/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.keys;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import oracle.pgx.api.beta.annotation.BetaApi;
import oracle.pgx.api.keys.ForeignKeyColumnDescriptor;
import oracle.pgx.api.keys.KeyColumnDescriptor;
import oracle.pgx.api.keys.KeyColumnDescriptorImpl;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.NameValidator;

@BetaApi
public class KeyUtils {
    public static final String DEFAULT_KEY_NAME = "";
    public static final String GENERATED_KEY_COLUMN_NAME = "generated_key_column_name";
    public static final String GENERATED_SOURCE_VERTEX_KEY_COLUMN_NAME = "generated_src_vertex_key_column_name";
    public static final String GENERATED_DESTINATION_VERTEX_KEY_COLUMN_NAME = "generated_src_vertex_key_column_name";
    private static final String GENERATED_REFERENCED_COLUMN_NAME = "generated_referenced_column";

    private KeyUtils() {
    }

    public static List<KeyColumnDescriptor> createKeyDescriptors(String keyColumnName, IdType keyColumnType) {
        return KeyUtils.createKeyDescriptors(Collections.singletonList(keyColumnName), Collections.singletonList(keyColumnType));
    }

    public static List<KeyColumnDescriptor> createKeyDescriptors(List<String> keyColumnNames, List<IdType> keyColumnTypes) {
        int numKeyColumns = keyColumnNames.size();
        assert (keyColumnTypes.size() == numKeyColumns);
        ArrayList<KeyColumnDescriptor> descriptors = new ArrayList<KeyColumnDescriptor>(numKeyColumns);
        for (int i = 0; i < numKeyColumns; ++i) {
            String name = keyColumnNames.get(i);
            if (name == null) {
                name = DEFAULT_KEY_NAME;
            }
            descriptors.add(new KeyColumnDescriptorImpl(name, keyColumnTypes.get(i)));
        }
        KeyUtils.validateKey(descriptors);
        return descriptors;
    }

    public static IdType getType(List<? extends KeyColumnDescriptor> keyColumns) {
        return KeyUtils.getSingleKeyColumn(keyColumns).getType();
    }

    public static IdType getTypeOrDefault(List<? extends KeyColumnDescriptor> keyColumns, IdType defaultType) {
        try {
            return KeyUtils.getType(keyColumns);
        }
        catch (IllegalArgumentException ex) {
            if (!keyColumns.isEmpty()) {
                return defaultType;
            }
            throw ex;
        }
    }

    public static <K> K getSingleKeyColumn(List<? extends K> keyColumns) {
        if (keyColumns.size() == 0) {
            throw new IllegalStateException(ErrorMessages.getMessage("COMPOSITE_KEYS_FAILED_TO_DETERMINE", new Object[0]));
        }
        if (keyColumns.size() > 1) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("COMPOSITE_KEYS_NOT_SUPPORTED_YET", new Object[0]));
        }
        return keyColumns.get(0);
    }

    public static <K> K getSingleKeyColumnOrNull(List<? extends K> keyColumns) {
        if (keyColumns.isEmpty()) {
            return null;
        }
        return KeyUtils.getSingleKeyColumn(keyColumns);
    }

    public static String getNameOrNull(KeyColumnDescriptor keyColumnDescriptor) {
        String name = keyColumnDescriptor == null ? null : keyColumnDescriptor.getName();
        return DEFAULT_KEY_NAME.equals(name) ? null : name;
    }

    public static String getNameOrNull(ForeignKeyColumnDescriptor foreignKeyColumnDescriptor) {
        return foreignKeyColumnDescriptor == null ? null : foreignKeyColumnDescriptor.getName();
    }

    public static String getForeignKeyColumnName(List<? extends ForeignKeyColumnDescriptor> foreignKeyColumns) {
        return KeyUtils.getSingleKeyColumn(foreignKeyColumns).getName();
    }

    public static void assertHasOneKeyColumnLegacy(int numKeyColumns) {
        if (numKeyColumns != 1) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("COMPOSITE_KEYS_NOT_SUPPORTED_LEGACY", new Object[0]));
        }
    }

    public static void validateKey(List<? extends KeyColumnDescriptor> keyColumns) {
        long numDistinctNames;
        for (KeyColumnDescriptor keyColumnDescriptor : keyColumns) {
            KeyUtils.validateKeyDescriptorNotNull(keyColumnDescriptor);
        }
        if (keyColumns.size() > 1 && (numDistinctNames = keyColumns.stream().map(KeyColumnDescriptor::getName).distinct().count()) < (long)keyColumns.size()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("KEY_COLUMN_NAMES_MUST_BE_UNIQUE", new Object[0]));
        }
    }

    public static void validateForeignKey(List<? extends ForeignKeyColumnDescriptor> foreignKeyColumns) {
        for (ForeignKeyColumnDescriptor foreignKeyColumnDescriptor : foreignKeyColumns) {
            ErrorMessages.requireNonNull(foreignKeyColumnDescriptor.getName(), "foreign key column name");
            NameValidator.validate(foreignKeyColumnDescriptor.getName());
            if (foreignKeyColumnDescriptor.getReferences() == null) continue;
            NameValidator.validate(foreignKeyColumnDescriptor.getReferences());
        }
        if (foreignKeyColumns.size() > 1 && foreignKeyColumns.stream().map(ForeignKeyColumnDescriptor::getReferences).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("FOREIGN_KEYS_REFERENCED_COLUMN_NOT_SET", new Object[0]));
        }
    }

    public static void validateForeignKeyToPrimaryKey(List<? extends ForeignKeyColumnDescriptor> foreignKeys, List<? extends KeyColumnDescriptor> primaryKeys) {
        int numKeys = primaryKeys.size();
        if (foreignKeys.size() != numKeys) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("FOREIGN_KEYS_UNEXPECTED_NUMBER", numKeys, foreignKeys.size()));
        }
        if (numKeys == 1 && foreignKeys.get(0).getReferences() == null) {
            return;
        }
        Map<String, Integer> keyToForeignKey = primaryKeys.stream().collect(Collectors.toMap(KeyColumnDescriptor::getName, ignored -> -1));
        for (int k = 0; k < numKeys; ++k) {
            ForeignKeyColumnDescriptor foreignKey = foreignKeys.get(k);
            Integer previousRefKey = keyToForeignKey.put(foreignKey.getReferences(), k);
            if (previousRefKey == null) {
                throw new IllegalArgumentException(ErrorMessages.getMessage("FOREIGN_KEY_REFERENCED_COLUMN_NOT_FOUND", foreignKey.getName(), foreignKey.getReferences()));
            }
            if (previousRefKey == -1) continue;
            throw new IllegalArgumentException(ErrorMessages.getMessage("FOREIGN_KEYS_REFERENCE_SAME_COLUMN", foreignKeys.get(previousRefKey).getName(), foreignKey.getName(), foreignKey.getReferences()));
        }
    }

    private static void validateKeyDescriptorNotNull(KeyColumnDescriptor keyDescriptor) {
        ErrorMessages.requireNonNull(keyDescriptor.getName(), "key column name");
        ErrorMessages.requireNonNull(keyDescriptor.getType(), "key column type");
    }

    public static ForeignKeyColumnDescriptor getForeignKeyColumnDescriptorOrDefault(List<? extends ForeignKeyColumnDescriptor> keyColumnDescriptors, String defaultName) {
        boolean isCompKey = keyColumnDescriptors.size() > 1;
        return isCompKey ? ForeignKeyColumnDescriptor.of(defaultName, GENERATED_REFERENCED_COLUMN_NAME) : KeyUtils.getSingleKeyColumn(keyColumnDescriptors);
    }

    public static KeyColumnDescriptor getKeyColumnDescriptorOrDefault(List<? extends KeyColumnDescriptor> keyColumns, String defaultName) {
        boolean isCompKey = keyColumns.size() > 1;
        return isCompKey ? KeyColumnDescriptor.of(defaultName, IdType.LONG) : KeyUtils.getSingleKeyColumn(keyColumns);
    }
}

