/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.stratego;

import io.usethesource.capsule.Map;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mb.nabl2.terms.stratego.StrategoBlob;
import mb.nabl2.terms.stratego.StrategoTerms;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.stratego.TermOrigin;
import org.metaborg.util.tuple.Tuple2;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.util.TermUtils;

public final class StrategoTermIndices {
    private static final String OP = "TermIndex";
    private static final int ARITY = 2;

    private StrategoTermIndices() {
    }

    public static IStrategoTerm index(IStrategoTerm term, String resource, ITermFactory termFactory) {
        return new Indexer(resource, termFactory, true, 1, null).index(term);
    }

    public static IStrategoTerm indexMore(IStrategoTerm term, String resource, int startIndex, ITermFactory termFactory) {
        return new Indexer(resource, termFactory, false, startIndex >= 1 ? startIndex : 1, null).index(term);
    }

    public static int findMaxIndex(IStrategoTerm term) {
        int maxId = StrategoTermIndices.get(term).map(TermIndex::getId).orElse(-1);
        for (IStrategoTerm subterm : term.getSubterms()) {
            maxId = Math.max(maxId, StrategoTermIndices.findMaxIndex(subterm));
        }
        return maxId;
    }

    public static Tuple2<IStrategoTerm, Map.Immutable<TermIndex, TermIndex>> reindex(IStrategoTerm term, String resource, int startIndex, ITermFactory termFactory) {
        Map.Transient mapping = Map.Transient.of();
        IndexerCallback callback = (_term, oldIndex, newIndex) -> {
            if (oldIndex != null) {
                mapping.__put((Object)oldIndex, (Object)newIndex);
            }
        };
        IStrategoTerm newTerm = new Indexer(resource, termFactory, true, startIndex >= 1 ? startIndex : 1, callback).index(term);
        return Tuple2.of(newTerm, mapping.freeze());
    }

    public static IStrategoTerm erase(IStrategoTerm term, ITermFactory termFactory) {
        return new Eraser(termFactory).erase(term);
    }

    public static Optional<TermIndex> get(IStrategoTerm term) {
        for (IStrategoTerm anno : term.getAnnotations()) {
            Optional<TermIndex> index = StrategoTermIndices.match(anno);
            if (!index.isPresent()) continue;
            return index;
        }
        return Optional.empty();
    }

    public static <T extends IStrategoTerm> T put(TermIndex index, T term, ITermFactory factory) {
        IStrategoTerm result = factory.annotateTerm(term, factory.makeListCons(StrategoTermIndices.build(index, factory), StrategoTermIndices.removeFromAnnoList(term.getAnnotations(), factory)));
        return (T)result;
    }

    public static <T extends IStrategoTerm> T remove(T term, ITermFactory factory) {
        IStrategoTerm result = factory.annotateTerm(term, StrategoTermIndices.removeFromAnnoList(term.getAnnotations(), factory));
        return (T)result;
    }

    public static IStrategoTerm build(TermIndex index, ITermFactory factory) {
        IStrategoConstructor ctor = factory.makeConstructor(OP, 2);
        IStrategoAppl indexTerm = factory.makeAppl(ctor, factory.makeString(index.getResource()), factory.makeInt(index.getId()));
        TermOrigin.get(index).ifPresent(o -> o.put(indexTerm));
        return indexTerm;
    }

    public static Optional<TermIndex> match(IStrategoTerm term) {
        if (!TermUtils.isAppl(term, OP, 2)) {
            return Optional.empty();
        }
        IStrategoTerm resourceTerm = term.getSubterm(0);
        IStrategoTerm idTerm = term.getSubterm(1);
        TermIndex index1 = TermIndex.of(TermUtils.toJavaString(resourceTerm), TermUtils.toJavaInt(idTerm));
        TermIndex index2 = TermOrigin.get(term).map(o -> o.put(index1)).orElse(index1);
        return Optional.of(index2);
    }

    private static IStrategoList removeFromAnnoList(IStrategoList list, ITermFactory factory) {
        ArrayList<IStrategoTerm> terms = new ArrayList<IStrategoTerm>(list.getAllSubterms().length);
        IStrategoTerm[] iStrategoTermArray = list.getAllSubterms();
        int n = iStrategoTermArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStrategoTerm term = iStrategoTermArray[n2];
            if (!StrategoTermIndices.match(term).isPresent()) {
                terms.add(term);
            }
            ++n2;
        }
        return factory.makeList(terms);
    }

    private static class Eraser {
        private final ITermFactory termFactory;

        Eraser(ITermFactory termFactory) {
            this.termFactory = termFactory;
        }

        private IStrategoTerm erase(IStrategoTerm term) {
            IStrategoTerm result = StrategoTerms.match(term, StrategoTerms.cases(appl -> this.termFactory.makeAppl(appl.getConstructor(), this.erase(appl.getSubterms()), appl.getAnnotations()), tuple -> this.termFactory.makeTuple(this.erase(tuple.getSubterms()), tuple.getAnnotations()), list -> this.erase((IStrategoList)list), integer -> this.termFactory.annotateTerm(this.termFactory.makeInt(integer.intValue()), integer.getAnnotations()), real -> this.termFactory.annotateTerm(this.termFactory.makeReal(real.realValue()), real.getAnnotations()), string -> this.termFactory.annotateTerm(this.termFactory.makeString(string.stringValue()), string.getAnnotations()), blob -> new StrategoBlob(blob.value()), plhdr -> this.termFactory.annotateTerm(this.termFactory.makePlaceholder(plhdr.getTemplate()), plhdr.getAnnotations())));
            this.termFactory.copyAttachments(term, result);
            result = StrategoTermIndices.remove(result, this.termFactory);
            assert (!StrategoTermIndices.get(result).isPresent());
            return result;
        }

        private IStrategoList erase(IStrategoList list) {
            IStrategoList result = list.isEmpty() ? this.termFactory.makeList(TermFactory.EMPTY_TERM_ARRAY, list.getAnnotations()) : this.termFactory.makeListCons(this.erase(list.head()), this.erase(list.tail()), list.getAnnotations());
            this.termFactory.copyAttachments(list, result);
            result = StrategoTermIndices.remove(result, this.termFactory);
            assert (!StrategoTermIndices.get(result).isPresent());
            return result;
        }

        private IStrategoTerm[] erase(List<IStrategoTerm> terms) {
            return (IStrategoTerm[])terms.stream().map(this::erase).toArray(IStrategoTerm[]::new);
        }
    }

    private static class Indexer {
        private final String resource;
        private final ITermFactory termFactory;
        private int nextId;
        private boolean overwrite;
        @Nullable
        private IndexerCallback callback;

        public Indexer(String resource, ITermFactory termFactory, boolean overwrite, int initialId, @Nullable IndexerCallback callback) {
            this.resource = resource;
            this.termFactory = termFactory;
            this.overwrite = overwrite;
            this.nextId = initialId;
            this.callback = callback;
        }

        public IStrategoTerm index(IStrategoTerm term) {
            IStrategoTerm result = StrategoTerms.match(term, StrategoTerms.cases(appl -> this.termFactory.makeAppl(appl.getConstructor(), this.index(appl.getSubterms()), appl.getAnnotations()), tuple -> this.termFactory.makeTuple(this.index(tuple.getSubterms()), tuple.getAnnotations()), list -> this.index((IStrategoList)list), integer -> this.termFactory.annotateTerm(this.termFactory.makeInt(integer.intValue()), integer.getAnnotations()), real -> this.termFactory.annotateTerm(this.termFactory.makeReal(real.realValue()), real.getAnnotations()), string -> this.termFactory.annotateTerm(this.termFactory.makeString(string.stringValue()), string.getAnnotations()), blob -> new StrategoBlob(blob.value()), plhdr -> this.termFactory.annotateTerm(this.termFactory.makePlaceholder(plhdr.getTemplate()), plhdr.getAnnotations())));
            TermIndex oldIndex = StrategoTermIndices.get(term).orElse(null);
            if (this.overwrite || oldIndex == null) {
                TermIndex newIndex = TermIndex.of(this.resource, this.nextId++);
                TermIndex newNewIndex = TermOrigin.get(term).map(o -> o.put(newIndex)).orElse(newIndex);
                result = StrategoTermIndices.put(newNewIndex, result, this.termFactory);
                if (this.callback != null) {
                    this.callback.onIndex(term, oldIndex, newNewIndex);
                }
            }
            this.termFactory.copyAttachments(term, result);
            return result;
        }

        private IStrategoList index(IStrategoList list) {
            IStrategoList result = list.isEmpty() ? this.termFactory.makeList(TermFactory.EMPTY_TERM_ARRAY, list.getAnnotations()) : this.termFactory.makeListCons(this.index(list.head()), this.index(list.tail()), list.getAnnotations());
            if (this.overwrite || !StrategoTermIndices.get(list).isPresent()) {
                TermIndex index1 = TermIndex.of(this.resource, this.nextId++);
                TermIndex index = TermOrigin.get(list).map(o -> o.put(index1)).orElse(index1);
                result = StrategoTermIndices.put(index, result, this.termFactory);
            }
            this.termFactory.copyAttachments(list, result);
            return result;
        }

        private IStrategoTerm[] index(List<IStrategoTerm> terms) {
            return (IStrategoTerm[])terms.stream().map(this::index).toArray(IStrategoTerm[]::new);
        }
    }

    private static interface IndexerCallback {
        public void onIndex(IStrategoTerm var1, @Nullable TermIndex var2, TermIndex var3);
    }
}

