/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20.reference;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import mb.scopegraph.oopsla20.INameResolution;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.reference.DataLeq;
import mb.scopegraph.oopsla20.reference.DataWF;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.oopsla20.reference.Env;
import mb.scopegraph.oopsla20.reference.IncompleteException;
import mb.scopegraph.oopsla20.reference.LabelOrder;
import mb.scopegraph.oopsla20.reference.LabelWF;
import mb.scopegraph.oopsla20.reference.ResolutionException;
import mb.scopegraph.oopsla20.terms.newPath.ResolutionPath;
import mb.scopegraph.oopsla20.terms.newPath.ScopePath;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Predicate2;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.tuple.Tuple2;

public class FastNameResolution<S, L, D>
implements INameResolution<S, L, D> {
    private final IScopeGraph<S, L, D> scopeGraph;
    private final EdgeOrData<L> dataLabel;
    private final Set.Immutable<EdgeOrData<L>> allLabels;
    private final LabelWF<L> labelWF;
    private final LabelOrder<L> labelOrder;
    private final DataWF<D> dataWF;
    private final DataLeq<D> dataEquiv;
    private final Predicate2<S, EdgeOrData<L>> isComplete;
    private final Map<Set.Immutable<EdgeOrData<L>>, Set.Immutable<EdgeOrData<L>>> maxCache = new HashMap<Set.Immutable<EdgeOrData<L>>, Set.Immutable<EdgeOrData<L>>>();
    private final Map<Tuple2<Set.Immutable<EdgeOrData<L>>, EdgeOrData<L>>, Set.Immutable<EdgeOrData<L>>> smallerCache = new HashMap<Tuple2<Set.Immutable<EdgeOrData<L>>, EdgeOrData<L>>, Set.Immutable<EdgeOrData<L>>>();

    public FastNameResolution(IScopeGraph<S, L, D> scopeGraph, Set<L> edgeLabels, LabelWF<L> labelWF, LabelOrder<L> labelOrder, DataWF<D> dataWF, DataLeq<D> dataEquiv, Predicate2<S, EdgeOrData<L>> isComplete) {
        this.scopeGraph = scopeGraph;
        this.dataLabel = EdgeOrData.data();
        this.allLabels = ((Set.Immutable)edgeLabels.stream().map(EdgeOrData::edge).collect(CapsuleCollectors.toSet())).__insert(this.dataLabel);
        this.labelWF = labelWF;
        this.labelOrder = labelOrder;
        this.dataWF = dataWF;
        this.dataEquiv = dataEquiv;
        this.isComplete = isComplete;
    }

    @Override
    public Env<S, L, D> resolve(S scope, ICancel cancel) throws ResolutionException, InterruptedException {
        return this.env(this.labelWF, new ScopePath(scope), Env.empty(), cancel);
    }

    private Env<S, L, D> env(LabelWF<L> re, ScopePath<S, L> path, Iterable<ResolutionPath<S, L, D>> specifics, ICancel cancel) throws ResolutionException, InterruptedException {
        return this.env_L(this.allLabels, re, path, specifics, cancel);
    }

    private Env<S, L, D> env_L(Set.Immutable<EdgeOrData<L>> L2, LabelWF<L> re, ScopePath<S, L> path, Iterable<ResolutionPath<S, L, D>> specifics, ICancel cancel) throws ResolutionException, InterruptedException {
        cancel.throwIfCancelled();
        Env.Builder env = Env.builder();
        Set.Immutable<EdgeOrData<L>> max_L = this.max(L2);
        for (EdgeOrData l : max_L) {
            Set.Immutable<EdgeOrData<L>> smaller = this.smaller(L2, l);
            Env<S, L, D> env1 = this.env_L(smaller, re, path, specifics, cancel);
            env.addAll(env1);
            if (!env1.isEmpty() && this.dataEquiv.alwaysTrue()) continue;
            Env<S, L, D> env2 = this.env_l(l, re, path, Iterables2.fromConcat(specifics, env1), cancel);
            env.addAll(env2);
        }
        return env.build();
    }

    private Env<S, L, D> env_l(EdgeOrData<L> l, LabelWF<L> re, ScopePath<S, L> path, Iterable<ResolutionPath<S, L, D>> specifics, ICancel cancel) throws ResolutionException, InterruptedException {
        return l.matchInResolution(() -> this.env_data(re, path, specifics), lbl -> this.env_edges(lbl, re, path, specifics, cancel));
    }

    private Env<S, L, D> env_data(LabelWF<L> re, ScopePath<S, L> path, Iterable<ResolutionPath<S, L, D>> specifics) throws ResolutionException, InterruptedException {
        if (!re.accepting()) {
            return Env.empty();
        }
        if (!this.isComplete.test(path.getTarget(), this.dataLabel)) {
            throw new IncompleteException(path.getTarget(), this.dataLabel);
        }
        Object datum = this.getData(re, path).orElse(null);
        if (datum == null || !this.dataWF.wf(datum) || this.isShadowed(datum, specifics)) {
            return Env.empty();
        }
        return Env.of(path.resolve(datum));
    }

    private Env<S, L, D> env_edges(L l, LabelWF<L> re, ScopePath<S, L> path, Iterable<ResolutionPath<S, L, D>> specifics, ICancel cancel) throws ResolutionException, InterruptedException {
        Optional<LabelWF<L>> newRe = re.step(l);
        if (!newRe.isPresent()) {
            return Env.empty();
        }
        re = newRe.get();
        EdgeOrData<L> edgeLabel = EdgeOrData.edge(l);
        if (!this.isComplete.test(path.getTarget(), edgeLabel)) {
            throw new IncompleteException(path.getTarget(), edgeLabel);
        }
        Env.Builder env = Env.builder();
        for (S nextScope : this.getEdges(re, path, l)) {
            Optional<ScopePath<S, L>> p = path.step(l, nextScope);
            if (!p.isPresent()) continue;
            env.addAll(this.env(re, p.get(), specifics, cancel));
        }
        return env.build();
    }

    private boolean isShadowed(D datum, Iterable<ResolutionPath<S, L, D>> specifics) throws ResolutionException, InterruptedException {
        for (ResolutionPath<S, L, D> p : specifics) {
            if (!this.dataEquiv.leq(p.getDatum(), datum)) continue;
            return true;
        }
        return false;
    }

    protected Optional<D> getData(LabelWF<L> re, ScopePath<S, L> path) {
        return this.scopeGraph.getData(path.getTarget());
    }

    protected Iterable<S> getEdges(LabelWF<L> re, ScopePath<S, L> path, L l) {
        return this.scopeGraph.getEdges(path.getTarget(), l);
    }

    private Set.Immutable<EdgeOrData<L>> max(Set.Immutable<EdgeOrData<L>> L2) throws ResolutionException, InterruptedException {
        Set.Immutable<EdgeOrData<L>> max2 = this.maxCache.get(L2);
        if (max2 == null) {
            max2 = this.computeMax(L2);
            this.maxCache.put(L2, max2);
        }
        return max2;
    }

    private Set.Immutable<EdgeOrData<L>> computeMax(Set.Immutable<EdgeOrData<L>> L2) throws ResolutionException, InterruptedException {
        Set.Transient max2 = CapsuleUtil.transientSet();
        block0: for (EdgeOrData l1 : L2) {
            for (EdgeOrData l2 : L2) {
                if (this.labelOrder.lt(l1, l2)) continue block0;
            }
            max2.__insert((Object)l1);
        }
        return max2.freeze();
    }

    private Set.Immutable<EdgeOrData<L>> smaller(Set.Immutable<EdgeOrData<L>> L2, EdgeOrData<L> l1) throws ResolutionException, InterruptedException {
        Tuple2<Set.Immutable<EdgeOrData<L>>, EdgeOrData<L>> key = Tuple2.of(L2, l1);
        Set.Immutable<EdgeOrData<L>> smaller = this.smallerCache.get(key);
        if (smaller == null) {
            smaller = this.computeSmaller(L2, l1);
            this.smallerCache.put(key, smaller);
        }
        return smaller;
    }

    private Set.Immutable<EdgeOrData<L>> computeSmaller(Set.Immutable<EdgeOrData<L>> L2, EdgeOrData<L> l1) throws ResolutionException, InterruptedException {
        Set.Transient smaller = CapsuleUtil.transientSet();
        for (EdgeOrData l2 : L2) {
            if (!this.labelOrder.lt(l2, l1)) continue;
            smaller.__insert((Object)l2);
        }
        return smaller.freeze();
    }

    public static <S, L, D> Builder<S, L, D> builder() {
        return new Builder();
    }

    public static class Builder<S, L, D>
    implements INameResolution.Builder<S, L, D> {
        private LabelWF<L> labelWF = LabelWF.ANY();
        private LabelOrder<L> labelOrder = LabelOrder.NONE();
        private DataWF<D> dataWF = DataWF.ANY();
        private DataLeq<D> dataEquiv = DataLeq.ALL();
        private Predicate2<S, EdgeOrData<L>> isComplete = (s, l) -> true;

        @Override
        public Builder<S, L, D> withLabelWF(LabelWF<L> labelWF) {
            this.labelWF = labelWF;
            return this;
        }

        @Override
        public Builder<S, L, D> withLabelOrder(LabelOrder<L> labelOrder) {
            this.labelOrder = labelOrder;
            return this;
        }

        @Override
        public Builder<S, L, D> withDataWF(DataWF<D> dataWF) {
            this.dataWF = dataWF;
            return this;
        }

        @Override
        public Builder<S, L, D> withDataEquiv(DataLeq<D> dataEquiv) {
            this.dataEquiv = dataEquiv;
            return this;
        }

        @Override
        public Builder<S, L, D> withIsComplete(Predicate2<S, EdgeOrData<L>> isComplete) {
            this.isComplete = isComplete;
            return this;
        }

        @Override
        public FastNameResolution<S, L, D> build(IScopeGraph<S, L, D> scopeGraph, Set<L> edgeLabels) {
            return new FastNameResolution<S, L, D>(scopeGraph, edgeLabels, this.labelWF, this.labelOrder, this.dataWF, this.dataEquiv, this.isComplete);
        }
    }
}

