/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.solver.IConstraint;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action1;

public final class CConj
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IConstraint left;
    private final IConstraint right;
    @Nullable
    private final IConstraint cause;
    @Nullable
    private final CConj origin;
    private final int hashCode = this.computeHashCode();

    public CConj(IConstraint left, IConstraint right) {
        this(left, right, null, null);
    }

    public CConj(IConstraint left, IConstraint right, @Nullable IConstraint cause) {
        this(left, right, cause, null);
    }

    private CConj(IConstraint left, IConstraint right, @Nullable IConstraint cause, @Nullable CConj origin) {
        this.left = left;
        this.right = right;
        this.cause = cause;
        this.origin = origin;
    }

    public IConstraint left() {
        return this.left;
    }

    public IConstraint right() {
        return this.right;
    }

    public CConj withArguments(IConstraint left, IConstraint right) {
        if (this.left == left && this.right == right) {
            return this;
        }
        return new CConj(left, right, this.cause, this.origin);
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CConj withCause(@Nullable IConstraint cause) {
        if (this.cause == cause) {
            return this;
        }
        return new CConj(this.left, this.right, cause, this.origin);
    }

    @Override
    @Nullable
    public CConj origin() {
        return this.origin;
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseConj(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseConj(this);
    }

    @Override
    public Set.Immutable<ITermVar> getVars() {
        return Set.Immutable.union(this.left.getVars(), this.right.getVars());
    }

    @Override
    public Set.Immutable<ITermVar> freeVars() {
        Set.Transient freeVars = CapsuleUtil.transientSet();
        this.doVisitFreeVars(arg_0 -> freeVars.__insert(arg_0));
        return freeVars.freeze();
    }

    @Override
    public void visitFreeVars(Action1<ITermVar> onFreeVar) {
        this.doVisitFreeVars(onFreeVar);
    }

    private void doVisitFreeVars(Action1<ITermVar> onFreeVar) {
        this.left.visitFreeVars(onFreeVar);
        this.right.visitFreeVars(onFreeVar);
    }

    @Override
    public CConj apply(ISubstitution.Immutable subst) {
        return this.apply(subst, false);
    }

    @Override
    public CConj unsafeApply(ISubstitution.Immutable subst) {
        return this.unsafeApply(subst, false);
    }

    @Override
    public CConj apply(IRenaming subst) {
        return this.apply(subst, false);
    }

    @Override
    public CConj apply(ISubstitution.Immutable subst, boolean trackOrigin) {
        return new CConj(this.left.apply(subst, trackOrigin), this.right.apply(subst, trackOrigin), this.cause, this.origin == null && trackOrigin ? this : this.origin);
    }

    @Override
    public CConj unsafeApply(ISubstitution.Immutable subst, boolean trackOrigin) {
        return new CConj(this.left.unsafeApply(subst, trackOrigin), this.right.unsafeApply(subst, trackOrigin), this.cause, this.origin == null && trackOrigin ? this : this.origin);
    }

    @Override
    public CConj apply(IRenaming subst, boolean trackOrigin) {
        return new CConj(this.left.apply(subst, trackOrigin), this.right.apply(subst, trackOrigin), this.cause, this.origin == null && trackOrigin ? this : this.origin);
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.left.toString(termToString));
        sb.append(", ");
        sb.append(this.right.toString(termToString));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CConj that = (CConj)o;
        return this.hashCode == that.hashCode && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right) && Objects.equals(this.cause, that.cause) && Objects.equals(this.origin, that.origin);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        return Objects.hash(this.left, this.right, this.cause, this.origin);
    }
}

