/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import jakarta.inject.Inject;
import mb.nabl2.terms.stratego.StrategoBlob;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.oopsla20.reference.RelationLabelOrder;
import mb.scopegraph.relations.IRelation;
import mb.scopegraph.relations.RelationDescription;
import mb.scopegraph.relations.RelationException;
import mb.scopegraph.relations.impl.Relation;
import mb.statix.spoofax.LabelUtils;
import org.metaborg.util.tuple.Tuple2;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

public class STX_ords_to_relation
extends AbstractPrimitive {
    @Inject
    public STX_ords_to_relation() {
        super(STX_ords_to_relation.class.getSimpleName(), 0, 1);
    }

    @Override
    public boolean call(IContext context, Strategy[] svars, IStrategoTerm[] tvars) {
        IStrategoTerm labelPairs = context.current();
        IStrategoTerm relation = tvars[0];
        IRelation.Transient<EdgeOrData<IStrategoTerm>> order = Relation.Transient.of(RelationDescription.STRICT_PARTIAL_ORDER);
        if (!TermUtils.isList(labelPairs)) {
            throw new IllegalArgumentException("Expected list with label pairs, got " + labelPairs);
        }
        for (IStrategoTerm labelPair : labelPairs) {
            Tuple2<IStrategoTerm, IStrategoTerm> lbls = LabelUtils.parseLabelPair(labelPair);
            IStrategoTerm left = LabelUtils.normalizeLabel(lbls._1(), relation);
            IStrategoTerm right = LabelUtils.normalizeLabel(lbls._2(), relation);
            try {
                order.add(EdgeOrData.edge(left), EdgeOrData.edge(right));
            }
            catch (RelationException e) {
                throw new IllegalArgumentException("Relation order not strictly partial.", e);
            }
        }
        StrategoBlob result = new StrategoBlob(new RelationLabelOrder(order.freeze()));
        context.setCurrent(result);
        return true;
    }
}

