/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.IIntTerm;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.IStringTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.Attachments;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.Pattern;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.matching.TermPattern;
import mb.nabl2.terms.matching.Transform;
import mb.nabl2.terms.substitution.FreshVars;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.path.IResolutionPath;
import mb.scopegraph.oopsla20.path.IScopePath;
import mb.scopegraph.oopsla20.path.IStep;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.oopsla20.reference.ScopeGraph;
import mb.scopegraph.regexp.IRegExp;
import mb.scopegraph.regexp.IRegExpBuilder;
import mb.scopegraph.regexp.impl.RegExpBuilder;
import mb.scopegraph.relations.IRelation;
import mb.scopegraph.relations.RelationDescription;
import mb.scopegraph.relations.RelationException;
import mb.scopegraph.relations.impl.Relation;
import mb.scopegraph.resolution.RCExp;
import mb.scopegraph.resolution.RExp;
import mb.scopegraph.resolution.RMerge;
import mb.scopegraph.resolution.RResolve;
import mb.scopegraph.resolution.RShadow;
import mb.scopegraph.resolution.RStep;
import mb.scopegraph.resolution.RSubEnv;
import mb.scopegraph.resolution.RVar;
import mb.scopegraph.resolution.State;
import mb.scopegraph.resolution.StateMachine;
import mb.scopegraph.schema.Bound;
import mb.scopegraph.schema.Cardinality;
import mb.scopegraph.schema.Schema;
import mb.scopegraph.schema.SchemaDecl;
import mb.scopegraph.schema.SchemaEdge;
import mb.statix.arithmetic.ArithExpr;
import mb.statix.arithmetic.ArithTerms;
import mb.statix.arithmetic.ArithTest;
import mb.statix.constraints.CArith;
import mb.statix.constraints.CAstId;
import mb.statix.constraints.CAstProperty;
import mb.statix.constraints.CCompiledQuery;
import mb.statix.constraints.CConj;
import mb.statix.constraints.CEqual;
import mb.statix.constraints.CExists;
import mb.statix.constraints.CFalse;
import mb.statix.constraints.CInequal;
import mb.statix.constraints.CNew;
import mb.statix.constraints.CResolveQuery;
import mb.statix.constraints.CTellEdge;
import mb.statix.constraints.CTrue;
import mb.statix.constraints.CTry;
import mb.statix.constraints.CUser;
import mb.statix.constraints.Constraints;
import mb.statix.constraints.messages.IMessage;
import mb.statix.constraints.messages.IMessagePart;
import mb.statix.constraints.messages.Message;
import mb.statix.constraints.messages.MessageKind;
import mb.statix.constraints.messages.TermPart;
import mb.statix.constraints.messages.TextPart;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.IConstraint;
import mb.statix.solver.query.QueryFilter;
import mb.statix.solver.query.QueryMin;
import mb.statix.solver.query.QueryProject;
import mb.statix.spec.BaseRuleSet;
import mb.statix.spec.Rule;
import mb.statix.spec.RuleName;
import mb.statix.spec.RuleSet;
import mb.statix.spec.Spec;
import org.metaborg.util.Ref;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.collection.Sets;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.optionals.Optionals;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.tuple.Tuple3;

public class StatixTerms {
    private static final ILogger log = LoggerUtils.logger(StatixTerms.class);
    public static final String SCOPE_OP = "Scope";
    public static final String TERMINDEX_OP = "TermIndex";
    public static final String OCCURRENCE_OP = "StxOccurrence";
    public static final String PATH_EMPTY_OP = "PathEmpty";
    public static final String PATH_STEP_OP = "PathStep";
    public static final String WITHID_OP = "WithId";
    public static final String NOID_OP = "NoId";
    public static final String SCOPEGRAPH_OP = "ScopeGraph";
    public static final String EOP_OP = "EOP";
    public static final String STATE_OP = "State";
    public static final String STEP_OP = "Step";
    public static final String RESOLVE_OP = "Resolve";
    public static final String SUBENV_OP = "SubEnv";
    public static final String MERGE_OP = "Merge";
    public static final String SHADOW_OP = "Shadow";
    public static final String CEXP_OP = "CExp";
    public static final String RVAR_OP = "RVar";

    public static TermMatch.IMatcher<Spec> spec() {
        return TermMatch.M.appl5("Spec", TermMatch.M.req(StatixTerms.labels()), TermMatch.M.req(StatixTerms.labels()), TermMatch.M.term(), StatixTerms.rules(), TermMatch.M.req(StatixTerms.scopeExtensions()), (t, edgeLabels, dataLabels, noRelationLabel, rules, ext) -> Spec.of(rules, (Set.Immutable<ITerm>)edgeLabels, (Set.Immutable<ITerm>)dataLabels, (SetMultimap.Immutable<String, Tuple2<Integer, ITerm>>)ext).precomputeCriticalEdges());
    }

    public static TermMatch.IMatcher<RuleSet> rules() {
        return TermMatch.M.listElems(TermMatch.M.req(StatixTerms.rule())).map(BaseRuleSet::of);
    }

    public static TermMatch.IMatcher<Rule> rule() {
        return TermMatch.M.cases(TermMatch.M.appl3("Rule", TermMatch.M.req("Rulename", StatixTerms.ruleName()), TermMatch.M.req("RuleHead", StatixTerms.head()), TermMatch.M.req("Constraint", StatixTerms.constraint()), (r, n, h, bc) -> Rule.of((String)h._1(), n, (ImList.Immutable)h._2(), bc).withLabel((RuleName)n)), TermMatch.M.appl4("Rule", TermMatch.M.req("Rulename", StatixTerms.ruleName()), TermMatch.M.req("RuleHead", StatixTerms.head()), TermMatch.M.listElems(TermMatch.M.req("VarTerm", StatixTerms.varTerm())), TermMatch.M.req("Constraint", StatixTerms.constraint()), (r, n, h, bvs, bc) -> {
            log.warn("Rules with explicit local variables are deprecated.");
            return Rule.of((String)h._1(), n, (ImList.Immutable)h._2(), new CExists((Iterable<ITermVar>)bvs, (IConstraint)bc)).withLabel((RuleName)n);
        }));
    }

    public static TermMatch.IMatcher<RuleName> ruleName() {
        return TermMatch.M.cases(TermMatch.M.appl1("Name", TermMatch.M.stringValue(), (t, n) -> RuleName.of(n)));
    }

    public static TermMatch.IMatcher<Tuple2<String, ImList.Immutable<Pattern>>> head() {
        return TermMatch.M.appl2("C", StatixTerms.constraintName(), TermMatch.M.listElems(StatixTerms.pattern()), (h, name, patterns) -> Tuple2.of(name, patterns));
    }

    public static TermMatch.IMatcher<IConstraint> constraint() {
        return (t, u) -> TermMatch.M.casesFix(m -> Iterables2.from(TermMatch.M.appl4("CArith", ArithTerms.matchExpr(), ArithTerms.matchTest(), ArithTerms.matchExpr(), StatixTerms.message(), (c, ae1, op, ae2, msg) -> new CArith((ArithExpr)ae1, (ArithTest)op, (ArithExpr)ae2, msg.orElse(null))), TermMatch.M.appl2("CAstId", StatixTerms.term(), StatixTerms.term(), (c, t1, t2) -> new CAstId((ITerm)t1, (ITerm)t2)), TermMatch.M.appl4("CAstProperty", StatixTerms.term(), StatixTerms.label(), StatixTerms.propertyOp(), StatixTerms.term(), (c, idTerm, property, op, valueTerm) -> new CAstProperty((ITerm)idTerm, (ITerm)property, (CAstProperty.Op)((Object)((Object)((Object)op))), (ITerm)valueTerm)), TermMatch.M.appl2("CConj", m, m, (c, c1, c2) -> new CConj((IConstraint)c1, (IConstraint)c2)), TermMatch.M.appl3("CEqual", StatixTerms.term(), StatixTerms.term(), StatixTerms.message(), (c, t1, t2, msg) -> new CEqual((ITerm)t1, (ITerm)t2, msg.orElse(null))), TermMatch.M.appl2("CExists", TermMatch.M.listElems(StatixTerms.varTerm()), StatixTerms.constraint(), (c, vs, body) -> new CExists((Iterable<ITermVar>)vs, (IConstraint)body)), TermMatch.M.appl1("CFalse", StatixTerms.message(), (c, msg) -> new CFalse(msg.orElse(null))), TermMatch.M.appl3("CInequal", StatixTerms.term(), StatixTerms.term(), StatixTerms.message(), (c, t1, t2, msg) -> new CInequal((Iterable<ITermVar>)CapsuleUtil.immutableSet(), (ITerm)t1, (ITerm)t2, msg.orElse(null))), TermMatch.M.appl1("CNew", TermMatch.M.listElems(StatixTerms.term()), (c, ts) -> Constraints.conjoin(ts.stream().map(s -> new CNew((ITerm)s, (ITerm)s)).collect(Collectors.toList()))), StatixTerms.resolveQuery(), TermMatch.M.appl3("CPreCompiledQuery", StatixTerms.resolveQuery(), StatixTerms.states(), TermMatch.M.stringValue(), (c, query, states, initial) -> {
            State initialState = (State)states.get(initial);
            if (initialState == null) {
                throw new IllegalStateException("Invalid initial state: " + initial);
            }
            StateMachine<ITerm> stateMachine = new StateMachine<ITerm>((Map.Immutable<String, State<ITerm>>)states, initialState);
            return new CCompiledQuery(query.filter(), query.min(), query.project(), query.scopeTerm(), query.resultTerm(), query.message().orElse(null), stateMachine);
        }), TermMatch.M.appl3("CTellEdge", StatixTerms.term(), StatixTerms.label(), StatixTerms.term(), (c, sourceScope, label, targetScope) -> new CTellEdge((ITerm)sourceScope, (ITerm)label, (ITerm)targetScope)), TermMatch.M.appl3("CTellRel", StatixTerms.label(), TermMatch.M.listElems(StatixTerms.term()), StatixTerms.term(), (c, rel, args, scope) -> {
            FreshVars f = new FreshVars(args.stream().flatMap(a -> a.getVars().stream()).collect(Collectors.toList()));
            ITermVar d = f.fresh("d");
            return Constraints.exists(CapsuleUtil.immutableSet(d), Constraints.conjoin(Iterables2.from(new CNew(d, TermBuild.B.newTuple((Collection<? extends ITerm>)args, c.getAttachments())), new CTellEdge((ITerm)scope, (ITerm)rel, d))));
        }), TermMatch.M.appl0("CTrue", c -> new CTrue()), TermMatch.M.appl2("CTry", StatixTerms.constraint(), StatixTerms.message(), (c, body, msg) -> new CTry((IConstraint)body, msg.orElse(null))), TermMatch.M.appl3("C", StatixTerms.constraintName(), TermMatch.M.listElems(StatixTerms.term()), StatixTerms.message(), (c, name, args, msg) -> new CUser((String)name, (Iterable<? extends ITerm>)args, msg.orElse(null))))).match(t, u);
    }

    public static TermMatch.IMatcher<CResolveQuery> resolveQuery() {
        return (t, u) -> TermMatch.M.cases(TermMatch.M.appl6("CResolveQuery", TermMatch.M.term(), TermMatch.M.term(), TermMatch.M.term(), StatixTerms.term(), StatixTerms.term(), StatixTerms.message(), (c, rel, filterTerm, minTerm, scope, result, msg) -> {
            Optional<QueryFilter> maybeFilter = StatixTerms.queryFilter(rel).match((ITerm)filterTerm, u);
            Optional<QueryMin> maybeMin = StatixTerms.queryMin(rel).match((ITerm)minTerm, u);
            return Optionals.lift(maybeFilter, maybeMin, (filter, min2) -> new CResolveQuery((QueryFilter)filter, (QueryMin)min2, QueryProject.FULL, (ITerm)scope, (ITerm)result, msg.orElse(null)));
        }), TermMatch.M.appl("CResolveQuery", c -> {
            if (c.getArgs().size() != 7) {
                return Optional.empty();
            }
            ITerm rel = c.getArgs().get(0);
            ITerm filterTerm = c.getArgs().get(1);
            ITerm minTerm = c.getArgs().get(2);
            ITerm projectTerm = c.getArgs().get(3);
            Optional<ITerm> maybeScope = StatixTerms.term().match(c.getArgs().get(4), u);
            Optional<ITerm> maybeResult = StatixTerms.term().match(c.getArgs().get(5), u);
            Optional<Optional<IMessage>> maybeMsg = StatixTerms.message().match(c.getArgs().get(6), u);
            Optional<QueryFilter> maybeFilter = StatixTerms.queryFilter(rel).match(filterTerm, u);
            Optional<QueryMin> maybeMin = StatixTerms.queryMin(rel).match(minTerm, u);
            Optional<QueryProject> maybeProject = StatixTerms.queryProject().match(projectTerm, u);
            return Optionals.lift(maybeFilter, maybeMin, maybeProject, maybeScope, maybeResult, maybeMsg, (filter, min2, project, scope, result, msg) -> new CResolveQuery((QueryFilter)filter, (QueryMin)min2, (QueryProject)project, (ITerm)scope, (ITerm)result, msg.orElse(null)));
        })).flatMap(o -> o).match(t, u);
    }

    public static TermMatch.IMatcher<Map.Immutable<String, State<ITerm>>> states() {
        return TermMatch.M.listElems(StatixTerms.state()).map(states -> {
            Map.Transient mapBuilder = CapsuleUtil.transientMap();
            for (Tuple2 state : states) {
                mapBuilder.__put((Object)((String)state._1()), (Object)((State)state._2()));
            }
            return mapBuilder.freeze();
        });
    }

    public static TermMatch.IMatcher<Tuple2<String, State<ITerm>>> state() {
        return TermMatch.M.appl3(STATE_OP, TermMatch.M.stringValue(), TermMatch.M.listElems(StatixTerms.step()), StatixTerms.rvar(), (appl, name, steps, var) -> {
            ImList.Immutable ss = steps.stream().map(Tuple3::_1).collect(ImList.Immutable.toImmutableList());
            boolean accepting = steps.stream().anyMatch(Tuple3::_2);
            Stream<Tuple2> transitionStream = steps.stream().map(Tuple3::_3).filter(Optional::isPresent).map(Optional::get);
            Map.Immutable<ITerm, String> transitions = CapsuleUtil.collectToMap(transitionStream, Tuple2::_1, Tuple2::_2, (v1, v2) -> {
                if (!v1.equals(v2)) {
                    throw new IllegalArgumentException("Conflicting states " + v1 + " and " + v2 + ".");
                }
                return v1;
            });
            return Tuple2.of(name, new State<ITerm>(ss, (RVar)var, accepting, transitions));
        });
    }

    public static TermMatch.IMatcher<Tuple3<RStep<ITerm>, Boolean, Optional<Tuple2<ITerm, String>>>> step() {
        return TermMatch.M.appl2(STEP_OP, StatixTerms.rvar(), StatixTerms.rexp(), (appl, var, exp) -> Tuple3.of(new RStep((RVar)var, (RExp)exp._1()), (Boolean)exp._2(), (Optional)exp._3()));
    }

    public static TermMatch.IMatcher<Tuple3<RExp<ITerm>, Boolean, Optional<Tuple2<ITerm, String>>>> rexp() {
        return TermMatch.M.casesFix(m -> Iterables2.from(TermMatch.M.appl0(RESOLVE_OP, appl -> Tuple3.of(RResolve.of(), true, Optional.empty())), TermMatch.M.appl2(SUBENV_OP, StatixTerms.label(), TermMatch.M.stringValue(), (appl, lbl, state) -> Tuple3.of(new RSubEnv<ITerm>((ITerm)lbl, (String)state), false, Optional.of(Tuple2.of(lbl, state)))), TermMatch.M.appl1(MERGE_OP, TermMatch.M.listElems(StatixTerms.rvar()), (appl, envs) -> Tuple3.of(new RMerge((Iterable<RVar>)envs), false, Optional.empty())), TermMatch.M.appl2(SHADOW_OP, StatixTerms.rvar(), StatixTerms.rvar(), (appl, left, right) -> Tuple3.of(new RShadow((RVar)left, (RVar)right), false, Optional.empty())), TermMatch.M.appl2(CEXP_OP, StatixTerms.rvar(), m, (appl, env, exp) -> Tuple3.of(new RCExp((RVar)env, (RExp)exp._1()), (Boolean)exp._2(), (Optional)exp._3()))));
    }

    public static TermMatch.IMatcher<RVar> rvar() {
        return TermMatch.M.appl1(RVAR_OP, TermMatch.M.stringValue(), (appl, name) -> new RVar((String)name));
    }

    private static TermMatch.IMatcher<String> constraintName() {
        return TermMatch.M.stringValue();
    }

    public static TermMatch.IMatcher<QueryFilter> queryFilter(ITerm rel) {
        RegExpBuilder<ITerm> builder = new RegExpBuilder<ITerm>();
        TermMatch.IMatcher<IRegExp<ITerm>> reMatcher = StatixTerms.labelRE(builder);
        if (!StatixTerms.isEOP(rel)) {
            reMatcher = reMatcher.map(re -> (IRegExp)builder.concat((IRegExp<ITerm>)re, (IRegExp<ITerm>)((IRegExp)builder.symbol(rel))));
        }
        return TermMatch.M.appl2("Filter", reMatcher, StatixTerms.hoconstraint(), (f, wf, dataConstraint) -> new QueryFilter((IRegExp<ITerm>)wf, (Rule)dataConstraint));
    }

    public static TermMatch.IMatcher<QueryMin> queryMin(ITerm rel) {
        TermMatch.IMatcher<IRelation.Immutable<EdgeOrData<ITerm>>> ltMatcher = StatixTerms.labelLt();
        if (!StatixTerms.isEOP(rel)) {
            ltMatcher = ltMatcher.map(lt2 -> {
                IRelation.Transient newLt = Relation.Transient.of(lt2.getDescription());
                lt2.stream().forEach(ls -> {
                    EdgeOrData newL1 = ((EdgeOrData)ls._1()).match(() -> EdgeOrData.edge(rel), EdgeOrData::edge);
                    EdgeOrData newL2 = ((EdgeOrData)ls._2()).match(() -> EdgeOrData.edge(rel), EdgeOrData::edge);
                    try {
                        newLt.add(newL1, newL2);
                    }
                    catch (RelationException e) {
                        throw new IllegalStateException();
                    }
                });
                return newLt.freeze();
            });
        }
        return TermMatch.M.appl2("Min", ltMatcher, StatixTerms.hoconstraint(), (m, ord, dataConstraint) -> new QueryMin((IRelation.Immutable<EdgeOrData<ITerm>>)ord, (Rule)dataConstraint));
    }

    private static TermMatch.IMatcher<QueryProject> queryProject() {
        return TermMatch.M.appl1("Project", TermMatch.M.cases(TermMatch.M.appl0("PFull", appl -> QueryProject.FULL), TermMatch.M.appl0("PTargetData", appl -> QueryProject.TARGET_DATA), TermMatch.M.appl0("PData", appl -> QueryProject.DATA)), (appl, project) -> project);
    }

    private static boolean isEOP(ITerm label) {
        return TermMatch.M.appl0(EOP_OP).match(label).isPresent();
    }

    public static TermMatch.IMatcher<Rule> hoconstraint() {
        return TermMatch.M.cases(TermMatch.M.appl2("LLam", TermMatch.M.listElems(StatixTerms.pattern()), StatixTerms.constraint(), (t, ps, c) -> Rule.of("", RuleName.empty(), ps, c)), TermMatch.M.appl3("LLam", TermMatch.M.listElems(StatixTerms.pattern()), TermMatch.M.listElems(StatixTerms.varTerm()), StatixTerms.constraint(), (t, ps, vs, c) -> {
            log.warn("Lambdas with explicit local variables are deprecated.");
            return Rule.of("", RuleName.empty(), ps, new CExists((Iterable<ITermVar>)vs, (IConstraint)c));
        }));
    }

    public static TermMatch.IMatcher<SetMultimap.Immutable<String, Tuple2<Integer, ITerm>>> scopeExtensions() {
        return TermMatch.M.listElems(StatixTerms.scopeExtension(), (t, exts) -> {
            SetMultimap.Transient extmap = SetMultimap.Transient.of();
            exts.forEach(ext -> {
                Boolean bl = ext.apply((arg_0, arg_1) -> ((SetMultimap.Transient)extmap).__insert(arg_0, arg_1));
            });
            return extmap.freeze();
        });
    }

    public static TermMatch.IMatcher<Tuple2<String, Tuple2<Integer, ITerm>>> scopeExtension() {
        return TermMatch.M.tuple3(TermMatch.M.stringValue(), TermMatch.M.integerValue(), TermMatch.M.term(), (t, c, i, lbl) -> Tuple2.of(c, Tuple2.of(i - 1, lbl)));
    }

    public static TermMatch.IMatcher<Set.Immutable<ITerm>> labels() {
        return TermMatch.M.listElems(StatixTerms.label()).map(CapsuleUtil::toSet);
    }

    public static TermMatch.IMatcher<ITerm> label() {
        return TermMatch.M.term();
    }

    private static TermMatch.IMatcher<IRegExp<ITerm>> labelRE(IRegExpBuilder<ITerm> builder) {
        return TermMatch.M.casesFix(m -> Iterables2.from(TermMatch.M.appl0("Empty", t -> (IRegExp)builder.emptySet()), TermMatch.M.appl0("Epsilon", t -> (IRegExp)builder.emptyString()), TermMatch.M.appl1("Closure", m, (t, re) -> (IRegExp)builder.closure((IRegExp<ITerm>)re)), TermMatch.M.appl1("Neg", m, (t, re) -> (IRegExp)builder.complement((IRegExp<ITerm>)re)), TermMatch.M.appl2("Concat", m, m, (t, re1, re2) -> (IRegExp)builder.concat((IRegExp<ITerm>)re1, (IRegExp<ITerm>)re2)), TermMatch.M.appl2("And", m, m, (t, re1, re2) -> (IRegExp)builder.and((IRegExp<ITerm>)re1, (IRegExp<ITerm>)re2)), TermMatch.M.appl2("Or", m, m, (t, re1, re2) -> (IRegExp)builder.or((IRegExp<ITerm>)re1, (IRegExp<ITerm>)re2)), StatixTerms.label().map(l -> (IRegExp)builder.symbol((ITerm)l))));
    }

    public static TermMatch.IMatcher<IRelation.Immutable<EdgeOrData<ITerm>>> labelLt() {
        return TermMatch.M.listElems(StatixTerms.labelPair(), (t, ps) -> {
            IRelation.Transient<EdgeOrData> order = Relation.Transient.of(RelationDescription.STRICT_PARTIAL_ORDER);
            for (Tuple2 p : ps) {
                try {
                    order.add((EdgeOrData)p._1(), (EdgeOrData)p._2());
                }
                catch (RelationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return order.freeze();
        });
    }

    public static TermMatch.IMatcher<Tuple2<EdgeOrData<ITerm>, EdgeOrData<ITerm>>> labelPair() {
        return TermMatch.M.appl2("LabelPair", StatixTerms.label(), StatixTerms.label(), (t, l1, l2) -> {
            EdgeOrData<Object> _l1 = StatixTerms.isEOP(l1) ? EdgeOrData.data() : EdgeOrData.edge(l1);
            EdgeOrData<Object> _l2 = StatixTerms.isEOP(l2) ? EdgeOrData.data() : EdgeOrData.edge(l2);
            return Tuple2.of(_l1, _l2);
        });
    }

    public static TermMatch.IMatcher<CAstProperty.Op> propertyOp() {
        return TermMatch.M.cases(TermMatch.M.appl0("Add", t -> CAstProperty.Op.ADD), TermMatch.M.appl0("Set", t -> CAstProperty.Op.SET));
    }

    public static TermMatch.IMatcher<ITerm> term() {
        return TermMatch.M.casesFix(m -> Iterables2.from(StatixTerms.varTerm(), TermMatch.M.appl2("Op", TermMatch.M.stringValue(), TermMatch.M.listElems(m), (t, op, args) -> TermBuild.B.newAppl((String)op, (Iterable<? extends ITerm>)args, t.getAttachments())), TermMatch.M.appl1("Tuple", TermMatch.M.listElems(m), (t, args) -> TermBuild.B.newTuple((Collection<? extends ITerm>)args, t.getAttachments())), TermMatch.M.appl1("Str", TermMatch.M.stringValue(), (t, string) -> TermBuild.B.newString(Terms.unescapeString(string), t.getAttachments())), StatixTerms.intTerm(), StatixTerms.listTerm(), TermMatch.M.appl(SCOPE_OP, t -> t), TermMatch.M.appl(TERMINDEX_OP, t -> t), TermMatch.M.appl(NOID_OP, t -> t), TermMatch.M.appl(WITHID_OP, t -> t), TermMatch.M.appl3(OCCURRENCE_OP, TermMatch.M.string(), TermMatch.M.listElems(m), StatixTerms.positionTerm(), (t, ns, args, pos) -> {
            ImList.Immutable<ITerm> applArgs = ImList.Immutable.of(new ITerm[]{ns, TermBuild.B.newList((Collection<? extends ITerm>)args), pos});
            return TermBuild.B.newAppl(OCCURRENCE_OP, applArgs, t.getAttachments());
        }), TermMatch.M.appl1(PATH_EMPTY_OP, StatixTerms.term(), (t, s) -> {
            ImList.Immutable<ITerm> applArgs = ImList.Immutable.of(new ITerm[]{s});
            return TermBuild.B.newAppl(PATH_EMPTY_OP, applArgs, t.getAttachments());
        }), TermMatch.M.appl3(PATH_STEP_OP, StatixTerms.term(), StatixTerms.term(), StatixTerms.term(), (t, p, l, s) -> {
            ImList.Immutable<ITerm> applArgs = ImList.Immutable.of(new ITerm[]{p, l, s});
            return TermBuild.B.newAppl(PATH_STEP_OP, applArgs, t.getAttachments());
        })));
    }

    public static TermMatch.IMatcher<IIntTerm> intTerm() {
        return TermMatch.M.appl1("Int", TermMatch.M.stringValue(), (t, integer) -> TermBuild.B.newInt(Integer.parseInt(integer), t.getAttachments()));
    }

    private static TermMatch.IMatcher<ITerm> positionTerm() {
        return TermMatch.M.cases(TermMatch.M.appl0(NOID_OP), TermMatch.M.appl1(WITHID_OP, StatixTerms.varTerm(), (t, v) -> v));
    }

    public static TermMatch.IMatcher<IListTerm> listTerm() {
        return TermMatch.M.casesFix(m -> Iterables2.from(StatixTerms.varTerm(), TermMatch.M.appl1("List", TermMatch.M.listElems((t, u) -> StatixTerms.term().match(t, u)), (t, elems) -> {
            ArrayList<IAttachments> as = new ArrayList<IAttachments>();
            elems.stream().map(ITerm::getAttachments).forEach(as::add);
            as.add(t.getAttachments());
            return TermBuild.B.newList((Collection<? extends ITerm>)elems, (Collection<IAttachments>)as);
        }), TermMatch.M.appl2("ListTail", TermMatch.M.listElems((t, u) -> StatixTerms.term().match(t, u)), m, (t, elems, tail) -> {
            ArrayList<IAttachments> as = new ArrayList<IAttachments>();
            elems.stream().map(ITerm::getAttachments).forEach(as::add);
            return TermBuild.B.newListTail((Collection<? extends ITerm>)elems, (IListTerm)tail, (Collection<IAttachments>)as).withAttachments(t.getAttachments());
        })));
    }

    public static TermMatch.IMatcher<ITermVar> varTerm() {
        return TermMatch.M.preserveAttachments(TermMatch.M.appl1("Var", TermMatch.M.stringValue(), (t, name) -> TermBuild.B.newVar("", (String)name, t.getAttachments())));
    }

    public static TermMatch.IMatcher<Pattern> pattern() {
        return TermMatch.M.casesFix(m -> Iterables2.from(StatixTerms.varPattern(), TermMatch.M.appl2("As", StatixTerms.varOrWld(), m, (t, var, pattern) -> var.map(v -> TermPattern.P.newAs((ITermVar)v, (Pattern)pattern)).orElseGet(() -> TermPattern.P.newAs((Pattern)pattern))), TermMatch.M.appl2("Op", TermMatch.M.stringValue(), TermMatch.M.listElems(m), (t, op, args) -> TermPattern.P.newAppl((String)op, (Iterable<? extends Pattern>)args, t.getAttachments())), TermMatch.M.appl1("Tuple", TermMatch.M.listElems(TermMatch.M.req(m)), (t, args) -> TermPattern.P.newTuple((Iterable<? extends Pattern>)args, t.getAttachments())), TermMatch.M.appl1("List", TermMatch.M.listElems((t, u) -> m.match(t, u)), (t, elems) -> TermPattern.P.newList((List<? extends Pattern>)elems, t.getAttachments())), TermMatch.M.appl2("ListTail", TermMatch.M.listElems((t, u) -> m.match(t, u)), m, (t, elems, tail) -> TermPattern.P.newListTail((List<? extends Pattern>)elems, (Pattern)tail, t.getAttachments())), TermMatch.M.appl1("Str", TermMatch.M.stringValue(), (t, string) -> TermPattern.P.newString(Terms.unescapeString(string), t.getAttachments())), TermMatch.M.appl1("Int", TermMatch.M.stringValue(), (t, integer) -> TermPattern.P.newInt(Integer.parseInt(integer), t.getAttachments())), TermMatch.M.appl3(OCCURRENCE_OP, TermMatch.M.stringValue(), TermMatch.M.listElems(m), StatixTerms.positionPattern(), (t, ns, args, pos) -> {
            ImList.Immutable<Pattern> applArgs = ImList.Immutable.of(new Pattern[]{TermPattern.P.newString((String)ns), TermPattern.P.newList((List<? extends Pattern>)args), pos});
            return TermPattern.P.newAppl(OCCURRENCE_OP, applArgs, t.getAttachments());
        }), TermMatch.M.appl1(PATH_EMPTY_OP, m, (t, s) -> {
            ImList.Immutable<Pattern> applArgs = ImList.Immutable.of(new Pattern[]{s});
            return TermPattern.P.newAppl(PATH_EMPTY_OP, applArgs, t.getAttachments());
        }), TermMatch.M.appl3(PATH_STEP_OP, m, m, m, (t, p, l, s) -> {
            ImList.Immutable<Pattern> applArgs = ImList.Immutable.of(new Pattern[]{p, l, s});
            return TermPattern.P.newAppl(PATH_STEP_OP, applArgs, t.getAttachments());
        })));
    }

    public static TermMatch.IMatcher<Optional<ITermVar>> varOrWld() {
        return TermMatch.M.cases(TermMatch.M.appl0("Wld", t -> Optional.empty()), TermMatch.M.appl1("Var", TermMatch.M.stringValue(), (t, name) -> Optional.of(TermBuild.B.newVar("", (String)name, t.getAttachments()))));
    }

    public static TermMatch.IMatcher<Pattern> varPattern() {
        return StatixTerms.varOrWld().map(v -> v.map(TermPattern.P::newVar).orElse(TermPattern.P.newWld()));
    }

    private static TermMatch.IMatcher<Pattern> positionPattern() {
        return TermMatch.M.cases(TermMatch.M.appl0(NOID_OP, t -> TermPattern.P.newWld()), TermMatch.M.appl1(WITHID_OP, StatixTerms.varPattern(), (t, p) -> p));
    }

    public static TermMatch.IMatcher<Optional<IMessage>> message() {
        return TermMatch.M.cases(TermMatch.M.appl0("NoMessage", t -> Optional.empty()), TermMatch.M.appl3("Message", StatixTerms.messageKind(), StatixTerms.messageContent(), StatixTerms.messageOrigin(), (t, kind, content, origin) -> Optional.of(new Message((MessageKind)kind, (Iterable<IMessagePart>)content, origin.orElse(null)))));
    }

    public static TermMatch.IMatcher<List<IMessagePart>> messageContent() {
        return TermMatch.M.cases(TermMatch.M.appl1("Str", TermMatch.M.stringValue(), (t, text) -> ImList.Immutable.of(new IMessagePart[]{new TextPart(Terms.unescapeString(text))})), TermMatch.M.appl1("Formatted", TermMatch.M.listElems(StatixTerms.messagePart()), (t, parts) -> parts));
    }

    public static TermMatch.IMatcher<IMessagePart> messagePart() {
        return TermMatch.M.cases(TermMatch.M.appl1("Text", TermMatch.M.stringValue(), (t, text) -> new TextPart(StatixTerms.unescapeMessageText(text))), TermMatch.M.appl1("Term", StatixTerms.term(), (t, term) -> new TermPart((ITerm)term)));
    }

    private static String unescapeMessageText(String text) {
        StringBuilder sb = new StringBuilder();
        StringCharacterIterator it = new StringCharacterIterator(text);
        while (it.current() != '\uffff') {
            char c1 = it.current();
            if (c1 == '\\') {
                char c2 = it.next();
                if (c2 != '\uffff') {
                    switch (c2) {
                        case 'n': {
                            sb.append('\n');
                            break;
                        }
                        case 'r': {
                            sb.append('\r');
                            break;
                        }
                        case 't': {
                            sb.append('\t');
                            break;
                        }
                        case '[': 
                        case '\\': 
                        case ']': {
                            sb.append(c2);
                            break;
                        }
                        default: {
                            sb.append(c1).append(c2);
                            break;
                        }
                    }
                } else {
                    sb.append(c1);
                }
            } else {
                sb.append(c1);
            }
            it.next();
        }
        return sb.toString();
    }

    public static TermMatch.IMatcher<MessageKind> messageKind() {
        return TermMatch.M.cases(TermMatch.M.appl0("Error", t -> MessageKind.ERROR), TermMatch.M.appl0("Warning", t -> MessageKind.WARNING), TermMatch.M.appl0("Note", t -> MessageKind.NOTE));
    }

    public static TermMatch.IMatcher<Optional<ITerm>> messageOrigin() {
        return TermMatch.M.cases(TermMatch.M.appl0("NoOrigin", t -> Optional.empty()), TermMatch.M.appl1("Origin", StatixTerms.varTerm(), (t, v) -> Optional.of(v)));
    }

    public static TermMatch.IMatcher<IScopeGraph.Immutable<Scope, ITerm, ITerm>> scopeGraph() {
        return TermMatch.M.cases(TermMatch.M.appl1(SCOPEGRAPH_OP, StatixTerms.scopeGraphEntries(), (t, scopeGraph) -> scopeGraph), StatixTerms.scopeGraphEntries());
    }

    public static TermMatch.IMatcher<IScopeGraph.Immutable<Scope, ITerm, ITerm>> scopeGraphEntries() {
        return TermMatch.M.listElems(StatixTerms.scopeEntry(), (t, scopeEntries) -> {
            ScopeGraph.Transient<Scope, ITerm, ITerm> scopeGraph = ScopeGraph.Transient.of();
            for (Tuple3 se : scopeEntries) {
                Scope s = (Scope)se._1();
                if (((Optional)se._2()).isPresent()) {
                    scopeGraph.setDatum(s, (ITerm)((Optional)se._2()).get());
                }
                for (Map.Entry ee : ((Map)se._3()).entrySet()) {
                    ITerm lbl = (ITerm)ee.getKey();
                    for (Scope tgt : (ImList.Immutable)ee.getValue()) {
                        scopeGraph.addEdge(s, lbl, tgt);
                    }
                }
            }
            return scopeGraph.freeze();
        });
    }

    public static TermMatch.IMatcher<Tuple3<Scope, Optional<ITerm>, Map<ITerm, ImList.Immutable<Scope>>>> scopeEntry() {
        return TermMatch.M.tuple3(Scope.matcher(), TermMatch.M.option(TermMatch.M.term()), TermMatch.M.map(StatixTerms.label(), TermMatch.M.listElems(Scope.matcher())), (t, scope, maybeDatum, edges) -> Tuple3.of(scope, maybeDatum, edges));
    }

    public static ITerm toTerm(IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph, IUnifier.Immutable unifier) {
        HashMap dataEntries = new HashMap();
        HashMap edgeEntries = new HashMap();
        scopeGraph.getData().forEach((s, d) -> {
            d = unifier.findRecursive((ITerm)d);
            dataEntries.put(s, d);
        });
        scopeGraph.getEdges().forEach((src_lbl, tgt) -> {
            Map edges = edgeEntries.computeIfAbsent((Scope)src_lbl.getKey(), k -> new HashMap());
            edges.computeIfAbsent((ITerm)src_lbl.getValue(), k -> new ArrayList()).addAll(tgt);
        });
        ArrayList<ITerm> scopeEntries = new ArrayList<ITerm>();
        for (Scope scope : Sets.union(edgeEntries.keySet(), dataEntries.keySet())) {
            ITerm data = Optional.ofNullable((ITerm)dataEntries.get(scope)).map(d -> TermBuild.B.newAppl("Some", (ITerm)d)).orElse(TermBuild.B.newAppl("None", new ITerm[0]));
            ITerm edges = Optional.ofNullable((Map)edgeEntries.get(scope)).map(es -> {
                ArrayList lblTgts = new ArrayList();
                es.entrySet().forEach(ee -> {
                    ITerm lbl_tgt = TermBuild.B.newTuple((ITerm)ee.getKey(), TermBuild.B.newList(StatixTerms.explicateVars((Iterable)ee.getValue())));
                    lblTgts.add(lbl_tgt);
                });
                return TermBuild.B.newList(lblTgts);
            }).orElse(TermBuild.B.newList(new ITerm[0]));
            scopeEntries.add(TermBuild.B.newTuple(StatixTerms.explicateVars(scope), data, edges));
        }
        return TermBuild.B.newAppl(SCOPEGRAPH_OP, TermBuild.B.newList(scopeEntries));
    }

    public static ITerm explode(ITerm term) {
        return term.match(Terms.cases(appl -> {
            switch (appl.getOp()) {
                case "WithId": 
                case "TermIndex": 
                case "NoId": 
                case "Scope": 
                case "PathStep": 
                case "PathEmpty": {
                    return appl;
                }
                case "StxOccurrence": {
                    ITerm ns = appl.getArgs().get(0);
                    List args = TermMatch.M.listElems().map(ts -> StatixTerms.explode(ts)).match(appl.getArgs().get(1)).orElseThrow(() -> new IllegalArgumentException());
                    ITerm pos = StatixTerms.explodePosition(appl.getArgs().get(2));
                    return TermBuild.B.newAppl(appl.getOp(), ImList.Immutable.of(new ITerm[]{ns, TermBuild.B.newList(args), pos}), term.getAttachments());
                }
            }
            List<ITerm> args = StatixTerms.explode(appl.getArgs());
            return TermBuild.B.newAppl("Op", ImList.Immutable.of(new ITerm[]{TermBuild.B.newString(appl.getOp()), TermBuild.B.newList(args)}), term.getAttachments());
        }, list -> StatixTerms.explode(list), string -> TermBuild.B.newAppl("Str", ImList.Immutable.of(new IStringTerm[]{TermBuild.B.newString(Terms.escapeString(string.getValue()))}), term.getAttachments()), integer -> TermBuild.B.newAppl("Int", ImList.Immutable.of(new IStringTerm[]{TermBuild.B.newString(integer.toString())}), term.getAttachments()), blob -> TermBuild.B.newString(blob.toString(), term.getAttachments()), var -> StatixTerms.explode(var))).withAttachments(term.getAttachments());
    }

    private static ITerm explode(IListTerm list) {
        ArrayList terms = new ArrayList();
        ArrayList<IAttachments> attachments = new ArrayList<IAttachments>();
        Ref varTail = new Ref();
        while (list != null) {
            list = list.match(ListTerms.cases(cons -> {
                terms.add(StatixTerms.explode(cons.getHead()));
                attachments.add(cons.getAttachments());
                return cons.getTail();
            }, nil -> {
                attachments.add(nil.getAttachments());
                return null;
            }, var -> {
                varTail.set(StatixTerms.explode(var));
                attachments.add(Attachments.empty());
                return null;
            }));
        }
        list = TermBuild.B.newList(terms, attachments);
        if (varTail.get() != null) {
            return TermBuild.B.newAppl("ListTail", list, (ITerm)varTail.get());
        }
        return TermBuild.B.newAppl("List", list);
    }

    public static ITerm explode(ITermVar var) {
        if (!var.getResource().isEmpty()) {
            throw new IllegalArgumentException("Exploding a variable with a resource is not possible. Exploding a unification variable instead of a syntax variable?");
        }
        return TermBuild.B.newAppl("Var", TermBuild.B.newString(var.getName()));
    }

    private static List<ITerm> explode(Iterable<? extends ITerm> terms) {
        return Iterables2.stream(terms).map(StatixTerms::explode).collect(ImList.Immutable.toImmutableList());
    }

    private static ITerm explodePosition(ITerm pos) {
        return TermMatch.M.appl0(NOID_OP).match(pos).orElse(TermBuild.B.newAppl(WITHID_OP, StatixTerms.explode(pos)));
    }

    public static ITerm explicateVars(ITerm term) {
        return Transform.T.sometd(TermMatch.M.cases(TermMatch.M.cons(TermMatch.M.term(), TermMatch.M.var(), (t, hd, tl) -> TermBuild.B.newAppl("Conc", StatixTerms.explicateVars(hd), StatixTerms.explicateVar(tl))), TermMatch.M.var(StatixTerms::explicateVar))::match).apply(term);
    }

    private static ITerm explicateVar(ITermVar var) {
        return TermBuild.B.newAppl("Var", TermBuild.B.newString(var.getResource()), TermBuild.B.newString(var.getName()));
    }

    public static List<ITerm> explicateVars(Iterable<? extends ITerm> terms) {
        return Iterables2.stream(terms).map(StatixTerms::explicateVars).collect(ImList.Immutable.toImmutableList());
    }

    public static ITerm pathToTerm(IResolutionPath<Scope, ITerm, ITerm> path, Set<ITerm> relationLabels) {
        return TermBuild.B.newTuple(StatixTerms.pathToTerm(path.getPath(), relationLabels), TermBuild.B.newTuple(path.getDatum()));
    }

    public static ITerm pathToTerm(IScopePath<Scope, ITerm> path, Set<ITerm> relationLabels) {
        IApplTerm pathTerm = TermBuild.B.newAppl(PATH_EMPTY_OP, path.getSource());
        Iterator it = path.iterator();
        while (it.hasNext()) {
            IStep step = (IStep)it.next();
            if (relationLabels.contains(step.getLabel())) break;
            pathTerm = TermBuild.B.newAppl(PATH_STEP_OP, pathTerm, (ITerm)step.getLabel(), (ITerm)step.getTarget());
        }
        if (it.hasNext()) {
            throw new IllegalArgumentException("Encountered a relation label in the middle of path.");
        }
        return pathTerm;
    }

    public static Optional<Tuple2<Scope, ITerm>> pathTargetAndData(ITerm pathTerm) {
        return TermMatch.M.tuple2(TermMatch.M.cases(TermMatch.M.preserveAttachments(TermMatch.M.appl1(PATH_EMPTY_OP, Scope.matcher(), (appl, scope) -> scope)), TermMatch.M.preserveAttachments(TermMatch.M.appl3(PATH_STEP_OP, TermMatch.M.term(), TermMatch.M.term(), Scope.matcher(), (appl, prefix, lbl, scope) -> scope))), TermMatch.M.term(), (t, scope, data) -> Tuple2.of(scope, data)).match(pathTerm);
    }

    public static TermMatch.IMatcher<Schema<ITerm, ITerm, RuleName>> schema() {
        return TermMatch.M.req("SGSchema", TermMatch.M.appl3("SGSchema", StatixTerms.schemaEdges(), StatixTerms.schemaDecls(), TermMatch.M.term(), (appl, edges, decls, vars) -> {
            Schema.Builder builder = Schema.newBuilder();
            edges.forEach(builder::addEdge);
            decls.forEach(builder::addDecl);
            return builder.build();
        }));
    }

    private static TermMatch.IMatcher<List<SchemaEdge<ITerm, ITerm, RuleName>>> schemaEdges() {
        return TermMatch.M.req("SGEdges", TermMatch.M.appl1("SGEdges", TermMatch.M.listElems(StatixTerms.schemaEdge()), (appl, edges) -> edges));
    }

    private static TermMatch.IMatcher<SchemaEdge<ITerm, ITerm, RuleName>> schemaEdge() {
        return TermMatch.M.req("SGEdge", TermMatch.M.appl4("SGEdge", TermMatch.M.listElems(StatixTerms.kindVar()), StatixTerms.label(), TermMatch.M.listElems(StatixTerms.kindVar()), StatixTerms.ruleName(), (appl, sources, lbl, targets, ruleName) -> {
            SchemaEdge.Builder builder = SchemaEdge.builder(lbl, ruleName);
            sources.forEach(k_c -> {
                SchemaEdge.Builder builder2 = builder.addSource((ITerm)k_c._1(), (Cardinality)k_c._2());
            });
            targets.forEach(k_c -> {
                SchemaEdge.Builder builder2 = builder.addTarget((ITerm)k_c._1(), (Cardinality)k_c._2());
            });
            return builder.build();
        }));
    }

    private static TermMatch.IMatcher<List<SchemaDecl<ITerm, ITerm, RuleName>>> schemaDecls() {
        return TermMatch.M.req("SGDecls", TermMatch.M.appl1("SGDecls", TermMatch.M.listElems(StatixTerms.schemaDecl()), (appl, decls) -> decls));
    }

    private static TermMatch.IMatcher<SchemaDecl<ITerm, ITerm, RuleName>> schemaDecl() {
        return TermMatch.M.req("SGDecl", TermMatch.M.appl4("SGDecl", TermMatch.M.listElems(StatixTerms.kindVar()), StatixTerms.label(), TermMatch.M.listElems(StatixTerms.relKinds()), StatixTerms.ruleName(), (appl, sources, lbl, relKinds, ruleName) -> {
            SchemaDecl.Builder builder = SchemaDecl.builder(lbl, ruleName);
            sources.forEach(k_c -> {
                SchemaDecl.Builder builder2 = builder.addSource((ITerm)k_c._1(), (Cardinality)k_c._2());
            });
            IntStream.range(0, relKinds.size()).forEach(idx -> ((Optional)relKinds.get(idx)).ifPresent(kcs -> kcs.forEach(k_c -> builder.addValue(idx, (ITerm)k_c._1(), (Cardinality)k_c._2()))));
            return builder.build();
        }));
    }

    private static TermMatch.IMatcher<Optional<List<Tuple2<ITerm, Cardinality>>>> relKinds() {
        return TermMatch.M.req("RelKind", TermMatch.M.cases(TermMatch.M.appl0("DData", __ -> Optional.empty()), TermMatch.M.appl1("DScope", TermMatch.M.listElems(StatixTerms.kindVar()), (appl, kcs) -> Optional.of(kcs))));
    }

    private static TermMatch.IMatcher<Tuple2<ITerm, Cardinality>> kindVar() {
        return TermMatch.M.req("SK/C", TermMatch.M.appl2("ScopeKindWithCard", TermMatch.M.term(), StatixTerms.cardinality(), (appl, kind, card) -> Tuple2.of(kind, card)));
    }

    private static TermMatch.IMatcher<Cardinality> cardinality() {
        return TermMatch.M.req("Card", TermMatch.M.appl2("Cardinality", StatixTerms.bound(), StatixTerms.bound(), (appl, lower, upper) -> new Cardinality((Bound)lower, (Bound)upper)));
    }

    private static TermMatch.IMatcher<Bound> bound() {
        return TermMatch.M.req("Bound", TermMatch.M.cases(TermMatch.M.appl1("BNum", TermMatch.M.integerValue(), (appl, n) -> Bound.finite(n)), TermMatch.M.appl0("INF", __ -> Bound.infinite())));
    }
}

