/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.io;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.metaborg.sdf2table.grammar.IAttribute;
import org.metaborg.sdf2table.grammar.IProduction;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.Priority;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.io.ParseTableIO;
import org.metaborg.sdf2table.parsetable.LRItem;
import org.metaborg.sdf2table.parsetable.ParseTable;
import org.metaborg.sdf2table.parsetable.State;
import org.metaborg.sdf2table.parsetable.StateStatus;
import org.metaborg.util.collection.BiMap2;
import org.metaborg.util.collection.SetMultimap;
import org.metaborg.util.stream.Collectors2;

public class IncrementalParseTableGenerator
extends ParseTableIO {
    private Set<IProduction> additionalProds;
    private SetMultimap<IProduction, IAttribute> additionalProdAttributes = null;
    private Set<IProduction> removedProds;
    private Set<Symbol> changedSymbols;
    SetMultimap<Priority, Integer> additionalPrios;
    SetMultimap<Priority, Integer> removedPrios;

    public IncrementalParseTableGenerator(InputStream grammarFileStream, ParseTable reference) throws Exception {
        super(grammarFileStream, true);
        boolean changed;
        ParseTable current = this.getParseTable();
        Set<IProduction> currentProductions = current.productionLabels().keySet();
        Set<IProduction> referenceProductions = reference.productionLabels().keySet();
        this.additionalProds = currentProductions.stream().filter(e -> !referenceProductions.contains(e)).collect(Collectors2.toHashSet());
        this.removedProds = referenceProductions.stream().filter(e -> !currentProductions.contains(e)).collect(Collectors2.toHashSet());
        if (!this.additionalProds.isEmpty()) {
            this.additionalProdAttributes = new SetMultimap();
        }
        for (IProduction p : this.additionalProds) {
            this.additionalProdAttributes.putAll(p, (Collection<IAttribute>)current.normalizedGrammar().getProductionAttributesMapping().get(p));
        }
        SetMultimap<Priority, Integer> currentPriorities = current.normalizedGrammar().priorities();
        SetMultimap<Priority, Integer> referencePriorities = reference.normalizedGrammar().priorities();
        this.additionalPrios = currentPriorities.entries().filter(e -> !referencePriorities.containsEntry((Priority)e.getKey(), (Integer)e.getValue())).collect(SetMultimap.collector());
        this.removedPrios = referencePriorities.entries().filter(e -> !currentPriorities.containsEntry((Priority)e.getKey(), (Integer)e.getValue())).collect(SetMultimap.collector());
        this.changedSymbols = new HashSet<Symbol>();
        boolean bl = changed = !this.additionalPrios.isEmpty() || !this.removedPrios.isEmpty() || !this.additionalProds.isEmpty() || !this.removedProds.isEmpty();
        if (changed) {
            this.updateParseTable(reference);
        }
    }

    private void updateParseTable(ParseTable reference) {
        this.setParseTable(reference);
        ParseTable currentPT = this.getParseTable();
        this.additionalPrios.entries().forEach(f -> {
            currentPT.normalizedGrammar().priorities().put((Priority)f.getKey(), (Integer)f.getValue());
            this.changedSymbols.add((Symbol)((Priority)f.getKey()).lower().leftHand());
        });
        this.removedPrios.entries().forEach(f -> {
            currentPT.normalizedGrammar().priorities().remove((Priority)f.getKey(), (Integer)f.getValue());
            this.changedSymbols.add((Symbol)((Priority)f.getKey()).lower().leftHand());
        });
        BiMap2<IProduction, Integer> prod_labels = this.getParseTable().productionLabels();
        for (IProduction p : this.removedProds) {
            currentPT.getProdLabelFactory().releaseLabel(prod_labels.remove(p));
            this.changedSymbols.add((Symbol)p.leftHand());
        }
        for (IProduction p : this.additionalProds) {
            prod_labels.put(p, currentPT.getProdLabelFactory().getNextLabel());
            currentPT.normalizedGrammar().getProductionAttributesMapping().putAll(this.additionalProdAttributes);
            this.getParseTable().normalizedGrammar().getSymbolProductionsMapping().put((Symbol)p.leftHand(), p);
            this.changedSymbols.add((Symbol)p.leftHand());
        }
        for (IProduction p : this.additionalProds) {
            for (State s : currentPT.getSymbolStatesMapping().getStatesfromProduction(p, currentPT.normalizedGrammar().priorities())) {
                if (!s.status().equals((Object)StateStatus.PROCESSED)) continue;
                this.invalidateCacheItemSets(s);
                s.markDirty();
            }
        }
    }

    private void invalidateCacheItemSets(State state) {
        for (ISymbol iSymbol : this.changedSymbols) {
            for (LRItem item : state.getItems()) {
                if (!item.getProd().rightHand().get(item.getDotPosition()).equals(iSymbol)) continue;
                this.getParseTable().cachedItems().remove(item);
            }
        }
    }
}

