/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.util.HashSet;
import java.util.Set;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoNamed;
import org.spoofax.jsglr.client.IKeywordRecognizer;
import org.spoofax.jsglr.client.Label;
import org.spoofax.jsglr.client.ParseTable;
import org.spoofax.terms.Term;

public class KeywordRecognizer
implements IKeywordRecognizer {
    private static final long serialVersionUID = 7078477392176661390L;
    private final Set<String> keywords = new HashSet<String>();

    protected KeywordRecognizer(ParseTable table) {
        if (table != null) {
            IStrategoConstructor litFun = table.getFactory().makeConstructor("lit", 1);
            for (Label l : table.getLabels()) {
                IStrategoNamed lit;
                String litString;
                Object rhs;
                if (l == null || !Term.isTermAppl(rhs = Term.termAt(l.getProduction(), 1)) || ((IStrategoAppl)rhs).getConstructor() != litFun || !KeywordRecognizer.isPotentialKeyword(litString = (lit = (IStrategoNamed)Term.termAt(rhs, 0)).getName())) continue;
                this.keywords.add(litString);
            }
        }
    }

    @Override
    public boolean isKeyword(String literal) {
        return this.keywords.contains(literal.trim());
    }

    public static boolean isPotentialKeyword(String literal) {
        int i = 0;
        int end = literal.length();
        while (i < end) {
            char c = literal.charAt(i);
            if (!KeywordRecognizer.isPotentialKeywordChar(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isPotentialKeywordChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }
}

