// Predefined imports, functions, variables
@@IMPORTS@@

// Shorter form of System.out.println
void println(Object s) {
    System.out.println(s);
}

// To avoid naming conflict with slf4j logger, need to specify full name of logback logger
ch.qos.logback.classic.Logger getLogger(String loggerName) {
    ch.qos.logback.classic.Logger logger;
    if (loggerName.equalsIgnoreCase("ROOT")) {
      logger = (ch.qos.logback.classic.Logger) LoggerFactory.getLogger(org.slf4j.Logger.ROOT_LOGGER_NAME);
    } else {
      logger = (ch.qos.logback.classic.Logger) LoggerFactory.getLogger(loggerName);
    }
    return logger;
}

void loglevel(String loggerName, String levelName) {
    ch.qos.logback.classic.Logger logger = getLogger(loggerName);

    if (logger == null) {
        println("Unknown logger: " + loggerName);
        return;
    }

    Level level = Level.toLevel(levelName);

    if (level == null) {
        println("Unknown level: " + levelName);
        return;
    }
    
    logger.setLevel(level);
    println("Log level of " + loggerName + " logger set to " + logger.getLevel());
}

// Parse arguments and initialize variables
var args = System.getProperty("args").trim();
var argsArray = Utils.splitArgs(args);
var parser = ArgumentParsers.newFor("pgx").build();
var arguments = Arguments.parseArgs(parser, argsArray);

ServerInstance instance = null;
PgxSession session = null;
Analyst analyst = null;

if (!arguments.noConnect) {
    try {
      instance = Utils.createInstance(arguments);
      session = Utils.createSession(instance, arguments);
      analyst = Utils.createAnalyst(session);
    } catch (Throwable t) {
      t.printStackTrace(System.err);
      System.exit(-1);
    }
}

if (!arguments.noBanner) {
    Utils.printHelpInfo();
    Utils.printVersionBanner(instance);

    if (!arguments.noConnect) {
        Utils.printAvailableVariables();
    }
}

// Configure JShell mode
/set mode pgx -quiet
/set prompt pgx "@@PROMPT@@" "@@CONTINUATION_PROMPT@@"
/set format pgx action "created" added-primary
/set format pgx action "modified" modified-primary
/set format pgx action "replaced" replaced-primary
/set format pgx action "overwrote" overwrote-primary
/set format pgx action "dropped" dropped-primary
/set format pgx action "  update created" added-update
/set format pgx action "  update modified" modified-update
/set format pgx action "  update replaced" replaced-update
/set format pgx action "  update overwrote" overwrote-update
/set format pgx action "  update dropped" dropped-update
/set format pgx display "{result}{pre}created scratch variable {name} : {type}{post}" expression-added,modified,replaced-primary
/set format pgx display "{result}{pre}value of {name} : {type}{post}" varvalue-added,modified,replaced-primary
/set format pgx display "{result}{pre}assigned to {name} : {type}{post}" assignment-primary
/set format pgx display "{result}{pre}{action} variable {name} : {type}{resolve}{post}" vardecl,varinit
/set format pgx display "{pre}{action} variable {name}{resolve}{post}" vardecl,varinit-notdefined
/set format pgx display "{pre}{action} variable {name}{post}" vardecl,varinit,expression-dropped
/set format pgx display "{pre}{action} {typeKind} {name}{resolve}{post}" class,interface,enum,annotation
/set format pgx display "{pre}{action} method {name}({type}){resolve}{post}" method
/set format pgx display "{pre}attempted to use {typeKind} {name}{resolve}{post}" class,interface,enum,annotation-used
/set format pgx display "{pre}attempted to call method {name}({type}){resolve}{post}" method-used
/set format pgx display "" added,modified,replaced,overwrote,dropped-update
/set format pgx display "{pre}{action} variable {name}, reset to null{post}" vardecl,varinit-replaced-update-ok
/set format pgx display "{result}" vardecl,varinit,expression,varvalue,assignment-added,modified,replaced-primary-ok
/set format pgx err "%6$s"
/set format pgx errorline "{post}{pre}    {err}"
/set format pgx errorpost "%n"
/set format pgx errorpre "|  "
/set format pgx errors "%5$s"
/set format pgx name "%1$s"
/set format pgx post "%n"
/set format pgx pre "|  "
/set format pgx resolve "{until}{unrerr}" added,modified,replaced,used-defined,notdefined
/set format pgx result "{name} ==> {value}{post}" added,modified,replaced-primary-ok
/set format pgx type "%2$s"
/set format pgx typeKind "class" class
/set format pgx typeKind "interface" interface
/set format pgx typeKind "enum" enum
/set format pgx typeKind "annotation interface" annotation
/set format pgx unrerr "{unresolved} is declared" unresolved1-error0
/set format pgx unrerr "{unresolved} are declared" unresolved2-error0
/set format pgx unrerr " this error is corrected: {errors}" unresolved0-error1
/set format pgx unrerr "{unresolved} is declared and this error is corrected: {errors}" unresolved1-error1
/set format pgx unrerr "{unresolved} are declared and this error is corrected: {errors}" unresolved2-error1
/set format pgx unrerr " these errors are corrected: {errors}" unresolved0-error2
/set format pgx unrerr "{unresolved} is declared and these errors are corrected: {errors}" unresolved1-error2
/set format pgx unrerr "{unresolved} are declared and these errors are corrected: {errors}" unresolved2-error2
/set format pgx unresolved "%4$s"
/set format pgx until ", however, it cannot be instantiated or its methods invoked until" class-primary-defined
/set format pgx until ", however, its methods cannot be invoked until" interface-primary-defined
/set format pgx until ", however, it cannot be used until" enum,annotation-primary-defined
/set format pgx until ", however, it cannot be invoked until" method-primary-defined
/set format pgx until ", however, it cannot be referenced until" primary-notdefined
/set format pgx until " which cannot be instantiated or its methods invoked until" class-update-defined
/set format pgx until " whose methods cannot be invoked until" interface-update-defined
/set format pgx until " which cannot be invoked until" method-update-defined
/set format pgx until " which cannot be referenced until" update-notdefined
/set format pgx value "%3$s"
/set mode -retain pgx
