/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.utils;

import java.io.File;
import java.net.URI;
import org.ow2.proactive.utils.OneJar;

public class ClasspathUtils {
    private static String SCHEDULER_HOME;

    public static String findBaseDirectoryFromJarLocation(String childDirectoryName) {
        try {
            URI jarPath = ClasspathUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            File parentFile = new File(jarPath);
            while (parentFile.getParentFile() != null) {
                if (parentFile.getParentFile().getName().equals(childDirectoryName)) {
                    return parentFile.getParentFile().getParent();
                }
                parentFile = parentFile.getParentFile();
            }
            return new File(".").getAbsolutePath();
        }
        catch (Exception e) {
            return new File(".").getAbsolutePath();
        }
    }

    public static synchronized String findSchedulerHome() {
        if (SCHEDULER_HOME == null && OneJar.isRunningWithOneJar()) {
            SCHEDULER_HOME = ClasspathUtils.findBaseDirectoryFromJarLocation("lib");
        } else if (SCHEDULER_HOME == null) {
            SCHEDULER_HOME = ClasspathUtils.findBaseDirectoryFromJarLocation("dist");
        }
        return SCHEDULER_HOME;
    }
}

