# **********************************************************************
#
# Copyright (c) 2003-2015 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.1
#
# <auto-generated>
#
# Generated from file `PermissionsVerifier.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

import Ice, IcePy
import Glacier2_SSLInfo_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Included module Glacier2
_M_Glacier2 = Ice.openModule('Glacier2')

# Start of module Glacier2
__name__ = 'Glacier2'

if 'PermissionDeniedException' not in _M_Glacier2.__dict__:
    _M_Glacier2.PermissionDeniedException = Ice.createTempClass()
    class PermissionDeniedException(Ice.UserException):
        '''This exception is raised if a client is denied the ability to create
a session with the router.'''
        def __init__(self, reason=''):
            self.reason = reason

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Glacier2::PermissionDeniedException'

    _M_Glacier2._t_PermissionDeniedException = IcePy.defineException('::Glacier2::PermissionDeniedException', PermissionDeniedException, (), True, None, (('reason', (), IcePy._t_string, False, 0),))
    PermissionDeniedException._ice_type = _M_Glacier2._t_PermissionDeniedException

    _M_Glacier2.PermissionDeniedException = PermissionDeniedException
    del PermissionDeniedException

if 'PermissionsVerifier' not in _M_Glacier2.__dict__:
    _M_Glacier2.PermissionsVerifier = Ice.createTempClass()
    class PermissionsVerifier(Ice.Object):
        '''The Glacier2 permissions verifier. This is called through the
process of establishing a session.'''
        def __init__(self):
            if Ice.getType(self) == _M_Glacier2.PermissionsVerifier:
                raise RuntimeError('Glacier2.PermissionsVerifier is an abstract class')

        def ice_ids(self, current=None):
            return ('::Glacier2::PermissionsVerifier', '::Ice::Object')

        def ice_id(self, current=None):
            return '::Glacier2::PermissionsVerifier'

        def ice_staticId():
            return '::Glacier2::PermissionsVerifier'
        ice_staticId = staticmethod(ice_staticId)

        def checkPermissions(self, userId, password, current=None):
            '''Check whether a user has permission to access the router.

Arguments:
    userId The user id for which to check permission.

    password The user's password.

    reason The reason why access was denied.

Returns:
    True if access is granted, or false otherwise.

Exceptions:
    PermissionDeniedException Raised if the user access is
denied. This can be raised in place of returning false with a
reason set in the reason out parameter.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_Glacier2._t_PermissionsVerifier)

        __repr__ = __str__

    _M_Glacier2.PermissionsVerifierPrx = Ice.createTempClass()
    class PermissionsVerifierPrx(Ice.ObjectPrx):

        '''Check whether a user has permission to access the router.

Arguments:
    userId The user id for which to check permission.

    password The user's password.

    reason The reason why access was denied.

Returns:
    True if access is granted, or false otherwise.

Exceptions:
    PermissionDeniedException Raised if the user access is
denied. This can be raised in place of returning false with a
reason set in the reason out parameter.'''
        def checkPermissions(self, userId, password, _ctx=None):
            return _M_Glacier2.PermissionsVerifier._op_checkPermissions.invoke(self, ((userId, password), _ctx))

        '''Check whether a user has permission to access the router.

Arguments:
    userId The user id for which to check permission.

    password The user's password.

    reason The reason why access was denied.

Returns:
    True if access is granted, or false otherwise.

Exceptions:
    PermissionDeniedException Raised if the user access is
denied. This can be raised in place of returning false with a
reason set in the reason out parameter.'''
        def begin_checkPermissions(self, userId, password, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Glacier2.PermissionsVerifier._op_checkPermissions.begin(self, ((userId, password), _response, _ex, _sent, _ctx))

        '''Check whether a user has permission to access the router.

Arguments:
    userId The user id for which to check permission.

    password The user's password.

    reason The reason why access was denied.

Returns:
    True if access is granted, or false otherwise.

Exceptions:
    PermissionDeniedException Raised if the user access is
denied. This can be raised in place of returning false with a
reason set in the reason out parameter.'''
        def end_checkPermissions(self, _r):
            return _M_Glacier2.PermissionsVerifier._op_checkPermissions.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_Glacier2.PermissionsVerifierPrx.ice_checkedCast(proxy, '::Glacier2::PermissionsVerifier', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_Glacier2.PermissionsVerifierPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::Glacier2::PermissionsVerifier'
        ice_staticId = staticmethod(ice_staticId)

    _M_Glacier2._t_PermissionsVerifierPrx = IcePy.defineProxy('::Glacier2::PermissionsVerifier', PermissionsVerifierPrx)

    _M_Glacier2._t_PermissionsVerifier = IcePy.defineClass('::Glacier2::PermissionsVerifier', PermissionsVerifier, -1, (), True, False, None, (), ())
    PermissionsVerifier._ice_type = _M_Glacier2._t_PermissionsVerifier

    PermissionsVerifier._op_checkPermissions = IcePy.Operation('checkPermissions', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, Ice.FormatType.SlicedFormat, (), (((), IcePy._t_string, False, 0), ((), IcePy._t_string, False, 0)), (((), IcePy._t_string, False, 0),), ((), IcePy._t_bool, False, 0), (_M_Glacier2._t_PermissionDeniedException,))

    _M_Glacier2.PermissionsVerifier = PermissionsVerifier
    del PermissionsVerifier

    _M_Glacier2.PermissionsVerifierPrx = PermissionsVerifierPrx
    del PermissionsVerifierPrx

if 'SSLPermissionsVerifier' not in _M_Glacier2.__dict__:
    _M_Glacier2.SSLPermissionsVerifier = Ice.createTempClass()
    class SSLPermissionsVerifier(Ice.Object):
        '''The SSL Glacier2 permissions verifier. This is called through the
process of establishing a session.'''
        def __init__(self):
            if Ice.getType(self) == _M_Glacier2.SSLPermissionsVerifier:
                raise RuntimeError('Glacier2.SSLPermissionsVerifier is an abstract class')

        def ice_ids(self, current=None):
            return ('::Glacier2::SSLPermissionsVerifier', '::Ice::Object')

        def ice_id(self, current=None):
            return '::Glacier2::SSLPermissionsVerifier'

        def ice_staticId():
            return '::Glacier2::SSLPermissionsVerifier'
        ice_staticId = staticmethod(ice_staticId)

        def authorize(self, info, current=None):
            '''Check whether a user has permission to access the router.

Arguments:
    info The SSL information.

    reason The reason why access was denied.

Returns:
    True if access is granted, or false otherwise.

Exceptions:
    PermissionDeniedException Raised if the user access is
denied. This can be raised in place of returning false with a
reason set in the reason out parameter.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_Glacier2._t_SSLPermissionsVerifier)

        __repr__ = __str__

    _M_Glacier2.SSLPermissionsVerifierPrx = Ice.createTempClass()
    class SSLPermissionsVerifierPrx(Ice.ObjectPrx):

        '''Check whether a user has permission to access the router.

Arguments:
    info The SSL information.

    reason The reason why access was denied.

Returns:
    True if access is granted, or false otherwise.

Exceptions:
    PermissionDeniedException Raised if the user access is
denied. This can be raised in place of returning false with a
reason set in the reason out parameter.'''
        def authorize(self, info, _ctx=None):
            return _M_Glacier2.SSLPermissionsVerifier._op_authorize.invoke(self, ((info, ), _ctx))

        '''Check whether a user has permission to access the router.

Arguments:
    info The SSL information.

    reason The reason why access was denied.

Returns:
    True if access is granted, or false otherwise.

Exceptions:
    PermissionDeniedException Raised if the user access is
denied. This can be raised in place of returning false with a
reason set in the reason out parameter.'''
        def begin_authorize(self, info, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Glacier2.SSLPermissionsVerifier._op_authorize.begin(self, ((info, ), _response, _ex, _sent, _ctx))

        '''Check whether a user has permission to access the router.

Arguments:
    info The SSL information.

    reason The reason why access was denied.

Returns:
    True if access is granted, or false otherwise.

Exceptions:
    PermissionDeniedException Raised if the user access is
denied. This can be raised in place of returning false with a
reason set in the reason out parameter.'''
        def end_authorize(self, _r):
            return _M_Glacier2.SSLPermissionsVerifier._op_authorize.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_Glacier2.SSLPermissionsVerifierPrx.ice_checkedCast(proxy, '::Glacier2::SSLPermissionsVerifier', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_Glacier2.SSLPermissionsVerifierPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::Glacier2::SSLPermissionsVerifier'
        ice_staticId = staticmethod(ice_staticId)

    _M_Glacier2._t_SSLPermissionsVerifierPrx = IcePy.defineProxy('::Glacier2::SSLPermissionsVerifier', SSLPermissionsVerifierPrx)

    _M_Glacier2._t_SSLPermissionsVerifier = IcePy.defineClass('::Glacier2::SSLPermissionsVerifier', SSLPermissionsVerifier, -1, (), True, False, None, (), ())
    SSLPermissionsVerifier._ice_type = _M_Glacier2._t_SSLPermissionsVerifier

    SSLPermissionsVerifier._op_authorize = IcePy.Operation('authorize', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, Ice.FormatType.SlicedFormat, (), (((), _M_Glacier2._t_SSLInfo, False, 0),), (((), IcePy._t_string, False, 0),), ((), IcePy._t_bool, False, 0), (_M_Glacier2._t_PermissionDeniedException,))

    _M_Glacier2.SSLPermissionsVerifier = SSLPermissionsVerifier
    del SSLPermissionsVerifier

    _M_Glacier2.SSLPermissionsVerifierPrx = SSLPermissionsVerifierPrx
    del SSLPermissionsVerifierPrx

# End of module Glacier2

Ice.sliceChecksums["::Glacier2::PermissionDeniedException"] = "27def8d4569ab203b629b9162d530ba"
Ice.sliceChecksums["::Glacier2::PermissionsVerifier"] = "fcf33ee75c6e0e651d33c88bbca148d"
Ice.sliceChecksums["::Glacier2::SSLPermissionsVerifier"] = "c9d5a5d4c26aae9cb2da81d56f9f9e1"
