# **********************************************************************
#
# Copyright (c) 2003-2015 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.1
#
# <auto-generated>
#
# Generated from file `SSLInfo.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

import Ice, IcePy
import Ice_BuiltinSequences_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Start of module Glacier2
_M_Glacier2 = Ice.openModule('Glacier2')
__name__ = 'Glacier2'

if 'SSLInfo' not in _M_Glacier2.__dict__:
    _M_Glacier2.SSLInfo = Ice.createTempClass()
    class SSLInfo(object):
        '''Information taken from an SSL connection used for permissions
verification.'''
        def __init__(self, remoteHost='', remotePort=0, localHost='', localPort=0, cipher='', certs=None):
            self.remoteHost = remoteHost
            self.remotePort = remotePort
            self.localHost = localHost
            self.localPort = localPort
            self.cipher = cipher
            self.certs = certs

        def __hash__(self):
            _h = 0
            _h = 5 * _h + Ice.getHash(self.remoteHost)
            _h = 5 * _h + Ice.getHash(self.remotePort)
            _h = 5 * _h + Ice.getHash(self.localHost)
            _h = 5 * _h + Ice.getHash(self.localPort)
            _h = 5 * _h + Ice.getHash(self.cipher)
            if self.certs:
                for _i0 in self.certs:
                    _h = 5 * _h + Ice.getHash(_i0)
            return _h % 0x7fffffff

        def __compare(self, other):
            if other is None:
                return 1
            elif not isinstance(other, _M_Glacier2.SSLInfo):
                return NotImplemented
            else:
                if self.remoteHost is None or other.remoteHost is None:
                    if self.remoteHost != other.remoteHost:
                        return (-1 if self.remoteHost is None else 1)
                else:
                    if self.remoteHost < other.remoteHost:
                        return -1
                    elif self.remoteHost > other.remoteHost:
                        return 1
                if self.remotePort is None or other.remotePort is None:
                    if self.remotePort != other.remotePort:
                        return (-1 if self.remotePort is None else 1)
                else:
                    if self.remotePort < other.remotePort:
                        return -1
                    elif self.remotePort > other.remotePort:
                        return 1
                if self.localHost is None or other.localHost is None:
                    if self.localHost != other.localHost:
                        return (-1 if self.localHost is None else 1)
                else:
                    if self.localHost < other.localHost:
                        return -1
                    elif self.localHost > other.localHost:
                        return 1
                if self.localPort is None or other.localPort is None:
                    if self.localPort != other.localPort:
                        return (-1 if self.localPort is None else 1)
                else:
                    if self.localPort < other.localPort:
                        return -1
                    elif self.localPort > other.localPort:
                        return 1
                if self.cipher is None or other.cipher is None:
                    if self.cipher != other.cipher:
                        return (-1 if self.cipher is None else 1)
                else:
                    if self.cipher < other.cipher:
                        return -1
                    elif self.cipher > other.cipher:
                        return 1
                if self.certs is None or other.certs is None:
                    if self.certs != other.certs:
                        return (-1 if self.certs is None else 1)
                else:
                    if self.certs < other.certs:
                        return -1
                    elif self.certs > other.certs:
                        return 1
                return 0

        def __lt__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r < 0

        def __le__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r <= 0

        def __gt__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r > 0

        def __ge__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r >= 0

        def __eq__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r == 0

        def __ne__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r != 0

        def __str__(self):
            return IcePy.stringify(self, _M_Glacier2._t_SSLInfo)

        __repr__ = __str__

    _M_Glacier2._t_SSLInfo = IcePy.defineStruct('::Glacier2::SSLInfo', SSLInfo, (), (
        ('remoteHost', (), IcePy._t_string),
        ('remotePort', (), IcePy._t_int),
        ('localHost', (), IcePy._t_string),
        ('localPort', (), IcePy._t_int),
        ('cipher', (), IcePy._t_string),
        ('certs', (), _M_Ice._t_StringSeq)
    ))

    _M_Glacier2.SSLInfo = SSLInfo
    del SSLInfo

# End of module Glacier2

Ice.sliceChecksums["::Glacier2::SSLInfo"] = "ca63bc6d361a48471c4d16ea29818e5"
