# **********************************************************************
#
# Copyright (c) 2003-2015 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.1
#
# <auto-generated>
#
# Generated from file `Observer.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

import Ice, IcePy
import Glacier2_Session_ice
import IceGrid_Exception_ice
import IceGrid_Descriptor_ice
import IceGrid_Admin_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Included module Glacier2
_M_Glacier2 = Ice.openModule('Glacier2')

# Included module IceGrid
_M_IceGrid = Ice.openModule('IceGrid')

# Start of module IceGrid
__name__ = 'IceGrid'

if 'ServerDynamicInfo' not in _M_IceGrid.__dict__:
    _M_IceGrid.ServerDynamicInfo = Ice.createTempClass()
    class ServerDynamicInfo(object):
        '''Dynamic information about the state of a server.'''
        def __init__(self, id='', state=_M_IceGrid.ServerState.Inactive, pid=0, enabled=False):
            self.id = id
            self.state = state
            self.pid = pid
            self.enabled = enabled

        def __hash__(self):
            _h = 0
            _h = 5 * _h + Ice.getHash(self.id)
            _h = 5 * _h + Ice.getHash(self.state)
            _h = 5 * _h + Ice.getHash(self.pid)
            _h = 5 * _h + Ice.getHash(self.enabled)
            return _h % 0x7fffffff

        def __compare(self, other):
            if other is None:
                return 1
            elif not isinstance(other, _M_IceGrid.ServerDynamicInfo):
                return NotImplemented
            else:
                if self.id is None or other.id is None:
                    if self.id != other.id:
                        return (-1 if self.id is None else 1)
                else:
                    if self.id < other.id:
                        return -1
                    elif self.id > other.id:
                        return 1
                if self.state is None or other.state is None:
                    if self.state != other.state:
                        return (-1 if self.state is None else 1)
                else:
                    if self.state < other.state:
                        return -1
                    elif self.state > other.state:
                        return 1
                if self.pid is None or other.pid is None:
                    if self.pid != other.pid:
                        return (-1 if self.pid is None else 1)
                else:
                    if self.pid < other.pid:
                        return -1
                    elif self.pid > other.pid:
                        return 1
                if self.enabled is None or other.enabled is None:
                    if self.enabled != other.enabled:
                        return (-1 if self.enabled is None else 1)
                else:
                    if self.enabled < other.enabled:
                        return -1
                    elif self.enabled > other.enabled:
                        return 1
                return 0

        def __lt__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r < 0

        def __le__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r <= 0

        def __gt__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r > 0

        def __ge__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r >= 0

        def __eq__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r == 0

        def __ne__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r != 0

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_ServerDynamicInfo)

        __repr__ = __str__

    _M_IceGrid._t_ServerDynamicInfo = IcePy.defineStruct('::IceGrid::ServerDynamicInfo', ServerDynamicInfo, (), (
        ('id', (), IcePy._t_string),
        ('state', (), _M_IceGrid._t_ServerState),
        ('pid', (), IcePy._t_int),
        ('enabled', (), IcePy._t_bool)
    ))

    _M_IceGrid.ServerDynamicInfo = ServerDynamicInfo
    del ServerDynamicInfo

if '_t_ServerDynamicInfoSeq' not in _M_IceGrid.__dict__:
    _M_IceGrid._t_ServerDynamicInfoSeq = IcePy.defineSequence('::IceGrid::ServerDynamicInfoSeq', (), _M_IceGrid._t_ServerDynamicInfo)

if 'AdapterDynamicInfo' not in _M_IceGrid.__dict__:
    _M_IceGrid.AdapterDynamicInfo = Ice.createTempClass()
    class AdapterDynamicInfo(object):
        '''Dynamic information about the state of an adapter.'''
        def __init__(self, id='', proxy=None):
            self.id = id
            self.proxy = proxy

        def __eq__(self, other):
            if other is None:
                return False
            elif not isinstance(other, _M_IceGrid.AdapterDynamicInfo):
                return NotImplemented
            else:
                if self.id != other.id:
                    return False
                if self.proxy != other.proxy:
                    return False
                return True

        def __ne__(self, other):
            return not self.__eq__(other)

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_AdapterDynamicInfo)

        __repr__ = __str__

    _M_IceGrid._t_AdapterDynamicInfo = IcePy.defineStruct('::IceGrid::AdapterDynamicInfo', AdapterDynamicInfo, (), (
        ('id', (), IcePy._t_string),
        ('proxy', (), IcePy._t_ObjectPrx)
    ))

    _M_IceGrid.AdapterDynamicInfo = AdapterDynamicInfo
    del AdapterDynamicInfo

if '_t_AdapterDynamicInfoSeq' not in _M_IceGrid.__dict__:
    _M_IceGrid._t_AdapterDynamicInfoSeq = IcePy.defineSequence('::IceGrid::AdapterDynamicInfoSeq', (), _M_IceGrid._t_AdapterDynamicInfo)

if 'NodeDynamicInfo' not in _M_IceGrid.__dict__:
    _M_IceGrid.NodeDynamicInfo = Ice.createTempClass()
    class NodeDynamicInfo(object):
        '''Dynamic information about the state of a node.'''
        def __init__(self, info=Ice._struct_marker, servers=None, adapters=None):
            if info is Ice._struct_marker:
                self.info = _M_IceGrid.NodeInfo()
            else:
                self.info = info
            self.servers = servers
            self.adapters = adapters

        def __eq__(self, other):
            if other is None:
                return False
            elif not isinstance(other, _M_IceGrid.NodeDynamicInfo):
                return NotImplemented
            else:
                if self.info != other.info:
                    return False
                if self.servers != other.servers:
                    return False
                if self.adapters != other.adapters:
                    return False
                return True

        def __ne__(self, other):
            return not self.__eq__(other)

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_NodeDynamicInfo)

        __repr__ = __str__

    _M_IceGrid._t_NodeDynamicInfo = IcePy.defineStruct('::IceGrid::NodeDynamicInfo', NodeDynamicInfo, (), (
        ('info', (), _M_IceGrid._t_NodeInfo),
        ('servers', (), _M_IceGrid._t_ServerDynamicInfoSeq),
        ('adapters', (), _M_IceGrid._t_AdapterDynamicInfoSeq)
    ))

    _M_IceGrid.NodeDynamicInfo = NodeDynamicInfo
    del NodeDynamicInfo

if '_t_NodeDynamicInfoSeq' not in _M_IceGrid.__dict__:
    _M_IceGrid._t_NodeDynamicInfoSeq = IcePy.defineSequence('::IceGrid::NodeDynamicInfoSeq', (), _M_IceGrid._t_NodeDynamicInfo)

if 'NodeObserver' not in _M_IceGrid.__dict__:
    _M_IceGrid.NodeObserver = Ice.createTempClass()
    class NodeObserver(Ice.Object):
        '''The node observer interface. Observers should implement this
interface to receive information about the state of the IceGrid
nodes.'''
        def __init__(self):
            if Ice.getType(self) == _M_IceGrid.NodeObserver:
                raise RuntimeError('IceGrid.NodeObserver is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceGrid::NodeObserver')

        def ice_id(self, current=None):
            return '::IceGrid::NodeObserver'

        def ice_staticId():
            return '::IceGrid::NodeObserver'
        ice_staticId = staticmethod(ice_staticId)

        def nodeInit(self, nodes, current=None):
            '''The nodeInit operation indicates the current state
of nodes. It is called after the registration of an observer.

Arguments:
    nodes The current state of the nodes.'''
            pass

        def nodeUp(self, node, current=None):
            '''The nodeUp operation is called to notify an observer that a node
came up.

Arguments:
    node The node state.'''
            pass

        def nodeDown(self, name, current=None):
            '''The nodeDown operation is called to notify an observer that a node
went down.

Arguments:
    name The node name.'''
            pass

        def updateServer(self, node, updatedInfo, current=None):
            '''The updateServer operation is called to notify an observer that
the state of a server changed.

Arguments:
    node The node hosting the server.

    updatedInfo The new server state.'''
            pass

        def updateAdapter(self, node, updatedInfo, current=None):
            '''The updateAdapter operation is called to notify an observer that
the state of an adapter changed.

Arguments:
    node The node hosting the adapter.

    updatedInfo The new adapter state.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_NodeObserver)

        __repr__ = __str__

    _M_IceGrid.NodeObserverPrx = Ice.createTempClass()
    class NodeObserverPrx(Ice.ObjectPrx):

        '''The nodeInit operation indicates the current state
of nodes. It is called after the registration of an observer.

Arguments:
    nodes The current state of the nodes.'''
        def nodeInit(self, nodes, _ctx=None):
            return _M_IceGrid.NodeObserver._op_nodeInit.invoke(self, ((nodes, ), _ctx))

        '''The nodeInit operation indicates the current state
of nodes. It is called after the registration of an observer.

Arguments:
    nodes The current state of the nodes.'''
        def begin_nodeInit(self, nodes, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.NodeObserver._op_nodeInit.begin(self, ((nodes, ), _response, _ex, _sent, _ctx))

        '''The nodeInit operation indicates the current state
of nodes. It is called after the registration of an observer.

Arguments:
    nodes The current state of the nodes.'''
        def end_nodeInit(self, _r):
            return _M_IceGrid.NodeObserver._op_nodeInit.end(self, _r)

        '''The nodeUp operation is called to notify an observer that a node
came up.

Arguments:
    node The node state.'''
        def nodeUp(self, node, _ctx=None):
            return _M_IceGrid.NodeObserver._op_nodeUp.invoke(self, ((node, ), _ctx))

        '''The nodeUp operation is called to notify an observer that a node
came up.

Arguments:
    node The node state.'''
        def begin_nodeUp(self, node, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.NodeObserver._op_nodeUp.begin(self, ((node, ), _response, _ex, _sent, _ctx))

        '''The nodeUp operation is called to notify an observer that a node
came up.

Arguments:
    node The node state.'''
        def end_nodeUp(self, _r):
            return _M_IceGrid.NodeObserver._op_nodeUp.end(self, _r)

        '''The nodeDown operation is called to notify an observer that a node
went down.

Arguments:
    name The node name.'''
        def nodeDown(self, name, _ctx=None):
            return _M_IceGrid.NodeObserver._op_nodeDown.invoke(self, ((name, ), _ctx))

        '''The nodeDown operation is called to notify an observer that a node
went down.

Arguments:
    name The node name.'''
        def begin_nodeDown(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.NodeObserver._op_nodeDown.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        '''The nodeDown operation is called to notify an observer that a node
went down.

Arguments:
    name The node name.'''
        def end_nodeDown(self, _r):
            return _M_IceGrid.NodeObserver._op_nodeDown.end(self, _r)

        '''The updateServer operation is called to notify an observer that
the state of a server changed.

Arguments:
    node The node hosting the server.

    updatedInfo The new server state.'''
        def updateServer(self, node, updatedInfo, _ctx=None):
            return _M_IceGrid.NodeObserver._op_updateServer.invoke(self, ((node, updatedInfo), _ctx))

        '''The updateServer operation is called to notify an observer that
the state of a server changed.

Arguments:
    node The node hosting the server.

    updatedInfo The new server state.'''
        def begin_updateServer(self, node, updatedInfo, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.NodeObserver._op_updateServer.begin(self, ((node, updatedInfo), _response, _ex, _sent, _ctx))

        '''The updateServer operation is called to notify an observer that
the state of a server changed.

Arguments:
    node The node hosting the server.

    updatedInfo The new server state.'''
        def end_updateServer(self, _r):
            return _M_IceGrid.NodeObserver._op_updateServer.end(self, _r)

        '''The updateAdapter operation is called to notify an observer that
the state of an adapter changed.

Arguments:
    node The node hosting the adapter.

    updatedInfo The new adapter state.'''
        def updateAdapter(self, node, updatedInfo, _ctx=None):
            return _M_IceGrid.NodeObserver._op_updateAdapter.invoke(self, ((node, updatedInfo), _ctx))

        '''The updateAdapter operation is called to notify an observer that
the state of an adapter changed.

Arguments:
    node The node hosting the adapter.

    updatedInfo The new adapter state.'''
        def begin_updateAdapter(self, node, updatedInfo, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.NodeObserver._op_updateAdapter.begin(self, ((node, updatedInfo), _response, _ex, _sent, _ctx))

        '''The updateAdapter operation is called to notify an observer that
the state of an adapter changed.

Arguments:
    node The node hosting the adapter.

    updatedInfo The new adapter state.'''
        def end_updateAdapter(self, _r):
            return _M_IceGrid.NodeObserver._op_updateAdapter.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceGrid.NodeObserverPrx.ice_checkedCast(proxy, '::IceGrid::NodeObserver', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceGrid.NodeObserverPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceGrid::NodeObserver'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceGrid._t_NodeObserverPrx = IcePy.defineProxy('::IceGrid::NodeObserver', NodeObserverPrx)

    _M_IceGrid._t_NodeObserver = IcePy.defineClass('::IceGrid::NodeObserver', NodeObserver, -1, (), True, False, None, (), ())
    NodeObserver._ice_type = _M_IceGrid._t_NodeObserver

    NodeObserver._op_nodeInit = IcePy.Operation('nodeInit', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_IceGrid._t_NodeDynamicInfoSeq, False, 0),), (), None, ())
    NodeObserver._op_nodeUp = IcePy.Operation('nodeUp', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_IceGrid._t_NodeDynamicInfo, False, 0),), (), None, ())
    NodeObserver._op_nodeDown = IcePy.Operation('nodeDown', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0),), (), None, ())
    NodeObserver._op_updateServer = IcePy.Operation('updateServer', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0), ((), _M_IceGrid._t_ServerDynamicInfo, False, 0)), (), None, ())
    NodeObserver._op_updateAdapter = IcePy.Operation('updateAdapter', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0), ((), _M_IceGrid._t_AdapterDynamicInfo, False, 0)), (), None, ())

    _M_IceGrid.NodeObserver = NodeObserver
    del NodeObserver

    _M_IceGrid.NodeObserverPrx = NodeObserverPrx
    del NodeObserverPrx

if 'ApplicationObserver' not in _M_IceGrid.__dict__:
    _M_IceGrid.ApplicationObserver = Ice.createTempClass()
    class ApplicationObserver(Ice.Object):
        '''The database observer interface. Observers should implement this
interface to receive information about the state of the IceGrid
registry database.'''
        def __init__(self):
            if Ice.getType(self) == _M_IceGrid.ApplicationObserver:
                raise RuntimeError('IceGrid.ApplicationObserver is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceGrid::ApplicationObserver')

        def ice_id(self, current=None):
            return '::IceGrid::ApplicationObserver'

        def ice_staticId():
            return '::IceGrid::ApplicationObserver'
        ice_staticId = staticmethod(ice_staticId)

        def applicationInit(self, serial, applications, current=None):
            '''applicationInit is called after the registration
of an observer to indicate the state of the registry.

Arguments:
    serial The current serial number of the registry
database. This serial number allows observers to make sure that
their internal state is synchronized with the registry.

    applications The applications currently registered with
the registry.'''
            pass

        def applicationAdded(self, serial, desc, current=None):
            '''The applicationAdded operation is called to notify an observer
that an application was added.

Arguments:
    serial The new serial number of the registry database.

    desc The descriptor of the new application.'''
            pass

        def applicationRemoved(self, serial, name, current=None):
            '''The applicationRemoved operation is called to notify an observer
that an application was removed.

Arguments:
    serial The new serial number of the registry database.

    name The name of the application that was removed.'''
            pass

        def applicationUpdated(self, serial, desc, current=None):
            '''The applicationUpdated operation is called to notify an observer
that an application was updated.

Arguments:
    serial The new serial number of the registry database.

    desc The descriptor of the update.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_ApplicationObserver)

        __repr__ = __str__

    _M_IceGrid.ApplicationObserverPrx = Ice.createTempClass()
    class ApplicationObserverPrx(Ice.ObjectPrx):

        '''applicationInit is called after the registration
of an observer to indicate the state of the registry.

Arguments:
    serial The current serial number of the registry
database. This serial number allows observers to make sure that
their internal state is synchronized with the registry.

    applications The applications currently registered with
the registry.'''
        def applicationInit(self, serial, applications, _ctx=None):
            return _M_IceGrid.ApplicationObserver._op_applicationInit.invoke(self, ((serial, applications), _ctx))

        '''applicationInit is called after the registration
of an observer to indicate the state of the registry.

Arguments:
    serial The current serial number of the registry
database. This serial number allows observers to make sure that
their internal state is synchronized with the registry.

    applications The applications currently registered with
the registry.'''
        def begin_applicationInit(self, serial, applications, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.ApplicationObserver._op_applicationInit.begin(self, ((serial, applications), _response, _ex, _sent, _ctx))

        '''applicationInit is called after the registration
of an observer to indicate the state of the registry.

Arguments:
    serial The current serial number of the registry
database. This serial number allows observers to make sure that
their internal state is synchronized with the registry.

    applications The applications currently registered with
the registry.'''
        def end_applicationInit(self, _r):
            return _M_IceGrid.ApplicationObserver._op_applicationInit.end(self, _r)

        '''The applicationAdded operation is called to notify an observer
that an application was added.

Arguments:
    serial The new serial number of the registry database.

    desc The descriptor of the new application.'''
        def applicationAdded(self, serial, desc, _ctx=None):
            return _M_IceGrid.ApplicationObserver._op_applicationAdded.invoke(self, ((serial, desc), _ctx))

        '''The applicationAdded operation is called to notify an observer
that an application was added.

Arguments:
    serial The new serial number of the registry database.

    desc The descriptor of the new application.'''
        def begin_applicationAdded(self, serial, desc, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.ApplicationObserver._op_applicationAdded.begin(self, ((serial, desc), _response, _ex, _sent, _ctx))

        '''The applicationAdded operation is called to notify an observer
that an application was added.

Arguments:
    serial The new serial number of the registry database.

    desc The descriptor of the new application.'''
        def end_applicationAdded(self, _r):
            return _M_IceGrid.ApplicationObserver._op_applicationAdded.end(self, _r)

        '''The applicationRemoved operation is called to notify an observer
that an application was removed.

Arguments:
    serial The new serial number of the registry database.

    name The name of the application that was removed.'''
        def applicationRemoved(self, serial, name, _ctx=None):
            return _M_IceGrid.ApplicationObserver._op_applicationRemoved.invoke(self, ((serial, name), _ctx))

        '''The applicationRemoved operation is called to notify an observer
that an application was removed.

Arguments:
    serial The new serial number of the registry database.

    name The name of the application that was removed.'''
        def begin_applicationRemoved(self, serial, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.ApplicationObserver._op_applicationRemoved.begin(self, ((serial, name), _response, _ex, _sent, _ctx))

        '''The applicationRemoved operation is called to notify an observer
that an application was removed.

Arguments:
    serial The new serial number of the registry database.

    name The name of the application that was removed.'''
        def end_applicationRemoved(self, _r):
            return _M_IceGrid.ApplicationObserver._op_applicationRemoved.end(self, _r)

        '''The applicationUpdated operation is called to notify an observer
that an application was updated.

Arguments:
    serial The new serial number of the registry database.

    desc The descriptor of the update.'''
        def applicationUpdated(self, serial, desc, _ctx=None):
            return _M_IceGrid.ApplicationObserver._op_applicationUpdated.invoke(self, ((serial, desc), _ctx))

        '''The applicationUpdated operation is called to notify an observer
that an application was updated.

Arguments:
    serial The new serial number of the registry database.

    desc The descriptor of the update.'''
        def begin_applicationUpdated(self, serial, desc, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.ApplicationObserver._op_applicationUpdated.begin(self, ((serial, desc), _response, _ex, _sent, _ctx))

        '''The applicationUpdated operation is called to notify an observer
that an application was updated.

Arguments:
    serial The new serial number of the registry database.

    desc The descriptor of the update.'''
        def end_applicationUpdated(self, _r):
            return _M_IceGrid.ApplicationObserver._op_applicationUpdated.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceGrid.ApplicationObserverPrx.ice_checkedCast(proxy, '::IceGrid::ApplicationObserver', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceGrid.ApplicationObserverPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceGrid::ApplicationObserver'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceGrid._t_ApplicationObserverPrx = IcePy.defineProxy('::IceGrid::ApplicationObserver', ApplicationObserverPrx)

    _M_IceGrid._t_ApplicationObserver = IcePy.defineClass('::IceGrid::ApplicationObserver', ApplicationObserver, -1, (), True, False, None, (), ())
    ApplicationObserver._ice_type = _M_IceGrid._t_ApplicationObserver

    ApplicationObserver._op_applicationInit = IcePy.Operation('applicationInit', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_int, False, 0), ((), _M_IceGrid._t_ApplicationInfoSeq, False, 0)), (), None, ())
    ApplicationObserver._op_applicationAdded = IcePy.Operation('applicationAdded', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_int, False, 0), ((), _M_IceGrid._t_ApplicationInfo, False, 0)), (), None, ())
    ApplicationObserver._op_applicationRemoved = IcePy.Operation('applicationRemoved', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_int, False, 0), ((), IcePy._t_string, False, 0)), (), None, ())
    ApplicationObserver._op_applicationUpdated = IcePy.Operation('applicationUpdated', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_int, False, 0), ((), _M_IceGrid._t_ApplicationUpdateInfo, False, 0)), (), None, ())

    _M_IceGrid.ApplicationObserver = ApplicationObserver
    del ApplicationObserver

    _M_IceGrid.ApplicationObserverPrx = ApplicationObserverPrx
    del ApplicationObserverPrx

if 'AdapterObserver' not in _M_IceGrid.__dict__:
    _M_IceGrid.AdapterObserver = Ice.createTempClass()
    class AdapterObserver(Ice.Object):
        '''This interface allows applications to monitor the state of object
adapters that are registered with IceGrid.'''
        def __init__(self):
            if Ice.getType(self) == _M_IceGrid.AdapterObserver:
                raise RuntimeError('IceGrid.AdapterObserver is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceGrid::AdapterObserver')

        def ice_id(self, current=None):
            return '::IceGrid::AdapterObserver'

        def ice_staticId():
            return '::IceGrid::AdapterObserver'
        ice_staticId = staticmethod(ice_staticId)

        def adapterInit(self, adpts, current=None):
            '''adapterInit is called after registration of
an observer to indicate the state of the registry.

Arguments:
    adpts The adapters that were dynamically registered
with the registry (not through the deployment mechanism).'''
            pass

        def adapterAdded(self, info, current=None):
            '''The adapterAdded operation is called to notify an observer when
a dynamically-registered adapter was added.

Arguments:
    info The details of the new adapter.'''
            pass

        def adapterUpdated(self, info, current=None):
            '''The adapterUpdated operation is called to notify an observer when
a dynamically-registered adapter was updated.

Arguments:
    info The details of the updated adapter.'''
            pass

        def adapterRemoved(self, id, current=None):
            '''The adapterRemoved operation is called to notify an observer when
a dynamically-registered adapter was removed.

Arguments:
    id The ID of the removed adapter.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_AdapterObserver)

        __repr__ = __str__

    _M_IceGrid.AdapterObserverPrx = Ice.createTempClass()
    class AdapterObserverPrx(Ice.ObjectPrx):

        '''adapterInit is called after registration of
an observer to indicate the state of the registry.

Arguments:
    adpts The adapters that were dynamically registered
with the registry (not through the deployment mechanism).'''
        def adapterInit(self, adpts, _ctx=None):
            return _M_IceGrid.AdapterObserver._op_adapterInit.invoke(self, ((adpts, ), _ctx))

        '''adapterInit is called after registration of
an observer to indicate the state of the registry.

Arguments:
    adpts The adapters that were dynamically registered
with the registry (not through the deployment mechanism).'''
        def begin_adapterInit(self, adpts, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdapterObserver._op_adapterInit.begin(self, ((adpts, ), _response, _ex, _sent, _ctx))

        '''adapterInit is called after registration of
an observer to indicate the state of the registry.

Arguments:
    adpts The adapters that were dynamically registered
with the registry (not through the deployment mechanism).'''
        def end_adapterInit(self, _r):
            return _M_IceGrid.AdapterObserver._op_adapterInit.end(self, _r)

        '''The adapterAdded operation is called to notify an observer when
a dynamically-registered adapter was added.

Arguments:
    info The details of the new adapter.'''
        def adapterAdded(self, info, _ctx=None):
            return _M_IceGrid.AdapterObserver._op_adapterAdded.invoke(self, ((info, ), _ctx))

        '''The adapterAdded operation is called to notify an observer when
a dynamically-registered adapter was added.

Arguments:
    info The details of the new adapter.'''
        def begin_adapterAdded(self, info, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdapterObserver._op_adapterAdded.begin(self, ((info, ), _response, _ex, _sent, _ctx))

        '''The adapterAdded operation is called to notify an observer when
a dynamically-registered adapter was added.

Arguments:
    info The details of the new adapter.'''
        def end_adapterAdded(self, _r):
            return _M_IceGrid.AdapterObserver._op_adapterAdded.end(self, _r)

        '''The adapterUpdated operation is called to notify an observer when
a dynamically-registered adapter was updated.

Arguments:
    info The details of the updated adapter.'''
        def adapterUpdated(self, info, _ctx=None):
            return _M_IceGrid.AdapterObserver._op_adapterUpdated.invoke(self, ((info, ), _ctx))

        '''The adapterUpdated operation is called to notify an observer when
a dynamically-registered adapter was updated.

Arguments:
    info The details of the updated adapter.'''
        def begin_adapterUpdated(self, info, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdapterObserver._op_adapterUpdated.begin(self, ((info, ), _response, _ex, _sent, _ctx))

        '''The adapterUpdated operation is called to notify an observer when
a dynamically-registered adapter was updated.

Arguments:
    info The details of the updated adapter.'''
        def end_adapterUpdated(self, _r):
            return _M_IceGrid.AdapterObserver._op_adapterUpdated.end(self, _r)

        '''The adapterRemoved operation is called to notify an observer when
a dynamically-registered adapter was removed.

Arguments:
    id The ID of the removed adapter.'''
        def adapterRemoved(self, id, _ctx=None):
            return _M_IceGrid.AdapterObserver._op_adapterRemoved.invoke(self, ((id, ), _ctx))

        '''The adapterRemoved operation is called to notify an observer when
a dynamically-registered adapter was removed.

Arguments:
    id The ID of the removed adapter.'''
        def begin_adapterRemoved(self, id, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdapterObserver._op_adapterRemoved.begin(self, ((id, ), _response, _ex, _sent, _ctx))

        '''The adapterRemoved operation is called to notify an observer when
a dynamically-registered adapter was removed.

Arguments:
    id The ID of the removed adapter.'''
        def end_adapterRemoved(self, _r):
            return _M_IceGrid.AdapterObserver._op_adapterRemoved.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceGrid.AdapterObserverPrx.ice_checkedCast(proxy, '::IceGrid::AdapterObserver', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceGrid.AdapterObserverPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceGrid::AdapterObserver'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceGrid._t_AdapterObserverPrx = IcePy.defineProxy('::IceGrid::AdapterObserver', AdapterObserverPrx)

    _M_IceGrid._t_AdapterObserver = IcePy.defineClass('::IceGrid::AdapterObserver', AdapterObserver, -1, (), True, False, None, (), ())
    AdapterObserver._ice_type = _M_IceGrid._t_AdapterObserver

    AdapterObserver._op_adapterInit = IcePy.Operation('adapterInit', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_IceGrid._t_AdapterInfoSeq, False, 0),), (), None, ())
    AdapterObserver._op_adapterAdded = IcePy.Operation('adapterAdded', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_IceGrid._t_AdapterInfo, False, 0),), (), None, ())
    AdapterObserver._op_adapterUpdated = IcePy.Operation('adapterUpdated', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_IceGrid._t_AdapterInfo, False, 0),), (), None, ())
    AdapterObserver._op_adapterRemoved = IcePy.Operation('adapterRemoved', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0),), (), None, ())

    _M_IceGrid.AdapterObserver = AdapterObserver
    del AdapterObserver

    _M_IceGrid.AdapterObserverPrx = AdapterObserverPrx
    del AdapterObserverPrx

if 'ObjectObserver' not in _M_IceGrid.__dict__:
    _M_IceGrid.ObjectObserver = Ice.createTempClass()
    class ObjectObserver(Ice.Object):
        '''This interface allows applications to monitor IceGrid well-known objects.'''
        def __init__(self):
            if Ice.getType(self) == _M_IceGrid.ObjectObserver:
                raise RuntimeError('IceGrid.ObjectObserver is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceGrid::ObjectObserver')

        def ice_id(self, current=None):
            return '::IceGrid::ObjectObserver'

        def ice_staticId():
            return '::IceGrid::ObjectObserver'
        ice_staticId = staticmethod(ice_staticId)

        def objectInit(self, objects, current=None):
            '''objectInit is called after the registration of
an observer to indicate the state of the registry.

Arguments:
    objects The objects registered with the Admin
interface (not through the deployment mechanism).'''
            pass

        def objectAdded(self, info, current=None):
            '''The objectAdded operation is called to notify an observer when an
object was added to the Admin interface.

Arguments:
    info The details of the added object.'''
            pass

        def objectUpdated(self, info, current=None):
            '''objectUpdated is called to notify an observer when
an object registered with the Admin interface was updated.

Arguments:
    info The details of the updated object.'''
            pass

        def objectRemoved(self, id, current=None):
            '''objectRemoved is called to notify an observer when
an object registered with the Admin interface was removed.

Arguments:
    id The identity of the removed object.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_ObjectObserver)

        __repr__ = __str__

    _M_IceGrid.ObjectObserverPrx = Ice.createTempClass()
    class ObjectObserverPrx(Ice.ObjectPrx):

        '''objectInit is called after the registration of
an observer to indicate the state of the registry.

Arguments:
    objects The objects registered with the Admin
interface (not through the deployment mechanism).'''
        def objectInit(self, objects, _ctx=None):
            return _M_IceGrid.ObjectObserver._op_objectInit.invoke(self, ((objects, ), _ctx))

        '''objectInit is called after the registration of
an observer to indicate the state of the registry.

Arguments:
    objects The objects registered with the Admin
interface (not through the deployment mechanism).'''
        def begin_objectInit(self, objects, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.ObjectObserver._op_objectInit.begin(self, ((objects, ), _response, _ex, _sent, _ctx))

        '''objectInit is called after the registration of
an observer to indicate the state of the registry.

Arguments:
    objects The objects registered with the Admin
interface (not through the deployment mechanism).'''
        def end_objectInit(self, _r):
            return _M_IceGrid.ObjectObserver._op_objectInit.end(self, _r)

        '''The objectAdded operation is called to notify an observer when an
object was added to the Admin interface.

Arguments:
    info The details of the added object.'''
        def objectAdded(self, info, _ctx=None):
            return _M_IceGrid.ObjectObserver._op_objectAdded.invoke(self, ((info, ), _ctx))

        '''The objectAdded operation is called to notify an observer when an
object was added to the Admin interface.

Arguments:
    info The details of the added object.'''
        def begin_objectAdded(self, info, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.ObjectObserver._op_objectAdded.begin(self, ((info, ), _response, _ex, _sent, _ctx))

        '''The objectAdded operation is called to notify an observer when an
object was added to the Admin interface.

Arguments:
    info The details of the added object.'''
        def end_objectAdded(self, _r):
            return _M_IceGrid.ObjectObserver._op_objectAdded.end(self, _r)

        '''objectUpdated is called to notify an observer when
an object registered with the Admin interface was updated.

Arguments:
    info The details of the updated object.'''
        def objectUpdated(self, info, _ctx=None):
            return _M_IceGrid.ObjectObserver._op_objectUpdated.invoke(self, ((info, ), _ctx))

        '''objectUpdated is called to notify an observer when
an object registered with the Admin interface was updated.

Arguments:
    info The details of the updated object.'''
        def begin_objectUpdated(self, info, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.ObjectObserver._op_objectUpdated.begin(self, ((info, ), _response, _ex, _sent, _ctx))

        '''objectUpdated is called to notify an observer when
an object registered with the Admin interface was updated.

Arguments:
    info The details of the updated object.'''
        def end_objectUpdated(self, _r):
            return _M_IceGrid.ObjectObserver._op_objectUpdated.end(self, _r)

        '''objectRemoved is called to notify an observer when
an object registered with the Admin interface was removed.

Arguments:
    id The identity of the removed object.'''
        def objectRemoved(self, id, _ctx=None):
            return _M_IceGrid.ObjectObserver._op_objectRemoved.invoke(self, ((id, ), _ctx))

        '''objectRemoved is called to notify an observer when
an object registered with the Admin interface was removed.

Arguments:
    id The identity of the removed object.'''
        def begin_objectRemoved(self, id, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.ObjectObserver._op_objectRemoved.begin(self, ((id, ), _response, _ex, _sent, _ctx))

        '''objectRemoved is called to notify an observer when
an object registered with the Admin interface was removed.

Arguments:
    id The identity of the removed object.'''
        def end_objectRemoved(self, _r):
            return _M_IceGrid.ObjectObserver._op_objectRemoved.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceGrid.ObjectObserverPrx.ice_checkedCast(proxy, '::IceGrid::ObjectObserver', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceGrid.ObjectObserverPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceGrid::ObjectObserver'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceGrid._t_ObjectObserverPrx = IcePy.defineProxy('::IceGrid::ObjectObserver', ObjectObserverPrx)

    _M_IceGrid._t_ObjectObserver = IcePy.defineClass('::IceGrid::ObjectObserver', ObjectObserver, -1, (), True, False, None, (), ())
    ObjectObserver._ice_type = _M_IceGrid._t_ObjectObserver

    ObjectObserver._op_objectInit = IcePy.Operation('objectInit', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_IceGrid._t_ObjectInfoSeq, False, 0),), (), None, ())
    ObjectObserver._op_objectAdded = IcePy.Operation('objectAdded', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_IceGrid._t_ObjectInfo, False, 0),), (), None, ())
    ObjectObserver._op_objectUpdated = IcePy.Operation('objectUpdated', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_IceGrid._t_ObjectInfo, False, 0),), (), None, ())
    ObjectObserver._op_objectRemoved = IcePy.Operation('objectRemoved', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_Ice._t_Identity, False, 0),), (), None, ())

    _M_IceGrid.ObjectObserver = ObjectObserver
    del ObjectObserver

    _M_IceGrid.ObjectObserverPrx = ObjectObserverPrx
    del ObjectObserverPrx

if 'RegistryObserver' not in _M_IceGrid.__dict__:
    _M_IceGrid.RegistryObserver = Ice.createTempClass()
    class RegistryObserver(Ice.Object):
        '''This interface allows applications to monitor changes the state
of the registry.'''
        def __init__(self):
            if Ice.getType(self) == _M_IceGrid.RegistryObserver:
                raise RuntimeError('IceGrid.RegistryObserver is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceGrid::RegistryObserver')

        def ice_id(self, current=None):
            return '::IceGrid::RegistryObserver'

        def ice_staticId():
            return '::IceGrid::RegistryObserver'
        ice_staticId = staticmethod(ice_staticId)

        def registryInit(self, registries, current=None):
            '''The registryInit operation is called after registration of
an observer to indicate the state of the registries.

Arguments:
    registries The current state of the registries.'''
            pass

        def registryUp(self, node, current=None):
            '''The nodeUp operation is called to notify an observer that a node
came up.

Arguments:
    node The node state.'''
            pass

        def registryDown(self, name, current=None):
            '''The nodeDown operation is called to notify an observer that a node
went down.

Arguments:
    name The node name.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_RegistryObserver)

        __repr__ = __str__

    _M_IceGrid.RegistryObserverPrx = Ice.createTempClass()
    class RegistryObserverPrx(Ice.ObjectPrx):

        '''The registryInit operation is called after registration of
an observer to indicate the state of the registries.

Arguments:
    registries The current state of the registries.'''
        def registryInit(self, registries, _ctx=None):
            return _M_IceGrid.RegistryObserver._op_registryInit.invoke(self, ((registries, ), _ctx))

        '''The registryInit operation is called after registration of
an observer to indicate the state of the registries.

Arguments:
    registries The current state of the registries.'''
        def begin_registryInit(self, registries, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.RegistryObserver._op_registryInit.begin(self, ((registries, ), _response, _ex, _sent, _ctx))

        '''The registryInit operation is called after registration of
an observer to indicate the state of the registries.

Arguments:
    registries The current state of the registries.'''
        def end_registryInit(self, _r):
            return _M_IceGrid.RegistryObserver._op_registryInit.end(self, _r)

        '''The nodeUp operation is called to notify an observer that a node
came up.

Arguments:
    node The node state.'''
        def registryUp(self, node, _ctx=None):
            return _M_IceGrid.RegistryObserver._op_registryUp.invoke(self, ((node, ), _ctx))

        '''The nodeUp operation is called to notify an observer that a node
came up.

Arguments:
    node The node state.'''
        def begin_registryUp(self, node, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.RegistryObserver._op_registryUp.begin(self, ((node, ), _response, _ex, _sent, _ctx))

        '''The nodeUp operation is called to notify an observer that a node
came up.

Arguments:
    node The node state.'''
        def end_registryUp(self, _r):
            return _M_IceGrid.RegistryObserver._op_registryUp.end(self, _r)

        '''The nodeDown operation is called to notify an observer that a node
went down.

Arguments:
    name The node name.'''
        def registryDown(self, name, _ctx=None):
            return _M_IceGrid.RegistryObserver._op_registryDown.invoke(self, ((name, ), _ctx))

        '''The nodeDown operation is called to notify an observer that a node
went down.

Arguments:
    name The node name.'''
        def begin_registryDown(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.RegistryObserver._op_registryDown.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        '''The nodeDown operation is called to notify an observer that a node
went down.

Arguments:
    name The node name.'''
        def end_registryDown(self, _r):
            return _M_IceGrid.RegistryObserver._op_registryDown.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceGrid.RegistryObserverPrx.ice_checkedCast(proxy, '::IceGrid::RegistryObserver', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceGrid.RegistryObserverPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceGrid::RegistryObserver'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceGrid._t_RegistryObserverPrx = IcePy.defineProxy('::IceGrid::RegistryObserver', RegistryObserverPrx)

    _M_IceGrid._t_RegistryObserver = IcePy.defineClass('::IceGrid::RegistryObserver', RegistryObserver, -1, (), True, False, None, (), ())
    RegistryObserver._ice_type = _M_IceGrid._t_RegistryObserver

    RegistryObserver._op_registryInit = IcePy.Operation('registryInit', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_IceGrid._t_RegistryInfoSeq, False, 0),), (), None, ())
    RegistryObserver._op_registryUp = IcePy.Operation('registryUp', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_IceGrid._t_RegistryInfo, False, 0),), (), None, ())
    RegistryObserver._op_registryDown = IcePy.Operation('registryDown', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0),), (), None, ())

    _M_IceGrid.RegistryObserver = RegistryObserver
    del RegistryObserver

    _M_IceGrid.RegistryObserverPrx = RegistryObserverPrx
    del RegistryObserverPrx

# End of module IceGrid

Ice.sliceChecksums["::IceGrid::AdapterDynamicInfo"] = "b371e9a58f115e6ebfbcda735fee57f7"
Ice.sliceChecksums["::IceGrid::AdapterDynamicInfoSeq"] = "54465843167a2f93fa96d13b7f41ea32"
Ice.sliceChecksums["::IceGrid::AdapterObserver"] = "7f4ed59e236da9d6c35ad7e6ad9cb0"
Ice.sliceChecksums["::IceGrid::ApplicationObserver"] = "2862cdcba54714282f68b13a8fb4ae"
Ice.sliceChecksums["::IceGrid::NodeDynamicInfo"] = "3ad52341f32973212d26a9a6dda08b"
Ice.sliceChecksums["::IceGrid::NodeDynamicInfoSeq"] = "f61633c5e3992f718dba78b7f165c2"
Ice.sliceChecksums["::IceGrid::NodeObserver"] = "e06c1ad6807d2876de9e818855a65738"
Ice.sliceChecksums["::IceGrid::ObjectObserver"] = "5364683a872f127e46cc5e215d98c3c"
Ice.sliceChecksums["::IceGrid::RegistryObserver"] = "fd83b1558e7c77f2d322b25449518"
Ice.sliceChecksums["::IceGrid::ServerDynamicInfo"] = "fd4b9177ca54ae4688b51fa51d6870"
Ice.sliceChecksums["::IceGrid::ServerDynamicInfoSeq"] = "e3fda58997d5cd946e78cae739174cb"
