# **********************************************************************
#
# Copyright (c) 2003-2015 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.1
#
# <auto-generated>
#
# Generated from file `Connection.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

import Ice, IcePy
import Ice_ObjectAdapterF_ice
import Ice_Identity_ice
import Ice_Endpoint_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Start of module Ice
__name__ = 'Ice'

if 'ConnectionInfo' not in _M_Ice.__dict__:
    _M_Ice.ConnectionInfo = Ice.createTempClass()
    class ConnectionInfo(object):
        '''Base class providing access to the connection details. *'''
        def __init__(self, incoming=False, adapterName='', connectionId='', rcvSize=0, sndSize=0):
            self.incoming = incoming
            self.adapterName = adapterName
            self.connectionId = connectionId
            self.rcvSize = rcvSize
            self.sndSize = sndSize

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_ConnectionInfo)

        __repr__ = __str__

    _M_Ice._t_ConnectionInfo = IcePy.defineClass('::Ice::ConnectionInfo', ConnectionInfo, -1, (), False, False, None, (), (
        ('incoming', (), IcePy._t_bool, False, 0),
        ('adapterName', (), IcePy._t_string, False, 0),
        ('connectionId', (), IcePy._t_string, False, 0),
        ('rcvSize', (), IcePy._t_int, False, 0),
        ('sndSize', (), IcePy._t_int, False, 0)
    ))
    ConnectionInfo._ice_type = _M_Ice._t_ConnectionInfo

    _M_Ice.ConnectionInfo = ConnectionInfo
    del ConnectionInfo

if 'Connection' not in _M_Ice.__dict__:
    _M_Ice._t_Connection = IcePy.declareClass('::Ice::Connection')

if 'ConnectionCallback' not in _M_Ice.__dict__:
    _M_Ice.ConnectionCallback = Ice.createTempClass()
    class ConnectionCallback(object):
        '''An application can implement this interface to receive notifications when
a connection closes or receives a heartbeat message.'''
        def __init__(self):
            if Ice.getType(self) == _M_Ice.ConnectionCallback:
                raise RuntimeError('Ice.ConnectionCallback is an abstract class')

        def heartbeat(self, con):
            '''This method is called by the the connection when a heartbeat is
received from the peer.'''
            pass

        def closed(self, con):
            '''This method is called by the the connection when the connection
is closed.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_ConnectionCallback)

        __repr__ = __str__

    _M_Ice._t_ConnectionCallback = IcePy.defineClass('::Ice::ConnectionCallback', ConnectionCallback, -1, (), True, False, None, (), ())
    ConnectionCallback._ice_type = _M_Ice._t_ConnectionCallback

    _M_Ice.ConnectionCallback = ConnectionCallback
    del ConnectionCallback

if 'ACMClose' not in _M_Ice.__dict__:
    _M_Ice.ACMClose = Ice.createTempClass()
    class ACMClose(Ice.EnumBase):

        def __init__(self, _n, _v):
            Ice.EnumBase.__init__(self, _n, _v)

        def valueOf(self, _n):
            if _n in self._enumerators:
                return self._enumerators[_n]
            return None
        valueOf = classmethod(valueOf)

    ACMClose.CloseOff = ACMClose("CloseOff", 0)
    ACMClose.CloseOnIdle = ACMClose("CloseOnIdle", 1)
    ACMClose.CloseOnInvocation = ACMClose("CloseOnInvocation", 2)
    ACMClose.CloseOnInvocationAndIdle = ACMClose("CloseOnInvocationAndIdle", 3)
    ACMClose.CloseOnIdleForceful = ACMClose("CloseOnIdleForceful", 4)
    ACMClose._enumerators = { 0:ACMClose.CloseOff, 1:ACMClose.CloseOnIdle, 2:ACMClose.CloseOnInvocation, 3:ACMClose.CloseOnInvocationAndIdle, 4:ACMClose.CloseOnIdleForceful }

    _M_Ice._t_ACMClose = IcePy.defineEnum('::Ice::ACMClose', ACMClose, (), ACMClose._enumerators)

    _M_Ice.ACMClose = ACMClose
    del ACMClose

if 'ACMHeartbeat' not in _M_Ice.__dict__:
    _M_Ice.ACMHeartbeat = Ice.createTempClass()
    class ACMHeartbeat(Ice.EnumBase):

        def __init__(self, _n, _v):
            Ice.EnumBase.__init__(self, _n, _v)

        def valueOf(self, _n):
            if _n in self._enumerators:
                return self._enumerators[_n]
            return None
        valueOf = classmethod(valueOf)

    ACMHeartbeat.HeartbeatOff = ACMHeartbeat("HeartbeatOff", 0)
    ACMHeartbeat.HeartbeatOnInvocation = ACMHeartbeat("HeartbeatOnInvocation", 1)
    ACMHeartbeat.HeartbeatOnIdle = ACMHeartbeat("HeartbeatOnIdle", 2)
    ACMHeartbeat.HeartbeatAlways = ACMHeartbeat("HeartbeatAlways", 3)
    ACMHeartbeat._enumerators = { 0:ACMHeartbeat.HeartbeatOff, 1:ACMHeartbeat.HeartbeatOnInvocation, 2:ACMHeartbeat.HeartbeatOnIdle, 3:ACMHeartbeat.HeartbeatAlways }

    _M_Ice._t_ACMHeartbeat = IcePy.defineEnum('::Ice::ACMHeartbeat', ACMHeartbeat, (), ACMHeartbeat._enumerators)

    _M_Ice.ACMHeartbeat = ACMHeartbeat
    del ACMHeartbeat

if 'ACM' not in _M_Ice.__dict__:
    _M_Ice.ACM = Ice.createTempClass()
    class ACM(object):
        def __init__(self, timeout=0, close=_M_Ice.ACMClose.CloseOff, heartbeat=_M_Ice.ACMHeartbeat.HeartbeatOff):
            self.timeout = timeout
            self.close = close
            self.heartbeat = heartbeat

        def __hash__(self):
            _h = 0
            _h = 5 * _h + Ice.getHash(self.timeout)
            _h = 5 * _h + Ice.getHash(self.close)
            _h = 5 * _h + Ice.getHash(self.heartbeat)
            return _h % 0x7fffffff

        def __compare(self, other):
            if other is None:
                return 1
            elif not isinstance(other, _M_Ice.ACM):
                return NotImplemented
            else:
                if self.timeout is None or other.timeout is None:
                    if self.timeout != other.timeout:
                        return (-1 if self.timeout is None else 1)
                else:
                    if self.timeout < other.timeout:
                        return -1
                    elif self.timeout > other.timeout:
                        return 1
                if self.close is None or other.close is None:
                    if self.close != other.close:
                        return (-1 if self.close is None else 1)
                else:
                    if self.close < other.close:
                        return -1
                    elif self.close > other.close:
                        return 1
                if self.heartbeat is None or other.heartbeat is None:
                    if self.heartbeat != other.heartbeat:
                        return (-1 if self.heartbeat is None else 1)
                else:
                    if self.heartbeat < other.heartbeat:
                        return -1
                    elif self.heartbeat > other.heartbeat:
                        return 1
                return 0

        def __lt__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r < 0

        def __le__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r <= 0

        def __gt__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r > 0

        def __ge__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r >= 0

        def __eq__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r == 0

        def __ne__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r != 0

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_ACM)

        __repr__ = __str__

    _M_Ice._t_ACM = IcePy.defineStruct('::Ice::ACM', ACM, (), (
        ('timeout', (), IcePy._t_int),
        ('close', (), _M_Ice._t_ACMClose),
        ('heartbeat', (), _M_Ice._t_ACMHeartbeat)
    ))

    _M_Ice.ACM = ACM
    del ACM

if 'Connection' not in _M_Ice.__dict__:
    _M_Ice.Connection = Ice.createTempClass()
    class Connection(object):
        '''The user-level interface to a connection.'''
        def __init__(self):
            if Ice.getType(self) == _M_Ice.Connection:
                raise RuntimeError('Ice.Connection is an abstract class')

        def close(self, force):
            '''Close a connection, either gracefully or forcefully. If a
connection is closed forcefully, it closes immediately, without
sending the relevant close connection protocol messages to the
peer and waiting for the peer to acknowledge these protocol
messages.

Arguments:
    force If true, close forcefully. Otherwise the
connection is closed gracefully.'''
            pass

        def createProxy(self, id):
            '''Create a special proxy that always uses this connection. This
can be used for callbacks from a server to a client if the
server cannot directly establish a connection to the client,
for example because of firewalls. In this case, the server
would create a proxy using an already established connection
from the client.

Arguments:
    id The identity for which a proxy is to be created.

Returns:
    A proxy that matches the given identity and uses this
connection.'''
            pass

        def setAdapter(self, adapter):
            '''Explicitly set an object adapter that dispatches requests that
are received over this connection. A client can invoke an
operation on a server using a proxy, and then set an object
adapter for the outgoing connection that is used by the proxy
in order to receive callbacks. This is useful if the server
cannot establish a connection back to the client, for example
because of firewalls.

Arguments:
    adapter The object adapter that should be used by this
connection to dispatch requests. The object adapter must be
activated. When the object adapter is deactivated, it is
automatically removed from the connection.'''
            pass

        def getAdapter(self):
            '''Get the object adapter that dispatches requests for this
connection.

Returns:
    The object adapter that dispatches requests for the
connection, or null if no adapter is set.'''
            pass

        def getEndpoint(self):
            '''Get the endpoint from which the connection was created.

Returns:
    The endpoint from which the connection was created.'''
            pass

        def flushBatchRequests(self):
            '''Flush any pending batch requests for this connection.
This means all batch requests invoked on fixed proxies
associated with the connection.'''
            pass

        def setCallback(self, callback):
            '''Set callback on the connection. The callback is called by the
connection when it's closed. The callback is called from the
Ice thread pool associated with the connection.

Arguments:
    callback The connection callback object.'''
            pass

        def setACM(self, timeout, close, heartbeat):
            '''Set the active connection management parameters.

Arguments:
    timeout The timeout value in milliseconds.

    close The close condition

    heartbeat The hertbeat condition'''
            pass

        def getACM(self):
            '''Get the ACM parameters.

Returns:
    The ACM parameters.'''
            pass

        def type(self):
            '''Return the connection type. This corresponds to the endpoint
type, i.e., "tcp", "udp", etc.

Returns:
    The type of the connection.'''
            pass

        def timeout(self):
            '''Get the timeout for the connection.

Returns:
    The connection's timeout.'''
            pass

        def toString(self):
            '''Return a description of the connection as human readable text,
suitable for logging or error messages.

Returns:
    The description of the connection as human readable
text.'''
            pass

        def getInfo(self):
            '''Returns the connection information.

Returns:
    The connection information.'''
            pass

        def setBufferSize(self, rcvSize, sndSize):
            '''Set the connectiion buffer receive/send size.

@rcvSize The connection receive buffer size.
@sndSize The connection send buffer size.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_Connection)

        __repr__ = __str__

    _M_Ice._t_Connection = IcePy.defineClass('::Ice::Connection', Connection, -1, (), True, False, None, (), ())
    Connection._ice_type = _M_Ice._t_Connection

    _M_Ice.Connection = Connection
    del Connection

if 'IPConnectionInfo' not in _M_Ice.__dict__:
    _M_Ice.IPConnectionInfo = Ice.createTempClass()
    class IPConnectionInfo(_M_Ice.ConnectionInfo):
        '''Provides access to the connection details of an IP connection'''
        def __init__(self, incoming=False, adapterName='', connectionId='', rcvSize=0, sndSize=0, localAddress="", localPort=-1, remoteAddress="", remotePort=-1):
            _M_Ice.ConnectionInfo.__init__(self, incoming, adapterName, connectionId, rcvSize, sndSize)
            self.localAddress = localAddress
            self.localPort = localPort
            self.remoteAddress = remoteAddress
            self.remotePort = remotePort

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_IPConnectionInfo)

        __repr__ = __str__

    _M_Ice._t_IPConnectionInfo = IcePy.defineClass('::Ice::IPConnectionInfo', IPConnectionInfo, -1, (), False, False, _M_Ice._t_ConnectionInfo, (), (
        ('localAddress', (), IcePy._t_string, False, 0),
        ('localPort', (), IcePy._t_int, False, 0),
        ('remoteAddress', (), IcePy._t_string, False, 0),
        ('remotePort', (), IcePy._t_int, False, 0)
    ))
    IPConnectionInfo._ice_type = _M_Ice._t_IPConnectionInfo

    _M_Ice.IPConnectionInfo = IPConnectionInfo
    del IPConnectionInfo

if 'TCPConnectionInfo' not in _M_Ice.__dict__:
    _M_Ice.TCPConnectionInfo = Ice.createTempClass()
    class TCPConnectionInfo(_M_Ice.IPConnectionInfo):
        '''Provides access to the connection details of a TCP connection'''
        def __init__(self, incoming=False, adapterName='', connectionId='', rcvSize=0, sndSize=0, localAddress="", localPort=-1, remoteAddress="", remotePort=-1):
            _M_Ice.IPConnectionInfo.__init__(self, incoming, adapterName, connectionId, rcvSize, sndSize, localAddress, localPort, remoteAddress, remotePort)

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_TCPConnectionInfo)

        __repr__ = __str__

    _M_Ice._t_TCPConnectionInfo = IcePy.defineClass('::Ice::TCPConnectionInfo', TCPConnectionInfo, -1, (), False, False, _M_Ice._t_IPConnectionInfo, (), ())
    TCPConnectionInfo._ice_type = _M_Ice._t_TCPConnectionInfo

    _M_Ice.TCPConnectionInfo = TCPConnectionInfo
    del TCPConnectionInfo

if 'UDPConnectionInfo' not in _M_Ice.__dict__:
    _M_Ice.UDPConnectionInfo = Ice.createTempClass()
    class UDPConnectionInfo(_M_Ice.IPConnectionInfo):
        '''Provides access to the connection details of a UDP connection'''
        def __init__(self, incoming=False, adapterName='', connectionId='', rcvSize=0, sndSize=0, localAddress="", localPort=-1, remoteAddress="", remotePort=-1, mcastAddress='', mcastPort=-1):
            _M_Ice.IPConnectionInfo.__init__(self, incoming, adapterName, connectionId, rcvSize, sndSize, localAddress, localPort, remoteAddress, remotePort)
            self.mcastAddress = mcastAddress
            self.mcastPort = mcastPort

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_UDPConnectionInfo)

        __repr__ = __str__

    _M_Ice._t_UDPConnectionInfo = IcePy.defineClass('::Ice::UDPConnectionInfo', UDPConnectionInfo, -1, (), False, False, _M_Ice._t_IPConnectionInfo, (), (
        ('mcastAddress', (), IcePy._t_string, False, 0),
        ('mcastPort', (), IcePy._t_int, False, 0)
    ))
    UDPConnectionInfo._ice_type = _M_Ice._t_UDPConnectionInfo

    _M_Ice.UDPConnectionInfo = UDPConnectionInfo
    del UDPConnectionInfo

if '_t_HeaderDict' not in _M_Ice.__dict__:
    _M_Ice._t_HeaderDict = IcePy.defineDictionary('::Ice::HeaderDict', (), IcePy._t_string, IcePy._t_string)

if 'WSConnectionInfo' not in _M_Ice.__dict__:
    _M_Ice.WSConnectionInfo = Ice.createTempClass()
    class WSConnectionInfo(_M_Ice.TCPConnectionInfo):
        '''Provides access to the connection details of a WebSocket connection'''
        def __init__(self, incoming=False, adapterName='', connectionId='', rcvSize=0, sndSize=0, localAddress="", localPort=-1, remoteAddress="", remotePort=-1, headers=None):
            _M_Ice.TCPConnectionInfo.__init__(self, incoming, adapterName, connectionId, rcvSize, sndSize, localAddress, localPort, remoteAddress, remotePort)
            self.headers = headers

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_WSConnectionInfo)

        __repr__ = __str__

    _M_Ice._t_WSConnectionInfo = IcePy.defineClass('::Ice::WSConnectionInfo', WSConnectionInfo, -1, (), False, False, _M_Ice._t_TCPConnectionInfo, (), (('headers', (), _M_Ice._t_HeaderDict, False, 0),))
    WSConnectionInfo._ice_type = _M_Ice._t_WSConnectionInfo

    _M_Ice.WSConnectionInfo = WSConnectionInfo
    del WSConnectionInfo

# End of module Ice
