// **********************************************************************
//
// Copyright (c) 2003-2015 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.1
//
// <auto-generated>
//
// Generated from file `RemoteLogger.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Ice_RemoteLogger_h__
#define __Ice_RemoteLogger_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Proxy.h>
#include <Ice/GCObject.h>
#include <Ice/AsyncResult.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <IceUtil/Optional.h>
#include <Ice/StreamF.h>
#include <Ice/BuiltinSequences.h>
#include <IceUtil/UndefSysMacros.h>
#include <list>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 306
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 1
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICE_API
#   ifdef ICE_API_EXPORTS
#       define ICE_API ICE_DECLSPEC_EXPORT
#   elif defined(ICE_STATIC_LIBS)
#       define ICE_API /**/
#   else
#       define ICE_API ICE_DECLSPEC_IMPORT
#   endif
#endif

namespace IceProxy
{

namespace Ice
{

class RemoteLogger;
ICE_API void __read(::IceInternal::BasicStream*, ::IceInternal::ProxyHandle< ::IceProxy::Ice::RemoteLogger>&);
ICE_API ::IceProxy::Ice::Object* upCast(::IceProxy::Ice::RemoteLogger*);

class LoggerAdmin;
ICE_API void __read(::IceInternal::BasicStream*, ::IceInternal::ProxyHandle< ::IceProxy::Ice::LoggerAdmin>&);
ICE_API ::IceProxy::Ice::Object* upCast(::IceProxy::Ice::LoggerAdmin*);

}

}

namespace Ice
{

class RemoteLogger;
bool operator==(const RemoteLogger&, const RemoteLogger&);
bool operator<(const RemoteLogger&, const RemoteLogger&);
ICE_API ::Ice::Object* upCast(::Ice::RemoteLogger*);
typedef ::IceInternal::Handle< ::Ice::RemoteLogger> RemoteLoggerPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Ice::RemoteLogger> RemoteLoggerPrx;
ICE_API void __patch(RemoteLoggerPtr&, const ::Ice::ObjectPtr&);

class LoggerAdmin;
bool operator==(const LoggerAdmin&, const LoggerAdmin&);
bool operator<(const LoggerAdmin&, const LoggerAdmin&);
ICE_API ::Ice::Object* upCast(::Ice::LoggerAdmin*);
typedef ::IceInternal::Handle< ::Ice::LoggerAdmin> LoggerAdminPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Ice::LoggerAdmin> LoggerAdminPrx;
ICE_API void __patch(LoggerAdminPtr&, const ::Ice::ObjectPtr&);

}

namespace Ice
{

enum LogMessageType
{
    PrintMessage,
    TraceMessage,
    WarningMessage,
    ErrorMessage
};

typedef ::std::vector< ::Ice::LogMessageType> LogMessageTypeSeq;

struct LogMessage
{
    ::Ice::LogMessageType type;
    ::Ice::Long timestamp;
    ::std::string traceCategory;
    ::std::string message;

    bool operator==(const LogMessage& __rhs) const
    {
        if(this == &__rhs)
        {
            return true;
        }
        if(type != __rhs.type)
        {
            return false;
        }
        if(timestamp != __rhs.timestamp)
        {
            return false;
        }
        if(traceCategory != __rhs.traceCategory)
        {
            return false;
        }
        if(message != __rhs.message)
        {
            return false;
        }
        return true;
    }

    bool operator<(const LogMessage& __rhs) const
    {
        if(this == &__rhs)
        {
            return false;
        }
        if(type < __rhs.type)
        {
            return true;
        }
        else if(__rhs.type < type)
        {
            return false;
        }
        if(timestamp < __rhs.timestamp)
        {
            return true;
        }
        else if(__rhs.timestamp < timestamp)
        {
            return false;
        }
        if(traceCategory < __rhs.traceCategory)
        {
            return true;
        }
        else if(__rhs.traceCategory < traceCategory)
        {
            return false;
        }
        if(message < __rhs.message)
        {
            return true;
        }
        else if(__rhs.message < message)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const LogMessage& __rhs) const
    {
        return !operator==(__rhs);
    }
    bool operator<=(const LogMessage& __rhs) const
    {
        return operator<(__rhs) || operator==(__rhs);
    }
    bool operator>(const LogMessage& __rhs) const
    {
        return !operator<(__rhs) && !operator==(__rhs);
    }
    bool operator>=(const LogMessage& __rhs) const
    {
        return !operator<(__rhs);
    }
};

typedef std::list<LogMessage> LogMessageSeq;

class ICE_API RemoteLoggerAlreadyAttachedException : public ::Ice::UserException
{
public:

    RemoteLoggerAlreadyAttachedException() {}
    virtual ~RemoteLoggerAlreadyAttachedException() throw();

    virtual ::std::string ice_name() const;
    virtual RemoteLoggerAlreadyAttachedException* ice_clone() const;
    virtual void ice_throw() const;

protected:
    virtual void __writeImpl(::IceInternal::BasicStream*) const;
    virtual void __readImpl(::IceInternal::BasicStream*);
    using ::Ice::UserException::__writeImpl;
    using ::Ice::UserException::__readImpl;
};

static RemoteLoggerAlreadyAttachedException __RemoteLoggerAlreadyAttachedException_init;

}

namespace Ice
{
template<>
struct StreamableTraits< ::Ice::LogMessageType>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 3;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

template<>
struct StreamableTraits< ::Ice::LogMessage>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 11;
    static const bool fixedLength = false;
};

template<class S>
struct StreamWriter< ::Ice::LogMessage, S>
{
    static void write(S* __os, const ::Ice::LogMessage& v)
    {
        __os->write(v.type);
        __os->write(v.timestamp);
        __os->write(v.traceCategory);
        __os->write(v.message);
    }
};

template<class S>
struct StreamReader< ::Ice::LogMessage, S>
{
    static void read(S* __is, ::Ice::LogMessage& v)
    {
        __is->read(v.type);
        __is->read(v.timestamp);
        __is->read(v.traceCategory);
        __is->read(v.message);
    }
};

#if defined(ICE_HAS_DECLSPEC_IMPORT_EXPORT) && !defined(ICE_API_EXPORTS) && !defined(ICE_STATIC_LIBS)
template struct ICE_API StreamWriter< ::Ice::LogMessage, ::IceInternal::BasicStream>;
template struct ICE_API StreamReader< ::Ice::LogMessage, ::IceInternal::BasicStream>;
#endif

template<>
struct StreamableTraits< ::Ice::RemoteLoggerAlreadyAttachedException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

}

namespace Ice
{

class Callback_RemoteLogger_init_Base : virtual public ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_RemoteLogger_init_Base> Callback_RemoteLogger_initPtr;

class Callback_RemoteLogger_log_Base : virtual public ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_RemoteLogger_log_Base> Callback_RemoteLogger_logPtr;

class Callback_LoggerAdmin_attachRemoteLogger_Base : virtual public ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LoggerAdmin_attachRemoteLogger_Base> Callback_LoggerAdmin_attachRemoteLoggerPtr;

class Callback_LoggerAdmin_detachRemoteLogger_Base : virtual public ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LoggerAdmin_detachRemoteLogger_Base> Callback_LoggerAdmin_detachRemoteLoggerPtr;

class Callback_LoggerAdmin_getLog_Base : virtual public ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LoggerAdmin_getLog_Base> Callback_LoggerAdmin_getLogPtr;

}

namespace IceProxy
{

namespace Ice
{

class ICE_API RemoteLogger : virtual public ::IceProxy::Ice::Object
{
public:

    void init(const ::std::string& __p_prefix, const ::Ice::LogMessageSeq& __p_logMessages)
    {
        init(__p_prefix, __p_logMessages, 0);
    }
    void init(const ::std::string& __p_prefix, const ::Ice::LogMessageSeq& __p_logMessages, const ::Ice::Context& __ctx)
    {
        init(__p_prefix, __p_logMessages, &__ctx);
    }
#ifdef ICE_CPP11
    ::Ice::AsyncResultPtr
    begin_init(const ::std::string& __p_prefix, const ::Ice::LogMessageSeq& __p_logMessages, const ::IceInternal::Function<void ()>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception = ::IceInternal::Function<void (const ::Ice::Exception&)>(), const ::IceInternal::Function<void (bool)>& __sent = ::IceInternal::Function<void (bool)>())
    {
        return begin_init(__p_prefix, __p_logMessages, 0, new ::IceInternal::Cpp11FnOnewayCallbackNC(__response, __exception, __sent));
    }
    ::Ice::AsyncResultPtr
    begin_init(const ::std::string& __p_prefix, const ::Ice::LogMessageSeq& __p_logMessages, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __completed, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __sent = ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>())
    {
        return begin_init(__p_prefix, __p_logMessages, 0, ::Ice::newCallback(__completed, __sent), 0);
    }
    ::Ice::AsyncResultPtr
    begin_init(const ::std::string& __p_prefix, const ::Ice::LogMessageSeq& __p_logMessages, const ::Ice::Context& __ctx, const ::IceInternal::Function<void ()>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception = ::IceInternal::Function<void (const ::Ice::Exception&)>(), const ::IceInternal::Function<void (bool)>& __sent = ::IceInternal::Function<void (bool)>())
    {
        return begin_init(__p_prefix, __p_logMessages, &__ctx, new ::IceInternal::Cpp11FnOnewayCallbackNC(__response, __exception, __sent), 0);
    }
    ::Ice::AsyncResultPtr
    begin_init(const ::std::string& __p_prefix, const ::Ice::LogMessageSeq& __p_logMessages, const ::Ice::Context& __ctx, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __completed, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __sent = ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>())
    {
        return begin_init(__p_prefix, __p_logMessages, &__ctx, ::Ice::newCallback(__completed, __sent));
    }
#endif

    ::Ice::AsyncResultPtr begin_init(const ::std::string& __p_prefix, const ::Ice::LogMessageSeq& __p_logMessages)
    {
        return begin_init(__p_prefix, __p_logMessages, 0, ::IceInternal::__dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_init(const ::std::string& __p_prefix, const ::Ice::LogMessageSeq& __p_logMessages, const ::Ice::Context& __ctx)
    {
        return begin_init(__p_prefix, __p_logMessages, &__ctx, ::IceInternal::__dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_init(const ::std::string& __p_prefix, const ::Ice::LogMessageSeq& __p_logMessages, const ::Ice::CallbackPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_init(__p_prefix, __p_logMessages, 0, __del, __cookie);
    }

    ::Ice::AsyncResultPtr begin_init(const ::std::string& __p_prefix, const ::Ice::LogMessageSeq& __p_logMessages, const ::Ice::Context& __ctx, const ::Ice::CallbackPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_init(__p_prefix, __p_logMessages, &__ctx, __del, __cookie);
    }

    ::Ice::AsyncResultPtr begin_init(const ::std::string& __p_prefix, const ::Ice::LogMessageSeq& __p_logMessages, const ::Ice::Callback_RemoteLogger_initPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_init(__p_prefix, __p_logMessages, 0, __del, __cookie);
    }

    ::Ice::AsyncResultPtr begin_init(const ::std::string& __p_prefix, const ::Ice::LogMessageSeq& __p_logMessages, const ::Ice::Context& __ctx, const ::Ice::Callback_RemoteLogger_initPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_init(__p_prefix, __p_logMessages, &__ctx, __del, __cookie);
    }

    void end_init(const ::Ice::AsyncResultPtr&);
    
private:

    void init(const ::std::string&, const ::Ice::LogMessageSeq&, const ::Ice::Context*);
    ::Ice::AsyncResultPtr begin_init(const ::std::string&, const ::Ice::LogMessageSeq&, const ::Ice::Context*, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& __cookie = 0);
    
public:

    void log(const ::Ice::LogMessage& __p_message)
    {
        log(__p_message, 0);
    }
    void log(const ::Ice::LogMessage& __p_message, const ::Ice::Context& __ctx)
    {
        log(__p_message, &__ctx);
    }
#ifdef ICE_CPP11
    ::Ice::AsyncResultPtr
    begin_log(const ::Ice::LogMessage& __p_message, const ::IceInternal::Function<void ()>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception = ::IceInternal::Function<void (const ::Ice::Exception&)>(), const ::IceInternal::Function<void (bool)>& __sent = ::IceInternal::Function<void (bool)>())
    {
        return begin_log(__p_message, 0, new ::IceInternal::Cpp11FnOnewayCallbackNC(__response, __exception, __sent));
    }
    ::Ice::AsyncResultPtr
    begin_log(const ::Ice::LogMessage& __p_message, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __completed, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __sent = ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>())
    {
        return begin_log(__p_message, 0, ::Ice::newCallback(__completed, __sent), 0);
    }
    ::Ice::AsyncResultPtr
    begin_log(const ::Ice::LogMessage& __p_message, const ::Ice::Context& __ctx, const ::IceInternal::Function<void ()>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception = ::IceInternal::Function<void (const ::Ice::Exception&)>(), const ::IceInternal::Function<void (bool)>& __sent = ::IceInternal::Function<void (bool)>())
    {
        return begin_log(__p_message, &__ctx, new ::IceInternal::Cpp11FnOnewayCallbackNC(__response, __exception, __sent), 0);
    }
    ::Ice::AsyncResultPtr
    begin_log(const ::Ice::LogMessage& __p_message, const ::Ice::Context& __ctx, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __completed, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __sent = ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>())
    {
        return begin_log(__p_message, &__ctx, ::Ice::newCallback(__completed, __sent));
    }
#endif

    ::Ice::AsyncResultPtr begin_log(const ::Ice::LogMessage& __p_message)
    {
        return begin_log(__p_message, 0, ::IceInternal::__dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_log(const ::Ice::LogMessage& __p_message, const ::Ice::Context& __ctx)
    {
        return begin_log(__p_message, &__ctx, ::IceInternal::__dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_log(const ::Ice::LogMessage& __p_message, const ::Ice::CallbackPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_log(__p_message, 0, __del, __cookie);
    }

    ::Ice::AsyncResultPtr begin_log(const ::Ice::LogMessage& __p_message, const ::Ice::Context& __ctx, const ::Ice::CallbackPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_log(__p_message, &__ctx, __del, __cookie);
    }

    ::Ice::AsyncResultPtr begin_log(const ::Ice::LogMessage& __p_message, const ::Ice::Callback_RemoteLogger_logPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_log(__p_message, 0, __del, __cookie);
    }

    ::Ice::AsyncResultPtr begin_log(const ::Ice::LogMessage& __p_message, const ::Ice::Context& __ctx, const ::Ice::Callback_RemoteLogger_logPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_log(__p_message, &__ctx, __del, __cookie);
    }

    void end_log(const ::Ice::AsyncResultPtr&);
    
private:

    void log(const ::Ice::LogMessage&, const ::Ice::Context*);
    ::Ice::AsyncResultPtr begin_log(const ::Ice::LogMessage&, const ::Ice::Context*, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& __cookie = 0);
    
public:
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_context(const ::Ice::Context& __context) const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_context(__context).get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_adapterId(const ::std::string& __id) const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_adapterId(__id).get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_endpoints(const ::Ice::EndpointSeq& __endpoints) const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_endpoints(__endpoints).get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_locatorCacheTimeout(int __timeout) const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_locatorCacheTimeout(__timeout).get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_connectionCached(bool __cached) const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_connectionCached(__cached).get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_endpointSelection(::Ice::EndpointSelectionType __est) const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_endpointSelection(__est).get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_secure(bool __secure) const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_secure(__secure).get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_preferSecure(bool __preferSecure) const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_preferSecure(__preferSecure).get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_router(const ::Ice::RouterPrx& __router) const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_router(__router).get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_locator(const ::Ice::LocatorPrx& __locator) const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_locator(__locator).get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_collocationOptimized(bool __co) const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_collocationOptimized(__co).get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_invocationTimeout(int __timeout) const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_invocationTimeout(__timeout).get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_twoway() const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_twoway().get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_oneway() const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_oneway().get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_batchOneway() const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_batchOneway().get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_datagram() const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_datagram().get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_batchDatagram() const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_batchDatagram().get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_compress(bool __compress) const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_compress(__compress).get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_timeout(int __timeout) const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_timeout(__timeout).get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_connectionId(const ::std::string& __id) const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_connectionId(__id).get());
    }
    
    ::IceInternal::ProxyHandle<RemoteLogger> ice_encodingVersion(const ::Ice::EncodingVersion& __v) const
    {
        return dynamic_cast<RemoteLogger*>(::IceProxy::Ice::Object::ice_encodingVersion(__v).get());
    }
    
    static const ::std::string& ice_staticId();

private: 
    virtual ::IceProxy::Ice::Object* __newInstance() const;
};

class ICE_API LoggerAdmin : virtual public ::IceProxy::Ice::Object
{
public:

    void attachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax)
    {
        attachRemoteLogger(__p_prx, __p_messageTypes, __p_traceCategories, __p_messageMax, 0);
    }
    void attachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Context& __ctx)
    {
        attachRemoteLogger(__p_prx, __p_messageTypes, __p_traceCategories, __p_messageMax, &__ctx);
    }
#ifdef ICE_CPP11
    ::Ice::AsyncResultPtr
    begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::IceInternal::Function<void ()>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception = ::IceInternal::Function<void (const ::Ice::Exception&)>(), const ::IceInternal::Function<void (bool)>& __sent = ::IceInternal::Function<void (bool)>())
    {
        return __begin_attachRemoteLogger(__p_prx, __p_messageTypes, __p_traceCategories, __p_messageMax, 0, __response, __exception, __sent);
    }
    ::Ice::AsyncResultPtr
    begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __completed, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __sent = ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>())
    {
        return begin_attachRemoteLogger(__p_prx, __p_messageTypes, __p_traceCategories, __p_messageMax, 0, ::Ice::newCallback(__completed, __sent), 0);
    }
    ::Ice::AsyncResultPtr
    begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Context& __ctx, const ::IceInternal::Function<void ()>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception = ::IceInternal::Function<void (const ::Ice::Exception&)>(), const ::IceInternal::Function<void (bool)>& __sent = ::IceInternal::Function<void (bool)>())
    {
        return __begin_attachRemoteLogger(__p_prx, __p_messageTypes, __p_traceCategories, __p_messageMax, &__ctx, __response, __exception, __sent);
    }
    ::Ice::AsyncResultPtr
    begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Context& __ctx, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __completed, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __sent = ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>())
    {
        return begin_attachRemoteLogger(__p_prx, __p_messageTypes, __p_traceCategories, __p_messageMax, &__ctx, ::Ice::newCallback(__completed, __sent));
    }
    
private:

    ::Ice::AsyncResultPtr __begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Context* __ctx, const ::IceInternal::Function<void ()>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception, const ::IceInternal::Function<void (bool)>& __sent);
    
public:
#endif

    ::Ice::AsyncResultPtr begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax)
    {
        return begin_attachRemoteLogger(__p_prx, __p_messageTypes, __p_traceCategories, __p_messageMax, 0, ::IceInternal::__dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Context& __ctx)
    {
        return begin_attachRemoteLogger(__p_prx, __p_messageTypes, __p_traceCategories, __p_messageMax, &__ctx, ::IceInternal::__dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::CallbackPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_attachRemoteLogger(__p_prx, __p_messageTypes, __p_traceCategories, __p_messageMax, 0, __del, __cookie);
    }

    ::Ice::AsyncResultPtr begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Context& __ctx, const ::Ice::CallbackPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_attachRemoteLogger(__p_prx, __p_messageTypes, __p_traceCategories, __p_messageMax, &__ctx, __del, __cookie);
    }

    ::Ice::AsyncResultPtr begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Callback_LoggerAdmin_attachRemoteLoggerPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_attachRemoteLogger(__p_prx, __p_messageTypes, __p_traceCategories, __p_messageMax, 0, __del, __cookie);
    }

    ::Ice::AsyncResultPtr begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Context& __ctx, const ::Ice::Callback_LoggerAdmin_attachRemoteLoggerPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_attachRemoteLogger(__p_prx, __p_messageTypes, __p_traceCategories, __p_messageMax, &__ctx, __del, __cookie);
    }

    void end_attachRemoteLogger(const ::Ice::AsyncResultPtr&);
    
private:

    void attachRemoteLogger(const ::Ice::RemoteLoggerPrx&, const ::Ice::LogMessageTypeSeq&, const ::Ice::StringSeq&, ::Ice::Int, const ::Ice::Context*);
    ::Ice::AsyncResultPtr begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx&, const ::Ice::LogMessageTypeSeq&, const ::Ice::StringSeq&, ::Ice::Int, const ::Ice::Context*, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& __cookie = 0);
    
public:

    bool detachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx)
    {
        return detachRemoteLogger(__p_prx, 0);
    }
    bool detachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::Context& __ctx)
    {
        return detachRemoteLogger(__p_prx, &__ctx);
    }
#ifdef ICE_CPP11
    ::Ice::AsyncResultPtr
    begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::IceInternal::Function<void (bool)>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception = ::IceInternal::Function<void (const ::Ice::Exception&)>(), const ::IceInternal::Function<void (bool)>& __sent = ::IceInternal::Function<void (bool)>())
    {
        return __begin_detachRemoteLogger(__p_prx, 0, __response, __exception, __sent);
    }
    ::Ice::AsyncResultPtr
    begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __completed, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __sent = ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>())
    {
        return begin_detachRemoteLogger(__p_prx, 0, ::Ice::newCallback(__completed, __sent), 0);
    }
    ::Ice::AsyncResultPtr
    begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::Context& __ctx, const ::IceInternal::Function<void (bool)>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception = ::IceInternal::Function<void (const ::Ice::Exception&)>(), const ::IceInternal::Function<void (bool)>& __sent = ::IceInternal::Function<void (bool)>())
    {
        return __begin_detachRemoteLogger(__p_prx, &__ctx, __response, __exception, __sent);
    }
    ::Ice::AsyncResultPtr
    begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::Context& __ctx, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __completed, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __sent = ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>())
    {
        return begin_detachRemoteLogger(__p_prx, &__ctx, ::Ice::newCallback(__completed, __sent));
    }
    
private:

    ::Ice::AsyncResultPtr __begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::Context* __ctx, const ::IceInternal::Function<void (bool)>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception, const ::IceInternal::Function<void (bool)>& __sent);
    
public:
#endif

    ::Ice::AsyncResultPtr begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx)
    {
        return begin_detachRemoteLogger(__p_prx, 0, ::IceInternal::__dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::Context& __ctx)
    {
        return begin_detachRemoteLogger(__p_prx, &__ctx, ::IceInternal::__dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::CallbackPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_detachRemoteLogger(__p_prx, 0, __del, __cookie);
    }

    ::Ice::AsyncResultPtr begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::Context& __ctx, const ::Ice::CallbackPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_detachRemoteLogger(__p_prx, &__ctx, __del, __cookie);
    }

    ::Ice::AsyncResultPtr begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::Callback_LoggerAdmin_detachRemoteLoggerPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_detachRemoteLogger(__p_prx, 0, __del, __cookie);
    }

    ::Ice::AsyncResultPtr begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::Context& __ctx, const ::Ice::Callback_LoggerAdmin_detachRemoteLoggerPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_detachRemoteLogger(__p_prx, &__ctx, __del, __cookie);
    }

    bool end_detachRemoteLogger(const ::Ice::AsyncResultPtr&);
    
private:

    bool detachRemoteLogger(const ::Ice::RemoteLoggerPrx&, const ::Ice::Context*);
    ::Ice::AsyncResultPtr begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx&, const ::Ice::Context*, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& __cookie = 0);
    
public:

    ::Ice::LogMessageSeq getLog(const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, ::std::string& __p_prefix)
    {
        return getLog(__p_messageTypes, __p_traceCategories, __p_messageMax, __p_prefix, 0);
    }
    ::Ice::LogMessageSeq getLog(const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, ::std::string& __p_prefix, const ::Ice::Context& __ctx)
    {
        return getLog(__p_messageTypes, __p_traceCategories, __p_messageMax, __p_prefix, &__ctx);
    }
#ifdef ICE_CPP11
    ::Ice::AsyncResultPtr
    begin_getLog(const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::IceInternal::Function<void (const ::Ice::LogMessageSeq&, const ::std::string&)>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception = ::IceInternal::Function<void (const ::Ice::Exception&)>(), const ::IceInternal::Function<void (bool)>& __sent = ::IceInternal::Function<void (bool)>())
    {
        return __begin_getLog(__p_messageTypes, __p_traceCategories, __p_messageMax, 0, __response, __exception, __sent);
    }
    ::Ice::AsyncResultPtr
    begin_getLog(const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __completed, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __sent = ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>())
    {
        return begin_getLog(__p_messageTypes, __p_traceCategories, __p_messageMax, 0, ::Ice::newCallback(__completed, __sent), 0);
    }
    ::Ice::AsyncResultPtr
    begin_getLog(const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Context& __ctx, const ::IceInternal::Function<void (const ::Ice::LogMessageSeq&, const ::std::string&)>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception = ::IceInternal::Function<void (const ::Ice::Exception&)>(), const ::IceInternal::Function<void (bool)>& __sent = ::IceInternal::Function<void (bool)>())
    {
        return __begin_getLog(__p_messageTypes, __p_traceCategories, __p_messageMax, &__ctx, __response, __exception, __sent);
    }
    ::Ice::AsyncResultPtr
    begin_getLog(const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Context& __ctx, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __completed, const ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>& __sent = ::IceInternal::Function<void (const ::Ice::AsyncResultPtr&)>())
    {
        return begin_getLog(__p_messageTypes, __p_traceCategories, __p_messageMax, &__ctx, ::Ice::newCallback(__completed, __sent));
    }
    
private:

    ::Ice::AsyncResultPtr __begin_getLog(const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Context* __ctx, const ::IceInternal::Function<void (const ::Ice::LogMessageSeq&, const ::std::string&)>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception, const ::IceInternal::Function<void (bool)>& __sent);
    
public:
#endif

    ::Ice::AsyncResultPtr begin_getLog(const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax)
    {
        return begin_getLog(__p_messageTypes, __p_traceCategories, __p_messageMax, 0, ::IceInternal::__dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getLog(const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Context& __ctx)
    {
        return begin_getLog(__p_messageTypes, __p_traceCategories, __p_messageMax, &__ctx, ::IceInternal::__dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getLog(const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::CallbackPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_getLog(__p_messageTypes, __p_traceCategories, __p_messageMax, 0, __del, __cookie);
    }

    ::Ice::AsyncResultPtr begin_getLog(const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Context& __ctx, const ::Ice::CallbackPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_getLog(__p_messageTypes, __p_traceCategories, __p_messageMax, &__ctx, __del, __cookie);
    }

    ::Ice::AsyncResultPtr begin_getLog(const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Callback_LoggerAdmin_getLogPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_getLog(__p_messageTypes, __p_traceCategories, __p_messageMax, 0, __del, __cookie);
    }

    ::Ice::AsyncResultPtr begin_getLog(const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Context& __ctx, const ::Ice::Callback_LoggerAdmin_getLogPtr& __del, const ::Ice::LocalObjectPtr& __cookie = 0)
    {
        return begin_getLog(__p_messageTypes, __p_traceCategories, __p_messageMax, &__ctx, __del, __cookie);
    }

    ::Ice::LogMessageSeq end_getLog(::std::string& __p_prefix, const ::Ice::AsyncResultPtr&);
    
private:

    ::Ice::LogMessageSeq getLog(const ::Ice::LogMessageTypeSeq&, const ::Ice::StringSeq&, ::Ice::Int, ::std::string&, const ::Ice::Context*);
    ::Ice::AsyncResultPtr begin_getLog(const ::Ice::LogMessageTypeSeq&, const ::Ice::StringSeq&, ::Ice::Int, const ::Ice::Context*, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& __cookie = 0);
    
public:
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_context(const ::Ice::Context& __context) const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_context(__context).get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_adapterId(const ::std::string& __id) const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_adapterId(__id).get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_endpoints(const ::Ice::EndpointSeq& __endpoints) const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_endpoints(__endpoints).get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_locatorCacheTimeout(int __timeout) const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_locatorCacheTimeout(__timeout).get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_connectionCached(bool __cached) const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_connectionCached(__cached).get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_endpointSelection(::Ice::EndpointSelectionType __est) const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_endpointSelection(__est).get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_secure(bool __secure) const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_secure(__secure).get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_preferSecure(bool __preferSecure) const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_preferSecure(__preferSecure).get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_router(const ::Ice::RouterPrx& __router) const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_router(__router).get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_locator(const ::Ice::LocatorPrx& __locator) const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_locator(__locator).get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_collocationOptimized(bool __co) const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_collocationOptimized(__co).get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_invocationTimeout(int __timeout) const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_invocationTimeout(__timeout).get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_twoway() const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_twoway().get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_oneway() const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_oneway().get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_batchOneway() const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_batchOneway().get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_datagram() const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_datagram().get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_batchDatagram() const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_batchDatagram().get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_compress(bool __compress) const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_compress(__compress).get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_timeout(int __timeout) const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_timeout(__timeout).get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_connectionId(const ::std::string& __id) const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_connectionId(__id).get());
    }
    
    ::IceInternal::ProxyHandle<LoggerAdmin> ice_encodingVersion(const ::Ice::EncodingVersion& __v) const
    {
        return dynamic_cast<LoggerAdmin*>(::IceProxy::Ice::Object::ice_encodingVersion(__v).get());
    }
    
    static const ::std::string& ice_staticId();

private: 
    virtual ::IceProxy::Ice::Object* __newInstance() const;
};

}

}

namespace Ice
{

class ICE_API RemoteLogger : virtual public ::Ice::Object
{
public:

    typedef RemoteLoggerPrx ProxyType;
    typedef RemoteLoggerPtr PointerType;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::Current()) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::Current()) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::Current()) const;
    static const ::std::string& ice_staticId();

    virtual void init(const ::std::string&, const ::Ice::LogMessageSeq&, const ::Ice::Current& = ::Ice::Current()) = 0;
    ::Ice::DispatchStatus ___init(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void log(const ::Ice::LogMessage&, const ::Ice::Current& = ::Ice::Current()) = 0;
    ::Ice::DispatchStatus ___log(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::DispatchStatus __dispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:
    virtual void __writeImpl(::IceInternal::BasicStream*) const;
    virtual void __readImpl(::IceInternal::BasicStream*);
    using ::Ice::Object::__writeImpl;
    using ::Ice::Object::__readImpl;
};

inline bool operator==(const RemoteLogger& l, const RemoteLogger& r)
{
    return static_cast<const ::Ice::Object&>(l) == static_cast<const ::Ice::Object&>(r);
}

inline bool operator<(const RemoteLogger& l, const RemoteLogger& r)
{
    return static_cast<const ::Ice::Object&>(l) < static_cast<const ::Ice::Object&>(r);
}

class ICE_API LoggerAdmin : virtual public ::Ice::Object
{
public:

    typedef LoggerAdminPrx ProxyType;
    typedef LoggerAdminPtr PointerType;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::Current()) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::Current()) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::Current()) const;
    static const ::std::string& ice_staticId();

    virtual void attachRemoteLogger(const ::Ice::RemoteLoggerPrx&, const ::Ice::LogMessageTypeSeq&, const ::Ice::StringSeq&, ::Ice::Int, const ::Ice::Current& = ::Ice::Current()) = 0;
    ::Ice::DispatchStatus ___attachRemoteLogger(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool detachRemoteLogger(const ::Ice::RemoteLoggerPrx&, const ::Ice::Current& = ::Ice::Current()) = 0;
    ::Ice::DispatchStatus ___detachRemoteLogger(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::LogMessageSeq getLog(const ::Ice::LogMessageTypeSeq&, const ::Ice::StringSeq&, ::Ice::Int, ::std::string&, const ::Ice::Current& = ::Ice::Current()) = 0;
    ::Ice::DispatchStatus ___getLog(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::DispatchStatus __dispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:
    virtual void __writeImpl(::IceInternal::BasicStream*) const;
    virtual void __readImpl(::IceInternal::BasicStream*);
    using ::Ice::Object::__writeImpl;
    using ::Ice::Object::__readImpl;
};

inline bool operator==(const LoggerAdmin& l, const LoggerAdmin& r)
{
    return static_cast<const ::Ice::Object&>(l) == static_cast<const ::Ice::Object&>(r);
}

inline bool operator<(const LoggerAdmin& l, const LoggerAdmin& r)
{
    return static_cast<const ::Ice::Object&>(l) < static_cast<const ::Ice::Object&>(r);
}

}

namespace Ice
{

template<class T>
class CallbackNC_RemoteLogger_init : public Callback_RemoteLogger_init_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_RemoteLogger_init(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_init<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_init<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_init<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_init<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_RemoteLogger_init : public Callback_RemoteLogger_init_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_RemoteLogger_init(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_init<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_init<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_init<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_init<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_RemoteLogger_log : public Callback_RemoteLogger_log_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_RemoteLogger_log(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_log<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_log<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_log<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_log<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_RemoteLogger_log : public Callback_RemoteLogger_log_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_RemoteLogger_log(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_log<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_log<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_log<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_log<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_LoggerAdmin_attachRemoteLogger : public Callback_LoggerAdmin_attachRemoteLogger_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_LoggerAdmin_attachRemoteLogger(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& __result) const
    {
        ::Ice::LoggerAdminPrx __proxy = ::Ice::LoggerAdminPrx::uncheckedCast(__result->getProxy());
        try
        {
            __proxy->end_attachRemoteLogger(__result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(__result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

    private:

    Response _response;
};

template<class T> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_attachRemoteLogger<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_attachRemoteLogger<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_attachRemoteLogger<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_attachRemoteLogger<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_LoggerAdmin_attachRemoteLogger : public Callback_LoggerAdmin_attachRemoteLogger_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_LoggerAdmin_attachRemoteLogger(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& __result) const
    {
        ::Ice::LoggerAdminPrx __proxy = ::Ice::LoggerAdminPrx::uncheckedCast(__result->getProxy());
        try
        {
            __proxy->end_attachRemoteLogger(__result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(__result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(__result->getCookie()));
        }
    }

    private:

    Response _response;
};

template<class T, typename CT> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_attachRemoteLogger<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_attachRemoteLogger<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_attachRemoteLogger<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_attachRemoteLogger<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_LoggerAdmin_detachRemoteLogger : public Callback_LoggerAdmin_detachRemoteLogger_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(bool);

    CallbackNC_LoggerAdmin_detachRemoteLogger(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& __result) const
    {
        ::Ice::LoggerAdminPrx __proxy = ::Ice::LoggerAdminPrx::uncheckedCast(__result->getProxy());
        bool __ret;
        try
        {
            __ret = __proxy->end_detachRemoteLogger(__result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(__result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(__ret);
        }
    }

    private:

    Response _response;
};

template<class T> Callback_LoggerAdmin_detachRemoteLoggerPtr
newCallback_LoggerAdmin_detachRemoteLogger(const IceUtil::Handle<T>& instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_detachRemoteLogger<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_LoggerAdmin_detachRemoteLoggerPtr
newCallback_LoggerAdmin_detachRemoteLogger(T* instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_detachRemoteLogger<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_LoggerAdmin_detachRemoteLogger : public Callback_LoggerAdmin_detachRemoteLogger_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(bool, const CT&);

    Callback_LoggerAdmin_detachRemoteLogger(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& __result) const
    {
        ::Ice::LoggerAdminPrx __proxy = ::Ice::LoggerAdminPrx::uncheckedCast(__result->getProxy());
        bool __ret;
        try
        {
            __ret = __proxy->end_detachRemoteLogger(__result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(__result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(__ret, CT::dynamicCast(__result->getCookie()));
        }
    }

    private:

    Response _response;
};

template<class T, typename CT> Callback_LoggerAdmin_detachRemoteLoggerPtr
newCallback_LoggerAdmin_detachRemoteLogger(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_detachRemoteLogger<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_LoggerAdmin_detachRemoteLoggerPtr
newCallback_LoggerAdmin_detachRemoteLogger(T* instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_detachRemoteLogger<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_LoggerAdmin_getLog : public Callback_LoggerAdmin_getLog_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::LogMessageSeq&, const ::std::string&);

    CallbackNC_LoggerAdmin_getLog(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& __result) const
    {
        ::Ice::LoggerAdminPrx __proxy = ::Ice::LoggerAdminPrx::uncheckedCast(__result->getProxy());
        ::std::string prefix;
        ::Ice::LogMessageSeq __ret;
        try
        {
            __ret = __proxy->end_getLog(prefix, __result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(__result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(__ret, prefix);
        }
    }

    private:

    Response _response;
};

template<class T> Callback_LoggerAdmin_getLogPtr
newCallback_LoggerAdmin_getLog(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::LogMessageSeq&, const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_getLog<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_LoggerAdmin_getLogPtr
newCallback_LoggerAdmin_getLog(T* instance, void (T::*cb)(const ::Ice::LogMessageSeq&, const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_getLog<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_LoggerAdmin_getLog : public Callback_LoggerAdmin_getLog_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::LogMessageSeq&, const ::std::string&, const CT&);

    Callback_LoggerAdmin_getLog(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& __result) const
    {
        ::Ice::LoggerAdminPrx __proxy = ::Ice::LoggerAdminPrx::uncheckedCast(__result->getProxy());
        ::std::string prefix;
        ::Ice::LogMessageSeq __ret;
        try
        {
            __ret = __proxy->end_getLog(prefix, __result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(__result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(__ret, prefix, CT::dynamicCast(__result->getCookie()));
        }
    }

    private:

    Response _response;
};

template<class T, typename CT> Callback_LoggerAdmin_getLogPtr
newCallback_LoggerAdmin_getLog(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::LogMessageSeq&, const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_getLog<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_LoggerAdmin_getLogPtr
newCallback_LoggerAdmin_getLog(T* instance, void (T::*cb)(const ::Ice::LogMessageSeq&, const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_getLog<T, CT>(instance, cb, excb, sentcb);
}

}

#include <IceUtil/PopDisableWarnings.h>
#endif
