// **********************************************************************
//
// Copyright (c) 2003-2015 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.1
//
// <auto-generated>
//
// Generated from file `Process.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef ICE_API_EXPORTS
#   define ICE_API_EXPORTS
#endif
#include <Ice/Process.h>
#include <IceUtil/PushDisableWarnings.h>
#include <Ice/LocalException.h>
#include <Ice/ObjectFactory.h>
#include <Ice/Outgoing.h>
#include <Ice/OutgoingAsync.h>
#include <Ice/BasicStream.h>
#include <IceUtil/Iterator.h>
#include <IceUtil/PopDisableWarnings.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 306
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 1
#       error Ice patch level mismatch!
#   endif
#endif

namespace
{

const ::std::string __Ice__Process__shutdown_name = "shutdown";

const ::std::string __Ice__Process__writeMessage_name = "writeMessage";

}
#ifdef __SUNPRO_CC
class ICE_API IceProxy::Ice::Process;
#endif
ICE_API ::IceProxy::Ice::Object* ::IceProxy::Ice::upCast(::IceProxy::Ice::Process* p) { return p; }

void
::IceProxy::Ice::__read(::IceInternal::BasicStream* __is, ::IceInternal::ProxyHandle< ::IceProxy::Ice::Process>& v)
{
    ::Ice::ObjectPrx proxy;
    __is->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new ::IceProxy::Ice::Process;
        v->__copyFrom(proxy);
    }
}

void
IceProxy::Ice::Process::shutdown(const ::Ice::Context* __ctx)
{
    ::IceInternal::Outgoing __og(this, __Ice__Process__shutdown_name, ::Ice::Normal, __ctx);
    __og.writeEmptyParams();
    __invoke(__og);
}

::Ice::AsyncResultPtr
IceProxy::Ice::Process::begin_shutdown(const ::Ice::Context* __ctx, const ::IceInternal::CallbackBasePtr& __del, const ::Ice::LocalObjectPtr& __cookie)
{
    ::IceInternal::OutgoingAsyncPtr __result = new ::IceInternal::OutgoingAsync(this, __Ice__Process__shutdown_name, __del, __cookie);
    try
    {
        __result->prepare(__Ice__Process__shutdown_name, ::Ice::Normal, __ctx);
        __result->writeEmptyParams();
        __result->invoke();
    }
    catch(const ::Ice::Exception& __ex)
    {
        __result->abort(__ex);
    }
    return __result;
}

void
IceProxy::Ice::Process::end_shutdown(const ::Ice::AsyncResultPtr& __result)
{
    __end(__result, __Ice__Process__shutdown_name);
}

void
IceProxy::Ice::Process::writeMessage(const ::std::string& __p_message, ::Ice::Int __p_fd, const ::Ice::Context* __ctx)
{
    ::IceInternal::Outgoing __og(this, __Ice__Process__writeMessage_name, ::Ice::Normal, __ctx);
    try
    {
        ::IceInternal::BasicStream* __os = __og.startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_message);
        __os->write(__p_fd);
        __og.endWriteParams();
    }
    catch(const ::Ice::LocalException& __ex)
    {
        __og.abort(__ex);
    }
    __invoke(__og);
}

::Ice::AsyncResultPtr
IceProxy::Ice::Process::begin_writeMessage(const ::std::string& __p_message, ::Ice::Int __p_fd, const ::Ice::Context* __ctx, const ::IceInternal::CallbackBasePtr& __del, const ::Ice::LocalObjectPtr& __cookie)
{
    ::IceInternal::OutgoingAsyncPtr __result = new ::IceInternal::OutgoingAsync(this, __Ice__Process__writeMessage_name, __del, __cookie);
    try
    {
        __result->prepare(__Ice__Process__writeMessage_name, ::Ice::Normal, __ctx);
        ::IceInternal::BasicStream* __os = __result->startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_message);
        __os->write(__p_fd);
        __result->endWriteParams();
        __result->invoke();
    }
    catch(const ::Ice::Exception& __ex)
    {
        __result->abort(__ex);
    }
    return __result;
}

void
IceProxy::Ice::Process::end_writeMessage(const ::Ice::AsyncResultPtr& __result)
{
    __end(__result, __Ice__Process__writeMessage_name);
}

const ::std::string&
IceProxy::Ice::Process::ice_staticId()
{
    return ::Ice::Process::ice_staticId();
}

::IceProxy::Ice::Object*
IceProxy::Ice::Process::__newInstance() const
{
    return new Process;
}

ICE_API ::Ice::Object* Ice::upCast(::Ice::Process* p) { return p; }

namespace
{
const ::std::string __Ice__Process_ids[2] =
{
    "::Ice::Object",
    "::Ice::Process"
};

}

bool
Ice::Process::ice_isA(const ::std::string& _s, const ::Ice::Current&) const
{
    return ::std::binary_search(__Ice__Process_ids, __Ice__Process_ids + 2, _s);
}

::std::vector< ::std::string>
Ice::Process::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&__Ice__Process_ids[0], &__Ice__Process_ids[2]);
}

const ::std::string&
Ice::Process::ice_id(const ::Ice::Current&) const
{
    return __Ice__Process_ids[1];
}

const ::std::string&
Ice::Process::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::Ice::Process";
    return typeId;
#else
    return __Ice__Process_ids[1];
#endif
}

::Ice::DispatchStatus
Ice::Process::___shutdown(::IceInternal::Incoming& __inS, const ::Ice::Current& __current)
{
    __checkMode(::Ice::Normal, __current.mode);
    __inS.readEmptyParams();
    shutdown(__current);
    __inS.__writeEmptyParams();
    return ::Ice::DispatchOK;
}

::Ice::DispatchStatus
Ice::Process::___writeMessage(::IceInternal::Incoming& __inS, const ::Ice::Current& __current)
{
    __checkMode(::Ice::Normal, __current.mode);
    ::IceInternal::BasicStream* __is = __inS.startReadParams();
    ::std::string __p_message;
    ::Ice::Int __p_fd;
    __is->read(__p_message);
    __is->read(__p_fd);
    __inS.endReadParams();
    writeMessage(__p_message, __p_fd, __current);
    __inS.__writeEmptyParams();
    return ::Ice::DispatchOK;
}

namespace
{
const ::std::string __Ice__Process_all[] =
{
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "shutdown",
    "writeMessage"
};

}

::Ice::DispatchStatus
Ice::Process::__dispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair< const ::std::string*, const ::std::string*> r = ::std::equal_range(__Ice__Process_all, __Ice__Process_all + 6, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - __Ice__Process_all)
    {
        case 0:
        {
            return ___ice_id(in, current);
        }
        case 1:
        {
            return ___ice_ids(in, current);
        }
        case 2:
        {
            return ___ice_isA(in, current);
        }
        case 3:
        {
            return ___ice_ping(in, current);
        }
        case 4:
        {
            return ___shutdown(in, current);
        }
        case 5:
        {
            return ___writeMessage(in, current);
        }
    }

    assert(false);
    throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
}

void
Ice::Process::__writeImpl(::IceInternal::BasicStream* __os) const
{
    __os->startWriteSlice(ice_staticId(), -1, true);
    __os->endWriteSlice();
}

void
Ice::Process::__readImpl(::IceInternal::BasicStream* __is)
{
    __is->startReadSlice();
    __is->endReadSlice();
}

void ICE_API 
Ice::__patch(ProcessPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = ::Ice::ProcessPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(::Ice::Process::ice_staticId(), v);
    }
}
