# Copyright 2020 StrongDM Inc
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import peering_group_nodes_pb2 as peering__group__nodes__pb2


class PeeringGroupNodesStub(object):
    """PeeringGroupNodes provides the building blocks necessary to obtain attach a node to a peering group.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Create = channel.unary_unary(
                '/v1.PeeringGroupNodes/Create',
                request_serializer=peering__group__nodes__pb2.PeeringGroupNodeCreateRequest.SerializeToString,
                response_deserializer=peering__group__nodes__pb2.PeeringGroupNodeCreateResponse.FromString,
                )
        self.Delete = channel.unary_unary(
                '/v1.PeeringGroupNodes/Delete',
                request_serializer=peering__group__nodes__pb2.PeeringGroupNodeDeleteRequest.SerializeToString,
                response_deserializer=peering__group__nodes__pb2.PeeringGroupNodeDeleteResponse.FromString,
                )
        self.Get = channel.unary_unary(
                '/v1.PeeringGroupNodes/Get',
                request_serializer=peering__group__nodes__pb2.PeeringGroupNodeGetRequest.SerializeToString,
                response_deserializer=peering__group__nodes__pb2.PeeringGroupNodeGetResponse.FromString,
                )
        self.List = channel.unary_unary(
                '/v1.PeeringGroupNodes/List',
                request_serializer=peering__group__nodes__pb2.PeeringGroupNodeListRequest.SerializeToString,
                response_deserializer=peering__group__nodes__pb2.PeeringGroupNodeListResponse.FromString,
                )


class PeeringGroupNodesServicer(object):
    """PeeringGroupNodes provides the building blocks necessary to obtain attach a node to a peering group.
    """

    def Create(self, request, context):
        """Create attaches a Node to a PeeringGroup
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Delete(self, request, context):
        """Delete detaches a Node to a PeeringGroup.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Get(self, request, context):
        """Get reads the information of one peering group to node attachment.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def List(self, request, context):
        """List gets a list of peering group node attachments.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_PeeringGroupNodesServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Create': grpc.unary_unary_rpc_method_handler(
                    servicer.Create,
                    request_deserializer=peering__group__nodes__pb2.PeeringGroupNodeCreateRequest.FromString,
                    response_serializer=peering__group__nodes__pb2.PeeringGroupNodeCreateResponse.SerializeToString,
            ),
            'Delete': grpc.unary_unary_rpc_method_handler(
                    servicer.Delete,
                    request_deserializer=peering__group__nodes__pb2.PeeringGroupNodeDeleteRequest.FromString,
                    response_serializer=peering__group__nodes__pb2.PeeringGroupNodeDeleteResponse.SerializeToString,
            ),
            'Get': grpc.unary_unary_rpc_method_handler(
                    servicer.Get,
                    request_deserializer=peering__group__nodes__pb2.PeeringGroupNodeGetRequest.FromString,
                    response_serializer=peering__group__nodes__pb2.PeeringGroupNodeGetResponse.SerializeToString,
            ),
            'List': grpc.unary_unary_rpc_method_handler(
                    servicer.List,
                    request_deserializer=peering__group__nodes__pb2.PeeringGroupNodeListRequest.FromString,
                    response_serializer=peering__group__nodes__pb2.PeeringGroupNodeListResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'v1.PeeringGroupNodes', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class PeeringGroupNodes(object):
    """PeeringGroupNodes provides the building blocks necessary to obtain attach a node to a peering group.
    """

    @staticmethod
    def Create(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.PeeringGroupNodes/Create',
            peering__group__nodes__pb2.PeeringGroupNodeCreateRequest.SerializeToString,
            peering__group__nodes__pb2.PeeringGroupNodeCreateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Delete(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.PeeringGroupNodes/Delete',
            peering__group__nodes__pb2.PeeringGroupNodeDeleteRequest.SerializeToString,
            peering__group__nodes__pb2.PeeringGroupNodeDeleteResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Get(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.PeeringGroupNodes/Get',
            peering__group__nodes__pb2.PeeringGroupNodeGetRequest.SerializeToString,
            peering__group__nodes__pb2.PeeringGroupNodeGetResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def List(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.PeeringGroupNodes/List',
            peering__group__nodes__pb2.PeeringGroupNodeListRequest.SerializeToString,
            peering__group__nodes__pb2.PeeringGroupNodeListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
