# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CheckNameAvailability(Model):
    """Description of a Check Name availability request properties.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The Name to check the namespace name availability
     and The namespace name can contain only letters, numbers, and hyphens. The
     namespace must start with a letter, and it must end with a letter or
     number.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CheckNameAvailability, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class CheckNameAvailabilityResult(Model):
    """Description of a Check Name availability request properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param name_available: Value indicating namespace is availability, true if
     the namespace is available; otherwise, false.
    :type name_available: bool
    :param reason: The reason for unavailability of a namespace. Possible
     values include: 'None', 'InvalidName', 'SubscriptionIsDisabled',
     'NameInUse', 'NameInLockdown', 'TooManyNamespaceInCurrentSubscription'
    :type reason: str or
     ~azure.mgmt.servicebus.v2015_08_01.models.UnavailableReason
    :ivar message: The detailed info regarding the reason associated with the
     namespace.
    :vartype message: str
    """

    _validation = {
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)
        self.message = None


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class MessageCountDetails(Model):
    """Message Count Details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar active_message_count: Number of active messages in the queue, topic,
     or subscription.
    :vartype active_message_count: long
    :ivar dead_letter_message_count: Number of messages that are dead
     lettered.
    :vartype dead_letter_message_count: long
    :ivar scheduled_message_count: Number of scheduled messages.
    :vartype scheduled_message_count: long
    :ivar transfer_dead_letter_message_count: Number of messages transferred
     into dead letters.
    :vartype transfer_dead_letter_message_count: long
    :ivar transfer_message_count: Number of messages transferred to another
     queue, topic, or subscription.
    :vartype transfer_message_count: long
    """

    _validation = {
        'active_message_count': {'readonly': True},
        'dead_letter_message_count': {'readonly': True},
        'scheduled_message_count': {'readonly': True},
        'transfer_dead_letter_message_count': {'readonly': True},
        'transfer_message_count': {'readonly': True},
    }

    _attribute_map = {
        'active_message_count': {'key': 'activeMessageCount', 'type': 'long'},
        'dead_letter_message_count': {'key': 'deadLetterMessageCount', 'type': 'long'},
        'scheduled_message_count': {'key': 'scheduledMessageCount', 'type': 'long'},
        'transfer_dead_letter_message_count': {'key': 'transferDeadLetterMessageCount', 'type': 'long'},
        'transfer_message_count': {'key': 'transferMessageCount', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(MessageCountDetails, self).__init__(**kwargs)
        self.active_message_count = None
        self.dead_letter_message_count = None
        self.scheduled_message_count = None
        self.transfer_dead_letter_message_count = None
        self.transfer_message_count = None


class NamespaceCreateOrUpdateParameters(Model):
    """Parameters supplied to the Create Or Update Namespace operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Namespace location.
    :type location: str
    :param sku:
    :type sku: ~azure.mgmt.servicebus.v2015_08_01.models.Sku
    :param tags: Namespace tags.
    :type tags: dict[str, str]
    :ivar provisioning_state: Provisioning state of the namespace.
    :vartype provisioning_state: str
    :param status: State of the namespace. Possible values include: 'Unknown',
     'Creating', 'Created', 'Activating', 'Enabling', 'Active', 'Disabling',
     'Disabled', 'SoftDeleting', 'SoftDeleted', 'Removing', 'Removed', 'Failed'
    :type status: str or
     ~azure.mgmt.servicebus.v2015_08_01.models.NamespaceState
    :ivar created_at: The time the namespace was created.
    :vartype created_at: datetime
    :ivar updated_at: The time the namespace was updated.
    :vartype updated_at: datetime
    :ivar service_bus_endpoint: Endpoint you can use to perform Service Bus
     operations.
    :vartype service_bus_endpoint: str
    :param create_acs_namespace: Indicates whether to create an ACS namespace.
    :type create_acs_namespace: bool
    :param enabled: Specifies whether this instance is enabled.
    :type enabled: bool
    """

    _validation = {
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_at': {'readonly': True},
        'updated_at': {'readonly': True},
        'service_bus_endpoint': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'NamespaceState'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'service_bus_endpoint': {'key': 'properties.serviceBusEndpoint', 'type': 'str'},
        'create_acs_namespace': {'key': 'properties.createACSNamespace', 'type': 'bool'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(NamespaceCreateOrUpdateParameters, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)
        self.provisioning_state = None
        self.status = kwargs.get('status', None)
        self.created_at = None
        self.updated_at = None
        self.service_bus_endpoint = None
        self.create_acs_namespace = kwargs.get('create_acs_namespace', None)
        self.enabled = kwargs.get('enabled', None)


class Resource(Model):
    """The Resource definition for other than namespace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :param location: Resource location.
    :type location: str
    :ivar type: Resource type
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.location = kwargs.get('location', None)
        self.type = None


class TrackedResource(Resource):
    """The Resource definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :param location: Resource location.
    :type location: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class NamespaceResource(TrackedResource):
    """Description of a namespace resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :param location: Resource location.
    :type location: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param sku:
    :type sku: ~azure.mgmt.servicebus.v2015_08_01.models.Sku
    :ivar provisioning_state: Provisioning state of the namespace.
    :vartype provisioning_state: str
    :param status: State of the namespace. Possible values include: 'Unknown',
     'Creating', 'Created', 'Activating', 'Enabling', 'Active', 'Disabling',
     'Disabled', 'SoftDeleting', 'SoftDeleted', 'Removing', 'Removed', 'Failed'
    :type status: str or
     ~azure.mgmt.servicebus.v2015_08_01.models.NamespaceState
    :ivar created_at: The time the namespace was created.
    :vartype created_at: datetime
    :ivar updated_at: The time the namespace was updated.
    :vartype updated_at: datetime
    :ivar service_bus_endpoint: Endpoint you can use to perform Service Bus
     operations.
    :vartype service_bus_endpoint: str
    :param create_acs_namespace: Indicates whether to create an ACS namespace.
    :type create_acs_namespace: bool
    :param enabled: Specifies whether this instance is enabled.
    :type enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_at': {'readonly': True},
        'updated_at': {'readonly': True},
        'service_bus_endpoint': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'NamespaceState'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'service_bus_endpoint': {'key': 'properties.serviceBusEndpoint', 'type': 'str'},
        'create_acs_namespace': {'key': 'properties.createACSNamespace', 'type': 'bool'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(NamespaceResource, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.provisioning_state = None
        self.status = kwargs.get('status', None)
        self.created_at = None
        self.updated_at = None
        self.service_bus_endpoint = None
        self.create_acs_namespace = kwargs.get('create_acs_namespace', None)
        self.enabled = kwargs.get('enabled', None)


class NamespaceUpdateParameters(Model):
    """Parameters supplied to the Patch Namespace operation.

    :param tags: Resource tags
    :type tags: dict[str, str]
    :param sku: The sku of the created namespace
    :type sku: ~azure.mgmt.servicebus.v2015_08_01.models.Sku
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(self, **kwargs):
        super(NamespaceUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.sku = kwargs.get('sku', None)


class Operation(Model):
    """A ServiceBus REST API operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}
    :vartype name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.servicebus.v2015_08_01.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = kwargs.get('display', None)


class OperationDisplay(Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provider: Service provider: Microsoft.ServiceBus
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Invoice,
     etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None


class QueueCreateOrUpdateParameters(Model):
    """Parameters supplied to the Create Or Update Queue operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Queue name.
    :type name: str
    :param location: Required. location of the resource.
    :type location: str
    :param lock_duration: The duration of a peek-lock; that is, the amount of
     time that the message is locked for other receivers. The maximum value for
     LockDuration is 5 minutes; the default value is 1 minute.
    :type lock_duration: str
    :ivar accessed_at: Last time a message was sent, or the last time there
     was a receive request to this queue.
    :vartype accessed_at: datetime
    :param auto_delete_on_idle: the TimeSpan idle interval after which the
     queue is automatically deleted. The minimum duration is 5 minutes.
    :type auto_delete_on_idle: str
    :param entity_availability_status: Entity availability status for the
     queue. Possible values include: 'Available', 'Limited', 'Renaming',
     'Restoring', 'Unknown'
    :type entity_availability_status: str or
     ~azure.mgmt.servicebus.v2015_08_01.models.EntityAvailabilityStatus
    :ivar created_at: The exact time the message was created.
    :vartype created_at: datetime
    :param default_message_time_to_live: The default message time to live
     value. This is the duration after which the message expires, starting from
     when the message is sent to Service Bus. This is the default value used
     when TimeToLive is not set on a message itself.
    :type default_message_time_to_live: str
    :param duplicate_detection_history_time_window: TimeSpan structure that
     defines the duration of the duplicate detection history. The default value
     is 10 minutes.
    :type duplicate_detection_history_time_window: str
    :param enable_batched_operations: A value that indicates whether
     server-side batched operations are enabled.
    :type enable_batched_operations: bool
    :param dead_lettering_on_message_expiration: A value that indicates
     whether this queue has dead letter support when a message expires.
    :type dead_lettering_on_message_expiration: bool
    :param enable_express: A value that indicates whether Express Entities are
     enabled. An express queue holds a message in memory temporarily before
     writing it to persistent storage.
    :type enable_express: bool
    :param enable_partitioning: A value that indicates whether the queue is to
     be partitioned across multiple message brokers.
    :type enable_partitioning: bool
    :param is_anonymous_accessible: A value that indicates whether the message
     is accessible anonymously.
    :type is_anonymous_accessible: bool
    :param max_delivery_count: The maximum delivery count. A message is
     automatically deadlettered after this number of deliveries.
    :type max_delivery_count: int
    :param max_size_in_megabytes: The maximum size of the queue in megabytes,
     which is the size of memory allocated for the queue.
    :type max_size_in_megabytes: long
    :ivar message_count: The number of messages in the queue.
    :vartype message_count: long
    :ivar count_details:
    :vartype count_details:
     ~azure.mgmt.servicebus.v2015_08_01.models.MessageCountDetails
    :param requires_duplicate_detection: A value indicating if this queue
     requires duplicate detection.
    :type requires_duplicate_detection: bool
    :param requires_session: A value that indicates whether the queue supports
     the concept of sessions.
    :type requires_session: bool
    :ivar size_in_bytes: The size of the queue, in bytes.
    :vartype size_in_bytes: long
    :param status: Enumerates the possible values for the status of a
     messaging entity. Possible values include: 'Active', 'Creating',
     'Deleting', 'Disabled', 'ReceiveDisabled', 'Renaming', 'Restoring',
     'SendDisabled', 'Unknown'
    :type status: str or
     ~azure.mgmt.servicebus.v2015_08_01.models.EntityStatus
    :param support_ordering: A value that indicates whether the queue supports
     ordering.
    :type support_ordering: bool
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: datetime
    """

    _validation = {
        'location': {'required': True},
        'accessed_at': {'readonly': True},
        'created_at': {'readonly': True},
        'message_count': {'readonly': True},
        'count_details': {'readonly': True},
        'size_in_bytes': {'readonly': True},
        'updated_at': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'lock_duration': {'key': 'properties.lockDuration', 'type': 'str'},
        'accessed_at': {'key': 'properties.accessedAt', 'type': 'iso-8601'},
        'auto_delete_on_idle': {'key': 'properties.autoDeleteOnIdle', 'type': 'str'},
        'entity_availability_status': {'key': 'properties.entityAvailabilityStatus', 'type': 'EntityAvailabilityStatus'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'default_message_time_to_live': {'key': 'properties.defaultMessageTimeToLive', 'type': 'str'},
        'duplicate_detection_history_time_window': {'key': 'properties.duplicateDetectionHistoryTimeWindow', 'type': 'str'},
        'enable_batched_operations': {'key': 'properties.enableBatchedOperations', 'type': 'bool'},
        'dead_lettering_on_message_expiration': {'key': 'properties.deadLetteringOnMessageExpiration', 'type': 'bool'},
        'enable_express': {'key': 'properties.enableExpress', 'type': 'bool'},
        'enable_partitioning': {'key': 'properties.enablePartitioning', 'type': 'bool'},
        'is_anonymous_accessible': {'key': 'properties.isAnonymousAccessible', 'type': 'bool'},
        'max_delivery_count': {'key': 'properties.maxDeliveryCount', 'type': 'int'},
        'max_size_in_megabytes': {'key': 'properties.maxSizeInMegabytes', 'type': 'long'},
        'message_count': {'key': 'properties.messageCount', 'type': 'long'},
        'count_details': {'key': 'properties.countDetails', 'type': 'MessageCountDetails'},
        'requires_duplicate_detection': {'key': 'properties.requiresDuplicateDetection', 'type': 'bool'},
        'requires_session': {'key': 'properties.requiresSession', 'type': 'bool'},
        'size_in_bytes': {'key': 'properties.sizeInBytes', 'type': 'long'},
        'status': {'key': 'properties.status', 'type': 'EntityStatus'},
        'support_ordering': {'key': 'properties.supportOrdering', 'type': 'bool'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(QueueCreateOrUpdateParameters, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.location = kwargs.get('location', None)
        self.lock_duration = kwargs.get('lock_duration', None)
        self.accessed_at = None
        self.auto_delete_on_idle = kwargs.get('auto_delete_on_idle', None)
        self.entity_availability_status = kwargs.get('entity_availability_status', None)
        self.created_at = None
        self.default_message_time_to_live = kwargs.get('default_message_time_to_live', None)
        self.duplicate_detection_history_time_window = kwargs.get('duplicate_detection_history_time_window', None)
        self.enable_batched_operations = kwargs.get('enable_batched_operations', None)
        self.dead_lettering_on_message_expiration = kwargs.get('dead_lettering_on_message_expiration', None)
        self.enable_express = kwargs.get('enable_express', None)
        self.enable_partitioning = kwargs.get('enable_partitioning', None)
        self.is_anonymous_accessible = kwargs.get('is_anonymous_accessible', None)
        self.max_delivery_count = kwargs.get('max_delivery_count', None)
        self.max_size_in_megabytes = kwargs.get('max_size_in_megabytes', None)
        self.message_count = None
        self.count_details = None
        self.requires_duplicate_detection = kwargs.get('requires_duplicate_detection', None)
        self.requires_session = kwargs.get('requires_session', None)
        self.size_in_bytes = None
        self.status = kwargs.get('status', None)
        self.support_ordering = kwargs.get('support_ordering', None)
        self.updated_at = None


class QueueResource(Resource):
    """Description of queue Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :param location: Resource location.
    :type location: str
    :ivar type: Resource type
    :vartype type: str
    :param lock_duration: The duration of a peek-lock; that is, the amount of
     time that the message is locked for other receivers. The maximum value for
     LockDuration is 5 minutes; the default value is 1 minute.
    :type lock_duration: str
    :ivar accessed_at: Last time a message was sent, or the last time there
     was a receive request to this queue.
    :vartype accessed_at: datetime
    :param auto_delete_on_idle: the TimeSpan idle interval after which the
     queue is automatically deleted. The minimum duration is 5 minutes.
    :type auto_delete_on_idle: str
    :param entity_availability_status: Entity availability status for the
     queue. Possible values include: 'Available', 'Limited', 'Renaming',
     'Restoring', 'Unknown'
    :type entity_availability_status: str or
     ~azure.mgmt.servicebus.v2015_08_01.models.EntityAvailabilityStatus
    :ivar created_at: The exact time the message was created.
    :vartype created_at: datetime
    :param default_message_time_to_live: The default message time to live
     value. This is the duration after which the message expires, starting from
     when the message is sent to Service Bus. This is the default value used
     when TimeToLive is not set on a message itself.
    :type default_message_time_to_live: str
    :param duplicate_detection_history_time_window: TimeSpan structure that
     defines the duration of the duplicate detection history. The default value
     is 10 minutes.
    :type duplicate_detection_history_time_window: str
    :param enable_batched_operations: A value that indicates whether
     server-side batched operations are enabled.
    :type enable_batched_operations: bool
    :param dead_lettering_on_message_expiration: A value that indicates
     whether this queue has dead letter support when a message expires.
    :type dead_lettering_on_message_expiration: bool
    :param enable_express: A value that indicates whether Express Entities are
     enabled. An express queue holds a message in memory temporarily before
     writing it to persistent storage.
    :type enable_express: bool
    :param enable_partitioning: A value that indicates whether the queue is to
     be partitioned across multiple message brokers.
    :type enable_partitioning: bool
    :param is_anonymous_accessible: A value that indicates whether the message
     is accessible anonymously.
    :type is_anonymous_accessible: bool
    :param max_delivery_count: The maximum delivery count. A message is
     automatically deadlettered after this number of deliveries.
    :type max_delivery_count: int
    :param max_size_in_megabytes: The maximum size of the queue in megabytes,
     which is the size of memory allocated for the queue.
    :type max_size_in_megabytes: long
    :ivar message_count: The number of messages in the queue.
    :vartype message_count: long
    :ivar count_details:
    :vartype count_details:
     ~azure.mgmt.servicebus.v2015_08_01.models.MessageCountDetails
    :param requires_duplicate_detection: A value indicating if this queue
     requires duplicate detection.
    :type requires_duplicate_detection: bool
    :param requires_session: A value that indicates whether the queue supports
     the concept of sessions.
    :type requires_session: bool
    :ivar size_in_bytes: The size of the queue, in bytes.
    :vartype size_in_bytes: long
    :param status: Enumerates the possible values for the status of a
     messaging entity. Possible values include: 'Active', 'Creating',
     'Deleting', 'Disabled', 'ReceiveDisabled', 'Renaming', 'Restoring',
     'SendDisabled', 'Unknown'
    :type status: str or
     ~azure.mgmt.servicebus.v2015_08_01.models.EntityStatus
    :param support_ordering: A value that indicates whether the queue supports
     ordering.
    :type support_ordering: bool
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'accessed_at': {'readonly': True},
        'created_at': {'readonly': True},
        'message_count': {'readonly': True},
        'count_details': {'readonly': True},
        'size_in_bytes': {'readonly': True},
        'updated_at': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'lock_duration': {'key': 'properties.lockDuration', 'type': 'str'},
        'accessed_at': {'key': 'properties.accessedAt', 'type': 'iso-8601'},
        'auto_delete_on_idle': {'key': 'properties.autoDeleteOnIdle', 'type': 'str'},
        'entity_availability_status': {'key': 'properties.entityAvailabilityStatus', 'type': 'EntityAvailabilityStatus'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'default_message_time_to_live': {'key': 'properties.defaultMessageTimeToLive', 'type': 'str'},
        'duplicate_detection_history_time_window': {'key': 'properties.duplicateDetectionHistoryTimeWindow', 'type': 'str'},
        'enable_batched_operations': {'key': 'properties.enableBatchedOperations', 'type': 'bool'},
        'dead_lettering_on_message_expiration': {'key': 'properties.deadLetteringOnMessageExpiration', 'type': 'bool'},
        'enable_express': {'key': 'properties.enableExpress', 'type': 'bool'},
        'enable_partitioning': {'key': 'properties.enablePartitioning', 'type': 'bool'},
        'is_anonymous_accessible': {'key': 'properties.isAnonymousAccessible', 'type': 'bool'},
        'max_delivery_count': {'key': 'properties.maxDeliveryCount', 'type': 'int'},
        'max_size_in_megabytes': {'key': 'properties.maxSizeInMegabytes', 'type': 'long'},
        'message_count': {'key': 'properties.messageCount', 'type': 'long'},
        'count_details': {'key': 'properties.countDetails', 'type': 'MessageCountDetails'},
        'requires_duplicate_detection': {'key': 'properties.requiresDuplicateDetection', 'type': 'bool'},
        'requires_session': {'key': 'properties.requiresSession', 'type': 'bool'},
        'size_in_bytes': {'key': 'properties.sizeInBytes', 'type': 'long'},
        'status': {'key': 'properties.status', 'type': 'EntityStatus'},
        'support_ordering': {'key': 'properties.supportOrdering', 'type': 'bool'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(QueueResource, self).__init__(**kwargs)
        self.lock_duration = kwargs.get('lock_duration', None)
        self.accessed_at = None
        self.auto_delete_on_idle = kwargs.get('auto_delete_on_idle', None)
        self.entity_availability_status = kwargs.get('entity_availability_status', None)
        self.created_at = None
        self.default_message_time_to_live = kwargs.get('default_message_time_to_live', None)
        self.duplicate_detection_history_time_window = kwargs.get('duplicate_detection_history_time_window', None)
        self.enable_batched_operations = kwargs.get('enable_batched_operations', None)
        self.dead_lettering_on_message_expiration = kwargs.get('dead_lettering_on_message_expiration', None)
        self.enable_express = kwargs.get('enable_express', None)
        self.enable_partitioning = kwargs.get('enable_partitioning', None)
        self.is_anonymous_accessible = kwargs.get('is_anonymous_accessible', None)
        self.max_delivery_count = kwargs.get('max_delivery_count', None)
        self.max_size_in_megabytes = kwargs.get('max_size_in_megabytes', None)
        self.message_count = None
        self.count_details = None
        self.requires_duplicate_detection = kwargs.get('requires_duplicate_detection', None)
        self.requires_session = kwargs.get('requires_session', None)
        self.size_in_bytes = None
        self.status = kwargs.get('status', None)
        self.support_ordering = kwargs.get('support_ordering', None)
        self.updated_at = None


class RegenerateKeysParameters(Model):
    """Parameters supplied to the Regenerate Authorization Rule operation.

    :param policykey: Key that needs to be regenerated. Possible values
     include: 'PrimaryKey', 'SecondaryKey'
    :type policykey: str or
     ~azure.mgmt.servicebus.v2015_08_01.models.Policykey
    """

    _attribute_map = {
        'policykey': {'key': 'Policykey', 'type': 'Policykey'},
    }

    def __init__(self, **kwargs):
        super(RegenerateKeysParameters, self).__init__(**kwargs)
        self.policykey = kwargs.get('policykey', None)


class ResourceListKeys(Model):
    """Namespace/ServiceBus Connection String.

    :param primary_connection_string: Primary connection string of the created
     namespace authorization rule.
    :type primary_connection_string: str
    :param secondary_connection_string: Secondary connection string of the
     created namespace authorization rule.
    :type secondary_connection_string: str
    :param primary_key: A base64-encoded 256-bit primary key for signing and
     validating the SAS token.
    :type primary_key: str
    :param secondary_key: A base64-encoded 256-bit primary key for signing and
     validating the SAS token.
    :type secondary_key: str
    :param key_name: A string that describes the authorization rule.
    :type key_name: str
    """

    _attribute_map = {
        'primary_connection_string': {'key': 'primaryConnectionString', 'type': 'str'},
        'secondary_connection_string': {'key': 'secondaryConnectionString', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceListKeys, self).__init__(**kwargs)
        self.primary_connection_string = kwargs.get('primary_connection_string', None)
        self.secondary_connection_string = kwargs.get('secondary_connection_string', None)
        self.primary_key = kwargs.get('primary_key', None)
        self.secondary_key = kwargs.get('secondary_key', None)
        self.key_name = kwargs.get('key_name', None)


class SharedAccessAuthorizationRuleCreateOrUpdateParameters(Model):
    """Parameters supplied to the Create Or Update Authorization Rules operation.

    All required parameters must be populated in order to send to Azure.

    :param location: data center location.
    :type location: str
    :param name: Name of the authorization rule.
    :type name: str
    :param rights: Required. The rights associated with the rule.
    :type rights: list[str or
     ~azure.mgmt.servicebus.v2015_08_01.models.AccessRights]
    """

    _validation = {
        'rights': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'rights': {'key': 'properties.rights', 'type': '[AccessRights]'},
    }

    def __init__(self, **kwargs):
        super(SharedAccessAuthorizationRuleCreateOrUpdateParameters, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.name = kwargs.get('name', None)
        self.rights = kwargs.get('rights', None)


class SharedAccessAuthorizationRuleResource(Resource):
    """Description of a namespace authorization rule.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :param location: Resource location.
    :type location: str
    :ivar type: Resource type
    :vartype type: str
    :param rights: Required. The rights associated with the rule.
    :type rights: list[str or
     ~azure.mgmt.servicebus.v2015_08_01.models.AccessRights]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'rights': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'rights': {'key': 'properties.rights', 'type': '[AccessRights]'},
    }

    def __init__(self, **kwargs):
        super(SharedAccessAuthorizationRuleResource, self).__init__(**kwargs)
        self.rights = kwargs.get('rights', None)


class Sku(Model):
    """SKU of the namespace.

    All required parameters must be populated in order to send to Azure.

    :param name: Name of this SKU. Possible values include: 'Basic',
     'Standard', 'Premium'
    :type name: str or ~azure.mgmt.servicebus.v2015_08_01.models.SkuName
    :param tier: Required. The billing tier of this particular SKU. Possible
     values include: 'Basic', 'Standard', 'Premium'
    :type tier: str or ~azure.mgmt.servicebus.v2015_08_01.models.SkuTier
    :param capacity: The specified messaging units for the tier.
    :type capacity: int
    """

    _validation = {
        'tier': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.capacity = kwargs.get('capacity', None)


class SubscriptionCreateOrUpdateParameters(Model):
    """Parameters supplied to the Create Or Update Subscription operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Subscription data center location.
    :type location: str
    :param type: Resource manager type of the resource.
    :type type: str
    :ivar accessed_at: Last time there was a receive request to this
     subscription.
    :vartype accessed_at: datetime
    :param auto_delete_on_idle: TimeSpan idle interval after which the topic
     is automatically deleted. The minimum duration is 5 minutes.
    :type auto_delete_on_idle: str
    :ivar count_details:
    :vartype count_details:
     ~azure.mgmt.servicebus.v2015_08_01.models.MessageCountDetails
    :ivar created_at: Exact time the message was created.
    :vartype created_at: datetime
    :param default_message_time_to_live: Default message time to live value.
     This is the duration after which the message expires, starting from when
     the message is sent to Service Bus. This is the default value used when
     TimeToLive is not set on a message itself.
    :type default_message_time_to_live: str
    :param dead_lettering_on_filter_evaluation_exceptions: Value that
     indicates whether a subscription has dead letter support on filter
     evaluation exceptions.
    :type dead_lettering_on_filter_evaluation_exceptions: bool
    :param dead_lettering_on_message_expiration: Value that indicates whether
     a subscription has dead letter support when a message expires.
    :type dead_lettering_on_message_expiration: bool
    :param enable_batched_operations: Value that indicates whether server-side
     batched operations are enabled.
    :type enable_batched_operations: bool
    :param entity_availability_status: Entity availability status for the
     topic. Possible values include: 'Available', 'Limited', 'Renaming',
     'Restoring', 'Unknown'
    :type entity_availability_status: str or
     ~azure.mgmt.servicebus.v2015_08_01.models.EntityAvailabilityStatus
    :param is_read_only: Value that indicates whether the entity description
     is read-only.
    :type is_read_only: bool
    :param lock_duration: The lock duration time span for the subscription.
    :type lock_duration: str
    :param max_delivery_count: Number of maximum deliveries.
    :type max_delivery_count: int
    :ivar message_count: Number of messages.
    :vartype message_count: long
    :param requires_session: Value indicating if a subscription supports the
     concept of sessions.
    :type requires_session: bool
    :param status: Enumerates the possible values for the status of a
     messaging entity. Possible values include: 'Active', 'Creating',
     'Deleting', 'Disabled', 'ReceiveDisabled', 'Renaming', 'Restoring',
     'SendDisabled', 'Unknown'
    :type status: str or
     ~azure.mgmt.servicebus.v2015_08_01.models.EntityStatus
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: datetime
    """

    _validation = {
        'location': {'required': True},
        'accessed_at': {'readonly': True},
        'count_details': {'readonly': True},
        'created_at': {'readonly': True},
        'message_count': {'readonly': True},
        'updated_at': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'accessed_at': {'key': 'properties.accessedAt', 'type': 'iso-8601'},
        'auto_delete_on_idle': {'key': 'properties.autoDeleteOnIdle', 'type': 'str'},
        'count_details': {'key': 'properties.countDetails', 'type': 'MessageCountDetails'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'default_message_time_to_live': {'key': 'properties.defaultMessageTimeToLive', 'type': 'str'},
        'dead_lettering_on_filter_evaluation_exceptions': {'key': 'properties.deadLetteringOnFilterEvaluationExceptions', 'type': 'bool'},
        'dead_lettering_on_message_expiration': {'key': 'properties.deadLetteringOnMessageExpiration', 'type': 'bool'},
        'enable_batched_operations': {'key': 'properties.enableBatchedOperations', 'type': 'bool'},
        'entity_availability_status': {'key': 'properties.entityAvailabilityStatus', 'type': 'EntityAvailabilityStatus'},
        'is_read_only': {'key': 'properties.isReadOnly', 'type': 'bool'},
        'lock_duration': {'key': 'properties.lockDuration', 'type': 'str'},
        'max_delivery_count': {'key': 'properties.maxDeliveryCount', 'type': 'int'},
        'message_count': {'key': 'properties.messageCount', 'type': 'long'},
        'requires_session': {'key': 'properties.requiresSession', 'type': 'bool'},
        'status': {'key': 'properties.status', 'type': 'EntityStatus'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(SubscriptionCreateOrUpdateParameters, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.type = kwargs.get('type', None)
        self.accessed_at = None
        self.auto_delete_on_idle = kwargs.get('auto_delete_on_idle', None)
        self.count_details = None
        self.created_at = None
        self.default_message_time_to_live = kwargs.get('default_message_time_to_live', None)
        self.dead_lettering_on_filter_evaluation_exceptions = kwargs.get('dead_lettering_on_filter_evaluation_exceptions', None)
        self.dead_lettering_on_message_expiration = kwargs.get('dead_lettering_on_message_expiration', None)
        self.enable_batched_operations = kwargs.get('enable_batched_operations', None)
        self.entity_availability_status = kwargs.get('entity_availability_status', None)
        self.is_read_only = kwargs.get('is_read_only', None)
        self.lock_duration = kwargs.get('lock_duration', None)
        self.max_delivery_count = kwargs.get('max_delivery_count', None)
        self.message_count = None
        self.requires_session = kwargs.get('requires_session', None)
        self.status = kwargs.get('status', None)
        self.updated_at = None


class SubscriptionResource(Resource):
    """Description of subscription resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :param location: Resource location.
    :type location: str
    :ivar type: Resource type
    :vartype type: str
    :ivar accessed_at: Last time there was a receive request to this
     subscription.
    :vartype accessed_at: datetime
    :param auto_delete_on_idle: TimeSpan idle interval after which the topic
     is automatically deleted. The minimum duration is 5 minutes.
    :type auto_delete_on_idle: str
    :ivar count_details:
    :vartype count_details:
     ~azure.mgmt.servicebus.v2015_08_01.models.MessageCountDetails
    :ivar created_at: Exact time the message was created.
    :vartype created_at: datetime
    :param default_message_time_to_live: Default message time to live value.
     This is the duration after which the message expires, starting from when
     the message is sent to Service Bus. This is the default value used when
     TimeToLive is not set on a message itself.
    :type default_message_time_to_live: str
    :param dead_lettering_on_filter_evaluation_exceptions: Value that
     indicates whether a subscription has dead letter support on filter
     evaluation exceptions.
    :type dead_lettering_on_filter_evaluation_exceptions: bool
    :param dead_lettering_on_message_expiration: Value that indicates whether
     a subscription has dead letter support when a message expires.
    :type dead_lettering_on_message_expiration: bool
    :param enable_batched_operations: Value that indicates whether server-side
     batched operations are enabled.
    :type enable_batched_operations: bool
    :param entity_availability_status: Entity availability status for the
     topic. Possible values include: 'Available', 'Limited', 'Renaming',
     'Restoring', 'Unknown'
    :type entity_availability_status: str or
     ~azure.mgmt.servicebus.v2015_08_01.models.EntityAvailabilityStatus
    :param is_read_only: Value that indicates whether the entity description
     is read-only.
    :type is_read_only: bool
    :param lock_duration: The lock duration time span for the subscription.
    :type lock_duration: str
    :param max_delivery_count: Number of maximum deliveries.
    :type max_delivery_count: int
    :ivar message_count: Number of messages.
    :vartype message_count: long
    :param requires_session: Value indicating if a subscription supports the
     concept of sessions.
    :type requires_session: bool
    :param status: Enumerates the possible values for the status of a
     messaging entity. Possible values include: 'Active', 'Creating',
     'Deleting', 'Disabled', 'ReceiveDisabled', 'Renaming', 'Restoring',
     'SendDisabled', 'Unknown'
    :type status: str or
     ~azure.mgmt.servicebus.v2015_08_01.models.EntityStatus
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'accessed_at': {'readonly': True},
        'count_details': {'readonly': True},
        'created_at': {'readonly': True},
        'message_count': {'readonly': True},
        'updated_at': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'accessed_at': {'key': 'properties.accessedAt', 'type': 'iso-8601'},
        'auto_delete_on_idle': {'key': 'properties.autoDeleteOnIdle', 'type': 'str'},
        'count_details': {'key': 'properties.countDetails', 'type': 'MessageCountDetails'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'default_message_time_to_live': {'key': 'properties.defaultMessageTimeToLive', 'type': 'str'},
        'dead_lettering_on_filter_evaluation_exceptions': {'key': 'properties.deadLetteringOnFilterEvaluationExceptions', 'type': 'bool'},
        'dead_lettering_on_message_expiration': {'key': 'properties.deadLetteringOnMessageExpiration', 'type': 'bool'},
        'enable_batched_operations': {'key': 'properties.enableBatchedOperations', 'type': 'bool'},
        'entity_availability_status': {'key': 'properties.entityAvailabilityStatus', 'type': 'EntityAvailabilityStatus'},
        'is_read_only': {'key': 'properties.isReadOnly', 'type': 'bool'},
        'lock_duration': {'key': 'properties.lockDuration', 'type': 'str'},
        'max_delivery_count': {'key': 'properties.maxDeliveryCount', 'type': 'int'},
        'message_count': {'key': 'properties.messageCount', 'type': 'long'},
        'requires_session': {'key': 'properties.requiresSession', 'type': 'bool'},
        'status': {'key': 'properties.status', 'type': 'EntityStatus'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(SubscriptionResource, self).__init__(**kwargs)
        self.accessed_at = None
        self.auto_delete_on_idle = kwargs.get('auto_delete_on_idle', None)
        self.count_details = None
        self.created_at = None
        self.default_message_time_to_live = kwargs.get('default_message_time_to_live', None)
        self.dead_lettering_on_filter_evaluation_exceptions = kwargs.get('dead_lettering_on_filter_evaluation_exceptions', None)
        self.dead_lettering_on_message_expiration = kwargs.get('dead_lettering_on_message_expiration', None)
        self.enable_batched_operations = kwargs.get('enable_batched_operations', None)
        self.entity_availability_status = kwargs.get('entity_availability_status', None)
        self.is_read_only = kwargs.get('is_read_only', None)
        self.lock_duration = kwargs.get('lock_duration', None)
        self.max_delivery_count = kwargs.get('max_delivery_count', None)
        self.message_count = None
        self.requires_session = kwargs.get('requires_session', None)
        self.status = kwargs.get('status', None)
        self.updated_at = None


class TopicCreateOrUpdateParameters(Model):
    """Parameters supplied to the Create Or Update Topic operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Topic name.
    :type name: str
    :param location: Required. Location of the resource.
    :type location: str
    :ivar accessed_at: Last time the message was sent, or a request was
     received, for this topic.
    :vartype accessed_at: datetime
    :param auto_delete_on_idle: TimeSpan idle interval after which the topic
     is automatically deleted. The minimum duration is 5 minutes.
    :type auto_delete_on_idle: str
    :param entity_availability_status: Entity availability status for the
     topic. Possible values include: 'Available', 'Limited', 'Renaming',
     'Restoring', 'Unknown'
    :type entity_availability_status: str or
     ~azure.mgmt.servicebus.v2015_08_01.models.EntityAvailabilityStatus
    :ivar created_at: Exact time the message was created.
    :vartype created_at: datetime
    :ivar count_details:
    :vartype count_details:
     ~azure.mgmt.servicebus.v2015_08_01.models.MessageCountDetails
    :param default_message_time_to_live: Default message time to live value.
     This is the duration after which the message expires, starting from when
     the message is sent to Service Bus. This is the default value used when
     TimeToLive is not set on a message itself.
    :type default_message_time_to_live: str
    :param duplicate_detection_history_time_window: TimeSpan structure that
     defines the duration of the duplicate detection history. The default value
     is 10 minutes.
    :type duplicate_detection_history_time_window: str
    :param enable_batched_operations: Value that indicates whether server-side
     batched operations are enabled.
    :type enable_batched_operations: bool
    :param enable_express: Value that indicates whether Express Entities are
     enabled. An express topic holds a message in memory temporarily before
     writing it to persistent storage.
    :type enable_express: bool
    :param enable_partitioning: Value that indicates whether the topic to be
     partitioned across multiple message brokers is enabled.
    :type enable_partitioning: bool
    :param filtering_messages_before_publishing: Whether messages should be
     filtered before publishing.
    :type filtering_messages_before_publishing: bool
    :param is_anonymous_accessible: Value that indicates whether the message
     is accessible anonymously.
    :type is_anonymous_accessible: bool
    :param is_express:
    :type is_express: bool
    :param max_size_in_megabytes: Maximum size of the topic in megabytes,
     which is the size of the memory allocated for the topic.
    :type max_size_in_megabytes: long
    :param requires_duplicate_detection: Value indicating if this topic
     requires duplicate detection.
    :type requires_duplicate_detection: bool
    :ivar size_in_bytes: Size of the topic, in bytes.
    :vartype size_in_bytes: long
    :param status: Enumerates the possible values for the status of a
     messaging entity. Possible values include: 'Active', 'Creating',
     'Deleting', 'Disabled', 'ReceiveDisabled', 'Renaming', 'Restoring',
     'SendDisabled', 'Unknown'
    :type status: str or
     ~azure.mgmt.servicebus.v2015_08_01.models.EntityStatus
    :ivar subscription_count: Number of subscriptions.
    :vartype subscription_count: int
    :param support_ordering: Value that indicates whether the topic supports
     ordering.
    :type support_ordering: bool
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: datetime
    """

    _validation = {
        'location': {'required': True},
        'accessed_at': {'readonly': True},
        'created_at': {'readonly': True},
        'count_details': {'readonly': True},
        'size_in_bytes': {'readonly': True},
        'subscription_count': {'readonly': True},
        'updated_at': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'accessed_at': {'key': 'properties.accessedAt', 'type': 'iso-8601'},
        'auto_delete_on_idle': {'key': 'properties.autoDeleteOnIdle', 'type': 'str'},
        'entity_availability_status': {'key': 'properties.entityAvailabilityStatus', 'type': 'EntityAvailabilityStatus'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'count_details': {'key': 'properties.countDetails', 'type': 'MessageCountDetails'},
        'default_message_time_to_live': {'key': 'properties.defaultMessageTimeToLive', 'type': 'str'},
        'duplicate_detection_history_time_window': {'key': 'properties.duplicateDetectionHistoryTimeWindow', 'type': 'str'},
        'enable_batched_operations': {'key': 'properties.enableBatchedOperations', 'type': 'bool'},
        'enable_express': {'key': 'properties.enableExpress', 'type': 'bool'},
        'enable_partitioning': {'key': 'properties.enablePartitioning', 'type': 'bool'},
        'filtering_messages_before_publishing': {'key': 'properties.filteringMessagesBeforePublishing', 'type': 'bool'},
        'is_anonymous_accessible': {'key': 'properties.isAnonymousAccessible', 'type': 'bool'},
        'is_express': {'key': 'properties.isExpress', 'type': 'bool'},
        'max_size_in_megabytes': {'key': 'properties.maxSizeInMegabytes', 'type': 'long'},
        'requires_duplicate_detection': {'key': 'properties.requiresDuplicateDetection', 'type': 'bool'},
        'size_in_bytes': {'key': 'properties.sizeInBytes', 'type': 'long'},
        'status': {'key': 'properties.status', 'type': 'EntityStatus'},
        'subscription_count': {'key': 'properties.subscriptionCount', 'type': 'int'},
        'support_ordering': {'key': 'properties.supportOrdering', 'type': 'bool'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(TopicCreateOrUpdateParameters, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.location = kwargs.get('location', None)
        self.accessed_at = None
        self.auto_delete_on_idle = kwargs.get('auto_delete_on_idle', None)
        self.entity_availability_status = kwargs.get('entity_availability_status', None)
        self.created_at = None
        self.count_details = None
        self.default_message_time_to_live = kwargs.get('default_message_time_to_live', None)
        self.duplicate_detection_history_time_window = kwargs.get('duplicate_detection_history_time_window', None)
        self.enable_batched_operations = kwargs.get('enable_batched_operations', None)
        self.enable_express = kwargs.get('enable_express', None)
        self.enable_partitioning = kwargs.get('enable_partitioning', None)
        self.filtering_messages_before_publishing = kwargs.get('filtering_messages_before_publishing', None)
        self.is_anonymous_accessible = kwargs.get('is_anonymous_accessible', None)
        self.is_express = kwargs.get('is_express', None)
        self.max_size_in_megabytes = kwargs.get('max_size_in_megabytes', None)
        self.requires_duplicate_detection = kwargs.get('requires_duplicate_detection', None)
        self.size_in_bytes = None
        self.status = kwargs.get('status', None)
        self.subscription_count = None
        self.support_ordering = kwargs.get('support_ordering', None)
        self.updated_at = None


class TopicResource(Resource):
    """Description of topic resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :param location: Resource location.
    :type location: str
    :ivar type: Resource type
    :vartype type: str
    :ivar accessed_at: Last time the message was sent, or a request was
     received, for this topic.
    :vartype accessed_at: datetime
    :param auto_delete_on_idle: TimeSpan idle interval after which the topic
     is automatically deleted. The minimum duration is 5 minutes.
    :type auto_delete_on_idle: str
    :param entity_availability_status: Entity availability status for the
     topic. Possible values include: 'Available', 'Limited', 'Renaming',
     'Restoring', 'Unknown'
    :type entity_availability_status: str or
     ~azure.mgmt.servicebus.v2015_08_01.models.EntityAvailabilityStatus
    :ivar created_at: Exact time the message was created.
    :vartype created_at: datetime
    :ivar count_details:
    :vartype count_details:
     ~azure.mgmt.servicebus.v2015_08_01.models.MessageCountDetails
    :param default_message_time_to_live: Default message time to live value.
     This is the duration after which the message expires, starting from when
     the message is sent to Service Bus. This is the default value used when
     TimeToLive is not set on a message itself.
    :type default_message_time_to_live: str
    :param duplicate_detection_history_time_window: TimeSpan structure that
     defines the duration of the duplicate detection history. The default value
     is 10 minutes.
    :type duplicate_detection_history_time_window: str
    :param enable_batched_operations: Value that indicates whether server-side
     batched operations are enabled.
    :type enable_batched_operations: bool
    :param enable_express: Value that indicates whether Express Entities are
     enabled. An express topic holds a message in memory temporarily before
     writing it to persistent storage.
    :type enable_express: bool
    :param enable_partitioning: Value that indicates whether the topic to be
     partitioned across multiple message brokers is enabled.
    :type enable_partitioning: bool
    :param filtering_messages_before_publishing: Whether messages should be
     filtered before publishing.
    :type filtering_messages_before_publishing: bool
    :param is_anonymous_accessible: Value that indicates whether the message
     is accessible anonymously.
    :type is_anonymous_accessible: bool
    :param is_express:
    :type is_express: bool
    :param max_size_in_megabytes: Maximum size of the topic in megabytes,
     which is the size of the memory allocated for the topic.
    :type max_size_in_megabytes: long
    :param requires_duplicate_detection: Value indicating if this topic
     requires duplicate detection.
    :type requires_duplicate_detection: bool
    :ivar size_in_bytes: Size of the topic, in bytes.
    :vartype size_in_bytes: long
    :param status: Enumerates the possible values for the status of a
     messaging entity. Possible values include: 'Active', 'Creating',
     'Deleting', 'Disabled', 'ReceiveDisabled', 'Renaming', 'Restoring',
     'SendDisabled', 'Unknown'
    :type status: str or
     ~azure.mgmt.servicebus.v2015_08_01.models.EntityStatus
    :ivar subscription_count: Number of subscriptions.
    :vartype subscription_count: int
    :param support_ordering: Value that indicates whether the topic supports
     ordering.
    :type support_ordering: bool
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'accessed_at': {'readonly': True},
        'created_at': {'readonly': True},
        'count_details': {'readonly': True},
        'size_in_bytes': {'readonly': True},
        'subscription_count': {'readonly': True},
        'updated_at': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'accessed_at': {'key': 'properties.accessedAt', 'type': 'iso-8601'},
        'auto_delete_on_idle': {'key': 'properties.autoDeleteOnIdle', 'type': 'str'},
        'entity_availability_status': {'key': 'properties.entityAvailabilityStatus', 'type': 'EntityAvailabilityStatus'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'count_details': {'key': 'properties.countDetails', 'type': 'MessageCountDetails'},
        'default_message_time_to_live': {'key': 'properties.defaultMessageTimeToLive', 'type': 'str'},
        'duplicate_detection_history_time_window': {'key': 'properties.duplicateDetectionHistoryTimeWindow', 'type': 'str'},
        'enable_batched_operations': {'key': 'properties.enableBatchedOperations', 'type': 'bool'},
        'enable_express': {'key': 'properties.enableExpress', 'type': 'bool'},
        'enable_partitioning': {'key': 'properties.enablePartitioning', 'type': 'bool'},
        'filtering_messages_before_publishing': {'key': 'properties.filteringMessagesBeforePublishing', 'type': 'bool'},
        'is_anonymous_accessible': {'key': 'properties.isAnonymousAccessible', 'type': 'bool'},
        'is_express': {'key': 'properties.isExpress', 'type': 'bool'},
        'max_size_in_megabytes': {'key': 'properties.maxSizeInMegabytes', 'type': 'long'},
        'requires_duplicate_detection': {'key': 'properties.requiresDuplicateDetection', 'type': 'bool'},
        'size_in_bytes': {'key': 'properties.sizeInBytes', 'type': 'long'},
        'status': {'key': 'properties.status', 'type': 'EntityStatus'},
        'subscription_count': {'key': 'properties.subscriptionCount', 'type': 'int'},
        'support_ordering': {'key': 'properties.supportOrdering', 'type': 'bool'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(TopicResource, self).__init__(**kwargs)
        self.accessed_at = None
        self.auto_delete_on_idle = kwargs.get('auto_delete_on_idle', None)
        self.entity_availability_status = kwargs.get('entity_availability_status', None)
        self.created_at = None
        self.count_details = None
        self.default_message_time_to_live = kwargs.get('default_message_time_to_live', None)
        self.duplicate_detection_history_time_window = kwargs.get('duplicate_detection_history_time_window', None)
        self.enable_batched_operations = kwargs.get('enable_batched_operations', None)
        self.enable_express = kwargs.get('enable_express', None)
        self.enable_partitioning = kwargs.get('enable_partitioning', None)
        self.filtering_messages_before_publishing = kwargs.get('filtering_messages_before_publishing', None)
        self.is_anonymous_accessible = kwargs.get('is_anonymous_accessible', None)
        self.is_express = kwargs.get('is_express', None)
        self.max_size_in_megabytes = kwargs.get('max_size_in_megabytes', None)
        self.requires_duplicate_detection = kwargs.get('requires_duplicate_detection', None)
        self.size_in_bytes = None
        self.status = kwargs.get('status', None)
        self.subscription_count = None
        self.support_ordering = kwargs.get('support_ordering', None)
        self.updated_at = None
