# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import ServiceBusManagementClientConfiguration
from .operations import Operations
from .operations import NamespacesOperations
from .operations import QueuesOperations
from .operations import TopicsOperations
from .operations import SubscriptionsOperations
from . import models


class ServiceBusManagementClient(SDKClient):
    """Azure Service Bus client

    :ivar config: Configuration for client.
    :vartype config: ServiceBusManagementClientConfiguration

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.servicebus.v2015_08_01.operations.Operations
    :ivar namespaces: Namespaces operations
    :vartype namespaces: azure.mgmt.servicebus.v2015_08_01.operations.NamespacesOperations
    :ivar queues: Queues operations
    :vartype queues: azure.mgmt.servicebus.v2015_08_01.operations.QueuesOperations
    :ivar topics: Topics operations
    :vartype topics: azure.mgmt.servicebus.v2015_08_01.operations.TopicsOperations
    :ivar subscriptions: Subscriptions operations
    :vartype subscriptions: azure.mgmt.servicebus.v2015_08_01.operations.SubscriptionsOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Subscription credentials that uniquely identify a
     Microsoft Azure subscription. The subscription ID forms part of the URI
     for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = ServiceBusManagementClientConfiguration(credentials, subscription_id, base_url)
        super(ServiceBusManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2015-08-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.namespaces = NamespacesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.queues = QueuesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.topics = TopicsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.subscriptions = SubscriptionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
