# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

import uuid
from msrest.pipeline import ClientRawResponse

from .. import models


class RemediationsOperations(object):
    """RemediationsOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    :ivar management_groups_namespace: The namespace for Microsoft Management RP; only "Microsoft.Management" is allowed. Constant value: "Microsoft.Management".
    :ivar api_version: Client Api Version. Constant value: "2018-07-01-preview".
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self.management_groups_namespace = "Microsoft.Management"
        self.api_version = "2018-07-01-preview"

        self.config = config

    def list_deployments_at_management_group(
            self, management_group_id, remediation_name, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Gets all deployments for a remediation at management group scope.

        :param management_group_id: Management group ID.
        :type management_group_id: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of RemediationDeployment
        :rtype:
         ~azure.mgmt.policyinsights.models.RemediationDeploymentPaged[~azure.mgmt.policyinsights.models.RemediationDeployment]
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top

        def internal_paging(next_link=None, raw=False):

            if not next_link:
                # Construct URL
                url = self.list_deployments_at_management_group.metadata['url']
                path_format_arguments = {
                    'managementGroupsNamespace': self._serialize.url("self.management_groups_namespace", self.management_groups_namespace, 'str'),
                    'managementGroupId': self._serialize.url("management_group_id", management_group_id, 'str'),
                    'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
                }
                url = self._client.format_url(url, **path_format_arguments)

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if top is not None:
                    query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self.config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

            # Construct and send request
            request = self._client.post(url, query_parameters, header_parameters)
            response = self._client.send(request, stream=False, **operation_config)

            if response.status_code not in [200]:
                raise models.ErrorResponseException(self._deserialize, response)

            return response

        # Deserialize response
        deserialized = models.RemediationDeploymentPaged(internal_paging, self._deserialize.dependencies)

        if raw:
            header_dict = {}
            client_raw_response = models.RemediationDeploymentPaged(internal_paging, self._deserialize.dependencies, header_dict)
            return client_raw_response

        return deserialized
    list_deployments_at_management_group.metadata = {'url': '/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/listDeployments'}

    def cancel_at_management_group(
            self, management_group_id, remediation_name, custom_headers=None, raw=False, **operation_config):
        """Cancels a remediation at management group scope.

        :param management_group_id: Management group ID.
        :type management_group_id: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Remediation or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.Remediation or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.cancel_at_management_group.metadata['url']
        path_format_arguments = {
            'managementGroupsNamespace': self._serialize.url("self.management_groups_namespace", self.management_groups_namespace, 'str'),
            'managementGroupId': self._serialize.url("management_group_id", management_group_id, 'str'),
            'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Remediation', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    cancel_at_management_group.metadata = {'url': '/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/cancel'}

    def list_for_management_group(
            self, management_group_id, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Gets all remediations for the management group.

        :param management_group_id: Management group ID.
        :type management_group_id: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of Remediation
        :rtype:
         ~azure.mgmt.policyinsights.models.RemediationPaged[~azure.mgmt.policyinsights.models.Remediation]
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        filter = None
        if query_options is not None:
            filter = query_options.filter

        def internal_paging(next_link=None, raw=False):

            if not next_link:
                # Construct URL
                url = self.list_for_management_group.metadata['url']
                path_format_arguments = {
                    'managementGroupsNamespace': self._serialize.url("self.management_groups_namespace", self.management_groups_namespace, 'str'),
                    'managementGroupId': self._serialize.url("management_group_id", management_group_id, 'str')
                }
                url = self._client.format_url(url, **path_format_arguments)

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if top is not None:
                    query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
                if filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self.config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            response = self._client.send(request, stream=False, **operation_config)

            if response.status_code not in [200]:
                raise models.ErrorResponseException(self._deserialize, response)

            return response

        # Deserialize response
        deserialized = models.RemediationPaged(internal_paging, self._deserialize.dependencies)

        if raw:
            header_dict = {}
            client_raw_response = models.RemediationPaged(internal_paging, self._deserialize.dependencies, header_dict)
            return client_raw_response

        return deserialized
    list_for_management_group.metadata = {'url': '/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations'}

    def create_or_update_at_management_group(
            self, management_group_id, remediation_name, parameters, custom_headers=None, raw=False, **operation_config):
        """Creates or updates a remediation at management group scope.

        :param management_group_id: Management group ID.
        :type management_group_id: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param parameters: The remediation parameters.
        :type parameters: ~azure.mgmt.policyinsights.models.Remediation
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Remediation or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.Remediation or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.create_or_update_at_management_group.metadata['url']
        path_format_arguments = {
            'managementGroupsNamespace': self._serialize.url("self.management_groups_namespace", self.management_groups_namespace, 'str'),
            'managementGroupId': self._serialize.url("management_group_id", management_group_id, 'str'),
            'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct body
        body_content = self._serialize.body(parameters, 'Remediation')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 201]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Remediation', response)
        if response.status_code == 201:
            deserialized = self._deserialize('Remediation', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_or_update_at_management_group.metadata = {'url': '/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}'}

    def get_at_management_group(
            self, management_group_id, remediation_name, custom_headers=None, raw=False, **operation_config):
        """Gets an existing remediation at management group scope.

        :param management_group_id: Management group ID.
        :type management_group_id: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Remediation or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.Remediation or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.get_at_management_group.metadata['url']
        path_format_arguments = {
            'managementGroupsNamespace': self._serialize.url("self.management_groups_namespace", self.management_groups_namespace, 'str'),
            'managementGroupId': self._serialize.url("management_group_id", management_group_id, 'str'),
            'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Remediation', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_at_management_group.metadata = {'url': '/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}'}

    def delete_at_management_group(
            self, management_group_id, remediation_name, custom_headers=None, raw=False, **operation_config):
        """Deletes an existing remediation at management group scope.

        :param management_group_id: Management group ID.
        :type management_group_id: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Remediation or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.Remediation or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.delete_at_management_group.metadata['url']
        path_format_arguments = {
            'managementGroupsNamespace': self._serialize.url("self.management_groups_namespace", self.management_groups_namespace, 'str'),
            'managementGroupId': self._serialize.url("management_group_id", management_group_id, 'str'),
            'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 204]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Remediation', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_at_management_group.metadata = {'url': '/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}'}

    def list_deployments_at_subscription(
            self, subscription_id, remediation_name, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Gets all deployments for a remediation at subscription scope.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of RemediationDeployment
        :rtype:
         ~azure.mgmt.policyinsights.models.RemediationDeploymentPaged[~azure.mgmt.policyinsights.models.RemediationDeployment]
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top

        def internal_paging(next_link=None, raw=False):

            if not next_link:
                # Construct URL
                url = self.list_deployments_at_subscription.metadata['url']
                path_format_arguments = {
                    'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
                    'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
                }
                url = self._client.format_url(url, **path_format_arguments)

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if top is not None:
                    query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self.config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

            # Construct and send request
            request = self._client.post(url, query_parameters, header_parameters)
            response = self._client.send(request, stream=False, **operation_config)

            if response.status_code not in [200]:
                raise models.ErrorResponseException(self._deserialize, response)

            return response

        # Deserialize response
        deserialized = models.RemediationDeploymentPaged(internal_paging, self._deserialize.dependencies)

        if raw:
            header_dict = {}
            client_raw_response = models.RemediationDeploymentPaged(internal_paging, self._deserialize.dependencies, header_dict)
            return client_raw_response

        return deserialized
    list_deployments_at_subscription.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/listDeployments'}

    def cancel_at_subscription(
            self, subscription_id, remediation_name, custom_headers=None, raw=False, **operation_config):
        """Cancels a remediation at subscription scope.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Remediation or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.Remediation or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.cancel_at_subscription.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Remediation', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    cancel_at_subscription.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/cancel'}

    def list_for_subscription(
            self, subscription_id, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Gets all remediations for the subscription.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of Remediation
        :rtype:
         ~azure.mgmt.policyinsights.models.RemediationPaged[~azure.mgmt.policyinsights.models.Remediation]
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        filter = None
        if query_options is not None:
            filter = query_options.filter

        def internal_paging(next_link=None, raw=False):

            if not next_link:
                # Construct URL
                url = self.list_for_subscription.metadata['url']
                path_format_arguments = {
                    'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str')
                }
                url = self._client.format_url(url, **path_format_arguments)

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if top is not None:
                    query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
                if filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self.config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            response = self._client.send(request, stream=False, **operation_config)

            if response.status_code not in [200]:
                raise models.ErrorResponseException(self._deserialize, response)

            return response

        # Deserialize response
        deserialized = models.RemediationPaged(internal_paging, self._deserialize.dependencies)

        if raw:
            header_dict = {}
            client_raw_response = models.RemediationPaged(internal_paging, self._deserialize.dependencies, header_dict)
            return client_raw_response

        return deserialized
    list_for_subscription.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations'}

    def create_or_update_at_subscription(
            self, subscription_id, remediation_name, parameters, custom_headers=None, raw=False, **operation_config):
        """Creates or updates a remediation at subscription scope.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param parameters: The remediation parameters.
        :type parameters: ~azure.mgmt.policyinsights.models.Remediation
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Remediation or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.Remediation or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.create_or_update_at_subscription.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct body
        body_content = self._serialize.body(parameters, 'Remediation')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 201]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Remediation', response)
        if response.status_code == 201:
            deserialized = self._deserialize('Remediation', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_or_update_at_subscription.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}'}

    def get_at_subscription(
            self, subscription_id, remediation_name, custom_headers=None, raw=False, **operation_config):
        """Gets an existing remediation at subscription scope.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Remediation or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.Remediation or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.get_at_subscription.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Remediation', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_at_subscription.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}'}

    def delete_at_subscription(
            self, subscription_id, remediation_name, custom_headers=None, raw=False, **operation_config):
        """Deletes an existing remediation at subscription scope.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Remediation or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.Remediation or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.delete_at_subscription.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 204]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Remediation', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_at_subscription.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}'}

    def list_deployments_at_resource_group(
            self, subscription_id, resource_group_name, remediation_name, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Gets all deployments for a remediation at resource group scope.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of RemediationDeployment
        :rtype:
         ~azure.mgmt.policyinsights.models.RemediationDeploymentPaged[~azure.mgmt.policyinsights.models.RemediationDeployment]
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top

        def internal_paging(next_link=None, raw=False):

            if not next_link:
                # Construct URL
                url = self.list_deployments_at_resource_group.metadata['url']
                path_format_arguments = {
                    'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
                    'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
                    'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
                }
                url = self._client.format_url(url, **path_format_arguments)

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if top is not None:
                    query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self.config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

            # Construct and send request
            request = self._client.post(url, query_parameters, header_parameters)
            response = self._client.send(request, stream=False, **operation_config)

            if response.status_code not in [200]:
                raise models.ErrorResponseException(self._deserialize, response)

            return response

        # Deserialize response
        deserialized = models.RemediationDeploymentPaged(internal_paging, self._deserialize.dependencies)

        if raw:
            header_dict = {}
            client_raw_response = models.RemediationDeploymentPaged(internal_paging, self._deserialize.dependencies, header_dict)
            return client_raw_response

        return deserialized
    list_deployments_at_resource_group.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/listDeployments'}

    def cancel_at_resource_group(
            self, subscription_id, resource_group_name, remediation_name, custom_headers=None, raw=False, **operation_config):
        """Cancels a remediation at resource group scope.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Remediation or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.Remediation or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.cancel_at_resource_group.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Remediation', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    cancel_at_resource_group.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/cancel'}

    def list_for_resource_group(
            self, subscription_id, resource_group_name, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Gets all remediations for the subscription.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of Remediation
        :rtype:
         ~azure.mgmt.policyinsights.models.RemediationPaged[~azure.mgmt.policyinsights.models.Remediation]
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        filter = None
        if query_options is not None:
            filter = query_options.filter

        def internal_paging(next_link=None, raw=False):

            if not next_link:
                # Construct URL
                url = self.list_for_resource_group.metadata['url']
                path_format_arguments = {
                    'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
                    'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str')
                }
                url = self._client.format_url(url, **path_format_arguments)

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if top is not None:
                    query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
                if filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self.config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            response = self._client.send(request, stream=False, **operation_config)

            if response.status_code not in [200]:
                raise models.ErrorResponseException(self._deserialize, response)

            return response

        # Deserialize response
        deserialized = models.RemediationPaged(internal_paging, self._deserialize.dependencies)

        if raw:
            header_dict = {}
            client_raw_response = models.RemediationPaged(internal_paging, self._deserialize.dependencies, header_dict)
            return client_raw_response

        return deserialized
    list_for_resource_group.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations'}

    def create_or_update_at_resource_group(
            self, subscription_id, resource_group_name, remediation_name, parameters, custom_headers=None, raw=False, **operation_config):
        """Creates or updates a remediation at resource group scope.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param parameters: The remediation parameters.
        :type parameters: ~azure.mgmt.policyinsights.models.Remediation
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Remediation or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.Remediation or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.create_or_update_at_resource_group.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct body
        body_content = self._serialize.body(parameters, 'Remediation')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 201]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Remediation', response)
        if response.status_code == 201:
            deserialized = self._deserialize('Remediation', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_or_update_at_resource_group.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}'}

    def get_at_resource_group(
            self, subscription_id, resource_group_name, remediation_name, custom_headers=None, raw=False, **operation_config):
        """Gets an existing remediation at resource group scope.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Remediation or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.Remediation or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.get_at_resource_group.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Remediation', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_at_resource_group.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}'}

    def delete_at_resource_group(
            self, subscription_id, resource_group_name, remediation_name, custom_headers=None, raw=False, **operation_config):
        """Deletes an existing remediation at resource group scope.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Remediation or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.Remediation or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.delete_at_resource_group.metadata['url']
        path_format_arguments = {
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 204]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Remediation', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_at_resource_group.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}'}

    def list_deployments_at_resource(
            self, resource_id, remediation_name, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Gets all deployments for a remediation at resource scope.

        :param resource_id: Resource ID.
        :type resource_id: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of RemediationDeployment
        :rtype:
         ~azure.mgmt.policyinsights.models.RemediationDeploymentPaged[~azure.mgmt.policyinsights.models.RemediationDeployment]
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top

        def internal_paging(next_link=None, raw=False):

            if not next_link:
                # Construct URL
                url = self.list_deployments_at_resource.metadata['url']
                path_format_arguments = {
                    'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True),
                    'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
                }
                url = self._client.format_url(url, **path_format_arguments)

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if top is not None:
                    query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self.config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

            # Construct and send request
            request = self._client.post(url, query_parameters, header_parameters)
            response = self._client.send(request, stream=False, **operation_config)

            if response.status_code not in [200]:
                raise models.ErrorResponseException(self._deserialize, response)

            return response

        # Deserialize response
        deserialized = models.RemediationDeploymentPaged(internal_paging, self._deserialize.dependencies)

        if raw:
            header_dict = {}
            client_raw_response = models.RemediationDeploymentPaged(internal_paging, self._deserialize.dependencies, header_dict)
            return client_raw_response

        return deserialized
    list_deployments_at_resource.metadata = {'url': '/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/listDeployments'}

    def cancel_at_resource(
            self, resource_id, remediation_name, custom_headers=None, raw=False, **operation_config):
        """Cancel a remediation at resource scope.

        :param resource_id: Resource ID.
        :type resource_id: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Remediation or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.Remediation or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.cancel_at_resource.metadata['url']
        path_format_arguments = {
            'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True),
            'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Remediation', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    cancel_at_resource.metadata = {'url': '/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/cancel'}

    def list_for_resource(
            self, resource_id, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Gets all remediations for a resource.

        :param resource_id: Resource ID.
        :type resource_id: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of Remediation
        :rtype:
         ~azure.mgmt.policyinsights.models.RemediationPaged[~azure.mgmt.policyinsights.models.Remediation]
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        filter = None
        if query_options is not None:
            filter = query_options.filter

        def internal_paging(next_link=None, raw=False):

            if not next_link:
                # Construct URL
                url = self.list_for_resource.metadata['url']
                path_format_arguments = {
                    'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True)
                }
                url = self._client.format_url(url, **path_format_arguments)

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if top is not None:
                    query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
                if filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self.config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            response = self._client.send(request, stream=False, **operation_config)

            if response.status_code not in [200]:
                raise models.ErrorResponseException(self._deserialize, response)

            return response

        # Deserialize response
        deserialized = models.RemediationPaged(internal_paging, self._deserialize.dependencies)

        if raw:
            header_dict = {}
            client_raw_response = models.RemediationPaged(internal_paging, self._deserialize.dependencies, header_dict)
            return client_raw_response

        return deserialized
    list_for_resource.metadata = {'url': '/{resourceId}/providers/Microsoft.PolicyInsights/remediations'}

    def create_or_update_at_resource(
            self, resource_id, remediation_name, parameters, custom_headers=None, raw=False, **operation_config):
        """Creates or updates a remediation at resource scope.

        :param resource_id: Resource ID.
        :type resource_id: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param parameters: The remediation parameters.
        :type parameters: ~azure.mgmt.policyinsights.models.Remediation
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Remediation or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.Remediation or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.create_or_update_at_resource.metadata['url']
        path_format_arguments = {
            'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True),
            'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct body
        body_content = self._serialize.body(parameters, 'Remediation')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 201]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Remediation', response)
        if response.status_code == 201:
            deserialized = self._deserialize('Remediation', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_or_update_at_resource.metadata = {'url': '/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}'}

    def get_at_resource(
            self, resource_id, remediation_name, custom_headers=None, raw=False, **operation_config):
        """Gets an existing remediation at resource scope.

        :param resource_id: Resource ID.
        :type resource_id: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Remediation or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.Remediation or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.get_at_resource.metadata['url']
        path_format_arguments = {
            'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True),
            'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Remediation', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_at_resource.metadata = {'url': '/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}'}

    def delete_at_resource(
            self, resource_id, remediation_name, custom_headers=None, raw=False, **operation_config):
        """Deletes an existing remediation at individual resource scope.

        :param resource_id: Resource ID.
        :type resource_id: str
        :param remediation_name: The name of the remediation.
        :type remediation_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Remediation or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.Remediation or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.mgmt.policyinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.delete_at_resource.metadata['url']
        path_format_arguments = {
            'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True),
            'remediationName': self._serialize.url("remediation_name", remediation_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 204]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Remediation', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_at_resource.metadata = {'url': '/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}'}
