from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

atmel = SchLib(tool=SKIDL).add_parts(*[
        Part(name='AT42QT1010-TSHR',dest=TEMPLATE,tool=SKIDL,keywords='Touch QTouch Sensor Key',description='Single-key Touch Sensor, SOT-23-6',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,aliases=['AT42QT1011-TSHR'],pins=[
            Pin(num='1',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='SNSK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='SNS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='SYNC',do_erc=True)]),
        Part(name='AT89C2051-PU',dest=TEMPLATE,tool=SKIDL,keywords='MCS-51 8bit Flash Microcontroller',description='DIP20, 2k Flash, 128B SRAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['AT89C4051-PU'],pins=[
            Pin(num='1',name='RST/VPP',do_erc=True),
            Pin(num='2',name='(RXD)P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(TXD)P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTAL2',do_erc=True),
            Pin(num='5',name='XTAL1',do_erc=True),
            Pin(num='6',name='(~INT0~)P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(~INT1~)P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(T0)P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(T1)P3.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P3.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(AIN0)P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(AIN1)P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P1.7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='AT89C2051-SU',dest=TEMPLATE,tool=SKIDL,keywords='MCS-51 8bit Flash Microcontroller',description='SO20, 2k Flash, 128B SRAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['AT89C4051-SU'],pins=[
            Pin(num='1',name='RST/VPP',do_erc=True),
            Pin(num='2',name='(RXD)P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(TXD)P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTAL2',do_erc=True),
            Pin(num='5',name='XTAL1',do_erc=True),
            Pin(num='6',name='(~INT0~)P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(~INT1~)P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(T0)P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(T1)P3.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P3.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(AIN0)P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(AIN1)P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P1.7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='AT89S2051-PU',dest=TEMPLATE,tool=SKIDL,keywords='MCS-51 8bit Flash Microcontroller',description='PDIP20, 4k Flash, 256B SRAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['AT89S4051-24PU'],pins=[
            Pin(num='1',name='RST/VPP',do_erc=True),
            Pin(num='2',name='(RXD)P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(TXD)P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTAL2',do_erc=True),
            Pin(num='5',name='XTAL1',do_erc=True),
            Pin(num='6',name='(~INT0~)P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(~INT1~)P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(T0)P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(T1)P3.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P3.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(AIN0)P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(AIN1)P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(MOSI)P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(MISO)P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(SCK)P1.7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='AT89S2051-SU',dest=TEMPLATE,tool=SKIDL,keywords='MCS-51 8bit Flash Microcontroller',description='SO20, 4k Flash, 256B SRAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['AT89S4051-24SU'],pins=[
            Pin(num='1',name='RST/VPP',do_erc=True),
            Pin(num='2',name='(RXD)P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(TXD)P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTAL2',do_erc=True),
            Pin(num='5',name='XTAL1',do_erc=True),
            Pin(num='6',name='(~INT0~)P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(~INT1~)P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(T0)P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(T1)P3.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P3.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(AIN0)P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(AIN1)P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(MOSI)P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(MISO)P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(SCK)P1.7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='AT90CAN128-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='64k Flash, 4k SRAM, 2k EEPROM, JTAG, CAN, TQFP64',ref_prefix='U',num_units=1,fplist=['TQFP64'],do_erc=True,aliases=['AT90CAN64-16AU', 'AT90CAN32-16AU'],pins=[
            Pin(num='2',name='PE0(RXD0/PDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD0/PDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(XCK0/AIN0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(OC3A/AIN1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(OC3B/INT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(OC3C/INT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(T3/INT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(ICP3/INT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RESET',do_erc=True),
            Pin(num='30',name='(TXCAN/XCK1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(A13)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',do_erc=True),
            Pin(num='11',name='(SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(RXCAN/T1)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(A14)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',do_erc=True),
            Pin(num='12',name='(MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(T0)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(A15/CLK0)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(~WR~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(ALE)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(OC2A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(~RD~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(SCL/INT0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(A8)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',do_erc=True),
            Pin(num='16',name='(OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(SDA/INT1)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(A9)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',do_erc=True),
            Pin(num='17',name='(OC0A/OC1C)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(RXD1/INT2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(A10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',do_erc=True),
            Pin(num='18',name='PG3(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TXD1/INT3)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(A11)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',do_erc=True),
            Pin(num='19',name='PG4(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(ICP1)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(A12)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',do_erc=True)]),
        Part(name='AT90CAN128-16MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='64k Flash, 4k SRAM, 2k EEPROM, JTAG, CAN, QFN64',ref_prefix='U',num_units=1,fplist=['QFN64'],do_erc=True,aliases=['AT90CAN64-16MU', 'AT90CAN32-16MU'],pins=[
            Pin(num='2',name='PE0(RXD0/PDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD0/PDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(XCK0/AIN0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(OC3A/AIN1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(OC3B/INT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(OC3C/INT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(T3/INT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(ICP3/INT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RESET',do_erc=True),
            Pin(num='30',name='(TXCAN/XCK1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(A13)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',do_erc=True),
            Pin(num='11',name='(SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(RXCAN/T1)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(A14)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',do_erc=True),
            Pin(num='12',name='(MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(T0)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(A15/CLK0)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(~WR~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(ALE)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(OC2A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(~RD~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(SCL/INT0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(A8)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',do_erc=True),
            Pin(num='16',name='(OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(SDA/INT1)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(A9)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',do_erc=True),
            Pin(num='17',name='(OC0A/OC1C)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(RXD1/INT2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(A10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',do_erc=True),
            Pin(num='18',name='PG3(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TXD1/INT3)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(A11)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',do_erc=True),
            Pin(num='19',name='PG4(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(ICP1)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(A12)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',do_erc=True)]),
        Part(name='AT90PWM1-16MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller LightingAVR PWM',description='QFN/MLF32, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(MISO_A/OC1A/PSCIN2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MOSI_A/OC0A/~SS~)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='(MISO/PSCOUT20)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(MOSI/PSCOUT21)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(OC0B/XTAL1)PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='(ADC0/XTAL2)PE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='AREF',do_erc=True),
            Pin(num='31',name='(~RESET~/OCD)PE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(SCK_A/ADC1/ICP1A)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(CLKO/PSCIN0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(ADC2/ACMP2)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(AMP0-)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(ADC3/ACMPM/INT0)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(AMP0+)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(ACMP0)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(ADC5/INT1)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(ADC6/INT2)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(ADC7/ICP1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(SCK/ADC4/PSCOUT01)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='(~SS_A~/PSCOUT00)PD0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='AT90PWM1-16SU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller LightingAVR PWM',description='SO24, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(~SS_A~/PSCOUT00)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(~RESET~/OCD)PE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(CLKO/PSCIN0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(MISO_A/OC1A/PSCIN2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(MOSI_A/OC0A/~SS~)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='(MISO/PSCOUT20)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(MOSI/PSCOUT21)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(OC0B/XTAL1)PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(AMP0-)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(ADC0/XTAL2)PE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(AMP0+)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(SCK_A/ADC1/ICP1A)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(ADC6/INT2)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(ADC2/ACMP2)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(ADC7/ICP1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(ADC3/ACMPM/INT0)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(SCK/ADC4/PSCOUT01)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(ACMP0)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(ADC5/INT1)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='AREF',do_erc=True)]),
        Part(name='AT90S1200-4PC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller ClassicAVR',description='PDIP20, 1k Flash, No SRAM, 64B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~RESET',do_erc=True),
            Pin(num='2',name='PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTAL2',do_erc=True),
            Pin(num='5',name='XTAL1',do_erc=True),
            Pin(num='6',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(AIN0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(AIN1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='AT90S1200-4SC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller ClassicAVR',description='SO20, 1k Flash, No SRAM, 64B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~RESET',do_erc=True),
            Pin(num='2',name='PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTAL2',do_erc=True),
            Pin(num='5',name='XTAL1',do_erc=True),
            Pin(num='6',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(AIN0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(AIN1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='AT90S1200-4YC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller ClassicAVR',description='SSOP20, 1k Flash, No SRAM, 64B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~RESET',do_erc=True),
            Pin(num='2',name='PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTAL2',do_erc=True),
            Pin(num='5',name='XTAL1',do_erc=True),
            Pin(num='6',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(AIN0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(AIN1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='AT90S2313-4PC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller ClassicAVR',description='PDIP20, 2k Flash, 128B SRAM, 128B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~RESET',do_erc=True),
            Pin(num='2',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTAL2',do_erc=True),
            Pin(num='5',name='XTAL1',do_erc=True),
            Pin(num='6',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(AIN0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(AIN1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(OC1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='AT90S2313-4SC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller ClassicAVR',description='SO20, 2k Flash, 128B SRAM, 128B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~RESET',do_erc=True),
            Pin(num='2',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTAL2',do_erc=True),
            Pin(num='5',name='XTAL1',do_erc=True),
            Pin(num='6',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(AIN0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(AIN1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(OC1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='AT90S2323-4PC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller ClassicAVR',description='AT90S/LS2323, PDIP8, 2k Flash, 128B SRAM, 128B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~RESET',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='(MOSI)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(INT0/MISO)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(SCK/T0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT90S2323-4SC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller ClassicAVR',description='AT90S/LS2323, SO8 Wide, 2k Flash, 128B SRAM, 128B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~RESET',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='(MOSI)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(INT0/MISO)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(SCK/T0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT90S2333-4AC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller ClassicAVR',description='TQFP32, 4k Flash, 128B SRAM, 256B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['AT90S4433-8AC'],pins=[
            Pin(num='1',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL1',do_erc=True),
            Pin(num='8',name='XTAL2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='(T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(AIN0)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(AIN1)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(ICP)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(OC1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(ADC0)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(~SS~)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(ADC1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(MOSI)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ADC2)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(MISO)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(ADC3)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(SCK)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(ADC4)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='(ADC5)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='~RESET',do_erc=True)]),
        Part(name='AT90S2333-4PC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller ClassicAVR',description='PDIP28 Narrow, 4k Flash, 128B SRAM, 256B EEPROM',ref_prefix='U',num_units=1,fplist=['28DIP-ELL600', '28dip600'],do_erc=True,aliases=['AT90S4433-8PC'],pins=[
            Pin(num='1',name='~RESET',do_erc=True),
            Pin(num='2',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='XTAL1',do_erc=True),
            Pin(num='10',name='XTAL2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='(T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(AIN0)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='(AIN1)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(ADC0)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(ICP)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(ADC1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(OC1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ADC2)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(~SS~)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(ADC3)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(MOSI)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(ADC4)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(MISO)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(ADC5)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(SCK)PB5',func=Pin.BIDIR,do_erc=True)]),
        Part(name='AT90S2343-4PC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller ClassicAVR',description='AT90S/LS2343, PDIP8, 2k Flash, 128B SRAM, 128B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~RESET',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(CLOCK)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='(MOSI)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(INT0/MISO)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(SCK/T0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT90S2343-4SC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller ClassicAVR',description='AT90S/LS2343, SO8 Wide, 2k Flash, 128B SRAM, 128B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~RESET',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(CLOCK)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='(MOSI)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(INT0/MISO)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(SCK/T0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT90S4414-4AC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller ClassicAVR',description='TQFP44, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['AT90S8515-4AC'],pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(A10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(A11)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(~WR~)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(A12)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(~RD~)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(A13)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(A14)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(A15)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='OC1B',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ALE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(A8)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(A9)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ICP',do_erc=True)]),
        Part(name='AT90S4414-4JC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller ClassicAVR',description='PLCC44, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['AT90S8515-4JC'],pins=[
            Pin(num='2',name='(T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RESET',do_erc=True),
            Pin(num='20',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(A14)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(A15)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='OC1B',func=Pin.PWRIN,do_erc=True),
            Pin(num='42',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ALE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='43',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(A8)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(A9)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ICP',do_erc=True),
            Pin(num='16',name='PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(A10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(A11)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(~WR~)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(A12)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(~RD~)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(A13)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True)]),
        Part(name='AT90S4414-4PC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller ClassicAVR',description='PDIP40, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,fplist=['40DIP-ELL600', '40dip600'],do_erc=True,aliases=['AT90S8515-4PC'],pins=[
            Pin(num='1',name='(T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='ALE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='40',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(A8)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ICP',do_erc=True),
            Pin(num='12',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(A9)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(A10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(A11)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(A12)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(~WR~)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(A13)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(~RD~)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(A14)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(A15)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='OC1B',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='AT90S4434-4AC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller ClassicAVR',description='TQFP44, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['AT90S8535-8AC'],pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT90S4434-4JC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller ClassicAVR',description='PLCC44, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['AT90S8535-8JC'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='(T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RESET',do_erc=True),
            Pin(num='20',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='43',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True)]),
        Part(name='AT90S4434-4PC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller ClassicAVR',description='PDIP40, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,fplist=['40DIP-ELL600', '40dip600'],do_erc=True,aliases=['AT90S8535-8PC'],pins=[
            Pin(num='1',name='(T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='AT90USB162-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller USB',description='TQFP32, 16k Flash, 512B SRAM, 512B EEPROM, USB 2.0',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='XTAL1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='XTAL2(PC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='(PCINT11)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(OC0B/INT0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(AIN0/INT1)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(RXD1/AIN1/INT2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(TXD1/INT3)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(INT5)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT6)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='D-/SDATA',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(XCK/PCINT12)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(OC0A/OC1C/PCINT7)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='UVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='(~RTS~/INT6)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(ICP1/CLKO/INT4)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='(~CTS~/~HWB~/T0/INT7)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(OC1A/PCINT8)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(~SS~/PCINT0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='~RESET~(PC1/dW)',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(SCLK/PCINT1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(OC1B/PCINT9)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PDI/MOSI/PCINT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT10)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PDO/MISO/PCINT3)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='UCAP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='(T1/PCINT4)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='UGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(PCINT5)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='D+/SCK',func=Pin.BIDIR,do_erc=True)]),
        Part(name='AT90USB82-16MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller USB',description='QFN/MLF32, 8k Flash, 512B SRAM, 512B EEPROM, USB 2.0',ref_prefix='U',num_units=1,do_erc=True,aliases=['AT90USB162-16MU'],pins=[
            Pin(num='1',name='XTAL1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='XTAL2(PC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='(PCINT11)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(OC0B/INT0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(AIN0/INT1)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(RXD1/AIN1/INT2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(TXD1/INT3)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(INT5)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT6)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='D-/SDATA',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(XCK/PCINT12)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(OC0A/OC1C/PCINT7)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='UVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='(~RTS~/INT6)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(ICP1/CLKO/INT4)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='(~CTS~/~HWB~/T0/INT7)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(OC1A/PCINT8)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(~SS~/PCINT0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='~RESET~(PC1/dW)',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(SCLK/PCINT1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(OC1B/PCINT9)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PDI/MOSI/PCINT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT10)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PDO/MISO/PCINT3)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='UCAP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='(T1/PCINT4)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='UGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(PCINT5)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='D+/SCK',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA128-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP64, 128k Flash, 4k SRAM, 4k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~PEN',do_erc=True),
            Pin(num='2',name='PE0(RXD0/PDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD0/PDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(XCK0/AIN0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(OC3A/AIN1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(OC3B/INT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(OC3C/INT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(T3/INT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(IC3/INT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RESET',do_erc=True),
            Pin(num='30',name='(XCK1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(A13)PC5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',do_erc=True),
            Pin(num='11',name='(SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(T1)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(A14)PC6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='51',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',do_erc=True),
            Pin(num='12',name='(MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(T2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(A15)PC7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(~WR~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(ALE)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(OC0)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(~RD~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(SCL/INT0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(A8)PC0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',do_erc=True),
            Pin(num='16',name='(OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(SDA/INT1)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(A9)PC1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',do_erc=True),
            Pin(num='17',name='(OC2/OC1C)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(RXD1/INT2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(A10)PC2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',do_erc=True),
            Pin(num='18',name='PG3(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TXD1/INT3)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(A11)PC3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',do_erc=True),
            Pin(num='19',name='PG4(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(ICP1)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(A12)PC4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='49',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',do_erc=True)]),
        Part(name='ATMEGA128-16MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='QFN/MLF64, 128k Flash, 4k SRAM, 4k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~PEN',do_erc=True),
            Pin(num='2',name='PE0(RXD0/PDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD0/PDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(XCK0/AIN0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(OC3A/AIN1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(OC3B/INT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(OC3C/INT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(T3/INT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(IC3/INT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RESET',do_erc=True),
            Pin(num='30',name='(XCK1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(A13)PC5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',do_erc=True),
            Pin(num='11',name='(SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(T1)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(A14)PC6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='51',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',do_erc=True),
            Pin(num='12',name='(MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(T2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(A15)PC7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(~WR~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(ALE)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(OC0)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(~RD~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(SCL/INT0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(A8)PC0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',do_erc=True),
            Pin(num='16',name='(OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(SDA/INT1)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(A9)PC1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',do_erc=True),
            Pin(num='17',name='(OC2/OC1C)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(RXD1/INT2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(A10)PC2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',do_erc=True),
            Pin(num='18',name='PG3(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TXD1/INT3)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(A11)PC3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',do_erc=True),
            Pin(num='19',name='PG4(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(ICP1)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(A12)PC4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='49',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',do_erc=True)]),
        Part(name='ATMEGA1280-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP100, 64k Flash, 8k SRAM, 4k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA640-16AU', 'ATMEGA2560-16AU', 'ATMEGA1280-8AU', 'ATMEGA640-8AU', 'ATMEGA2560-8AU'],pins=[
            Pin(num='1',name='PG5(OCOB)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT8/RXD0)PE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(TXD0)PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(XCK0/AIN0)PE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(OC3A/AIN1)PE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(OC3B/INT4)PE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(OC3C/INT5)PE5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(T3/INT6)PE6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(CLKO/ICP3/INT7)PE7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(PCINT1/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='~RESET',do_erc=True),
            Pin(num='40',name='PL5(OC5C)',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='(T2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='(A15)PC7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='70',name='PG2(ALE)',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='90',name='(TDI/ADC7)PF7',do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='(PCINT2/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='PL6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PG0(~WR~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='71',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='91',name='(TD0/ADC6)PF6',do_erc=True),
            Pin(num='12',name='PH0(RXD2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT3/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='42',name='PL7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PG1(~RD~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PK7(ADC15/PCINT23)',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='(TMS/ADC5)PF5',do_erc=True),
            Pin(num='13',name='PH1(TXD2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT4/OC2A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(SCL/INT0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='(A8)PC0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='63',name='PJ0(RXD3/PCINT9)',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PK6(ADC14/PCINT22)',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='(TCK/ADC4)PF4',do_erc=True),
            Pin(num='14',name='PH2(XCK2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT5/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(SDA/INT1)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='(A9)PC1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='64',name='PJ1(TXD3/PCINT10)',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PK5(ADC13/PCINT21)',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='(ADC3)PF3',do_erc=True),
            Pin(num='15',name='PH3(OC4A)',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT6/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PL0(ICP4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='(RXD1/INT2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='(A10)PC2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='65',name='PJ2(XCK3/PCINT11)',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PK4(ADC12/PCINT20)',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='(ADC2)PF2',do_erc=True),
            Pin(num='16',name='PH4(OC4B)',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT7/OC0A/OC1C)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PL1(ICP5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='(TXD1/INT3)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='(A11)PC3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='66',name='PJ3(PCINT12)',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PK3(ADC11/PCINT19)',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='(ADC1)PF1',do_erc=True),
            Pin(num='17',name='PH5(OC4C)',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PH7(T4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PL2(T5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='(ICP1)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='(A12)PC4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='67',name='PJ4(PCINT13)',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PK2(ADC10/PCINT18)',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='(ADC0)PF0',do_erc=True),
            Pin(num='18',name='PH6(OC2B)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PG3(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PL3(OC5A)',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='(XCK1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='(A13)PC5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='68',name='PJ5(PCINT14)',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PK1(ADC9/PCINT17)',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT0/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PG4(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PL4(OC5B)',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='(T1)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='(A14)PC6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='69',name='PJ6(PCINT15)',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='PJ7',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='PK0(ADC8/PCINT16)',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='AVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA1281-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP64, 256k Flash, 8k SRAM, 4k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA2561-16AU', 'ATMEGA1281-8AU', 'ATMEGA1261-8AU'],pins=[
            Pin(num='1',name='PG5(OCOB)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE0(RXD0/PDI/PCINT8)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD0/PDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(XCK0/AIN0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(OC3A/AIN1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(OC3B/INT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(OC3C/INT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(T3/INT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(IC3/INT7/CLKO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT0/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RESET',do_erc=True),
            Pin(num='30',name='(XCK1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(A13)PC5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',do_erc=True),
            Pin(num='11',name='(PCINT1/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(T1)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(A14)PC6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='51',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',do_erc=True),
            Pin(num='12',name='(PCINT2/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(T2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(A15)PC7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT3/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(~WR~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(ALE)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(PCINT4/OC2A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(~RD~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(PCINT5/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(SCL/INT0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(A8)PC0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',do_erc=True),
            Pin(num='16',name='(PCINT6/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(SDA/INT1)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(A9)PC1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',do_erc=True),
            Pin(num='17',name='(PCINT7/OC0A/OC1C)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(RXD1/INT2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(A10)PC2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',do_erc=True),
            Pin(num='18',name='PG3(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TXD1/INT3)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(A11)PC3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',do_erc=True),
            Pin(num='19',name='PG4(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(ICP1)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(A12)PC4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='49',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',do_erc=True)]),
        Part(name='ATMEGA1281-16MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='MLF/QFN64, 256k Flash, 8k SRAM, 4k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA2561-16MU', 'ATMEGA1281-8MU', 'ATMEGA1261-8MU'],pins=[
            Pin(num='1',name='PG5(OCOB)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE0(RXD0/PDI/PCINT8)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD0/PDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(XCK0/AIN0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(OC3A/AIN1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(OC3B/INT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(OC3C/INT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(T3/INT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(IC3/INT7/CLKO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT0/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RESET',do_erc=True),
            Pin(num='30',name='(XCK1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(A13)PC5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',do_erc=True),
            Pin(num='11',name='(PCINT1/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(T1)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(A14)PC6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='51',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',do_erc=True),
            Pin(num='12',name='(PCINT2/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(T2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(A15)PC7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT3/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(~WR~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(ALE)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(PCINT4/OC2A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(~RD~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(PCINT5/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(SCL/INT0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(A8)PC0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',do_erc=True),
            Pin(num='16',name='(PCINT6/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(SDA/INT1)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(A9)PC1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',do_erc=True),
            Pin(num='17',name='(PCINT7/OC0A/OC1C)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(RXD1/INT2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(A10)PC2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',do_erc=True),
            Pin(num='18',name='PG3(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TXD1/INT3)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(A11)PC3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',do_erc=True),
            Pin(num='19',name='PG4(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(ICP1)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(A12)PC4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='49',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',do_erc=True)]),
        Part(name='ATMEGA1284-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR PicoPower',description='TQFP44, 64k Flash, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA164A-AU', 'ATMEGA164PA-AU', 'ATMEGA324A-AU', 'ATMEGA324PA-AU', 'ATMEGA644A-AU', 'ATMEGA644PA-AU', 'ATMEGA1284P-AU'],pins=[
            Pin(num='1',name='(PCINT13/MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT14/MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT15/SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT24/RXD0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT25/TXD0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT17/SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(PCINT7/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(PCINT8/T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT26/RXD1/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(PCINT18/TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(PCINT6/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(PCINT9/CLKO/T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT27/TXD1/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT19/TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(PCINT5/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(PCINT10/AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT28/XCK1/OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT20/TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(PCINT4/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(PCINT11/AIN1/OC0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT294/OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT21/TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(PCINT3/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(PCINT12/OC0B/~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT30/OC2B/ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT22/TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(PCINT2/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT31/OC2A)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT23/TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(PCINT1/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(PCINT0/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(PCINT16/SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA1284-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR PicoPower',description='VQFN44, 64k Flash, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA164A-MU', 'ATMEGA164PA-MU', 'ATMEGA324A-MU', 'ATMEGA324PA-MU', 'ATMEGA644A-MU', 'ATMEGA644PA-MU', 'ATMEGA1284P-MU'],pins=[
            Pin(num='1',name='(PCINT13/MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT14/MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT15/SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT24/RXD0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT25/TXD0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT17/SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(PCINT7/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(PCINT8/T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT26/RXD1/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(PCINT18/TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(PCINT6/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(PCINT9/CLKO/T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT27/TXD1/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT19/TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(PCINT5/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(PCINT10/AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT28/XCK1/OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT20/TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(PCINT4/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(PCINT11/AIN1/OC0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT294/OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT21/TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(PCINT3/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(PCINT12/OC0B/~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT30/OC2B/ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT22/TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(PCINT2/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT31/OC2A)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT23/TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(PCINT1/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(PCINT0/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(PCINT16/SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA1284-PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR PicoPower',description='PDIP40, 64k Flash, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,fplist=['40DIP-ELL600', '40dip600'],do_erc=True,aliases=['ATMEGA164A-PU', 'ATMEGA164PA-PU', 'ATMEGA324A-PU', 'ATMEGA324PA-PU', 'ATMEGA644A-PU', 'ATMEGA644PA-PU', 'ATMEGA1284P-PU'],pins=[
            Pin(num='1',name='(PCINT8/T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT9/CLKO/T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT10/AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT11/AIN1/OC0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT12/OC0B/~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT13/MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT14/MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT15/SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(PCINT30/OC2B/ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='(PCINT0/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='(PCINT31/OC2A)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT16/SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT17/SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(PCINT7/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT24/RXD0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT18/TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(PCINT6/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT25/TXD0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT19/TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(PCINT5/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT26/RXD1/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT20/TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(PCINT4/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT27/TXD1/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT21/TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(PCINT3/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT28/XCK1/OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(PCINT22/TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(PCINT2/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT294/OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(PCINT23/TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(PCINT1/ADC1)PA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA128A-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP64, 128k Flash, 4k SRAM, 4k EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~PEN',do_erc=True),
            Pin(num='2',name='PE0(RXD0/PDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD0/PDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(XCK0/AIN0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(OC3A/AIN1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(OC3B/INT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(OC3C/INT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(T3/INT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(ICP3/INT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RESET',do_erc=True),
            Pin(num='30',name='(XCK1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(A13)PC5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',do_erc=True),
            Pin(num='11',name='(SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(T1)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(A14)PC6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='51',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',do_erc=True),
            Pin(num='12',name='(MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(T2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(A15)PC7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(~WR~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(ALE)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(OC0)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(~RD~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(SCL/INT0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(A8)PC0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',do_erc=True),
            Pin(num='16',name='(OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(SDA/INT1)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(A9)PC1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',do_erc=True),
            Pin(num='17',name='(OC2/OC1C)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(RXD1/INT2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(A10)PC2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',do_erc=True),
            Pin(num='18',name='PG3(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TXD1/INT3)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(A11)PC3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',do_erc=True),
            Pin(num='19',name='PG4(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(ICP1)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(A12)PC4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='49',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',do_erc=True)]),
        Part(name='ATMEGA128A-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='MLF/QFN64, 128k Flash, 4k SRAM, 4k EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~PEN',do_erc=True),
            Pin(num='2',name='PE0(RXD0/PDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD0/PDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(XCK0/AIN0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(OC3A/AIN1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(OC3B/INT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(OC3C/INT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(T3/INT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(ICP3/INT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RESET',do_erc=True),
            Pin(num='30',name='(XCK1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(A13)PC5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',do_erc=True),
            Pin(num='11',name='(SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(T1)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(A14)PC6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='51',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',do_erc=True),
            Pin(num='12',name='(MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(T2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(A15)PC7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(~WR~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(ALE)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(OC0)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(~RD~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(SCL/INT0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(A8)PC0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',do_erc=True),
            Pin(num='16',name='(OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(SDA/INT1)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(A9)PC1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',do_erc=True),
            Pin(num='17',name='(OC2/OC1C)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(RXD1/INT2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(A10)PC2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',do_erc=True),
            Pin(num='18',name='PG3(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TXD1/INT3)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(A11)PC3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',do_erc=True),
            Pin(num='19',name='PG4(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(ICP1)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(A12)PC4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='49',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',do_erc=True)]),
        Part(name='ATMEGA16-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP44, 16k Flash, 1k SRAM, 512B EEPROM, JTAG',ref_prefix='U',num_units=1,fplist=['TQFP44'],do_erc=True,pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(AIN1/OC0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA16-16MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='QFN/MLF44, 16k Flash, 1k SRAM, 512B EEPROM, JTAG',ref_prefix='U',num_units=1,fplist=['MLF44'],do_erc=True,pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(AIN1/OC0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA16-16PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='PDIP40, 16k Flash, 1k SRAM, 512B EEPROM, JTAG',ref_prefix='U',num_units=1,fplist=['40DIP-ELL600', '40dip600'],do_erc=True,pins=[
            Pin(num='1',name='(T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(AIN1/OC0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA161-4AC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP44, 16k Flash, 1K SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='(RXD0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(TXD0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(TOSC1)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(A10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(OC0/T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(OC1A/TOSC2)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(A11)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(OC2/T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(~WR~)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(A12)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(RXD1/AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(~RD~)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(A13)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(TXD1/AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(A14)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(A15)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='PE2(OC1B)',func=Pin.OUTPUT,do_erc=True),
            Pin(num='36',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PE1(ALE)',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(A8)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(A9)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PE0(ICP/INT2)',do_erc=True)]),
        Part(name='ATMEGA161-4PC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='PDIP40, 16k Flash, 1K SRAM, 512B EEPROM',ref_prefix='U',num_units=1,fplist=['40DIP-ELL600', '40dip600'],do_erc=True,pins=[
            Pin(num='1',name='(OC0/T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(OC2/T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(RXD1/AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(TXD1/AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='(RXD0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='PE1(ALE)',func=Pin.OUTPUT,do_erc=True),
            Pin(num='40',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='(TXD0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(A8)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PE0(ICP/INT2)',do_erc=True),
            Pin(num='12',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(A9)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(A10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(TOSC1)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(A11)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(OC1A/TOSC2)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(A12)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(~WR~)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(A13)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(~RD~)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(A14)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(A15)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PE2(OC1B)',func=Pin.OUTPUT,do_erc=True),
            Pin(num='39',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA162-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP44, 16k Flash, 1K SRAM, 512B EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='(RXD0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(TXD0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(XCK1/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(ICP3/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(XCK0/OC3A/TOSC1)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT10/A10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(PCINT7/AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(OC0/T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(OC1A/TOSC2)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(PCINT11/A11)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(PCINT6/AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(OC2/T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(~WR~)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT12/TCK/A12)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(PCINT5/AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(RXD1/AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(~RD~)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT13/TMS/A13)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(PCINT4/AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(TXD1/AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT14/TDO/A14)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(PCINT3/AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(OC3B/~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT15/TDI/A15)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(PCINT2/AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='PE2(OC1B)',func=Pin.OUTPUT,do_erc=True),
            Pin(num='36',name='(PCINT1/AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='PE1(ALE)',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='(PCINT0/AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT8/A8)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(PCINT9/A9)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PE0(ICP/INT2)',do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA162-16MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='QFN/MLF44, 16k Flash, 1K SRAM, 512B EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='(RXD0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(TXD0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(XCK1/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(ICP3/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(XCK0/OC3A/TOSC1)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT10/A10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(PCINT7/AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(OC0/T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(OC1A/TOSC2)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(PCINT11/A11)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(PCINT6/AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(OC2/T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(~WR~)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT12/TCK/A12)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(PCINT5/AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(RXD1/AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(~RD~)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT13/TMS/A13)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(PCINT4/AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(TXD1/AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT14/TDO/A14)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(PCINT3/AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(OC3B/~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT15/TDI/A15)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(PCINT2/AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='PE2(OC1B)',func=Pin.OUTPUT,do_erc=True),
            Pin(num='36',name='(PCINT1/AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='PE1(ALE)',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='(PCINT0/AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT8/A8)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(PCINT9/A9)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PE0(ICP/INT2)',do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA162-16PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='PDIP40, 16k Flash, 1K SRAM, 512B EEPROM, JTAG',ref_prefix='U',num_units=1,fplist=['40DIP-ELL600', '40dip600'],do_erc=True,pins=[
            Pin(num='1',name='(OC0/T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(OC2/T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(RXD1/AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(TXD1/AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(OC3B/~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='(RXD0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='PE1(ALE)',func=Pin.OUTPUT,do_erc=True),
            Pin(num='40',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='(TXD0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(PCINT8/A8)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PE0(ICP/INT2)',do_erc=True),
            Pin(num='12',name='(XCK1/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT9/A9)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(PCINT7/AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(ICP3/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT10/A10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(PCINT6/AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(XCK0/OC3A/TOSC1)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT11/A11)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(PCINT5/AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(OC1A/TOSC2)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT12/TCK/A12)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(PCINT4/AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(~WR~)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT13/TMS/A13)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(PCINT3/AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(~RD~)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT14/TDO/A14)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(PCINT2/AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(PCINT15/TDI/A15)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(PCINT1/AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PE2(OC1B)',func=Pin.OUTPUT,do_erc=True),
            Pin(num='39',name='(PCINT0/AD0)PA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA163-4AC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP44, 16k Flash, 1k SRAM, 512B EEPROM',ref_prefix='U',num_units=1,fplist=['TQFP44'],do_erc=True,pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA163-4PC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='PDIP40, 16k Flash, 1k SRAM, 512B EEPROM',ref_prefix='U',num_units=1,fplist=['40DIP-ELL600', '40dip600'],do_erc=True,pins=[
            Pin(num='1',name='(T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA164P-20AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR PicoPower',description='TQFP44, 64k Flash, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA324P-20AU', 'ATMEGA644P-20AU'],pins=[
            Pin(num='1',name='(PCINT13/MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT14/MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT15/SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT24/RXD0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT25/TXD0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT17/SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(PCINT7/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(PCINT8/T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT26/RXD1/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(PCINT18/TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(PCINT6/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(PCINT9/CLKO/T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT27/TXD1/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT20/TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(PCINT5/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(PCINT10/AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT28/XCK1/OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT21/TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(PCINT4/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(PCINT11/AIN1/OC0A)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT29/OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT22/TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(PCINT3/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(PCINT12/OC0B/~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT30/OC2B/ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT23/TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(PCINT2/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT31/OC2A)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT24/TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(PCINT1/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(PCINT0/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(PCINT16/SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA164P-20MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR PicoPower',description='MLF/QFN44, 64k Flash, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA324P-20MU', 'ATMEGA644P-20MU'],pins=[
            Pin(num='1',name='(PCINT13/MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT14/MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT15/SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT24/RXD0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT25/TXD0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT17/SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(PCINT7/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(PCINT8/T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT26/RXD1/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(PCINT18/TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(PCINT6/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(PCINT9/CLKO/T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT27/TXD1/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT20/TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(PCINT5/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(PCINT10/AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT28/XCK1/OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT21/TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(PCINT4/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(PCINT11/AIN1/OC0A)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT29/OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT22/TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(PCINT3/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(PCINT12/OC0B/~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT30/OC2B/ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT23/TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(PCINT2/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT31/OC2A)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT24/TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(PCINT1/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(PCINT0/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(PCINT16/SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA164P-20PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR PicoPower',description='PDIP40, 64k Flash, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,fplist=['40DIP-ELL600', '40dip600'],do_erc=True,aliases=['ATMEGA324P-20PU', 'ATMEGA644P-20PU'],pins=[
            Pin(num='1',name='(PCINT8/T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT9/CLKO/T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT10/AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT11/AIN1/OC0A)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT12/OC0B/~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT13/MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT14/MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT15/SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(PCINT30/OC2B/ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='(PCINT0/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='(PCINT31/OC2A)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT16/SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT17/SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(PCINT7/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT24/RXD0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT18/TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(PCINT6/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT25/TXD0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT20/TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(PCINT5/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT26/RXD1/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT21/TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(PCINT4/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT27/TXD1/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT22/TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(PCINT3/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT28/XCK1/OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(PCINT23/TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(PCINT2/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT29/OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(PCINT24/TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(PCINT1/ADC1)PA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA165-8AI',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP64, 16k Flash, 1k SRAM, 512k EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='2',name='PE0(RXD/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(AIN0/XCK/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(AIN1/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(USCK/SCL/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(DI/SDA/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(DO/PCINT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(CLKO/PCINT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT8/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RESET',do_erc=True),
            Pin(num='30',name='PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT9/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT10/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(PCINT12/OC0A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(PCINT13/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ICP1)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT14/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(INT0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT15/OC2A)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG3(T1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PG4(T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA165-8MI',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='QFN/MLF64, 16k Flash, 1k SRAM, 512k EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='2',name='PE0(RXD/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(AIN0/XCK/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(AIN1/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(USCK/SCL/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(DI/SDA/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(DO/PCINT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(CLKO/PCINT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT8/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RESET',do_erc=True),
            Pin(num='30',name='PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT9/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT10/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(PCINT12/OC0A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(PCINT13/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ICP1)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT14/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(INT0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT15/OC2A)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG3(T1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PG4(T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA165P-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR PicoPower',description='TQFP64, 16k Flash, 1k SRAM, 512k EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='2',name='PE0(RXD/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(AIN0/XCK/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(AIN1/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(USCK/SCL/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(DI/SDA/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(DO/PCINT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(CLKO/PCINT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT8/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RESET',do_erc=True),
            Pin(num='30',name='PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT9/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT10/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(PCINT12/OC0A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(PCINT13/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ICP1)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT14/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(INT0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT15/OC2A)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG3(T1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PG4(T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA165P-16MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR PicoPower',description='QFN/MLF64, 16k Flash, 1k SRAM, 512k EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='2',name='PE0(RXD/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(AIN0/XCK/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(AIN1/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(USCK/SCL/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(DI/SDA/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(DO/PCINT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(CLKO/PCINT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT8/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RESET',do_erc=True),
            Pin(num='30',name='PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT9/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT10/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(PCINT12/OC0A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(PCINT13/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ICP1)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT14/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(INT0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT15/OC2A)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG3(T1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PG4(T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA165PA-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR PicoPower',description='TQFP64, 64k Flash, 4k SRAM, 2k EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA165A-AU', 'ATMEGA325A-AU', 'ATMEGA325PA-AU', 'ATMEGA645A-AU', 'ATMEGA645P-AU'],pins=[
            Pin(num='2',name='PE0(RXD/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(AIN0/XCK/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(AIN1/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(USCK/SCL/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(DI/SDA/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(DO/PCINT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(CLKO/PCINT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT8/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PG5(~RESET~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT9/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT10/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(PCINT12/OC0A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(PCINT13/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ICP1)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT14/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(INT0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT15/OC2A)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG3(T1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PG4(T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA165PA-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR PicoPower',description='QFN/MLF64, 64k Flash, 4k SRAM, 2k EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA165A-MU', 'ATMEGA325A-MU', 'ATMEGA325PA-MU', 'ATMEGA645A-MU', 'ATMEGA645P-MU'],pins=[
            Pin(num='2',name='PE0(RXD/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(AIN0/XCK/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(AIN1/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(USCK/SCL/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(DI/SDA/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(DO/PCINT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(CLKO/PCINT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT8/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PG5(~RESET~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT9/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT10/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(PCINT12/OC0A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(PCINT13/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ICP1)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT14/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(INT0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT15/OC2A)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG3(T1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PG4(T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA168-20AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP32, 8k Flash, 512B SRAM, 1k EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA48-20AU', 'ATMEGA88-20AU'],pins=[
            Pin(num='1',name='(PCINT19/OC2B/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT20/XCK/T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(PCINT6/XTAL1/TOSC1)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT7/XTAL2/TOSC2)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT21/OC0B/T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT22/OC0A/AIN0)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(PCINT16/RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT23/AIN1)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(PCINT17/TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT0/CLKO/ICP1)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC7',do_erc=True),
            Pin(num='32',name='(PCINT18/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT1/OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT8/ADC0)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT2/OC1B/~SS~)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT9/ADC1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT3/OC2/MOSI)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT10/ADC2)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT4/MISO)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT11/ADC3)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT5/SCK)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT12/SDA/ADC4)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='(PCINT13/SCL/ADC5)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='ADC6',do_erc=True),
            Pin(num='29',name='(PCINT14/~RESET~)PC6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA168-20MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='QFN/MLF32, 8k Flash, 512B SRAM, 1k EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA48-20MU', 'ATMEGA88-20MU'],pins=[
            Pin(num='1',name='(PCINT19/OC2B/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT20/XCK/T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(PCINT6/XTAL1/TOSC1)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT7/XTAL2/TOSC2)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT21/OC0B/T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT22/OC0A/AIN0)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(PCINT16/RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT23/AIN1)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(PCINT17/TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT0/CLKO/ICP1)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC7',do_erc=True),
            Pin(num='32',name='(PCINT18/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT1/OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT8/ADC0)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT2/OC1B/~SS~)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT9/ADC1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT3/OC2/MOSI)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT10/ADC2)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT4/MISO)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT11/ADC3)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT5/SCK)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT12/SDA/ADC4)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='(PCINT13/SCL/ADC5)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='ADC6',do_erc=True),
            Pin(num='29',name='(PCINT14/~RESET~)PC6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA168-20PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='PDIP28 Narrow, 8k Flash, 512B SRAM, 1k EEPROM',ref_prefix='U',num_units=1,fplist=['28DIP-ELL600', '28dip600'],do_erc=True,aliases=['ATMEGA48-20PU', 'ATMEGA88-20PU'],pins=[
            Pin(num='1',name='(PCINT14/~RESET~)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT16/RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT17/TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT18/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT19/OC2B/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT20/XCK/T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='(PCINT6/XTAL1/TOSC1)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT7/XTAL2/TOSC2)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='(PCINT21/OC0B/T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT22/OC0A/AIN0)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='(PCINT23/AIN1)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT8/ADC0)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT0/CLKO/ICP1)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT9/ADC1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT1/OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT10/ADC2)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT2/OC1B/~SS~)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT11/ADC3)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT3/OC2/MOSI)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT12/SDA/ADC4)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT4/MISO)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(PCINT13/SCL/ADC5)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT5/SCK)PB5',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA168A-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR PicoPower',description='TQFP32, 8k Flash, 1kB SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA48A-AU', 'ATMEGA48PA-AU', 'ATMEGA88A-AU', 'ATMEGA88PA-AU', 'ATMEGA168PA-AU', 'ATMEGA328-AU', 'ATMEGA328P-AU'],pins=[
            Pin(num='1',name='(PCINT19/OC2B/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT20/XCK/T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(PCINT6/XTAL1/TOSC1)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT7/XTAL2/TOSC2)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT21/OC0B/T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT22/OC0A/AIN0)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(PCINT16/RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT23/AIN1)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(PCINT17/TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT0/CLKO/ICP1)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC7',do_erc=True),
            Pin(num='32',name='(PCINT18/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT1/OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT8/ADC0)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT2/OC1B/~SS~)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT9/ADC1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT3/OC2A/MOSI)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT10/ADC2)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT4/MISO)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT11/ADC3)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT5/SCK)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT12/SDA/ADC4)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='(PCINT13/SCL/ADC5)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='ADC6',do_erc=True),
            Pin(num='29',name='(PCINT14/~RESET~)PC6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA168A-MMH',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR PicoPower',description='QFN/MLF28, 8k Flash, 1kB SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA48A-MMH', 'ATMEGA48PA-MMH', 'ATMEGA88A-MMH', 'ATMEGA88PA-MMH', 'ATMEGA168PA-MMH', 'ATMEGA328-MMH', 'ATMEGA328P-MMH'],pins=[
            Pin(num='1',name='(PCINT19/OC2B/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT20/XCK/T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='(PCINT6/XTAL1/TOSC1)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT7/XTAL2/TOSC2)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT21/OC0B/T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT22/OC0A/AIN0)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT23/AIN1)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT0/CLKO/ICP1)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT9/ADC1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT1/OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(PCINT10/ADC2)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT2/OC1B/~SS~)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT11/ADC3)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT3/OC2A/MOSI)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT12/SDA/ADC4)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT4/MISO)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT13/SCL/ADC5)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT5/SCK)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT14/~RESET~)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='(PCINT16/RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT17/TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='(PCINT18/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT8/ADC0)PC0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA168A-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR PicoPower',description='QFN/MLF32, 8k Flash, 1kB SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA48A-MU', 'ATMEGA48PA-MU', 'ATMEGA88A-MU', 'ATMEGA88PA-MU', 'ATMEGA168PA-MU', 'ATMEGA328-MU', 'ATMEGA328P-MU'],pins=[
            Pin(num='1',name='(PCINT19/OC2B/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT20/XCK/T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(PCINT6/XTAL1/TOSC1)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT7/XTAL2/TOSC2)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT21/OC0B/T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT22/OC0A/AIN0)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(PCINT16/RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT23/AIN1)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(PCINT17/TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT0/CLKO/ICP1)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC7',do_erc=True),
            Pin(num='32',name='(PCINT18/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT1/OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT8/ADC0)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT2/OC1B/~SS~)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT9/ADC1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT3/OC2A/MOSI)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT10/ADC2)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT4/MISO)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT11/ADC3)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT5/SCK)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT12/SDA/ADC4)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='(PCINT13/SCL/ADC5)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='ADC6',do_erc=True),
            Pin(num='29',name='(PCINT14/~RESET~)PC6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA168A-PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR PicoPower',description='PDIP28 Narrow, 8k Flash, 1kB SRAM, 512B EEPROM',ref_prefix='U',num_units=1,fplist=['28DIP-ELL600', '28dip600'],do_erc=True,aliases=['ATMEGA48A-PU', 'ATMEGA48PA-PU', 'ATMEGA88A-PU', 'ATMEGA88PA-PU', 'ATMEGA168PA-PU', 'ATMEGA328-PU', 'ATMEGA328P-PU'],pins=[
            Pin(num='1',name='(PCINT14/~RESET~)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT16/RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT17/TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT18/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT19/OC2B/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT20/XCK/T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='(PCINT6/XTAL1/TOSC1)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT7/XTAL2/TOSC2)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='(PCINT21/OC0B/T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT22/OC0A/AIN0)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='(PCINT23/AIN1)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT8/ADC0)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT0/CLKO/ICP1)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT9/ADC1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT1/OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT10/ADC2)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT2/OC1B/~SS~)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT11/ADC3)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT3/OC2A/MOSI)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT12/SDA/ADC4)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT4/MISO)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(PCINT13/SCL/ADC5)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT5/SCK)PB5',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA169-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR LCD',description='TQFP64, 16k Flash, 1k SRAM, 512k EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='LCDCAP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='PE0(RXD/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(AIN0/XCK/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(AIN1/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(USCK/SCL/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(DI/SDA/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(DO/PCINT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(CLKO/PCINT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT8/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RESET',do_erc=True),
            Pin(num='30',name='(SEG17)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(SEG7)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='(COM1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT9/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(SEG16)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(SEG6)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='(COM0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT10/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(SEG15)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(SEG5)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(SEG14)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(SEG4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(PCINT12/OC0A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(SEG13)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(SEG3)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(PCINT13/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ICP1/SEG22)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(SEG12)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='(SEG2)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT14/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(INT0/SEG21)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(SEG11)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='(SEG1)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT15/OC2A)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(SEG20)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(SEG10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='(SEG0)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG3(SEG24/T1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(SEG19)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(SEG9)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='(COM3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PG4(SEG23/T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(SEG18)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(SEG8)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='(COM2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA169-16MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR LCD',description='QFN/MLF64, 16k Flash, 1k SRAM, 512k EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='LCDCAP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='PE0(RXD/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(AIN0/XCK/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(AIN1/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(USCK/SCL/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(DI/SDA/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(DO/PCINT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(CLKO/PCINT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT8/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RESET',do_erc=True),
            Pin(num='30',name='(SEG17)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(SEG7)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='(COM1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT9/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(SEG16)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(SEG6)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='(COM0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT10/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(SEG15)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(SEG5)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(SEG14)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(SEG4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(PCINT12/OC0A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(SEG13)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(SEG3)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(PCINT13/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ICP1/SEG22)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(SEG12)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='(SEG2)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT14/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(INT0/SEG21)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(SEG11)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='(SEG1)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT15/OC2A)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(SEG20)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(SEG10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='(SEG0)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG3(SEG24/T1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(SEG19)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(SEG9)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='(COM3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PG4(SEG23/T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(SEG18)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(SEG8)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='(COM2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA169P-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR LCD PicoPower',description='TQFP64, 16k Flash, 1k SRAM, 512k EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='LCDCAP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='PE0(RXD/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(AIN0/XCK/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(AIN1/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(USCK/SCL/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(DI/SDA/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(DO/PCINT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(CLKO/PCINT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT8/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PG5(~RESET~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(SEG17)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(SEG7)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='(COM1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT9/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(SEG16)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(SEG6)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='(COM0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT10/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(SEG15)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(SEG5)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(SEG14)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(SEG4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(PCINT12/OC0A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(SEG13)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(SEG3)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(PCINT13/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ICP1/SEG22)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(SEG12)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='(SEG2)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT14/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(INT0/SEG21)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(SEG11)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='(SEG1)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT15/OC2A)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(SEG20)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(SEG10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='(SEG0)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG3(SEG24/T1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(SEG19)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(SEG9)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='(COM3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PG4(SEG23/T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(SEG18)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(SEG8)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='(COM2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA169P-16MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR LCD PicoPower',description='QFN/MLF64, 16k Flash, 1k SRAM, 512k EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='LCDCAP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='PE0(RXD/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(AIN0/XCK/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(AIN1/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(USCK/SCL/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(DI/SDA/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(DO/PCINT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(CLKO/PCINT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT8/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PG5(~RESET~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(SEG17)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(SEG7)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='(COM1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT9/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(SEG16)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(SEG6)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='(COM0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT10/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(SEG15)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(SEG5)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(SEG14)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(SEG4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(PCINT12/OC0A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(SEG13)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(SEG3)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(PCINT13/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ICP1/SEG22)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(SEG12)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='(SEG2)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT14/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(INT0/SEG21)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(SEG11)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='(SEG1)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT15/OC2A)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(SEG20)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(SEG10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='(SEG0)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG3(SEG24/T1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(SEG19)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(SEG9)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='(COM3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PG4(SEG23/T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(SEG18)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(SEG8)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='(COM2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA169PA-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR LCD PicoPower',description='TQFP64, 64k Flash, 4k SRAM, 2k EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA169A-AU', 'ATMEGA329A-AU', 'ATMEGA329PA-AU', 'ATMEGA649A-AU', 'ATMEGA649P-AU'],pins=[
            Pin(num='1',name='LCDCAP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='PE0(RXD/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(AIN0/XCK/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(AIN1/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(USCK/SCL/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(DI/SDA/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(DO/PCINT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(CLKO/PCINT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT8/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PG5(~RESET~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(SEG17)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(SEG7)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='(COM1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT9/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(SEG16)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(SEG6)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='(COM0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT10/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(SEG15)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(SEG5)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(SEG14)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(SEG4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(PCINT12/OC0A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(SEG13)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(SEG3)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(PCINT13/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ICP1/SEG22)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(SEG12)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='(SEG2)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT14/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(INT0/SEG21)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(SEG11)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='(SEG1)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT15/OC2A)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(SEG20)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(SEG10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='(SEG0)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG3(SEG24/T1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(SEG19)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(SEG9)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='(COM3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PG4(SEG23/T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(SEG18)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(SEG8)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='(COM2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA169PA-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR LCD PicoPower',description='QFN/MLF64, 64k Flash, 4k SRAM, 2k EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA169A-MU', 'ATMEGA329A-MU', 'ATMEGA329PA-MU', 'ATMEGA649A-MU', 'ATMEGA649P-MU'],pins=[
            Pin(num='1',name='LCDCAP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='PE0(RXD/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(AIN0/XCK/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(AIN1/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(USCK/SCL/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(DI/SDA/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(DO/PCINT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(CLKO/PCINT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT8/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PG5(~RESET~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(SEG17)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(SEG7)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='(COM1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT9/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(SEG16)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(SEG6)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='(COM0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT10/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(SEG15)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(SEG5)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(SEG14)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(SEG4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(PCINT12/OC0A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(SEG13)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(SEG3)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(PCINT13/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ICP1/SEG22)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(SEG12)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='(SEG2)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT14/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(INT0/SEG21)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(SEG11)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='(SEG1)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT15/OC2A)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(SEG20)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(SEG10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='(SEG0)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG3(SEG24/T1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(SEG19)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(SEG9)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='(COM3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PG4(SEG23/T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(SEG18)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(SEG8)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='(COM2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA16A-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP44, 16k Flash, 1k SRAM, 512B EEPROM, JTAG',ref_prefix='U',num_units=1,fplist=['TQFP44'],do_erc=True,pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(AIN1/OC0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA16A-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='QFN/MLF44, 16k Flash, 1k SRAM, 512B EEPROM, JTAG',ref_prefix='U',num_units=1,fplist=['MLF44'],do_erc=True,pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(AIN1/OC0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA16A-PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='PDIP40, 16k Flash, 1k SRAM, 512B EEPROM, JTAG',ref_prefix='U',num_units=1,fplist=['40DIP-ELL600', '40dip600'],do_erc=True,pins=[
            Pin(num='1',name='(T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(AIN1/OC0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA16M1-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP32, 64k Flash, 4k SRAM, 2kB EEPROM, CAN',ref_prefix='U',num_units=1,fplist=['TQFP32'],do_erc=True,aliases=['ATMEGA32M1-AU', 'ATMEGA64M1-AU'],pins=[
            Pin(num='1',name='(PCINT18/PSCIN2/OC1A/MISO_A)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT19/TXD/TXLIN/OC0A/~SS~/MOSI_A)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT9/PSCIN1/OC1B/~SS_A~)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='(PCINT10/T0/TXCAN)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT11/T1/ICP1B/RXCAN)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT0/MISO/PSCOUT2A)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT1/MOSI/PSCOUT2B)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT25/OC0B/XTAL1)PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='(PCINT8/INT3/PSCOUT1A)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT26/ADC0/XTAL2)PE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='AREF(ISRC)',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(PCINT24/OCD/~RESET~)PE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT20/ADC1/RXD/RXLIN/ICP1A/SCK_A)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT14/ADC10/ACMP1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(PCINT17/CLKO/PSCIN0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT21/ADC2/ACMP2)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT3/AMP0-)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT22/ADC3/INT0/ACMPN2)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT4/AMP0+)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT23/ACMP0)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT15/D2A/AMP2+)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT2/ADC5/INT1/ACMPN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT5/ADC6/INT2/ACMPN1/AMP2-)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT12/ADC8/ACMPN3/AMP1-)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT6/ADC7/PSCOUT1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT13/ADC9/ACMP3/AMP1+)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(PCINT7/ADC4/SCK/PSCOUT0B)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='(PCINT16/PSCOUT0A)PD0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA16M1-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='QFN32, 64k Flash, 4k SRAM, 2kB EEPROM, CAN',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA32M1-MU', 'ATMEGA64M1-MU'],pins=[
            Pin(num='1',name='(PCINT18/PSCIN2/OC1A/MISO_A)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT19/TXD/TXLIN/OC0A/~SS~/MOSI_A)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT9/PSCIN1/OC1B/~SS_A~)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='(PCINT10/T0/TXCAN)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT11/T1/ICP1B/RXCAN)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT0/MISO/PSCOUT2A)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT1/MOSI/PSCOUT2B)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT25/OC0B/XTAL1)PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='(PCINT8/INT3/PSCOUT1A)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT26/ADC0/XTAL2)PE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='AREF(ISRC)',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(PCINT24/OCD/~RESET~)PE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT20/ADC1/RXD/RXLIN/ICP1A/SCK_A)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT14/ADC10/ACMP1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(PCINT17/CLKO/PSCIN0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT21/ADC2/ACMP2)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT3/AMP0-)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT22/ADC3/INT0/ACMPN2)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT4/AMP0+)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT23/ACMP0)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT15/D2A/AMP2+)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT2/ADC5/INT1/ACMPN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT5/ADC6/INT2/ACMPN1/AMP2-)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT12/ADC8/ACMPN3/AMP1-)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT6/ADC7/PSCOUT1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT13/ADC9/ACMP3/AMP1+)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(PCINT7/ADC4/SCK/PSCOUT0B)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='(PCINT16/PSCOUT0A)PD0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA16U4-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR USB',description='TQFP44, 32K Flash, 2.5K SRAM, 1K EEPROM, USB2.0',ref_prefix='U',num_units=1,fplist=['TQFP44'],do_erc=True,aliases=['ATMEGA16U4RC-AU', 'ATMEGA32U4-AU', 'ATMEGA32U4RC-AU'],pins=[
            Pin(num='1',name='(INT6/AIN0)PE6',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='UVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='D+',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='UGND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='UCAP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='VBUS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='(SS/PCINT0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(SCLK/PCINT1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PDI/MOSI/PCINT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(RXD/INT2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(ADC13/OC1B/OC4B/PCINT13)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(ADC1)PF1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PDO/MISO/PCINT3)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(TXD/INT3)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(OC3A/~OC4A~)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(ADC0)PF0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(OC0A/OC1C/~RTS~/PCINT7)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(XCK1/~CTS~)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(ICP3/CLK0/OC4A)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='AREF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='~RESET~',do_erc=True),
            Pin(num='23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='(~HWB~)PE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='(ICP2/ADC8)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='XTAL2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='26',name='(T1/~OC4D~/ADC9)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC7/TDI)PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='XTAL1',do_erc=True),
            Pin(num='27',name='(T0/OC4D/ADC10)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(ADC6/TDO)PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(OC0B/SCL/INT0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(ADC11/PCINT4)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(ADC5/TMS)PF5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(SDA/INT1)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(ADC12/OC1A/~OC4B~/PCINT12)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(ADC4/TCK)PF4',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA16U4-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR USB',description='QFN44, 32K Flash, 2.5K SRAM, 1K EEPROM, USB2.0',ref_prefix='U',num_units=1,fplist=['QFN44'],do_erc=True,aliases=['ATMEGA16U4RC-MU', 'ATMEGA32U4-MU', 'ATMEGA32U4RC-MU'],pins=[
            Pin(num='1',name='(INT6/AIN0)PE6',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='UVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='D+',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='UGND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='UCAP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='VBUS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='(SS/PCINT0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(SCLK/PCINT1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PDI/MOSI/PCINT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(RXD/INT2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(ADC13/OC1B/OC4B/PCINT13)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(ADC1)PF1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PDO/MISO/PCINT3)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(TXD/INT3)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(OC3A/~OC4A~)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(ADC0)PF0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(OC0A/OC1C/~RTS~/PCINT7)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(XCK1/~CTS~)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(ICP3/CLK0/OC4A)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='AREF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='~RESET~',do_erc=True),
            Pin(num='23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='(~HWB~)PE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='(ICP2/ADC8)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='XTAL2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='26',name='(T1/~OC4D~/ADC9)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC7/TDI)PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='XTAL1',do_erc=True),
            Pin(num='27',name='(T0/OC4D/ADC10)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(ADC6/TDO)PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(OC0B/SCL/INT0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(ADC11/PCINT4)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(ADC5/TMS)PF5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(SDA/INT1)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(ADC12/OC1A/~OC4B~/PCINT12)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(ADC4/TCK)PF4',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA32-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP44, 32k Flash, 2k SRAM, 1k EEPROM, JTAG',ref_prefix='U',num_units=1,fplist=['TQFP44'],do_erc=True,pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(AIN1/OC0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA32-16MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='QFN/MLF44, 32k Flash, 2k SRAM, 1k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(AIN1/OC0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA32-16PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='PDIP40, 32k Flash, 2k SRAM, 1k EEPROM, JTAG',ref_prefix='U',num_units=1,fplist=['40DIP-ELL600', '40dip600'],do_erc=True,pins=[
            Pin(num='1',name='(T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(AIN1/OC0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA323-4AC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP44, 32k Flash, 2k SRAM, 1k EEPROM, JTAG',ref_prefix='U',num_units=1,fplist=['TQFP44'],do_erc=True,pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(AIN1/OC0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA323-4PC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='PDIP40, 32k Flash, 2k SRAM, 1k EEPROM, JTAG',ref_prefix='U',num_units=1,fplist=['40DIP-ELL600', '40dip600'],do_erc=True,pins=[
            Pin(num='1',name='(T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(AIN1/OC0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA325-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP64, 64k Flash, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA645-16AU'],pins=[
            Pin(num='2',name='PE0(RXD/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(AIN0/XCK/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(AIN1/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(USCK/SCL/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(DI/SDA/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(DO/PCINT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(CLKO/PCINT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT8/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PG5(~RESET~)',do_erc=True),
            Pin(num='30',name='PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT9/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT10/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(PCINT12/OC0A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(PCINT13/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ICP1)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT14/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(INT0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT15/OC2A)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG3(T1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PG4(T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA325-16MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='MLF/QFN64, 64k Flash, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA645-16MU'],pins=[
            Pin(num='2',name='PE0(RXD/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(AIN0/XCK/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(AIN1/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(USCK/SCL/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(DI/SDA/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(DO/PCINT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(CLKO/PCINT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT8/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PG5(~RESET~)',do_erc=True),
            Pin(num='30',name='PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT9/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT10/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(PCINT12/OC0A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(PCINT13/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ICP1)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT14/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(INT0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT15/OC2A)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG3(T1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PG4(T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA3250-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP100, 64k Flash, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA6450-16AU'],pins=[
            Pin(num='2',name='(PCINT0/RXD)PE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT1/TXD)PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT2/AIN0/XCK)PE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT3/AIN1)PE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT4/USCK/SCL)PE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT5/DI/SDA)PE5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT6/DO)PE6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT7/CLKO)PE7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(PCINT9/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PG5(~RESET~)',do_erc=True),
            Pin(num='40',name='PJ5(PCINT29)',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='PG2',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='90',name='PF7(ADC7/TDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='(PCINT10/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='PJ6(PCINT30)',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PG0',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='91',name='PF6(ADC6/TDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT11/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='PG1',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='PF5(ADC5/TMS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PJ0(PCINT24)',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT12/OC0A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='XTAL2(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(ICP1)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PH0(PCINT16)',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='PF4(ADC4/TCK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PJ1(PCINT25)',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT13/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='XTAL1(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(INT0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='PH1(PCINT17)',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PH4(PCINT20)',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='PF3(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT14/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='PH2(PCINT18)',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PH5(PCINT21)',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='PF2(ADC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT15/OC2A)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='PH3(PCINT19)',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PH6(PCINT22)',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='PF1(ADC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PJ2(PCINT26)',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PH7(PCINT23)',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='PF0(ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PG3(T1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PJ3(PCINT27)',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT8/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PG4(T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PJ4(PCINT28)',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='AVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA328PB-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP32, 32k Flash, 2kB SRAM, 1K EEPROM',ref_prefix='U',num_units=1,fplist=['TQFP-32*7x7mm*Pitch0.8mm*'],do_erc=True,pins=[
            Pin(num='1',name='(OC2B/INT1/PTCXY)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(XCK0/T0/PTCXY)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE0(PTCXY/SDA1/ICP4/ACO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='PE1(PTCXY/SCL1/T4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(XTAL1/TOSC1)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(XTAL2/TOSC2)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(OC0B/T1/PTCXY)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(OC0A/AIN0/PTCXY)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(RXD0/OC3A/PTCXY)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(AIN1/PTCXY)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(TXD0/OC4A/PTCXY)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(CLKO/ICP1/PTCXY)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PE3(PTCY/ADC7/T3/MOSI1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(OC3B/OC4B/INT0/PTCXY)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(OC1A/PTCXY)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(MISO1/ADC0/PTCY)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(OC1B/~SS0~/PTCXY)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(SCK1/ADC1/PTCY)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(MOSI0/TXD1/OC2A/PTCXY)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ADC2/PTCY)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(MISO0/RXD1/PTCXY)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(ADC3/PTCY)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(XCK0/SCK0/PTCXY)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(SDA0/ADC4/PTCY)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='(SCL0/ADC5/PTCY)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PE2(PTCY/ADC6/ICP3/~SS1~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(~RESET~)PC6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA328PB-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='VQFN32, Exposed Pad, 32k Flash, 2kB SRAM, 1K EEPROM',ref_prefix='U',num_units=1,fplist=['QFN-32*1EP*5x5mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='(OC2B/INT1/PTCXY)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(XCK0/T0/PTCXY)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE0(PTCXY/SDA1/ICP4/ACO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='PE1(PTCXY/SCL1/T4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(XTAL1/TOSC1)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(XTAL2/TOSC2)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(OC0B/T1/PTCXY)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(OC0A/AIN0/PTCXY)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(RXD0/OC3A/PTCXY)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(AIN1/PTCXY)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(TXD0/OC4A/PTCXY)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(CLKO/ICP1/PTCXY)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PE3(PTCY/ADC7/T3/MOSI1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(OC3B/OC4B/INT0/PTCXY)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(OC1A/PTCXY)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(MISO1/ADC0/PTCY)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PAD',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(OC1B/~SS0~/PTCXY)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(SCK1/ADC1/PTCY)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(MOSI0/TXD1/OC2A/PTCXY)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ADC2/PTCY)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(MISO0/RXD1/PTCXY)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(ADC3/PTCY)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(XCK0/SCK0/PTCXY)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(SDA0/ADC4/PTCY)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='(SCL0/ADC5/PTCY)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PE2(PTCY/ADC6/ICP3/~SS1~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(~RESET~)PC6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA329-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP64, 64k Flash, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA649-16AU'],pins=[
            Pin(num='1',name='LCDCAP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='PE0(RXD/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(AIN0/XCK/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(AIN1/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(USCK/SCL/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(DI/SDA/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(DO/PCINT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(CLKO/PCINT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT8/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PG5(~RESET~)',do_erc=True),
            Pin(num='30',name='(SEG17)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(SEG7)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='(COM1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT9/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(SEG16)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(SEG6)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='(COM0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT10/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(SEG15)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(SEG5)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(SEG14)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(SEG4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(PCINT12/OC0A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(SEG13)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(SEG3)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(PCINT13/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(SEG22/ICP1)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(SEG12)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='(SEG2)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT14/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(SEG21/INT0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(SEG11)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='(SEG1)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT15/OC2A)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(SEG20)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(SEG10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='(SEG0)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG3(T1/SEG24)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(SEG19)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(SEG9)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='(COM3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PG4(T0/SEG23)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(SEG18)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(SEG8)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='(COM2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA329-16MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='QFN/MLF64, 64k Flash, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA649-16MU'],pins=[
            Pin(num='1',name='LCDCAP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='PE0(RXD/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(AIN0/XCK/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(AIN1/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(USCK/SCL/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(DI/SDA/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(DO/PCINT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(CLKO/PCINT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT8/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PG5(~RESET~)',do_erc=True),
            Pin(num='30',name='(SEG17)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(SEG7)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='(COM1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT9/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(SEG16)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(SEG6)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='(COM0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT10/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(SEG15)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(SEG5)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(SEG14)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(SEG4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(PCINT12/OC0A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(SEG13)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(SEG3)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(PCINT13/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(SEG22/ICP1)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(SEG12)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='(SEG2)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT14/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(SEG21/INT0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(SEG11)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='(SEG1)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT15/OC2A)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(SEG20)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(SEG10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='(SEG0)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG3(T1/SEG24)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(SEG19)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(SEG9)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='(COM3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PG4(T0/SEG23)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(SEG18)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(SEG8)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='(COM2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA3290-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP100, 64k Flash, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA6490-16AU'],pins=[
            Pin(num='1',name='LCDCAP',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT0/RXD)PE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT1/TXD)PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT2/AIN0/XCK)PE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT3/AIN1)PE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT4/USCK/SCL)PE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT5/DI/SDA)PE5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT6/DO)PE6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT7/CLKO)PE7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(PCINT9/SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PG5(~RESET~)',do_erc=True),
            Pin(num='40',name='PJ5(PCINT29/SEG28)',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='(SEG19)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='PG2(SEG4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='90',name='PF7(ADC7/TDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='(PCINT10/MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='PJ6(PCINT30/SEG27)',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PG0(SEG18)',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='(SEG3)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='91',name='PF6(ADC6/TDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT11/MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='PG1(SEG17)',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='(SEG2)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='PF5(ADC5/TMS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PJ0(PCINT24/SEG35)',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT12/OC0A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='XTAL2(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(SEG26/ICP1)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='(SEG16)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PH0(PCINT16/SEG10)',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='(SEG1)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='PF4(ADC4/TCK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PJ1(PCINT25/SEG34)',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT13/OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='XTAL1(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(SEG25/INT0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='(SEG15)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='PH1(PCINT17/SEG9)',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='(SEG0)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PH4(PCINT20/SEG39)',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='PF3(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT14/OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='(SEG24)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='(SEG14)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='PH2(PCINT18/SEG8)',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='(COM3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PH5(PCINT21/SEG38)',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='PF2(ADC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT15/OC2A)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='(SEG23)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='(SEG13)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='PH3(PCINT19/SEG7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='(COM2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PH6(PCINT22/SEG37)',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='PF1(ADC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PJ2(PCINT26/SEG31)',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='(SEG22)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='(SEG12)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='(COM1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PH7(PCINT23/SEG36)',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='PF0(ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PG3(T1/SEG33)',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PJ3(PCINT27/SEG30)',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='(SEG21)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='(SEG11)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='(SEG6)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='(COM0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT8/~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PG4(T0/SEG32)',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PJ4(PCINT28/SEG29)',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='(SEG20)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='(SEG5)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='AVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA32A-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP44, 32k Flash, 2k SRAM, 1k EEPROM, JTAG',ref_prefix='U',num_units=1,fplist=['TQFP44'],do_erc=True,pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(AIN1/OC0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA32A-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='QFN/MLF44, 32k Flash, 2k SRAM, 1k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(AIN1/OC0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA32A-PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='PDIP40, 32k Flash, 2k SRAM, 1k EEPROM, JTAG',ref_prefix='U',num_units=1,fplist=['40DIP-ELL600', '40dip600'],do_erc=True,pins=[
            Pin(num='1',name='(T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(AIN1/OC0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA64-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP64, 64k Flash, 4k SRAM, 2k EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~PEN',do_erc=True),
            Pin(num='2',name='PE0(RXD/PDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(XCK0/AIN0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(OC3A/AIN1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(OC3B/INT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(OC3C/INT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(T3/INT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(IC3/INT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RESET',do_erc=True),
            Pin(num='30',name='(XCK1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(A13)PC5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',do_erc=True),
            Pin(num='11',name='(SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(T1)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(A14)PC6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='51',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',do_erc=True),
            Pin(num='12',name='(MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(T2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(A15)PC7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(~WR~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(ALE)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(OC0)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(~RD~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(SCL/INT0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(A8)PC0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',do_erc=True),
            Pin(num='16',name='(OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(SDA/INT1)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(A9)PC1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',do_erc=True),
            Pin(num='17',name='(OC2/OC1C)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(RXD1/INT2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(A10)PC2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',do_erc=True),
            Pin(num='18',name='PG3(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TXD1/INT3)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(A11)PC3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',do_erc=True),
            Pin(num='19',name='PG4(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(IC1)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(A12)PC4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='49',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',do_erc=True)]),
        Part(name='ATMEGA64-16MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='QFN/MLF64, 64k Flash, 4k SRAM, 2k EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~PEN',do_erc=True),
            Pin(num='2',name='PE0(RXD/PDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(XCK0/AIN0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(OC3A/AIN1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(OC3B/INT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(OC3C/INT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(T3/INT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(IC3/INT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RESET',do_erc=True),
            Pin(num='30',name='(XCK1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(A13)PC5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',do_erc=True),
            Pin(num='11',name='(SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(T1)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(A14)PC6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='51',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',do_erc=True),
            Pin(num='12',name='(MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(T2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(A15)PC7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(~WR~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(ALE)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(OC0)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(~RD~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(SCL/INT0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(A8)PC0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',do_erc=True),
            Pin(num='16',name='(OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(SDA/INT1)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(A9)PC1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',do_erc=True),
            Pin(num='17',name='(OC2/OC1C)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(RXD1/INT2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(A10)PC2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',do_erc=True),
            Pin(num='18',name='PG3(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TXD1/INT3)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(A11)PC3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',do_erc=True),
            Pin(num='19',name='PG4(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(IC1)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(A12)PC4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='49',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',do_erc=True)]),
        Part(name='ATMEGA644-20AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP44, 64k Flash, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(PCINT13/MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT14/MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT15/SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT24/RXD0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT25/TXD0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT17/SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(PCINT7/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(PCINT8/T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT26/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(PCINT18/TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(PCINT6/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(PCINT9/CLKO/T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT27/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT19/TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(PCINT5/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(PCINT10/AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT28/OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT20/TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(PCINT4/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(PCINT11/AIN1/OC0A)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT294/OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT21/TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(PCINT3/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(PCINT12/OC0B/~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT30/OC2B/ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT22/TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(PCINT2/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT31/OC2A)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT23/TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(PCINT1/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(PCINT0/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(PCINT16/SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA644-20MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='ATMEGA644A, QFN/MLF44, 64k Flash, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(PCINT13/MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT14/MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT15/SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT24/RXD0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT25/TXD0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT17/SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(PCINT7/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(PCINT8/T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT26/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(PCINT18/TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(PCINT6/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(PCINT9/CLKO/T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT27/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT19/TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(PCINT5/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(PCINT10/AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT28/OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT20/TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(PCINT4/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(PCINT11/AIN1/OC0A)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT294/OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT21/TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(PCINT3/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(PCINT12/OC0B/~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT30/OC2B/ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT22/TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(PCINT2/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT31/OC2A)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT23/TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(PCINT1/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(PCINT0/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(PCINT16/SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA644-20PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='PDIP40, 64k Flash, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,fplist=['40DIP-ELL600', '40dip600'],do_erc=True,pins=[
            Pin(num='1',name='(PCINT8/T0/XCK)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT9/CLKO/T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT10/AIN0/INT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT11/AIN1/OC0A)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT12/OC0B/~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT13/MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT14/MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT15/SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(PCINT30/OC2B/ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='(PCINT0/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='(PCINT31/OC2A)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT16/SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT17/SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(PCINT7/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT24/RXD0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT18/TCK)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(PCINT6/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT25/TXD0)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT19/TMS)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(PCINT5/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT26/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT20/TDO)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(PCINT4/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT27/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT21/TDI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(PCINT3/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT28/OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(PCINT22/TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(PCINT2/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT294/OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(PCINT23/TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(PCINT1/ADC1)PA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA64A-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP64, 64k Flash, 4k SRAM, 2k EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~PEN',do_erc=True),
            Pin(num='2',name='PE0(RXD/PDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(XCK0/AIN0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(OC3A/AIN1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(OC3B/INT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(OC3C/INT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(T3/INT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(IC3/INT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RESET',do_erc=True),
            Pin(num='30',name='(XCK1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(A13)PC5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',do_erc=True),
            Pin(num='11',name='(SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(T1)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(A14)PC6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='51',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',do_erc=True),
            Pin(num='12',name='(MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(T2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(A15)PC7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(~WR~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(ALE)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(OC0)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(~RD~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(SCL/INT0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(A8)PC0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',do_erc=True),
            Pin(num='16',name='(OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(SDA/INT1)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(A9)PC1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',do_erc=True),
            Pin(num='17',name='(OC2/OC1C)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(RXD1/INT2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(A10)PC2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',do_erc=True),
            Pin(num='18',name='PG3(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TXD1/INT3)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(A11)PC3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',do_erc=True),
            Pin(num='19',name='PG4(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(IC1)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(A12)PC4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='49',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',do_erc=True)]),
        Part(name='ATMEGA64A-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='QFN/MLF64, 64k Flash, 4k SRAM, 2k EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~PEN',do_erc=True),
            Pin(num='2',name='PE0(RXD/PDI)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE1(TXD/PDO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE2(XCK0/AIN0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE3(OC3A/AIN1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4(OC3B/INT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE5(OC3C/INT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE6(T3/INT6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE7(IC3/INT7)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(~SS~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RESET',do_erc=True),
            Pin(num='30',name='(XCK1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(A13)PC5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF1(ADC1)',do_erc=True),
            Pin(num='11',name='(SCK)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(T1)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(A14)PC6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='51',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PF0(ADC0)',do_erc=True),
            Pin(num='12',name='(MOSI)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='(T2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(A15)PC7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(MISO)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG0(~WR~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PG2(ALE)',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='(OC0)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG1(~RD~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF7(ADC7/TDI)',do_erc=True),
            Pin(num='64',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(OC1A)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(SCL/INT0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(A8)PC0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF6(ADC6/TDO)',do_erc=True),
            Pin(num='16',name='(OC1B)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(SDA/INT1)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(A9)PC1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PF5(ADC5/TMS)',do_erc=True),
            Pin(num='17',name='(OC2/OC1C)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(RXD1/INT2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(A10)PC2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PF4(ADC4/TCK)',do_erc=True),
            Pin(num='18',name='PG3(TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TXD1/INT3)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(A11)PC3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PF3(ADC3)',do_erc=True),
            Pin(num='19',name='PG4(TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(IC1)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(A12)PC4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='49',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF2(ADC2)',do_erc=True)]),
        Part(name='ATMEGA8-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP32, 8k Flash, 1k SRAM, 512B EEPROM',ref_prefix='U',num_units=1,fplist=['TQFP32'],do_erc=True,aliases=['ATMEGA8A-AU'],pins=[
            Pin(num='1',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(XCK/T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PB6(XTAL1/TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PB7(XTAL2/TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(AIN0)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(AIN1)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(ICP)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(ADC0)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(~SS~/OC1B)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(ADC1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(MOSI/OC2)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ADC2)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(MISO)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(ADC3)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(SCK)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(ADC4/SDA)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='(ADC5/SCL)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='ADC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PC6(~RESET~)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA8-16MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='QFN/MLF32, 8k Flash, 1k SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATMEGA8A-MU'],pins=[
            Pin(num='1',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(XCK/T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PB6(XTAL1/TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PB7(XTAL2/TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(AIN0)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(AIN1)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(ICP)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(ADC0)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(~SS~/OC1B)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(ADC1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(MOSI/OC2)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ADC2)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(MISO)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(ADC3)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(SCK)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(ADC4/SDA)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='(ADC5/SCL)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='ADC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PC6(~RESET~)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA8-16PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='PDIP28 Narrow, 8k Flash, 1k SRAM, 512B EEPROM',ref_prefix='U',num_units=1,fplist=['28DIP-ELL600', '28dip600'],do_erc=True,aliases=['ATMEGA8A-PU'],pins=[
            Pin(num='1',name='PC6(~RESET~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(XCK/T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='PB6(XTAL1/TOSC1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PB7(XTAL2/TOSC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='(T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(AIN0)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='(AIN1)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(ADC0)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(ICP)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(ADC1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ADC2)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(~SS~/OC1B)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(ADC3)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(MOSI/OC2)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(ADC4/SDA)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(MISO)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(ADC5/SCL)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(SCK)PB5',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA8515-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP44, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(XCK)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(A10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(OC0/T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(A11)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(~WR~)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(A12)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(~RD~)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(A13)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(A14)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(A15)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='PE2(OC1B)',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PE1(ALE)',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(A8)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(A9)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PE0(ICP/INT2)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA8515-16JU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='PLCC44, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='2',name='(OC0/T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RESET',do_erc=True),
            Pin(num='20',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(A14)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(A15)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='PE2(OC1B)',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PE1(ALE)',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(A8)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(A9)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PE0(ICP/INT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(XCK)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(A10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(A11)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(~WR~)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(A12)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(~RD~)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(A13)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA8515-16MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='QFN/MLF44, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(XCK)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(A10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(OC0/T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(A11)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(~WR~)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(A12)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(~RD~)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(A13)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(A14)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(A15)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='PE2(OC1B)',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PE1(ALE)',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(A8)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(A9)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PE0(ICP/INT2)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA8515-16PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='PDIP40, 8K Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,fplist=['40DIP-ELL600', '40dip600'],do_erc=True,pins=[
            Pin(num='1',name='(OC0/T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='PE1(ALE)',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(A8)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PE0(ICP/INT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(A9)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(AD7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(A10)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(AD6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(XCK)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(A11)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(AD5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(A12)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(AD4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(~WR~)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(A13)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(AD3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(~RD~)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(A14)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(AD2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(A15)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(AD1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PE2(OC1B)',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(AD0)PA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA8535-16AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP44, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(XCK/T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(INT2/AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(OC0/AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA8535-16JU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='PLCC44, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='(XCK/T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(INT2/AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(OC0/AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RESET',do_erc=True),
            Pin(num='20',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='43',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA8535-16MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='QFN/MLF44, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='(XCK/T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='(INT2/AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='(OC0/AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATMEGA8535-16PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='PDIP40, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,fplist=['40DIP-ELL600', '40dip600'],do_erc=True,pins=[
            Pin(num='1',name='(XCK/T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(T1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(INT2/AIN0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(OC0/AIN1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(~SS~)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(MOSI)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(MISO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(SCK)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='(OC2)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(SCL)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(SDA)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='(ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='(ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='(ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(OC1B)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(TOSC1)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(OC1A)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(TOSC2)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATMEGA8U2-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR',description='TQFP-32, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,fplist=['TQFP-32', 'QFN-32-1EP'],do_erc=True,aliases=['ATMEGA16U2-AU', 'ATMEGA32U2-AU'],pins=[
            Pin(num='1',name='XTAL1',do_erc=True),
            Pin(num='2',name='PC0(XTAL2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='(PCINT11/AIN2)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(OC.0B/INT0)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(AIN0/INT1)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(RXD1/AIN1/INT2)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(TXD1/INT3)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(INT5/AIN3)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT6)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(XCK/AIN4/PCINT12)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(PCINT7/OC.0A/OC.1C)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='UVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='(~RTS~/AIN5/INT6)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(INT4/ICP1/CLK0)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='(~CTS~/~HWB~/AIN6/T0/INT7)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(OC.1A/PCINT8)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(~SS~/PCINT0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC1(~RESET~/dW)',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(SCLK/PCINT1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT9/OC.1B)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PDI/MOSI/PCINT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT10)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PD0/MISO/PCINT3)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='UCAP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='(T1/PCINT4)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='UGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='(PCINT5)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='D+',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY10-P',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8-bit Microcontroller tinyAVR Discontinued',description='DIP8, 1k OTP Flash, No SRAM, 64B EEPROM (For reference only)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(~RESET~)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(XTAL1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(XTAL2)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='(AIN0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(AIN1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(T0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY10-S',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8-bit Microcontroller tinyAVR Discontinued',description='SO8, 1k OTP FLash, No SRAM, 64B EEPROM (For reference only)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(~RESET~)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(XTAL1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(XTAL2)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='(AIN0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(AIN1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(T0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY10-TS',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SOT-23-6, 1k Flash, 32B SRAM, No EEPROM, ADC',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PB0(AIN0/ADC0/OC0A/PCINT0/TPIDATA)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='PB1(AIN1/ADC1/OC0B/ICP0/PCINT1/CLKI/TPICLK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PB2(INT0/ADC2/T0/PCINT2/CLKO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='PB3(~RESET~/ADC3/PCINT3)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY11-6PC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='PDIP8, 1k Flash, No SRAM, No EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PB5(~RESET~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PB3(XTAL1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PB4(XTAL2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PB0(AIN0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PB1(AIN1/INT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PB2(T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY11-6SC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SO8 Wide, 1k Flash, No SRAM, No EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PB5(~RESET~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PB3(XTAL1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PB4(XTAL2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PB0(AIN0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PB1(AIN1/INT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PB2(T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY12-4PC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='PDIP8, 1k Flash, No SRAM, 64B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PB5(~RESET~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PB3(XTAL1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PB4(XTAL2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PB0(MOSI/AIN0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PB1(MISO/AIN1/INT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PB2(SCK/T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY12-4SC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SO8 Wide, 1k Flash, No SRAM, 64B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PB5(~RESET~)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PB3(XTAL1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PB4(XTAL2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PB0(MOSI/AIN0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PB1(MISO/AIN1/INT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PB2(SCK/T0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY13-20MMU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='QFN/MLF10, 1k Flash, 64B SRAM, 64B EEPROM, Debug Wire',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY13A-MMF'],pins=[
            Pin(num='1',name='PB5(~RESET~/ADC0/PCINT5/dW)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PB3(CLKI/ADC3/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PB4(ADC2/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='PB0(MOSI/AIN0/OC0A/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PB1(MISO/AIN1/OC0B/INT0/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PB2(SCK/ADC1/T0/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY13-20MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='QFN/MLF20, 1k Flash, 64B SRAM, 64B EEPROM, Debug Wire',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY13A-MU'],pins=[
            Pin(num='1',name='PB5(~RESET~/ADC0/PCINT5/dW)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PB3(CLKI/ADC3/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PB4(ADC2/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='PB0(MOSI/AIN0/OC0A/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PB1(MISO/AIN1/OC0B/INT0/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PB2(SCK/ADC1/T0/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY13-20PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='PDIP8, 1k Flash, 64B SRAM, 64B EEPROM, Debug Wire',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY13A-PU'],pins=[
            Pin(num='1',name='PB5(~RESET~/ADC0/PCINT5/dW)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PB3(CLKI/ADC3/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PB4(ADC2/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PB0(MOSI/AIN0/OC0A/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PB1(MISO/AIN1/OC0B/INT0/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PB2(SCK/ADC1/T0/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY13-20SSU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SO8, 1k Flash, 64B SRAM, 64B EEPROM, Debug Wire',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY13A-SSU'],pins=[
            Pin(num='1',name='PB5(~RESET~/ADC0/PCINT5/dW)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PB3(CLKI/ADC3/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PB4(ADC2/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PB0(MOSI/AIN0/OC0A/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PB1(MISO/AIN1/OC0B/INT0/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PB2(SCK/ADC1/T0/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY13-20SU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SO8 Wide, 1k Flash, 64B SRAM, 64B EEPROM, Debug Wire',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY13A-SU'],pins=[
            Pin(num='1',name='PB5(~RESET~/ADC0/PCINT5/dW)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PB3(CLKI/ADC3/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PB4(ADC2/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PB0(MOSI/AIN0/OC0A/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PB1(MISO/AIN1/OC0B/INT0/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PB2(SCK/ADC1/T0/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY15-1PC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='PDIP8, 1k Flash, No SRAM, 64B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PB5(~RESET~/ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PB3(ADC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PB4(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PB0(MOSI/AIN0/AREF)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PB1(MISO/AIN1/OC1A)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PB2(SCK/ADC1/T0/INT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY15-1SC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SO8 Wide, 1k Flash, No SRAM, 64B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PB5(~RESET~/ADC0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PB3(ADC2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PB4(ADC3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PB0(MOSI/AIN0/AREF)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PB1(MISO/AIN1/OC1A)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PB2(SCK/ADC1/T0/INT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY1634-MN',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='QFN/MLF20, 16k Flash, 1k SRAM, 256B EEPROM, ADC, ACI, dW',ref_prefix='U',num_units=1,fplist=['QFN*', 'MLF*'],do_erc=True,pins=[
            Pin(num='1',name='(PCINT6/OC1B/ADC3)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT5/OC0B/ADC2)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT4/T0/ADC1)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT3/T1/SNS/ADC0)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT2/AIN1)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT1/AIN0)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT0/AREF)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='(PCINT17/CLKI/XTAL1)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT7/RXD0/ADC4)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT16/XTAL2)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT15/dW/~RESET~)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT14/INT0/CLKO/ADC11)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT13/XCK1/USCK/SCL/ICP1/ADC10)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT12/XCK0/OC0A/ADC9)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT11/OC1A/ADC8)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT10/TXD1/DO/ADC7)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT9/RXD1/SDA/DI/ADC6)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT8/TXD0/ADC5)PB0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY1634-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='QFN/MLF20, 16k Flash, 1k SRAM, 256B EEPROM, ADC, ACI, dW',ref_prefix='U',num_units=1,fplist=['QFN*', 'MLF*'],do_erc=True,pins=[
            Pin(num='1',name='(PCINT6/OC1B/ADC3)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT5/OC0B/ADC2)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT4/T0/ADC1)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT3/T1/SNS/ADC0)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT2/AIN1)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT1/AIN0)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT0/AREF)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='(PCINT17/CLKI/XTAL1)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT7/RXD0/ADC4)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT16/XTAL2)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT15/dW/~RESET~)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT14/INT0/CLKO/ADC11)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT13/XCK1/USCK/SCL/ICP1/ADC10)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT12/XCK0/OC0A/ADC9)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT11/OC1A/ADC8)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT10/TXD1/DO/ADC7)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT9/RXD1/SDA/DI/ADC6)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT8/TXD0/ADC5)PB0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY1634-SU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SOIC20, 16k Flash, 1k SRAM, 256B EEPROM, ADC, ACI, dW',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,pins=[
            Pin(num='1',name='(PCINT8/TXD0/ADC5)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT7/RXD0/ADC4)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT6/OC1B/ADC3)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT5/OC0B/ADC2)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT4/T0/ADC1)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT3/T1/SNS/ADC0)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT2/AIN1)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT1/AIN0)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT0/AREF)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(PCINT9/RXD1/SDA/DI/ADC6)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='(PCINT17/CLKI/XTAL1)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT16/XTAL2)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT15/dW/~RESET~)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT14/INT0/CLKO/ADC11)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT13/XCK1/USCK/SCL/ICP1/ADC10)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT12/XCK0/OC0A/ADC9)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT11/OC1A/ADC8)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT10/TXD1/DO/ADC7)PB2',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY167-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR Automotive',description='MLF32, 16k Flash, 512B SRAM, 512B EEPROM, Debug Wire',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='3',name='(PCINT3/INT1/ISRC/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='(PCINT4/MOSI/SDA/DI/ICP1/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT5/SCK/SCL/USCK/T1/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='(PCINT1/TXLIN/TXD/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT6/~SS~/AIN0/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(PCINT2/MISO/DO/OC0A/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT7/AREF/XREF/AIN1/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT15/OC1BX/dW/~RESET~/ADC10)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT14/OC1AX/INT0/ADC9)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT11/OC1BV)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT10/OC1AV/USCK/SCL)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT9/OC1BU/DO)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT13/OC1BW/XTAL2/CLKO/ADC8)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(PCINT8/OC1AU/DI/SDA)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT12/OC1AW/XTAL1/CLKI)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(PCINT0/RXLIN/RXD/ADC0)PA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY167-SU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR Automotive',description='SO20, 16k Flash, 512B SRAM, 512B EEPROM, Debug Wire',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(PCINT0/RXLIN/RXD/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT1/TXLIN/TXD/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT2/MISO/DO/OC0A/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT3/INT1/ISRC/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(PCINT4/MOSI/SDA/DI/ICP1/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT5/SCK/SCL/USCK/T1/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT6/~SS~/AIN0/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT7/AREF/XREF/AIN1/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT8/OC1AU/DI/SDA)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT15/OC1BX/dW/~RESET~/ADC10)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT14/OC1AX/INT0/ADC9)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT13/OC1BW/XTAL2/CLKO/ADC8)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT12/OC1AW/XTAL1/CLKI)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='(PCINT11/OC1BV)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT10/OC1AV/USCK/SCL)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT9/OC1BU/DO)PB1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY167-XU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR Automotive',description='TSSOP20, 16k Flash, 512B SRAM, 512B EEPROM, Debug Wire',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(PCINT0/RXLIN/RXD/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT1/TXLIN/TXD/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT2/MISO/DO/OC0A/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT3/INT1/ISRC/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(PCINT4/MOSI/SDA/DI/ICP1/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT5/SCK/SCL/USCK/T1/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT6/~SS~/AIN0/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT7/AREF/XREF/AIN1/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT8/OC1AU/DI/SDA)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT15/OC1BX/dW/~RESET~/ADC10)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT14/OC1AX/INT0/ADC9)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT13/OC1BW/XTAL2/CLKO/ADC8)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT12/OC1AW/XTAL1/CLKI)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='(PCINT11/OC1BV)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT10/OC1AV/USCK/SCL)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT9/OC1BU/DO)PB1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY20-MMH',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='VQFN20, 2k Flash, 128B SRAM, No EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(PCINT4/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT3/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT2/AIN1/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT1/AIN0/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT0/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='(PCINT8/TPICLK/T0/CLKI)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT9/TPIDATA/MOSI/SDA/OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/~RESET~)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT10/INT0/MISO/OC1B/OC0A/CKOUT)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT7/SCL/SCK/T1/ICP1/OC0B/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT6/~SS~/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT5/ADC5)PA5',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY20-SSU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='S014, 2k Flash, 128B SRAM, No EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='(PCINT8/TPICLK/T0/CLKI)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT9/TPIDATA/MOSI/SDA/OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT11/~RESET~)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT10/INT0/MISO/OC1B/OC0A/CKOUT)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT7/SCL/SCK/T1/ICP1/OC0B/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT6/~SS~/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT5/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT4/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT3/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT2/AIN1/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT1/AIN0/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT0/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY20-XU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='TSS0P14, 2k Flash, 128B SRAM, No EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='(PCINT8/TPICLK/T0/CLKI)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT9/TPIDATA/MOSI/SDA/OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT11/~RESET~)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT10/INT0/MISO/OC1B/OC0A/CKOUT)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT7/SCL/SCK/T1/ICP1/OC0B/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT6/~SS~/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT5/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT4/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT3/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT2/AIN1/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT1/AIN0/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT0/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY22-8PC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='PDIP8, 2k Flash, 128B SRAM, 128B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~RESET',do_erc=True),
            Pin(num='2',name='(CLOCK)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='(MOSI)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(MISO/INT0)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(SCK/T0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY22-8SC',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SO8 Wide, 2k Flash, 128B SRAM, 128B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~RESET',do_erc=True),
            Pin(num='2',name='(CLOCK)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='(MOSI)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(MISO/INT0)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(SCK/T0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY2313-20MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='MLF20, 2k Flash, 128B SRAM, 128B EEPROM, Debug Wire',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PA1(XTAL2)',do_erc=True),
            Pin(num='3',name='PA0(XTAL1)',do_erc=True),
            Pin(num='4',name='(CKOUT/XCK/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(OC0B/T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT0/AIN0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT1/AIN1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT2/OC0A)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT3/OC1A)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT4/OC1B)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT5/MOSI/DI/SDA)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT6/MISO/DO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT7/USCK/SCK/SCL)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='PA2(~RESET~/dW)',do_erc=True)]),
        Part(name='ATTINY2313-20PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='PDIP20, 2k Flash, 128B SRAM, 128B EEPROM, Debug Wire',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PA2(~RESET~/dW)',do_erc=True),
            Pin(num='2',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PA1(XTAL2)',do_erc=True),
            Pin(num='5',name='PA0(XTAL1)',do_erc=True),
            Pin(num='6',name='(CKOUT/XCK/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(OC0B/T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT0/AIN0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT1/AIN1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT2/OC0A)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT3/OC1A)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT4/OC1B)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT5/MOSI/DI/SDA)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT6/MISO/DO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT7/USCK/SCK/SCL)PB7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY2313-20SU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SO20, 2k Flash, 128B SRAM, 128B EEPROM, Debug Wire',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PA2(~RESET~/dW)',do_erc=True),
            Pin(num='2',name='(RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PA1(XTAL2)',do_erc=True),
            Pin(num='5',name='PA0(XTAL1)',do_erc=True),
            Pin(num='6',name='(CKOUT/XCK/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(OC0B/T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='(ICP)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT0/AIN0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT1/AIN1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT2/OC0A)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT3/OC1A)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT4/OC1B)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT5/MOSI/DI/SDA)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT6/MISO/DO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT7/USCK/SCK/SCL)PB7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY2313A-PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='PDIP20, 2k Flash, 128B SRAM, 128B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PA2(~RESET~/dW/PCINT10)',do_erc=True),
            Pin(num='2',name='(PCINT11/RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT12/TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PA1(XTAL2/PCINT9)',do_erc=True),
            Pin(num='5',name='PA0(XTAL1/CLKI/PCINT8)',do_erc=True),
            Pin(num='6',name='(PCINT13/CKOUT/XCK/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT14/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT15/T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT16/OC0B/T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='(PCINT17/ICP1)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT0/AIN0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT1/AIN1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT2/OC0A)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT3/OC1A)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT4/OC1B)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT5/MOSI/DI/SDA)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT6/MISO/DO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT7/USCK/SCK/SCL)PB7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY2313A-SU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SO20, 2k Flash, 128B SRAM, 128B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PA2(~RESET~/dW/PCINT10)',do_erc=True),
            Pin(num='2',name='(PCINT11/RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT12/TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PA1(XTAL2/PCINT9)',do_erc=True),
            Pin(num='5',name='PA0(XTAL1/CLKI/PCINT8)',do_erc=True),
            Pin(num='6',name='(PCINT13/CKOUT/XCK/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT14/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT15/T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT16/OC0B/T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='(PCINT17/ICPI)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT0/AIN0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT1/AIN1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT2/OC0A)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT3/OC1A)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT4/OC1B)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT5/MOSI/DI/SDA)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT6/MISO/DO)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT7/USCK/SCK/SCL)PB7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY24-20MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='QFN/MLF20, 8k Flash, 512B SRAM, 512B EEPROM, dW',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY44-20MU', 'ATTINY84-20MU'],pins=[
            Pin(num='1',name='(PCINT4/USCK/SCL/T1/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT3/T0/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT2/AIN1/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT1/AIN0/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT0/AREF/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(PCINT5/DO/MISO/OC1B/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT8/CLKI/XTAL1)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT9/XTAL2)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/dW/~RESET~)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT10/CKOUT/OC0A/INT0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT7/ICP/OC0B/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT6/SDA/DI/MOSI/OC1A/ADC6)PA6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY24-20PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='PDIP14, 8k Flash, 512B SRAM, 512B EEPROM, dW',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY44-20PU', 'ATTINY84-20PU'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='(PCINT8/CLKI/XTAL1)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT9/XTAL2)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT11/dW/~RESET~)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT10/CKOUT/OC0A/INT0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT7/ICP/OC0B/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT6/SDA/DI/MOSI/OC1A/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT5/DO/MISO/OC1B/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT4/USCK/SCL/T1/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT3/T0/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT2/AIN1/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT1/AIN0/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT0/AREF/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY24-20SSU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SO14, 8k Flash, 512B SRAM, 128B EEPROM, dW',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY44-20SSU', 'ATTINY84-20SSU'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='(PCINT8/CLKI/XTAL1)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT9/XTAL2)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT11/dW/~RESET~)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT10/CKOUT/OC0A/INT0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT7/ICP/OC0B/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT6/SDA/DI/MOSI/OC1A/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT5/DO/MISO/OC1B/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT4/USCK/SCL/T1/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT3/T0/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT2/AIN1/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT1/AIN0/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT0/AREF/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY24A-MMH',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='VQFN20, 8k Flash, 512B SRAM, 512B EEPROM, dW',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY44A-MMH', 'ATTINY84A-MMH'],pins=[
            Pin(num='1',name='(PCINT4/USCK/SCL/T1/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT3/T0/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT2/AIN1/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT1/AIN0/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT0/AREF/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(PCINT5/DO/MISO/OC1B/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT8/CLKI/XTAL1)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT9/XTAL2)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/dW/~RESET~)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT10/CKOUT/OC0A/INT0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT7/ICP/OC0B/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT6/SDA/DI/MOSI/OC1A/ADC6)PA6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY24A-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='QFN/MLF20, 8k Flash, 512B SRAM, 512B EEPROM, dW',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY44A-MU', 'ATTINY84A-MU'],pins=[
            Pin(num='1',name='(PCINT4/USCK/SCL/T1/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT3/T0/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT2/AIN1/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT1/AIN0/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT0/AREF/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(PCINT5/DO/MISO/OC1B/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT8/CLKI/XTAL1)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT9/XTAL2)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/dW/~RESET~)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT10/CKOUT/OC0A/INT0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT7/ICP/OC0B/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT6/SDA/DI/MOSI/OC1A/ADC6)PA6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY24A-PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='PDIP14, 8k Flash, 512B SRAM, 512B EEPROM, dW',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY44A-PU', 'ATTINY84A-PU'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='(PCINT8/CLKI/XTAL1)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT9/XTAL2)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT11/dW/~RESET~)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT10/CKOUT/OC0A/INT0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT7/ICP/OC0B/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT6/SDA/DI/MOSI/OC1A/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT5/DO/MISO/OC1B/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT4/USCK/SCL/T1/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT3/T0/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT2/AIN1/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT1/AIN0/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT0/AREF/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY24A-SSU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SO14, 8k Flash, 512B SRAM, 512B EEPROM, dW',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY44A-SSU', 'ATTINY84A-SSU'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='(PCINT8/CLKI/XTAL1)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT9/XTAL2)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT11/dW/~RESET~)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT10/CKOUT/OC0A/INT0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT7/ICP/OC0B/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT6/SDA/DI/MOSI/OC1A/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT5/DO/MISO/OC1B/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT4/USCK/SCL/T1/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT3/T0/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT2/AIN1/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT1/AIN0/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT0/AREF/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY25-20MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='ATTINY25, QFN/MLF20, 8k Flash, 512B SRAM, 512B EEPROM, Debug Wire',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY45-20MU', 'ATTINY85-20MU'],pins=[
            Pin(num='1',name='PB5(~RESET~/dW/ADC0/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PB3(XTAL1/CLKI/OC1B/ADC3/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PB4(XTAL2/CLKO/OC1B/ADC2/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='PB0(MOSI/DI/SDA/AIN0/OC0A/OC1A/AREF/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PB1(MISO/DO/AIN1/OC0B/OC1A/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PB2(SCK/USCK/SCL/T0/INT0/ADC1/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY25-20PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='ATTINY85, PDIP8, 8k Flash, 512B SRAM, 512B EEPROM, Debug Wire',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY45-20PU', 'ATTINY85-20PU'],pins=[
            Pin(num='1',name='PB5(~RESET~/dW/ADC0/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PB3(XTAL1/CLKI/OC1B/ADC3/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PB4(XTAL2/CLKO/OC1B/ADC2/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PB0(MOSI/DI/SDA/AIN0/OC0A/OC1A/AREF/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PB1(MISO/DO/AIN1/OC0B/OC1A/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PB2(SCK/USCK/SCL/T0/INT0/ADC1/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY25-20SSU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SO8, 2k Flash, 128B SRAM, 128B EEPROM, Debug Wire',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PB5(~RESET~/dW/ADC0/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PB3(XTAL1/CLKI/OC1B/ADC3/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PB4(XTAL2/CLKO/OC1B/ADC2/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PB0(MOSI/DI/SDA/AIN0/OC0A/OC1A/AREF/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PB1(MISO/DO/AIN1/OC0B/OC1A/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PB2(SCK/USCK/SCL/T0/INT0/ADC1/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY25-20SU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='ATTINY85, SO8 Wide, 8k Flash, 512B SRAM, 512B EEPROM, Debug Wire',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY45-20SU', 'ATTINY85-20SU'],pins=[
            Pin(num='1',name='PB5(~RESET~/dW/ADC0/PCINT5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PB3(XTAL1/CLKI/~OC1B~/ADC3/PCINT3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PB4(XTAL2/CLKO/OC1B/ADC2/PCINT4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PB0(MOSI/DI/SDA/AIN0/OC0A/~OC1A~/AREF/PCINT0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PB1(MISO/DO/AIN1/OC0B/OC1A/PCINT1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PB2(SCK/USCK/SCL/T0/INT0/ADC1/PCINT2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY26-16MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='QFN/MLF32, 2k Flash, 128B SRAM, 128B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='2',name='(OC1B)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(ADC7/XTAL1)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(ADC8/XTAL2)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(ADC9/INT0/T0)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(MOSI/DI/SDA/~OC1A~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(ADC10/~RESET~)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(MISO/DO/OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(AREF)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(SCK/SCL/~OC1B~)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(AIN1/ADC6)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(AIN0/ADC5)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(ADC4)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(ADC3)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='AVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY26-16PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='PDIP20, 2k Flash, 128B SRAM, 128B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(MOSI/DI/SDA/~OC1A~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO/DO/OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK/SCL/~OC1B~)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(OC1B)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(ADC7/XTAL1)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(ADC8/XTAL2)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(ADC9/INT0/T0)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(ADC10/~RESET~)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(AIN1/ADC6)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(AIN0/ADC5)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(ADC4)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(ADC3)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='(AREF)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY26-16SU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SO20, 2k Flash, 128B SRAM, 128B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(MOSI/DI/SDA/~OC1A~)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO/DO/OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK/SCL/~OC1B~)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(OC1B)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(ADC7/XTAL1)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(ADC8/XTAL2)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(ADC9/INT0/T0)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(ADC10/~RESET~)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(AIN1/ADC6)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(AIN0/ADC5)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(ADC4)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(ADC3)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='(AREF)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(ADC1)PA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY261-20MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='QFN/MLF32, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY461-20MU', 'ATTINY861-20MU'],pins=[
            Pin(num='2',name='(OC1B/PCINT11)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(ADC7/~OC1D~/CLKI/XTAL1/PCINT12)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(ADC8/OC1D/CLKO/XTAL2/PCINT13)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(ADC9/INT0/T0/PCINT14)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(MOSI/DI/SDA/~OC1A~/PCINT8)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(ADC10/~RESET~/PCINT15)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(MISO/DO/OC1A/PCINT9)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(AREF/PCINT3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(SCK/USCK/SCL/~OC1B~/PCINT10)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(ADC6/AIN1/PCINT7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(ADC2/INT1/USCK/SCL/PCINT2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(ADC5/AIN0/PCINT6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(ADC4/AIN2/PCINT5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ADC1/DO/PCINT1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(ADC0/DI/SDA/PCINT0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(ADC3/ICP0/PCINT4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='AVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY261-20PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='PDIP20, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY461-20PU', 'ATTINY861-20PU'],pins=[
            Pin(num='1',name='(MOSI/DI/SDA/~OC1A~/PCINT8)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO/DO/OC1A/PCINT9)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK/USCK/SCL/~OC1B~/PCINT10)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(OC1B/PCINT11)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(ADC7/~OC1D~/CLKI/XTAL1/PCINT12)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(ADC8/OC1D/CLKO/XTAL2/PCINT13)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(ADC9/INT0/T0/PCINT14)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(ADC10/~RESET~/PCINT15)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(ADC0/DI/SDA/PCINT0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(ADC6/AIN1/PCINT7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(ADC5/AIN0/PCINT6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(ADC4/AIN2/PCINT5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(ADC3/ICP0/PCINT4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='(AREF/PCINT3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(ADC2/INT1/USCK/SCL/PCINT2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(ADC1/DO/PCINT1)PA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY261-20SU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='PDIP20, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY461-20SU', 'ATTINY861-20SU'],pins=[
            Pin(num='1',name='(MOSI/DI/SDA/~OC1A~/PCINT8)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO/DO/OC1A/PCINT9)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK/USCK/SCL/~OC1B~/PCINT10)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(OC1B/PCINT11)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(ADC7/~OC1D~/CLKI/XTAL1/PCINT12)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(ADC8/OC1D/CLKO/XTAL2/PCINT13)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(ADC9/INT0/T0/PCINT14)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(ADC10/~RESET~/PCINT15)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(ADC0/DI/SDA/PCINT0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(ADC6/AIN1/PCINT7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(ADC5/AIN0/PCINT6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(ADC4/AIN2/PCINT5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(ADC3/ICP0/PCINT4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='(AREF/PCINT3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(ADC2/INT1/USCK/SCL/PCINT2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(ADC1/DO/PCINT1)PA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY261A-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='QFN/MLF32, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY461A-MU', 'ATTINY861A-MU'],pins=[
            Pin(num='2',name='(OC1B/PCINT11)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(ADC7/~OC1D~/CLKI/XTAL1/PCINT12)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(ADC8/OC1D/CLKO/XTAL2/PCINT13)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(ADC9/INT0/T0/PCINT14)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(MOSI/DI/SDA/~OC1A~/PCINT8)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(ADC10/~RESET~/PCINT15)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(MISO/DO/OC1A/PCINT9)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(AREF/PCINT3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(SCK/USCK/SCL/~OC1B~/PCINT10)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(ADC6/AIN1/PCINT7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(ADC2/INT1/USCK/SCL/PCINT2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(ADC5/AIN0/PCINT6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(ADC4/AIN2/PCINT5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(ADC1/DO/PCINT1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(ADC0/DI/SDA/PCINT0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(ADC3/ICP0/PCINT4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='AVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY261A-PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='PDIP20, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY461A-PU', 'ATTINY861A-PU'],pins=[
            Pin(num='1',name='(MOSI/DI/SDA/~OC1A~/PCINT8)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO/DO/OC1A/PCINT9)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK/USCK/SCL/~OC1B~/PCINT10)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(OC1B/PCINT11)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(ADC7/~OC1D~/CLKI/XTAL1/PCINT12)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(ADC8/OC1D/CLKO/XTAL2/PCINT13)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(ADC9/INT0/T0/PCINT14)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(ADC10/~RESET~/PCINT15)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(ADC0/DI/SDA/PCINT0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(ADC6/AIN1/PCINT7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(ADC5/AIN0/PCINT6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(ADC4/AIN2/PCINT5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(ADC3/ICP0/PCINT4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='(AREF/PCINT3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(ADC2/INT1/USCK/SCL/PCINT2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(ADC1/DO/PCINT1)PA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY261A-SU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SO20, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY461A-SU', 'ATTINY861A-SU'],pins=[
            Pin(num='1',name='(MOSI/DI/SDA/~OC1A~/PCINT8)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO/DO/OC1A/PCINT9)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK/USCK/SCL/~OC1B~/PCINT10)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(OC1B/PCINT11)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(ADC7/~OC1D~/CLKI/XTAL1/PCINT12)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(ADC8/OC1D/CLKO/XTAL2/PCINT13)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(ADC9/INT0/T0/PCINT14)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(ADC10/~RESET~/PCINT15)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(ADC0/DI/SDA/PCINT0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(ADC6/AIN1/PCINT7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(ADC5/AIN0/PCINT6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(ADC4/AIN2/PCINT5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(ADC3/ICP0/PCINT4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='(AREF/PCINT3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(ADC2/INT1/USCK/SCL/PCINT2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(ADC1/DO/PCINT1)PA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY261A-XU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='TSSOP20, 8k Flash, 512B SRAM, 512B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY461A-XU', 'ATTINY861A-XU'],pins=[
            Pin(num='1',name='(MOSI/DI/SDA/~OC1A~/PCINT8)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(MISO/DO/OC1A/PCINT9)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(SCK/USCK/SCL/~OC1B~/PCINT10)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(OC1B/PCINT11)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(ADC7/~OC1D~/CLKI/XTAL1/PCINT12)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(ADC8/OC1D/CLKO/XTAL2/PCINT13)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(ADC9/INT0/T0/PCINT14)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(ADC10/~RESET~/PCINT15)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(ADC0/DI/SDA/PCINT0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(ADC6/AIN1/PCINT7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(ADC5/AIN0/PCINT6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(ADC4/AIN2/PCINT5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(ADC3/ICP0/PCINT4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='(AREF/PCINT3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(ADC2/INT1/USCK/SCL/PCINT2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(ADC1/DO/PCINT1)PA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY28-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR IR',description='TQFP32, 2k Flash, No SRAM, No EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL1',do_erc=True),
            Pin(num='8',name='XTAL2',do_erc=True),
            Pin(num='9',name='PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(AIN0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(AIN1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(T0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(INT0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(IR)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(INT1)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='~RESET',do_erc=True)]),
        Part(name='ATTINY28-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR IR',description='MLF/QFN32, 2k Flash, No SRAM, No EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='XTAL1',do_erc=True),
            Pin(num='8',name='XTAL2',do_erc=True),
            Pin(num='9',name='PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(AIN0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(AIN1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(T0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(INT0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(~IR~)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(INT1)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='~RESET',do_erc=True)]),
        Part(name='ATTINY28-PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR IR',description='PDIP28 Narrow, 2k Flash, No SRAM, No EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~RESET',do_erc=True),
            Pin(num='2',name='PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='XTAL1',do_erc=True),
            Pin(num='10',name='XTAL2',do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(AIN0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(AIN1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(~IR~)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(T0)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(INT0)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(INT1)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB5',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY4-TS',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SOT-23-6, 512B Flash, 32B SRAM, No EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PB0(AIN0/OC0A/PCINT0/TPIDATA)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='PB1(AIN1/OC0B/ICP0/PCINT1/CLKI/TPICLK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PB2(INT0/T0/PCINT2/CLKO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='PB3(~RESET~/PCINT3)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY40-MMH',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='MLF/VQFN20, 4k Flash, 256B SRAM, No EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(PCINT6/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT5/OC0B/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT4/T0/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT3/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT2/AIN1/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT1/AIN0/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT0/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='(PCINT17/TPICLK/CLKI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT7/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT16/TPIDATA/MOSI/SDA)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT15/~RESET~)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT14/MISO/CLKO/INT0)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT13/SCK/SCL/ICP1/T1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT12/~SS~/OC0A)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT11/ADC11)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT10/ADC10)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT9/ADC9)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT8/ADC8)PB0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY40-SU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='S020 Wide, 4k Flash, 256B SRAM, No EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(PCINT8/ADC8)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT7/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT6/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT5/OC0B/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT4/T0/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT3/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT2/AIN1/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT1/AIN0/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT0/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(PCINT9/ADC9)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='(PCINT17/TPICLK/CLKI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT16/TPIDATA/MOSI/SDA)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT15/~RESET~)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT14/MISO/CLKO/INT0)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT13/SCK/SCL/ICP1/T1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT12/~SS~/OC0A)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT11/ADC11)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT10/ADC10)PB2',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY40-XU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='TSS0P20, 4k Flash, 256B SRAM, No EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(PCINT8/ADC8)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT7/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT6/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT5/OC0B/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT4/T0/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT3/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT2/AIN1/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT1/AIN0/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT0/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(PCINT9/ADC9)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='(PCINT17/TPICLK/CLKI)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT16/TPIDATA/MOSI/SDA)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT15/~RESET~)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT14/MISO/CLKO/INT0)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT13/SCK/SCL/ICP1/T1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT12/~SS~/OC0A)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT11/ADC11)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT10/ADC10)PB2',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY4313-PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='PDIP20, 4k Flash, 256B SRAM, 256B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PA2(~RESET~/dW/PCINT10)',do_erc=True),
            Pin(num='2',name='(PCINT11/RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT12/TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PA1(XTAL2/PCINT9)',do_erc=True),
            Pin(num='5',name='PA0(XTAL1/CLKI/PCINT8)',do_erc=True),
            Pin(num='6',name='(PCINT13/CKOUT/XCK/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT14/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT15/T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT16/OC0B/T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='(PCINT17/ICPI)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(AIN0/PCINT0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(AIN1/PCINT1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(OC0A/PCINT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(OC1A/PCINT3)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(OC1B/PCINT4)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(MOSI/DI/SDA/PCINT5)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(MISO/DO/PCINT6)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(USCK/SCK/SCL/PCINT7)PB7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY4313-SU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SO20, 4k Flash, 256B SRAM, 256B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PA2(~RESET~/dW/PCINT10)',do_erc=True),
            Pin(num='2',name='(PCINT11/RXD)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT12/TXD)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PA1(XTAL2/PCINT9)',do_erc=True),
            Pin(num='5',name='PA0(XTAL1/CLKI/PCINT8)',do_erc=True),
            Pin(num='6',name='(PCINT13/CKOUT/XCK/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT14/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT15/T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT16/OC0B/T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='(PCINT17/ICPI)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(AIN0/PCINT0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(AIN1/PCINT1)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(OC0A/PCINT2)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(OC1A/PCINT3)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(OC1B/PCINT4)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(MOSI/DI/SDA/PCINT5)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(MISO/DO/PCINT6)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(USCK/SCK/SCL/PCINT7)PB7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY43U-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR Battery Boost',description='MLF/QFN20, 4k Flash, 256B SRAM, 64B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(PCINT10/OC0B)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT11/CLKO/T1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT12/DI/OC1A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT13/DO/OC1B)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT14/USCK/SCL)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT15/INT0)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='LSW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(PCINT9/OC0A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT0/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT1/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT2/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT3/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT4/AIN0)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT5/AIN1)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT6/CLKI)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT7/dW/~RESET~)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT8/T0)PB0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY43U-SU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR Battery Boost',description='SO20, 4k Flash, 256B SRAM, 64B EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(PCINT8/T0)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT9/OC0A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT10/OC0B)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT11/CLKO/T1)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT12/DI/OC1A)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT13/DO/OC1B)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT14/USCK/SCL)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT15/INT0)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(PCINT7/dW/~RESET~)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='LSW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='(PCINT0/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT1/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT2/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT3/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT4/AIN0)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT5/AIN1)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT6/CLKI)PA6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY441-MMH',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='WQFN20, 8k Flash, 512B SRAM, 512B EEPROM, ADC, ACI, dW',ref_prefix='U',num_units=1,fplist=['WQFN*'],do_erc=True,aliases=['ATTINY841-MMH'],pins=[
            Pin(num='1',name='(PCINT4/SCK/SCL/RXD1/T1/TOCC3/AIN11/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT3/SCK/XCK0/T0/TOCC2/AIN10/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT2/~SS~/RXD0/TOCC1/AIN01/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT1/MOSI/TXD0/TOCC0/AIN00/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT0/MISO/AREF/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(PCINT5/MISO/TXD1/T2/TOCC4/ACO0/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT8/CLKI/XTAL1/ADC11)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT9/INT0/XTAL2/ADC10)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/dW/~RESET~/ADC9)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT10/RXD0/ICP2/CLKO/TOCC7/ADC8)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT7/~SS~/TXD0/ICP1/TOCC6/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT6/MOSI/SDA/XCK1/TOCC5/ACO1/ADC6)PA6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY441-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='MLF/QFN20, 8k Flash, 512B SRAM, 512B EEPROM, ADC, ACI, dW',ref_prefix='U',num_units=1,fplist=['QFN*', 'MLF*'],do_erc=True,aliases=['ATTINY841-MU'],pins=[
            Pin(num='1',name='(PCINT4/SCK/SCL/RXD1/T1/TOCC3/AIN11/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT3/SCK/XCK0/T0/TOCC2/AIN10/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT2/~SS~/RXD0/TOCC1/AIN01/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT1/MOSI/TXD0/TOCC0/AIN00/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT0/MISO/AREF/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='(PCINT5/MISO/TXD1/T2/TOCC4/ACO0/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT8/CLKI/XTAL1/ADC11)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT9/INT0/XTAL2/ADC10)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT11/dW/~RESET~/ADC9)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT10/RXD0/ICP2/CLKO/TOCC7/ADC8)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT7/~SS~/TXD0/ICP1/TOCC6/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT6/MOSI/SDA/XCK1/TOCC5/ACO1/ADC6)PA6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY441-SSU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SO14, 8k Flash, 512B SRAM, 512B EEPROM, ADC, ACI, dW',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['ATTINY841-SSU'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='(PCINT8/CLKI/XTAL1/ADC11)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT9/INT0/XTAL2/ADC10)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT11/dW/~RESET~/ADC9)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT10/RXD0/ICP2/CLKO/TOCC7/ADC8)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT7/~SS~/TXD0/ICP1/TOCC6/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT6/MOSI/SDA/XCK1/TOCC5/ACO1/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT5/MISO/TXD1/T2/TOCC4/ACO0/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT4/SCK/SCL/RXD1/T1/TOCC3/AIN11/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT3/SCK/XCK0/T0/TOCC2/AIN10/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT2/~SS~/RXD0/TOCC1/AIN01/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT1/MOSI/TXD0/TOCC0/AIN00/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT0/MISO/AREF/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATTINY48-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='TQFP32, 8k Flash, 512B SRAM, 64B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY88-AU'],pins=[
            Pin(num='1',name='(PCINT19/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT20/T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT26)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='(PCINT27)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT6/CLKI)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT7)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT21/T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT22/AIN0)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT15)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(PCINT16)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT23/AIN1)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(PCINT17)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT0/CLKO/ICP1)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT25/ADC7)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(PCINT18/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT1/OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT8/ADC0)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT2/OC1B/~SS~)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT9/ADC1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT3/MOSI)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT10/ADC2)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT4/MISO)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT11/ADC3)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT5/SCK)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT12/SDA/ADC4)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='(PCINT13/SCL/ADC5)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT24/ADC6)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(PCINT14/~RESET~)PC6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY48-MMH',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='QFN/MLF28, 8k Flash, 512B SRAM, 64B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY88-MMH'],pins=[
            Pin(num='1',name='(PCINT19/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT20/T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='(PCINT6/CLKI)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT7)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT21/T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT22/AIN0)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT23/AIN1)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT0/CLKO/ICP1)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT9/ADC1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT1/OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(PCINT10/ADC2)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT2/OC1B/~SS~)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT11/ADC3)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT3/MOSI)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT12/SDA/ADC4)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT4/MISO)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT13/SCL/ADC5)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT5/SCK)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT14/~RESET~)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='(PCINT16)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT15)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT17)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='(PCINT18/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT8/ADC0)PC0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY48-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='QFN/MLF32, 8k Flash, 512B SRAM, 64B EEPROM',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATTINY88-MU'],pins=[
            Pin(num='1',name='(PCINT19/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT20/T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT26)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='(PCINT27)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='(PCINT6/CLKI)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT7)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT21/T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT22/AIN0)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT15)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='(PCINT16)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT23/AIN1)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(PCINT17)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT0/CLKO/ICP1)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='(PCINT25/ADC7)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='(PCINT18/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT1/OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT8/ADC0)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT2/OC1B/~SS~)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT9/ADC1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT3/MOSI)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT10/ADC2)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT4/MISO)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT11/ADC3)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT5/SCK)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT12/SDA/ADC4)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='(PCINT13/SCL/ADC5)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT24/ADC6)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(PCINT14/~RESET~)PC6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY48-PU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='PDIP28 Narrow, 8k Flash, 512B SRAM, 64B EEPROM',ref_prefix='U',num_units=1,fplist=['28DIP-ELL600', '28dip600'],do_erc=True,aliases=['ATTINY88-PU'],pins=[
            Pin(num='1',name='(PCINT14/~RESET~)PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT16)PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT17)PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT18/INT0)PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='(PCINT19/INT1)PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='(PCINT20/T0)PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='(PCINT6/CLKI)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT7)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AVCC',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT21/T1)PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(PCINT15)PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT22/AIN0)PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='(PCINT23/AIN1)PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(PCINT8/ADC0)PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT0/CLKO/ICP1)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='(PCINT9/ADC1)PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT1/OC1A)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT10/ADC2)PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='(PCINT2/OC1B/~SS~)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT11/ADC3)PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='(PCINT3/MOSI)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT12/SDA/ADC4)PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT4/MISO)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(PCINT13/SCL/ADC5)PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT5/SCK)PB5',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY5-TS',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SOT-23-6, 512B Flash, 32B SRAM, No EEPROM, ADC',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PB0(AIN0/ADC0/OC0A/PCINT0/TPIDATA)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='PB1(AIN1/ADC1/OC0B/ICP0/PCINT1/CLKI/TPICLK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PB2(INT0/ADC2/T0/PCINT2/CLKO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='PB3(~RESET~/ADC3/PCINT3)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY87-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR Automotive',description='MLF32, 8k Flash, 512B SRAM, 512B EEPROM, Debug Wire',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='3',name='(PCINT3/INT1/ISRC/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='(PCINT4/MOSI/SDA/DI/ICP1/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT5/SCK/SCL/USCK/T1/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='(PCINT1/TXLIN/TXD/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT6/~SS~/AIN0/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='(PCINT2/MISO/DO/OC0A/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT7/AREF/XREF/AIN1/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT15/OC1BX/dW/~RESET~/ADC10)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='(PCINT14/OC1AX/INT0/ADC9)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='(PCINT11/OC1BV)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(PCINT10/OC1AV/USCK/SCL)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='(PCINT9/OC1BU/DO)PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT13/OC1BW/XTAL2/CLKO/ADC8)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='(PCINT8/OC1AU/DI/SDA)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT12/OC1AW/XTAL1/CLKI)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='(PCINT0/RXLIN/RXD/ADC0)PA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY87-SU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR Automotive',description='S020, 8k Flash, 512B SRAM, 512B EEPROM, Debug Wire',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(PCINT0/RXLIN/RXD/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT1/TXLIN/TXD/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT2/MISO/DO/OC0A/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT3/INT1/ISRC/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(PCINT4/MOSI/SDA/DI/ICP1/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT5/SCK/SCL/USCK/T1/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT6/~SS~/AIN0/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT7/AREF/XREF/AIN1/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT8/OC1AU/DI/SDA)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT15/OC1BX/dW/~RESET~/ADC10)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT14/OC1AX/INT0/ADC9)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT13/OC1BW/XTAL2/CLKO/ADC8)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT12/OC1AW/XTAL1/CLKI)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='(PCINT11/OC1BV)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT10/OC1AV/USCK/SCL)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT9/OC1BU/DO)PB1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY87-XU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR Automotive',description='TSSOP20, 8k Flash, 512B SRAM, 512B EEPROM, Debug Wire',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(PCINT0/RXLIN/RXD/ADC0)PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='(PCINT1/TXLIN/TXD/ADC1)PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='(PCINT2/MISO/DO/OC0A/ADC2)PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='(PCINT3/INT1/ISRC/ADC3)PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='(PCINT4/MOSI/SDA/DI/ICP1/ADC4)PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(PCINT5/SCK/SCL/USCK/T1/ADC5)PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='(PCINT6/~SS~/AIN0/ADC6)PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='(PCINT7/AREF/XREF/AIN1/ADC7)PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='(PCINT8/OC1AU/DI/SDA)PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='(PCINT15/OC1BX/dW/~RESET~/ADC10)PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(PCINT14/OC1AX/INT0/ADC9)PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(PCINT13/OC1BW/XTAL2/CLKO/ADC8)PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='(PCINT12/OC1AW/XTAL1/CLKI)PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='(PCINT11/OC1BV)PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='(PCINT10/OC1AV/USCK/SCL)PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(PCINT9/OC1BU/DO)PB1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATTINY9-TS',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller tinyAVR',description='SOT-23-6, 1024B Flash, 32B SRAM, No EEPROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PB0(AIN0/OC0A/PCINT0/TPIDATA)',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='PB1(AIN1/OC0B/ICP0/PCINT1/CLKI/TPICLK)',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PB2(INT0/T0/PCINT2/CLKO)',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='PB3(~RESET~/PCINT3)',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA128A1-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='TQFP100, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA64A1-AU', 'ATXMEGA192A1-AU', 'ATXMEGA256A1-AU', 'ATXMEGA384A1-AU'],pins=[
            Pin(num='1',name='AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='AREF/AC0/ADC0/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AC1/ADC1/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='DAC0/AC2/ADC2/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DAC1/AC3/ADC3/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TMS/AC4/ADC4/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TDI/AC5/ADC5/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='MOSI/XCK1/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='MOSI/XCK1/OC1B/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='MOSI/XCK1/OC0CHS/OC1B/PE5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF5/OC1B/MOSI/XCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PH5/~CS1~/A17',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='PJ5/D5/A5/A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='PK5/A5/A13/A21',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='11',name='TCK/AC6/ADC6/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='MISO/RXD1/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='MISO/RXD1/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='MISO/RXD1/~OC0DLS~/PE6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PF6/MISO/RXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PH6/~CS2~/A18',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='PJ6/D6/A6/A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PK6/A6/A14/A22',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='PR0/XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='TDO/AC0OUT/AC7/ADC7/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='EVOUT/CLKOUT/SCK/TXD1/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='EVOUT/CLKOUT/SCK/TXD1/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='EVOUT/CLKOUT/SCK/TXD1/OC0DHS/PE7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PF7/SCK/TXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PH7/~CS3~/A19',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='PJ7/D7/A7/A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PK7/A7/A15/A23',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='PR1/XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='43',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='73',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='83',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='93',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='84',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SDA/OC0A/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SDA/~OC0ALS~/OC0A/PE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PF0/OC0A/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PH0/~WE',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='PJ0/D0/A0/A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='PK0/A0/A8/A16',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PQ0/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='AREF/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='SCL/XCK0/OC0B/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='SCL/XCK0/OC0AHS/OC0B/PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PF1/OC0B/SCL/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PH1/~RE',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='PJ1/D1/A1/A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='PK1/A1/A9/A17',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PQ1/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='RXD0/OC0C/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RXD0/~OC0BLS~/OC0C/PE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PH2/ALE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='PJ2/D2/A2/A10',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='PK2/A2/A10/A18',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PQ2',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='DAC0/AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TXD0/OC0BHS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TXD0/OC0D/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='TXD0/OC0BHS/OC0D/PE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PH3/ALE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='PJ3/D3/A3/A11',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='PK3/A3/A11/A19',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PQ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='DAC1/AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='~SS~/OC1A/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='~SS~/~OC0CLS~/OC1A/PE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF4/OC1A/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PH4/~CS0~/A16',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='PJ4/D4/A4/A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='PK4/A4/A12/A20',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='PDI_DAT',do_erc=True),
            Pin(num='99',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA128A1U-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='TQFP100, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, USB, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA64A1U-AU'],pins=[
            Pin(num='1',name='AC1OUT/AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='AREF/AC0/ADC0/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AC1/ADC1/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='DAC0/AC2/ADC2/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DAC1/AC3/ADC3/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TMS/AC4/ADC4/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TDI/AC5/ADC5/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='MOSI/XCK1/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='MOSI/XCK1/OC1B/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='MOSI/XCK1/OC0CHS/OC1B/PE5',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF5/OC1B/MOSI/XCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PH5/~CS1~/A17/BA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='PJ5/D5/A5/A9/A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='PK5/A5/A13/A21',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='11',name='TCK/AC1OUT/AC6/ADC6/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='CLKRTC/MISO/RXD1/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='MISO/RXD1/D-/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='MISO/RXD1/~OC0DLS~/PE6',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PF6/MISO/RXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PH6/~CS2~/A18/CKE',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='PJ6/D6/A6/A10/A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PK6/A6/A14/A22',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='PR0/XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='TDO/AC0OUT/AC7/ADC7/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='EVOUT/CLKP/SCK/TXD1/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='EVOUT/CLKP/SCK/TXD1/D+/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='EVOUT/CLKP/SCK/TXD1/OC0DHS/PE7',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PF7/SCK/TXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PH7/~CS3~/A19/CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='PJ7/D7/A7/A11/A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PK7/A7/A15/A23',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='PR1/XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='43',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='73',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='83',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='93',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='84',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SDA/OC0A/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SDA/~OC0ALS~/OC0A/PE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PF0/OC0A/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PH0/~WE',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='PJ0/D0/A0/A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='PK0/A0/A8/A16',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PQ0/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='AREF/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='SCL/XCK0/OC0B/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='SCL/XCK0/OC0AHS/OC0B/PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PF1/OC0B/SCL/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PH1/~RE~/~CAS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='PJ1/D1/A1/A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='PK1/A1/A9/A17',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PQ1/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='RXD0/OC0C/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RXD0/~OC0BLS~/OC0C/PE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PH2/~ALE1~/~RAS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='PJ2/D2/A2/A10',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='PK2/A2/A10/A18',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PQ2',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='DAC0/AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TXD0/OC0BHS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TXD0/OC0D/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='TXD0/OC0BHS/OC0D/PE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PH3/~ALE2~/~DQM~',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='PJ3/D3/A3/A11',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='PK3/A3/A11/A19',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PQ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='DAC1/AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='~SS~/OC1A/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='~SS~/~OC0CLS~/OC1A/PE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF4/OC1A/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PH4/~CS0~/A16/BA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='PJ4/D4/A4/A8/A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='PK4/A4/A12/A20',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='PDI_DAT',do_erc=True),
            Pin(num='99',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA128A3-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='TQFP64, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA64A3-AU', 'ATXMEGA256A3-AU', 'ATXMEGA192A3-AU'],pins=[
            Pin(num='1',name='AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AREFB/AC0/ADC0/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AC1/ADC1/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DAC0/AC2/ADC2/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='DAC1/AC3/ADC3/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TMS/AC4/ADC4/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PD4/OC1A/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE4/OC1A/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF4',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='TDI/AC5/ADC5/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='MOSI/XCK1/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PD5/OC1B/XCK1/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE5/OC1B/XCK1/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PF5',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='TCK/AC6/ADC6/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='MISO/RXD1/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PD6/RXD1/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE6/RXD1/MISO/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREFA/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TDO/AC0OUT/AC7/ADC7/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='EVOUT/CLKOUT/SCK/TXD1/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PD7/TXD1/SCK/CLKOUT/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE7/TXD1/SCK/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='OC0A/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PE0/OC0A/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PF0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PDI_DATA',do_erc=True),
            Pin(num='17',name='SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='XCK0/OC0B/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PE1/OC0B/XCK0/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF1/OC0B/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='18',name='RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RXD0/OC0C/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PR0/XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TXD0/OC0BHS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TXD0/OC0D/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PR1/XTAL1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA128A3-MH',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='QFN64, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA64A3-MH', 'ATXMEGA256A3-MH', 'ATXMEGA192A3-MH'],pins=[
            Pin(num='1',name='AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AREFB/AC0/ADC0/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AC1/ADC1/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DAC0/AC2/ADC2/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='DAC1/AC3/ADC3/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TMS/AC4/ADC4/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PD4/OC1A/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE4/OC1A/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF4',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='TDI/AC5/ADC5/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='MOSI/XCK1/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PD5/OC1B/XCK1/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE5/OC1B/XCK1/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PF5',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='TCK/AC6/ADC6/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='MISO/RXD1/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PD6/RXD1/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE6/RXD1/MISO/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREFA/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TDO/AC0OUT/AC7/ADC7/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='EVOUT/CLKOUT/SCK/TXD1/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PD7/TXD1/SCK/CLKOUT/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE7/TXD1/SCK/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='OC0A/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PE0/OC0A/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PF0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PDI_DATA',do_erc=True),
            Pin(num='17',name='SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='XCK0/OC0B/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PE1/OC0B/XCK0/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF1/OC0B/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='18',name='RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RXD0/OC0C/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PR0/XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TXD0/OC0BHS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TXD0/OC0D/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PR1/XTAL1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA128A3U-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='TQFP64, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, JTAG, USB',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA64A3U-AU', 'ATXMEGA256A3U-AU', 'ATXMEGA192A3U-AU'],pins=[
            Pin(num='1',name='AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AC1OUT/AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AREFB/AC0/ADC0/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AC1/ADC1/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DAC0/AC2/ADC2/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='DAC1/AC3/ADC3/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TMS/AC4/ADC4/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PD4/OC1A/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE4/OC1A/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF4',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='TDI/AC5/ADC5/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='MOSI/XCK1/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PD5/OC1B/XCK1/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE5/OC1B/XCK1/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PF5',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='TCK/AC1OUT/AC6/ADC6/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='MISO/RXD1/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PD6/RXD1/D-/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE6/RXD1/MISO/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREFA/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TDO/AC0OUT/AC7/ADC7/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='EVOUT/CLKOUT/SCK/TXD1/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PD7/TXD1/D+/SCK/CLKOUT/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE7/TXD1/SCK/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SDAIN/SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='OC0A/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PE0/OC0A/SDA/SDAIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PF0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PDI_DATA',do_erc=True),
            Pin(num='17',name='SCLIN/SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='XCK0/OC0B/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PE1/OC0B/XCK0/SCL/SCLIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF1/OC0B/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='18',name='SDAOUT/RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RXD0/OC0C/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE2/OC0C/RXD0/SDAOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PR0/XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='SCLOUT/TXD0/OC0BHS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TXD0/OC0D/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE3/OC0D/TXD0/SCLOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PR1/XTAL1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA128A3U-MH',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='QFN64, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, JTAG, USB',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA64A3U-MH', 'ATXMEGA256A3U-MH', 'ATXMEGA192A3U-MH'],pins=[
            Pin(num='1',name='AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AC1OUT/AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AREFB/AC0/ADC0/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AC1/ADC1/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DAC0/AC2/ADC2/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='DAC1/AC3/ADC3/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TMS/AC4/ADC4/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PD4/OC1A/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE4/OC1A/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF4',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='TDI/AC5/ADC5/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='MOSI/XCK1/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PD5/OC1B/XCK1/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE5/OC1B/XCK1/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PF5',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='TCK/AC1OUT/AC6/ADC6/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='MISO/RXD1/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PD6/RXD1/D-/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE6/RXD1/MISO/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREFA/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TDO/AC0OUT/AC7/ADC7/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='EVOUT/CLKOUT/SCK/TXD1/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PD7/TXD1/D+/SCK/CLKOUT/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE7/TXD1/SCK/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SDAIN/SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='OC0A/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PE0/OC0A/SDA/SDAIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PF0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PDI_DATA',do_erc=True),
            Pin(num='17',name='SCLIN/SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='XCK0/OC0B/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PE1/OC0B/XCK0/SCL/SCLIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF1/OC0B/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='18',name='SDAOUT/RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RXD0/OC0C/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE2/OC0C/RXD0/SDAOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PR0/XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='SCLOUT/TXD0/OC0BHS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TXD0/OC0D/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE3/OC0D/TXD0/SCLOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PR1/XTAL1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA128B1-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='TQFP100, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, JTAG, USB, LCD',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA64B1-AU'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='PC0/OC0A/~OC0ALS~/SDA/EXTCLKC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC1/OCOB/OC0AHS/XCK0/SCL/EXTCLKC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC2/OC0C/~OC0BLS~/RXD0/EXTCLKC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PC3/OC0D/OC0BHS/TXD0/EXTCLKC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PC4/OC1A/~OC0CLS~/~SS~/EXTCLKC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PC5/OC1B/OC0CHS/MOSI/EXTCLKC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC6/~OC0DLS~/MISO/RTCOUT/EXTCLKC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC7/OC0DHS/SCK/CLKP/EVOUT/EXTCLKC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='PE1/OC0B/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PG1/SEG38',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PM3/SEG28',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='SEG18',func=Pin.OUTPUT,do_erc=True),
            Pin(num='60',name='SEG8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='70',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='80',name='PR0/XTAL2/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='PE2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PG2/SEG37',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PM4/SEG27',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='SEG17',func=Pin.OUTPUT,do_erc=True),
            Pin(num='61',name='SEG7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='71',name='BIAS1',do_erc=True),
            Pin(num='81',name='PR1/XTAL1/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='PD0/D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PE3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PG3/SEG36',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PM5/SEG26',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='SEG16',func=Pin.OUTPUT,do_erc=True),
            Pin(num='62',name='SEG6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='72',name='BIAS2',do_erc=True),
            Pin(num='82',name='PA0/ADC0/ADC8/AC0/AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='PB0/ADC8/ADC0/AC0/AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PD1/D+',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG4/SEG35',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PM6/SEG25',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='SEG15',func=Pin.OUTPUT,do_erc=True),
            Pin(num='63',name='SEG5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='73',name='VLCD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='83',name='PA1/ADC1/ADC9/AC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='PB1/ADC9/ADC1/AC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PE5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG5/SEG34',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PM7/SEG24',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='SEG14',func=Pin.OUTPUT,do_erc=True),
            Pin(num='64',name='SEG4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='74',name='CAPL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='84',name='PA2/ADC2/ADC10/AC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='PB2/ADC10/ADC2/AC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='25',name='PE6/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PG6/SEG33',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='SEG23',func=Pin.OUTPUT,do_erc=True),
            Pin(num='55',name='SEG13',func=Pin.OUTPUT,do_erc=True),
            Pin(num='65',name='SEG3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='75',name='CAPH',func=Pin.OUTPUT,do_erc=True),
            Pin(num='85',name='PA3/ADC3/ADC11/AC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='PB3/ADC11/ADC3/AC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PDI_DAT',do_erc=True),
            Pin(num='26',name='PE7/TOSC1/CLKP/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PG7/SEG32',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SEG22',func=Pin.OUTPUT,do_erc=True),
            Pin(num='56',name='SEG12',func=Pin.OUTPUT,do_erc=True),
            Pin(num='66',name='SEG2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='76',name='COM0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='86',name='PA4/ADC4/ADC12/AC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='PB4/ADC12/ADC4/AC4/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='PM0/SEG31',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='SEG21',func=Pin.OUTPUT,do_erc=True),
            Pin(num='57',name='SEG11',func=Pin.OUTPUT,do_erc=True),
            Pin(num='67',name='BLINK/SEG1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='77',name='COM1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='87',name='PA5/ADC5/ADC13/AC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='PB5/ADC13/ADC5/AC5/TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='PM1/SEG30',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='SEG20',func=Pin.OUTPUT,do_erc=True),
            Pin(num='58',name='SEG10',func=Pin.OUTPUT,do_erc=True),
            Pin(num='68',name='BLINK/SEG0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='78',name='COM2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='88',name='PA6/ADC6/ADC14/AC6/AC1OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PB6/ADC14/ADC6/AC6/AC1OUT/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PE0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PG0/SEG39',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PM2/SEG29',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SEG19',func=Pin.OUTPUT,do_erc=True),
            Pin(num='59',name='SEG9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='69',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='79',name='COM3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='89',name='PA7/ADC7/ADC15/AC7/AC0OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='PB7/ADC15/ADC7/AC7/AC0OUT/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATXMEGA128B3-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='TQFP64, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, JTAG, USB, LCD',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA64B3-AU'],pins=[
            Pin(num='1',name='PC0/OC0A/~OC0ALS~/SDA/EXTCLKC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC1/OC0B/OC0AHS/XCK0/SCL/EXTCLKC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC2/OC0C/~OC0BLS~/RXD0/EXTCLKC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC3/OC0D/OC0BHS/TXD0/EXTCLKC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PC4/OC1A/~OC0CLS~/~SS~/EXTCLKC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PC5/OC1B/OC0CHS/MOSI/EXTCLKC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PC6/~OCODLS~/MISO/EXTCLKC6/RTCOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC7/OC0DHS/SCK/EXTCLKC7/CLKP/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='PG3/SEG21',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PM5/SEG11',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='BLINK/SEG1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='COM1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='60',name='PB3/ADC11/ADC3/AC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PD0/D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PG4/SEG20',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PM6/SEG10',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='BLINK/SEG0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='51',name='COM2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='61',name='PB4/ADC12/ADC4/AC4/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PD1/D+',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PG5/SEG19',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PM7/SEG9',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='COM3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='62',name='PB5/ADC13/ADC5/AC5/TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='23',name='PG6/SEG18',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SEG8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='43',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='53',name='PR0/XTAL2/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PB6/ADC14/ADC6/AC6/AC1OUT/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PDI_DATA',do_erc=True),
            Pin(num='24',name='PG7/SEG17',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SEG7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='44',name='BIAS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='PR1/XTAL1/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='PB7/ADC15/ADC7/AC7/AC0OUT/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='PM0/SEG16',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SEG6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='BIAS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='PM1/SEG15',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='SEG5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='VLCD',func=Pin.PWRIN,do_erc=True),
            Pin(num='56',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='PG0/SEG24',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PM2/SEG14',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SEG4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='CAPL',func=Pin.PWRIN,do_erc=True),
            Pin(num='57',name='PB0/ADC8/ADC0/AC0/AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG1/SEG23',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PM3/SEG13',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='SEG3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='CAPH',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PB1/ADC9/ADC1/AC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PG2/SEG22',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PM4/SEG12',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='SEG2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='49',name='COM0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='59',name='PB2/ADC10/ADC2/AC2',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA128B3-MH',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='QFN64, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, JTAG, USB, LCD',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA64B3-MH'],pins=[
            Pin(num='1',name='PC0/OC0A/~OC0ALS~/SDA/EXTCLKC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC1/OC0B/OC0AHS/XCK0/SCL/EXTCLKC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC2/OC0C/~OC0BLS~/RXD0/EXTCLKC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC3/OC0D/OC0BHS/TXD0/EXTCLKC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PC4/OC1A/~OC0CLS~/~SS~/EXTCLKC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PC5/OC1B/OC0CHS/MOSI/EXTCLKC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PC6/~OCODLS~/MISO/EXTCLKC6/RTCOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC7/OC0DHS/SCK/EXTCLKC7/CLKP/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='PG3/SEG21',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PM5/SEG11',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='BLINK/SEG1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='COM1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='60',name='PB3/ADC11/ADC3/AC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PD0/D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PG4/SEG20',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PM6/SEG10',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='BLINK/SEG0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='51',name='COM2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='61',name='PB4/ADC12/ADC4/AC4/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PD1/D+',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PG5/SEG19',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PM7/SEG9',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='COM3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='62',name='PB5/ADC13/ADC5/AC5/TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='23',name='PG6/SEG18',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SEG8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='43',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='53',name='PR0/XTAL2/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PB6/ADC14/ADC6/AC6/AC1OUT/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PDI_DATA',do_erc=True),
            Pin(num='24',name='PG7/SEG17',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SEG7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='44',name='BIAS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='PR1/XTAL1/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='PB7/ADC15/ADC7/AC7/AC0OUT/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='PM0/SEG16',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SEG6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='BIAS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='PM1/SEG15',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='SEG5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='VLCD',func=Pin.PWRIN,do_erc=True),
            Pin(num='56',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='PG0/SEG24',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PM2/SEG14',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SEG4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='CAPL',func=Pin.PWRIN,do_erc=True),
            Pin(num='57',name='PB0/ADC8/ADC0/AC0/AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG1/SEG23',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PM3/SEG13',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='SEG3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='CAPH',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PB1/ADC9/ADC1/AC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PG2/SEG22',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PM4/SEG12',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='SEG2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='49',name='COM0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='59',name='PB2/ADC10/ADC2/AC2',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA128C3-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='TQFP64, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, JTAG, USB',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA64C3-AU', 'ATXMEGA192C3-AU', 'ATXMEGA256C3-AU'],pins=[
            Pin(num='1',name='AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AC1OUT/AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AREFB/ADC8/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC9/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC10/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC11/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC12/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PD4/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF4',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='ADC13/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='MOSI/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PD5/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE5',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PF5',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='ADC14/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RTCOUT/MISO/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PD6/MISO/D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE6/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREFA/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC15/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='EVOUT/CLKP/SCK/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PD7/SCK/D+/CLKP/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE7/TOSC1/CLKP/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='OC0A/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PE0/OC0A/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PF0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PDI_DATA',do_erc=True),
            Pin(num='17',name='SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='XCK0/OC0B/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PE1/OC0B/XCK0/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF1/OC0B',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='18',name='RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RXD0/OC0C/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF2/OC0C',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PR0/XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TXD0/OCB0HS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TXD0/OC0D/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF3/OC0D',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PR1/XTAL1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA128C3-MH',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='QFN64, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, JTAG, USB',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA64C3-MH', 'ATXMEGA192C3-MH', 'ATXMEGA256C3-MH'],pins=[
            Pin(num='1',name='AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AC1OUT/AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AREFB/ADC8/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC9/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC10/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC11/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC12/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PD4/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF4',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='ADC13/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='MOSI/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PD5/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE5',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PF5',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='ADC14/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RTCOUT/MISO/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PD6/MISO/D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE6/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREFA/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC15/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='EVOUT/CLKP/SCK/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PD7/SCK/D+/CLKP/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE7/TOSC1/CLKP/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='OC0A/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PE0/OC0A/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PF0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PDI_DATA',do_erc=True),
            Pin(num='17',name='SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='XCK0/OC0B/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PE1/OC0B/XCK0/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF1/OC0B',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='18',name='RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RXD0/OC0C/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF2/OC0C',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PR0/XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TXD0/OCB0HS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TXD0/OC0D/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF3/OC0D',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PR1/XTAL1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA128D3-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='TQFP64, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA64D3-AU', 'ATXMEGA192D3-AU', 'ATXMEGA256D3-AU'],pins=[
            Pin(num='1',name='AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AC1OUT/AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AREFB/ADC8/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC9/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC10/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC11/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC12/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PD4/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF4',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='ADC13/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='MOSI/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PD5/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE5',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PF5',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='ADC14/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RTCOUT/MISO/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PD6/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE6/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREFA/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC15/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='EVOUT/CLKP/SCK/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PD7/SCK/CLKP/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE7/TOSC1/CLKP/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='OC0A/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PE0/OC0A/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PF0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PDI_DATA',do_erc=True),
            Pin(num='17',name='SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='XCK0/OC0B/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PE1/OC0B/XCK0/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF1/OC0B',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='18',name='RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RXD0/OC0C/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF2/OC0C',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PR0/XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TXD0/OC0BHS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TXD0/OC0D/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF3/OCOD',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PR1/XTAL1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA128D3-MH',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='QFN64, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA64D3-MH', 'ATXMEGA192D3-MH', 'ATXMEGA256D3-MH'],pins=[
            Pin(num='1',name='AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AC1OUT/AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AREFB/ADC8/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC9/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC10/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC11/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC12/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PD4/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF4',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='ADC13/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='MOSI/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PD5/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE5',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PF5',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='ADC14/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RTCOUT/MISO/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PD6/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE6/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREFA/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC15/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='EVOUT/CLKP/SCK/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PD7/SCK/CLKP/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE7/TOSC1/CLKP/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='OC0A/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PE0/OC0A/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PF0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PDI_DATA',do_erc=True),
            Pin(num='17',name='SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='XCK0/OC0B/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PE1/OC0B/XCK0/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF1/OC0B',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='18',name='RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RXD0/OC0C/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF2/OC0C',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PR0/XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TXD0/OC0BHS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TXD0/OC0D/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF3/OCOD',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PR1/XTAL1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA16A4-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='TQFP44, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA32A4-AU', 'ATXMEGA64A4-AU', 'ATXMEGA128A4-AU'],pins=[
            Pin(num='1',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AREFB/ADC8/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC9/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='DAC0/ADC10/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='DAC1/ACD11/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PD0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='AREFA/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PD1/OC0B/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PD2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PE2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TXD0/OC0BHS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PD3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PE3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PD4/OC1A/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PDI_DATA',do_erc=True),
            Pin(num='44',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='MOSI/XCK1/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PD5/OC1B/XCK1/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='16',name='MISO/RXD1/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PD6/RXD1/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PR0/XTAL2/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='EVOUT/CLKOUT/SCK/TXD1/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PD7/TXD1/SCK/CLKOUT/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PR1/XTAL1/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='PE0/OC0A/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='PE1/OC0B/XCK0/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='AVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATXMEGA16A4-MH',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='VQFN44, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA32A4-MH', 'ATXMEGA64A4-MH', 'ATXMEGA128A4-MH'],pins=[
            Pin(num='1',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AREFB/ADC8/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC9/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='DAC0/ADC10/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='DAC1/ACD11/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PD0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='AREFA/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PD1/OC0B/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PD2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PE2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TXD0/OC0BHS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PD3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PE3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PD4/OC1A/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PDI_DATA',do_erc=True),
            Pin(num='44',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='MOSI/XCK1/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PD5/OC1B/XCK1/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='16',name='MISO/RXD1/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PD6/RXD1/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PR0/XTAL2/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='EVOUT/CLKOUT/SCK/TXD1/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PD7/TXD1/SCK/CLKOUT/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PR1/XTAL1/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='PE0/OC0A/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='PE1/OC0B/XCK0/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='AVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATXMEGA16A4U-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='TQFP44, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, JTAG, USB',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA32A4U-AU', 'ATXMEGA64A4U-AU', 'ATXMEGA128A4U-AU'],pins=[
            Pin(num='1',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC1OUT/AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AREFB/ADC8/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC9/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='DAC0/ADC10/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='DAC1/ACD11/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='SDAIN/SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PD0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='AREFA/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='SCLIN/SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PD1/OC0B/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='SDAOUT/RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PD2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PE2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SCLOUT/TXD0/OC0BHS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PD3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PE3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PD4/OC1A/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PDI_DATA',do_erc=True),
            Pin(num='44',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='MOSI/XCK1/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PD5/OC1B/XCK1/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='16',name='CLKRTC/MISO/RXD1/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PD6/D-/RXD1/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PR0/XTAL2/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='EVOUT/CLKOUT/SCK/TXD1/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PD7/D+/TXD1/SCK/CLKOUT/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PR1/XTAL1/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='PE0/OC0A/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='PE1/OC0B/XCK0/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='AVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATXMEGA16A4U-MH',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='QFN44, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, JTAG, USB',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA32A4U-MH', 'ATXMEGA64A4U-MH', 'ATXMEGA128A4U-MH'],pins=[
            Pin(num='1',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC1OUT/AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AREFB/ADC8/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC9/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='DAC0/ADC10/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='DAC1/ACD11/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='SDAIN/SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PD0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='AREFA/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='SCLIN/SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PD1/OC0B/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='SDAOUT/RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PD2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PE2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SCLOUT/TXD0/OC0BHS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PD3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PE3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PD4/OC1A/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PDI_DATA',do_erc=True),
            Pin(num='44',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='MOSI/XCK1/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PD5/OC1B/XCK1/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='16',name='CLKRTC/MISO/RXD1/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PD6/D-/RXD1/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PR0/XTAL2/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='EVOUT/CLKOUT/SCK/TXD1/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PD7/D+/TXD1/SCK/CLKOUT/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PR1/XTAL1/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='PE0/OC0A/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='PE1/OC0B/XCK0/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='AVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATXMEGA16C4-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='TQFP44, 32k Flash, 4k Boot, 4k SRAM, 1k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA32C4-AU'],pins=[
            Pin(num='1',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC1OUT/AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AREFB/ADC8/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC9/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='ADC10/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC11/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='RXD0/~OC0ALS~/OC0C/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PD0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='AREFA/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='TXD0/OC0AHS/OC0D/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PD1/OC0B/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='~SS~/~OC0BLS~/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PD2/OC0B/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PE2/OC0C/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='MOSI/XCK1/OC0BHS/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PD3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PE3/OC0D/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RTCOUT/MISO/RXD2/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PD4/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PDI_DATA',do_erc=True),
            Pin(num='44',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PD5/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='16',name='~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PD6/MISO/D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PR0/XTAL1/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='EVOUT/CLKP/SCK/TXD3/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PD7/SCK/D+/CLKP/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PR1/XTAL2/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='PE0/OC0A/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='PE1/OC0B/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='AVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATXMEGA16C4-MH',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='VQFN44, 32k Flash, 4k Boot, 4k SRAM, 1k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA32C4-MH'],pins=[
            Pin(num='1',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC1OUT/AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AREFB/ADC8/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC9/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='ADC10/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC11/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='RXD0/~OC0ALS~/OC0C/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PD0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='AREFA/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='TXD0/OC0AHS/OC0D/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PD1/OC0B/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='~SS~/~OC0BLS~/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PD2/OC0B/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PE2/OC0C/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='MOSI/XCK1/OC0BHS/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PD3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PE3/OC0D/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RTCOUT/MISO/RXD2/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PD4/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PDI_DATA',do_erc=True),
            Pin(num='44',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PD5/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='16',name='~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PD6/MISO/D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PR0/XTAL1/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='EVOUT/CLKP/SCK/TXD3/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PD7/SCK/D+/CLKP/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PR1/XTAL2/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='PE0/OC0A/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='PE1/OC0B/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='AVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATXMEGA16D4-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='TQFP44, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA32D4-AU', 'ATXMEGA64D4-AU', 'ATXMEGA128D4-AU'],pins=[
            Pin(num='1',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AREF/ADC8/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC9/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='ADC10/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC11/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PD0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='AREF/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PD1/OC0B/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PD2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PE2/OC0C',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TXD0/OC0BHS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PD3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PE3/OC0D',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PD4/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PDI_DATA',do_erc=True),
            Pin(num='44',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='MOSI/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PD5/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='16',name='CLKRTC/MISO/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PD6/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PR0/XTAL2/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='EVOUT/CLKP/SCK/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PD7/SCK/CLKP/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PR1/XTAL1/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='PE0/OC0A/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='PE1/OC0B/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='AVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATXMEGA16D4-MH',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='VQFN44, 64k Flash, 4k Boot, 4k SRAM, 2k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,aliases=['ATXMEGA32D4-MH', 'ATXMEGA64D4-MH', 'ATXMEGA128D4-MH'],pins=[
            Pin(num='1',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AREF/ADC8/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC9/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='ADC10/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC11/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PD0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='AREF/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PD1/OC0B/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PD2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PE2/OC0C',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TXD0/OC0BHS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PD3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PE3/OC0D',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PD4/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PDI_DATA',do_erc=True),
            Pin(num='44',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='MOSI/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PD5/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='16',name='CLKRTC/MISO/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PD6/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PR0/XTAL2/TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='EVOUT/CLKP/SCK/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PD7/SCK/CLKP/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PR1/XTAL1/TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='PE0/OC0A/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='PE1/OC0B/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='AVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ATXMEGA256A3B-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='TQFP64, 256k Flash, 8k Boot, 16k SRAM, 4k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AREF/AC0/ADC0/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AC1/ADC1/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DAC0/AC2/ADC2/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='DAC1/AC3/ADC3/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TMS/AC4/ADC4/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='~SS~/OC1A/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE4/OC1A',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF4/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='TDI/AC5/ADC5/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='MOSI/XCK1/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='MOSI/XCK1/OC1B/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE5/OC1B',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='VBAT',do_erc=True),
            Pin(num='61',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='TCK/AC6/ADC6/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='MISO/RXD1/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='MISO/RXD1/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TDO/AC0OUT/AC7/ADC7/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='EVOUT/CLKP/SCK/TXD1/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='EVOUT/CLKP/SCK/TXD1/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SDAIN/SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='OC0A/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PE0/OC0A/SDA/SDAIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PF0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PDI_DATA',do_erc=True),
            Pin(num='17',name='SCLIN/SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='XCK0/OC0B/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PE1/OC0B/XCK0/SCL/SCLIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF1/OC0B/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='18',name='SDAOUT/RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RXD0/OC0C/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE2/OC0C/RXD0/SDAOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PR0/XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='SCLOUT/TXD0/OC0BHS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TXD0/OC0D/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE3/OC0D/TXD0/SCLOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PR1/XTAL1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA256A3B-MH',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='MLF/QFN64, 256k Flash, 8k Boot, 16k SRAM, 4k EEPROM, JTAG',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AREF/AC0/ADC0/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AC1/ADC1/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DAC0/AC2/ADC2/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='DAC1/AC3/ADC3/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TMS/AC4/ADC4/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='~SS~/OC1A/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE4/OC1A',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF4/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='TDI/AC5/ADC5/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='MOSI/XCK1/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='MOSI/XCK1/OC1B/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE5/OC1B',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='VBAT',do_erc=True),
            Pin(num='61',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='TCK/AC6/ADC6/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='MISO/RXD1/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='MISO/RXD1/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TDO/AC0OUT/AC7/ADC7/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='EVOUT/CLKP/SCK/TXD1/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='EVOUT/CLKP/SCK/TXD1/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SDAIN/SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='OC0A/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PE0/OC0A/SDA/SDAIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PF0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PDI_DATA',do_erc=True),
            Pin(num='17',name='SCLIN/SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='XCK0/OC0B/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PE1/OC0B/XCK0/SCL/SCLIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF1/OC0B/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='18',name='SDAOUT/RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RXD0/OC0C/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE2/OC0C/RXD0/SDAOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PR0/XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='SCLOUT/TXD0/OC0BHS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TXD0/OC0D/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE3/OC0D/TXD0/SCLOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PR1/XTAL1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA256A3BU-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='TQFP64, 256k Flash, 8k Boot, 16k SRAM, 4k EEPROM, JTAG, USB',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='AC3/ADC11/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC4/ADC12/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC5/ADC13/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AC1OUT/AC6/ADC14/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AC0OUT/AC7/ADC15/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AREF/AC0/ADC0/ADC8/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AC1/ADC1/ADC9/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DAC0/AC2/ADC2/ADC10/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='DAC1/AC3/ADC3/ADC11/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TMS/AC4/ADC4/ADC12/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='~SS~/OC1A/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE4/OC1A',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF4',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='TDI/AC5/ADC5/ADC13/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='MOSI/XCK1/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='MOSI/XCK1/OC1B/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE5/OC1B',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='VBAT',do_erc=True),
            Pin(num='61',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='TCK/AC1OUT/AC6/ADC6/ADC14/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='MISO/RXD1/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='MISO/RXD1/D-/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF/AC0/ADC8/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TDO/AC0OUT/AC7/ADC7/ADC15/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='EVOUT/CLKP/SCK/TXD1/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='EVOUT/CLKP/SCK/TXD1/D+/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AC1/ADC9/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AC2/ADC10/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='OC0A/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PE0/OC0A/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PF0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PDI_DATA',do_erc=True),
            Pin(num='17',name='SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='XCK0/OC0B/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PE1/OC0B/XCK0/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF1/OC0B/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='18',name='SDAOUT/RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RXD0/OC0C/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PR0/XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='SCLOUT/TXD0/OC0BHS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TXD0/OC0D/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PR1/XTAL1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA256A3BU-MH',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='QFN64, 256k Flash, 8k Boot, 16k SRAM, 4k EEPROM, JTAG, USB',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='AC3/ADC11/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AC4/ADC12/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AC5/ADC13/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AC1OUT/AC6/ADC14/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AC0OUT/AC7/ADC15/ADC7/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AREF/AC0/ADC0/ADC8/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AC1/ADC1/ADC9/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DAC0/AC2/ADC2/ADC10/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='DAC1/AC3/ADC3/ADC11/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TMS/AC4/ADC4/ADC12/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~SS~/~OC0CLS~/OC1A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='~SS~/OC1A/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE4/OC1A',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF4',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='TDI/AC5/ADC5/ADC13/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='MOSI/XCK1/OC0CHS/OC1B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='MOSI/XCK1/OC1B/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE5/OC1B',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='VBAT',do_erc=True),
            Pin(num='61',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='TCK/AC1OUT/AC6/ADC6/ADC14/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='MISO/RXD1/~OC0DLS~/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='MISO/RXD1/D-/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='TOSC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='AREF/AC0/ADC8/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TDO/AC0OUT/AC7/ADC7/ADC15/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='EVOUT/CLKP/SCK/TXD1/OC0DHS/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='EVOUT/CLKP/SCK/TXD1/D+/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TOSC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='AC1/ADC9/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='AC2/ADC10/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SDA/~OC0ALS~/OC0A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='OC0A/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PE0/OC0A/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PF0/OC0A',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PDI_DATA',do_erc=True),
            Pin(num='17',name='SCL/XCK0/OC0AHS/OC0B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='XCK0/OC0B/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PE1/OC0B/XCK0/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF1/OC0B/XCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='18',name='SDAOUT/RXD0/~OC0BLS~/OC0C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RXD0/OC0C/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF2/OC0C/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PR0/XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='SCLOUT/TXD0/OC0BHS/OC0D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TXD0/OC0D/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF3/OC0D/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PR1/XTAL1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA8E5-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='TQFP32, 8k Flash, 2k Boot, 1k SRAM, 512B EEPROM',ref_prefix='U',num_units=1,fplist=['TQFP*'],do_erc=True,aliases=['ATXMEGA16E5-AU', 'ATXMEGA32E5-AU'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='DAC1/AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='DAC0/AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AREF/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PDI_DATA',do_erc=True),
            Pin(num='8',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='9',name='AC0OUT/IN3/MOSI/TXD0/OC4DHS/OC4D/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AC1OUT/IN0/MISO/RXD0/~OC4DLS~/OC4C/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PR0/XTAL2/TOSC2/CLKOUT/EVOUT/RTCOUT/AC1OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AC1OUT/AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='IN2/SCK/XCK0/OC5B/OC4CHS/OC4B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PD7/ADC15/TXD0/IN3/CLKOUT/EVOUT/AC0OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='EXTCLK/OUT0/IN1/~SS~/OC5A/~OC4CLS~/OC4A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PD6/ADC14/RXD0/IN0/RTCOUT/AC1OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='IN3/TXD0/OC4BHS/OC4D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PD5/ADC13/OC5B/XCK0/IN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='IN0/RXD0/~OC4BLS~/OC4C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PD4/ADC12/OC5A/IN1/OUT0/CLKOUT/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='IN2/SCL/XCK0/OC4AHS/OC4B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PD3/ADC11/TXD0/IN3/OC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='OUT0/IN1/SDA/~OC4ALS~/OC4A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PD2/ADC10/RXD0/IN0/OC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='PD1/ADC1/XCK0/SCL/IN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='PD0/ADC8/SDA/IN1/OUT0/AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PR1/XTAL1/TOSC1/EXTCLK/AC0OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA8E5-M4U',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='UQFN32, 8k Flash, 2k Boot, 1k SRAM, 512B EEPROM',ref_prefix='U',num_units=1,fplist=['UQFN*'],do_erc=True,aliases=['ATXMEGA16E5-M4U', 'ATXMEGA32E5-M4U'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='DAC1/AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='DAC0/AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AREF/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PDI_DATA',do_erc=True),
            Pin(num='8',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='9',name='AC0OUT/IN3/MOSI/TXD0/OC4DHS/OC4D/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AC1OUT/IN0/MISO/RXD0/~OC4DLS~/OC4C/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PR0/XTAL2/TOSC2/CLKOUT/EVOUT/RTCOUT/AC1OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AC1OUT/AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='IN2/SCK/XCK0/OC5B/OC4CHS/OC4B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PD7/ADC15/TXD0/IN3/CLKOUT/EVOUT/AC0OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='EXTCLK/OUT0/IN1/~SS~/OC5A/~OC4CLS~/OC4A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PD6/ADC14/RXD0/IN0/RTCOUT/AC1OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='IN3/TXD0/OC4BHS/OC4D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PD5/ADC13/OC5B/XCK0/IN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='IN0/RXD0/~OC4BLS~/OC4C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PD4/ADC12/OC5A/IN1/OUT0/CLKOUT/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='IN2/SCL/XCK0/OC4AHS/OC4B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PD3/ADC11/TXD0/IN3/OC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='OUT0/IN1/SDA/~OC4ALS~/OC4A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PD2/ADC10/RXD0/IN0/OC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='PD1/ADC1/XCK0/SCL/IN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='PD0/ADC8/SDA/IN1/OUT0/AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PR1/XTAL1/TOSC1/EXTCLK/AC0OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATXMEGA8E5-MU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8/16bit Microcontroller XMegaAVR',description='VQFN32, 8k Flash, 2k Boot, 1k SRAM, 512B EEPROM',ref_prefix='U',num_units=1,fplist=['VQFN*'],do_erc=True,aliases=['ATXMEGA16E5-MU', 'ATXMEGA32E5-MU'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='AC4/ADC4/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='DAC1/AC3/ADC3/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='DAC0/AC2/ADC2/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AC1/ADC1/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AREF/AC0/ADC0/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PDI_DATA',do_erc=True),
            Pin(num='8',name='~RESET~/PDI_CLK',do_erc=True),
            Pin(num='9',name='AC0OUT/IN3/MOSI/TXD0/OC4DHS/OC4D/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AC1OUT/IN0/MISO/RXD0/~OC4DLS~/OC4C/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PR0/XTAL2/TOSC2/CLKOUT/EVOUT/RTCOUT/AC1OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AC1OUT/AC6/ADC6/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='IN2/SCK/XCK0/OC5B/OC4CHS/OC4B/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PD7/ADC15/TXD0/IN3/CLKOUT/EVOUT/AC0OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='AC5/ADC5/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='EXTCLK/OUT0/IN1/~SS~/OC5A/~OC4CLS~/OC4A/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PD6/ADC14/RXD0/IN0/RTCOUT/AC1OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='IN3/TXD0/OC4BHS/OC4D/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PD5/ADC13/OC5B/XCK0/IN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='IN0/RXD0/~OC4BLS~/OC4C/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PD4/ADC12/OC5A/IN1/OUT0/CLKOUT/EVOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='IN2/SCL/XCK0/OC4AHS/OC4B/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PD3/ADC11/TXD0/IN3/OC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='OUT0/IN1/SDA/~OC4ALS~/OC4A/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PD2/ADC10/RXD0/IN0/OC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='PD1/ADC1/XCK0/SCL/IN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='PD0/ADC8/SDA/IN1/OUT0/AREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PR1/XTAL1/TOSC1/EXTCLK/AC0OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AC0OUT/AC7/ADC7/PA7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ATmega32U4',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='ATmega32U4-AU',dest=TEMPLATE,tool=SKIDL,keywords='AVR 8bit Microcontroller MegaAVR USB',description='TQFP44, 32K Flash, 2.5K SRAM, 1K EEPROM, USB2.0',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='(INT6/AIN0)PE6',do_erc=True),
            Pin(num='2',name='UVCC',do_erc=True),
            Pin(num='3',name='D-',do_erc=True),
            Pin(num='4',name='D+',do_erc=True),
            Pin(num='5',name='UGND',do_erc=True),
            Pin(num='6',name='UCAP',do_erc=True),
            Pin(num='7',name='VBUS',do_erc=True),
            Pin(num='8',name='(SS/PCINT0)PB0',do_erc=True),
            Pin(num='9',name='(SCLK/PCINT1)PB1',do_erc=True),
            Pin(num='10',name='(PDI/MOSI/PCINT2)PB2',do_erc=True),
            Pin(num='20',name='(RXD/INT2)PD2',do_erc=True),
            Pin(num='30',name='(ADC13/OC1B/OC4B/PCINT13)PB6',do_erc=True),
            Pin(num='40',name='(ADC1)PF1',do_erc=True),
            Pin(num='11',name='(PDO/MISO/PCINT3)PB3',do_erc=True),
            Pin(num='21',name='(TXD/INT3)PD3',do_erc=True),
            Pin(num='31',name='(OC3A/~OC4A~)PC6',do_erc=True),
            Pin(num='41',name='(ADC0)PF0',do_erc=True),
            Pin(num='12',name='(OC0A/OC1C/~RTS~/PCINT7)PB7',do_erc=True),
            Pin(num='22',name='(XCK1/~CTS~)PD5',do_erc=True),
            Pin(num='32',name='(ICP3/CLK0/OC4A)PC7',do_erc=True),
            Pin(num='42',name='AREF',do_erc=True),
            Pin(num='13',name='RESET',do_erc=True),
            Pin(num='23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='(~HWB~)PE2',do_erc=True),
            Pin(num='43',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='(ICP2/ADC8)PD4',do_erc=True),
            Pin(num='35',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='XTAL2',do_erc=True),
            Pin(num='26',name='(T1/~OC4D~/ADC9)PD6',do_erc=True),
            Pin(num='36',name='(ADC7/TDI)PF7',do_erc=True),
            Pin(num='17',name='XTAL1',do_erc=True),
            Pin(num='27',name='(T0/OC4D/ADC10)PD7',do_erc=True),
            Pin(num='37',name='(ADC6/TDO)PF6',do_erc=True),
            Pin(num='18',name='(OC0B/SCL/INT0)PD0',do_erc=True),
            Pin(num='28',name='(ADC11/PCINT4)PB4',do_erc=True),
            Pin(num='38',name='(ADC5/TMS)PF5',do_erc=True),
            Pin(num='19',name='(SDA/INT1)PD1',do_erc=True),
            Pin(num='29',name='(ADC12/OC1A/~OC4B~/PCINT12)PB5',do_erc=True),
            Pin(num='39',name='(ADC4/TCK)PF4',do_erc=True)]),
        Part(name='AVR-ISP-10',dest=TEMPLATE,tool=SKIDL,keywords='IDC10 Male Connector',description='Standard IDC10 Male Connector, ISP Kanda (STK200/300)',ref_prefix='CON',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='AVR-ISP-6',dest=TEMPLATE,tool=SKIDL,keywords='IDC6 Male Connector',description='Standard IDC6 Male Connector, ATMEL ISP 6pin',ref_prefix='CON',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='AVR-JTAG-10',dest=TEMPLATE,tool=SKIDL,keywords='IDC10 Male Connector',description='Standard IDC10 Male Connector, ATMEL JTAG ICE mkI/mkII',ref_prefix='CON',num_units=1,fplist=['AVR-JTAG-10'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='AVR-PUDI-6',dest=TEMPLATE,tool=SKIDL,keywords='IDC6 Male Connector',description='Standard IDC6 Male Connector, ATMEL PDI 6pin',ref_prefix='CON',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='AVR-TPI-6',dest=TEMPLATE,tool=SKIDL,keywords='IDC6 Male Connector',description='Standard IDC6 Male Connector, ATMEL TPI 6pin',ref_prefix='CON',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SAMD20E14A-AU',dest=TEMPLATE,tool=SKIDL,keywords='ARM 32bit Microcontroller 48MHz CortexM0+',description='TQFP32, 128K Flash, 16K RAM, 48MHz, CortexM0+',ref_prefix='U',num_units=1,fplist=['TQFP32'],do_erc=True,aliases=['SAMD20E15A-AU', 'SAMD20E16A-AU', 'SAMD20E17A-AU'],pins=[
            Pin(num='1',name='XIN32/TC2WO0/SERCOM1P0/PA00',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='XOUT32/TC2WO1/SERCOM1P1/PA01',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='VOUT/Y0/AIN0/PA02',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Y1/AIN1/VREFA/VREFP/PA03',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='TC0WO0/SERCOM0P0/Y2/AIN0/AIN4/VREFB/PA04',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TC0W01/SERCOM0P1/Y3/AIN1/AIN5/PA05',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TC1WO0/SERCOM0P2/Y4/AIN2/AIN6/PA06',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TC1WO1/SERCOM0P3/Y5/AIN3/AIN7/PA07',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='VDDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='ACCMP1/TC3WO1/SERCOM3P3/SERCOM1P3/X7/PA19',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='VDDIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='TC0WO0/SERCOM2P0/SERCOM0P0/X0/AIN16/NMI/PA08',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GCLKIO6/TC4WO0/SERCOM5P0/SERCOM3P0/X10/PA22',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='GCLKIO0/SWCLK/TC1WO0/SERCOM1P2/PA30',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='TC0WO1/SERCOM2P1/SERCOM0P1/X1/AIN17/PA09',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GCLKIO7/TC4WO1/SERCOM5P1/SERCOM3P1/X11/PA23',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='SWDIO/TC1WO1/SERCOM1P3/PA31',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='GCLKIO4/TC1WO0/SERCOM2P2/SERCOM0P2/X2/AIN18/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TC5WO0/SERCOM5P2/SERCOM3P2/PA24',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GCLKIO5/TC1WO1/SERCOM2P3/SERCOM0P3/X3/AIN19/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='TC5WO1/SERCOM5P3/SERCOM3P3/PA25',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='XIN/GCLKIO0/TC3WO0/SERCOM4P2/SERCOM2P2/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='GCLKIO0/PA27',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='XOUT/GCLKIO1/TC3WO1/SERCOM4P3/SERCOM2P3/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='~RESET~',do_erc=True),
            Pin(num='17',name='GCLKIO2/TC2WO0/SERCOM3P0/SERCOM1P0/X4/PA16',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='GCLKIO0/PA28',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GCLKIO3/TC2WO1/SERCOM3P1/SERCOM1P1/X5/PA17',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='ACCMP0/TC3WO0/SERCOM3P2/SERCOM1P2/X6/PA18',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDDCORE',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SAMD20E14A-MU',dest=TEMPLATE,tool=SKIDL,keywords='ARM 32bit Microcontroller 48MHz CortexM0+',description='QFN32, 128K Flash, 16K RAM, 48MHz, CortexM0+',ref_prefix='U',num_units=1,fplist=['QFN32'],do_erc=True,aliases=['SAMD20E15A-MU', 'SAMD20E16A-MU', 'SAMD20E17A-MU'],pins=[
            Pin(num='1',name='XIN32/TC2WO0/SERCOM1P0/PA00',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='XOUT32/TC2WO1/SERCOM1P1/PA01',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='VOUT/Y0/AIN0/PA02',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Y1/AIN1/VREFA/VREFP/PA03',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='TC0WO0/SERCOM0P0/Y2/AIN0/AIN4/VREFB/PA04',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TC0W01/SERCOM0P1/Y3/AIN1/AIN5/PA05',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TC1WO0/SERCOM0P2/Y4/AIN2/AIN6/PA06',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TC1WO1/SERCOM0P3/Y5/AIN3/AIN7/PA07',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='VDDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='ACCMP1/TC3WO1/SERCOM3P3/SERCOM1P3/X7/PA19',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='VDDIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='TC0WO0/SERCOM2P0/SERCOM0P0/X0/AIN16/NMI/PA08',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GCLKIO6/TC4WO0/SERCOM5P0/SERCOM3P0/X10/PA22',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='GCLKIO0/SWCLK/TC1WO0/SERCOM1P2/PA30',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='TC0WO1/SERCOM2P1/SERCOM0P1/X1/AIN17/PA09',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GCLKIO7/TC4WO1/SERCOM5P1/SERCOM3P1/X11/PA23',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='SWDIO/TC1WO1/SERCOM1P3/PA31',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='GCLKIO4/TC1WO0/SERCOM2P2/SERCOM0P2/X2/AIN18/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TC5WO0/SERCOM5P2/SERCOM3P2/PA24',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GCLKIO5/TC1WO1/SERCOM2P3/SERCOM0P3/X3/AIN19/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='TC5WO1/SERCOM5P3/SERCOM3P3/PA25',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='XIN/GCLKIO0/TC3WO0/SERCOM4P2/SERCOM2P2/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='GCLKIO0/PA27',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='XOUT/GCLKIO1/TC3WO1/SERCOM4P3/SERCOM2P3/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='~RESET~',do_erc=True),
            Pin(num='17',name='GCLKIO2/TC2WO0/SERCOM3P0/SERCOM1P0/X4/PA16',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='GCLKIO0/PA28',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GCLKIO3/TC2WO1/SERCOM3P1/SERCOM1P1/X5/PA17',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='ACCMP0/TC3WO0/SERCOM3P2/SERCOM1P2/X6/PA18',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDDCORE',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SAMD20G14A-AU',dest=TEMPLATE,tool=SKIDL,keywords='ARM 32bit Microcontroller 48MHz CortexM0+',description='TQFP48, 256K Flash, 32K RAM, 48MHz, CortexM0+',ref_prefix='U',num_units=1,fplist=['TQFP48'],do_erc=True,aliases=['SAMD20G15A-AU', 'SAMD20G16A-AU', 'SAMD20G17A-AU', 'SAMD20G18A-AU'],pins=[
            Pin(num='1',name='XIN32/TC2WO0/SERCOM1P0/PA00',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='XOUT32/TC2WO1/SERCOM1P1/PA01',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='VOUT/Y0/AIN0/PA02',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Y1/AIN1/VREFA/VREFP/PA03',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='GNDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VDDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PB08/AIN2/Y14/SERCOM4P0/TC4WO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PB09/AIN3/Y15/SERCOM4P1/TC4WO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TC0WO0/SERCOM0P0/Y2/AIN0/AIN4/VREFB/PA04',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TC0W01/SERCOM0P1/Y3/AIN1/AIN5/PA05',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB11/SERCOM4P3/TC5WO1/GCLKIO5',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='GCLKIO5/TC7WO1/SERCOM3P3/SERCOM5P3/X9/PA21',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='~RESET~',do_erc=True),
            Pin(num='11',name='TC1WO0/SERCOM0P2/Y4/AIN2/AIN6/PA06',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ACCMP0/TC2WO0/SERCOM4P0/SERCOM2P0/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='GCLKIO6/TC4WO0/SERCOM5P0/SERCOM3P0/X10/PA22',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='GCLKIO0/PA28',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='TC1WO1/SERCOM0P3/Y5/AIN3/AIN7/PA07',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ACCMP1/TC2WO1/SERCOM4P1/SERCOM2P1/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='GCLKIO7/TC4WO1/SERCOM5P1/SERCOM3P1/X11/PA23',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='TC0WO0/SERCOM2P0/SERCOM0P0/X0/AIN16/NMI/PA08',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XIN/GCLKIO0/TC3WO0/SERCOM4P2/SERCOM2P2/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TC5WO0/SERCOM5P2/SERCOM3P2/PA24',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='VDDCORE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='TC0WO1/SERCOM2P1/SERCOM0P1/X1/AIN17/PA09',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XOUT/GCLKIO1/TC3WO1/SERCOM4P3/SERCOM2P3/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='TC5WO1/SERCOM5P3/SERCOM3P3/PA25',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='VDDIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='GCLKIO4/TC1WO0/SERCOM2P2/SERCOM0P2/X2/AIN18/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='GCLKIO2/TC2WO0/SERCOM3P0/SERCOM1P0/X4/PA16',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='GCLKIO0/SWCLK/TC1WO0/SERCOM1P2/PA30',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GCLKIO5/TC1WO1/SERCOM2P3/SERCOM0P3/X3/AIN19/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='GCLKIO3/TC2WO1/SERCOM3P1/SERCOM1P1/X5/PA17',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='SWDIO/TC1WO1/SERCOM1P3/PA31',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='ACCMP0/TC3WO0/SERCOM3P2/SERCOM1P2/X6/PA18',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PB22/SERCOM5P2/TC7WO0/GCLKIO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PB02/AIN10/Y8/SERCOM5P0/TC6WO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='ACCMP1/TC3WO1/SERCOM3P3/SERCOM1P3/X7/PA19',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PB23/SERCOM5P3/TC7WO1/GCLKIO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PB03/AIN11/Y9/SERCOM5P1/TC6WO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB10/SECOM4P2/TC5WO0/GCLKIO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='GCLKIO4/TC7WO0/SERCOM3P2/SERCOM5P2/X8/PA20',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='GCLKIO0/PA27',func=Pin.BIDIR,do_erc=True)]),
        Part(name='SAMD20G14A-MU',dest=TEMPLATE,tool=SKIDL,keywords='ARM 32bit Microcontroller 48MHz CortexM0+',description='QFN48, 256K Flash, 32K RAM, 48MHz, CortexM0+',ref_prefix='U',num_units=1,fplist=['QFN48'],do_erc=True,aliases=['SAMD20G15A-MU', 'SAMD20G16A-MU', 'SAMD20G17A-MU', 'SAMD20G18A-MU'],pins=[
            Pin(num='1',name='XIN32/TC2WO0/SERCOM1P0/PA00',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='XOUT32/TC2WO1/SERCOM1P1/PA01',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='VOUT/Y0/AIN0/PA02',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Y1/AIN1/VREFA/VREFP/PA03',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='GNDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VDDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PB08/AIN2/Y14/SERCOM4P0/TC4WO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PB09/AIN3/Y15/SERCOM4P1/TC4WO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TC0WO0/SERCOM0P0/Y2/AIN0/AIN4/VREFB/PA04',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TC0W01/SERCOM0P1/Y3/AIN1/AIN5/PA05',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB11/SERCOM4P3/TC5WO1/GCLKIO5',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='GCLKIO5/TC7WO1/SERCOM3P3/SERCOM5P3/X9/PA21',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='~RESET~',do_erc=True),
            Pin(num='11',name='TC1WO0/SERCOM0P2/Y4/AIN2/AIN6/PA06',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ACCMP0/TC2WO0/SERCOM4P0/SERCOM2P0/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='GCLKIO6/TC4WO0/SERCOM5P0/SERCOM3P0/X10/PA22',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='GCLKIO0/PA28',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='TC1WO1/SERCOM0P3/Y5/AIN3/AIN7/PA07',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ACCMP1/TC2WO1/SERCOM4P1/SERCOM2P1/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='GCLKIO7/TC4WO1/SERCOM5P1/SERCOM3P1/X11/PA23',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='TC0WO0/SERCOM2P0/SERCOM0P0/X0/AIN16/NMI/PA08',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XIN/GCLKIO0/TC3WO0/SERCOM4P2/SERCOM2P2/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TC5WO0/SERCOM5P2/SERCOM3P2/PA24',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='VDDCORE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='TC0WO1/SERCOM2P1/SERCOM0P1/X1/AIN17/PA09',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XOUT/GCLKIO1/TC3WO1/SERCOM4P3/SERCOM2P3/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='TC5WO1/SERCOM5P3/SERCOM3P3/PA25',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='VDDIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='GCLKIO4/TC1WO0/SERCOM2P2/SERCOM0P2/X2/AIN18/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='GCLKIO2/TC2WO0/SERCOM3P0/SERCOM1P0/X4/PA16',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='GCLKIO0/SWCLK/TC1WO0/SERCOM1P2/PA30',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GCLKIO5/TC1WO1/SERCOM2P3/SERCOM0P3/X3/AIN19/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='GCLKIO3/TC2WO1/SERCOM3P1/SERCOM1P1/X5/PA17',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='SWDIO/TC1WO1/SERCOM1P3/PA31',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='ACCMP0/TC3WO0/SERCOM3P2/SERCOM1P2/X6/PA18',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PB22/SERCOM5P2/TC7WO0/GCLKIO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PB02/AIN10/Y8/SERCOM5P0/TC6WO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='ACCMP1/TC3WO1/SERCOM3P3/SERCOM1P3/X7/PA19',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PB23/SERCOM5P3/TC7WO1/GCLKIO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PB03/AIN11/Y9/SERCOM5P1/TC6WO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB10/SECOM4P2/TC5WO0/GCLKIO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='GCLKIO4/TC7WO0/SERCOM3P2/SERCOM5P2/X8/PA20',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='GCLKIO0/PA27',func=Pin.BIDIR,do_erc=True)]),
        Part(name='SAMD20J14A-AU',dest=TEMPLATE,tool=SKIDL,keywords='ARM 32bit Microcontroller 48MHz CortexM0+',description='TQFP64, 256K Flash, 32K RAM, 48MHz, CortexM0+',ref_prefix='U',num_units=1,fplist=['TQFP64'],do_erc=True,aliases=['SAMD20J15A-AU', 'SAMD20J16A-AU', 'SAMD20J17A-AU', 'SAMD20J18A-AU'],pins=[
            Pin(num='1',name='XIN32/TC2WO0/SERCOM1P0/PA00',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='XOUT32/TC2WO1/SERCOM1P1/PA01',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='VOUT/Y0/AIN0/PA02',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Y1/AIN1/VREFA/VREFP/PA03',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PB04/AIN12/Y10',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PB05/AIN13/Y11',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='GNDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VDDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='PB06/AIN14/Y12',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PB07/AIN15/Y13',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='GCLKIO5/TC1WO1/SERCOM2P3/SERCOM0P3/X3/AIN19/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ACCMP1/TC2WO1/SERCOM4P1/SERCOM2P1/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB17/SERCOM5P1/TC6WO1/GCLKIO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PB23/SERCOM5P3/TC7WO1/GCLKIO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PB31/SERCOM5P1/TC0WO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PB08/AIN2/Y14/SERCOM4P0/TC4WO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='XIN/GCLKIO0/TC3WO0/SERCOM4P2/SERCOM2P2/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='GCLKIO4/TC7WO0/SERCOM3P2/SERCOM5P2/X8/PA20',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='GCLKIO0/PA27',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PB00/AIN8/Y6/SERCOM5P2/TC7WO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PB09/AIN3/Y15/SERCOM4P1/TC4WO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='XOUT/GCLKIO1/TC3WO1/SERCOM4P3/SERCOM2P3/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='GCLKIO5/TC7WO1/SERCOM3P3/SERCOM5P3/X9/PA21',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='~RESET~',do_erc=True),
            Pin(num='62',name='PB01/AIN9/Y7/SERCOM5P3/TC7WO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TC0WO0/SERCOM0P0/Y2/AIN0/AIN4/VREFB/PA04',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PB10/SECOM4P2/TC5WO0/GCLKIO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='43',name='GCLKIO6/TC4WO0/SERCOM5P0/SERCOM3P0/X10/PA22',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GCLKIO0/PA28',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PB02/AIN10/Y8/SERCOM5P0/TC6WO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TC0W01/SERCOM0P1/Y3/AIN1/AIN5/PA05',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PB11/SERCOM4P3/TC5WO1/GCLKIO5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='GCLKIO7/TC4WO1/SERCOM5P1/SERCOM3P1/X11/PA23',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='PB03/AIN11/Y9/SERCOM5P1/TC6WO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TC1WO0/SERCOM0P2/Y4/AIN2/AIN6/PA06',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/X12/SERC0M4P0/TC4WO0/GCLKIO6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='GCLKIO2/TC2WO0/SERCOM3P0/SERCOM1P0/X4/PA16',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='TC5WO0/SERCOM5P2/SERCOM3P2/PA24',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='VDDCORE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='TC1WO1/SERCOM0P3/Y5/AIN3/AIN7/PA07',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/X13/SERCOM4P1/TC4WO1/GCLKIO7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='GCLKIO3/TC2WO1/SERCOM3P1/SERCOM1P1/X5/PA17',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='TC5WO1/SERCOM5P3/SERCOM3P3/PA25',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='VDDIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='TC0WO0/SERCOM2P0/SERCOM0P0/X0/AIN16/NMI/PA08',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/X14/SERCOM4P2/TC5WO0/GCLKIO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='ACCMP0/TC3WO0/SERCOM3P2/SERCOM1P2/X6/PA18',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='57',name='GCLKIO0/SWCLK/TC1WO0/SERCOM1P2/PA30',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TC0WO1/SERCOM2P1/SERCOM0P1/X1/AIN17/PA09',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/X15/SERCOM4P3/TC5W01/GCLKIO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='ACCMP1/TC3WO1/SERCOM3P3/SERCOM1P3/X7/PA19',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='58',name='SWDIO/TC1WO1/SERCOM1P3/PA31',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='GCLKIO4/TC1WO0/SERCOM2P2/SERCOM0P2/X2/AIN18/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ACCMP0/TC2WO0/SERCOM4P0/SERCOM2P0/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB16/SERCOM5P0/TC6WO0/GCLKIO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PB22/SERCOM5P2/TC7WO0/GCLKIO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PB30/SERC0M5P0/TC0WO0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='SAMD20J14A-MU',dest=TEMPLATE,tool=SKIDL,keywords='ARM 32bit Microcontroller 48MHz CortexM0+',description='QFN64, 256K Flash, 32K RAM, 48MHz, CortexM0+',ref_prefix='U',num_units=1,fplist=['QFN64'],do_erc=True,aliases=['SAMD20J15A-MU', 'SAMD20J16A-MU', 'SAMD20J17A-MU', 'SAMD20J18A-MU'],pins=[
            Pin(num='1',name='XIN32/TC2WO0/SERCOM1P0/PA00',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='XOUT32/TC2WO1/SERCOM1P1/PA01',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='VOUT/Y0/AIN0/PA02',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Y1/AIN1/VREFA/VREFP/PA03',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PB04/AIN12/Y10',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PB05/AIN13/Y11',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='GNDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VDDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='PB06/AIN14/Y12',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PB07/AIN15/Y13',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='GCLKIO5/TC1WO1/SERCOM2P3/SERCOM0P3/X3/AIN19/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ACCMP1/TC2WO1/SERCOM4P1/SERCOM2P1/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB17/SERCOM5P1/TC6WO1/GCLKIO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PB23/SERCOM5P3/TC7WO1/GCLKIO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PB31/SERCOM5P1/TC0WO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PB08/AIN2/Y14/SERCOM4P0/TC4WO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='XIN/GCLKIO0/TC3WO0/SERCOM4P2/SERCOM2P2/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='GCLKIO4/TC7WO0/SERCOM3P2/SERCOM5P2/X8/PA20',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='GCLKIO0/PA27',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PB00/AIN8/Y6/SERCOM5P2/TC7WO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PB09/AIN3/Y15/SERCOM4P1/TC4WO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='XOUT/GCLKIO1/TC3WO1/SERCOM4P3/SERCOM2P3/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='GCLKIO5/TC7WO1/SERCOM3P3/SERCOM5P3/X9/PA21',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='~RESET~',do_erc=True),
            Pin(num='62',name='PB01/AIN9/Y7/SERCOM5P3/TC7WO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TC0WO0/SERCOM0P0/Y2/AIN0/AIN4/VREFB/PA04',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PB10/SECOM4P2/TC5WO0/GCLKIO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='43',name='GCLKIO6/TC4WO0/SERCOM5P0/SERCOM3P0/X10/PA22',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GCLKIO0/PA28',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PB02/AIN10/Y8/SERCOM5P0/TC6WO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TC0W01/SERCOM0P1/Y3/AIN1/AIN5/PA05',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PB11/SERCOM4P3/TC5WO1/GCLKIO5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='GCLKIO7/TC4WO1/SERCOM5P1/SERCOM3P1/X11/PA23',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='PB03/AIN11/Y9/SERCOM5P1/TC6WO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TC1WO0/SERCOM0P2/Y4/AIN2/AIN6/PA06',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/X12/SERC0M4P0/TC4WO0/GCLKIO6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='GCLKIO2/TC2WO0/SERCOM3P0/SERCOM1P0/X4/PA16',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='TC5WO0/SERCOM5P2/SERCOM3P2/PA24',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='VDDCORE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='TC1WO1/SERCOM0P3/Y5/AIN3/AIN7/PA07',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/X13/SERCOM4P1/TC4WO1/GCLKIO7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='GCLKIO3/TC2WO1/SERCOM3P1/SERCOM1P1/X5/PA17',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='TC5WO1/SERCOM5P3/SERCOM3P3/PA25',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='VDDIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='TC0WO0/SERCOM2P0/SERCOM0P0/X0/AIN16/NMI/PA08',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/X14/SERCOM4P2/TC5WO0/GCLKIO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='ACCMP0/TC3WO0/SERCOM3P2/SERCOM1P2/X6/PA18',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='57',name='GCLKIO0/SWCLK/TC1WO0/SERCOM1P2/PA30',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TC0WO1/SERCOM2P1/SERCOM0P1/X1/AIN17/PA09',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/X15/SERCOM4P3/TC5W01/GCLKIO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='ACCMP1/TC3WO1/SERCOM3P3/SERCOM1P3/X7/PA19',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='58',name='SWDIO/TC1WO1/SERCOM1P3/PA31',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='GCLKIO4/TC1WO0/SERCOM2P2/SERCOM0P2/X2/AIN18/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ACCMP0/TC2WO0/SERCOM4P0/SERCOM2P0/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB16/SERCOM5P0/TC6WO0/GCLKIO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PB22/SERCOM5P2/TC7WO0/GCLKIO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PB30/SERC0M5P0/TC0WO0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='SAML21E15B-A',dest=TEMPLATE,tool=SKIDL,keywords='ARM 32bit Microcontroller 48MHz CortexM0+',description='TQFP32, 265K Flash, 32K RAM, 48MHz, CortexM0+',ref_prefix='U',num_units=1,fplist=['Housings_QFP:TQFP-32_7x7mm_Pitch0.8mm'],do_erc=True,aliases=['SAML21E16B-A', 'SAML21E17B-A', 'SAML21E18B-A'],pins=[
            Pin(num='1',name='XIN32/EXTINT0EXTWAKE0/SERCOM1PAD0/TCC2WO0/PA00',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='XOUT32/EXTINT1EXTWAKE1/SERCOM1PAD1/TCC2WO1/PA01',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='EXTINT2EXTWAKE2/AIN0/Y0/VOUT0/OANEG0/PA02',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='EXTINT3EXTWAKE3/VREFA/AIN1/Y1/PA03',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='EXTINT4EXTWAKE4/VREFB/AIN4/AIN0/OAOUT2/SERCOM0PAD0/TCC0WO0/CCL0IN0/PA04',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='EXTINT5EXTWAKE5/AIN5/AIN1/VOUT1/OAPOS2/SERCOM0PAD1/TCC0WO1/CCL0IN1/PA05',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='EXTINT6EXTWAKE6/AIN6/AIN2/Y4/OAPOS0/SERCOM0PAD2/TCC1WO0/CCL0IN2/PA06',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='EXTINT7EXTWAKE7/AIN7/AIN3/OAOUT0/SERCOM0PAD3/TCC1WO1/CCL0OUT/PA07',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='VDDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='EXTINT3/X7/SERCOM1PAD3/SERCOM3PAD3/TC4WO1/TCC0WO3/ACCMP1/CCL0OUT/PA19',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='VDDIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='NMI/AIN16/X0Y6/SERCOM0PAD0/SERCOM2PAD0/TCC0WO0/TCC1WO2/CCL1IN0/PA08',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='EXTINT6/X10/SERCOM3PAD0/SERCOM5PAD0/TC0WO0/TCC0WO4/GCLKIO6/CCL2IN0/PA22',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='EXTINT10/SERCOM1PAD2/TCC1WO0/CORTEX_M0PSWCLK/GCLK_IO0/CCL1IN0/PA30',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='EXTINT9/AIN17/X1Y7/SERCOM0PAD1/SERCOM2PAD1/TCC0WO1/TCC1WO3/CCL1IN1/PA09',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='EXTINT7/X11/SERCOM3PAD1/SERCOM5PAD1/TC0WO1/TCC0WO5/USBSOF1KHZ/GCLKIO7/CCL2IN1/PA23',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='EXTINT11/SERCOM1PAD3/TCC1WO1/SWDIO/CCL1OUT/PA31',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='EXTINT10/AIN18/X2Y8/SERCOM0PAD2/SERCOM2PAD2/TCC1WO0/TCC0WO2/GCLKIO4/CCL1IN2/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='EXTINT12/SERCOM3PAD2/SERCOM5PAD2/TC1WO1/TCC1WO2/USBDM/CCL2IN2/PA24',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='EXTINT11/AIN19/X3Y9/SERCOM0PAD3/SERCOM2PAD3/TCC1WO1/TCC0WO3/GCLKIO5/CCL1OUT/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='EXTINT13/SERCOM3PAD3/SERCOM5PAD3/TC1WO1/TCC1WO3/USBDP/CCL2OUT/PA25',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='XIN/EXTINT14/SERCOM2PAD2/SERCOM4PAD2/TC4WO0/TCC0WO4/GCLKIO0/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='EXTINT15/GCLKIO0/PA27',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='XOUT/EXTINT15/SERCOM2PAD3/SERCOM4PAD3/TC4WO1/TCC0WO5/GCLKIO1/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='~RESET~',do_erc=True),
            Pin(num='17',name='EXTINT0/X4/SERCOM1PAD0/SERCOM3PAD4/TCC2WO0/TCC0WO6/GCLKIO2/CCL0IN0/PA16',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='VSW',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='EXTINT1/X5/SERCOM1PAD1/SERCOM3PAD1/TCC2WO1/TCC0WO7/GCLKIO3/CCL0IN1/PA17',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='EXTINT2/X6/SERCOM1PAD2/SERCOM3PAD2/TC4WO0/TCC0WO2/ACCMP0/CCL0IN2/PA18',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDDCORE',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SAML21E15B-M',dest=TEMPLATE,tool=SKIDL,keywords='ARM 32bit Microcontroller 48MHz CortexM0+',description='QFN32, 32K Flash, 4K RAM, 48MHz, CortexM0+',ref_prefix='U',num_units=1,fplist=['Housings_DFN_QFN:QFN-32-1EP_5x5mm_Pitch0.5mm'],do_erc=True,aliases=['SAML21E16B-M', 'SAML21E17B-M', 'SAML21E18B-M'],pins=[
            Pin(num='1',name='XIN32/EXTINT0EXTWAKE0/SERCOM1PAD0/TCC2WO0/PA00',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='XOUT32/EXTINT1EXTWAKE1/SERCOM1PAD1/TCC2WO1/PA01',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='EXTINT2EXTWAKE2/AIN0/Y0/VOUT0/OANEG0/PA02',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='EXTINT3EXTWAKE3/VREFA/AIN1/Y1/PA03',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='EXTINT4EXTWAKE4/VREFB/AIN4/AIN0/OAOUT2/SERCOM0PAD0/TCC0WO0/CCL0IN0/PA04',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='EXTINT5EXTWAKE5/AIN5/AIN1/VOUT1/OAPOS2/SERCOM0PAD1/TCC0WO1/CCL0IN1/PA05',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='EXTINT6EXTWAKE6/AIN6/AIN2/Y4/OAPOS0/SERCOM0PAD2/TCC1WO0/CCL0IN2/PA06',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='EXTINT7EXTWAKE7/AIN7/AIN3/OAOUT0/SERCOM0PAD3/TCC1WO1/CCL0OUT/PA07',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='VDDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='EXTINT3/X7/SERCOM1PAD3/SERCOM3PAD3/TC4WO1/TCC0WO3/ACCMP1/CCL0OUT/PA19',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='VDDIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='NMI/AIN16/X0Y6/SERCOM0PAD0/SERCOM2PAD0/TCC0WO0/TCC1WO2/CCL1IN0/PA08',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='EXTINT6/X10/SERCOM3PAD0/SERCOM5PAD0/TC0WO0/TCC0WO4/GCLKIO6/CCL2IN0/PA22',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='EXTINT10/SERCOM1PAD2/TCC1WO0/CORTEX_M0PSWCLK/GCLK_IO0/CCL1IN0/PA30',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='EXTINT9/AIN17/X1Y7/SERCOM0PAD1/SERCOM2PAD1/TCC0WO1/TCC1WO3/CCL1IN1/PA09',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='EXTINT7/X11/SERCOM3PAD1/SERCOM5PAD1/TC0WO1/TCC0WO5/USBSOF1KHZ/GCLKIO7/CCL2IN1/PA23',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='EXTINT11/SERCOM1PAD3/TCC1WO1/SWDIO/CCL1OUT/PA31',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='EXTINT10/AIN18/X2Y8/SERCOM0PAD2/SERCOM2PAD2/TCC1WO0/TCC0WO2/GCLKIO4/CCL1IN2/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='EXTINT12/SERCOM3PAD2/SERCOM5PAD2/TC1WO1/TCC1WO2/USBDM/CCL2IN2/PA24',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='EXTINT11/AIN19/X3Y9/SERCOM0PAD3/SERCOM2PAD3/TCC1WO1/TCC0WO3/GCLKIO5/CCL1OUT/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='EXTINT13/SERCOM3PAD3/SERCOM5PAD3/TC1WO1/TCC1WO3/USBDP/CCL2OUT/PA25',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='XIN/EXTINT14/SERCOM2PAD2/SERCOM4PAD2/TC4WO0/TCC0WO4/GCLKIO0/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='EXTINT15/GCLKIO0/PA27',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='XOUT/EXTINT15/SERCOM2PAD3/SERCOM4PAD3/TC4WO1/TCC0WO5/GCLKIO1/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='~RESET~',do_erc=True),
            Pin(num='17',name='EXTINT0/X4/SERCOM1PAD0/SERCOM3PAD4/TCC2WO0/TCC0WO6/GCLKIO2/CCL0IN0/PA16',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='VSW',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='EXTINT1/X5/SERCOM1PAD1/SERCOM3PAD1/TCC2WO1/TCC0WO7/GCLKIO3/CCL0IN1/PA17',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='EXTINT2/X6/SERCOM1PAD2/SERCOM3PAD2/TC4WO0/TCC0WO2/ACCMP0/CCL0IN2/PA18',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDDCORE',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SAML21G16B-A',dest=TEMPLATE,tool=SKIDL,keywords='ARM 32bit Microcontroller 48MHz CortexM0+',description='TQFP48, 256K Flash, 32K RAM, 48MHz, CortexM0+',ref_prefix='U',num_units=1,fplist=['Housings_QFP:TQFP-48-1EP_7x7mm_Pitch0.5mm'],do_erc=True,aliases=['SAML21G17B-A', 'SAML21G18B-A'],pins=[
            Pin(num='1',name='XIN32/EXTINT0EXTWAKE0/SERCOM1PAD0/TCC2WO0/PA00',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='XOUT32/EXTINT1EXTWAKE1/SERCOM1PAD1/TCC2WO1/PA01',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='EXTINT2EXTWAKE2/AIN0/Y0/VOUT0/OANEG0/PA02',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Y1/AIN1/VREFA/VREFP/PA03',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='GNDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VDDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='EXTINT8/AIN2/OAOUT1/SERCOM4PAD0/TC0WO0/CCL2IN2/PB08',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='EXTINT9/AIN3/Y15/OAPOS1/SERCOM4PAD1/TC0WO1/CCL2OUT/PB09',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='EXTINT4EXTWAKE4/VREFB/AIN4/AIN0/OAOUT2/SERCOM0PAD0/TCC0WO0/CCL0IN0/PA04',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='EXTINT5EXTWAKE5/AIN5/AIN1/VOUT1/OAPOS2/SERCOM0PAD1/TCC0WO1/CCL0IN1/PA05',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='EXTINT11/Y3/SERCOM4PAD3/TC1WO1/TCC0WO5/GCLKIO5/CCL1OUT/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='EXTINT5/X9/SERCOM5PAD3/SERCOM3PAD3/TC3WO1/TCC0WO7/GCLKIO5/PA21',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='~RESET~',do_erc=True),
            Pin(num='11',name='EXTINT6EXTWAKE6/AIN6/AIN2/Y4/OAPOS0/SERCOM0PAD2/TCC1WO0/CCL0IN2/PA06',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ACCMP0/TC2WO0/SERCOM4P0/SERCOM2P0/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='EXTINT6/X10/SERCOM3PAD0/SERCOM5PAD0/TC0WO0/TCC0WO4/GCLKIO6/CCL2IN0/PA22',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='VDDCORE',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='EXTINT7EXTWAKE7/AIN7/AIN3/OAOUT0/SERCOM0PAD3/TCC1WO1/CCL0OUT/PA07',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ACCMP1/TC2WO1/SERCOM4P1/SERCOM2P1/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='EXTINT7/X11/SERCOM3PAD1/SERCOM5PAD1/TC0WO1/TCC0WO5/USBSOF1KHZ/GCLKIO7/CCL2IN1/PA23',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='NMI/AIN16/X0Y6/SERCOM0PAD0/SERCOM2PAD0/TCC0WO0/TCC1WO2/CCL1IN0/PA08',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XIN/EXTINT14/SERCOM2PAD2/SERCOM4PAD2/TC4WO0/TCC0WO4/GCLKIO0/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='EXTINT12/SERCOM3PAD2/SERCOM5PAD2/TC1WO1/TCC1WO2/USBDM/CCL2IN2/PA24',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='VSW',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='EXTINT9/AIN17/X1Y7/SERCOM0PAD1/SERCOM2PAD1/TCC0WO1/TCC1WO3/CCL1IN1/PA09',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XOUT/EXTINT15/SERCOM2PAD3/SERCOM4PAD3/TC4WO1/TCC0WO5/GCLKIO1/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='EXTINT13/SERCOM3PAD3/SERCOM5PAD3/TC1WO1/TCC1WO3/USBDP/CCL2OUT/PA25',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='VDDIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='EXTINT10/AIN18/X2Y8/SERCOM0PAD2/SERCOM2PAD2/TCC1WO0/TCC0WO2/GCLKIO4/CCL1IN2/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='EXTINT0/X4/SERCOM1PAD0/SERCOM3PAD4/TCC2WO0/TCC0WO6/GCLKIO2/CCL0IN0/PA16',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='EXTINT10/SERCOM1PAD2/TCC1WO0/CORTEXM0PSWCLK/GCLKIO0/CCL1IN0/PA30',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='EXTINT11/AIN19/X3Y9/SERCOM0PAD3/SERCOM2PAD3/TCC1WO1/TCC0WO3/GCLKIO5/CCL1OUT/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='EXTINT1/X5/SERCOM1PAD1/SERCOM3PAD1/TCC2WO1/TCC0WO7/GCLKIO3/CCL0IN1/PA17',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='EXTINT11/SERCOM1PAD3/TCC1WO1/SWDIO/CCL1OUT/PA31',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='EXTINT2/X6/SERCOM1PAD2/SERCOM3PAD2/TC4WO0/TCC0WO2/ACCMP0/CCL0IN2/PA18',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='EXTINT6/SERCOM5PAD2/TC3WO0/GCLKIO0/CCL0IN0/PB22',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='EXTINT2/AIN10/SERCOM5PAD0/TC2WO0/SUPCOUT1/CCL0OUT/PB02',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='EXTINT3/X7/SERCOM1PAD3/SERCOM3PAD3/TC4WO1/TCC0WO3/ACCMP1/CCL0OUT/PA19',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='EXTINT7/SERCOM5PAD3/TC3WO1/GCLKIO1/CCL0OUT/PB23',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='EXTINT3/AIN11/SERCOM5PAD1/TC2WO1/SUPCVBAT/PB03',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='EXTINT10/Y2/SERCOM4PAD2/TC1WO0/TCC0WO4/GCLKIO4/CCL1IN2/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='EXTINT4/X8/SERCOM5PAD2/SERCOM3PAD2/TC3WO0/TCC0WO6/GCLKIO4/PA20',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='EXTINT15/GCLKIO0/PA27',func=Pin.BIDIR,do_erc=True)]),
        Part(name='SAML21G16B-M',dest=TEMPLATE,tool=SKIDL,keywords='ARM 32bit Microcontroller 48MHz CortexM0+',description='QFN48, 256K Flash, 32K RAM, 48MHz, CortexM0+',ref_prefix='U',num_units=1,fplist=['Housings_DFN_QFN:QFN-48-1EP_7x7mm_Pitch0.5mm'],do_erc=True,aliases=['SAML21G17B-M', 'SAML21G18B-M'],pins=[
            Pin(num='1',name='XIN32/EXTINT0EXTWAKE0/SERCOM1PAD0/TCC2WO0/PA00',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='XOUT32/EXTINT1EXTWAKE1/SERCOM1PAD1/TCC2WO1/PA01',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='EXTINT2EXTWAKE2/AIN0/Y0/VOUT0/OANEG0/PA02',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Y1/AIN1/VREFA/VREFP/PA03',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='GNDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VDDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='EXTINT8/AIN2/OAOUT1/SERCOM4PAD0/TC0WO0/CCL2IN2/PB08',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='EXTINT9/AIN3/Y15/OAPOS1/SERCOM4PAD1/TC0WO1/CCL2OUT/PB09',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='EXTINT4EXTWAKE4/VREFB/AIN4/AIN0/OAOUT2/SERCOM0PAD0/TCC0WO0/CCL0IN0/PA04',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='EXTINT5EXTWAKE5/AIN5/AIN1/VOUT1/OAPOS2/SERCOM0PAD1/TCC0WO1/CCL0IN1/PA05',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='EXTINT11/Y3/SERCOM4PAD3/TC1WO1/TCC0WO5/GCLKIO5/CCL1OUT/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='EXTINT5/X9/SERCOM5PAD3/SERCOM3PAD3/TC3WO1/TCC0WO7/GCLKIO5/PA21',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='~RESET~',do_erc=True),
            Pin(num='11',name='EXTINT6EXTWAKE6/AIN6/AIN2/Y4/OAPOS0/SERCOM0PAD2/TCC1WO0/CCL0IN2/PA06',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ACCMP0/TC2WO0/SERCOM4P0/SERCOM2P0/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='EXTINT6/X10/SERCOM3PAD0/SERCOM5PAD0/TC0WO0/TCC0WO4/GCLKIO6/CCL2IN0/PA22',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='GCLKIO0/PA28',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='EXTINT7EXTWAKE7/AIN7/AIN3/OAOUT0/SERCOM0PAD3/TCC1WO1/CCL0OUT/PA07',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ACCMP1/TC2WO1/SERCOM4P1/SERCOM2P1/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='EXTINT7/X11/SERCOM3PAD1/SERCOM5PAD1/TC0WO1/TCC0WO5/USBSOF1KHZ/GCLKIO7/CCL2IN1/PA23',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='NMI/AIN16/X0Y6/SERCOM0PAD0/SERCOM2PAD0/TCC0WO0/TCC1WO2/CCL1IN0/PA08',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XIN/EXTINT14/SERCOM2PAD2/SERCOM4PAD2/TC4WO0/TCC0WO4/GCLKIO0/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='EXTINT12/SERCOM3PAD2/SERCOM5PAD2/TC1WO1/TCC1WO2/USBDM/CCL2IN2/PA24',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='VSW',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='EXTINT9/AIN17/X1Y7/SERCOM0PAD1/SERCOM2PAD1/TCC0WO1/TCC1WO3/CCL1IN1/PA09',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='XOUT/EXTINT15/SERCOM2PAD3/SERCOM4PAD3/TC4WO1/TCC0WO5/GCLKIO1/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='EXTINT13/SERCOM3PAD3/SERCOM5PAD3/TC1WO1/TCC1WO3/USBDP/CCL2OUT/PA25',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='VDDIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='EXTINT10/AIN18/X2Y8/SERCOM0PAD2/SERCOM2PAD2/TCC1WO0/TCC0WO2/GCLKIO4/CCL1IN2/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='EXTINT0/X4/SERCOM1PAD0/SERCOM3PAD4/TCC2WO0/TCC0WO6/GCLKIO2/CCL0IN0/PA16',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='EXTINT10/SERCOM1PAD2/TCC1WO0/CORTEXM0PSWCLK/GCLKIO0/CCL1IN0/PA30',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='EXTINT11/AIN19/X3Y9/SERCOM0PAD3/SERCOM2PAD3/TCC1WO1/TCC0WO3/GCLKIO5/CCL1OUT/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='EXTINT1/X5/SERCOM1PAD1/SERCOM3PAD1/TCC2WO1/TCC0WO7/GCLKIO3/CCL0IN1/PA17',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='EXTINT11/SERCOM1PAD3/TCC1WO1/SWDIO/CCL1OUT/PA31',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='EXTINT2/X6/SERCOM1PAD2/SERCOM3PAD2/TC4WO0/TCC0WO2/ACCMP0/CCL0IN2/PA18',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='EXTINT6/SERCOM5PAD2/TC3WO0/GCLKIO0/CCL0IN0/PB22',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='EXTINT2/AIN10/SERCOM5PAD0/TC2WO0/SUPCOUT1/CCL0OUT/PB02',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='EXTINT3/X7/SERCOM1PAD3/SERCOM3PAD3/TC4WO1/TCC0WO3/ACCMP1/CCL0OUT/PA19',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='EXTINT7/SERCOM5PAD3/TC3WO1/GCLKIO1/CCL0OUT/PB23',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='EXTINT3/AIN11/SERCOM5PAD1/TC2WO1/SUPCVBAT/PB03',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='EXTINT10/Y2/SERCOM4PAD2/TC1WO0/TCC0WO4/GCLKIO4/CCL1IN2/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='EXTINT4/X8/SERCOM5PAD2/SERCOM3PAD2/TC3WO0/TCC0WO6/GCLKIO4/PA20',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='EXTINT15/GCLKIO0/PA27',func=Pin.BIDIR,do_erc=True)]),
        Part(name='SAML21J16B-A',dest=TEMPLATE,tool=SKIDL,keywords='ARM 32bit Microcontroller 48MHz CortexM0+',description='TQFP64, 256K Flash, 32K RAM, 48MHz, CortexM0+',ref_prefix='U',num_units=1,fplist=['Housings_QFP:TQFP-64_1EP_10x10mm_Pitch0.5mm'],do_erc=True,aliases=['SAML21J17B-A', 'SAML21J18B-A'],pins=[
            Pin(num='1',name='XIN32/EXTINT0EXTWAKE0/SERCOM1PAD0/TCC2WO0/PA00',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='XOUT32/EXTINT1EXTWAKE1/SERCOM1PAD1/TCC2WO1/PA01',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='EXTINT2EXTWAKE2/AIN0/Y0/VOUT0/OANEG0/PA02',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='EXTINT3EXTWAKE3/VREFA/AIN1/Y1/PA03',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PB04/EXTINT4/AIN12/Y10',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PB05/EXTINT5/AIN13/Y11/OANEG1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='GNDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VDDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='PB06/EXTINT6/AIN14/Y12/OANEG2/CCL2IN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PB07/EXTINT7/AIN15/Y13/CCL2IN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='EXTINT11/AIN19/X3Y9/SERCOM0PAD3/SERCOM2PAD3/TCC1WO1/TCC0WO3/GCLKIO5/CCL1OUT/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='EXTINT13/SERCOM2PAD1/SERCOM4PAD1/TCC2WO1/TCC0WO7/ACCMP1/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB17/EXTINT1/SERCOM5PAD1/TC2WO1/TCC0WO5/GCLKIO3/CCL3',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PB23/EXTINT7/SERCOM5PAD3/TC3WO1/GCLKIO1/CCL0OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PB31/EXTINT15/SERCOM5PAD1/TCC0WO1/TCC1WO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PB08/EXTINT8/AIN2/OAOUT1/SERCOM4PAD0/TC0WO0/CCL2IN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='XIN/EXTINT14/SERCOM2PAD2/SERCOM4PAD2/TC4WO0/TCC0WO4/GCLKIO0/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='EXTINT4/X8/SERCOM5PAD2/SERCOM3PAD2/TC3WO0/TCC0WO6/GCLKIO4/PA20',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='EXTINT15/GCLKIO0/PA27',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PB00/EXTINT0/AIN8/SERCOM5PAD2/TC3WO0/SUPCPSOK/CCL0IN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PB09/EXTINT9/AIN3/Y15/OAPOS1/SERCOM4PAD1/TC0WO1/CCL2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='XOUT/EXTINT15/SERCOM2PAD3/SERCOM4PAD3/TC4WO1/TCC0WO5/GCLKIO1/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='EXTINT5/X9/SERCOM5PAD3/SERCOM3PAD3/TC3WO1/TCC0WO7/GCLKIO5/PA21',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='~RESET~',do_erc=True),
            Pin(num='62',name='PB01/EXTINT1/AIN9/SERCOM5PAD3/TC3WO1/SUPCOUT0/CCL0IN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='EXTINT4EXTWAKE4/VREFB/AIN4/AIN0/OAOUT2/SERCOM0PAD0/TCC0WO0/CCL0IN0/PA04',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PB10/EXTINT10/Y2/SERCOM4PAD2/TC1WO0/TCC0WO4/GCLKIO4/CCL1IN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='43',name='EXTINT6/X10/SERCOM3PAD0/SERCOM5PAD0/TC0WO0/TCC0WO4/GCLKIO6/CCL2IN0/PA22',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VDDCORE',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='PB02/EXTINT2/AIN10/SERCOM5PAD0/TC2WO0/SUPCOUT1/CCL0OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='EXTINT5EXTWAKE5/AIN5/AIN1/VOUT1/OAPOS2/SERCOM0PAD1/TCC0WO1/CCL0IN1/PA05',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PB11/EXTINT11/Y3/SERCOM4PAD3/TC1WO1/TCC0WO5/GCLKIO5/CCL1OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='EXTINT7/X11/SERCOM3PAD1/SERCOM5PAD1/TC0WO1/TCC0WO5/USBSOF1KHZ/GCLKIO7/CCL2IN1/PA23',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='PB03/EXTINT3/AIN11/SERCOM5PAD1/TC2WO1/SUPCVBAT',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='EXTINT6EXTWAKE6/AIN6/AIN2/Y4/OAPOS0/SERCOM0PAD2/TCC1WO0/CCL0IN2/PA06',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/EXTINT12/X12Y5/SERCOM4PAD0/TC0WO0/TCC0WO6/GCLKIO6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='EXTINT0/X4/SERCOM1PAD0/SERCOM3PAD4/TCC2WO0/TCC0WO6/GCLKIO2/CCL0IN0/PA16',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='EXTINT12/SERCOM3PAD2/SERCOM5PAD2/TC1WO1/TCC1WO2/USBDM/CCL2IN2/PA24',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='VSW',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='TC1WO1/SERCOM0P3/Y5/AIN3/AIN7/PA07',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/EXTINT13/X13Y14/SERCOM4PAD1/TC0WO1/TCC0WO7/GCLKIO7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='EXTINT1/X5/SERCOM1PAD1/SERCOM3PAD1/TCC2WO1/TCC0WO7/GCLKIO3/CCL0IN1/PA17',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='EXTINT13/SERCOM3PAD3/SERCOM5PAD3/TC1WO1/TCC1WO3/USBDP/CCL2OUT/PA25',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='VDDIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='NMI/AIN16/X0Y6/SERCOM0PAD0/SERCOM2PAD0/TCC0WO0/TCC1WO2/CCL1IN0/PA08',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/EXTINT14/X14/SERCOM4PAD2/TC1WO0/GCLKIO0/CCL3IN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='EXTINT2/X6/SERCOM1PAD2/SERCOM3PAD2/TC4WO0/TCC0WO2/ACCMP0/CCL0IN2/PA18',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='57',name='EXTINT10/SERCOM1PAD2/TCC1WO0/CORTEXM0PSWCLK/GCLKIO0/CCL1IN0/PA30',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='EXTINT9/AIN17/X1Y7/SERCOM0PAD1/SERCOM2PAD1/TCC0WO1/TCC1WO3/CCL1IN1/PA09',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/EXTINT15/X15/SERCOM4PAD3/TC1WO1/GCLKIO1/CCL3IN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='EXTINT3/X7/SERCOM1PAD3/SERCOM3PAD3/TC4WO1/TCC0WO3/ACCMP1/CCL0OUT/PA19',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='58',name='EXTINT11/SERCOM1PAD3/TCC1WO1/SWDIO/CCL1OUT/PA31',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='EXTINT10/AIN18/X2Y8/SERCOM0PAD2/SERCOM2PAD2/TCC1WO0/TCC0WO2/GCLKIO4/CCL1IN2/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='EXTINT12/SERCOM2PAD0/SERCOM4PAD0/TCC2WO0/TCC0WO6/ACCMP0/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB16/EXTINT0/SERCOM5PAD0/TC2WO0/TCC0WO4/GCLKIO2/CCL3IN3',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PB22/EXTINT6/SERCOM5PAD2/TC3WO0/GCLKIO0/CCL0IN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PB30/EXTINT14/SERCOM5PAD0/TCC0WO0/TCC1WO2',func=Pin.BIDIR,do_erc=True)]),
        Part(name='SAML21J16B-M',dest=TEMPLATE,tool=SKIDL,keywords='ARM 32bit Microcontroller 48MHz CortexM0+',description='QFN64, 256K Flash, 32K RAM, 48MHz, CortexM0+',ref_prefix='U',num_units=1,fplist=['Housings_DFN_QFN:QFN-64-1EP_9x9mm_Pitch0.5mm'],do_erc=True,aliases=['SAML21J17B-M', 'SAML21J18B-M'],pins=[
            Pin(num='1',name='XIN32/EXTINT0EXTWAKE0/SERCOM1PAD0/TCC2WO0/PA00',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='XOUT32/EXTINT1EXTWAKE1/SERCOM1PAD1/TCC2WO1/PA01',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='EXTINT2EXTWAKE2/AIN0/Y0/VOUT0/OANEG0/PA02',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='EXTINT3EXTWAKE3/VREFA/AIN1/Y1/PA03',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PB04/EXTINT4/AIN12/Y10',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PB05/EXTINT5/AIN13/Y11/OANEG1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='GNDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VDDANA',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='PB06/EXTINT6/AIN14/Y12/OANEG2/CCL2IN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PB07/EXTINT7/AIN15/Y13/CCL2IN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='EXTINT11/AIN19/X3Y9/SERCOM0PAD3/SERCOM2PAD3/TCC1WO1/TCC0WO3/GCLKIO5/CCL1OUT/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='EXTINT13/SERCOM2PAD1/SERCOM4PAD1/TCC2WO1/TCC0WO7/ACCMP1/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB17/EXTINT1/SERCOM5PAD1/TC2WO1/TCC0WO5/GCLKIO3/CCL3',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PB23/EXTINT7/SERCOM5PAD3/TC3WO1/GCLKIO1/CCL0OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PB31/EXTINT15/SERCOM5PAD1/TCC0WO1/TCC1WO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PB08/EXTINT8/AIN2/OAOUT1/SERCOM4PAD0/TC0WO0/CCL2IN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='XIN/EXTINT14/SERCOM2PAD2/SERCOM4PAD2/TC4WO0/TCC0WO4/GCLKIO0/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='EXTINT4/X8/SERCOM5PAD2/SERCOM3PAD2/TC3WO0/TCC0WO6/GCLKIO4/PA20',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='EXTINT15/GCLKIO0/PA27',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PB00/EXTINT0/AIN8/SERCOM5PAD2/TC3WO0/SUPCPSOK/CCL0IN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PB09/EXTINT9/AIN3/Y15/OAPOS1/SERCOM4PAD1/TC0WO1/CCL2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='XOUT/EXTINT15/SERCOM2PAD3/SERCOM4PAD3/TC4WO1/TCC0WO5/GCLKIO1/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='EXTINT5/X9/SERCOM5PAD3/SERCOM3PAD3/TC3WO1/TCC0WO7/GCLKIO5/PA21',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='~RESET~',do_erc=True),
            Pin(num='62',name='PB01/EXTINT1/AIN9/SERCOM5PAD3/TC3WO1/SUPCOUT0/CCL0IN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='EXTINT4EXTWAKE4/VREFB/AIN4/AIN0/OAOUT2/SERCOM0PAD0/TCC0WO0/CCL0IN0/PA04',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PB10/EXTINT10/Y2/SERCOM4PAD2/TC1WO0/TCC0WO4/GCLKIO4/CCL1IN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='43',name='EXTINT6/X10/SERCOM3PAD0/SERCOM5PAD0/TC0WO0/TCC0WO4/GCLKIO6/CCL2IN0/PA22',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VDDCORE',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='PB02/EXTINT2/AIN10/SERCOM5PAD0/TC2WO0/SUPCOUT1/CCL0OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='EXTINT5EXTWAKE5/AIN5/AIN1/VOUT1/OAPOS2/SERCOM0PAD1/TCC0WO1/CCL0IN1/PA05',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PB11/EXTINT11/Y3/SERCOM4PAD3/TC1WO1/TCC0WO5/GCLKIO5/CCL1OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='EXTINT7/X11/SERCOM3PAD1/SERCOM5PAD1/TC0WO1/TCC0WO5/USBSOF1KHZ/GCLKIO7/CCL2IN1/PA23',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='PB03/EXTINT3/AIN11/SERCOM5PAD1/TC2WO1/SUPCVBAT',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='EXTINT6EXTWAKE6/AIN6/AIN2/Y4/OAPOS0/SERCOM0PAD2/TCC1WO0/CCL0IN2/PA06',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/EXTINT12/X12Y5/SERCOM4PAD0/TC0WO0/TCC0WO6/GCLKIO6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='EXTINT0/X4/SERCOM1PAD0/SERCOM3PAD4/TCC2WO0/TCC0WO6/GCLKIO2/CCL0IN0/PA16',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='EXTINT12/SERCOM3PAD2/SERCOM5PAD2/TC1WO1/TCC1WO2/USBDM/CCL2IN2/PA24',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='VSW',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='TC1WO1/SERCOM0P3/Y5/AIN3/AIN7/PA07',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/EXTINT13/X13Y14/SERCOM4PAD1/TC0WO1/TCC0WO7/GCLKIO7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='EXTINT1/X5/SERCOM1PAD1/SERCOM3PAD1/TCC2WO1/TCC0WO7/GCLKIO3/CCL0IN1/PA17',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='EXTINT13/SERCOM3PAD3/SERCOM5PAD3/TC1WO1/TCC1WO3/USBDP/CCL2OUT/PA25',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='VDDIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='NMI/AIN16/X0Y6/SERCOM0PAD0/SERCOM2PAD0/TCC0WO0/TCC1WO2/CCL1IN0/PA08',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/EXTINT14/X14/SERCOM4PAD2/TC1WO0/GCLKIO0/CCL3IN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='EXTINT2/X6/SERCOM1PAD2/SERCOM3PAD2/TC4WO0/TCC0WO2/ACCMP0/CCL0IN2/PA18',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='57',name='EXTINT10/SERCOM1PAD2/TCC1WO0/CORTEXM0PSWCLK/GCLKIO0/CCL1IN0/PA30',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='EXTINT9/AIN17/X1Y7/SERCOM0PAD1/SERCOM2PAD1/TCC0WO1/TCC1WO3/CCL1IN1/PA09',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/EXTINT15/X15/SERCOM4PAD3/TC1WO1/GCLKIO1/CCL3IN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='EXTINT3/X7/SERCOM1PAD3/SERCOM3PAD3/TC4WO1/TCC0WO3/ACCMP1/CCL0OUT/PA19',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='58',name='EXTINT11/SERCOM1PAD3/TCC1WO1/SWDIO/CCL1OUT/PA31',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='EXTINT10/AIN18/X2Y8/SERCOM0PAD2/SERCOM2PAD2/TCC1WO0/TCC0WO2/GCLKIO4/CCL1IN2/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='EXTINT12/SERCOM2PAD0/SERCOM4PAD0/TCC2WO0/TCC0WO6/ACCMP0/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB16/EXTINT0/SERCOM5PAD0/TC2WO0/TCC0WO4/GCLKIO2/CCL3IN3',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PB22/EXTINT6/SERCOM5PAD2/TC3WO0/GCLKIO0/CCL0IN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PB30/EXTINT14/SERCOM5PAD0/TCC0WO0/TCC1WO2',func=Pin.BIDIR,do_erc=True)])])