from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

linear = SchLib(tool=SKIDL).add_parts(*[
        Part(name='1408',dest=TEMPLATE,tool=SKIDL,keywords='CDA',description='CDA 8 bits',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='Range',do_erc=True),
            Pin(num='2',name='Gnd',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vee',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='I0',do_erc=True),
            Pin(num='5',name='A7',do_erc=True),
            Pin(num='6',name='A6',do_erc=True),
            Pin(num='7',name='A5',do_erc=True),
            Pin(num='8',name='A4',do_erc=True),
            Pin(num='9',name='A3',do_erc=True),
            Pin(num='10',name='A2',do_erc=True),
            Pin(num='11',name='A1',do_erc=True),
            Pin(num='12',name='A0',do_erc=True),
            Pin(num='13',name='Vcc',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='Vref+',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='Vref-',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='AD620',dest=TEMPLATE,tool=SKIDL,keywords='Instrumentation OpAmp',description='Instrumentation amplifier',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*', 'DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='Rg',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Ref',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='Rg',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='AD813',dest=TEMPLATE,tool=SKIDL,keywords='AmpliOp',description='Ampli Op 3 state out',ref_prefix='U',num_units=3,do_erc=True,pins=[
            Pin(num='4',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='D',do_erc=True),
            Pin(num='5',name='+',do_erc=True),
            Pin(num='6',name='-',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='D',do_erc=True),
            Pin(num='12',name='+',do_erc=True),
            Pin(num='13',name='-',do_erc=True),
            Pin(num='14',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='D',do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='-',do_erc=True),
            Pin(num='10',name='+',do_erc=True)]),
        Part(name='AD8202',dest=TEMPLATE,tool=SKIDL,keywords='highside HS current sense amplifier linear buffered monitor preamp',description='45V High Voltage, Precision Difference Amplifier, 10V/V x 2V/V adjustable gain, bandwidth 70kHz, Vcc=5V, unidirectional',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*', 'MSSOP*Pitch0.65mm*'],do_erc=True,aliases=['AD8208'],pins=[
            Pin(num='1',name='-IN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='A1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='A2',do_erc=True),
            Pin(num='5',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='+Vs',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='+IN',do_erc=True)]),
        Part(name='AD8203',dest=TEMPLATE,tool=SKIDL,keywords='highside HS current sense amplifier linear buffered monitor preamp',description='45V High Voltage, Precision Difference Amplifier, 7V/V x 2V/V adjustable gain, bandwidth 80kHz, Vcc=5V, unidirectional',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*', 'MSSOP*Pitch0.65mm*'],do_erc=True,aliases=['AD8209'],pins=[
            Pin(num='1',name='-IN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='A1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='A2',do_erc=True),
            Pin(num='5',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='+Vs',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='+IN',do_erc=True)]),
        Part(name='AD8207',dest=TEMPLATE,tool=SKIDL,keywords='highside HS current sense difference amplifier linear buffered',description='65V (35V) Zero-Drift, High Voltage, Bidirectional, Difference Amplifier, 20V/V gain, bandwidth 150kHz, Vcc=5V (3.3V),',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='-IN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vref2',do_erc=True),
            Pin(num='4',name='RANGE',do_erc=True),
            Pin(num='5',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='Vref1',do_erc=True),
            Pin(num='8',name='+IN',do_erc=True)]),
        Part(name='AD8210',dest=TEMPLATE,tool=SKIDL,keywords='HS difference amplifier linear',description='65V High Bandwidth, Bidirectional Difference Amplifier, 3V/V gain, bandwidth 3MHz, Vcc=5V',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*'],do_erc=True,aliases=['AD8216', 'AD8205', 'AD8206'],pins=[
            Pin(num='1',name='-IN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vref2',do_erc=True),
            Pin(num='4',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='Vref1',do_erc=True),
            Pin(num='8',name='+IN',do_erc=True)]),
        Part(name='AD8211',dest=TEMPLATE,tool=SKIDL,keywords='highside HS current sense amplifier linear buffered',description='65V High Voltage, Current Shunt Monitor, 20V/V gain, bandwidth 500kHz, Vcc=5V',ref_prefix='U',num_units=1,fplist=['SOT*'],do_erc=True,pins=[
            Pin(num='1',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vin+',do_erc=True),
            Pin(num='4',name='Vin-',do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AD8212',dest=TEMPLATE,tool=SKIDL,keywords='highside HS current sense shunt monitor amplifier linear',description='65V High Voltage Current, Shunt Monitor, adjustable gain, bandwidth 1000kHz, Vcc=7V~65V, current output, unidirectional',ref_prefix='U',num_units=1,fplist=['MSOP*'],do_erc=True,pins=[
            Pin(num='1',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='COM',do_erc=True),
            Pin(num='3',name='BIAS',do_erc=True),
            Pin(num='4',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='5',name='Iout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='ALPHA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='Vsns',do_erc=True)]),
        Part(name='AD8213',dest=TEMPLATE,tool=SKIDL,keywords='highside HS current sense amplifier linear buffered dual monitor',description='65V Dual, High Voltage, Current Shunt Monitor, 20V/V gain, bandwidth 500kHz, Vcc=5V',ref_prefix='U',num_units=2,fplist=['MSOP*'],do_erc=True,pins=[
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='CF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='+IN',do_erc=True),
            Pin(num='10',name='-IN',do_erc=True),
            Pin(num='1',name='-IN',do_erc=True),
            Pin(num='2',name='+IN',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='CF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AD8215',dest=TEMPLATE,tool=SKIDL,keywords='highside HS current sense amplifier linear buffered monitor',description='65V High Voltage, Current Shunt Monitor, 20V/V gain, bandwidth 450kHz, Vcc=5V, unidirectional',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='-IN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='+IN',do_erc=True)]),
        Part(name='AD8217',dest=TEMPLATE,tool=SKIDL,keywords='highside HS current sense amplifier linear buffered monitor',description='80V High Resolution, Zero-Drift, Current Shunt Monitor, 20V/V gain, bandwidth 500kHz, internal LDO, unidirectional',ref_prefix='U',num_units=1,fplist=['MSOP*'],do_erc=True,pins=[
            Pin(num='1',name='+IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='-IN',do_erc=True)]),
        Part(name='AD8218',dest=TEMPLATE,tool=SKIDL,keywords='highside HS current sense amplifier linear buffered',description='80V Zero Drift, Bidirectional, Current Shunt Monitor, 20V/V gain, bandwidth 450kHz, Vcc=5V (optional)',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*', 'LFCSP*'],do_erc=True,pins=[
            Pin(num='1',name='+IN',do_erc=True),
            Pin(num='2',name='Vs',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='ENB',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='REF',do_erc=True),
            Pin(num='8',name='-IN',do_erc=True)]),
        Part(name='AD8219',dest=TEMPLATE,tool=SKIDL,keywords='highside HS current sense amplifier linear buffered monitor',description='80V Zero Drift, Unidirectional, Current Shunt Monitor, 60V/V gain, bandwidth 500kHz, Vcc=4V~80V',ref_prefix='U',num_units=1,fplist=['MSOP*'],do_erc=True,pins=[
            Pin(num='1',name='+IN',do_erc=True),
            Pin(num='2',name='Vs',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='-IN',do_erc=True)]),
        Part(name='AD8417',dest=TEMPLATE,tool=SKIDL,keywords='highside HS current sense amplifier linear',description='70V Bidirectional, Zero Drift, Current Sense Amplifier, 20V/V gain, bandwidth 250kHz, VS=2.7V~5.5V',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*', 'MSOP*'],do_erc=True,aliases=['AD8418'],pins=[
            Pin(num='1',name='IN-',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='REF2',do_erc=True),
            Pin(num='4',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='REF1',do_erc=True),
            Pin(num='8',name='IN+',do_erc=True)]),
        Part(name='ADCMP350',dest=TEMPLATE,tool=SKIDL,keywords='comparator',description='Single-input comparator, internal 0.6V reference, Active-Low Open-Drain output, SC-70-4 package',ref_prefix='U',num_units=1,fplist=['SC-70*'],do_erc=True,pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='4',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ADCMP354',dest=TEMPLATE,tool=SKIDL,keywords='comparator',description='Single-input comparator, internal 0.6V reference, Active-High Open-Drain output, SC-70-4 package',ref_prefix='U',num_units=1,fplist=['SC-70*'],do_erc=True,pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='4',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ADCMP356',dest=TEMPLATE,tool=SKIDL,keywords='comparator',description='Single-input comparator, internal 0.6V reference, Active-High Push-Pull output, SC-70-4 package',ref_prefix='U',num_units=1,fplist=['SC-70*'],do_erc=True,pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='CA3080',dest=TEMPLATE,tool=SKIDL,keywords='intersil',description='2MHz, Operational Transconductance Amplifier (OTA), gM spread 1.6:1',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,aliases=['CA3080A'],pins=[
            Pin(num='2',name='INV.INPUT',do_erc=True),
            Pin(num='3',name='NOT-INV.INPUT',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='AMPLIFIER_BIAS_INPUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='OUTPUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='CA3130',dest=TEMPLATE,tool=SKIDL,keywords='AmpliOp Mos',description='4.5MHz, BiMOS Operational Amplifier with MOSFET Input/Bipolar Output',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC*Pitch1.27mm*'],do_erc=True,aliases=['CA3140'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='INA128',dest=TEMPLATE,tool=SKIDL,keywords='Instrumentation OpAmp',description='Precision, Low Power Instrumentation Amplifier G = 1 + 49.4kOhm/Rg',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC*Pitch1.27mm*'],do_erc=True,aliases=['INA129'],pins=[
            Pin(num='1',name='Rg',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Ref',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='Rg',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='INA326',dest=TEMPLATE,tool=SKIDL,keywords='Instrumentation OpAmp',description='Precision, Rail-to-Rail I/O Instrumentation Amplifier, MSOP-8 package',ref_prefix='U',num_units=1,fplist=['MSOP*3x3mm?Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='R1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='R2',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='R1',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='INA327',dest=TEMPLATE,tool=SKIDL,keywords='Instrumentation OpAmp',description='Precision, Rail-to-Rail I/O Instrumentation Amplifier, MSOP-10 package',ref_prefix='U',num_units=1,fplist=['MSOP*3x3mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='R1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='EN',do_erc=True),
            Pin(num='7',name='R2',do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='R1',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='L272D',dest=TEMPLATE,tool=SKIDL,keywords='ampliop Power OpAMP',description='Dual Power Op amp, SO-16',ref_prefix='U',num_units=2,fplist=['*SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='9',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='10',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='15',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='16',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='+',do_erc=True),
            Pin(num='14',name='-',do_erc=True),
            Pin(num='5',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='-',do_erc=True),
            Pin(num='12',name='+',do_erc=True)]),
        Part(name='L272M',dest=TEMPLATE,tool=SKIDL,keywords='ampliop Power OpAMP',description='Dual Power Op amp',ref_prefix='U',num_units=2,fplist=['*DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='2',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='+',do_erc=True),
            Pin(num='8',name='-',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='-',do_erc=True),
            Pin(num='6',name='+',do_erc=True)]),
        Part(name='LF398',dest=TEMPLATE,tool=SKIDL,description='Sample & hold',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='V+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='I',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Cap',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='T',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='Hold',do_erc=True)]),
        Part(name='LH0002H',dest=TEMPLATE,tool=SKIDL,keywords='Buffer',description='High speed analog Buffer',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='IN',do_erc=True)]),
        Part(name='LM13700',dest=TEMPLATE,tool=SKIDL,keywords='National OTA',description='Dual Operational Transconductance Amplifiers with Linearizing Diodes and Buffers',ref_prefix='U',num_units=4,fplist=['DIP*W7.62mm*'],do_erc=True,aliases=['LM13600'],pins=[
            Pin(num='6',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='OUTPUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='INPUT(-)',do_erc=True),
            Pin(num='14',name='INPUT(+)',do_erc=True),
            Pin(num='15',name='DIODE_BIAS',do_erc=True),
            Pin(num='16',name='AMP_BIAS_INPUT',do_erc=True),
            Pin(num='9',name='BUFFER_OUTPUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='BUFFER_INPUT',do_erc=True),
            Pin(num='1',name='AMP_BIAS_INPUT',do_erc=True),
            Pin(num='2',name='DIODE_BIAS',do_erc=True),
            Pin(num='3',name='INPUT(+)',do_erc=True),
            Pin(num='4',name='INPUT(-)',do_erc=True),
            Pin(num='5',name='OUTPUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='BUFFER_INPUT',do_erc=True),
            Pin(num='8',name='BUFFER_OUTPUT',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LM2902N',dest=TEMPLATE,tool=SKIDL,keywords='AmpliOp Mos',description='Precision Quad Op amp. Mos',ref_prefix='U',num_units=4,fplist=['SOIC*Pitch1.27mm*', 'DIP*W7.62mm*', 'TSSOP*4.4x5mm*Pitch0.65mm*', 'SSOP*', 'MSOP*'],do_erc=True,aliases=['LM324', 'TLC274', 'TL074', 'LM324N', 'LM324AN', 'MCP6004', 'TL084', 'TL064', 'LMV324', 'LMC6484', 'MCP604'],pins=[
            Pin(num='4',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='5',name='+',do_erc=True),
            Pin(num='6',name='-',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='-',do_erc=True),
            Pin(num='10',name='+',do_erc=True),
            Pin(num='12',name='+',do_erc=True),
            Pin(num='13',name='-',do_erc=True),
            Pin(num='14',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LM2903',dest=TEMPLATE,tool=SKIDL,keywords='Comp',description='Dual Voltage Comparator',ref_prefix='U',num_units=2,fplist=['SOIC*Pitch1.27mm*', 'DIP*W7.62mm*'],do_erc=True,aliases=['LM293', 'LM393', 'LM193'],pins=[
            Pin(num='1',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='_',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='+',do_erc=True),
            Pin(num='6',name='_',do_erc=True),
            Pin(num='7',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LM2903small',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='LM311N',dest=TEMPLATE,tool=SKIDL,keywords='comp',description='Voltage Comparator',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*', 'DIP*W7.62mm*', 'TSSOP*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='GND',do_erc=True),
            Pin(num='2',name='+',do_erc=True),
            Pin(num='3',name='-',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='BAL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LM318N',dest=TEMPLATE,tool=SKIDL,keywords='AmpliOp',description='ampli Op',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*', 'DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='FIN2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='FOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='FIN1',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LM319',dest=TEMPLATE,tool=SKIDL,keywords='comp',description='Dual voltage comparator (high speed)',ref_prefix='U',num_units=2,do_erc=True,aliases=['LM319N'],pins=[
            Pin(num='6',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Gnd1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='+',do_erc=True),
            Pin(num='5',name='-',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='Gnd1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='+',do_erc=True),
            Pin(num='10',name='-',do_erc=True)]),
        Part(name='LM319H',dest=TEMPLATE,tool=SKIDL,keywords='comp',description='Dual voltage comparator (high speed)',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='5',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='Gnd1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='-',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Gnd1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='+',do_erc=True),
            Pin(num='9',name='-',do_erc=True)]),
        Part(name='LM321',dest=TEMPLATE,tool=SKIDL,keywords='opamp',description='Low Power Single Operational Amplifier',ref_prefix='U',num_units=1,fplist=['SOT?23*'],do_erc=True,pins=[
            Pin(num='1',name='+',do_erc=True),
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='-',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LM339',dest=TEMPLATE,tool=SKIDL,keywords='Comp diff',description='Quad comparator.',ref_prefix='U',num_units=4,fplist=['SOIC*3.9x8.7mm*Pitch1.27mm*', 'DIP*W7.62mm*', 'SSOP*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='3',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='4',name='-',do_erc=True),
            Pin(num='5',name='+',do_erc=True),
            Pin(num='1',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='6',name='-',do_erc=True),
            Pin(num='7',name='+',do_erc=True),
            Pin(num='10',name='-',do_erc=True),
            Pin(num='11',name='+',do_erc=True),
            Pin(num='13',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='-',do_erc=True),
            Pin(num='9',name='+',do_erc=True),
            Pin(num='14',name='~',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='LM358',dest=TEMPLATE,tool=SKIDL,keywords='ampliop',description='Dual Rail-to-rail CMOS Operational Amplifier',ref_prefix='U',num_units=2,fplist=['SOIC*Pitch1.27mm*', 'DIP*W7.62mm*', 'TSSOP*Pitch0.65mm*', 'TO-99*', 'DSBGA*'],do_erc=True,aliases=['LMC6062', 'LMC6082', 'LM358N', 'TL072', 'TL082', 'NE5532', '4558', 'LMV358', 'TS912', 'TLC272', 'MCP602'],pins=[
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='5',name='+',do_erc=True),
            Pin(num='6',name='-',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LM386',dest=TEMPLATE,tool=SKIDL,keywords='Audio Power OpAmp',description='Low Voltage Audio Power Amp.',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*', 'DIP*W7.62mm*', 'MSSOP*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='Gnd',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True)]),
        Part(name='LM4250',dest=TEMPLATE,tool=SKIDL,keywords='Programmable OPAMP',description='Programmable Operational Amplifier',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='QCS~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='~',do_erc=True)]),
        Part(name='LM555N',dest=TEMPLATE,tool=SKIDL,keywords='opamp, rail-to-rail',description='Dual Op amp, rail-to-rail, 8MHz, MSOP8, SOIC8',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*', 'DIP*W7.62mm*', 'TSSOP*Pitch0.65mm*'],do_erc=True,aliases=['NE555', 'ICM7555', 'LMC555', 'TLC555', 'NA555', 'SE555', 'SA555'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TR',do_erc=True),
            Pin(num='3',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='R',do_erc=True),
            Pin(num='5',name='CV',do_erc=True),
            Pin(num='6',name='THR',do_erc=True),
            Pin(num='7',name='DIS',do_erc=True)]),
        Part(name='LM6161',dest=TEMPLATE,tool=SKIDL,keywords='AmpliOp',description='Op Amp.',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*', 'DIP*W7.62mm*'],do_erc=True,aliases=['LM6361', 'LM6261'],pins=[
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LM733CH',dest=TEMPLATE,tool=SKIDL,keywords='Video Diff',description='Differential Video amp',ref_prefix='U',num_units=1,fplist=['TO-5*'],do_erc=True,pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='V_',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LM741',dest=TEMPLATE,tool=SKIDL,keywords='AmpliOp',description='JFET-Input Operational Amplifiers',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*', 'DIP*W7.62mm*', 'TSSOP*Pitch0.65mm*'],do_erc=True,aliases=['LF155', 'LF156', 'LF256', 'LF257', 'LF355', 'LF356', 'LF357', 'TL081', 'TL061', 'TL071'],pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='LMV321',dest=TEMPLATE,tool=SKIDL,keywords='ampliop',description='Low-Voltage Rail-to-Rail Output Operational Amplifiers',ref_prefix='U',num_units=1,fplist=['SOT-23*', 'SC-70*'],do_erc=True,pins=[
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='+',do_erc=True),
            Pin(num='3',name='-',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LMV601',dest=TEMPLATE,tool=SKIDL,keywords='op amp amplifier operational',description='Low Power, general purpose Op Amp, SC-70-6 package',ref_prefix='U',num_units=1,fplist=['*SC-70*'],do_erc=True,pins=[
            Pin(num='1',name='+',do_erc=True),
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='-',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~SD',do_erc=True),
            Pin(num='6',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LT1492',dest=TEMPLATE,tool=SKIDL,keywords='operational amplifier opamp Precision',description='Dual Low Power Single-Supply Precision OpAmps, 5MHz FBP, 3V/µs SR',ref_prefix='U',num_units=2,fplist=['SOIC*Pitch1.27mm*', 'DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='5',name='+',do_erc=True),
            Pin(num='6',name='-',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LT1493',dest=TEMPLATE,tool=SKIDL,keywords='operational amplifier opamp Precision',description='Quad Low Power Single-Supply Precision OpAmps, 5MHz FBP, 3V/µs SR, SSOP package',ref_prefix='U',num_units=4,fplist=['SOIC*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='4',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='9',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='13',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='5',name='+',do_erc=True),
            Pin(num='6',name='-',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='-',do_erc=True),
            Pin(num='12',name='+',do_erc=True),
            Pin(num='14',name='+',do_erc=True),
            Pin(num='15',name='-',do_erc=True),
            Pin(num='16',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LT5560',dest=TEMPLATE,tool=SKIDL,keywords='Mixer, RF',description='0.01MHz to 4GHz Low Power Active Mixer',ref_prefix='U',num_units=1,fplist=['DFN*3x3mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='LO-',do_erc=True),
            Pin(num='2',name='EN',do_erc=True),
            Pin(num='3',name='IN+',do_erc=True),
            Pin(num='4',name='IN-',do_erc=True),
            Pin(num='5',name='OUT-',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='OUT+',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='LO+',do_erc=True),
            Pin(num='9',name='PGND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LT6106',dest=TEMPLATE,tool=SKIDL,keywords='current sense highside HS shunt monitor amplifier linear',description='36V high side current sense amplifier, adjustable gain, bandwidth 200kHz, Vcc=2.7V~36V, current output, unidirectional',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='-',do_erc=True),
            Pin(num='4',name='+',do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC4414',dest=TEMPLATE,tool=SKIDL,keywords='switch power FET',description='Controller for Large PFETs',ref_prefix='U',num_units=1,fplist=['MSOP*3x3mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='STAT',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='CTL',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='SENSE',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='GATE',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LTC6082',dest=TEMPLATE,tool=SKIDL,keywords='LTC6082 opamp ltc',description='Precision Quad Op amp.',ref_prefix='U',num_units=4,fplist=['ssop', 'dfn'],do_erc=True,pins=[
            Pin(num='4',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='5',name='+',do_erc=True),
            Pin(num='6',name='-',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='-',do_erc=True),
            Pin(num='12',name='+',do_erc=True),
            Pin(num='14',name='+',do_erc=True),
            Pin(num='15',name='-',do_erc=True),
            Pin(num='16',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LTC6102xDD',dest=TEMPLATE,tool=SKIDL,keywords='current sensor amplifier shunt monitoring high side',description='Precision zero drift current sense amplifier, 60V supply, DFN-8 package',ref_prefix='U',num_units=1,fplist=['DFN*Pitch0.5mm*'],do_erc=True,aliases=['LTC6102HVxDD'],pins=[
            Pin(num='1',name='-INS',do_erc=True),
            Pin(num='2',name='-INF',do_erc=True),
            Pin(num='3',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VREG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='+IN',do_erc=True),
            Pin(num='9',name='V-',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC6102xDD-1',dest=TEMPLATE,tool=SKIDL,keywords='current sensor amplifier shunt monitoring high side',description='Precision zero drift current sense amplifier, 60V supply, disable mode, DFN-8 package',ref_prefix='U',num_units=1,fplist=['DFN*Pitch0.5mm*'],do_erc=True,aliases=['LTC6102HVxDD-1'],pins=[
            Pin(num='1',name='-INS',do_erc=True),
            Pin(num='2',name='-INF',do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='4',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VREG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='+IN',do_erc=True),
            Pin(num='9',name='V-',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC6102xMS8',dest=TEMPLATE,tool=SKIDL,keywords='current sensor amplifier shunt monitoring high side',description='Precision zero drift current sense amplifier, 60V supply, MSOP-8 package',ref_prefix='U',num_units=1,fplist=['MSOP*Pitch0.65mm*'],do_erc=True,aliases=['LTC6102HVxMS8'],pins=[
            Pin(num='1',name='-INS',do_erc=True),
            Pin(num='2',name='-INF',do_erc=True),
            Pin(num='3',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VREG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='+IN',do_erc=True)]),
        Part(name='LTC6102xMS8-1',dest=TEMPLATE,tool=SKIDL,keywords='current sensor amplifier shunt monitoring high side',description='Precision zero drift current sense amplifier, 60V supply, disable mode, MSOP-8 package',ref_prefix='U',num_units=1,fplist=['MSOP*Pitch0.65mm*'],do_erc=True,aliases=['LTC6102HVxMS8-1'],pins=[
            Pin(num='1',name='-INS',do_erc=True),
            Pin(num='2',name='-INF',do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='4',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VREG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='+IN',do_erc=True)]),
        Part(name='LTC6362',dest=TEMPLATE,tool=SKIDL,keywords='linear ltc diff amp',description='Precision differential amplifier for dirving high resolution SAR ADCs',ref_prefix='U',num_units=1,fplist=['DFN*1EP*3x3mm*Pitch0.65mm*', 'MSOP*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True)]),
        Part(name='MAX4080F',dest=TEMPLATE,tool=SKIDL,keywords='telecom automotive backplane external reference',description='76V current sense amplifier, high side, unidirectional, 20V/V gain',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*', 'MSOP*Pitch0.65mm*'],do_erc=True,aliases=['MAX4080T', 'MAX4080S'],pins=[
            Pin(num='1',name='RS+',do_erc=True),
            Pin(num='2',name='Vcc',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='RS-',do_erc=True)]),
        Part(name='MAX4081F',dest=TEMPLATE,tool=SKIDL,keywords='telecom automotive backplane external reference',description='76V current sense amplifier, high side, bidirectional, 20V/V gain',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*', 'MSOP*Pitch0.65mm*'],do_erc=True,aliases=['MAX4081T', 'MAX4081S'],pins=[
            Pin(num='1',name='RS+',do_erc=True),
            Pin(num='2',name='Vcc',do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='GND',do_erc=True),
            Pin(num='5',name='OUT',do_erc=True),
            Pin(num='6',name='REF1B',do_erc=True),
            Pin(num='7',name='REF1A',do_erc=True),
            Pin(num='8',name='RS-',do_erc=True)]),
        Part(name='MAX4238ASA',dest=TEMPLATE,tool=SKIDL,keywords='Ampliop',description='Ultra-Low Offset/Drift, Low-Noise, Precision Amplifier, GBP=6.5MHz, SO-8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm'],do_erc=True,aliases=['MAX4239ASA'],pins=[
            Pin(num='1',name='~SHDN',do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='MAX4238AUT',dest=TEMPLATE,tool=SKIDL,keywords='Ampliop',description='Ultra-Low Offset/Drift, Low-Noise, Precision Amplifier, GBP=6.5MHz, SOT23',ref_prefix='U',num_units=1,fplist=['SOT?23*'],do_erc=True,aliases=['MAX4239AUT'],pins=[
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='-',do_erc=True),
            Pin(num='5',name='~SHDN',do_erc=True),
            Pin(num='6',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MAX471',dest=TEMPLATE,tool=SKIDL,description='High-Side Current-Sense Amplifier',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SHDN',do_erc=True),
            Pin(num='2',name='RS+',do_erc=True),
            Pin(num='3',name='RS+',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SIGN',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='6',name='RS-',do_erc=True),
            Pin(num='7',name='RS-',do_erc=True),
            Pin(num='8',name='OUT',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='MAX472',dest=TEMPLATE,tool=SKIDL,description='High-Side Current-Sense Amplifier',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SHDN',do_erc=True),
            Pin(num='3',name='SENSE+',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SIGN',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='6',name='SENSE-',do_erc=True),
            Pin(num='7',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='OUT',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='MC33178',dest=TEMPLATE,tool=SKIDL,keywords='ampliop',description='Dual Op amp (low power)',ref_prefix='U',num_units=2,fplist=['SOIC*Pitch1.27mm*', 'DIP*W7.62mm*', 'SSOP*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='5',name='+',do_erc=True),
            Pin(num='6',name='-',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='MCP6001',dest=TEMPLATE,tool=SKIDL,keywords='op amp amplifier operational',description='Op Amp in 5-pin package',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='-',do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP6001R',dest=TEMPLATE,tool=SKIDL,keywords='op amp amplifier operational',description='Op Amp in 5-pin package',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='-',do_erc=True),
            Pin(num='5',name='V-',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP601OT',dest=TEMPLATE,tool=SKIDL,keywords='op amp amplifier operational',description='2.7V to 6.0V Single Supply CMOS Operational Amplifier, SOT-23-5',ref_prefix='U',num_units=1,fplist=['SOT?23*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='-',do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP601P',dest=TEMPLATE,tool=SKIDL,keywords='CMOS Single-Supply OPAMP Ampliop',description='2.7V to 6.0V Single Supply CMOS Operational Amplifier, DIP-8',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='MCP601R',dest=TEMPLATE,tool=SKIDL,keywords='CMOS Single-Supply OPAMP Ampliop',description='2.7V to 6.0V Single Supply CMOS Operational Amplifier, SOT-23-5',ref_prefix='U',num_units=1,fplist=['SOT*23*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='-',do_erc=True),
            Pin(num='5',name='V-',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP601SN',dest=TEMPLATE,tool=SKIDL,keywords='CMOS Single-Supply OPAMP Ampliop',description='2.7V to 6.0V Single Supply CMOS Operational Amplifier, SO-8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='MCP601ST',dest=TEMPLATE,tool=SKIDL,keywords='CMOS Single-Supply OPAMP Ampliop',description='2.7V to 6.0V Single Supply CMOS Operational Amplifier, TSSOP-8',ref_prefix='U',num_units=1,fplist=['TSSOP*4.4x3mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='MCP603',dest=TEMPLATE,tool=SKIDL,keywords='CMOS Single-Supply OPAMP Ampliop',description='Dual 2.7V to 6.0V Single Supply CMOS Operational Amplifier, SOT-23-6',ref_prefix='U',num_units=1,fplist=['SOT*23*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='-',do_erc=True),
            Pin(num='5',name='~CS',do_erc=True),
            Pin(num='6',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP603P',dest=TEMPLATE,tool=SKIDL,keywords='CMOS Single-Supply OPAMP Ampliop',description='2.7V to 6.0V Single Supply CMOS Operational Amplifier, with Chip Select, DIP-8',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='~CS',do_erc=True)]),
        Part(name='MCP603SN',dest=TEMPLATE,tool=SKIDL,keywords='CMOS Single-Supply OPAMP Ampliop',description='2.7V to 6.0V Single Supply CMOS Operational Amplifier, with Chip Select, SO-8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='~CS',do_erc=True)]),
        Part(name='MCP603ST',dest=TEMPLATE,tool=SKIDL,keywords='CMOS Single-Supply OPAMP Ampliop',description='2.7V to 6.0V Single Supply CMOS Operational Amplifier, with Chip Select, TSSOP-8',ref_prefix='U',num_units=1,fplist=['TSSOP*4.4x3mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='~CS',do_erc=True)]),
        Part(name='MCP6562',dest=TEMPLATE,tool=SKIDL,keywords='comparator, low power, push-pull',description='Dual low power push-pull output comparator',ref_prefix='U',num_units=2,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*', 'MSOP*3x3mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='5',name='+',do_erc=True),
            Pin(num='6',name='-',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='MCP6566',dest=TEMPLATE,tool=SKIDL,keywords='comparator low power open drain',description='Low power open drain output comparator',ref_prefix='U',num_units=1,fplist=['SOT-23-*', 'SC?70*'],do_erc=True,pins=[
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='-',do_erc=True)]),
        Part(name='MCP6566R',dest=TEMPLATE,tool=SKIDL,keywords='comparator low power open drain',description='Low power open drain output comparator',ref_prefix='U',num_units=1,fplist=['SOT-23-*'],do_erc=True,pins=[
            Pin(num='2',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='-',do_erc=True)]),
        Part(name='MCP6566U',dest=TEMPLATE,tool=SKIDL,keywords='comparator low power open drain',description='Low power open drain output comparator',ref_prefix='U',num_units=1,fplist=['SOT-23-*'],do_erc=True,pins=[
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='+',do_erc=True),
            Pin(num='3',name='-',do_erc=True),
            Pin(num='4',name='~',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='MCP6567',dest=TEMPLATE,tool=SKIDL,keywords='comparator, low power, open drain',description='Dual low power open drain output comparator',ref_prefix='U',num_units=2,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*', 'MSOP*3x3mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='5',name='+',do_erc=True),
            Pin(num='6',name='-',do_erc=True),
            Pin(num='7',name='~',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='MCP6L91',dest=TEMPLATE,tool=SKIDL,keywords='opamp rail-to-rail',description='Rail-to-rail Op Amp, 10MHz, SOT-23-5',ref_prefix='U',num_units=1,fplist=['SOT-23-*'],do_erc=True,pins=[
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='-',do_erc=True)]),
        Part(name='MCP6L91R',dest=TEMPLATE,tool=SKIDL,keywords='opamp rail-to-rail',description='Rail-to-rail Op Amp, 10MHz, SOT-23-5',ref_prefix='U',num_units=1,fplist=['SOT-23-*'],do_erc=True,pins=[
            Pin(num='2',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='-',do_erc=True)]),
        Part(name='MIC845H',dest=TEMPLATE,tool=SKIDL,keywords='comparator',description='Precision single-input comparator, internal 2.55V reference, Active-High Push-Pull output, SC-70-5 package',ref_prefix='U',num_units=1,fplist=['SC-70*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MIC845L',dest=TEMPLATE,tool=SKIDL,keywords='comparator',description='Precision single-input comparator, internal 2.55V reference, Active-Low Push-Pull output, SC-70-5 package',ref_prefix='U',num_units=1,fplist=['SC-70*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MIC845N',dest=TEMPLATE,tool=SKIDL,keywords='comparator',description='Precision single-input comparator, internal 2.55V reference, Open Drain Output, SC-70-5 package',ref_prefix='U',num_units=1,fplist=['SC-70*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='NCS210',dest=TEMPLATE,tool=SKIDL,keywords='Current sensor shunt monitor',description='Bidirectional zero-drift current shunt, 75V/V gain, -0.3V to +26V common mode range',ref_prefix='U',num_units=1,fplist=['SC-70*'],do_erc=True,aliases=['NCS212', 'NCS211', 'NCS213', 'NCS214', 'NCS215'],pins=[
            Pin(num='1',name='REF',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vs',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='+IN',do_erc=True),
            Pin(num='5',name='-IN',do_erc=True),
            Pin(num='6',name='OUT',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='NE5534',dest=TEMPLATE,tool=SKIDL,keywords='Low-Noise OPAMP',description='Low-Noise High-Speed Audio Operational Amplifier',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['SA5534', 'LM101', 'LM201', 'LM301'],pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='~',do_erc=True)]),
        Part(name='NE556',dest=TEMPLATE,tool=SKIDL,keywords='timer',description='double 555-series timer IC',ref_prefix='U',num_units=2,fplist=['DIP*W7.62mm*', 'TSSOP*Pitch0.65mm*', 'SOIC*Pitch1.27mm*'],do_erc=True,aliases=['NA556', 'SA556', 'SE556', 'ICM7556'],pins=[
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='DIS',do_erc=True),
            Pin(num='2',name='THR',do_erc=True),
            Pin(num='3',name='CV',do_erc=True),
            Pin(num='4',name='R',do_erc=True),
            Pin(num='5',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='TR',do_erc=True),
            Pin(num='8',name='TR',do_erc=True),
            Pin(num='9',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='R',do_erc=True),
            Pin(num='11',name='CV',do_erc=True),
            Pin(num='12',name='THR',do_erc=True),
            Pin(num='13',name='DIS',do_erc=True)]),
        Part(name='NE567',dest=TEMPLATE,tool=SKIDL,keywords='tone decoder PLL',description='Tone decoder/phase-locked loop',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['SE567'],pins=[
            Pin(num='1',name='OFLT_C',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='LP_FLT_C',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='INPUT',do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='TIM_R',do_erc=True),
            Pin(num='6',name='TIM_RC',do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='OUTPUT',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='OP07',dest=TEMPLATE,tool=SKIDL,keywords='Low-Offset OPAMP',description='Ultra-Low Offset Voltage Operational Amplifier',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC*3.9x4.9mm*Pitch1.27mm*', 'TO?99*'],do_erc=True,aliases=['OP077', 'LT1363'],pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='~',do_erc=True)]),
        Part(name='OP275',dest=TEMPLATE,tool=SKIDL,keywords='ampliop',description='Dual Op amp (low power)',ref_prefix='U',num_units=2,fplist=['DIP*W7.62mm*', 'SOIC*3.9x4.9mm*Pitch1.27mm*', 'SOP*', 'LFCSP*'],do_erc=True,aliases=['ADA4075', 'MCP6002', 'LM7332'],pins=[
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='5',name='+',do_erc=True),
            Pin(num='6',name='-',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='OPA2333D',dest=TEMPLATE,tool=SKIDL,keywords='ampliop',description='Dual CMOS Operational Amplifiers, Zero-Drift Series, 1.8-V, microPower',ref_prefix='U',num_units=2,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm', 'MSOP*3x3mm?Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='5',name='+',do_erc=True),
            Pin(num='6',name='-',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='OPA2340',dest=TEMPLATE,tool=SKIDL,keywords='ampliop',description='Dual Single-Supply, Rail-to-Rail Operational Amplifier, MicroAmplifier™ Series',ref_prefix='U',num_units=2,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm', 'MSOP*3x3mm?Pitch0.65mm*', 'DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='5',name='+',do_erc=True),
            Pin(num='6',name='-',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='OPA333D',dest=TEMPLATE,tool=SKIDL,keywords='Ampliop',description='Single-Supply, Rail-to-Rail Operational Amplifier, MicroAmplifier™ Series',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['OPA340D'],pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='OPA333DBV',dest=TEMPLATE,tool=SKIDL,keywords='Ampliop',description='Single-Supply, Rail-to-Rail Operational Amplifier, MicroAmplifier™ Series',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,aliases=['OPA340DBV'],pins=[
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='-',do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='OPA333DCK',dest=TEMPLATE,tool=SKIDL,keywords='CMOS Ampliop',description='CMOS Operational Amplifier, Zero-Drift Series, 1.8-V, microPower, SC70-5',ref_prefix='U',num_units=1,fplist=['SC?70*'],do_erc=True,pins=[
            Pin(num='1',name='+',do_erc=True),
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='-',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='OPA340P',dest=TEMPLATE,tool=SKIDL,keywords='Ampliop',description='CMOS Operational Amplifiers, Zero-Drift Series, 1.8-V, microPower, DIP8 package',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='OPA376AIDCK',dest=TEMPLATE,tool=SKIDL,keywords='op amp amplifier operational',description='Op Amp in 5-pin package',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='+',do_erc=True),
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='-',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='OPA4340D',dest=TEMPLATE,tool=SKIDL,keywords='AmpliOp',description='Quad Single-Supply, Rail-to-Rail Operational Amplifier, MicroAmplifier™ Series',ref_prefix='U',num_units=4,fplist=['SOIC*3.9x8.7mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='4',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='5',name='+',do_erc=True),
            Pin(num='6',name='-',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='-',do_erc=True),
            Pin(num='10',name='+',do_erc=True),
            Pin(num='12',name='+',do_erc=True),
            Pin(num='13',name='-',do_erc=True),
            Pin(num='14',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='OPA4340DBQ',dest=TEMPLATE,tool=SKIDL,keywords='AmpliOp',description='Quad Single-Supply, Rail-to-Rail Operational Amplifier, MicroAmplifier™ Series',ref_prefix='U',num_units=4,fplist=['SSOP*4.4x5.2mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='4',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='9',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='13',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='5',name='+',do_erc=True),
            Pin(num='6',name='-',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='-',do_erc=True),
            Pin(num='12',name='+',do_erc=True),
            Pin(num='14',name='+',do_erc=True),
            Pin(num='15',name='-',do_erc=True),
            Pin(num='16',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='TS881',dest=TEMPLATE,tool=SKIDL,keywords='comparator',description='Rail to rail nanopower comparator',ref_prefix='U',num_units=1,fplist=['SOT-23*', 'SC-70*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='_',do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TSV911ILT',dest=TEMPLATE,tool=SKIDL,keywords='opamp rail-to-rail',description='Single Op amp, rail-to-rail, 8MHz, SOT23-5',ref_prefix='U',num_units=1,fplist=['SOT23*'],do_erc=True,pins=[
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='-',do_erc=True)]),
        Part(name='TSV912',dest=TEMPLATE,tool=SKIDL,keywords='opamp, rail-to-rail',description='Dual Op amp, rail-to-rail, 8MHz, MSOP8, SOIC8',ref_prefix='U',num_units=2,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*', 'MSOP*3x3mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='4',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='5',name='+',do_erc=True),
            Pin(num='6',name='-',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True)])])