from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

sensors = SchLib(tool=SKIDL).add_parts(*[
        Part(name='40PC015G',dest=TEMPLATE,tool=SKIDL,keywords='gage gauge pressure sensor',description='Gauge pressure sensor, 0 to 250PSI, 5V supply, 0.2% accuracy, integrated signal conditioning, excellent media compatibility',ref_prefix='U',num_units=1,do_erc=True,aliases=['40PC100G', '40PC150G', '40PC250G'],pins=[
            Pin(num='1',name='Vcc',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='A1101ELHL',dest=TEMPLATE,tool=SKIDL,keywords='hall switch',description='Hall effect switch, unipolar, Bop=340G, Brp=240G, -40C to +125C',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,aliases=['A1101LLHL', 'A1102ELHL', 'A1102LLHL', 'A1103ELHL', 'A1103LLHL', 'A1104LLHL', 'A1106LLHL'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vout',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='A1301KLHLT-T',dest=TEMPLATE,tool=SKIDL,keywords='hall switch',description='Linear Hall Effect Sensor, SOT-23W',ref_prefix='U',num_units=1,fplist=['SOT*'],do_erc=True,aliases=['A1302ELHLT-T', 'A1302KLHLT-T'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='Vout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='A1301KUA-T',dest=TEMPLATE,tool=SKIDL,keywords='hall switch',description='Linear Hall Effect Sensor, SIP 3pin',ref_prefix='U',num_units=1,do_erc=True,aliases=['A1301EUA-T', 'A1302KUA-T'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vout',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='AD8418',dest=TEMPLATE,tool=SKIDL,keywords='current sense amplifier shunt high side bidirectional',description='Bidirectional zero-drift current sense amplifier, 20V/V',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='-IN',do_erc=True),
            Pin(num='2',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VR2',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VR1',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='+IN',do_erc=True)]),
        Part(name='AS5045B',dest=TEMPLATE,tool=SKIDL,keywords='Magnetic Hall Encoder',description='Magnetic Position Sensor, 12-bit, PWM Output, ABI Output, SPI Interface',ref_prefix='U',num_units=1,fplist=['SSOP*16_5.3x6.2mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='MagINCn',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='MagDECn',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='3',name='A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='B',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='I',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='PDIO',do_erc=True),
            Pin(num='9',name='DO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='CLK',do_erc=True),
            Pin(num='11',name='CSn',do_erc=True),
            Pin(num='12',name='PWM',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='14',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='15',name='VDD3V3',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD5V',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AS5048A',dest=TEMPLATE,tool=SKIDL,keywords='sensor magnetic hall position rotation spi',description='Magnetic position sensor, 14-bit, PWM output, SPI Interface',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='~CSn',do_erc=True),
            Pin(num='2',name='CLK',do_erc=True),
            Pin(num='3',name='MISO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='MOSI',do_erc=True),
            Pin(num='5',name='TEST',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='TEST',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='TEST',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='TEST',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='TEST',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='TEST',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='VDD5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VDD3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PWM',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='AS5048B',dest=TEMPLATE,tool=SKIDL,keywords='sensor magnetic hall position rotation i2c',description='Magnetic position sensor, 14-bit, PWM output, I2C Interface',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='SCL',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='A1',do_erc=True),
            Pin(num='5',name='TEST',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='TEST',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='TEST',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='TEST',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='TEST',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='TEST',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='VDD5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VDD3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PWM',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='AS5055A',dest=TEMPLATE,tool=SKIDL,keywords='sensor magnetic hall position rotation spi',description='Magnetic position sensor, 12-bit, SPI interface',ref_prefix='U',num_units=1,fplist=['QFN*'],do_erc=True,aliases=['AS5050A'],pins=[
            Pin(num='1',name='MOSI',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='MISO',do_erc=True),
            Pin(num='3',name='SCK',do_erc=True),
            Pin(num='4',name='~SS',do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='9',name='TEST',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~EN_INT',do_erc=True),
            Pin(num='11',name='VDDp',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='WM',do_erc=True),
            Pin(num='15',name='~INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='17',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='BD1020HFV',dest=TEMPLATE,tool=SKIDL,keywords='Temperature sensor',description='Analog Ouput Temperature Sensor',ref_prefix='U',num_units=1,fplist=['HVSOF5*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='PG',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='Vout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='BMP085',dest=TEMPLATE,tool=SKIDL,keywords='Digital Barometer',description='19-Bit Digital Barometer, LCC-8',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='EOC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='XCLR',do_erc=True)]),
        Part(name='C12880MA',dest=TEMPLATE,tool=SKIDL,keywords='spectrometer',description='Micro spectrometer 340 to 850nm resolution 15nm',ref_prefix='U',num_units=1,fplist=['C12880*'],do_erc=True,pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='CLK',do_erc=True),
            Pin(num='5',name='CASE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='ST',do_erc=True),
            Pin(num='7',name='TRG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='9',name='EOS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='VIDEO',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='DHT11',dest=TEMPLATE,tool=SKIDL,keywords='digital temperature humidity sensor',description='- Temperature and humidity module',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VCC',do_erc=True),
            Pin(num='2',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='Flir_LEPTON',dest=TEMPLATE,tool=SKIDL,keywords='LWIR camera',description='LWIR camera 8 to 14um 80x60 pixel',ref_prefix='U',num_units=1,fplist=['105028-1001*', '105028-2011*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GPIO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GPIO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GPIO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='GPIO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VDDC',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='SPI_MOSI',do_erc=True),
            Pin(num='21',name='SCL',do_erc=True),
            Pin(num='31',name='MIPI_DATA_N',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='SPI_MISO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='MIPI_DATA_P',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='SPI_CLK',do_erc=True),
            Pin(num='23',name='PWR_DWN_L',do_erc=True),
            Pin(num='14',name='SPI_CS_L',do_erc=True),
            Pin(num='24',name='RESET_L',do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='MASTER_CLK',do_erc=True),
            Pin(num='17',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='MIPI_CLK_N',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='MIPI_CLK_P',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='INA138',dest=TEMPLATE,tool=SKIDL,keywords='current sensor shunt monitor',description='Unipolar high-side current shunt monitor, 60V common mode',ref_prefix='U',num_units=1,fplist=['SOT-23-*'],do_erc=True,aliases=['INA168'],pins=[
            Pin(num='1',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='+IN',do_erc=True),
            Pin(num='5',name='-IN',do_erc=True)]),
        Part(name='INA193',dest=TEMPLATE,tool=SKIDL,keywords='Current sensor shunt monitor high low side',description='100V/V Current shunt monitor with independent supply, -16V to +80V common mode range',ref_prefix='U',num_units=1,fplist=['SOT-23'],do_erc=True,aliases=['INA194', 'INA195'],pins=[
            Pin(num='1',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='+IN',do_erc=True),
            Pin(num='4',name='-IN',do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='INA196',dest=TEMPLATE,tool=SKIDL,keywords='Current sensor shunt monitor high low side',description='100V/V Current shunt monitor with independent supply, -16V to +80V common mode range',ref_prefix='U',num_units=1,fplist=['SOT-23'],do_erc=True,aliases=['INA197', 'INA198'],pins=[
            Pin(num='1',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='+IN',do_erc=True),
            Pin(num='5',name='-IN',do_erc=True)]),
        Part(name='INA282',dest=TEMPLATE,tool=SKIDL,keywords='current monitor shunt sensor bidirectional high low side common mode',description='100V/V High accuracy, wide common-mode range bidirectional current shunt monitor',ref_prefix='U',num_units=1,do_erc=True,aliases=['INA286', 'INA283', 'INA284', 'INA285'],pins=[
            Pin(num='1',name='-IN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='REF2',do_erc=True),
            Pin(num='4',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='5',name='OUT',do_erc=True),
            Pin(num='6',name='V+',do_erc=True),
            Pin(num='7',name='REF1',do_erc=True),
            Pin(num='8',name='+IN',do_erc=True)]),
        Part(name='KTY81',dest=TEMPLATE,tool=SKIDL,keywords='silicon temperature sensors',description='KTY81 series silicon temperature sensors',ref_prefix='TH',num_units=1,fplist=['TO?92*', 'SOD70*'],do_erc=True,aliases=['KT100', 'KTY10'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='KTY82',dest=TEMPLATE,tool=SKIDL,keywords='silicon temperature sensors',description='KTY82 series silicon temperature sensors, SOT-23',ref_prefix='TH',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='KTY83',dest=TEMPLATE,tool=SKIDL,keywords='silicon temperature sensor diode',description='KTY84 series silicon temperature sensors, polarized, SOD68',ref_prefix='TH',num_units=1,fplist=['DO?34*', 'SOD68*'],do_erc=True,aliases=['KTY84'],pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='KTY85',dest=TEMPLATE,tool=SKIDL,keywords='silicon temperature sensor diode',description='KTY85 series silicon temperature sensors, polarized, SOD80',ref_prefix='TH',num_units=1,fplist=['SOD80*'],do_erc=True,pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='L3G4200D',dest=TEMPLATE,tool=SKIDL,keywords='3-Axis MEMS Gyroscope',description='16-bit 3 Axis Digital MEMS Gyroscope, LGA-16',ref_prefix='U',num_units=1,fplist=['LGA*'],do_erc=True,pins=[
            Pin(num='1',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='SCL/SPC',do_erc=True),
            Pin(num='3',name='SDA/SDI/SDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='SDO/SA0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='CS',do_erc=True),
            Pin(num='6',name='DRDY/INT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='INT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='RES(GND)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='RES(GND)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='RES(GND)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='RES(GND)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='RES(GND)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PLLFILT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='RES(VDD)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='L3GD20',dest=TEMPLATE,tool=SKIDL,keywords='3-Axis MEMS Gyroscope',description='16-bit 3 Axis Digital MEMS Gyroscope, LGA-16',ref_prefix='U',num_units=1,fplist=['LGA*'],do_erc=True,pins=[
            Pin(num='1',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='SCL/SPC',do_erc=True),
            Pin(num='3',name='SDA/SDI/SDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='SDO/SA0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='CS',do_erc=True),
            Pin(num='6',name='DRDY/INT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='INT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='RES(GND)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='RES(GND)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='RES(GND)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='RES(GND)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='RES(GND)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='RES(CAP)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='RES(VDD)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LA25-P',dest=TEMPLATE,tool=SKIDL,keywords='LEM current transducer',description='LA 55-P Current transducer',ref_prefix='U',num_units=1,fplist=['LEM_LA25-P'],do_erc=True,aliases=['LA55-P', 'LA100-P'],pins=[
            Pin(num='1',name='M',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LIS2DH',dest=TEMPLATE,tool=SKIDL,keywords='3-axis accelerometer spi mems',description='3-Axis Accelerometer, 2/4/8/16g range, I2C/SPI interface',ref_prefix='U',num_units=1,fplist=['LGA-*_2x2mm_Pitch0.35mm*'],do_erc=True,pins=[
            Pin(num='1',name='SCL/SPC',do_erc=True),
            Pin(num='2',name='SDA/SDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='SA0/SDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~CS',do_erc=True),
            Pin(num='5',name='INT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='INT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Vdd_IO',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LIS2HH12',dest=TEMPLATE,tool=SKIDL,keywords='3-axis accelerometer spi mems',description='3-Axis Accelerometer, 2/4/8g range, I2C/SPI interface',ref_prefix='U',num_units=1,fplist=['LGA*2x2mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='SCL/SPC',do_erc=True),
            Pin(num='2',name='~CS',do_erc=True),
            Pin(num='3',name='SA0/SDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='SDA/SDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RES',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='Vdd_IO',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='INT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='INT1',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LIS331HH',dest=TEMPLATE,tool=SKIDL,keywords='3-axis accelerometer spi i2c mems',description='3-Axis Accelerometer, 6/12/24g range, 1000Hz, I2C and SPI interface',ref_prefix='U',num_units=1,fplist=['LGA-*_3x3mm_Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='SCL/SPC',do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='SDA/SDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='SA0/SDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~CS',do_erc=True),
            Pin(num='9',name='INT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='INT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LM35-D',dest=TEMPLATE,tool=SKIDL,keywords='temperature sensor thermistor',description='Precision centigrade temperature sensor, SOIC-8 package',ref_prefix='U',num_units=1,fplist=['SOIC*'],do_erc=True,pins=[
            Pin(num='1',name='Vout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='+VS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LM35-LP',dest=TEMPLATE,tool=SKIDL,keywords='temperature sensor thermistor',description='Precision centigrade temperature sensor, TO-92 package',ref_prefix='U',num_units=1,fplist=['TO-92*'],do_erc=True,pins=[
            Pin(num='1',name='+VS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='Vout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LM35-NEB',dest=TEMPLATE,tool=SKIDL,keywords='temperature sensor thermistor',description='Precision centigrade temperature sensor, TO-220 package',ref_prefix='U',num_units=1,fplist=['TO-220*'],do_erc=True,pins=[
            Pin(num='1',name='+VS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vout',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LM73',dest=TEMPLATE,tool=SKIDL,keywords='digital temperature sensor',description='11 to 14 Bit digital temperature sensor with 2 wire interface, SOT23-6',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,aliases=['LM73-1'],pins=[
            Pin(num='1',name='ADDR',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='SMBCLK',do_erc=True),
            Pin(num='5',name='~ALERT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='SMBDAT',func=Pin.BIDIR,do_erc=True)]),
        Part(name='LMT84DCK',dest=TEMPLATE,tool=SKIDL,keywords='temperature sensor thermistor ntc',description='Analog temperature sensor, NTC, 0.4C accuracy, -5.5mV/C, -50C to +150C, 1.5 to 5.5V, SC-70-5 package',ref_prefix='U',num_units=1,fplist=['SC-70-*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LMT85DCK',dest=TEMPLATE,tool=SKIDL,keywords='temperature sensor thermistor ntc',description='Analog temperature sensor, NTC, 0.3C accuracy, -8.2mV/C, -50C to +150C, 1.8 to 5.5V, SC-70-5 package',ref_prefix='U',num_units=1,fplist=['SC-70-*'],do_erc=True,pins=[
            Pin(num='1',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LMT86DCK',dest=TEMPLATE,tool=SKIDL,keywords='temperature sensor thermistor ntc',description='Analog temperature sensor, NTC, 0.25C accuracy, -10.9mV/C, -50C to +150C, 2.2 to 5.5V, SC-70-5 package',ref_prefix='U',num_units=1,fplist=['SC-70-*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Vdd',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LMT87DCK',dest=TEMPLATE,tool=SKIDL,keywords='temperature sensor thermistor ntc',description='Analog temperature sensor, NTC, 0.3C accuracy, -13.6mV/C, -50C to +150C, 2.7 to 5.5V, SC-70-5 package',ref_prefix='U',num_units=1,fplist=['SC-70-*'],do_erc=True,pins=[
            Pin(num='1',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Vdd',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LSM303D',dest=TEMPLATE,tool=SKIDL,keywords='Accelerometer Magnetometer MEMS',description='I2C/SPI, 3D Accelerometer and 3D Magnetometer',ref_prefix='U',num_units=1,fplist=['LGA*'],do_erc=True,pins=[
            Pin(num='1',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='SETC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='SETP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='SCL/SPC',do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='SDA/SDI/SDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='SDO/SAO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='CS',do_erc=True),
            Pin(num='9',name='INT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='INT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='C1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LSM303DLHC',dest=TEMPLATE,tool=SKIDL,keywords='Accelerometer Magnetometer MEMS',description='I2C, 3D Accelerometer and 3D Magnetometer',ref_prefix='U',num_units=1,fplist=['LGA*'],do_erc=True,pins=[
            Pin(num='1',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='SCL',do_erc=True),
            Pin(num='3',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='INT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='INT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='C1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='9',name='DRDY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='SETP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='SETC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LSM9DS1',dest=TEMPLATE,tool=SKIDL,keywords='I2C SPI IMU accelerometer gyroscope magnetometer',description='I2C SPI 9 axis IMU accelerometer gyroscope magnetometer',ref_prefix='U',num_units=1,fplist=['LGA*3x3.5mm*Pitch0.43mm*'],do_erc=True,pins=[
            Pin(num='1',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='SCL/SPC',do_erc=True),
            Pin(num='3',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='SDA/SDI/SDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='SDO_A/G',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='SDO_M',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='CS_A/G',do_erc=True),
            Pin(num='8',name='CS_M',do_erc=True),
            Pin(num='9',name='DRDY_M',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='INT_M',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='INT1_A/G',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='CAP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='INT2_A/G',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='DEN_A/G',do_erc=True),
            Pin(num='23',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='RES',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='C1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='RES',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RES',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='RES',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RES',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LV25-P',dest=TEMPLATE,tool=SKIDL,keywords='Voltage transducer',description='LEM Voltage transducer LV 25-P',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='HV+',do_erc=True),
            Pin(num='3',name='HV-',do_erc=True),
            Pin(num='4',name='M',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='V-',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MAX31855',dest=TEMPLATE,tool=SKIDL,keywords='Thermocouple Converter',description='Cold-Junction Compensated Thermocouple-to-Digital Converter',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T-',do_erc=True),
            Pin(num='3',name='T+',do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SCK',do_erc=True),
            Pin(num='6',name='~CS',do_erc=True),
            Pin(num='7',name='SO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='NC',do_erc=True)]),
        Part(name='MCP9501',dest=TEMPLATE,tool=SKIDL,keywords='Temperature Switch sensor',description='Temperature Switch with Selectable Hysteresis, Open-Drain, Active-Low Output (Cold Option), SOT-23-5',ref_prefix='U',num_units=1,fplist=['SOT?23*'],do_erc=True,aliases=['MCP9503'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Hyst',do_erc=True),
            Pin(num='4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Out',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='MCP9502',dest=TEMPLATE,tool=SKIDL,keywords='Temperature Switch sensor',description='Temperature Switch with Selectable Hysteresis, Push-Pull, Active-High Output (Cold Option), SOT-23-5',ref_prefix='U',num_units=1,fplist=['SOT?23*'],do_erc=True,aliases=['MCP9504'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Hyst',do_erc=True),
            Pin(num='4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Out',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='MCP9700AT-E/LT',dest=TEMPLATE,tool=SKIDL,keywords='temperature sensor thermistor',description='Low power, analog thermistor temperature sensor, ±4C accuracy, -40C to +150C, in SC-70-5 package',ref_prefix='U',num_units=1,fplist=['SC-70-5*'],do_erc=True,aliases=['MCP9700AT-H/LT', 'MCP9700T-E/LT', 'MCP9700T-H/LT'],pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='MCP9700T-H/TT',dest=TEMPLATE,tool=SKIDL,keywords='temperature sensor thermistor',description='Low power, analog thermistor temperature sensor, ±4C accuracy, -40C to +150C, in SOT-23-3 package',ref_prefix='U',num_units=1,fplist=['SOT-23-3*'],do_erc=True,aliases=['MCP9700T-E/TT', 'MCP9700AT-H/TT', 'MCP9700AT-E/TT'],pins=[
            Pin(num='1',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='Vout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MMA8653FCR1',dest=TEMPLATE,tool=SKIDL,keywords='Accelerometer I2C',description='3-Axis 10-bit Digital Accelerometer with I2C interface',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='SCL',do_erc=True),
            Pin(num='3',name='INT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='BYP',do_erc=True),
            Pin(num='5',name='INT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='Vddio',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='SDA',do_erc=True)]),
        Part(name='MP45DT02',dest=TEMPLATE,tool=SKIDL,keywords='MEMS Microphone',description='MEMS Omnidirectional Digital Microphone, HLGA-6',ref_prefix='U',num_units=1,fplist=['HLGA*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='LR',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='CLK',do_erc=True),
            Pin(num='5',name='DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MPU-6000',dest=TEMPLATE,tool=SKIDL,keywords='mems',description='InvenSense 6-Axis Motion Sensor, Gyroscope, Accelerometer, I2C/SPI',ref_prefix='U',num_units=1,fplist=['QFN-24*4x4mm_Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='CLKIN',do_erc=True),
            Pin(num='6',name='AUX_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AUX_SCL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~CS',do_erc=True),
            Pin(num='9',name='AD0/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='REGOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='CPOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='FSYNC',do_erc=True),
            Pin(num='12',name='INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='SCL/SCLK',do_erc=True),
            Pin(num='24',name='SDA/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MPU-6050',dest=TEMPLATE,tool=SKIDL,keywords='mems',description='InvenSense 6-Axis Motion Sensor, Gyroscope, Accelerometer, I2C',ref_prefix='U',num_units=1,fplist=['QFN-24*4x4mm_Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='CLKIN',do_erc=True),
            Pin(num='6',name='AUX_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AUX_SCL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='AD0',do_erc=True),
            Pin(num='10',name='REGOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='CPOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='FSYNC',do_erc=True),
            Pin(num='12',name='INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='SCL',do_erc=True),
            Pin(num='24',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MPU-9150',dest=TEMPLATE,tool=SKIDL,keywords='mems magnetometer',description='InvenSense 9-Axis Motion Sensor, Accelerometer, Gyroscope, Compass, I2C',ref_prefix='U',num_units=1,fplist=['QFN-24*4x4mm_Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='CLKIN',do_erc=True),
            Pin(num='3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='AUX_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AUX_SCL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='AD0',do_erc=True),
            Pin(num='10',name='REGOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='CPOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='FSYNC',do_erc=True),
            Pin(num='12',name='INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='SCL',do_erc=True),
            Pin(num='24',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MPU-9250',dest=TEMPLATE,tool=SKIDL,keywords='mems magnetometer',description='InvenSense 9-Axis Motion Sensor, Accelerometer, Gyroscope, Compass, I2C/SPI',ref_prefix='U',num_units=1,fplist=['QFN-24*3x3mm_Pitch0.4mm*'],do_erc=True,pins=[
            Pin(num='1',name='RESV_VDDIO',do_erc=True),
            Pin(num='6',name='AUX_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AUX_SCL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='AD0/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='REGOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='RESV_GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='FSYNC',do_erc=True),
            Pin(num='12',name='INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='~CS',do_erc=True),
            Pin(num='13',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='SCL/SCLK',do_erc=True),
            Pin(num='24',name='SDA/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MPXA6115A',dest=TEMPLATE,tool=SKIDL,keywords='absolute pressure sensor',description='Absolute pressure sensor, 15 to 115kPa, analog output, integrated signal conditioning, temperature compensated, media resistant gel, SSO package',ref_prefix='U',num_units=1,do_erc=True,aliases=['MPXAZ6115A', 'MPXH6115A', 'MPXHZ6115A'],pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='Vcc',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='Vout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='PT100',dest=TEMPLATE,tool=SKIDL,keywords='platinum temperature sensor RTD',description='PT500 platinum temperature sensor (RTD)',ref_prefix='TH',num_units=1,fplist=['TO?92*', 'PIN?ARRAY*', 'bornier*', 'Terminal?Block*', 'SOD70*', 'R*1206*', 'R*0805*'],do_erc=True,aliases=['PT500', 'PT1000'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SHT1x',dest=TEMPLATE,tool=SKIDL,keywords='digital temperature humidity sensor',description='Temperature and humidity module',ref_prefix='U',num_units=1,fplist=['SHT1x'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='DATA',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='SCK',do_erc=True),
            Pin(num='4',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TLV493D',dest=TEMPLATE,tool=SKIDL,keywords='magnetic field i2c',description='Low power 3D magnetic sensor, I2C interface, SOT23-6 package',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='SCL/INT',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='SDA/ADDR',func=Pin.BIDIR,do_erc=True)]),
        Part(name='TMP20AIDCK',dest=TEMPLATE,tool=SKIDL,keywords='temperature sensor thermistor',description='Analog thermistor temperature sensor, ±2.5C accuracy, -55C to +130C, SC-70-5 package',ref_prefix='U',num_units=1,fplist=['SC?70*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TMP20AIDRL',dest=TEMPLATE,tool=SKIDL,keywords='temperature sensor thermistor',description='Analog thermistor temperature sensor, ±2.5C accuracy, -55C to +130C, SOT-563-6 package',ref_prefix='U',num_units=1,fplist=['SOT?563*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TMP411',dest=TEMPLATE,tool=SKIDL,keywords='Temperature sensor remote local i2c',description='- Remote and Local TEMPERATURE SENSOR',ref_prefix='U',num_units=1,fplist=['SOIC', 'MSOP', 'SO'],do_erc=True,pins=[
            Pin(num='1',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='D+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='D-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~TERM',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~ALERT',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='7',name='SDA',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='SCL',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='ZXCT1009',dest=TEMPLATE,tool=SKIDL,keywords='High side current sensor monitor shunt',description='High side current sensor, SOT-23',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='Vs-',do_erc=True),
            Pin(num='2',name='Vs+',do_erc=True),
            Pin(num='3',name='Iout',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='ZXCT1107',dest=TEMPLATE,tool=SKIDL,keywords='High side current sensor monitor shunt',description='High side current sensor, SOT-23',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='S+',do_erc=True),
            Pin(num='2',name='S-',do_erc=True),
            Pin(num='3',name='Out',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='ZXCT1109',dest=TEMPLATE,tool=SKIDL,keywords='High side current sensor monitor shunt',description='High side current sensor, SOT-23',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='S-',do_erc=True),
            Pin(num='2',name='S+',do_erc=True),
            Pin(num='3',name='Out',func=Pin.OUTPUT,do_erc=True)])])