from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

texas = SchLib(tool=SKIDL).add_parts(*[
        Part(name='ISO7320C',dest=TEMPLATE,tool=SKIDL,keywords='2Ch Dual Digital Isolator 25Mbps',description='Low Power Dual-Channel 2/0 Digital Isolator, 25Mbps 33ns, Fail-Safe Low, SO8',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['ISO7320FC'],pins=[
            Pin(num='1',name='VCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='INA',do_erc=True),
            Pin(num='3',name='INB',do_erc=True),
            Pin(num='4',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='OUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='OUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VCC2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ISO7321C',dest=TEMPLATE,tool=SKIDL,keywords='2Ch Dual Digital Isolator 25Mbps',description='Low Power Dual-Channel 1/1 Digital Isolator, 25Mbps 33ns, Fail-Safe Low, SO8',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['ISO7321FC'],pins=[
            Pin(num='1',name='VCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='OUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='INB',do_erc=True),
            Pin(num='4',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='OUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='INA',do_erc=True),
            Pin(num='8',name='VCC2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ISO7340C',dest=TEMPLATE,tool=SKIDL,keywords='4Ch Quad Digital Isolator 25Mbps',description='Low Power Quad-Channel 4/0 Digital Isolator, 25Mbps 31ns, Fail-Safe Low, SO16',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['ISO7340FC'],pins=[
            Pin(num='1',name='VCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='INA',do_erc=True),
            Pin(num='4',name='INB',do_erc=True),
            Pin(num='5',name='INC',do_erc=True),
            Pin(num='6',name='IND',do_erc=True),
            Pin(num='8',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='EN',do_erc=True),
            Pin(num='11',name='OUTD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='OUTC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='OUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='OUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ISO7341C',dest=TEMPLATE,tool=SKIDL,keywords='4Ch Quad Digital Isolator 25Mbps',description='Low Power Quad-Channel 3/1 Digital Isolator, 25Mbps 31ns, Fail-Safe Low, SO16',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['ISO7341FC'],pins=[
            Pin(num='1',name='VCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='INA',do_erc=True),
            Pin(num='4',name='INB',do_erc=True),
            Pin(num='5',name='INC',do_erc=True),
            Pin(num='6',name='OUTD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='EN1',do_erc=True),
            Pin(num='8',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='EN2',do_erc=True),
            Pin(num='11',name='IND',do_erc=True),
            Pin(num='12',name='OUTC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='OUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='OUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ISO7342C',dest=TEMPLATE,tool=SKIDL,keywords='4Ch Quad Digital Isolator 25Mbps',description='Low Power Quad-Channel 2/2 Digital Isolator, 25Mbps 31ns, Fail-Safe Low, SO16',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['ISO7342FC'],pins=[
            Pin(num='1',name='VCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='INA',do_erc=True),
            Pin(num='4',name='INB',do_erc=True),
            Pin(num='5',name='OUTC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='OUTD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='EN1',do_erc=True),
            Pin(num='8',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='EN2',do_erc=True),
            Pin(num='11',name='IND',do_erc=True),
            Pin(num='12',name='INC',do_erc=True),
            Pin(num='13',name='OUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='OUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LM3S6911-EQC50',dest=TEMPLATE,tool=SKIDL,keywords='MCU ARM M3 Stellaris PHY ETH NRND',description='Ti Stellaris ARM-M3 MCU Ethernet PHY, Industrial grade, LQFP100',ref_prefix='U',num_units=1,fplist=['LQFP-100*'],do_erc=True,aliases=['LM3S6911-IQC50'],pins=[
            Pin(num='1',name='PE7',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE6/C1O',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='GNDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PE5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='LDO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='SSI0RX/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='RXIP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='~WAKE~',do_erc=True),
            Pin(num='60',name='PF2/LED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='I2C0SCL/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='SWCLK/TCK/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='C0+/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='SSI0TX/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='ERBIAS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='~HIB~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='61',name='PF1',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='I2C0SDA/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='91',name='C1-/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PD2/U1RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='CCP4/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='42',name='GNDPHY',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='XOSC0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='62',name='VDD25',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='PE0/SSI1CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='92',name='C0-/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PD3/U1TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='CCP3/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='43',name='TXOP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='53',name='XOSC1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='73',name='PE1/SSI1FSS',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='VCCPHY',func=Pin.PWRIN,do_erc=True),
            Pin(num='93',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VDD25',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='C1+/C0O/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='I2C1SCL/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='~RST~',do_erc=True),
            Pin(num='74',name='PE2/SSI1RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='VCCPHY',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='CCP5/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='I2C1SDA/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='VBAT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='65',name='CMOD0',do_erc=True),
            Pin(num='75',name='PE3/SSI1TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='GNDPHY',func=Pin.PWRIN,do_erc=True),
            Pin(num='95',name='PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='XTALPPHY',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='U0RX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='VCCPHY',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='TXON',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='66',name='CCP0/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='CMOD1',do_erc=True),
            Pin(num='86',name='GNDPHY',func=Pin.PWRIN,do_erc=True),
            Pin(num='96',name='PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='XTALNPHY',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='U0TX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RXIN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='PF0',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='67',name='CCP2/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='SWO/TDO/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='97',name='GNDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='PG1/U2TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='SSI0CLK/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='VDD25',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='OSC0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='58',name='MDIO',do_erc=True),
            Pin(num='68',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='78',name='TDI/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='VDD25',func=Pin.PWRIN,do_erc=True),
            Pin(num='98',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='PG0/U2RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='SSI0FSS/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='OSC1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='59',name='PF3/LED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='79',name='SWDIO/TMS/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='~TRST~/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='PD7/CCP1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='LM5175PWP',dest=TEMPLATE,tool=SKIDL,keywords='Buck Boost step-up step-down',description='42-V wide Vin synchronous 4-switch Buck-Boost controller, HTSSOP-28 package',ref_prefix='U',num_units=1,fplist=['HTSSOP*4.4x9.7mm*Pitch0.65*ThermalPad*'],do_erc=True,pins=[
            Pin(num='1',name='EN/UVLO',do_erc=True),
            Pin(num='2',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VISNS',do_erc=True),
            Pin(num='4',name='MODE',do_erc=True),
            Pin(num='5',name='DITH',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='RT/SYNC',do_erc=True),
            Pin(num='7',name='SLOPE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='SS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='COMP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='BOOT2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='FB',do_erc=True),
            Pin(num='21',name='LDRV2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='VOSNS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='ISNS(-)',do_erc=True),
            Pin(num='23',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='ISNS(+)',do_erc=True),
            Pin(num='24',name='BIAS',do_erc=True),
            Pin(num='15',name='CSG',do_erc=True),
            Pin(num='25',name='LDRV1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='CS',do_erc=True),
            Pin(num='26',name='BOOT1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='PGOOD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='HDRV1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='SW2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='SW1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='HDRV2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='29',name='PowerPAD',do_erc=True)]),
        Part(name='LM5175RHF',dest=TEMPLATE,tool=SKIDL,keywords='Buck Boost step-up step-down',description='42-V wide Vin synchronous 4-switch Buck-Boost controller, QFN-28 package',ref_prefix='U',num_units=1,fplist=['QFN*4.0x5.0mm*Pitch0.5*ThermalPad*'],do_erc=True,pins=[
            Pin(num='1',name='EN/UVLO',do_erc=True),
            Pin(num='2',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VISNS',do_erc=True),
            Pin(num='4',name='MODE',do_erc=True),
            Pin(num='5',name='DITH',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='RT/SYNC',do_erc=True),
            Pin(num='7',name='SLOPE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='SS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='COMP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='BOOT2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='FB',do_erc=True),
            Pin(num='21',name='LDRV2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='VOSNS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='ISNS(-)',do_erc=True),
            Pin(num='23',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='ISNS(+)',do_erc=True),
            Pin(num='24',name='BIAS',do_erc=True),
            Pin(num='15',name='CSG',do_erc=True),
            Pin(num='25',name='LDRV1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='CS',do_erc=True),
            Pin(num='26',name='BOOT1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='PGOOD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='HDRV1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='SW2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='SW1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='HDRV2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='29',name='PowerPAD',do_erc=True)]),
        Part(name='PCA9306',dest=TEMPLATE,tool=SKIDL,keywords='Dual bidirectional I2C Bus and SMBus voltage level translator',description='Dual bidirectional I2C Bus and SMBus voltage level translator',ref_prefix='U',num_units=1,fplist=['SSOP*2.95x2.8mm*Pitch0.65mm*', 'VSSOP*2.3x2mm*Pitch0.5mm*', 'X2SON*1.4x1mm*Pitch0.35mm*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VREF1',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='SCL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='SDA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='SDA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='VREF2',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='EN',do_erc=True)]),
        Part(name='TCA9555PWR',dest=TEMPLATE,tool=SKIDL,keywords='ti parallel port',description='16-bit I/O expander, I2C and SMBus interface, interrupts, TSSOP-24 package',ref_prefix='U',num_units=1,fplist=['TSSOP-24*'],do_erc=True,pins=[
            Pin(num='1',name='~INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='P00',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P01',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P02',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P03',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P04',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P05',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P06',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P17',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P07',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='A0',do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='SCL',do_erc=True),
            Pin(num='13',name='P10',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P11',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='P12',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P13',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P14',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P15',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P16',func=Pin.BIDIR,do_erc=True)]),
        Part(name='TCA9555RGER',dest=TEMPLATE,tool=SKIDL,keywords='ti parallel port',description='16-bit I/O expander, I2C and SMBus interface, interrupts, QFN-24 package',ref_prefix='U',num_units=1,fplist=['QFN-24-1EP_4x4mm_Pitch0.5mm'],do_erc=True,aliases=['TCA9555RTWR'],pins=[
            Pin(num='1',name='P00',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P01',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P02',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P03',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P04',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P05',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P06',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P07',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='P10',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P11',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='P12',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='~INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='P13',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='A1',do_erc=True),
            Pin(num='14',name='P14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='A2',do_erc=True),
            Pin(num='15',name='P15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='EPAD',do_erc=True),
            Pin(num='16',name='P16',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P17',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='A0',do_erc=True),
            Pin(num='19',name='SCL',do_erc=True)]),
        Part(name='TLC555',dest=TEMPLATE,tool=SKIDL,keywords='Timer NE555',description='CMOS Timer',ref_prefix='U',num_units=1,fplist=['DIP*', 'SOIC-*_3.9x4.9mm_Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~TRIG',do_erc=True),
            Pin(num='3',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='CONT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='THRES',do_erc=True),
            Pin(num='7',name='DISCH',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TLC5940NT',dest=TEMPLATE,tool=SKIDL,keywords='PWM LED driver',description='16-Channel LED Driver With DOT Correction and Grayscale PWM Control, DIP package',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='OUT1',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='OUT2',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='3',name='OUT3',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='4',name='OUT4',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='5',name='OUT5',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='6',name='OUT6',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='7',name='OUT7',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='OUT8',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='OUT9',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='OUT10',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='20',name='IREF',do_erc=True),
            Pin(num='11',name='OUT11',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='OUT12',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='OUT13',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='23',name='BLANK',do_erc=True),
            Pin(num='14',name='OUT14',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='24',name='XLAT',do_erc=True),
            Pin(num='15',name='OUT15',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='25',name='SCLK',do_erc=True),
            Pin(num='16',name='XERR',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='26',name='SIN',do_erc=True),
            Pin(num='17',name='SOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='VPRG',do_erc=True),
            Pin(num='18',name='GSCLK',do_erc=True),
            Pin(num='28',name='OUT0',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='19',name='DCPRG',do_erc=True)]),
        Part(name='TLC5940PWP',dest=TEMPLATE,tool=SKIDL,keywords='PWM LED driver',description='16-Channel LED Driver With DOT Correction and Grayscale PWM Control, TSSOP package with thermal pad',ref_prefix='U',num_units=1,fplist=['HTSSOP*4.4x9.7mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='BLANK',do_erc=True),
            Pin(num='3',name='XLAT',do_erc=True),
            Pin(num='4',name='SCLK',do_erc=True),
            Pin(num='5',name='SIN',do_erc=True),
            Pin(num='6',name='VPRG',do_erc=True),
            Pin(num='7',name='OUT0',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='OUT1',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='OUT2',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='OUT3',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='20',name='OUT13',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='OUT4',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='21',name='OUT14',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='OUT5',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='22',name='OUT15',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='13',name='OUT6',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='23',name='XERR',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='14',name='OUT7',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='24',name='SOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='OUT8',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='25',name='GSCLK',do_erc=True),
            Pin(num='16',name='OUT9',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='26',name='DCPRG',do_erc=True),
            Pin(num='17',name='OUT10',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='27',name='IREF',do_erc=True),
            Pin(num='18',name='OUT11',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='28',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='OUT12',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='29',name='PAD',do_erc=True)]),
        Part(name='TLC5973',dest=TEMPLATE,tool=SKIDL,keywords='LED current driver 12bit PWM',description='3 Channel 12bit PWM constant currend LED Driver with single wire interface',ref_prefix='U',num_units=1,fplist=['SOIC*4.9x3.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='OUT0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='OUT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='OUT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='SDI',do_erc=True),
            Pin(num='7',name='IREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TM4C1230C3PM',dest=TEMPLATE,tool=SKIDL,keywords='ARM Tiva Cortex M4 MCU',description='Tiva ARM 32bit CortexM4 Microcotroller, 80MHz, 256kB Flash, 32kB SRAM, 2k EEPROM, LQFP64',ref_prefix='U',num_units=1,fplist=['LQFP-64*'],do_erc=True,aliases=['LM4F111B2QR', 'TM4C1230D5PM', 'LM4F111C4QR', 'TM4C1230E6PM', 'LM4F111E5QR', 'TM4C1230H6PM', 'LM4F111H5QR'],pins=[
            Pin(num='1',name='I2C5SCL/SSI2RX/T0CCP0/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='GNDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='I2C5SDA/SSI2TX/T0CCP1/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PF4/T2CCP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE3/AIN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE2/AIN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE1/AIN2/U7TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE0/AIN3/U7RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='NMI/U2TX/WT5CCP1/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='SSI0FSS/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PF2/T1CCP0/SSI1CLK/TRD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='OSC0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='TDI/T5CCP0/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PE5/AIN8/U5TX/I2C2SDA/CAN0TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='SSI0RX/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PF3/T1CCP1/SSI1FSS/CAN0TX/TRCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='OSC1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='TMS/SWDIO/T4CCP1/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='AIN7/I2C3SCL/SSI1CLK/SSI3CLK/WT2CCP0/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='SSI0TX/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PG5/WT0CCP1/U2TX/I2C1SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='TCK/SWCLK/T4CCP0/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='AIN6/I2C3SDA/SSI1FSS/SSI3FSS/WT2CCP1/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='C0-/U3TX/WT1CCP1/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='I2C1SCL/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PG4/WT0CCP0/U2RX/I2C1SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='U6RX/WT4CCP0/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='U2RX/WT5CCP0/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='AIN5/SSI1RX/SSI3RX/WT3CCP0/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='C0+/U3RX/WT1CCP0/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='I2C1SDA/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PG3/T5CCP1/I2C4SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='U6TX/WT4CCP1/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='AIN4/SSI1TX/SSI3TX/WT3CCP1/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='C1+/U1CTS/U1TX/U4TX/WT0CCP1/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='VDDC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='PG2/T5CCP0/I2C4SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='U1RX/T2CCP0/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='C1-/U1RTS/U1RX/U4RX/WT0CCP0/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='PG1/T4CCP1/I2C3SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='U1TX/T2CCP1/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='VDDC',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='U0RX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='PG0/T4CCP0/I2C3SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='I2C0SCL/T3CCP0/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='AIN11/CAN0TX/SSI2FSS/T1CCP1/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='U0TX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PF0/T0CCP0/SSI1RX/U1RTS/CAN0RX/C0O/NMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='~RST~',do_erc=True),
            Pin(num='48',name='I2C0SDA/T3CCP1/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='AIN10/CAN0RX/SSI2CLK/T1CCP0/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='SSI0CLK/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PF1/T0CCP1/SSI1TX/U1CTS/C1O/TRD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='GND',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='TDO/SWO/T5CCP1/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PE4/AIN9/U5RX/I2C2SCL/CAN0RX',func=Pin.BIDIR,do_erc=True)]),
        Part(name='TM4C1231C3PM',dest=TEMPLATE,tool=SKIDL,keywords='ARM Tiva Cortex M4 MCU',description='Tiva ARM 32bit CortexM4 Microcotroller, 80MHz, 256kB Flash, 32kB SRAM, 2k EEPROM, LQFP64',ref_prefix='U',num_units=1,fplist=['LQFP-64*'],do_erc=True,aliases=['LM4F110B2QR', 'TM4C1231D5PM', 'LM4F110C4QR', 'TM4C1231E6PM', 'LM4F110E5QR', 'TM4C1231H6PM', 'LM4F110H5QR'],pins=[
            Pin(num='1',name='SSI2RX/T0CCP0/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='GNDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='SSI2TX/T0CCP1/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PF4/T2CCP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PE3/AIN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PE2/AIN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PE1/AIN2/U7TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PE0/AIN3/U7RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='NMI/U2TX/WT5CCP1/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='SSI0FSS/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PF2/T1CCP0/SSI1CLK/TRD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='OSC0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='TDI/T5CCP0/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PE5/AIN8/U5TX/I2C2SDA/CAN0TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='SSI0RX/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PF3/T1CCP1/SSI1FSS/CAN0TX/TRCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='OSC1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='TMS/SWDIO/T4CCP1/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='AIN7/I2C3SCL/SSI1CLK/SSI3CLK/WT2CCP0/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='SSI0TX/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='~WAKE~',do_erc=True),
            Pin(num='42',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='TCK/SWCLK/T4CCP0/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='AIN6/I2C3SDA/SSI1FSS/SSI3FSS/WT2CCP1/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='C0-/U3TX/WT1CCP1/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='I2C1SCL/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='~HIB~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='43',name='U6RX/WT4CCP0/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='U2RX/WT5CCP0/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='AIN5/SSI1RX/SSI3RX/WT3CCP0/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='C0+/U3RX/WT1CCP0/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='I2C1SDA/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='XOSC0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='U6TX/WT4CCP1/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='AIN4/SSI1TX/SSI3TX/WT3CCP1/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='C1+/U1CTS/U1TX/U4TX/WT0CCP1/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='VDDC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='GNDX',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='U1RX/T2CCP0/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='C1-/U1RTS/U1RX/U4RX/WT0CCP0/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='XOSC1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='U1TX/T2CCP1/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='VDDC',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='U0RX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='VBAT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='I2C0SCL/T3CCP0/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='AIN11/CAN0TX/SSI2FSS/T1CCP1/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='U0TX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PF0/T0CCP0/SSI1RX/U1RTS/CAN0RX/C0O/MNI',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='~RST~',do_erc=True),
            Pin(num='48',name='I2C0SDA/T3CCP1/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='AIN10/CAN0RX/SSI2CLK/T1CCP0/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='SSI0CLK/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PF1/T0CCP1/SSI1TX/U1CTS/C1O/TRD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='GND',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='TDO/SWO/T5CCP1/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PE4/AIN9/U5RX/I2C2SCL/CAN0RX',func=Pin.BIDIR,do_erc=True)]),
        Part(name='TMS320LF2406',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='TMS470R1B768',dest=TEMPLATE,tool=SKIDL,keywords='ARM 7TDM uC TMS470',description='ARM7TDM Microcontroller, 768KB Flash, 48KB RAM, PQFP-144',ref_prefix='U',num_units=1,fplist=['PQFP-144*'],do_erc=True,pins=[
            Pin(num='1',name='~SPI1ENA~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~SPI1SCS~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='SPI1SIMO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='SPI1SOMI',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='SPI1CLK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~SPI4ENA~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~SPI4SCS~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='SPI4SIMO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='SPI4SOMI',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='SPI4CLK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='GIOD[1]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='Vss',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='GIOA[1]/INT1/ECLK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='HET[31]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='60',name='SPI5CLK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='70',name='HET[19]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='80',name='HET[9]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='90',name='SCI1TX',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='GIOD[0]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='Vcc',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='GIOA[2]/INT2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='HET[24]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='61',name='~SPI5ENA~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='71',name='HET[18]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='81',name='VssIO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='91',name='SCI1RX',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='OSCOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='HET[17]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='~PORST~',do_erc=True),
            Pin(num='42',name='GIOA[3]/INT3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='VssIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='SPI2CLK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='72',name='AWD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='82',name='VccIO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='92',name='Vss',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='OSCIN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='HET[16]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='GIOA[7]/INT7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='SCI2RX',func=Pin.PASSIVE,do_erc=True),
            Pin(num='53',name='VccIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='SPI2SIMO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='73',name='PLLDIS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='83',name='CLKOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='93',name='Vcc',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='Vcc',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='HET[15]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='GIOA[6]/INT6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='SCI2TX',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='SPI2SOMI',func=Pin.PASSIVE,do_erc=True),
            Pin(num='74',name='TDI',func=Pin.PASSIVE,do_erc=True),
            Pin(num='84',name='GIOB[7]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='94',name='SPI3CLK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='~RST~',do_erc=True),
            Pin(num='25',name='HET[14]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='GIOA[5]/INT5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='SCI2CLK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='55',name='Vcc',func=Pin.UNSPEC,do_erc=True),
            Pin(num='65',name='~SPI2ENA~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='75',name='TDO5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='85',name='Vss',func=Pin.PASSIVE,do_erc=True),
            Pin(num='95',name='SPI3SOMI',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='VssIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='HET[13]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='GIOA[4]/INT4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='~SPI5SCS~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='CAN2HTX',func=Pin.PASSIVE,do_erc=True),
            Pin(num='66',name='~SPI2SCS~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='76',name='TCK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='86',name='Vcc',func=Pin.PASSIVE,do_erc=True),
            Pin(num='96',name='SPI3SIMO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='VccIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='HET[12]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='~TRST~',do_erc=True),
            Pin(num='47',name='HET[28]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='57',name='CAN2HRX',func=Pin.PASSIVE,do_erc=True),
            Pin(num='67',name='HET[22]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='77',name='CAN3HRX',func=Pin.PASSIVE,do_erc=True),
            Pin(num='87',name='CAN1HRX',func=Pin.PASSIVE,do_erc=True),
            Pin(num='97',name='~SPI3SCS~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='GIOD[3]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='HET[11]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='TEST',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='HET[29]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='58',name='SPI5SIMO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='68',name='HET[21]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='78',name='CAN3HTX',func=Pin.PASSIVE,do_erc=True),
            Pin(num='88',name='CAN1HTX',func=Pin.PASSIVE,do_erc=True),
            Pin(num='98',name='~SPI3ENA~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='GIOD[2]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='HET[10]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='GIOA[0]/INT0',do_erc=True),
            Pin(num='49',name='HET[30]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='59',name='SPI5SOMI',func=Pin.PASSIVE,do_erc=True),
            Pin(num='69',name='HET[20]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='79',name='HET[8]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='89',name='SCI1CLK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='99',name='ADEVT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='100',name='ADIN[7]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='110',name='ADIN[14]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='120',name='TMS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='130',name='HET[1]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='140',name='HET[5]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='101',name='ADIN[6]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='111',name='ADIN[10]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='121',name='TMS2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='131',name='Vss',func=Pin.PASSIVE,do_erc=True),
            Pin(num='141',name='HET[6]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='102',name='ADIN[5]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='112',name='ADIN[13]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='122',name='GIOC[0]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='132',name='Vcc',func=Pin.PASSIVE,do_erc=True),
            Pin(num='142',name='HET[7]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='103',name='ADIN[15]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='113',name='ADIN[9]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='123',name='HET[23]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='133',name='FLTP2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='143',name='GIOC[1]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='104',name='ADIN[4]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='114',name='ADIN[12]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='124',name='HET[25]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='134',name='FLTP1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='144',name='GIOC[2]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='105',name='ADIN[3]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='115',name='ADIN[8]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='125',name='HET[26]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='135',name='VccP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='106',name='ADIN[2]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='116',name='ADRefHi',func=Pin.PASSIVE,do_erc=True),
            Pin(num='126',name='HET[27]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='136',name='Vss',func=Pin.PASSIVE,do_erc=True),
            Pin(num='107',name='ADIN[1]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='117',name='ADRefLo',func=Pin.PASSIVE,do_erc=True),
            Pin(num='127',name='Vss',func=Pin.PASSIVE,do_erc=True),
            Pin(num='137',name='HET[2]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='108',name='ADIN[0]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='118',name='VccAD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='128',name='Vcc',func=Pin.PASSIVE,do_erc=True),
            Pin(num='138',name='HET[3]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='109',name='ADIN[11]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='119',name='VssAD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='129',name='HET[0]',func=Pin.PASSIVE,do_erc=True),
            Pin(num='139',name='HET[4]',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TPS2041B',dest=TEMPLATE,tool=SKIDL,keywords='1-chanel power-distribution USB',description='Single power-distribution switcher',ref_prefix='U',num_units=1,fplist=['SOT-23-5*'],do_erc=True,pins=[
            Pin(num='1',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~OC',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='4',name='~EN',do_erc=True),
            Pin(num='5',name='IN',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TPS2042D',dest=TEMPLATE,tool=SKIDL,keywords='2-chanel power-distribution USB',description='Dual power-distribution switcher',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IN1',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~EN1',do_erc=True),
            Pin(num='4',name='~EN2',do_erc=True),
            Pin(num='5',name='~OC2',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='6',name='OUT2',func=Pin.PWROUT,do_erc=True),
            Pin(num='7',name='OUT1',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='~OC1',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='TPS2044D',dest=TEMPLATE,tool=SKIDL,keywords='4-chanel power-distribution USB',description='Quad power-distribution switcher',ref_prefix='U',num_units=2,fplist=['SOIC*3.9x9.9mm*1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IN1',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~EN1',do_erc=True),
            Pin(num='4',name='~EN2',do_erc=True),
            Pin(num='13',name='~OC2',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='14',name='OUT2',func=Pin.PWROUT,do_erc=True),
            Pin(num='15',name='OUT1',func=Pin.PWROUT,do_erc=True),
            Pin(num='16',name='~OC1',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='IN2',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='~EN3',do_erc=True),
            Pin(num='8',name='~EN4',do_erc=True),
            Pin(num='9',name='~OC4',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='OUT4',func=Pin.PWROUT,do_erc=True),
            Pin(num='11',name='OUT3',func=Pin.PWROUT,do_erc=True),
            Pin(num='12',name='~OC3',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='TPS2054D',dest=TEMPLATE,tool=SKIDL,keywords='4-chanel power-distribution USB',description='Quad power-distribution switcher',ref_prefix='U',num_units=2,fplist=['SOIC*3.9x9.9mm*1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IN1',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='EN1',do_erc=True),
            Pin(num='4',name='EN2',do_erc=True),
            Pin(num='13',name='~OC2',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='14',name='OUT2',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='OUT1',func=Pin.PWROUT,do_erc=True),
            Pin(num='16',name='~OC1',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='IN2',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='EN3',do_erc=True),
            Pin(num='8',name='EN4',do_erc=True),
            Pin(num='9',name='~OC4',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='OUT4',func=Pin.PWROUT,do_erc=True),
            Pin(num='11',name='OUT3',func=Pin.PWROUT,do_erc=True),
            Pin(num='12',name='~OC3',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='TPS2513',dest=TEMPLATE,tool=SKIDL,keywords='USB Charge',description='USB Dedicated Charging Port Controller',ref_prefix='U',num_units=1,fplist=['SOT-23-6*'],do_erc=True,aliases=['TPS2513A'],pins=[
            Pin(num='1',name='DP1',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='DP2',do_erc=True),
            Pin(num='4',name='DM2',do_erc=True),
            Pin(num='5',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='DM1',do_erc=True)]),
        Part(name='TPS2514',dest=TEMPLATE,tool=SKIDL,keywords='USB Charge',description='USB Dedicated Charging Port Controller',ref_prefix='U',num_units=1,fplist=['SOT-23-6*'],do_erc=True,aliases=['TPS2514A'],pins=[
            Pin(num='1',name='DP1',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='5',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='DM1',do_erc=True)]),
        Part(name='TPS2560',dest=TEMPLATE,tool=SKIDL,keywords='power switche current limited usb port',description='Dual channel precision adjustable current-limited power switches',ref_prefix='U',num_units=1,fplist=['VSON*3x3mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='EN1',do_erc=True),
            Pin(num='5',name='EN2',do_erc=True),
            Pin(num='6',name='~FAULT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='ILM',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='OUT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='OUT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~FAULT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='PAD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TPS2561',dest=TEMPLATE,tool=SKIDL,keywords='power switche current limited usb port',description='Dual channel precision adjustable current-limited power switches',ref_prefix='U',num_units=1,fplist=['VSON*3x3mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='EN1',do_erc=True),
            Pin(num='5',name='EN2',do_erc=True),
            Pin(num='6',name='~FAULT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='ILM',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='OUT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='OUT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~FAULT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='PAD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TPS563200',dest=TEMPLATE,tool=SKIDL,keywords='step-down dcdc voltage regulator',description='4.5 to 17V input, 3A synchronous step-down voltage regulator',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,aliases=['TPS562200'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VFB',do_erc=True),
            Pin(num='5',name='EN',do_erc=True),
            Pin(num='6',name='VBST',do_erc=True)]),
        Part(name='TPS62130',dest=TEMPLATE,tool=SKIDL,keywords='step down dcdc converter',description='3-17V, 3A step-down converter',ref_prefix='U',num_units=1,fplist=['QFN*3x3mm*Pitch0.5mm*'],do_erc=True,aliases=['TPS62131', 'TPS62132', 'TPS62133'],pins=[
            Pin(num='1',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='PG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='FB',do_erc=True),
            Pin(num='6',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='FSW',do_erc=True),
            Pin(num='8',name='DEF',do_erc=True),
            Pin(num='9',name='SS/TR',do_erc=True),
            Pin(num='10',name='AVIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='PVIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='PVIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='EN',do_erc=True),
            Pin(num='14',name='VOS',do_erc=True),
            Pin(num='15',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='PAD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TS5A3160',dest=TEMPLATE,tool=SKIDL,keywords='SDPT Switch',description='1-Ohm SPDT Analog Switch, Make-Before-Break',ref_prefix='U',num_units=1,fplist=['SOT-23-6*', '*SC-70*'],do_erc=True,aliases=['TS5A3159'],pins=[
            Pin(num='1',name='NO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='NC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='COM',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='IN',do_erc=True)]),
        Part(name='TUSB2036',dest=TEMPLATE,tool=SKIDL,keywords='2-Port, 3-Port, 3.3V, EEPROM, Full Speed, Hub, Texas Instruments, USB1.1',description='2- or 3-Port USB1.1 HUB with optional serial EEPROM',ref_prefix='U',num_units=1,fplist=['LQFP-32_7x7mm_Pitch0.8mm'],do_erc=True,pins=[
            Pin(num='1',name='DP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='DM0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='EECLK',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='EEDATA/~GANGED',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='~BUSPWR',do_erc=True),
            Pin(num='9',name='~PWRON1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~OVRCUR1',do_erc=True),
            Pin(num='20',name='DP3',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='XTAL1/CLK48',do_erc=True),
            Pin(num='11',name='DM1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='~OCPROT~/~PWRSW~',do_erc=True),
            Pin(num='31',name='MODE',do_erc=True),
            Pin(num='12',name='DP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='NPINT0',do_erc=True),
            Pin(num='32',name='SUSPND',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~PWRON2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='NPINT1',do_erc=True),
            Pin(num='14',name='~OVRCUR2',do_erc=True),
            Pin(num='24',name='~NP3',do_erc=True),
            Pin(num='15',name='DM2',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='DP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='~EXTMEM',do_erc=True),
            Pin(num='17',name='~PWRON3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='DP0PUR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='~OVRCUR3',do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='DM3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='XTAL2',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='TUSB4041I',dest=TEMPLATE,tool=SKIDL,keywords='USB2.0 hub',description='four port USB 2.0 Hub',ref_prefix='U',num_units=1,fplist=['HTQFP*10x10mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='PWRCTL3/BATEN3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='VDD33',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='PWRCTL2/BATEN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PWRCTL1/BATEN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='SDA/SMBDAT',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL/SMBCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='SMBUSz',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='FULLPWRMGMTz/SMBA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PWRCTL_POL',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GANGED/SMBA2/HS_UP',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VDD33',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='XI',do_erc=True),
            Pin(num='40',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='50',name='USB_DM_DN3',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='OVERCUR4z',do_erc=True),
            Pin(num='21',name='USB_DP_UP',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VDD33',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='USB_DP_DN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='OVERCUR3z',do_erc=True),
            Pin(num='22',name='USB_DM_UP',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='USB_R1',do_erc=True),
            Pin(num='42',name='USB_DM_DN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='AUTOENz/HS_SUSPEND',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='USB_DP_DN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='OVERCUR1z',do_erc=True),
            Pin(num='24',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='USB_DM_DN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='PWRCTL4/BATEN4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='OVERCUR2z',do_erc=True),
            Pin(num='25',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='USB_VBUS',do_erc=True),
            Pin(num='26',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='USB_DP_DN4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TEST',do_erc=True),
            Pin(num='27',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='USB_DM_DN4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GRSTz',do_erc=True),
            Pin(num='28',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='38',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='VDD33',func=Pin.PWRIN,do_erc=True),
            Pin(num='58',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='XO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='39',name='RSVD',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='USB_DP_DN3',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='RSVD',func=Pin.BIDIR,do_erc=True)]),
        Part(name='TUSB8041',dest=TEMPLATE,tool=SKIDL,keywords='USB3.0 hub',description='four port USB 3.0 Hub',ref_prefix='U',num_units=1,fplist=['QFN*9x9mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='USB_DP_DN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='USB_DM_DN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='USB_SSTXP_DN1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='USB_SSTXM_DN1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='USB_SSRXP_DN1',do_erc=True),
            Pin(num='7',name='USB_SSRXM_DN1',do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='USB_DP_DN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='USB_DM_DN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='USB_SSTXM_DN3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='30',name='USB_SSRXM_DN4',do_erc=True),
            Pin(num='40',name='FULLPWRMGMTz/SMBA1/SS_UP',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='GRSTz',do_erc=True),
            Pin(num='60',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='11',name='USB_SSTXP_DN2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='PWRCTL_POL',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='XO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='USB_SSTXM_DN2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='USB_SSRXP_DN3',do_erc=True),
            Pin(num='32',name='PWRCTL4/BATEN4',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='GANGED/SMBA2/HS_UP',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VDD33',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='XI',do_erc=True),
            Pin(num='13',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='USB_SSRXM_DN3',do_erc=True),
            Pin(num='33',name='PWRCTL3/BATEN3',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='OVERCUR4z',do_erc=True),
            Pin(num='53',name='USB_DP_UP',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='VDD33',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='USB_SSRXP_DN2',do_erc=True),
            Pin(num='24',name='USB_DP_DN4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='VDD33',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='OVERCUR3z',do_erc=True),
            Pin(num='54',name='USB_DM_UP',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='USB_R1',do_erc=True),
            Pin(num='15',name='USB_SSRXM_DN2',do_erc=True),
            Pin(num='25',name='USB_DM_DN4',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PWRCTL2/BATEN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='AUTOENz/HS_SUSPEND',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='USB_SSTXP_UP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='65',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD33',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='USB_SSTXP_DN4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='36',name='PWRCTL1/BATEN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='OVERCUR1z',do_erc=True),
            Pin(num='56',name='USB_SSTXM_UP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='USB_DP_DN3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='USB_SSTXM_DN4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='SDA/SMBDAT',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='OVERCUR2z',do_erc=True),
            Pin(num='57',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='USB_DM_DN3',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='SCL/SMBCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='USB_VBUS',do_erc=True),
            Pin(num='58',name='USB_SSRXP_UP',do_erc=True),
            Pin(num='19',name='USB_SSTXP_DN3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='29',name='USB_SSRXP_DN4',do_erc=True),
            Pin(num='39',name='SMBUSz/SS_SUSPEND',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='TEST',do_erc=True),
            Pin(num='59',name='USB_SSRXM_UP',do_erc=True)]),
        Part(name='TXB0108DQSR',dest=TEMPLATE,tool=SKIDL,keywords='bidirectional voltage level translator',description='8-bit bidirectional voltage level translator with auto-direction sensing USON package',ref_prefix='U',num_units=1,fplist=['USON*2x4mm*Pitch0.4mm*'],do_erc=True,pins=[
            Pin(num='1',name='A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='OE',do_erc=True),
            Pin(num='7',name='A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='B1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='B8',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='B7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='B6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='B5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='B4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='B3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='B2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VCCB',func=Pin.PWRIN,do_erc=True)]),
        Part(name='UCC2891',dest=TEMPLATE,tool=SKIDL,keywords='SMPS PWM Controller',description='SMPS Current-Mode Active Clamp PWM Controller, SOIC-16/TSSOP-16',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x9.9mm*Pitch1.27mm*', 'TSSOP*4.4x5mm*Pitch0.65mm*'],do_erc=True,aliases=['UCC2893'],pins=[
            Pin(num='1',name='RTDEL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='RTON',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='RTOFF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='VREF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='SYNC',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='CS',do_erc=True),
            Pin(num='8',name='RSLOPE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='FB',do_erc=True),
            Pin(num='10',name='SS/SD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='AUX',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='LINEUV',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='VIN',do_erc=True)]),
        Part(name='UCC2892',dest=TEMPLATE,tool=SKIDL,keywords='SMPS PWM Controller',description='SMPS Current-Mode Active Clamp PWM Controller, SOIC-16/TSSOP-16',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x9.9mm*Pitch1.27mm*', 'TSSOP*4.4x5mm*Pitch0.65mm*'],do_erc=True,aliases=['UCC2894'],pins=[
            Pin(num='1',name='RTDEL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='RTON',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='RTOFF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='VREF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='SYNC',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='CS',do_erc=True),
            Pin(num='8',name='RSLOPE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='FB',do_erc=True),
            Pin(num='10',name='SS/SD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='AUX',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='LINEUV',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='LINEOV',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='UCC2897',dest=TEMPLATE,tool=SKIDL,keywords='SMPS PWM Controller',description='SMPS Advanced Current-Mode Active Clamp PWM Controller, TSSOP-20/QFN-20',ref_prefix='U',num_units=1,fplist=['TSSOP*4.4x6.5mm*Pitch0.65mm*', 'QFN*4x4mm*Pitch0.5mm'],do_erc=True,pins=[
            Pin(num='1',name='VIN',do_erc=True),
            Pin(num='2',name='N/C',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='RTDEL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='RTON',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='RTOFF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='VREF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='SYNC',do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='CS',do_erc=True),
            Pin(num='10',name='RSLOPE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='N/C',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='11',name='FB',do_erc=True),
            Pin(num='12',name='SS/SD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='AUX',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='PVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='LINEUV',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='LINEOV',func=Pin.PASSIVE,do_erc=True)])])