from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

Power_Management = SchLib(tool=SKIDL).add_parts(*[
        Part(name='FAN7842',dest=TEMPLATE,tool=SKIDL,keywords='gate driver',description='High and Low Side Gate Driver',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='HIN',do_erc=True),
            Pin(num='3',name='LIN',do_erc=True),
            Pin(num='4',name='COM',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='LO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='HO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VB',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LM5051',dest=TEMPLATE,tool=SKIDL,keywords='negative low-side or-ing ideal-diode',description='Low side OR-ing FET controller, -6V to -100V operation',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='Line',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='OFF',do_erc=True),
            Pin(num='4',name='~FGD',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='INN',do_erc=True),
            Pin(num='7',name='INP',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='GATE',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LM5060',dest=TEMPLATE,tool=SKIDL,keywords='high-voltage mosfet-driver hot-swap',description='High side protection controller, +5.5V to +65V operation, VSSOP-10 package',ref_prefix='U',num_units=1,fplist=['*SOP*3x3mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='SENSE',do_erc=True),
            Pin(num='2',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='OVP',do_erc=True),
            Pin(num='4',name='UVLO',do_erc=True),
            Pin(num='5',name='EN',do_erc=True),
            Pin(num='7',name='TIMER',do_erc=True),
            Pin(num='8',name='~PGD',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='OUT',do_erc=True),
            Pin(num='10',name='GATE',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LT1641-1',dest=TEMPLATE,tool=SKIDL,keywords='power switch FET driver',description='Positive high voltage hot swap controller +10V to +80V with auto-retry operation',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch_1.27mm*'],do_erc=True,aliases=['LT1641-2', 'MIC2587-1', 'MIC2587R-1'],pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='ON',do_erc=True),
            Pin(num='2',name='FB',do_erc=True),
            Pin(num='3',name='PWRGD',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='5',name='TIMER',do_erc=True),
            Pin(num='6',name='GATE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Sense',do_erc=True),
            Pin(num='8',name='Vcc',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC4007',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='LTC4357DCB',dest=TEMPLATE,tool=SKIDL,keywords='ideal-diode or-ing',description='Ideal diode controller, 9-80V operation, DFN-6 package',ref_prefix='U',num_units=1,fplist=['DFN*1EP*3.2mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='OUT',do_erc=True),
            Pin(num='2',name='IN',do_erc=True),
            Pin(num='3',name='GATE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PAD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC4357MS8',dest=TEMPLATE,tool=SKIDL,keywords='ideal-diode or-ing',description='Ideal diode controller, 9-80V operation, MSOP-8 package',ref_prefix='U',num_units=1,fplist=['MSOP*3x3mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='IN',do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='GATE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='OUT',do_erc=True)]),
        Part(name='LTC4359-DCB',dest=TEMPLATE,tool=SKIDL,keywords='ideal-diode or-ing reverse-protection',description='Ideal diode controller with reverse input protection, DFN-6 package',ref_prefix='U',num_units=1,fplist=['DFN*1EP*3x2mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='OUT',do_erc=True),
            Pin(num='2',name='GATE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='SRC',do_erc=True),
            Pin(num='4',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~SHDN',do_erc=True),
            Pin(num='6',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='Pad',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC4359-MS8',dest=TEMPLATE,tool=SKIDL,keywords='ideal-diode or-ing reverse-protection',description='Ideal diode controller with reverse input protection, MSOP-8 package',ref_prefix='U',num_units=1,fplist=['MSOP*3x3mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='GATE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='SRC',do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~SHDN',do_erc=True),
            Pin(num='6',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='OUT',do_erc=True)]),
        Part(name='LTC4364CDE',dest=TEMPLATE,tool=SKIDL,keywords='surge overvoltage undervoltage reverse-polarity protection diode ORing MOSFET driver',description='Surge stopper with ideal diode, UV and OV protection -40V to +80V in DFN-14 package, -40°C to +85°C',ref_prefix='U',num_units=1,fplist=['DFN*3x4mm*Pitch0.5mm*'],do_erc=True,aliases=['LTC4364IDE', 'LTC4364HDE'],pins=[
            Pin(num='1',name='OUT',do_erc=True),
            Pin(num='2',name='SENSE',do_erc=True),
            Pin(num='3',name='DGATE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='SOURCE',do_erc=True),
            Pin(num='5',name='GATE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='~SHDN',do_erc=True),
            Pin(num='8',name='UV',do_erc=True),
            Pin(num='9',name='OV',do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='~FLT',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='ENOUT',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='13',name='TMR',do_erc=True),
            Pin(num='14',name='FB',do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC4364CMS',dest=TEMPLATE,tool=SKIDL,keywords='surge overvoltage undervoltage reverse-polarity protection diode ORing MOSFET driver',description='Surge stopper with ideal diode, UV and OV protection -40V to +80V in MSOP-16 package, -40°C to +85°C',ref_prefix='U',num_units=1,fplist=['MSOP*3x4mm*Pitch0.5mm*'],do_erc=True,aliases=['LTC4364IMS', 'LTC4364HMS'],pins=[
            Pin(num='1',name='OUT',do_erc=True),
            Pin(num='2',name='SENSE',do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='DGATE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='SOURCE',do_erc=True),
            Pin(num='6',name='HGATE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='~SHDN',do_erc=True),
            Pin(num='10',name='UV',do_erc=True),
            Pin(num='11',name='OV',do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='~FLT',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='14',name='ENOUT',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='15',name='TMR',do_erc=True),
            Pin(num='16',name='FB',do_erc=True)]),
        Part(name='LTC4364CS',dest=TEMPLATE,tool=SKIDL,keywords='surge overvoltage undervoltage reverse-polarity protection diode ORing MOSFET driver',description='Surge stopper with ideal diode, UV and OV protection -40V to +80V in SOIC-16 package, -40°C to +85°C',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x9.9mm*Pitch1.27mm*'],do_erc=True,aliases=['LTC4364IS', 'LTC4364HS'],pins=[
            Pin(num='1',name='OUT',do_erc=True),
            Pin(num='2',name='SENSE',do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='DGATE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='SOURCE',do_erc=True),
            Pin(num='6',name='HGATE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='~SHDN',do_erc=True),
            Pin(num='10',name='UV',do_erc=True),
            Pin(num='11',name='OV',do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='~FLT',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='14',name='ENOUT',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='15',name='TMR',do_erc=True),
            Pin(num='16',name='FB',do_erc=True)]),
        Part(name='LTC4365DDB',dest=TEMPLATE,tool=SKIDL,keywords='overvoltage undervoltage reverse-polarity protection',description='Overvoltage, Undervoltage and Reverse Supply Protection Controller, 3x2mm DFN-8 package, 1ms fault recovery',ref_prefix='U',num_units=1,fplist=['DFN*1EP*2x3mm*Pitch0.5mm*'],do_erc=True,aliases=['LTC4365DDB-1'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='OV',do_erc=True),
            Pin(num='3',name='UV',do_erc=True),
            Pin(num='4',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GATE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Vout',do_erc=True),
            Pin(num='7',name='~FAULT',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='~SHDN',do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC4365TS8',dest=TEMPLATE,tool=SKIDL,keywords='overvoltage undervoltage reverse-polarity protection',description='Overvoltage, Undervoltage and Reverse Supply Protection Controller, TSOT23-8 package, 1ms fault recovery',ref_prefix='U',num_units=1,fplist=['*SOT-23*'],do_erc=True,aliases=['LTC4365TS8-1'],pins=[
            Pin(num='1',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='UV',do_erc=True),
            Pin(num='3',name='OV',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~SHDN',do_erc=True),
            Pin(num='6',name='~FAULT',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='7',name='Vout',do_erc=True),
            Pin(num='8',name='GATE',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LTC4417CGN',dest=TEMPLATE,tool=SKIDL,keywords='switch power FET sequence',description='Prioritized PowerPath controller QFN-24, industrial temperature range',ref_prefix='U',num_units=1,fplist=['QFN*4x4mm*Pitch0.5mm*'],do_erc=True,aliases=['LTC4417IGN', 'LTC4417HGN'],pins=[
            Pin(num='1',name='UV1',do_erc=True),
            Pin(num='2',name='OV1',do_erc=True),
            Pin(num='3',name='UV2',do_erc=True),
            Pin(num='4',name='OV2',do_erc=True),
            Pin(num='5',name='UV3',do_erc=True),
            Pin(num='6',name='OV3',do_erc=True),
            Pin(num='7',name='~VALID1',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='~VALID2',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='~VALID3',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='V2',do_erc=True),
            Pin(num='11',name='CAS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='V1',do_erc=True),
            Pin(num='12',name='VOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='EN',do_erc=True),
            Pin(num='13',name='G3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='~SHDN',do_erc=True),
            Pin(num='14',name='VS3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='HYS',do_erc=True),
            Pin(num='15',name='G2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='PAD',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VS2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='G1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='VS1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='V3',do_erc=True)]),
        Part(name='LTC4440EMS8',dest=TEMPLATE,tool=SKIDL,keywords='high-side mosfet-driver',description='High-side, N-Channel, Mosfet driver, 80V input, -40°C to +125°C, MSOP-8 package',ref_prefix='U',num_units=1,fplist=['MSOP*1EP*3x3mm*Pitch0.65mm*'],do_erc=True,aliases=['LTC4440IMS8'],pins=[
            Pin(num='1',name='INP',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='BOOST',do_erc=True),
            Pin(num='7',name='TG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='TS',do_erc=True),
            Pin(num='9',name='PAD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC4440ES6',dest=TEMPLATE,tool=SKIDL,keywords='high-side mosfet-driver',description='High-side, N-Channel, Mosfet driver, 80V input, -40°C to +85°C, SOT23-6 package',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,aliases=['LTC4440IS6'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='INP',do_erc=True),
            Pin(num='4',name='TS',do_erc=True),
            Pin(num='5',name='TG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='BOOST',do_erc=True)]),
        Part(name='MC33064D',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['MC34064D']),
        Part(name='MC34064P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['MC33064P']),
        Part(name='MCP100-270D',dest=TEMPLATE,tool=SKIDL,keywords='supervisor reset push-pull',description='Microcontroller reset monitor, 4.85V threshold, active low output',ref_prefix='U',num_units=1,fplist=['SOT-23*', 'TO-92*'],do_erc=True,aliases=['MCP100-300D', 'MCP100-315D', 'MCP100-450D', 'MCP100-460D', 'MCP100-475D', 'MCP100-485D'],pins=[
            Pin(num='1',name='~RST',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP101-270D',dest=TEMPLATE,tool=SKIDL,keywords='supervisor reset push-pull',description='Microcontroller reset monitor, 4.85V threshold, active high output',ref_prefix='U',num_units=1,fplist=['SOT-23*', 'TO-92*'],do_erc=True,aliases=['MCP101-300D', 'MCP101-315D', 'MCP101-450D', 'MCP101-460D', 'MCP101-475D', 'MCP101-485D'],pins=[
            Pin(num='1',name='RST',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP1415',dest=TEMPLATE,tool=SKIDL,keywords='mosfet gate driver',description='1.5A High speed power MOSFET driver with inverting output',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='IN',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~OUT',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='MCP1415R',dest=TEMPLATE,tool=SKIDL,keywords='mosfet gate driver',description='1.5A High speed power MOSFET driver with inverting output',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='IN',do_erc=True),
            Pin(num='4',name='~OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Vdd',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP1416',dest=TEMPLATE,tool=SKIDL,keywords='mosfet gate driver',description='1.5A High speed power MOSFET driver with non-inverting output',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='IN',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='MCP1416R',dest=TEMPLATE,tool=SKIDL,keywords='mosfet gate driver',description='1.5A High speed power MOSFET driver with non-inverting output',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='IN',do_erc=True),
            Pin(num='4',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Vdd',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MIC2026-1BN',dest=TEMPLATE,tool=SKIDL,keywords='mosfet distribution',description='Dual-channel, high side, power distribution switch, 2.7V-5.5V, Active Low Output, in DIP-8 Package',ref_prefix='U',num_units=1,fplist=['SOIC*', 'DIP*'],do_erc=True,aliases=['MIC2026-1BM', 'MIC2026-2BN', 'MIC2026-2BM'],pins=[
            Pin(num='1',name='ENA',do_erc=True),
            Pin(num='2',name='FLGA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='FLGB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='ENB',do_erc=True),
            Pin(num='5',name='OUTB',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='OUTA',func=Pin.PWROUT,do_erc=True)]),
        Part(name='RT9701',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='TCM809',dest=TEMPLATE,tool=SKIDL,keywords='supervisor reset push-pull',description='Microcontroller reset monitor, active low output',ref_prefix='U',num_units=1,fplist=['SOT-23*', 'SC-70*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~RESET~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TCM810',dest=TEMPLATE,tool=SKIDL,keywords='supervisor reset push-pull',description='Microcontroller reset monitor, active high output',ref_prefix='U',num_units=1,fplist=['SOT-23*', 'SC-70*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='RESET',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TL7702',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['TL7705'])])