from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

conn = SchLib(tool=SKIDL).add_parts(*[
        Part(name='BARREL_JACK',dest=TEMPLATE,tool=SKIDL,keywords='DC power barrel jack connector',description='DC Barrel Jack',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='BUSAT',dest=TEMPLATE,tool=SKIDL,keywords='ISA',description='Connector BUS ISA 16 bits',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='RESET',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='+5V',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='IRQ2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='-5V',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='DRQ2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='-12V',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='UNUSED',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='+12V',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='CLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='30',name='OSC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='40',name='DB0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='50',name='BA12',func=Pin.TRISTATE,do_erc=True),
            Pin(num='60',name='BA02',func=Pin.TRISTATE,do_erc=True),
            Pin(num='70',name='DACK0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='80',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='90',name='MEMW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='SMEMW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='IRQ7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='IO_READY',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='BA11',func=Pin.TRISTATE,do_erc=True),
            Pin(num='61',name='BA01',func=Pin.TRISTATE,do_erc=True),
            Pin(num='71',name='DRQ0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='81',name='SBHE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='91',name='D8',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='SMEMR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='IRQ6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='IO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='AEN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='52',name='BA10',func=Pin.TRISTATE,do_erc=True),
            Pin(num='62',name='BA00',func=Pin.TRISTATE,do_erc=True),
            Pin(num='72',name='DACK5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='82',name='LA23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='92',name='D9',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='IOW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='IRQ5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='DB7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='43',name='BA19',func=Pin.TRISTATE,do_erc=True),
            Pin(num='53',name='BA09',func=Pin.TRISTATE,do_erc=True),
            Pin(num='63',name='MEMCS16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='73',name='DRQ5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='83',name='LA22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='93',name='D10',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='IOR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='IRQ4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='DB6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='44',name='BA18',func=Pin.TRISTATE,do_erc=True),
            Pin(num='54',name='BA08',func=Pin.TRISTATE,do_erc=True),
            Pin(num='64',name='IOCS16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='74',name='DACK6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='84',name='LA21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='94',name='D11',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='DACK3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='IRQ3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='DB5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='45',name='BA17',func=Pin.TRISTATE,do_erc=True),
            Pin(num='55',name='BA07',func=Pin.TRISTATE,do_erc=True),
            Pin(num='65',name='IRQ10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='75',name='DRQ6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='85',name='LA20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='95',name='D12',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='DRQ3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='DACK2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='DB4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='46',name='BA16',func=Pin.TRISTATE,do_erc=True),
            Pin(num='56',name='BA06',func=Pin.TRISTATE,do_erc=True),
            Pin(num='66',name='IRQ11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='76',name='DACK7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='86',name='LA19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='96',name='D13',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='DACK1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='TC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='DB3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='47',name='BA15',func=Pin.TRISTATE,do_erc=True),
            Pin(num='57',name='BA05',func=Pin.TRISTATE,do_erc=True),
            Pin(num='67',name='IRQ12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='77',name='DRQ7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='87',name='LA18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='97',name='D14',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='DRQ1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='ALE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='DB2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='48',name='BA14',func=Pin.TRISTATE,do_erc=True),
            Pin(num='58',name='BA04',func=Pin.TRISTATE,do_erc=True),
            Pin(num='68',name='IRQ15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='78',name='+5V',func=Pin.PASSIVE,do_erc=True),
            Pin(num='88',name='LA17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='98',name='D15',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='REFRESH',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='VCC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='DB1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='49',name='BA13',func=Pin.TRISTATE,do_erc=True),
            Pin(num='59',name='BA03',func=Pin.TRISTATE,do_erc=True),
            Pin(num='69',name='IRQ14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='79',name='MASTER',func=Pin.PASSIVE,do_erc=True),
            Pin(num='89',name='MEMR',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='BUSPC',dest=TEMPLATE,tool=SKIDL,keywords='ISA',description='Connector BUS ISA 8 Bits',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='RESET',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='INQ2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='-5V',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='DRQ2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='-12V',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='UNUSED',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='+12V',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='CLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='30',name='OSC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='40',name='DB0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='50',name='BA12',func=Pin.TRISTATE,do_erc=True),
            Pin(num='60',name='BA02',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='MEM',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='IRQ7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='IO_READY',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='BA11',func=Pin.TRISTATE,do_erc=True),
            Pin(num='61',name='BA01',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='MEM',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='IRQ6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='IO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='AEN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='52',name='BA10',func=Pin.TRISTATE,do_erc=True),
            Pin(num='62',name='BA00',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='IOW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='IRQ5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='DB7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='43',name='BA19',func=Pin.TRISTATE,do_erc=True),
            Pin(num='53',name='BA09',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='IOR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='IRQ4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='DB6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='44',name='BA18',func=Pin.TRISTATE,do_erc=True),
            Pin(num='54',name='BA08',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='DACK3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='IRQ3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='DB5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='45',name='BA17',func=Pin.TRISTATE,do_erc=True),
            Pin(num='55',name='BA07',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='DRQ3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='DACK2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='DB4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='46',name='BA16',func=Pin.TRISTATE,do_erc=True),
            Pin(num='56',name='BA06',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='DACK1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='TC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='DB3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='47',name='BA15',func=Pin.TRISTATE,do_erc=True),
            Pin(num='57',name='BA05',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='DRQ1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='ALE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='DB2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='48',name='BA14',func=Pin.TRISTATE,do_erc=True),
            Pin(num='58',name='BA04',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='DACK0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='VCC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='DB1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='49',name='BA13',func=Pin.TRISTATE,do_erc=True),
            Pin(num='59',name='BA03',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='C64AB',dest=TEMPLATE,tool=SKIDL,keywords='connector DIN',description='Connector Europe 64 contacts ranges A,B',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='A1',name='1A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B1',name='1B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A2',name='2A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B2',name='2B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A3',name='3A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B3',name='3B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A4',name='4A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B4',name='4B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A5',name='5A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B5',name='5B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A6',name='6A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B6',name='6B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A7',name='7A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B7',name='7B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A8',name='8A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B8',name='8B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A9',name='9A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B9',name='9B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A10',name='10A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B10',name='10B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A20',name='20A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B20',name='20B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A30',name='30A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B30',name='30B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A11',name='11A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B11',name='11B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A21',name='21A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B21',name='21B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A31',name='31A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B31',name='31B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A12',name='12A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B12',name='12B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A22',name='22A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B22',name='22B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A32',name='32A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B32',name='32B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A13',name='13A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B13',name='13B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A23',name='23A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B23',name='23B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A14',name='14A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B14',name='14B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A24',name='24A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B24',name='24B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A15',name='15A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B15',name='15B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A25',name='25A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B25',name='25B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A16',name='16A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B16',name='16B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A26',name='26A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B26',name='26B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A17',name='17A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B17',name='17B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A27',name='27A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B27',name='27B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A18',name='18A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B18',name='18B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A28',name='28A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B28',name='28B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A19',name='19A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B19',name='19B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A29',name='29A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B29',name='29B',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='C64AC',dest=TEMPLATE,tool=SKIDL,keywords='connector DIN',description='Connector Europe 64 contacts, ranges A,B,C',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='A1',name='1A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C1',name='1C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A2',name='2A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C2',name='2C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A3',name='3A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C3',name='3C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A4',name='4A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C4',name='4C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A5',name='5A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C5',name='5C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A6',name='6A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C6',name='6C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A7',name='7A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C7',name='7C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A8',name='8A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C8',name='8C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A9',name='9A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C9',name='9C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A10',name='10A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C10',name='10C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A20',name='20A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C20',name='20C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A30',name='30A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C30',name='30C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A11',name='11A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C11',name='11C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A21',name='21A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C21',name='21C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A31',name='31A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C31',name='31C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A12',name='12A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C12',name='12C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A22',name='22A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C22',name='22C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A32',name='32A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C32',name='32C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A13',name='13A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C13',name='13C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A23',name='23A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C23',name='23C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A14',name='14A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C14',name='14C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A24',name='24A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C24',name='24C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A15',name='15A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C15',name='15C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A25',name='25A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C25',name='25C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A16',name='16A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C16',name='16C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A26',name='26A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C26',name='26C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A17',name='17A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C17',name='17C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A27',name='27A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C27',name='27C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A18',name='18A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C18',name='18C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A28',name='28A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C28',name='28C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A19',name='19A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C19',name='19C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A29',name='29A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C29',name='29C',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='C96ABC',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector Europe, 96 contacts, ranges A,B,C',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='A1',name='1A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B1',name='1B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C1',name='1C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A2',name='2A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B2',name='2B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C2',name='2C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A3',name='3A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B3',name='3B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C3',name='3C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A4',name='4A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B4',name='4B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C4',name='4C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A5',name='5A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B5',name='5B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C5',name='5C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A6',name='6A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B6',name='6B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C6',name='6C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A7',name='7A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B7',name='7B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C7',name='7C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A8',name='8A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B8',name='8B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C8',name='8C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A9',name='9A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B9',name='9B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C9',name='9C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A10',name='10A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B10',name='10B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C10',name='10C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A20',name='20A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B20',name='20B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C20',name='20C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A30',name='30A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B30',name='30B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C30',name='30C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A11',name='11A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B11',name='11B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C11',name='11C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A21',name='21A',func=Pin.TRISTATE,do_erc=True),
            Pin(num='B21',name='21B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C21',name='21C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A31',name='31A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B31',name='31B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C31',name='31C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A12',name='12A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B12',name='12B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C12',name='12C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A22',name='22A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B22',name='22B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C22',name='22C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A32',name='32A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B32',name='32B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C32',name='32C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A13',name='13A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B13',name='13B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C13',name='13C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A23',name='23A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B23',name='23B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C23',name='23C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A14',name='14A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B14',name='14B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C14',name='14C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A24',name='24A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B24',name='24B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C24',name='24C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A15',name='15A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B15',name='15B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C15',name='15C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A25',name='25A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B25',name='25B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C25',name='25C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A16',name='16A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B16',name='16B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C16',name='16C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A26',name='26A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B26',name='26B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C26',name='26C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A17',name='17A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B17',name='17B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C17',name='17C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A27',name='27A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B27',name='27B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C27',name='27C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A18',name='18A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B18',name='18B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C18',name='18C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A28',name='28A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B28',name='28B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C28',name='28C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A19',name='19A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B19',name='19B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C19',name='19C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A29',name='29A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B29',name='29B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C29',name='29C',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X01',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x01, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X01_FEMALE',dest=TEMPLATE,tool=SKIDL,keywords='Connector, Female, Generic',description='Generic Female Connector, Single Row, 01x01, socket header',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X01_MALE',dest=TEMPLATE,tool=SKIDL,keywords='Connector, Male, Generic',description='Generic Male Connector, single row, 01x01, pin header',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X02',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x02, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X02_FEMALE',dest=TEMPLATE,tool=SKIDL,keywords='Connector, Female, Generic',description='Generic Female Connector, Single Row, 01x02, socket header',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X02_MALE',dest=TEMPLATE,tool=SKIDL,keywords='Connector, Male, Generic',description='Generic Male Connector, single row, 01x02, pin header',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X03',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x03, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X03_FEMALE',dest=TEMPLATE,tool=SKIDL,keywords='Connector, Female, Generic',description='Generic Female Connector, Single Row, 01x03, socket header',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X03_MALE',dest=TEMPLATE,tool=SKIDL,keywords='Connector, Male, Generic',description='Generic Male Connector, single row, 01x03, pin header',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X04',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x04, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X04_FEMALE',dest=TEMPLATE,tool=SKIDL,keywords='Connector, Female, Generic',description='Generic Female Connector, Single Row, 01x04, socket header',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X04_MALE',dest=TEMPLATE,tool=SKIDL,keywords='Connector, Male, Generic',description='Generic Male Connector, single row, 01x04, pin header',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X05',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x05, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X06',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x06, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X07',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x07, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X08',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x08, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X09',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x09, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X10',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x10, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X11',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x11, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X12',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x12, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X13',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x13, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X14',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x14, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X15',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x15, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X16',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x16, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X17',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x17, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X18',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x18, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X19',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x19, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X20',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x20, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X21',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x21, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X22',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x22, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X23',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x23, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X24',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x24, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X25',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x25, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X26',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x26, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X27',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x27, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X28',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x28, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X29',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x29, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X30',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x30, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X31',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x31, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X32',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x32, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X33',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x33, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X34',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x34, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X35',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x35, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X36',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x36, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X37',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x37, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X38',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x38, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X39',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x39, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_01X40',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, single row, 01x40, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_1X*', 'Pin_Header_Angled_1X*', 'Socket_Strip_Straight_1X*', 'Socket_Strip_Angled_1X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X01',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x01, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X02',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x02, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X03',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x03, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*', 'IDC_Header_Straight_*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X04',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x04, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*', 'IDC_Header_Straight_*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X05',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x05, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*', 'IDC_Header_Straight_*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X06',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x06, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*', 'IDC_Header_Straight_*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X07',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x07, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*', 'IDC_Header_Straight_*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X08',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x08, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*', 'IDC_Header_Straight_*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X09',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x09, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X10',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x10, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*', 'IDC_Header_Straight_*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X11',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x11, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X12',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x12, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X13',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x13, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*', 'IDC_Header_Straight_*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X14',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x14, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X15',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x15, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*', 'IDC_Header_Straight_*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X16',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x16, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X17',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x17, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*', 'IDC_Header_Straight_*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X18',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x18, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X19',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x19, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X20',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x20, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*', 'IDC_Header_Straight_*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X21',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x21, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X22',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x22, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X23',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x23, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X24',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x24, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='P47',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='P48',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X25',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x25, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*', 'IDC_Header_Straight_*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='P50',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='P47',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='P48',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True),
            Pin(num='49',name='P49',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X26',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x26, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='P50',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='P51',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='P52',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='P47',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='P48',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True),
            Pin(num='49',name='P49',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X27',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x27, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='P50',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='P51',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='P52',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='53',name='P53',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='P54',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='P47',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='P48',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True),
            Pin(num='49',name='P49',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X28',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x28, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='P50',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='P51',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='P52',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='53',name='P53',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='P54',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='55',name='P55',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='P56',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='P47',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='P48',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True),
            Pin(num='49',name='P49',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X29',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x29, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='P50',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='P51',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='P52',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='53',name='P53',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='P54',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='55',name='P55',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='P56',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='P47',func=Pin.PASSIVE,do_erc=True),
            Pin(num='57',name='P57',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='P48',func=Pin.PASSIVE,do_erc=True),
            Pin(num='58',name='P58',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True),
            Pin(num='49',name='P49',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X30',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x30, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*', 'IDC_Header_Straight_*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='P50',func=Pin.PASSIVE,do_erc=True),
            Pin(num='60',name='P60',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='P51',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='P52',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='53',name='P53',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='P54',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='55',name='P55',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='P56',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='P47',func=Pin.PASSIVE,do_erc=True),
            Pin(num='57',name='P57',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='P48',func=Pin.PASSIVE,do_erc=True),
            Pin(num='58',name='P58',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True),
            Pin(num='49',name='P49',func=Pin.PASSIVE,do_erc=True),
            Pin(num='59',name='P59',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X31',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x31, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='P50',func=Pin.PASSIVE,do_erc=True),
            Pin(num='60',name='P60',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='P51',func=Pin.PASSIVE,do_erc=True),
            Pin(num='61',name='P61',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='P52',func=Pin.PASSIVE,do_erc=True),
            Pin(num='62',name='P62',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='53',name='P53',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='P54',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='55',name='P55',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='P56',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='P47',func=Pin.PASSIVE,do_erc=True),
            Pin(num='57',name='P57',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='P48',func=Pin.PASSIVE,do_erc=True),
            Pin(num='58',name='P58',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True),
            Pin(num='49',name='P49',func=Pin.PASSIVE,do_erc=True),
            Pin(num='59',name='P59',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X32',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x32, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*', 'IDC_Header_Straight_*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='P50',func=Pin.PASSIVE,do_erc=True),
            Pin(num='60',name='P60',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='P51',func=Pin.PASSIVE,do_erc=True),
            Pin(num='61',name='P61',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='P52',func=Pin.PASSIVE,do_erc=True),
            Pin(num='62',name='P62',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='53',name='P53',func=Pin.PASSIVE,do_erc=True),
            Pin(num='63',name='P63',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='P54',func=Pin.PASSIVE,do_erc=True),
            Pin(num='64',name='P64',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='55',name='P55',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='P56',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='P47',func=Pin.PASSIVE,do_erc=True),
            Pin(num='57',name='P57',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='P48',func=Pin.PASSIVE,do_erc=True),
            Pin(num='58',name='P58',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True),
            Pin(num='49',name='P49',func=Pin.PASSIVE,do_erc=True),
            Pin(num='59',name='P59',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X33',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x33, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='P50',func=Pin.PASSIVE,do_erc=True),
            Pin(num='60',name='P60',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='P51',func=Pin.PASSIVE,do_erc=True),
            Pin(num='61',name='P61',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='P52',func=Pin.PASSIVE,do_erc=True),
            Pin(num='62',name='P62',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='53',name='P53',func=Pin.PASSIVE,do_erc=True),
            Pin(num='63',name='P63',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='P54',func=Pin.PASSIVE,do_erc=True),
            Pin(num='64',name='P64',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='55',name='P55',func=Pin.PASSIVE,do_erc=True),
            Pin(num='65',name='P65',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='P56',func=Pin.PASSIVE,do_erc=True),
            Pin(num='66',name='P66',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='P47',func=Pin.PASSIVE,do_erc=True),
            Pin(num='57',name='P57',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='P48',func=Pin.PASSIVE,do_erc=True),
            Pin(num='58',name='P58',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True),
            Pin(num='49',name='P49',func=Pin.PASSIVE,do_erc=True),
            Pin(num='59',name='P59',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X34',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x34, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='P50',func=Pin.PASSIVE,do_erc=True),
            Pin(num='60',name='P60',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='P51',func=Pin.PASSIVE,do_erc=True),
            Pin(num='61',name='P61',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='P52',func=Pin.PASSIVE,do_erc=True),
            Pin(num='62',name='P62',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='53',name='P53',func=Pin.PASSIVE,do_erc=True),
            Pin(num='63',name='P63',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='P54',func=Pin.PASSIVE,do_erc=True),
            Pin(num='64',name='P64',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='55',name='P55',func=Pin.PASSIVE,do_erc=True),
            Pin(num='65',name='P65',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='P56',func=Pin.PASSIVE,do_erc=True),
            Pin(num='66',name='P66',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='P47',func=Pin.PASSIVE,do_erc=True),
            Pin(num='57',name='P57',func=Pin.PASSIVE,do_erc=True),
            Pin(num='67',name='P67',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='P48',func=Pin.PASSIVE,do_erc=True),
            Pin(num='58',name='P58',func=Pin.PASSIVE,do_erc=True),
            Pin(num='68',name='P68',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True),
            Pin(num='49',name='P49',func=Pin.PASSIVE,do_erc=True),
            Pin(num='59',name='P59',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X35',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x35, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='P50',func=Pin.PASSIVE,do_erc=True),
            Pin(num='60',name='P60',func=Pin.PASSIVE,do_erc=True),
            Pin(num='70',name='P70',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='P51',func=Pin.PASSIVE,do_erc=True),
            Pin(num='61',name='P61',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='P52',func=Pin.PASSIVE,do_erc=True),
            Pin(num='62',name='P62',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='53',name='P53',func=Pin.PASSIVE,do_erc=True),
            Pin(num='63',name='P63',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='P54',func=Pin.PASSIVE,do_erc=True),
            Pin(num='64',name='P64',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='55',name='P55',func=Pin.PASSIVE,do_erc=True),
            Pin(num='65',name='P65',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='P56',func=Pin.PASSIVE,do_erc=True),
            Pin(num='66',name='P66',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='P47',func=Pin.PASSIVE,do_erc=True),
            Pin(num='57',name='P57',func=Pin.PASSIVE,do_erc=True),
            Pin(num='67',name='P67',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='P48',func=Pin.PASSIVE,do_erc=True),
            Pin(num='58',name='P58',func=Pin.PASSIVE,do_erc=True),
            Pin(num='68',name='P68',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True),
            Pin(num='49',name='P49',func=Pin.PASSIVE,do_erc=True),
            Pin(num='59',name='P59',func=Pin.PASSIVE,do_erc=True),
            Pin(num='69',name='P69',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X36',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x36, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='P50',func=Pin.PASSIVE,do_erc=True),
            Pin(num='60',name='P60',func=Pin.PASSIVE,do_erc=True),
            Pin(num='70',name='P70',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='P51',func=Pin.PASSIVE,do_erc=True),
            Pin(num='61',name='P61',func=Pin.PASSIVE,do_erc=True),
            Pin(num='71',name='P71',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='P52',func=Pin.PASSIVE,do_erc=True),
            Pin(num='62',name='P62',func=Pin.PASSIVE,do_erc=True),
            Pin(num='72',name='P72',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='53',name='P53',func=Pin.PASSIVE,do_erc=True),
            Pin(num='63',name='P63',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='P54',func=Pin.PASSIVE,do_erc=True),
            Pin(num='64',name='P64',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='55',name='P55',func=Pin.PASSIVE,do_erc=True),
            Pin(num='65',name='P65',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='P56',func=Pin.PASSIVE,do_erc=True),
            Pin(num='66',name='P66',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='P47',func=Pin.PASSIVE,do_erc=True),
            Pin(num='57',name='P57',func=Pin.PASSIVE,do_erc=True),
            Pin(num='67',name='P67',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='P48',func=Pin.PASSIVE,do_erc=True),
            Pin(num='58',name='P58',func=Pin.PASSIVE,do_erc=True),
            Pin(num='68',name='P68',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True),
            Pin(num='49',name='P49',func=Pin.PASSIVE,do_erc=True),
            Pin(num='59',name='P59',func=Pin.PASSIVE,do_erc=True),
            Pin(num='69',name='P69',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X37',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x37, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='P50',func=Pin.PASSIVE,do_erc=True),
            Pin(num='60',name='P60',func=Pin.PASSIVE,do_erc=True),
            Pin(num='70',name='P70',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='P51',func=Pin.PASSIVE,do_erc=True),
            Pin(num='61',name='P61',func=Pin.PASSIVE,do_erc=True),
            Pin(num='71',name='P71',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='P52',func=Pin.PASSIVE,do_erc=True),
            Pin(num='62',name='P62',func=Pin.PASSIVE,do_erc=True),
            Pin(num='72',name='P72',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='53',name='P53',func=Pin.PASSIVE,do_erc=True),
            Pin(num='63',name='P63',func=Pin.PASSIVE,do_erc=True),
            Pin(num='73',name='P73',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='P54',func=Pin.PASSIVE,do_erc=True),
            Pin(num='64',name='P64',func=Pin.PASSIVE,do_erc=True),
            Pin(num='74',name='P74',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='55',name='P55',func=Pin.PASSIVE,do_erc=True),
            Pin(num='65',name='P65',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='P56',func=Pin.PASSIVE,do_erc=True),
            Pin(num='66',name='P66',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='P47',func=Pin.PASSIVE,do_erc=True),
            Pin(num='57',name='P57',func=Pin.PASSIVE,do_erc=True),
            Pin(num='67',name='P67',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='P48',func=Pin.PASSIVE,do_erc=True),
            Pin(num='58',name='P58',func=Pin.PASSIVE,do_erc=True),
            Pin(num='68',name='P68',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True),
            Pin(num='49',name='P49',func=Pin.PASSIVE,do_erc=True),
            Pin(num='59',name='P59',func=Pin.PASSIVE,do_erc=True),
            Pin(num='69',name='P69',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X38',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x38, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='P50',func=Pin.PASSIVE,do_erc=True),
            Pin(num='60',name='P60',func=Pin.PASSIVE,do_erc=True),
            Pin(num='70',name='P70',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='P51',func=Pin.PASSIVE,do_erc=True),
            Pin(num='61',name='P61',func=Pin.PASSIVE,do_erc=True),
            Pin(num='71',name='P71',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='P52',func=Pin.PASSIVE,do_erc=True),
            Pin(num='62',name='P62',func=Pin.PASSIVE,do_erc=True),
            Pin(num='72',name='P72',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='53',name='P53',func=Pin.PASSIVE,do_erc=True),
            Pin(num='63',name='P63',func=Pin.PASSIVE,do_erc=True),
            Pin(num='73',name='P73',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='P54',func=Pin.PASSIVE,do_erc=True),
            Pin(num='64',name='P64',func=Pin.PASSIVE,do_erc=True),
            Pin(num='74',name='P74',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='55',name='P55',func=Pin.PASSIVE,do_erc=True),
            Pin(num='65',name='P65',func=Pin.PASSIVE,do_erc=True),
            Pin(num='75',name='P75',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='P56',func=Pin.PASSIVE,do_erc=True),
            Pin(num='66',name='P66',func=Pin.PASSIVE,do_erc=True),
            Pin(num='76',name='P76',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='P47',func=Pin.PASSIVE,do_erc=True),
            Pin(num='57',name='P57',func=Pin.PASSIVE,do_erc=True),
            Pin(num='67',name='P67',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='P48',func=Pin.PASSIVE,do_erc=True),
            Pin(num='58',name='P58',func=Pin.PASSIVE,do_erc=True),
            Pin(num='68',name='P68',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True),
            Pin(num='49',name='P49',func=Pin.PASSIVE,do_erc=True),
            Pin(num='59',name='P59',func=Pin.PASSIVE,do_erc=True),
            Pin(num='69',name='P69',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X39',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x39, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='P50',func=Pin.PASSIVE,do_erc=True),
            Pin(num='60',name='P60',func=Pin.PASSIVE,do_erc=True),
            Pin(num='70',name='P70',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='P51',func=Pin.PASSIVE,do_erc=True),
            Pin(num='61',name='P61',func=Pin.PASSIVE,do_erc=True),
            Pin(num='71',name='P71',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='P52',func=Pin.PASSIVE,do_erc=True),
            Pin(num='62',name='P62',func=Pin.PASSIVE,do_erc=True),
            Pin(num='72',name='P72',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='53',name='P53',func=Pin.PASSIVE,do_erc=True),
            Pin(num='63',name='P63',func=Pin.PASSIVE,do_erc=True),
            Pin(num='73',name='P73',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='P54',func=Pin.PASSIVE,do_erc=True),
            Pin(num='64',name='P64',func=Pin.PASSIVE,do_erc=True),
            Pin(num='74',name='P74',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='55',name='P55',func=Pin.PASSIVE,do_erc=True),
            Pin(num='65',name='P65',func=Pin.PASSIVE,do_erc=True),
            Pin(num='75',name='P75',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='P56',func=Pin.PASSIVE,do_erc=True),
            Pin(num='66',name='P66',func=Pin.PASSIVE,do_erc=True),
            Pin(num='76',name='P76',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='P47',func=Pin.PASSIVE,do_erc=True),
            Pin(num='57',name='P57',func=Pin.PASSIVE,do_erc=True),
            Pin(num='67',name='P67',func=Pin.PASSIVE,do_erc=True),
            Pin(num='77',name='P77',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='P48',func=Pin.PASSIVE,do_erc=True),
            Pin(num='58',name='P58',func=Pin.PASSIVE,do_erc=True),
            Pin(num='68',name='P68',func=Pin.PASSIVE,do_erc=True),
            Pin(num='78',name='P78',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True),
            Pin(num='49',name='P49',func=Pin.PASSIVE,do_erc=True),
            Pin(num='59',name='P59',func=Pin.PASSIVE,do_erc=True),
            Pin(num='69',name='P69',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_02X40',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector, double row, 02x40, pin header',ref_prefix='J',num_units=1,fplist=['Pin_Header_Straight_2X*', 'Pin_Header_Angled_2X*', 'Socket_Strip_Straight_2X*', 'Socket_Strip_Angled_2X*'],do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='P50',func=Pin.PASSIVE,do_erc=True),
            Pin(num='60',name='P60',func=Pin.PASSIVE,do_erc=True),
            Pin(num='70',name='P70',func=Pin.PASSIVE,do_erc=True),
            Pin(num='80',name='P80',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='P51',func=Pin.PASSIVE,do_erc=True),
            Pin(num='61',name='P61',func=Pin.PASSIVE,do_erc=True),
            Pin(num='71',name='P71',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='P52',func=Pin.PASSIVE,do_erc=True),
            Pin(num='62',name='P62',func=Pin.PASSIVE,do_erc=True),
            Pin(num='72',name='P72',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='53',name='P53',func=Pin.PASSIVE,do_erc=True),
            Pin(num='63',name='P63',func=Pin.PASSIVE,do_erc=True),
            Pin(num='73',name='P73',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='P54',func=Pin.PASSIVE,do_erc=True),
            Pin(num='64',name='P64',func=Pin.PASSIVE,do_erc=True),
            Pin(num='74',name='P74',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='55',name='P55',func=Pin.PASSIVE,do_erc=True),
            Pin(num='65',name='P65',func=Pin.PASSIVE,do_erc=True),
            Pin(num='75',name='P75',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='P26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='P56',func=Pin.PASSIVE,do_erc=True),
            Pin(num='66',name='P66',func=Pin.PASSIVE,do_erc=True),
            Pin(num='76',name='P76',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='P27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='P37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='P47',func=Pin.PASSIVE,do_erc=True),
            Pin(num='57',name='P57',func=Pin.PASSIVE,do_erc=True),
            Pin(num='67',name='P67',func=Pin.PASSIVE,do_erc=True),
            Pin(num='77',name='P77',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='P38',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='P48',func=Pin.PASSIVE,do_erc=True),
            Pin(num='58',name='P58',func=Pin.PASSIVE,do_erc=True),
            Pin(num='68',name='P68',func=Pin.PASSIVE,do_erc=True),
            Pin(num='78',name='P78',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True),
            Pin(num='49',name='P49',func=Pin.PASSIVE,do_erc=True),
            Pin(num='59',name='P59',func=Pin.PASSIVE,do_erc=True),
            Pin(num='69',name='P69',func=Pin.PASSIVE,do_erc=True),
            Pin(num='79',name='P79',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_15X4',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Connector Europe, 60 contacts, ranges A,B,C,D',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='A1',name='1A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B1',name='1B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C1',name='1C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D1',name='1D',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A2',name='2A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B2',name='2B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C2',name='2C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D2',name='2D',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A3',name='3A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B3',name='3B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C3',name='3C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D3',name='3D',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A4',name='4A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B4',name='4B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C4',name='4C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D4',name='4D',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A5',name='5A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B5',name='5B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C5',name='5C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D5',name='5D',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A6',name='6A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B6',name='6B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C6',name='6C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D6',name='6D',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A7',name='7A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B7',name='7B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C7',name='7C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D7',name='7D',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A8',name='8A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B8',name='8B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C8',name='8C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D8',name='8D',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A9',name='9A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B9',name='9B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C9',name='9C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D9',name='9D',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A10',name='10A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B10',name='10B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C10',name='10C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D10',name='10D',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A11',name='11A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B11',name='11B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C11',name='11C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D11',name='11D',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A12',name='12A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B12',name='12B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C12',name='12C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D12',name='12D',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A13',name='13A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B13',name='13B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C13',name='13C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D13',name='13D',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A14',name='14A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B14',name='14B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C14',name='14C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D14',name='14D',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A15',name='15A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B15',name='15B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C15',name='15C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D15',name='15D',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_ARM_JTAG_SWD_20',dest=TEMPLATE,tool=SKIDL,keywords='IDC20 Male Connector ARM JTAG SWD',description='Standard IDC20 Male Connector, ARM legacy JTAG and SWD interface',ref_prefix='J',num_units=1,fplist=['IDC*Header*Straight*', 'Pin_Header*2x10*Pitch2.54mm*'],do_erc=True,pins=[
            Pin(num='1',name='VTREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VCC/NC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~TRST~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='TDI',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='TMS/SWDIO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='TCK/SWDCLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='RTCK',do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='TDO/SWO',do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='~SRST~',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='DBGRQ/NC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='DBGACK/NC',do_erc=True)]),
        Part(name='CONN_COAXIAL',dest=TEMPLATE,tool=SKIDL,keywords='BNC SMA SMB SMC coaxial connector CINCH RCA',description='coaxial connector (BNC, SMA, SMB, SMC, Cinch/RCA, ...)',ref_prefix='J',num_units=1,fplist=['*BNC*', '*SMA*', '*SMB*', '*SMC*', '*Cinch*'],do_erc=True,pins=[
            Pin(num='1',name='In',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='Ext',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CONN_COAXIAL_x2',dest=TEMPLATE,tool=SKIDL,keywords='BNC SMA SMB SMC coaxial connector CINCH RCA',description='double coaxial connector (BNC, SMA, SMB, SMC, Cinch/RCA, ...)',ref_prefix='J',num_units=1,fplist=['*BNC*', '*SMA*', '*SMB*', '*SMC*', '*Cinch*'],do_erc=True,pins=[
            Pin(num='1',name='IN1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='IN2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='EXT',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB15_FEMALE',dest=TEMPLATE,tool=SKIDL,keywords='female D-SUB connector',description='15-pin female D-SUB connector (low-density/2 columns)',ref_prefix='J',num_units=1,fplist=['DB*F*'],do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P111',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB15_FEMALE_HighDensity',dest=TEMPLATE,tool=SKIDL,keywords='connector db15 VGA female D-SUB',description='15-pin female D-SUB connector, High density (3 columns), Triple Row, Generic, VGA-connector',ref_prefix='J',num_units=1,fplist=['DB*F*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB15_FEMALE_HighDensity_MountingHoles',dest=TEMPLATE,tool=SKIDL,keywords='connector db15 female D-SUB VGA',description='15-pin female D-SUB connector, High density (3 columns), Triple Row, Generic, VGA-connector, Mounting Hole',ref_prefix='J',num_units=1,fplist=['DB*F*'],do_erc=True,pins=[
            Pin(num='0',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB15_FEMALE_MountingHoles',dest=TEMPLATE,tool=SKIDL,keywords='female D-SUB connector',description='15-pin female D-SUB connector (low-density/2 columns), Mounting Hole',ref_prefix='J',num_units=1,fplist=['DB*F*'],do_erc=True,pins=[
            Pin(num='0',name='PAD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P111',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB15_MALE',dest=TEMPLATE,tool=SKIDL,keywords='male D-SUB connector',description='15-pin male D-SUB connector (low-density/2 columns)',ref_prefix='J',num_units=1,fplist=['DB*M*'],do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P111',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB15_MALE_HighDensity',dest=TEMPLATE,tool=SKIDL,keywords='connector male VGA D-SUB',description='15-pin male D-SUB connector, High density (3 columns), Triple Row, Generic, VGA-connector',ref_prefix='J',num_units=1,fplist=['DB*M*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB15_MALE_HighDensity_MountingHoles',dest=TEMPLATE,tool=SKIDL,keywords='connector male D-SUB VGA',description='15-pin male D-SUB connector, High density (3 columns), Triple Row, Generic, VGA-connector, Mounting Hole',ref_prefix='J',num_units=1,fplist=['DB*M*'],do_erc=True,pins=[
            Pin(num='0',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB15_MALE_MountingHoles',dest=TEMPLATE,tool=SKIDL,keywords='male D-SUB connector',description='15-pin male D-SUB connector (low-density/2 columns), Mounting Hole',ref_prefix='J',num_units=1,fplist=['DB*M*'],do_erc=True,pins=[
            Pin(num='0',name='PAD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P111',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB25_FEMALE',dest=TEMPLATE,tool=SKIDL,keywords='female D-SUB connector',description='25-pin female D-SUB connector',ref_prefix='J',num_units=1,fplist=['DB*F*'],do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB25_FEMALE_MountingHoles',dest=TEMPLATE,tool=SKIDL,keywords='female D-SUB connector',description='25-pin female D-SUB connector, Mounting Hole',ref_prefix='J',num_units=1,fplist=['DB*F*'],do_erc=True,pins=[
            Pin(num='0',name='PAD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB25_MALE',dest=TEMPLATE,tool=SKIDL,keywords='male D-SUB connector',description='25-pin male D-SUB connector',ref_prefix='J',num_units=1,fplist=['DB*M*'],do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB25_MALE_MountingHoles',dest=TEMPLATE,tool=SKIDL,keywords='male D-SUB connector',description='25-pin male D-SUB connector, Mounting Hole',ref_prefix='J',num_units=1,fplist=['DB*M*'],do_erc=True,pins=[
            Pin(num='0',name='PAD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='P22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='P23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='P24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='P25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB37_FEMALE',dest=TEMPLATE,tool=SKIDL,keywords='female D-SUB connector',description='37-pin female D-SUB connector',ref_prefix='J',num_units=1,fplist=['DB*F*'],do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB37_FEMALE_MountingHoles',dest=TEMPLATE,tool=SKIDL,keywords='female D-SUB connector',description='37-pin female D-SUB connector, Mounting Hole',ref_prefix='J',num_units=1,fplist=['DB*F*'],do_erc=True,pins=[
            Pin(num='0',name='PAD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB37_MALE',dest=TEMPLATE,tool=SKIDL,keywords='male D-SUB connector',description='37-pin male D-SUB connector',ref_prefix='J',num_units=1,fplist=['DB*M*'],do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB37_MALE_MountingHoles',dest=TEMPLATE,tool=SKIDL,keywords='male D-SUB connector',description='37-pin male D-SUB connector, Mounting Hole',ref_prefix='J',num_units=1,fplist=['DB*M*'],do_erc=True,pins=[
            Pin(num='0',name='PAD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='36',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='37',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB9_FEMALE',dest=TEMPLATE,tool=SKIDL,keywords='connector female D-SUB',description='9-pin female D-SUB connector',ref_prefix='J',num_units=1,fplist=['DB*F*'],do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='9',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB9_FEMALE_MountingHoles',dest=TEMPLATE,tool=SKIDL,keywords='connector female D-SUB',description='9-pin female D-SUB connector, Mounting Hole',ref_prefix='J',num_units=1,fplist=['DB*F*'],do_erc=True,pins=[
            Pin(num='0',name='PAD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='9',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB9_MALE',dest=TEMPLATE,tool=SKIDL,keywords='connector male D-SUB',description='9-pin male D-SUB connector',ref_prefix='J',num_units=1,fplist=['DB*M*'],do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='9',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DB9_MALE_MountingHoles',dest=TEMPLATE,tool=SKIDL,keywords='connector male D-SUB',description='9-pin male D-SUB connector, Mounting Hole',ref_prefix='J',num_units=1,fplist=['DB*M*'],do_erc=True,pins=[
            Pin(num='0',name='PAD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='9',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='DIL10',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='DIL14',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='DIL16',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='DIL18',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='DIL20',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='DIL24',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='DIL32',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='DIL38',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='DIL40',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='DIL6',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='DIL8',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='DIL_26',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['DIL26']),
        Part(name='DIN_5',dest=TEMPLATE,tool=SKIDL,keywords='connector DIN 5-pins 41524',description='5 pins connector, 41524',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='GS2',dest=TEMPLATE,tool=SKIDL,keywords='jumper solder bridge',description='2-pin jumper/solder bridge',ref_prefix='J',num_units=1,fplist=['GS*'],do_erc=True,pins=[
            Pin(num='1',name='G1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='G2',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='GS3',dest=TEMPLATE,tool=SKIDL,keywords='jumper solder bridge',description='3-pin jumper/solder bridge',ref_prefix='J',num_units=1,fplist=['GS*'],do_erc=True,pins=[
            Pin(num='1',name='G1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='G2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='G3',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='HE10-10',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='HE10-16',dest=TEMPLATE,tool=SKIDL,keywords='connector',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='16',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='HE10-20',dest=TEMPLATE,tool=SKIDL,keywords='connector',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='HE10-26',dest=TEMPLATE,tool=SKIDL,keywords='connector',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='HE10-32',dest=TEMPLATE,tool=SKIDL,keywords='connector',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='HE10-34',dest=TEMPLATE,tool=SKIDL,keywords='connector',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='30',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='22',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='23',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='24',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='25',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='26',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='27',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='28',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='29',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='I3E1394',dest=TEMPLATE,tool=SKIDL,description='CONNECTOR 6BR',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PWR',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='TPB-',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TPB+',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='TPA-',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TPA+',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='SHID',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='SHID',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='JACK_2P',dest=TEMPLATE,tool=SKIDL,keywords='mono audio jack',description='2-pin Mono audio Jack, withc switch contact',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='JACK_TRS_6PINS',dest=TEMPLATE,tool=SKIDL,keywords='audio jack connector TRS',description='audio jack TRS 6 pins',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='S',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='T',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='R',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='SN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='TN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='RN',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='JEDEC24',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='JEDEC28',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='LEMO2',dest=TEMPLATE,tool=SKIDL,keywords='LEMO connector',description='2-pin LEMO connector',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LEMO4',dest=TEMPLATE,tool=SKIDL,keywords='LEMO connector',description='4-pin LEMO connector',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LEMO5',dest=TEMPLATE,tool=SKIDL,keywords='LEMO connector',description='5-pin LEMO connector',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LEMO6',dest=TEMPLATE,tool=SKIDL,keywords='LEMO connector',description='6-pin LEMO connector',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='Micro_SD_Card',dest=TEMPLATE,tool=SKIDL,keywords='connector SD microsd',description='Micro SD Card Socket',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='DAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='DAT3/CD',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CMD',do_erc=True),
            Pin(num='4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='CLK',do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='DAT0',do_erc=True),
            Pin(num='8',name='DAT1',do_erc=True),
            Pin(num='9',name='SHIELD',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='Micro_SD_Card_Det',dest=TEMPLATE,tool=SKIDL,keywords='connector SD microsd',description='Micro SD Card Socket with card detection pins',ref_prefix='J',num_units=1,fplist=['microSD*Card*Receptable*'],do_erc=True,aliases=['Micro_SD_Card_Det_Hirose_DM3AT'],pins=[
            Pin(num='1',name='DAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='DAT3/CD',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CMD',do_erc=True),
            Pin(num='4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='CLK',do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='DAT0',do_erc=True),
            Pin(num='8',name='DAT1',do_erc=True),
            Pin(num='9',name='DET_B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='DET_A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='SHIELD',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='PAL20',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PAL24',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PCI9030-PQFP176',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PCI_5V_32BIT',dest=TEMPLATE,tool=SKIDL,keywords='PCI',description='Connector BUS PCI',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='A1',name='TRST#',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B1',name='-12V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A2',name='+12V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B2',name='TCK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A3',name='TMS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B3',name='GND',do_erc=True),
            Pin(num='A4',name='TDI',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B4',name='TDO',do_erc=True),
            Pin(num='A5',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B5',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A6',name='INTA#',do_erc=True),
            Pin(num='B6',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A7',name='INTC#',do_erc=True),
            Pin(num='B7',name='INTB#',do_erc=True),
            Pin(num='A8',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B8',name='INTD#',do_erc=True),
            Pin(num='A9',name='RESERVED',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B9',name='PRSNT1#',do_erc=True),
            Pin(num='A10',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B10',name='RESERVED',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A20',name='AD[30]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B20',name='AD[31]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A30',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B30',name='AD[19]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A40',name='SDONE',func=Pin.BIDIR,do_erc=True),
            Pin(num='B40',name='PERR#',func=Pin.BIDIR,do_erc=True),
            Pin(num='A60',name='REQ64#',func=Pin.BIDIR,do_erc=True),
            Pin(num='B60',name='ACK64#',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='RESERVED',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B11',name='PRSNT2#',do_erc=True),
            Pin(num='A21',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B21',name='AD[29]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A31',name='AD[18]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B31',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A41',name='SBO#',func=Pin.BIDIR,do_erc=True),
            Pin(num='B41',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A61',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B61',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A22',name='AD[28]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A32',name='AD[16]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B32',name='AD[17]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A42',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B42',name='SERR#',do_erc=True),
            Pin(num='A52',name='C/BE#[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B52',name='AD[08]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A62',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B62',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A23',name='AD[26]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B23',name='AD[27]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A33',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B33',name='C/BE#[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A43',name='PAR',func=Pin.BIDIR,do_erc=True),
            Pin(num='B43',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A53',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B53',name='AD[07]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A14',name='RESERVED',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B14',name='RESERVED',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B24',name='AD[25]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A34',name='FRAME#',func=Pin.BIDIR,do_erc=True),
            Pin(num='B34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A44',name='AD[15]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B44',name='C/BE#[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A54',name='AD[06]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B54',name='+3.3V',do_erc=True),
            Pin(num='A15',name='RST#',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A25',name='AD[24]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B25',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A35',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B35',name='IRDY#',func=Pin.BIDIR,do_erc=True),
            Pin(num='A45',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B45',name='AD[14]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A55',name='AD[04]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B55',name='AD[05]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A16',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B16',name='CLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A26',name='IDSEL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B26',name='C/BE#[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A36',name='TRDY#',func=Pin.BIDIR,do_erc=True),
            Pin(num='B36',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A46',name='AD[13]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B46',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A56',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B56',name='AD[03]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A17',name='GNT#',func=Pin.BIDIR,do_erc=True),
            Pin(num='B17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A27',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B27',name='AD[23]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A37',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B37',name='DEVSEL#',func=Pin.BIDIR,do_erc=True),
            Pin(num='A47',name='AD[11]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B47',name='AD[12]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A57',name='AD[02]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B57',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B18',name='REQ#',func=Pin.BIDIR,do_erc=True),
            Pin(num='A28',name='AD[22]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A38',name='STOP#',func=Pin.BIDIR,do_erc=True),
            Pin(num='B38',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A48',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B48',name='AD[10]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A58',name='AD[00]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B58',name='AD[01]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A19',name='RESERVED',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B19',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A29',name='AD[20]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B29',name='AD[21]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A39',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B39',name='LOCK#',func=Pin.BIDIR,do_erc=True),
            Pin(num='A49',name='AD[09]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B49',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A59',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B59',name='+5V',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PCI_CONUNIV',dest=TEMPLATE,tool=SKIDL,keywords='PCI',description='Connector BUS PCI',ref_prefix='J',num_units=1,do_erc=True,aliases=['BUSPCI-5V'],pins=[
            Pin(num='A1',name='TRST#',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B1',name='-12V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A2',name='+12V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B2',name='TCK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A3',name='TMS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B3',name='GND',do_erc=True),
            Pin(num='A4',name='TDI',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B4',name='TDO',do_erc=True),
            Pin(num='A5',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B5',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A6',name='INTA#',do_erc=True),
            Pin(num='B6',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A7',name='INTC#',do_erc=True),
            Pin(num='B7',name='INTB#',do_erc=True),
            Pin(num='A8',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B8',name='INTD#',do_erc=True),
            Pin(num='A9',name='RESERVED',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B9',name='PRSNT1#',do_erc=True),
            Pin(num='A10',name='VIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='B10',name='RESERVED',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A20',name='AD[30]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B20',name='AD[31]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A30',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B30',name='AD[19]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A40',name='RESERVED',func=Pin.BIDIR,do_erc=True),
            Pin(num='B40',name='PERR#',func=Pin.BIDIR,do_erc=True),
            Pin(num='A60',name='REQ64#',func=Pin.BIDIR,do_erc=True),
            Pin(num='B60',name='ACK64#',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='RESERVED',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B11',name='PRSNT2#',do_erc=True),
            Pin(num='A21',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B21',name='AD[29]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A31',name='AD[18]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B31',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A41',name='RESERVED',func=Pin.BIDIR,do_erc=True),
            Pin(num='B41',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A61',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B61',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A22',name='AD[28]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A32',name='AD[16]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B32',name='AD[17]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A42',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B42',name='SERR#',do_erc=True),
            Pin(num='A52',name='C/BE#[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B52',name='AD[08]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A62',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B62',name='+5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A23',name='AD[26]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B23',name='AD[27]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A33',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B33',name='C/BE#[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A43',name='PAR',func=Pin.BIDIR,do_erc=True),
            Pin(num='B43',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A53',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B53',name='AD[07]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A14',name='3.3VAUX',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B14',name='RESERVED',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B24',name='AD[25]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A34',name='FRAME#',func=Pin.BIDIR,do_erc=True),
            Pin(num='B34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A44',name='AD[15]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B44',name='C/BE#[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A54',name='AD[06]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B54',name='+3.3V',do_erc=True),
            Pin(num='A15',name='RST#',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A25',name='AD[24]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B25',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A35',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B35',name='IRDY#',func=Pin.BIDIR,do_erc=True),
            Pin(num='A45',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B45',name='AD[14]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A55',name='AD[04]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B55',name='AD[05]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A16',name='VIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='B16',name='CLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A26',name='IDSEL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B26',name='C/BE#[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A36',name='TRDY#',func=Pin.BIDIR,do_erc=True),
            Pin(num='B36',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='A46',name='AD[13]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B46',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A56',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B56',name='AD[03]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A17',name='GNT#',func=Pin.BIDIR,do_erc=True),
            Pin(num='B17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A27',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B27',name='AD[23]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A37',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B37',name='DEVSEL#',func=Pin.BIDIR,do_erc=True),
            Pin(num='A47',name='AD[11]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B47',name='AD[12]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A57',name='AD[02]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B57',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B18',name='REQ#',func=Pin.BIDIR,do_erc=True),
            Pin(num='A28',name='AD[22]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A38',name='STOP#',func=Pin.BIDIR,do_erc=True),
            Pin(num='B38',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A48',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B48',name='AD[10]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A58',name='AD[00]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B58',name='AD[01]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A19',name='PME#',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B19',name='VIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='A29',name='AD[20]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B29',name='AD[21]',func=Pin.BIDIR,do_erc=True),
            Pin(num='A39',name='+3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='B39',name='LOCK#',func=Pin.BIDIR,do_erc=True),
            Pin(num='A49',name='AD[09]',func=Pin.BIDIR,do_erc=True),
            Pin(num='B49',name='M66EN',func=Pin.PWRIN,do_erc=True),
            Pin(num='A59',name='VIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='B59',name='VIO',func=Pin.PWRIN,do_erc=True)]),
        Part(name='RJ12',dest=TEMPLATE,tool=SKIDL,keywords='RJ12 connector',description='RJ12 connector with 2 shield pins',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='SHIELD_1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='SHIELD_2',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='RJ45',dest=TEMPLATE,tool=SKIDL,keywords='RJ45',description='RJ45 connector with shield',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='SHIELD',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='RJ45-TRANSFO',dest=TEMPLATE,tool=SKIDL,keywords='RJ45',description='RJ45 with transformer + leds WURTH',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='TD+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='TCT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='TD-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='RD+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='RCT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='RD-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='SHIELD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='GA',name='LEDG_A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='YA',name='LEDY_A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='GK',name='LEDG_K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='YK',name='LEDY_K',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='RJ45_LEDS',dest=TEMPLATE,tool=SKIDL,keywords='RJ45 RJ45_LEDS',description='RJ45, status leds',ref_prefix='J',num_units=1,fplist=['RJ45*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='Raspberry_Pi_2_3',dest=TEMPLATE,tool=SKIDL,keywords='raspberrypi gpio',description='expansion header for Raspberry Pi 2 & 3',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='3V3',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='5V',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='(SDA1)_GPIO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='5V',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='(SCL1)_GPIO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='(GCLK)_GPIO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='(TXD0)_GPIO14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='(RXD0)_GPIO15',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='GPIO21',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GPIO17_(GEN0)',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='(SPI_MISO)_GPIO9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='GPIO6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='GPIO18_(GEN1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GPIO25_(GEN6)',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='GPIO12',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='GPIO27_(GEN2)',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='(SPI_SCLK)_GPIO11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='GPIO13',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='(~SPI_CE0~)_GPIO8',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='GPIO22_(GEN3)',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='GPIO19',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GPIO23_(GEN4)',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='(~SPI_CE1~)_GPIO7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='GPIO16',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='3V3',func=Pin.PWROUT,do_erc=True),
            Pin(num='27',name='ID_SD',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='GPIO26',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GPIO24_(GEN5)',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='ID_SC',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='GPIO20',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='(SPI_MOSI)_GPIO10',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='GPIO5',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SCART-F',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='Prise Peritel',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='P11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='P21',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='P12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SD_Card',dest=TEMPLATE,tool=SKIDL,keywords='connector SD',description='SD Card Reader',ref_prefix='J',num_units=1,fplist=['SD_Card_Receptacle'],do_erc=True,pins=[
            Pin(num='1',name='CD/DAT3',do_erc=True),
            Pin(num='2',name='CMD',do_erc=True),
            Pin(num='3',name='VSS',do_erc=True),
            Pin(num='4',name='VDD',do_erc=True),
            Pin(num='5',name='CLK',do_erc=True),
            Pin(num='6',name='VSS',do_erc=True),
            Pin(num='7',name='DAT0',do_erc=True),
            Pin(num='8',name='DAT1',do_erc=True),
            Pin(num='9',name='DAT2',do_erc=True),
            Pin(num='10',name='CARD_DETECT',do_erc=True),
            Pin(num='11',name='WRITE_PROTECT',do_erc=True),
            Pin(num='12',name='SHELL1',do_erc=True),
            Pin(num='13',name='SHELL2',do_erc=True)]),
        Part(name='SIL10',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='SIL12',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='SIL14',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='SIL26',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='SIM_Card',dest=TEMPLATE,tool=SKIDL,keywords='SIM card UICC',description='SIM Card',ref_prefix='J',num_units=1,fplist=['*SIM*Card*Holder*'],do_erc=True,pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='RST',do_erc=True),
            Pin(num='3',name='CLK',do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VPP',do_erc=True),
            Pin(num='7',name='I/O',func=Pin.BIDIR,do_erc=True)]),
        Part(name='SUPP20',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='SUPP24',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='SUPP28',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='SUPP32',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='SUPP40',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='Screw_Terminal_1x01',dest=TEMPLATE,tool=SKIDL,keywords='screw terminal block',description='1-pin screw terminal connector',ref_prefix='J',num_units=1,fplist=['TerminalBlock*1pol'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='Screw_Terminal_1x02',dest=TEMPLATE,tool=SKIDL,keywords='screw terminal block',description='2-pin screw terminal connector',ref_prefix='J',num_units=1,fplist=['bornier2', 'TerminalBlock*2pol'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='Screw_Terminal_1x03',dest=TEMPLATE,tool=SKIDL,keywords='screw terminal block',description='3-pin screw terminal connector',ref_prefix='J',num_units=1,fplist=['bornier3', 'TerminalBlock*3pol'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='Screw_Terminal_1x04',dest=TEMPLATE,tool=SKIDL,keywords='screw terminal block',description='4-pin screw terminal connector',ref_prefix='J',num_units=1,fplist=['bornier4', 'TerminalBlock*4pol'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='Screw_Terminal_1x05',dest=TEMPLATE,tool=SKIDL,keywords='screw terminal block',description='5-pin screw terminal connector',ref_prefix='J',num_units=1,fplist=['bornier5', 'TerminalBlock*5pol'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='Screw_Terminal_1x06',dest=TEMPLATE,tool=SKIDL,keywords='screw terminal block',description='6-pin screw terminal connector',ref_prefix='J',num_units=1,fplist=['bornier6', 'TerminalBlock*6pol'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='Screw_Terminal_1x07',dest=TEMPLATE,tool=SKIDL,keywords='screw terminal block',description='7-pin screw terminal connector',ref_prefix='J',num_units=1,fplist=['TerminalBlock*7pol'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='Screw_Terminal_1x08',dest=TEMPLATE,tool=SKIDL,keywords='screw terminal block',description='8-pin screw terminal connector',ref_prefix='J',num_units=1,fplist=['TerminalBlock*8pol'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='Screw_Terminal_1x09',dest=TEMPLATE,tool=SKIDL,keywords='screw terminal block',description='9-pin screw terminal connector',ref_prefix='J',num_units=1,fplist=['TerminalBlock*9pol'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='Screw_Terminal_1x10',dest=TEMPLATE,tool=SKIDL,keywords='screw terminal block',description='10-pin screw terminal connector',ref_prefix='J',num_units=1,fplist=['TerminalBlock*10pol'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='Screw_Terminal_1x11',dest=TEMPLATE,tool=SKIDL,keywords='screw terminal block',description='11-pin screw terminal connector',ref_prefix='J',num_units=1,fplist=['TerminalBlock*11pol'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='Screw_Terminal_1x12',dest=TEMPLATE,tool=SKIDL,keywords='screw terminal block',description='12-pin screw terminal connector',ref_prefix='J',num_units=1,fplist=['TerminalBlock*12pol'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TEST_1P',dest=TEMPLATE,tool=SKIDL,keywords='point tp',description='point',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TEST_2P',dest=TEMPLATE,tool=SKIDL,keywords='point tp',description='point',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='2',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='USB3_A',dest=TEMPLATE,tool=SKIDL,keywords='usb universal serial bus',description='USB 3.0 A connector',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VBUS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='D+',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SSRX-',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SSRX+',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='DRAIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='SSTX-',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='SSTX+',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='SHIELD',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='USB3_B',dest=TEMPLATE,tool=SKIDL,keywords='usb universal serial bus',description='USB 3.0 B connector',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VBUS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='D+',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SSTX-',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SSTX+',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='DRAIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='SSRX-',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='SSRX+',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='SHIELD',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='USB_A',dest=TEMPLATE,tool=SKIDL,keywords='connector USB',description='USB Type A connector',ref_prefix='J',num_units=1,fplist=['USB*'],do_erc=True,pins=[
            Pin(num='1',name='VBUS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='D-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='D+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Shield',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='USB_B',dest=TEMPLATE,tool=SKIDL,keywords='connector USB',description='USB Type B connector',ref_prefix='J',num_units=1,fplist=['USB*'],do_erc=True,pins=[
            Pin(num='1',name='VBUS',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='D-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='D+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='5',name='Shield',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='USB_OTG',dest=TEMPLATE,tool=SKIDL,keywords='connector USB',description='USB mini/micro connector',ref_prefix='J',num_units=1,fplist=['USB*'],do_erc=True,pins=[
            Pin(num='1',name='VBUS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='D-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='D+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='ID',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='Shield',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='XLR3',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='3 pins',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='XLR4',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='4 pins',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='XLR5',dest=TEMPLATE,tool=SKIDL,keywords='connector',description='5 pins',ref_prefix='J',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='P2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P5',func=Pin.PASSIVE,do_erc=True)])])