from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

interface = SchLib(tool=SKIDL).add_parts(*[
        Part(name='75LBC176',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='AD5280',dest=TEMPLATE,tool=SKIDL,keywords='digital potentiometer',description='Digital potentiometer, 256 position, single output, I2C interface',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='W',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~SHDN~',do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='AD0',do_erc=True),
            Pin(num='9',name='AD1',do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='O2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='VLOG',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='O1',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='AD5282',dest=TEMPLATE,tool=SKIDL,keywords='digital potentiometer',description='Digital potentiometer, 256 position, dual output, I2C interface',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='O1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='A1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='W1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='B1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~SHDN~',do_erc=True),
            Pin(num='7',name='SCL',do_erc=True),
            Pin(num='8',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='AD0',do_erc=True),
            Pin(num='10',name='AD1',do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VLOG',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='B2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='W2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='A2',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='AD5282_ABC',dest=TEMPLATE,tool=SKIDL,description='TSSOP16',ref_prefix='U',num_units=3,do_erc=True,pins=[
            Pin(num='1',name='O1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~SHDN~',do_erc=True),
            Pin(num='7',name='SCL',do_erc=True),
            Pin(num='8',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='AD0',do_erc=True),
            Pin(num='10',name='AD1',do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VLOG',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='A1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='W1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='B1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='B2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='W2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='A2',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='AD5290',dest=TEMPLATE,tool=SKIDL,keywords='R POT',description='Digital Potentiometer 256 steps (SPI control) +- 15V',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='RH',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='RL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='Vss-',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~CS~',do_erc=True),
            Pin(num='6',name='CLK',do_erc=True),
            Pin(num='7',name='SDI',do_erc=True),
            Pin(num='8',name='SDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Vdd+',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='RW',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='AD5293',dest=TEMPLATE,tool=SKIDL,keywords='R POT',description='Digital potentiometer 1024 pos (SPI)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~RST~',do_erc=True),
            Pin(num='2',name='Vss-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='RH',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='RW',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='RL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='Vdd+',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='EXT_CAP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='Vlog',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='SDI',do_erc=True),
            Pin(num='11',name='CLK',do_erc=True),
            Pin(num='12',name='~CS~',do_erc=True),
            Pin(num='13',name='SDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='RDY',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='AD9834',dest=TEMPLATE,tool=SKIDL,keywords='Direct Digital Synthesizer DDS',description='10 bit 75 MHz Complete Direct Digital Synthesizer, 2.3 V to 5.5 V, 20 mW, TSSOP20',ref_prefix='U',num_units=1,fplist=['TSSOP-20_4.4x6.5mm_Pitch0.65mm', 'TSSOP-20'],do_erc=True,pins=[
            Pin(num='1',name='FS_ADJUST',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='REFOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='COMP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='CAP/2.5V',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='MCLK',do_erc=True),
            Pin(num='9',name='FSELECT',do_erc=True),
            Pin(num='10',name='PSELECT',do_erc=True),
            Pin(num='20',name='IOUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='RESET',do_erc=True),
            Pin(num='12',name='SLEEP',do_erc=True),
            Pin(num='13',name='SDATA',do_erc=True),
            Pin(num='14',name='SCLK',do_erc=True),
            Pin(num='15',name='~FSYNC',do_erc=True),
            Pin(num='16',name='SIGNBITOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='VIN',do_erc=True),
            Pin(num='18',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='IOUT',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='AD9951',dest=TEMPLATE,tool=SKIDL,keywords='Direct Digital Synthesizer DDS',description='14-Bit Direct Digital Synthesizer with 400MSPS DAC, 1.8V, TQFP48',ref_prefix='U',num_units=1,fplist=['TQFP48*'],do_erc=True,pins=[
            Pin(num='1',name='I/OUPDATE',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='~OSC/REFCLK',do_erc=True),
            Pin(num='9',name='OSC/REFCLK',do_erc=True),
            Pin(num='10',name='CRYSTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='~IOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='30',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='SCLK',do_erc=True),
            Pin(num='11',name='CLKMODESELECT',do_erc=True),
            Pin(num='21',name='IOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='31',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='SDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='LOOPFILTER',do_erc=True),
            Pin(num='22',name='AGND',func=Pin.OUTPUT,do_erc=True),
            Pin(num='32',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='42',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='DACBP',do_erc=True),
            Pin(num='33',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='43',name='DVDD_I/O',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='DAC_RSET',do_erc=True),
            Pin(num='34',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='SYNCIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='PWRDWNCTL',do_erc=True),
            Pin(num='45',name='SYNC_CLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='RESET',do_erc=True),
            Pin(num='46',name='OSK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='IOSYNC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='SDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='~CS',do_erc=True)]),
        Part(name='ADM101E',dest=TEMPLATE,tool=SKIDL,keywords='rs232 uart transceiver line-driver',description='Single RS232 driver/receiver, 5V supply, 460kb/s',ref_prefix='U',num_units=1,fplist=['MSOP*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='C1-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='VS-',func=Pin.PWROUT,do_erc=True),
            Pin(num='4',name='T1IN',do_erc=True),
            Pin(num='5',name='R1OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='R1IN',do_erc=True),
            Pin(num='7',name='T1OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='SD',do_erc=True),
            Pin(num='9',name='C1+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ADM242',dest=TEMPLATE,tool=SKIDL,keywords='rs232 uart transceiver',description='Dual RS232 driver/receiver, 5V supply, 200kb/s, separate shutdown/enable pins',ref_prefix='U',num_units=1,fplist=['SO*', 'DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='~EN',do_erc=True),
            Pin(num='2',name='C1+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='V+',func=Pin.PWROUT,do_erc=True),
            Pin(num='4',name='C1-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='C2+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='C2-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='V-',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='T2OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='R2IN',do_erc=True),
            Pin(num='10',name='R2OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='T2IN',do_erc=True),
            Pin(num='12',name='T1IN',do_erc=True),
            Pin(num='13',name='R1OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='R1IN',do_erc=True),
            Pin(num='15',name='T1OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='~SHDN',do_erc=True)]),
        Part(name='ADM3053',dest=TEMPLATE,tool=SKIDL,keywords='can transceiver isolated protected',description='Isolated CAN Transceiver, integrated isolated DC-DC converter, 1Mbps',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='TXD',do_erc=True),
            Pin(num='6',name='Vio',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='Vcc',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='Visoout',func=Pin.PWROUT,do_erc=True),
            Pin(num='13',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='Vref',do_erc=True),
            Pin(num='15',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RS',do_erc=True),
            Pin(num='19',name='Visoin',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ADUM4160',dest=TEMPLATE,tool=SKIDL,keywords='usb isolation',description='Full/Low Speed, iCoupler USB Digital Isolator, 5kV protection',ref_prefix='U',num_units=1,fplist=['SOIC-*7.5x10.3mm_Pitch1.27mm*'],do_erc=True,aliases=['ADUM3160'],pins=[
            Pin(num='1',name='VBUS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VDD1',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='PDEN',do_erc=True),
            Pin(num='5',name='SPU',do_erc=True),
            Pin(num='6',name='UD-',func=Pin.TRISTATE,do_erc=True),
            Pin(num='7',name='UD+',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='DD+',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='DD-',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='PIN',do_erc=True),
            Pin(num='13',name='SPD',do_erc=True),
            Pin(num='14',name='VDD2',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VBUS2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ADuM1200AR',dest=TEMPLATE,tool=SKIDL,keywords='2Ch Dual Digital Isolator 25Mbps',description='Dual-Channel Digital Isolator, 25Mbps 45ns, Highest Tem. Grade, SO8',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['ADuM1200BR', 'ADuM1200CR', 'ADuM1200WS', 'ADuM1200WT', 'ADuM1200WU'],pins=[
            Pin(num='1',name='VDD1',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VIA',do_erc=True),
            Pin(num='3',name='VIB',do_erc=True),
            Pin(num='4',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VOB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='VOA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VDD2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ADuM1201AR',dest=TEMPLATE,tool=SKIDL,keywords='2Ch Dual Digital Isolator 25Mbps',description='Dual-Channel Digital Isolator, 25Mbps 45ns, Highest Temp. Grade, SO8',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['ADuM1201BR', 'ADuM1201CR', 'ADuM1201WS', 'ADuM1201WT', 'ADuM1201WU'],pins=[
            Pin(num='1',name='VDD1',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VOA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VIB',do_erc=True),
            Pin(num='4',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VOB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='VIA',do_erc=True),
            Pin(num='8',name='VDD2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='CH376T',dest=TEMPLATE,tool=SKIDL,keywords='File Management USB Flash Card SD Interface',description='File Management USB Flash Card SD Interface, TSSOP20',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~INT~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='RST',do_erc=True),
            Pin(num='3',name='~SPI~',do_erc=True),
            Pin(num='4',name='TXD',do_erc=True),
            Pin(num='5',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='SD_DI',do_erc=True),
            Pin(num='7',name='V3',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='UD+',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='UD-',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='XI',do_erc=True),
            Pin(num='12',name='XO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='SCS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='SCK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='SDI',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='SDO',do_erc=True),
            Pin(num='17',name='SD_CS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='SD_DO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='SD_CK',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='DP83848C',dest=TEMPLATE,tool=SKIDL,keywords='Ethernet PHY MII RMII 10/100Mpbs',description='MII/RMII Single 10/100Mbps Ethernet Physical Layer Transciever, LQFP48',ref_prefix='U',num_units=1,fplist=['*QFP*'],do_erc=True,pins=[
            Pin(num='1',name='TX_CLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='TX_EN',do_erc=True),
            Pin(num='3',name='TXD_0',do_erc=True),
            Pin(num='4',name='TXD_1',do_erc=True),
            Pin(num='5',name='TXD_2',do_erc=True),
            Pin(num='6',name='TXD_3/SNI_MODE',do_erc=True),
            Pin(num='7',name='PWR_DOWN/INT',do_erc=True),
            Pin(num='20',name='RESERVED',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='MDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='CRS/CRS_DV/LED_CFG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='RESERVED',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='MDC',do_erc=True),
            Pin(num='41',name='RX_ER/MDIX_EN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='AVDD33',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='IOVDD33',func=Pin.PWRIN,do_erc=True),
            Pin(num='42',name='COL/PHY_AD0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='RD-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='PFBOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='X2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='43',name='RXD_0/PHY_AD1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='RD+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='RBIAS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='X1',do_erc=True),
            Pin(num='44',name='RXD_1/PHY_AD2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='25M_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='35',name='IOGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='RXD_2/PHY_AD3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='TD-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='AN_EN/LED_ACT/COL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='36',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='RXD_3/PHY_AD4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='TD+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='AN1/LED_SPEED',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='PFBIN2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='IOGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='PFBIN1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='AN0/LED_LINK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='RX_CLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='IOVDD33',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='~RESET~',do_erc=True),
            Pin(num='39',name='RX_DV/MII_MODE',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='DP83848I',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='DS7820',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='DS7830',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['DS8830']),
        Part(name='DS90C124',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='DS90C241',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='EL2001',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='EL7242C',dest=TEMPLATE,tool=SKIDL,description='Translateur TTL->VMOS. Double driver VMOS',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='IN1',do_erc=True),
            Pin(num='2',name='IN',do_erc=True),
            Pin(num='7',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='IN1',do_erc=True),
            Pin(num='4',name='IN',do_erc=True),
            Pin(num='6',name='OUT',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='FD1771',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='FD2791',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['FD2795']),
        Part(name='GD65232DB',dest=TEMPLATE,tool=SKIDL,keywords='RS232 UART Driver Receiver Interface',description='Multiple RS-232 Driver and Receiver, SSOP-20',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,aliases=['GD75232DB'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='RA1',do_erc=True),
            Pin(num='3',name='RA2',do_erc=True),
            Pin(num='4',name='RA3',do_erc=True),
            Pin(num='5',name='DY1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='DY2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='RA4',do_erc=True),
            Pin(num='8',name='DY3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='RA5',do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='RY5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='DA3',do_erc=True),
            Pin(num='14',name='RY4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='DA2',do_erc=True),
            Pin(num='16',name='DA1',do_erc=True),
            Pin(num='17',name='RY3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='RY2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='RY1',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='GD65232DW',dest=TEMPLATE,tool=SKIDL,keywords='RS232 UART Driver Receiver Interface',description='Multiple RS-232 Driver and Receiver, SOIC20',ref_prefix='U',num_units=1,fplist=['SOIC*', 'SO-*', 'SO*'],do_erc=True,aliases=['GD75232DW'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='RA1',do_erc=True),
            Pin(num='3',name='RA2',do_erc=True),
            Pin(num='4',name='RA3',do_erc=True),
            Pin(num='5',name='DY1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='DY2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='RA4',do_erc=True),
            Pin(num='8',name='DY3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='RA5',do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='RY5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='DA3',do_erc=True),
            Pin(num='14',name='RY4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='DA2',do_erc=True),
            Pin(num='16',name='DA1',do_erc=True),
            Pin(num='17',name='RY3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='RY2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='RY1',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='GD65232PW',dest=TEMPLATE,tool=SKIDL,keywords='RS232 UART Driver Receiver Interface',description='Multiple RS-232 Driver and Receiver, TSSOP-20',ref_prefix='U',num_units=1,fplist=['TSSOP*'],do_erc=True,aliases=['GD75232PW'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='RA1',do_erc=True),
            Pin(num='3',name='RA2',do_erc=True),
            Pin(num='4',name='RA3',do_erc=True),
            Pin(num='5',name='DY1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='DY2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='RA4',do_erc=True),
            Pin(num='8',name='DY3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='RA5',do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='RY5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='DA3',do_erc=True),
            Pin(num='14',name='RY4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='DA2',do_erc=True),
            Pin(num='16',name='DA1',do_erc=True),
            Pin(num='17',name='RY3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='RY2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='RY1',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='GD75232N',dest=TEMPLATE,tool=SKIDL,keywords='RS232 UART Driver Receiver Interface',description='Multiple RS-232 Driver and Receiver, PDIP-20',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='RA1',do_erc=True),
            Pin(num='3',name='RA2',do_erc=True),
            Pin(num='4',name='RA3',do_erc=True),
            Pin(num='5',name='DY1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='DY2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='RA4',do_erc=True),
            Pin(num='8',name='DY3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='RA5',do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='RY5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='DA3',do_erc=True),
            Pin(num='14',name='RY4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='DA2',do_erc=True),
            Pin(num='16',name='DA1',do_erc=True),
            Pin(num='17',name='RY3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='RY2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='RY1',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='ICL7667',dest=TEMPLATE,tool=SKIDL,keywords='MOSFET driver array',description='Dual Power MOSFET Driver',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='I1',do_erc=True),
            Pin(num='3',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='I3',do_erc=True),
            Pin(num='5',name='O3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='O1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='ICM7209',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='ISL83491',dest=TEMPLATE,tool=SKIDL,keywords='RS485 RS422 transceiver full duplex',description='10Mbps RS485/RS422 transceiver, full duplex, receiver/driver enable, low power shutdown',ref_prefix='U',num_units=1,fplist=['SOIC*', 'DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='2',name='RO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~RE',do_erc=True),
            Pin(num='4',name='DE',do_erc=True),
            Pin(num='5',name='DI',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='Y',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~Z~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~B',do_erc=True),
            Pin(num='12',name='A',do_erc=True),
            Pin(num='13',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LT1080',dest=TEMPLATE,tool=SKIDL,keywords='rs232 uart transceiver',description='Dual RS232 driver/receiver, 5V supply, 120kb/s',ref_prefix='U',num_units=1,fplist=['SO*', 'DIP*W7.62mm*'],do_erc=True,aliases=['ADM222'],pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='C1+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='V+',func=Pin.PWROUT,do_erc=True),
            Pin(num='4',name='C1-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='C2+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='C2-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='V-',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='T2OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='R2IN',do_erc=True),
            Pin(num='10',name='R2OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='T2IN',do_erc=True),
            Pin(num='12',name='T1IN',do_erc=True),
            Pin(num='13',name='R1OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='R1IN',do_erc=True),
            Pin(num='15',name='T1OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='ON/~OFF',do_erc=True)]),
        Part(name='LTC2861',dest=TEMPLATE,tool=SKIDL,keywords='RS485',description='20Mbps RS485 transceiver with tntegrated switchable termination',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='RO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='RE',do_erc=True),
            Pin(num='3',name='DE',do_erc=True),
            Pin(num='4',name='DI',do_erc=True),
            Pin(num='5',name='TE',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='SLO',do_erc=True),
            Pin(num='12',name='Y',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~Z~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='~B~',do_erc=True),
            Pin(num='15',name='A',do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC2875-DD',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver',description='High-Speed CAN Transceiver, 4Mbps, 3.3V or 5V supply, DFN8 package',ref_prefix='U',num_units=1,fplist=['DFN*1EP*3x3mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='SPLIT',do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RS',do_erc=True),
            Pin(num='9',name='PAD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC2875-S8',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver',description='High-Speed CAN Transceiver, 4Mbps, 3.3V or 5V supply, SOIC8 package',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='SPLIT',do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RS',do_erc=True)]),
        Part(name='LTC2983',dest=TEMPLATE,tool=SKIDL,keywords='Flexible Temperature Measurement RTD NTC Cold Junction Termocouple',description='Multi-Sensor Temperature Measurement System, High Accuracy, LQFP-48 (7x7mm)',ref_prefix='U',num_units=1,fplist=['LQFP*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='CH5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='CH15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='SDI',do_erc=True),
            Pin(num='11',name='Vrefbyp',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='CH6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='CH16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='~CS~',do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='CH7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='CH17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='~RESET~',do_erc=True),
            Pin(num='13',name='Vrefout',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='CH8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='CH18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='LDO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='Vrefp',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='CH9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='CH19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='CH10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='CH20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='CH1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='CH11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='COM',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='Q3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='CH2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='CH12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='INTERRUPT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='Q2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='CH3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='CH13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='SCK',do_erc=True),
            Pin(num='48',name='Q1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='CH4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='CH14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='SDO',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LTC2990',dest=TEMPLATE,tool=SKIDL,keywords='Temperature Voltage Current Monitor I2C AFE',description='Temperature Voltage and Current Monitor, I2C Interface, MSOP-10',ref_prefix='U',num_units=1,fplist=['MSOP*'],do_erc=True,pins=[
            Pin(num='1',name='V1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='V2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='V3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='V4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='SCL',do_erc=True),
            Pin(num='8',name='ADR0',do_erc=True),
            Pin(num='9',name='ADR1',do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='M3003',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MAX13432EESD',dest=TEMPLATE,tool=SKIDL,keywords='rs485 transceiver',description='RS485 transceiver, full duplex, dual supply, receiver/driver enable, 16Mbps, SOIC-14 package',ref_prefix='U',num_units=1,fplist=['SOIC-*'],do_erc=True,aliases=['MAX13433EESD'],pins=[
            Pin(num='1',name='Vlogic',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='RO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='DE',do_erc=True),
            Pin(num='4',name='~RE',do_erc=True),
            Pin(num='5',name='DI',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='Y',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~Z~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~B',do_erc=True),
            Pin(num='12',name='A',do_erc=True),
            Pin(num='13',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MAX13432EETD',dest=TEMPLATE,tool=SKIDL,keywords='rs485 transceiver',description='RS485 transceiver, full duplex, dual supply, receiver/driver enable, 16Mbps, DFN-14 package',ref_prefix='U',num_units=1,fplist=['DFN-*_3x4mm_Pitch0.5mm*'],do_erc=True,aliases=['MAX13433EETD'],pins=[
            Pin(num='1',name='Vlogic',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='RO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='DE',do_erc=True),
            Pin(num='4',name='~RE',do_erc=True),
            Pin(num='5',name='DI',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='Y',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~Z~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~B',do_erc=True),
            Pin(num='12',name='A',do_erc=True),
            Pin(num='13',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='EP',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MAX13450E',dest=TEMPLATE,tool=SKIDL,keywords='RS485',description='20Mbps RS485 transceiver with integrated switchable termination',ref_prefix='U',num_units=1,fplist=['TSSOP14*'],do_erc=True,pins=[
            Pin(num='1',name='DE',do_erc=True),
            Pin(num='2',name='~RE',do_erc=True),
            Pin(num='3',name='DI',do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~TERM',do_erc=True),
            Pin(num='6',name='VL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='RO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='A',do_erc=True),
            Pin(num='9',name='~B',do_erc=True),
            Pin(num='10',name='Y',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='~Z',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='TERM100',do_erc=True),
            Pin(num='14',name='SRL',do_erc=True)]),
        Part(name='MAX232',dest=TEMPLATE,tool=SKIDL,keywords='rs232 uart transceiver line-driver',description='3.0V to 5.5V, Low-Power, up to 1Mbps, True RS-232 Transceivers Using Four 0.1μF External Capacitors',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*', 'DIP*W7.62mm*', 'TSSOP*4.4x5mm*Pitch0.65mm*'],do_erc=True,aliases=['MAX232I', 'MAX202', 'ADM232A', 'MAX3232', 'ICL3232'],pins=[
            Pin(num='1',name='C1+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='VS+',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='C1-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='C2+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='C2-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='VS-',func=Pin.PWROUT,do_erc=True),
            Pin(num='7',name='T2OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='R2IN',do_erc=True),
            Pin(num='9',name='R2OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='T2IN',do_erc=True),
            Pin(num='11',name='T1IN',do_erc=True),
            Pin(num='12',name='R1OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='R1IN',do_erc=True),
            Pin(num='14',name='T1OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MAX3051',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver',description='High-Speed CAN Transceiver, 1Mbps, 3.3V supply',ref_prefix='U',num_units=1,fplist=['SOT-23*', 'SOIC*'],do_erc=True,pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='SHDN',do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RS',do_erc=True)]),
        Part(name='MAX31855KASA',dest=TEMPLATE,tool=SKIDL,keywords='Cold Junction Termocouple Interface SPI',description='Cold Junction T-type Termocouple Interface, SPI, SO8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['MAX31855JASA', 'MAX31855NASA', 'MAX31855SASA', 'MAX31855TASA', 'MAX31855EASA', 'MAX31855RASA'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='T+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SCK',do_erc=True),
            Pin(num='6',name='~CS~',do_erc=True),
            Pin(num='7',name='SO',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='MAX3221',dest=TEMPLATE,tool=SKIDL,keywords='serial UART RS232',description='RS232 transceiver with 15kV ESD protection',ref_prefix='U',num_units=1,fplist=['SSOP*', 'TSSOP*'],do_erc=True,pins=[
            Pin(num='1',name='~EN',do_erc=True),
            Pin(num='2',name='C1+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='V+',func=Pin.PWROUT,do_erc=True),
            Pin(num='4',name='C1-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='C2+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='C2-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='V-',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='RIN',do_erc=True),
            Pin(num='9',name='ROUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~INVALID',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='DIN',do_erc=True),
            Pin(num='12',name='FORCEON',do_erc=True),
            Pin(num='13',name='DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='~FORCEOFF',do_erc=True)]),
        Part(name='MAX3226',dest=TEMPLATE,tool=SKIDL,keywords='rs232 uart transceiver',description='Single RS232 driver/receiver, 3.0V to 5V supply, 1Mb/s, AutoShutdown Plus, SSOP-16 package',ref_prefix='U',num_units=1,fplist=['SSOP-*'],do_erc=True,aliases=['MAX3227'],pins=[
            Pin(num='1',name='READY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='C1+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='V+',func=Pin.PWROUT,do_erc=True),
            Pin(num='4',name='C1-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='C2+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='C2-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='V-',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='R1IN',do_erc=True),
            Pin(num='9',name='R1OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~INVALID',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='T1IN',do_erc=True),
            Pin(num='12',name='FORCEON',do_erc=True),
            Pin(num='13',name='T1OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='~FORCEOFF',do_erc=True)]),
        Part(name='MC1413',dest=TEMPLATE,tool=SKIDL,keywords='darlington transistor array',description='High Voltage, High Current Darlington Transistor Arrays',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC*', 'SSOP*4.4x5.2mm*Pitch0.65mm', 'TSSOP*4.4x5mm*Pitch0.65mm'],do_erc=True,aliases=['ULN2003', 'ULN2003A', 'ULN2002', 'ULN2002A', 'ULN2004', 'ULN2004A', 'SN75468', 'SN75469', 'MC1413P'],pins=[
            Pin(num='1',name='I1',do_erc=True),
            Pin(num='2',name='I2',do_erc=True),
            Pin(num='3',name='I3',do_erc=True),
            Pin(num='4',name='I4',do_erc=True),
            Pin(num='5',name='I5',do_erc=True),
            Pin(num='6',name='I6',do_erc=True),
            Pin(num='7',name='I7',do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='COM',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='O7',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='O6',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='O5',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='13',name='O4',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='14',name='O3',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='15',name='O2',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='16',name='O1',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='MC1417',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MC3486',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MC3487',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MCP2551-I/P',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver',description='High-Speed CAN Transceiver, 1Mbps, 5V supply, PDIP8 package',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Vref',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='Rs',do_erc=True)]),
        Part(name='MCP2551-I/SN',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver',description='High-Speed CAN Transceiver, 1Mbps, 5V supply, SOIC8 package',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Vref',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='Rs',do_erc=True)]),
        Part(name='MCP2561-E/MF',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver',description='High-Speed CAN Transceiver, 1Mbps, 5V supply, SPLIT pin, -40C to +150C, DFN8 package',ref_prefix='U',num_units=1,fplist=['DFN*1EP*3x3mm*Pitch0.65mm*'],do_erc=True,aliases=['MCP2561-H/MF'],pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='SPLIT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='STBY',do_erc=True),
            Pin(num='9',name='PAD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP2561-E/P',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver',description='High-Speed CAN Transceiver, 1Mbps, 5V supply, SPLIT pin, -40C to +150C, DIP8 package',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,aliases=['MCP2561-H/P'],pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='SPLIT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='STBY',do_erc=True)]),
        Part(name='MCP2561-E/SN',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver',description='High-Speed CAN Transceiver, 1Mbps, 5V supply, SPLIT pin, -40C to +150C, SOIC8 package',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*'],do_erc=True,aliases=['MCP2561-H/SN'],pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='SPLIT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='STBY',do_erc=True)]),
        Part(name='MCP2562-E/MF',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver',description='High-Speed CAN Transceiver, 1Mbps, 5V supply, Vio pin, -40C to +150C, DFN8 package',ref_prefix='U',num_units=1,fplist=['DFN*1EP*3x3mm*Pitch0.65mm*'],do_erc=True,aliases=['MCP2562-H/MF'],pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Vio',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='SHDN',do_erc=True),
            Pin(num='9',name='PAD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP2562-E/P',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver',description='High-Speed CAN Transceiver, 1Mbps, 5V supply, Vio pin, -40C to +150C, DIP8 package',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,aliases=['MCP2562-H/P'],pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Vio',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='STBY',do_erc=True)]),
        Part(name='MCP2562-E/SN',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver',description='High-Speed CAN Transceiver, 1Mbps, 5V supply, Vio pin, -40C to +150C, SOIC8 package',ref_prefix='U',num_units=1,fplist=['SOIC*Pitch1.27mm*'],do_erc=True,aliases=['MCP2562-H/SN'],pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Vio',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='STBY',do_erc=True)]),
        Part(name='MCP41010',dest=TEMPLATE,tool=SKIDL,keywords='R POT',description='Single Digital Potentiometer, SPI interface, 256 taps, 100 kohm',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC*Pitch1.27mm*'],do_erc=True,aliases=['MCP41050', 'MCP41100'],pins=[
            Pin(num='1',name='~CS',do_erc=True),
            Pin(num='2',name='SCK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='SI',do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PA0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='PW0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='PB0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP42010',dest=TEMPLATE,tool=SKIDL,keywords='R POT',description='Dual Digital Potentiometer, SPI interface, 256 taps, 100 kohm',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC*3.9x8.7mm*Pitch1.27mm*', 'TSSOP*4.4x5mm*Pitch0.65mm*'],do_erc=True,aliases=['MCP42050', 'MCP42100'],pins=[
            Pin(num='1',name='~CS',do_erc=True),
            Pin(num='2',name='SCK',do_erc=True),
            Pin(num='3',name='SI',do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PB1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='PW1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='PA1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='PA0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='PW0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='PB0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='~RS',do_erc=True),
            Pin(num='12',name='~SHDN',do_erc=True),
            Pin(num='13',name='SO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MT43C4257',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MT43C4258',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='S5933_PQ160',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='SI9986',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='SP3481CN',dest=TEMPLATE,tool=SKIDL,keywords='Low Power Half-Duplex RS-485 Transceiver 10Mbps',description='Industrial 3.3V Low Power Half-Duplex RS-485 Transceiver 10Mbps, SO8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['MAX3072E', 'MAX3075E', 'MAX3078E', 'SP3481EN', 'SP3485CN', 'SP3485EN'],pins=[
            Pin(num='1',name='RO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~RE~',do_erc=True),
            Pin(num='3',name='DE',do_erc=True),
            Pin(num='4',name='DI',do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='A',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='B',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='SP3481CP',dest=TEMPLATE,tool=SKIDL,keywords='Low Power Half-Duplex RS-485 Transceiver 10Mbps',description='Industrial 3.3V Low Power Half-Duplex RS-485 Transceiver 10Mbps, DIP8',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,aliases=['SP3481EP', 'SP3485CP', 'SP3485EP'],pins=[
            Pin(num='1',name='RO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~RE~',do_erc=True),
            Pin(num='3',name='DE',do_erc=True),
            Pin(num='4',name='DI',do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='A',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='B',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TCA9534',dest=TEMPLATE,tool=SKIDL,keywords='SMBUS I2C Expander',description='8 Bit Port/Expander, I2C SMBUS, Interrupt output, TSSOP-16, SOIC-20',ref_prefix='U',num_units=1,fplist=['TSSOP*4.4x5mm*Pitch0.65mm*', 'SOIC*7.5x12.8mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='P0',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='P4',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P5',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='~INT~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='14',name='SCL',do_erc=True),
            Pin(num='15',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TCA9544A',dest=TEMPLATE,tool=SKIDL,keywords='I2C Hub',description='I2C Hub, 4 Channels, Interrupts, TSSOP-20',ref_prefix='U',num_units=1,fplist=['TSSOP*4.4x6.5mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='~INT0',do_erc=True),
            Pin(num='5',name='SD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='~INT1',do_erc=True),
            Pin(num='8',name='SD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='SC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='~INT2',do_erc=True),
            Pin(num='12',name='SD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='~INT3',do_erc=True),
            Pin(num='15',name='SD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='~INT',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='18',name='SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='SDA',func=Pin.BIDIR,do_erc=True)]),
        Part(name='TCA9548A_QFN',dest=TEMPLATE,tool=SKIDL,keywords='I2C Hub',description='I2C Hub, 8 Channels, QFN-24',ref_prefix='U',num_units=1,fplist=['QFN-*1EP*4x4mm*0.5mm'],do_erc=True,pins=[
            Pin(num='1',name='SD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='SC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='SD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='SC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='SD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='SD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='SC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='SD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='SC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='SD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='A0',do_erc=True),
            Pin(num='13',name='SC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='A1',do_erc=True),
            Pin(num='14',name='SD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='~RESET',do_erc=True),
            Pin(num='15',name='SC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='SC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='A2',do_erc=True),
            Pin(num='19',name='SCL',func=Pin.BIDIR,do_erc=True)]),
        Part(name='TCA9548A_TSSOP',dest=TEMPLATE,tool=SKIDL,keywords='I2C Hub',description='I2C Hub, 8 Channels, TSSOP-24',ref_prefix='U',num_units=1,fplist=['TSSOP-*4.4x7.8mm*0.65mm'],do_erc=True,pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='~RESET',do_erc=True),
            Pin(num='4',name='SD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='SC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='SC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='SD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='SC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='SD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='SC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='SC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='A2',do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='SC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='SD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='SD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='SC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='SD7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='TEA2014',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='TJA1021T',dest=TEMPLATE,tool=SKIDL,keywords='LIN 2.1 SAE J2602 Transceiver',description='TJA1021T, LIN 2.1/SAE J2602 transceiver, SOIC-8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='~SLP~',do_erc=True),
            Pin(num='3',name='~WAKE~',do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='LIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='INH',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='TJA1021TK',dest=TEMPLATE,tool=SKIDL,keywords='LIN 2.1 SAE J2602 Transceiver HVSON-8',description='TJA1021TK, LIN 2.1/SAE J2602 transceiver, DFN-8-1EP',ref_prefix='U',num_units=1,fplist=['DFN*1EP*3x3mm*Pitch0.65mm*', 'HVSON*'],do_erc=True,pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='~SLP~',do_erc=True),
            Pin(num='3',name='~WAKE~',do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='LIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='INH',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TJA1029T',dest=TEMPLATE,tool=SKIDL,keywords='LIN 2.2A/SAE J2602 Transceiver',description='TJA1029T, LIN 2.2A/SAE J2602 transceiver with TXD dominant timeout, SOIC-8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='~SLP~',do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='LIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='TJA1029TK',dest=TEMPLATE,tool=SKIDL,keywords='LIN 2.2A/SAE J2602 Transceiver HVSON-8',description='TJA1029TK, LIN 2.2A/SAE J2602 transceiver with TXD dominant timeout, DFN-8-1EP',ref_prefix='U',num_units=1,fplist=['DFN*1EP*3x3mm*Pitch0.65mm*', 'HVSON*'],do_erc=True,pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='~SLP~',do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='LIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TJA1049T',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver',description='TJA1049T, High-Speed CAN Transceiver, standby mode, split pin, SOIC-8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['TJA1042T'],pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='SPLIT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='STB',do_erc=True)]),
        Part(name='TJA1049T/3',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver',description='TJA1049T/3, High-Speed CAN Transceiver, separate VIO, standby mode, SOIC-8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['TJA1042T/3'],pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='STB',do_erc=True)]),
        Part(name='TJA1049TK',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver HVSON-8',description='TJA1049TK, High-Speed CAN Transceiver, standby mode, DFN-8-1EP',ref_prefix='U',num_units=1,fplist=['DFN*1EP*3x3mm*Pitch0.65mm*', 'HVSON*'],do_erc=True,pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='SPLIT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='STB',do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TJA1049TK/3',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver HVSON-8',description='TJA1049TK/3, High-Speed CAN Transceiver, separate VIO, standby mode, DFN-8-1EP',ref_prefix='U',num_units=1,fplist=['DFN*1EP*3x3mm*Pitch0.65mm*', 'HVSON*'],do_erc=True,aliases=['TJA1042TK/3'],pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='STB',do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TJA1051T',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver',description='TJA1051T, High-Speed CAN Transceiver, silent mode, SOIC-8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='n.c.',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='S',do_erc=True)]),
        Part(name='TJA1051T/3',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver',description='TJA1051T/3, High-Speed CAN Transceiver, separate VIO, silent mode, SOIC-8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='S',do_erc=True)]),
        Part(name='TJA1051T/E',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver',description='TJA1051T/E, High-Speed CAN Transceiver, enable pin, silent mode, SOIC-8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='EN',do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='S',do_erc=True)]),
        Part(name='TJA1051TK/3',dest=TEMPLATE,tool=SKIDL,keywords='High-Speed CAN Transceiver HVSON-8',description='TJA1051TK/3, High-Speed CAN Transceiver, separate VIO, silent mode, DFN-8-1EP',ref_prefix='U',num_units=1,fplist=['DFN*1EP*3x3mm*Pitch0.65mm*', 'HVSON*'],do_erc=True,pins=[
            Pin(num='1',name='TXD',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='CANL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CANH',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='S',do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='U2270B',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='UA9637',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='UA9638',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='ULN2803A',dest=TEMPLATE,tool=SKIDL,keywords='darlington transistor array',description='Darlington Transistor Arrays',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC-18*'],do_erc=True,aliases=['ULN2802A', 'ULN2801A', 'ULN2804A', 'ULN2805A'],pins=[
            Pin(num='1',name='I1',do_erc=True),
            Pin(num='2',name='I2',do_erc=True),
            Pin(num='3',name='I3',do_erc=True),
            Pin(num='4',name='I4',do_erc=True),
            Pin(num='5',name='I5',do_erc=True),
            Pin(num='6',name='I6',do_erc=True),
            Pin(num='7',name='I7',do_erc=True),
            Pin(num='8',name='I8',do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='COM',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='O8',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='O7',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='13',name='O6',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='14',name='O5',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='15',name='O4',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='16',name='O3',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='17',name='O2',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='18',name='O1',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='XTR115U',dest=TEMPLATE,tool=SKIDL,keywords='4-20mA Current Loop Transmitter',description='4-20mA Current Loop Transmitter, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['XTR116U'],pins=[
            Pin(num='1',name='Vref',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='Iin',do_erc=True),
            Pin(num='3',name='Iret',do_erc=True),
            Pin(num='4',name='Io',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='E',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='B',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='V+',do_erc=True),
            Pin(num='8',name='Vreg',func=Pin.OUTPUT,do_erc=True)])])