from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

silabs = SchLib(tool=SKIDL).add_parts(*[
        Part(name='CP2102N-A01-GQFN24',dest=TEMPLATE,tool=SKIDL,keywords='USB UART bridge',description='USB to UART master bridge',ref_prefix='U',num_units=1,fplist=['QFN*4x4mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='RI/CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='D+',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='REGIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VBUS',do_erc=True),
            Pin(num='9',name='~RSTb',do_erc=True),
            Pin(num='10',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='20',name='RXD',do_erc=True),
            Pin(num='11',name='GPIO.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='GPIO.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='DSR',do_erc=True),
            Pin(num='13',name='GPIO.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='DTR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='GPIO.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='DCD',do_erc=True),
            Pin(num='15',name='~SUSPENDb',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='17',name='SUSPEND',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='CTS',do_erc=True),
            Pin(num='19',name='RTS',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='CP2104',dest=TEMPLATE,tool=SKIDL,keywords='uart usb bridge interface transceiver',description='Single-Chip USB-to-UART Bridge, USB 2.0 Full-Speed, 2Mbps UART, QFN package',ref_prefix='U',num_units=1,fplist=['QFN*4x4mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='RI',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='D+',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='REGIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VBUS',do_erc=True),
            Pin(num='9',name='~RST',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='VIO/NC',func=Pin.PWROUT,do_erc=True),
            Pin(num='20',name='RXD',do_erc=True),
            Pin(num='11',name='GPIO.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='GPIO.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='DSR',do_erc=True),
            Pin(num='13',name='GPIO.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='DTR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='GPIO.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='DCD',do_erc=True),
            Pin(num='15',name='~SUSPEND',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='PAD',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VPP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='SUSPEND',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='CTS',do_erc=True),
            Pin(num='19',name='RTS',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='CP2112',dest=TEMPLATE,tool=SKIDL,keywords='USB SMBUS bridge',description='HID USB to SMBUS master bridge',ref_prefix='U',num_units=1,fplist=['QFN*4x4mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='D+',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='REGIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VBUS',do_erc=True),
            Pin(num='9',name='~RST',do_erc=True),
            Pin(num='10',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='20',name='GPIO.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='SUSPEND',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='GPIO.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='GPIO.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GPIO.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='GPIO.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='GPIO.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GPIO.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='SCL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='GPIO.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VPP',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='~SUSPEND',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='19',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='Si4362',dest=TEMPLATE,tool=SKIDL,keywords='radio receiver',description='EZRadioPRO Low Current Receiver',ref_prefix='U',num_units=1,fplist=['QFN*4x4mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='SDN',do_erc=True),
            Pin(num='2',name='RXp',do_erc=True),
            Pin(num='3',name='RXn',do_erc=True),
            Pin(num='4',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GPIO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GPIO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='GPIO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='~IRQ',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='SCLK',do_erc=True),
            Pin(num='13',name='SDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='SDI',do_erc=True),
            Pin(num='15',name='~SEL',do_erc=True),
            Pin(num='16',name='XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='XIN',do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='GPIO2',func=Pin.BIDIR,do_erc=True)]),
        Part(name='Si4735-D60-GU',dest=TEMPLATE,tool=SKIDL,keywords='Broadcast AM FM SW LW Radio Receiver RDS RBDS',description='AM/FM/SW/LW Broadcast Radio Receiver with RDS/RBDS',ref_prefix='U',num_units=1,fplist=['SSOP-24_3.9x8.7mm_Pitch0.635mm*'],do_erc=True,aliases=['Si4734-D60-GU', 'Si4731-D60-GU', 'Si4730-D60-GU'],pins=[
            Pin(num='1',name='DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='DFS',do_erc=True),
            Pin(num='3',name='GPO3/[DCLK]',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GPO2/[~INT~]',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='GPO1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='FMI',do_erc=True),
            Pin(num='9',name='RFGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='20',name='VD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='21',name='VA',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='AMI',do_erc=True),
            Pin(num='22',name='DBYP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='ROUT/[DOUT]',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='LOUT/[DFS]',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='~RST',do_erc=True),
            Pin(num='16',name='~SEN',do_erc=True),
            Pin(num='17',name='SCLK',do_erc=True),
            Pin(num='18',name='SDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RCLK',do_erc=True)])])