# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ServerUpgradeStartParameters(Model):
    """Start Azure SQL Server Upgrade parameters.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar version: The version for the Azure SQL Server being upgraded.
     Default value: "12.0" .
    :vartype version: str
    :param schedule_upgrade_after_utc_date_time: The earliest time to upgrade
     the Azure SQL Server (ISO8601 format).
    :type schedule_upgrade_after_utc_date_time: datetime
    :param database_collection: The collection of recommended database
     properties to upgrade the Azure SQL Server.
    :type database_collection: list of :class:`RecommendedDatabaseProperties
     <azure.mgmt.sql.models.RecommendedDatabaseProperties>`
    :param elastic_pool_collection: The collection of recommended elastic
     pool properties to upgrade the Azure SQL Server.
    :type elastic_pool_collection: list of
     :class:`UpgradeRecommendedElasticPoolProperties
     <azure.mgmt.sql.models.UpgradeRecommendedElasticPoolProperties>`
    """ 

    _validation = {
        'version': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'version': {'key': 'serverUpgradeProperties.Version', 'type': 'str'},
        'schedule_upgrade_after_utc_date_time': {'key': 'serverUpgradeProperties.ScheduleUpgradeAfterUtcDateTime', 'type': 'iso-8601'},
        'database_collection': {'key': 'serverUpgradeProperties.DatabaseCollection', 'type': '[RecommendedDatabaseProperties]'},
        'elastic_pool_collection': {'key': 'serverUpgradeProperties.ElasticPoolCollection', 'type': '[UpgradeRecommendedElasticPoolProperties]'},
    }

    version = "12.0"

    def __init__(self, schedule_upgrade_after_utc_date_time=None, database_collection=None, elastic_pool_collection=None):
        self.schedule_upgrade_after_utc_date_time = schedule_upgrade_after_utc_date_time
        self.database_collection = database_collection
        self.elastic_pool_collection = elastic_pool_collection
