/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import junit.framework.TestCase;
import org.openqa.selenium.server.BrowserConfigurationOptions;

public class BrowserConfigurationOptionsTest
extends TestCase {
    public void testInitializationWithNoOptions() {
        BrowserConfigurationOptions options = new BrowserConfigurationOptions("");
    }

    public void testInitializationWithGoodSingleOption() {
        BrowserConfigurationOptions options = new BrowserConfigurationOptions("profile:foo");
        BrowserConfigurationOptionsTest.assertEquals((String)"foo", (String)options.getProfile());
        BrowserConfigurationOptionsTest.assertTrue((boolean)options.hasOptions());
    }

    public void testInitializationWithGoodSingleOptionAndWhitespace() {
        BrowserConfigurationOptions options = new BrowserConfigurationOptions("profile: foo bar");
        BrowserConfigurationOptionsTest.assertEquals((String)"foo bar", (String)options.getProfile());
        BrowserConfigurationOptionsTest.assertTrue((boolean)options.hasOptions());
    }

    public void testInitializationWithBadSingleOption() {
        BrowserConfigurationOptions options = new BrowserConfigurationOptions("profile_foo");
        BrowserConfigurationOptionsTest.assertEquals((String)"", (String)options.getProfile());
        BrowserConfigurationOptionsTest.assertFalse((boolean)options.hasOptions());
    }

    public void testInitializationWithGoodOptionsAndWhitespace() {
        BrowserConfigurationOptions options = new BrowserConfigurationOptions("profile:foo ; unknown:bar");
        BrowserConfigurationOptionsTest.assertEquals((String)"foo", (String)options.getProfile());
        BrowserConfigurationOptionsTest.assertTrue((boolean)options.hasOptions());
    }

    public void testSettingProfileWithNull() {
        BrowserConfigurationOptions options = new BrowserConfigurationOptions();
        options.setProfile(null);
        BrowserConfigurationOptionsTest.assertEquals((String)"", (String)options.getProfile());
        BrowserConfigurationOptionsTest.assertFalse((boolean)options.hasOptions());
    }

    public void testSettingProfileWithEmptyString() {
        BrowserConfigurationOptions options = new BrowserConfigurationOptions();
        options.setProfile("");
        BrowserConfigurationOptionsTest.assertEquals((String)"", (String)options.getProfile());
        BrowserConfigurationOptionsTest.assertFalse((boolean)options.hasOptions());
    }

    public void testHasOptionsAfterSettingProfile() {
        BrowserConfigurationOptions options = new BrowserConfigurationOptions();
        options.setProfile("test");
        BrowserConfigurationOptionsTest.assertEquals((String)"test", (String)options.getProfile());
        BrowserConfigurationOptionsTest.assertTrue((boolean)options.hasOptions());
    }

    public void testToStringEquivalentToSerialize() {
        String[] tests = new String[]{"", "foo", "foo bar", null};
        BrowserConfigurationOptions options = new BrowserConfigurationOptions();
        for (String test : tests) {
            options.setProfile(test);
            BrowserConfigurationOptionsTest.assertEquals((String)options.serialize(), (String)options.toString());
        }
    }
}

