/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.IOException;
import junit.framework.TestCase;
import org.mortbay.http.HttpContext;
import org.mortbay.util.Resource;
import org.openqa.selenium.server.ClasspathResourceLocator;

public class ClasspathResourceLocatorUnitTest
extends TestCase {
    public void testShouldGetResourceFromClasspath() throws Exception {
        Resource resource = this.getResourceFromClasspath("ClasspathResourceLocatorUnitTest.class");
        ClasspathResourceLocatorUnitTest.assertNotNull((Object)resource.getInputStream());
    }

    public void testShouldReturnMissingResourceWhenResourceNotFound() throws Exception {
        Resource resource = this.getResourceFromClasspath("not_exists");
        ClasspathResourceLocatorUnitTest.assertFalse((boolean)resource.exists());
        ClasspathResourceLocatorUnitTest.assertNull((Object)resource.getInputStream());
    }

    public void testShouldStoreFileNameInMetaData() throws Exception {
        String filename = "ClasspathResourceLocatorUnitTest.class";
        Resource resource = this.getResourceFromClasspath(filename);
        ClasspathResourceLocatorUnitTest.assertEquals((String)"toString() must end with filename, because Jetty used this method to determine file type", (String)filename, (String)resource.toString());
    }

    private Resource getResourceFromClasspath(String path) throws IOException {
        ClasspathResourceLocator locator = new ClasspathResourceLocator();
        return locator.getResource(new HttpContext(), path);
    }
}

