# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SiteLimits(Model):
    """Represents metric limits set on a web app.

    :param max_percentage_cpu: Maximum allowed CPU usage percentage
    :type max_percentage_cpu: float
    :param max_memory_in_mb: Maximum allowed memory usage in MB
    :type max_memory_in_mb: long
    :param max_disk_size_in_mb: Maximum allowed disk size usage in MB
    :type max_disk_size_in_mb: long
    """ 

    _attribute_map = {
        'max_percentage_cpu': {'key': 'maxPercentageCpu', 'type': 'float'},
        'max_memory_in_mb': {'key': 'maxMemoryInMb', 'type': 'long'},
        'max_disk_size_in_mb': {'key': 'maxDiskSizeInMb', 'type': 'long'},
    }

    def __init__(self, max_percentage_cpu=None, max_memory_in_mb=None, max_disk_size_in_mb=None):
        self.max_percentage_cpu = max_percentage_cpu
        self.max_memory_in_mb = max_memory_in_mb
        self.max_disk_size_in_mb = max_disk_size_in_mb
