# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class CapabilitiesListResult(msrest.serialization.Model):
    """location capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of supported capabilities.
    :vartype value: list[~azure.mgmt.rdbms.postgresql_flexibleservers.models.CapabilityProperties]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CapabilityProperties]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CapabilitiesListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class CapabilityProperties(msrest.serialization.Model):
    """Location capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar zone: zone name.
    :vartype zone: str
    :ivar supported_flexible_server_editions:
    :vartype supported_flexible_server_editions:
     list[~azure.mgmt.rdbms.postgresql_flexibleservers.models.ServerEditionCapability]
    """

    _validation = {
        'zone': {'readonly': True},
        'supported_flexible_server_editions': {'readonly': True},
    }

    _attribute_map = {
        'zone': {'key': 'zone', 'type': 'str'},
        'supported_flexible_server_editions': {'key': 'supportedFlexibleServerEditions', 'type': '[ServerEditionCapability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CapabilityProperties, self).__init__(**kwargs)
        self.zone = None
        self.supported_flexible_server_editions = None


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class Configuration(ProxyResource):
    """Represents a Configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param value: Value of the configuration.
    :type value: str
    :ivar description: Description of the configuration.
    :vartype description: str
    :ivar default_value: Default value of the configuration.
    :vartype default_value: str
    :ivar data_type: Data type of the configuration. Possible values include: "Boolean", "Numeric",
     "Integer", "Enumeration".
    :vartype data_type: str or
     ~azure.mgmt.rdbms.postgresql_flexibleservers.models.ConfigurationDataType
    :ivar allowed_values: Allowed values of the configuration.
    :vartype allowed_values: str
    :param source: Source of the configuration.
    :type source: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'default_value': {'readonly': True},
        'data_type': {'readonly': True},
        'allowed_values': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'default_value': {'key': 'properties.defaultValue', 'type': 'str'},
        'data_type': {'key': 'properties.dataType', 'type': 'str'},
        'allowed_values': {'key': 'properties.allowedValues', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Configuration, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.description = None
        self.default_value = None
        self.data_type = None
        self.allowed_values = None
        self.source = kwargs.get('source', None)


class ConfigurationListResult(msrest.serialization.Model):
    """A list of server configurations.

    :param value: The list of server configurations.
    :type value: list[~azure.mgmt.rdbms.postgresql_flexibleservers.models.Configuration]
    :param next_link: The link used to get the next page of operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Configuration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConfigurationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class Database(ProxyResource):
    """Represents a Database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param charset: The charset of the database.
    :type charset: str
    :param collation: The collation of the database.
    :type collation: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'charset': {'key': 'properties.charset', 'type': 'str'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Database, self).__init__(**kwargs)
        self.charset = kwargs.get('charset', None)
        self.collation = kwargs.get('collation', None)


class DatabaseListResult(msrest.serialization.Model):
    """A List of databases.

    :param value: The list of databases housed in a server.
    :type value: list[~azure.mgmt.rdbms.postgresql_flexibleservers.models.Database]
    :param next_link: The link used to get the next page of databases.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Database]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class DelegatedSubnetUsage(msrest.serialization.Model):
    """Delegated subnet usage data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subnet_name: name of the subnet.
    :vartype subnet_name: str
    :ivar usage: Number of used delegated subnets.
    :vartype usage: long
    """

    _validation = {
        'subnet_name': {'readonly': True},
        'usage': {'readonly': True},
    }

    _attribute_map = {
        'subnet_name': {'key': 'subnetName', 'type': 'str'},
        'usage': {'key': 'usage', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DelegatedSubnetUsage, self).__init__(**kwargs)
        self.subnet_name = None
        self.usage = None


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: str
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.rdbms.postgresql_flexibleservers.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.rdbms.postgresql_flexibleservers.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class FirewallRule(ProxyResource):
    """Represents a server firewall rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param start_ip_address: Required. The start IP address of the server firewall rule. Must be
     IPv4 format.
    :type start_ip_address: str
    :param end_ip_address: Required. The end IP address of the server firewall rule. Must be IPv4
     format.
    :type end_ip_address: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'start_ip_address': {'required': True, 'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$'},
        'end_ip_address': {'required': True, 'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallRule, self).__init__(**kwargs)
        self.start_ip_address = kwargs['start_ip_address']
        self.end_ip_address = kwargs['end_ip_address']


class FirewallRuleListResult(msrest.serialization.Model):
    """A list of firewall rules.

    :param value: The list of firewall rules in a server.
    :type value: list[~azure.mgmt.rdbms.postgresql_flexibleservers.models.FirewallRule]
    :param next_link: The link used to get the next page of operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FirewallRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallRuleListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Default value: "SystemAssigned".
    :vartype type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'constant': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "SystemAssigned"

    def __init__(
        self,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None


class MaintenanceWindow(msrest.serialization.Model):
    """Maintenance window of a server.

    :param custom_window: indicates whether custom window is enabled or disabled.
    :type custom_window: str
    :param start_hour: start hour for maintenance window.
    :type start_hour: int
    :param start_minute: start minute for maintenance window.
    :type start_minute: int
    :param day_of_week: day of week for maintenance window.
    :type day_of_week: int
    """

    _attribute_map = {
        'custom_window': {'key': 'customWindow', 'type': 'str'},
        'start_hour': {'key': 'startHour', 'type': 'int'},
        'start_minute': {'key': 'startMinute', 'type': 'int'},
        'day_of_week': {'key': 'dayOfWeek', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MaintenanceWindow, self).__init__(**kwargs)
        self.custom_window = kwargs.get('custom_window', None)
        self.start_hour = kwargs.get('start_hour', None)
        self.start_minute = kwargs.get('start_minute', None)
        self.day_of_week = kwargs.get('day_of_week', None)


class NameAvailability(msrest.serialization.Model):
    """Represents a resource name availability.

    :param message: Error Message.
    :type message: str
    :param name_available: Indicates whether the resource name is available.
    :type name_available: bool
    :param name: name of the PostgreSQL server.
    :type name: str
    :param type: type of the server.
    :type type: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NameAvailability, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)
        self.name_available = kwargs.get('name_available', None)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)


class NameAvailabilityRequest(msrest.serialization.Model):
    """Request from client to check resource name availability.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Resource name to verify.
    :type name: str
    :param type: Resource type used for verification.
    :type type: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NameAvailabilityRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.type = kwargs.get('type', None)


class Operation(msrest.serialization.Model):
    """REST API operation definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation being performed on this particular object.
    :vartype name: str
    :ivar display: The localized display information for this particular operation or action.
    :vartype display: ~azure.mgmt.rdbms.postgresql_flexibleservers.models.OperationDisplay
    :param is_data_action: Indicates whether the operation is a data action.
    :type is_data_action: bool
    :ivar origin: The intended executor of the operation. Possible values include: "NotSpecified",
     "user", "system".
    :vartype origin: str or ~azure.mgmt.rdbms.postgresql_flexibleservers.models.OperationOrigin
    :ivar properties: Additional descriptions for the operation.
    :vartype properties: dict[str, str]
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
        'origin': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None
        self.is_data_action = kwargs.get('is_data_action', None)
        self.origin = None
        self.properties = None


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Operation resource provider name.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of resource provider operations.

    :param value: Collection of available operation details.
    :type value: list[~azure.mgmt.rdbms.postgresql_flexibleservers.models.Operation]
    :param next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']


class Server(TrackedResource):
    """Represents a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param identity: The Azure Active Directory identity of the server.
    :type identity: ~azure.mgmt.rdbms.postgresql_flexibleservers.models.Identity
    :param sku: The SKU (pricing tier) of the server.
    :type sku: ~azure.mgmt.rdbms.postgresql_flexibleservers.models.Sku
    :param administrator_login: The administrator's login name of a server. Can only be specified
     when the server is being created (and is required for creation).
    :type administrator_login: str
    :param administrator_login_password: The administrator login password (required for server
     creation).
    :type administrator_login_password: str
    :param version: PostgreSQL Server version. Possible values include: "12", "11".
    :type version: str or ~azure.mgmt.rdbms.postgresql_flexibleservers.models.ServerVersion
    :ivar state: A state of a server that is visible to user. Possible values include: "Ready",
     "Dropping", "Disabled", "Starting", "Stopping", "Stopped", "Updating".
    :vartype state: str or ~azure.mgmt.rdbms.postgresql_flexibleservers.models.ServerState
    :ivar ha_state: A state of a HA server that is visible to user. Possible values include:
     "NotEnabled", "CreatingStandby", "ReplicatingData", "FailingOver", "Healthy",
     "RemovingStandby".
    :vartype ha_state: str or ~azure.mgmt.rdbms.postgresql_flexibleservers.models.ServerHAState
    :ivar fully_qualified_domain_name: The fully qualified domain name of a server.
    :vartype fully_qualified_domain_name: str
    :param display_name: The display name of a server.
    :type display_name: str
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.postgresql_flexibleservers.models.StorageProfile
    :ivar public_network_access: public network access is enabled or not. Possible values include:
     "Enabled", "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.rdbms.postgresql_flexibleservers.models.ServerPublicNetworkAccessState
    :param maintenance_window: Maintenance window of a server.
    :type maintenance_window: ~azure.mgmt.rdbms.postgresql_flexibleservers.models.MaintenanceWindow
    :param ha_enabled: stand by count value can be either enabled or disabled. Possible values
     include: "Enabled", "Disabled".
    :type ha_enabled: str or ~azure.mgmt.rdbms.postgresql_flexibleservers.models.HAEnabledEnum
    :param source_server_name: The source PostgreSQL server name to restore from.
    :type source_server_name: str
    :param source_subscription_id: The subscription id of source serve PostgreSQL server name to
     restore from.
    :type source_subscription_id: str
    :param source_resource_group_name: The resource group name of source serve PostgreSQL server
     name to restore from.
    :type source_resource_group_name: str
    :param point_in_time_utc: Restore point creation time (ISO8601 format), specifying the time to
     restore from.
    :type point_in_time_utc: ~datetime.datetime
    :param availability_zone: availability Zone information of the server.
    :type availability_zone: str
    :ivar standby_availability_zone: availability Zone information of the server.
    :vartype standby_availability_zone: str
    :ivar byok_enforcement: Status showing whether the data encryption is enabled with
     customer-managed keys.
    :vartype byok_enforcement: str
    :param delegated_subnet_arguments:
    :type delegated_subnet_arguments:
     ~azure.mgmt.rdbms.postgresql_flexibleservers.models.ServerPropertiesDelegatedSubnetArguments
    :param private_dns_zone_arguments:
    :type private_dns_zone_arguments:
     ~azure.mgmt.rdbms.postgresql_flexibleservers.models.ServerPropertiesPrivateDnsZoneArguments
    :param create_mode: The mode to create a new PostgreSQL server. Possible values include:
     "Default", "PointInTimeRestore".
    :type create_mode: str or ~azure.mgmt.rdbms.postgresql_flexibleservers.models.CreateMode
    :param tags_properties_tags: Application-specific metadata in the form of key-value pairs.
    :type tags_properties_tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'state': {'readonly': True},
        'ha_state': {'readonly': True},
        'fully_qualified_domain_name': {'readonly': True},
        'public_network_access': {'readonly': True},
        'standby_availability_zone': {'readonly': True},
        'byok_enforcement': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'ha_state': {'key': 'properties.haState', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'maintenance_window': {'key': 'properties.maintenanceWindow', 'type': 'MaintenanceWindow'},
        'ha_enabled': {'key': 'properties.haEnabled', 'type': 'str'},
        'source_server_name': {'key': 'properties.sourceServerName', 'type': 'str'},
        'source_subscription_id': {'key': 'properties.sourceSubscriptionId', 'type': 'str'},
        'source_resource_group_name': {'key': 'properties.sourceResourceGroupName', 'type': 'str'},
        'point_in_time_utc': {'key': 'properties.pointInTimeUTC', 'type': 'iso-8601'},
        'availability_zone': {'key': 'properties.availabilityZone', 'type': 'str'},
        'standby_availability_zone': {'key': 'properties.standbyAvailabilityZone', 'type': 'str'},
        'byok_enforcement': {'key': 'properties.byokEnforcement', 'type': 'str'},
        'delegated_subnet_arguments': {'key': 'properties.delegatedSubnetArguments', 'type': 'ServerPropertiesDelegatedSubnetArguments'},
        'private_dns_zone_arguments': {'key': 'properties.privateDnsZoneArguments', 'type': 'ServerPropertiesPrivateDnsZoneArguments'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'tags_properties_tags': {'key': 'properties.tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Server, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.sku = kwargs.get('sku', None)
        self.administrator_login = kwargs.get('administrator_login', None)
        self.administrator_login_password = kwargs.get('administrator_login_password', None)
        self.version = kwargs.get('version', None)
        self.state = None
        self.ha_state = None
        self.fully_qualified_domain_name = None
        self.display_name = kwargs.get('display_name', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.public_network_access = None
        self.maintenance_window = kwargs.get('maintenance_window', None)
        self.ha_enabled = kwargs.get('ha_enabled', None)
        self.source_server_name = kwargs.get('source_server_name', None)
        self.source_subscription_id = kwargs.get('source_subscription_id', None)
        self.source_resource_group_name = kwargs.get('source_resource_group_name', None)
        self.point_in_time_utc = kwargs.get('point_in_time_utc', None)
        self.availability_zone = kwargs.get('availability_zone', None)
        self.standby_availability_zone = None
        self.byok_enforcement = None
        self.delegated_subnet_arguments = kwargs.get('delegated_subnet_arguments', None)
        self.private_dns_zone_arguments = kwargs.get('private_dns_zone_arguments', None)
        self.create_mode = kwargs.get('create_mode', None)
        self.tags_properties_tags = kwargs.get('tags_properties_tags', None)


class ServerEditionCapability(msrest.serialization.Model):
    """Server edition capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Server edition name.
    :vartype name: str
    :ivar supported_storage_editions:
    :vartype supported_storage_editions:
     list[~azure.mgmt.rdbms.postgresql_flexibleservers.models.StorageEditionCapability]
    :ivar supported_server_versions:
    :vartype supported_server_versions:
     list[~azure.mgmt.rdbms.postgresql_flexibleservers.models.ServerVersionCapability]
    """

    _validation = {
        'name': {'readonly': True},
        'supported_storage_editions': {'readonly': True},
        'supported_server_versions': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_storage_editions': {'key': 'supportedStorageEditions', 'type': '[StorageEditionCapability]'},
        'supported_server_versions': {'key': 'supportedServerVersions', 'type': '[ServerVersionCapability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerEditionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_storage_editions = None
        self.supported_server_versions = None


class ServerForUpdate(msrest.serialization.Model):
    """Represents a server to be updated.

    :param location: The location the resource resides in.
    :type location: str
    :param sku: The SKU (pricing tier) of the server.
    :type sku: ~azure.mgmt.rdbms.postgresql_flexibleservers.models.Sku
    :param tags: A set of tags. Application-specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    :param administrator_login_password: The password of the administrator login.
    :type administrator_login_password: str
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.postgresql_flexibleservers.models.StorageProfile
    :param ha_enabled: stand by count value can be either enabled or disabled. Possible values
     include: "Enabled", "Disabled".
    :type ha_enabled: str or ~azure.mgmt.rdbms.postgresql_flexibleservers.models.HAEnabledEnum
    :param maintenance_window: Maintenance window of a server.
    :type maintenance_window: ~azure.mgmt.rdbms.postgresql_flexibleservers.models.MaintenanceWindow
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'ha_enabled': {'key': 'properties.haEnabled', 'type': 'str'},
        'maintenance_window': {'key': 'properties.maintenanceWindow', 'type': 'MaintenanceWindow'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerForUpdate, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)
        self.administrator_login_password = kwargs.get('administrator_login_password', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.ha_enabled = kwargs.get('ha_enabled', None)
        self.maintenance_window = kwargs.get('maintenance_window', None)


class ServerListResult(msrest.serialization.Model):
    """A list of servers.

    :param value: The list of flexible servers.
    :type value: list[~azure.mgmt.rdbms.postgresql_flexibleservers.models.Server]
    :param next_link: The link used to get the next page of operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Server]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ServerPropertiesDelegatedSubnetArguments(msrest.serialization.Model):
    """ServerPropertiesDelegatedSubnetArguments.

    :param subnet_arm_resource_id: delegated subnet arm resource id.
    :type subnet_arm_resource_id: str
    """

    _attribute_map = {
        'subnet_arm_resource_id': {'key': 'subnetArmResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerPropertiesDelegatedSubnetArguments, self).__init__(**kwargs)
        self.subnet_arm_resource_id = kwargs.get('subnet_arm_resource_id', None)


class ServerPropertiesPrivateDnsZoneArguments(msrest.serialization.Model):
    """ServerPropertiesPrivateDnsZoneArguments.

    :param private_dns_zone_arm_resource_id: private dns zone arm resource id.
    :type private_dns_zone_arm_resource_id: str
    """

    _attribute_map = {
        'private_dns_zone_arm_resource_id': {'key': 'privateDnsZoneArmResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerPropertiesPrivateDnsZoneArguments, self).__init__(**kwargs)
        self.private_dns_zone_arm_resource_id = kwargs.get('private_dns_zone_arm_resource_id', None)


class ServerVersionCapability(msrest.serialization.Model):
    """Server version capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: server version.
    :vartype name: str
    :ivar supported_vcores:
    :vartype supported_vcores:
     list[~azure.mgmt.rdbms.postgresql_flexibleservers.models.VcoreCapability]
    """

    _validation = {
        'name': {'readonly': True},
        'supported_vcores': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_vcores': {'key': 'supportedVcores', 'type': '[VcoreCapability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerVersionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_vcores = None


class Sku(msrest.serialization.Model):
    """Sku information related properties of a server.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the sku, typically, tier + family + cores, e.g.
     Standard_D4s_v3.
    :type name: str
    :param tier: Required. The tier of the particular SKU, e.g. Burstable. Possible values include:
     "Burstable", "GeneralPurpose", "MemoryOptimized".
    :type tier: str or ~azure.mgmt.rdbms.postgresql_flexibleservers.models.SkuTier
    """

    _validation = {
        'name': {'required': True},
        'tier': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = kwargs['tier']


class StorageEditionCapability(msrest.serialization.Model):
    """storage edition capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: storage edition name.
    :vartype name: str
    :ivar supported_storage_mb:
    :vartype supported_storage_mb:
     list[~azure.mgmt.rdbms.postgresql_flexibleservers.models.StorageMBCapability]
    """

    _validation = {
        'name': {'readonly': True},
        'supported_storage_mb': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_storage_mb': {'key': 'supportedStorageMB', 'type': '[StorageMBCapability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageEditionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_storage_mb = None


class StorageMBCapability(msrest.serialization.Model):
    """storage size in MB capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: storage MB name.
    :vartype name: str
    :ivar supported_iops: supported IOPS.
    :vartype supported_iops: long
    :ivar storage_size_mb: storage size in MB.
    :vartype storage_size_mb: long
    """

    _validation = {
        'name': {'readonly': True},
        'supported_iops': {'readonly': True},
        'storage_size_mb': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_iops': {'key': 'supportedIops', 'type': 'long'},
        'storage_size_mb': {'key': 'storageSizeMB', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageMBCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_iops = None
        self.storage_size_mb = None


class StorageProfile(msrest.serialization.Model):
    """Storage Profile properties of a server.

    :param backup_retention_days: Backup retention days for the server.
    :type backup_retention_days: int
    :param storage_mb: Max storage allowed for a server.
    :type storage_mb: int
    """

    _attribute_map = {
        'backup_retention_days': {'key': 'backupRetentionDays', 'type': 'int'},
        'storage_mb': {'key': 'storageMB', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageProfile, self).__init__(**kwargs)
        self.backup_retention_days = kwargs.get('backup_retention_days', None)
        self.storage_mb = kwargs.get('storage_mb', None)


class VcoreCapability(msrest.serialization.Model):
    """Vcores capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: vCore name.
    :vartype name: str
    :ivar v_cores: supported vCores.
    :vartype v_cores: long
    :ivar supported_iops: supported IOPS.
    :vartype supported_iops: long
    :ivar supported_memory_per_vcore_mb: supported memory per vCore in MB.
    :vartype supported_memory_per_vcore_mb: long
    """

    _validation = {
        'name': {'readonly': True},
        'v_cores': {'readonly': True},
        'supported_iops': {'readonly': True},
        'supported_memory_per_vcore_mb': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'v_cores': {'key': 'vCores', 'type': 'long'},
        'supported_iops': {'key': 'supportedIops', 'type': 'long'},
        'supported_memory_per_vcore_mb': {'key': 'supportedMemoryPerVcoreMB', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VcoreCapability, self).__init__(**kwargs)
        self.name = None
        self.v_cores = None
        self.supported_iops = None
        self.supported_memory_per_vcore_mb = None


class VirtualNetworkSubnetUsageParameter(msrest.serialization.Model):
    """Virtual network subnet usage parameter.

    :param virtual_network_arm_resource_id: Virtual network resource id.
    :type virtual_network_arm_resource_id: str
    """

    _attribute_map = {
        'virtual_network_arm_resource_id': {'key': 'virtualNetworkArmResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkSubnetUsageParameter, self).__init__(**kwargs)
        self.virtual_network_arm_resource_id = kwargs.get('virtual_network_arm_resource_id', None)


class VirtualNetworkSubnetUsageResult(msrest.serialization.Model):
    """Virtual network subnet usage data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar delegated_subnets_usage:
    :vartype delegated_subnets_usage:
     list[~azure.mgmt.rdbms.postgresql_flexibleservers.models.DelegatedSubnetUsage]
    """

    _validation = {
        'delegated_subnets_usage': {'readonly': True},
    }

    _attribute_map = {
        'delegated_subnets_usage': {'key': 'delegatedSubnetsUsage', 'type': '[DelegatedSubnetUsage]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkSubnetUsageResult, self).__init__(**kwargs)
        self.delegated_subnets_usage = None
