# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class ActivateApplicationPackageParameters(Model):
    """Parameters for an activating an application package.

    :param format: The format of the application package binary file.
    :type format: str
    """

    _validation = {
        'format': {'required': True},
    }

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
    }

    def __init__(self, format):
        super(ActivateApplicationPackageParameters, self).__init__()
        self.format = format


class ApplicationPackageReference(Model):
    """Link to an application package inside the batch account.

    :param id: The ID of the application package to install. This must be
     inside the same batch account as the pool. This can either be a reference
     to a specific version or the default version if one exists.
    :type id: str
    :param version: The version of the application to deploy. If omitted, the
     default version is deployed. If this is omitted, and no default version is
     specified for this application, the request fails with the error code
     InvalidApplicationPackageReferences. If you are calling the REST API
     directly, the HTTP status code is 409.
    :type version: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(self, id, version=None):
        super(ApplicationPackageReference, self).__init__()
        self.id = id
        self.version = version


class AutoScaleRun(Model):
    """The results and errors from an execution of a pool autoscale formula.

    :param evaluation_time: The time at which the autoscale formula was last
     evaluated.
    :type evaluation_time: datetime
    :param results: The final values of all variables used in the evaluation
     of the autoscale formula. Each variable value is returned in the form
     $variable=value, and variables are separated by semicolons.
    :type results: str
    :param error: Details of the error encountered evaluating the autoscale
     formula on the pool, if the evaluation was unsuccessful.
    :type error: ~azure.mgmt.batch.models.AutoScaleRunError
    """

    _validation = {
        'evaluation_time': {'required': True},
    }

    _attribute_map = {
        'evaluation_time': {'key': 'evaluationTime', 'type': 'iso-8601'},
        'results': {'key': 'results', 'type': 'str'},
        'error': {'key': 'error', 'type': 'AutoScaleRunError'},
    }

    def __init__(self, evaluation_time, results=None, error=None):
        super(AutoScaleRun, self).__init__()
        self.evaluation_time = evaluation_time
        self.results = results
        self.error = error


class AutoScaleRunError(Model):
    """An error that occurred when autoscaling a pool.

    :param code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable
     for display in a user interface.
    :type message: str
    :param details: Additional details about the error.
    :type details: list[~azure.mgmt.batch.models.AutoScaleRunError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[AutoScaleRunError]'},
    }

    def __init__(self, code, message, details=None):
        super(AutoScaleRunError, self).__init__()
        self.code = code
        self.message = message
        self.details = details


class AutoScaleSettings(Model):
    """AutoScale settings for the pool.

    :param formula: A formula for the desired number of compute nodes in the
     pool.
    :type formula: str
    :param evaluation_interval: The time interval at which to automatically
     adjust the pool size according to the autoscale formula. If omitted, the
     default value is 15 minutes (PT15M).
    :type evaluation_interval: timedelta
    """

    _validation = {
        'formula': {'required': True},
    }

    _attribute_map = {
        'formula': {'key': 'formula', 'type': 'str'},
        'evaluation_interval': {'key': 'evaluationInterval', 'type': 'duration'},
    }

    def __init__(self, formula, evaluation_interval=None):
        super(AutoScaleSettings, self).__init__()
        self.formula = formula
        self.evaluation_interval = evaluation_interval


class AutoStorageBaseProperties(Model):
    """The properties related to the auto-storage account.

    :param storage_account_id: The resource ID of the storage account to be
     used for auto-storage account.
    :type storage_account_id: str
    """

    _validation = {
        'storage_account_id': {'required': True},
    }

    _attribute_map = {
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
    }

    def __init__(self, storage_account_id):
        super(AutoStorageBaseProperties, self).__init__()
        self.storage_account_id = storage_account_id


class AutoUserSpecification(Model):
    """Specifies the parameters for the auto user that runs a task on the Batch
    service.

    :param scope: The scope for the auto user. The default value is task.
     Possible values include: 'Task', 'Pool'
    :type scope: str or ~azure.mgmt.batch.models.AutoUserScope
    :param elevation_level: The elevation level of the auto user. nonAdmin -
     The auto user is a standard user without elevated access. admin - The auto
     user is a user with elevated access and operates with full Administrator
     permissions. The default value is nonAdmin. Possible values include:
     'NonAdmin', 'Admin'
    :type elevation_level: str or ~azure.mgmt.batch.models.ElevationLevel
    """

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'AutoUserScope'},
        'elevation_level': {'key': 'elevationLevel', 'type': 'ElevationLevel'},
    }

    def __init__(self, scope=None, elevation_level=None):
        super(AutoUserSpecification, self).__init__()
        self.scope = scope
        self.elevation_level = elevation_level


class BatchAccountCreateParameters(Model):
    """Parameters supplied to the Create operation.

    :param location: The region in which to create the account.
    :type location: str
    :param tags: The user-specified tags associated with the account.
    :type tags: dict[str, str]
    :param auto_storage: The properties related to the auto-storage account.
    :type auto_storage: ~azure.mgmt.batch.models.AutoStorageBaseProperties
    :param pool_allocation_mode: The allocation mode to use for creating pools
     in the Batch account. The pool allocation mode also affects how clients
     may authenticate to the Batch Service API. If the mode is BatchService,
     clients may authenticate using access keys or Azure Active Directory. If
     the mode is UserSubscription, clients must use Azure Active Directory. The
     default is BatchService. Possible values include: 'BatchService',
     'UserSubscription'
    :type pool_allocation_mode: str or
     ~azure.mgmt.batch.models.PoolAllocationMode
    :param key_vault_reference: A reference to the Azure key vault associated
     with the Batch account.
    :type key_vault_reference: ~azure.mgmt.batch.models.KeyVaultReference
    """

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'auto_storage': {'key': 'properties.autoStorage', 'type': 'AutoStorageBaseProperties'},
        'pool_allocation_mode': {'key': 'properties.poolAllocationMode', 'type': 'PoolAllocationMode'},
        'key_vault_reference': {'key': 'properties.keyVaultReference', 'type': 'KeyVaultReference'},
    }

    def __init__(self, location, tags=None, auto_storage=None, pool_allocation_mode=None, key_vault_reference=None):
        super(BatchAccountCreateParameters, self).__init__()
        self.location = location
        self.tags = tags
        self.auto_storage = auto_storage
        self.pool_allocation_mode = pool_allocation_mode
        self.key_vault_reference = key_vault_reference


class BatchAccountKeys(Model):
    """A set of Azure Batch account keys.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar account_name: The Batch account name.
    :vartype account_name: str
    :ivar primary: The primary key associated with the account.
    :vartype primary: str
    :ivar secondary: The secondary key associated with the account.
    :vartype secondary: str
    """

    _validation = {
        'account_name': {'readonly': True},
        'primary': {'readonly': True},
        'secondary': {'readonly': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'primary': {'key': 'primary', 'type': 'str'},
        'secondary': {'key': 'secondary', 'type': 'str'},
    }

    def __init__(self):
        super(BatchAccountKeys, self).__init__()
        self.account_name = None
        self.primary = None
        self.secondary = None


class BatchAccountRegenerateKeyParameters(Model):
    """Parameters supplied to the RegenerateKey operation.

    :param key_name: The type of account key to regenerate. Possible values
     include: 'Primary', 'Secondary'
    :type key_name: str or ~azure.mgmt.batch.models.AccountKeyType
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'AccountKeyType'},
    }

    def __init__(self, key_name):
        super(BatchAccountRegenerateKeyParameters, self).__init__()
        self.key_name = key_name


class BatchAccountUpdateParameters(Model):
    """Parameters for updating an Azure Batch account.

    :param tags: The user-specified tags associated with the account.
    :type tags: dict[str, str]
    :param auto_storage: The properties related to the auto-storage account.
    :type auto_storage: ~azure.mgmt.batch.models.AutoStorageBaseProperties
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'auto_storage': {'key': 'properties.autoStorage', 'type': 'AutoStorageBaseProperties'},
    }

    def __init__(self, tags=None, auto_storage=None):
        super(BatchAccountUpdateParameters, self).__init__()
        self.tags = tags
        self.auto_storage = auto_storage


class BatchLocationQuota(Model):
    """Quotas associated with a Batch region for a particular subscription.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar account_quota: The number of Batch accounts that may be created
     under the subscription in the specified region.
    :vartype account_quota: int
    """

    _validation = {
        'account_quota': {'readonly': True},
    }

    _attribute_map = {
        'account_quota': {'key': 'accountQuota', 'type': 'int'},
    }

    def __init__(self):
        super(BatchLocationQuota, self).__init__()
        self.account_quota = None


class CertificateBaseProperties(Model):
    """CertificateBaseProperties.

    :param thumbprint_algorithm: The algorithm of the certificate thumbprint.
     This must match the first portion of the certificate name. Currently
     required to be 'SHA1'.
    :type thumbprint_algorithm: str
    :param thumbprint: The thumbprint of the certificate. This must match the
     thumbprint from the name.
    :type thumbprint: str
    :param format: The format of the certificate - either Pfx or Cer. If
     omitted, the default is Pfx. Possible values include: 'Pfx', 'Cer'
    :type format: str or ~azure.mgmt.batch.models.CertificateFormat
    """

    _attribute_map = {
        'thumbprint_algorithm': {'key': 'thumbprintAlgorithm', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'format': {'key': 'format', 'type': 'CertificateFormat'},
    }

    def __init__(self, thumbprint_algorithm=None, thumbprint=None, format=None):
        super(CertificateBaseProperties, self).__init__()
        self.thumbprint_algorithm = thumbprint_algorithm
        self.thumbprint = thumbprint
        self.format = format


class CertificateReference(Model):
    """A reference to a certificate to be installed on compute nodes in a pool.
    This must exist inside the same account as the pool.

    :param id: The fully qualified ID of the certificate to install on the
     pool. This must be inside the same batch account as the pool.
    :type id: str
    :param store_location: The location of the certificate store on the
     compute node into which to install the certificate. The default value is
     currentUser. This property is applicable only for pools configured with
     Windows nodes (that is, created with cloudServiceConfiguration, or with
     virtualMachineConfiguration using a Windows image reference). For Linux
     compute nodes, the certificates are stored in a directory inside the task
     working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is
     supplied to the task to query for this location. For certificates with
     visibility of 'remoteUser', a 'certs' directory is created in the user's
     home directory (e.g., /home/{user-name}/certs) and certificates are placed
     in that directory. Possible values include: 'CurrentUser', 'LocalMachine'
    :type store_location: str or
     ~azure.mgmt.batch.models.CertificateStoreLocation
    :param store_name: The name of the certificate store on the compute node
     into which to install the certificate. This property is applicable only
     for pools configured with Windows nodes (that is, created with
     cloudServiceConfiguration, or with virtualMachineConfiguration using a
     Windows image reference). Common store names include: My, Root, CA, Trust,
     Disallowed, TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but
     any custom store name can also be used. The default value is My.
    :type store_name: str
    :param visibility: Which user accounts on the compute node should have
     access to the private data of the certificate.
    :type visibility: list[str or
     ~azure.mgmt.batch.models.CertificateVisibility]
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'store_location': {'key': 'storeLocation', 'type': 'CertificateStoreLocation'},
        'store_name': {'key': 'storeName', 'type': 'str'},
        'visibility': {'key': 'visibility', 'type': '[CertificateVisibility]'},
    }

    def __init__(self, id, store_location=None, store_name=None, visibility=None):
        super(CertificateReference, self).__init__()
        self.id = id
        self.store_location = store_location
        self.store_name = store_name
        self.visibility = visibility


class CheckNameAvailabilityParameters(Model):
    """Parameters for a check name availability request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param name: The name to check for availability
    :type name: str
    :ivar type: The resource type. Must be set to
     Microsoft.Batch/batchAccounts. Default value:
     "Microsoft.Batch/batchAccounts" .
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Batch/batchAccounts"

    def __init__(self, name):
        super(CheckNameAvailabilityParameters, self).__init__()
        self.name = name


class CheckNameAvailabilityResult(Model):
    """The CheckNameAvailability operation response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name_available: Gets a boolean value that indicates whether the name
     is available for you to use. If true, the name is available. If false, the
     name has already been taken or invalid and cannot be used.
    :vartype name_available: bool
    :ivar reason: Gets the reason that a Batch account name could not be used.
     The Reason element is only returned if NameAvailable is false. Possible
     values include: 'Invalid', 'AlreadyExists'
    :vartype reason: str or ~azure.mgmt.batch.models.NameAvailabilityReason
    :ivar message: Gets an error message explaining the Reason value in more
     detail.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'NameAvailabilityReason'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self):
        super(CheckNameAvailabilityResult, self).__init__()
        self.name_available = None
        self.reason = None
        self.message = None


class CloudServiceConfiguration(Model):
    """The configuration for nodes in a pool based on the Azure Cloud Services
    platform.

    :param os_family: The Azure Guest OS family to be installed on the virtual
     machines in the pool. Possible values are: 2 - OS Family 2, equivalent to
     Windows Server 2008 R2 SP1. 3 - OS Family 3, equivalent to Windows Server
     2012. 4 - OS Family 4, equivalent to Windows Server 2012 R2. 5 - OS Family
     5, equivalent to Windows Server 2016. For more information, see Azure
     Guest OS Releases
     (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
    :type os_family: str
    :param os_version: The Azure Guest OS version to be installed on the
     virtual machines in the pool. The default value is * which specifies the
     latest operating system version for the specified OS family.
    :type os_version: str
    """

    _validation = {
        'os_family': {'required': True},
    }

    _attribute_map = {
        'os_family': {'key': 'osFamily', 'type': 'str'},
        'os_version': {'key': 'osVersion', 'type': 'str'},
    }

    def __init__(self, os_family, os_version=None):
        super(CloudServiceConfiguration, self).__init__()
        self.os_family = os_family
        self.os_version = os_version


class ContainerConfiguration(Model):
    """The configuration for container-enabled pools.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: The container technology to be used.  Default value:
     "DockerCompatible" .
    :vartype type: str
    :param container_image_names: The collection of container image names.
     This is the full image reference, as would be specified to "docker pull".
     An image will be sourced from the default Docker registry unless the image
     is fully qualified with an alternative registry.
    :type container_image_names: list[str]
    :param container_registries: Additional private registries from which
     containers can be pulled. If any images must be downloaded from a private
     registry which requires credentials, then those credentials must be
     provided here.
    :type container_registries:
     list[~azure.mgmt.batch.models.ContainerRegistry]
    """

    _validation = {
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'container_image_names': {'key': 'containerImageNames', 'type': '[str]'},
        'container_registries': {'key': 'containerRegistries', 'type': '[ContainerRegistry]'},
    }

    type = "DockerCompatible"

    def __init__(self, container_image_names=None, container_registries=None):
        super(ContainerConfiguration, self).__init__()
        self.container_image_names = container_image_names
        self.container_registries = container_registries


class ContainerRegistry(Model):
    """A private container registry.

    :param registry_server: The registry URL. If omitted, the default is
     "docker.io".
    :type registry_server: str
    :param user_name: The user name to log into the registry server.
    :type user_name: str
    :param password: The password to log into the registry server.
    :type password: str
    """

    _validation = {
        'user_name': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'registry_server': {'key': 'registryServer', 'type': 'str'},
        'user_name': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(self, user_name, password, registry_server=None):
        super(ContainerRegistry, self).__init__()
        self.registry_server = registry_server
        self.user_name = user_name
        self.password = password


class DataDisk(Model):
    """Data Disk settings which will be used by the data disks associated to
    Compute Nodes in the pool.

    :param lun: The logical unit number. The lun is used to uniquely identify
     each data disk. If attaching multiple disks, each should have a distinct
     lun.
    :type lun: int
    :param caching: The type of caching to be enabled for the data disks.
     Values are:
     none - The caching mode for the disk is not enabled.
     readOnly - The caching mode for the disk is read only.
     readWrite - The caching mode for the disk is read and write.
     The default value for caching is none. For information about the caching
     options see:
     https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
     Possible values include: 'None', 'ReadOnly', 'ReadWrite'
    :type caching: str or ~azure.mgmt.batch.models.CachingType
    :param disk_size_gb: The initial disk size in GB when creating new data
     disk.
    :type disk_size_gb: int
    :param storage_account_type: The storage account type to be used for the
     data disk. If omitted, the default is "Standard_LRS". Values are:
     Standard_LRS - The data disk should use standard locally redundant
     storage.
     Premium_LRS - The data disk should use premium locally redundant storage.
     Possible values include: 'Standard_LRS', 'Premium_LRS'
    :type storage_account_type: str or
     ~azure.mgmt.batch.models.StorageAccountType
    """

    _validation = {
        'lun': {'required': True},
        'disk_size_gb': {'required': True},
    }

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'int'},
        'caching': {'key': 'caching', 'type': 'CachingType'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'StorageAccountType'},
    }

    def __init__(self, lun, disk_size_gb, caching=None, storage_account_type=None):
        super(DataDisk, self).__init__()
        self.lun = lun
        self.caching = caching
        self.disk_size_gb = disk_size_gb
        self.storage_account_type = storage_account_type


class DeleteCertificateError(Model):
    """An error response from the Batch service.

    :param code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable
     for display in a user interface.
    :type message: str
    :param target: The target of the particular error. For example, the name
     of the property in error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.batch.models.DeleteCertificateError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[DeleteCertificateError]'},
    }

    def __init__(self, code, message, target=None, details=None):
        super(DeleteCertificateError, self).__init__()
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class DeploymentConfiguration(Model):
    """Deployment configuration properties.

    :param cloud_service_configuration: The cloud service configuration for
     the pool. This property and virtualMachineConfiguration are mutually
     exclusive and one of the properties must be specified. This property
     cannot be specified if the Batch account was created with its
     poolAllocationMode property set to 'UserSubscription'.
    :type cloud_service_configuration:
     ~azure.mgmt.batch.models.CloudServiceConfiguration
    :param virtual_machine_configuration: The virtual machine configuration
     for the pool. This property and cloudServiceConfiguration are mutually
     exclusive and one of the properties must be specified.
    :type virtual_machine_configuration:
     ~azure.mgmt.batch.models.VirtualMachineConfiguration
    """

    _attribute_map = {
        'cloud_service_configuration': {'key': 'cloudServiceConfiguration', 'type': 'CloudServiceConfiguration'},
        'virtual_machine_configuration': {'key': 'virtualMachineConfiguration', 'type': 'VirtualMachineConfiguration'},
    }

    def __init__(self, cloud_service_configuration=None, virtual_machine_configuration=None):
        super(DeploymentConfiguration, self).__init__()
        self.cloud_service_configuration = cloud_service_configuration
        self.virtual_machine_configuration = virtual_machine_configuration


class EnvironmentSetting(Model):
    """An environment variable to be set on a task process.

    :param name: The name of the environment variable.
    :type name: str
    :param value: The value of the environment variable.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, name, value=None):
        super(EnvironmentSetting, self).__init__()
        self.name = name
        self.value = value


class FixedScaleSettings(Model):
    """Fixed scale settings for the pool.

    :param resize_timeout: The timeout for allocation of compute nodes to the
     pool. The default value is 15 minutes. Timeout values use ISO 8601 format.
     For example, use PT10M for 10 minutes. The minimum value is 5 minutes. If
     you specify a value less than 5 minutes, the Batch service rejects the
     request with an error; if you are calling the REST API directly, the HTTP
     status code is 400 (Bad Request).
    :type resize_timeout: timedelta
    :param target_dedicated_nodes: The desired number of dedicated compute
     nodes in the pool. At least one of targetDedicatedNodes, targetLowPriority
     nodes must be set.
    :type target_dedicated_nodes: int
    :param target_low_priority_nodes: The desired number of low-priority
     compute nodes in the pool. At least one of targetDedicatedNodes,
     targetLowPriority nodes must be set.
    :type target_low_priority_nodes: int
    :param node_deallocation_option: Determines what to do with a node and its
     running task(s) if the pool size is decreasing. If omitted, the default
     value is Requeue. Possible values include: 'Requeue', 'Terminate',
     'TaskCompletion', 'RetainedData'
    :type node_deallocation_option: str or
     ~azure.mgmt.batch.models.ComputeNodeDeallocationOption
    """

    _attribute_map = {
        'resize_timeout': {'key': 'resizeTimeout', 'type': 'duration'},
        'target_dedicated_nodes': {'key': 'targetDedicatedNodes', 'type': 'int'},
        'target_low_priority_nodes': {'key': 'targetLowPriorityNodes', 'type': 'int'},
        'node_deallocation_option': {'key': 'nodeDeallocationOption', 'type': 'ComputeNodeDeallocationOption'},
    }

    def __init__(self, resize_timeout=None, target_dedicated_nodes=None, target_low_priority_nodes=None, node_deallocation_option=None):
        super(FixedScaleSettings, self).__init__()
        self.resize_timeout = resize_timeout
        self.target_dedicated_nodes = target_dedicated_nodes
        self.target_low_priority_nodes = target_low_priority_nodes
        self.node_deallocation_option = node_deallocation_option


class ImageReference(Model):
    """A reference to an Azure Virtual Machines Marketplace image or the Azure
    Image resource of a custom Virtual Machine. To get the list of all
    imageReferences verified by Azure Batch, see the 'List supported node agent
    SKUs' operation.

    :param publisher: The publisher of the Azure Virtual Machines Marketplace
     image. For example, Canonical or MicrosoftWindowsServer.
    :type publisher: str
    :param offer: The offer type of the Azure Virtual Machines Marketplace
     image. For example, UbuntuServer or WindowsServer.
    :type offer: str
    :param sku: The SKU of the Azure Virtual Machines Marketplace image. For
     example, 14.04.0-LTS or 2012-R2-Datacenter.
    :type sku: str
    :param version: The version of the Azure Virtual Machines Marketplace
     image. A value of 'latest' can be specified to select the latest version
     of an image. If omitted, the default is 'latest'.
    :type version: str
    :param id: The ARM resource identifier of the virtual machine image.
     Computes nodes of the pool will be created using this custom image. This
     is of the form
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}.
     This property is mutually exclusive with other properties. The virtual
     machine image must be in the same region and subscription as the Azure
     Batch account. For information about the firewall settings for Batch node
     agent to communicate with Batch service see
     https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
     .
    :type id: str
    """

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, publisher=None, offer=None, sku=None, version=None, id=None):
        super(ImageReference, self).__init__()
        self.publisher = publisher
        self.offer = offer
        self.sku = sku
        self.version = version
        self.id = id


class InboundNatPool(Model):
    """A inbound NAT pool that can be used to address specific ports on compute
    nodes in a Batch pool externally.

    :param name: The name of the endpoint. The name must be unique within a
     Batch pool, can contain letters, numbers, underscores, periods, and
     hyphens. Names must start with a letter or number, must end with a letter,
     number, or underscore, and cannot exceed 77 characters.  If any invalid
     values are provided the request fails with HTTP status code 400.
    :type name: str
    :param protocol: The protocol of the endpoint. Possible values include:
     'TCP', 'UDP'
    :type protocol: str or ~azure.mgmt.batch.models.InboundEndpointProtocol
    :param backend_port: The port number on the compute node. This must be
     unique within a Batch pool. Acceptable values are between 1 and 65535
     except for 22, 3389, 29876 and 29877 as these are reserved. If any
     reserved values are provided the request fails with HTTP status code 400.
    :type backend_port: int
    :param frontend_port_range_start: The first port number in the range of
     external ports that will be used to provide inbound access to the
     backendPort on individual compute nodes. Acceptable values range between 1
     and 65534 except ports from 50000 to 55000 which are reserved. All ranges
     within a pool must be distinct and cannot overlap. If any reserved or
     overlapping values are provided the request fails with HTTP status code
     400.
    :type frontend_port_range_start: int
    :param frontend_port_range_end: The last port number in the range of
     external ports that will be used to provide inbound access to the
     backendPort on individual compute nodes. Acceptable values range between 1
     and 65534 except ports from 50000 to 55000 which are reserved by the Batch
     service. All ranges within a pool must be distinct and cannot overlap. If
     any reserved or overlapping values are provided the request fails with
     HTTP status code 400.
    :type frontend_port_range_end: int
    :param network_security_group_rules: A list of network security group
     rules that will be applied to the endpoint. The maximum number of rules
     that can be specified across all the endpoints on a Batch pool is 25. If
     no network security group rules are specified, a default rule will be
     created to allow inbound access to the specified backendPort. If the
     maximum number of network security group rules is exceeded the request
     fails with HTTP status code 400.
    :type network_security_group_rules:
     list[~azure.mgmt.batch.models.NetworkSecurityGroupRule]
    """

    _validation = {
        'name': {'required': True},
        'protocol': {'required': True},
        'backend_port': {'required': True},
        'frontend_port_range_start': {'required': True},
        'frontend_port_range_end': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'InboundEndpointProtocol'},
        'backend_port': {'key': 'backendPort', 'type': 'int'},
        'frontend_port_range_start': {'key': 'frontendPortRangeStart', 'type': 'int'},
        'frontend_port_range_end': {'key': 'frontendPortRangeEnd', 'type': 'int'},
        'network_security_group_rules': {'key': 'networkSecurityGroupRules', 'type': '[NetworkSecurityGroupRule]'},
    }

    def __init__(self, name, protocol, backend_port, frontend_port_range_start, frontend_port_range_end, network_security_group_rules=None):
        super(InboundNatPool, self).__init__()
        self.name = name
        self.protocol = protocol
        self.backend_port = backend_port
        self.frontend_port_range_start = frontend_port_range_start
        self.frontend_port_range_end = frontend_port_range_end
        self.network_security_group_rules = network_security_group_rules


class KeyVaultReference(Model):
    """Identifies the Azure key vault associated with a Batch account.

    :param id: The resource ID of the Azure key vault associated with the
     Batch account.
    :type id: str
    :param url: The URL of the Azure key vault associated with the Batch
     account.
    :type url: str
    """

    _validation = {
        'id': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(self, id, url):
        super(KeyVaultReference, self).__init__()
        self.id = id
        self.url = url


class LinuxUserConfiguration(Model):
    """Properties used to create a user account on a Linux node.

    :param uid: The user ID of the user account. The uid and gid properties
     must be specified together or not at all. If not specified the underlying
     operating system picks the uid.
    :type uid: int
    :param gid: The group ID for the user account. The uid and gid properties
     must be specified together or not at all. If not specified the underlying
     operating system picks the gid.
    :type gid: int
    :param ssh_private_key: The SSH private key for the user account. The
     private key must not be password protected. The private key is used to
     automatically configure asymmetric-key based authentication for SSH
     between nodes in a Linux pool when the pool's enableInterNodeCommunication
     property is true (it is ignored if enableInterNodeCommunication is false).
     It does this by placing the key pair into the user's .ssh directory. If
     not specified, password-less SSH is not configured between nodes (no
     modification of the user's .ssh directory is done).
    :type ssh_private_key: str
    """

    _attribute_map = {
        'uid': {'key': 'uid', 'type': 'int'},
        'gid': {'key': 'gid', 'type': 'int'},
        'ssh_private_key': {'key': 'sshPrivateKey', 'type': 'str'},
    }

    def __init__(self, uid=None, gid=None, ssh_private_key=None):
        super(LinuxUserConfiguration, self).__init__()
        self.uid = uid
        self.gid = gid
        self.ssh_private_key = ssh_private_key


class MetadataItem(Model):
    """A name-value pair associated with a Batch service resource.

    The Batch service does not assign any meaning to this metadata; it is
    solely for the use of user code.

    :param name: The name of the metadata item.
    :type name: str
    :param value: The value of the metadata item.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, name, value):
        super(MetadataItem, self).__init__()
        self.name = name
        self.value = value


class NetworkConfiguration(Model):
    """The network configuration for a pool.

    :param subnet_id: The ARM resource identifier of the virtual network
     subnet which the compute nodes of the pool will join. This is of the form
     /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
     The virtual network must be in the same region and subscription as the
     Azure Batch account. The specified subnet should have enough free IP
     addresses to accommodate the number of nodes in the pool. If the subnet
     doesn't have enough free IP addresses, the pool will partially allocate
     compute nodes, and a resize error will occur. The 'MicrosoftAzureBatch'
     service principal must have the 'Classic Virtual Machine Contributor'
     Role-Based Access Control (RBAC) role for the specified VNet. The
     specified subnet must allow communication from the Azure Batch service to
     be able to schedule tasks on the compute nodes. This can be verified by
     checking if the specified VNet has any associated Network Security Groups
     (NSG). If communication to the compute nodes in the specified subnet is
     denied by an NSG, then the Batch service will set the state of the compute
     nodes to unusable. For pools created via virtualMachineConfiguration the
     Batch account must have poolAllocationMode userSubscription in order to
     use a VNet. If the specified VNet has any associated Network Security
     Groups (NSG), then a few reserved system ports must be enabled for inbound
     communication. For pools created with a virtual machine configuration,
     enable ports 29876 and 29877, as well as port 22 for Linux and port 3389
     for Windows. For pools created with a cloud service configuration, enable
     ports 10100, 20100, and 30100. Also enable outbound connections to Azure
     Storage on port 443. For more details see:
     https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
    :type subnet_id: str
    :param endpoint_configuration: The configuration for endpoints on compute
     nodes in the Batch pool. Pool endpoint configuration is only supported on
     pools with the virtualMachineConfiguration property.
    :type endpoint_configuration:
     ~azure.mgmt.batch.models.PoolEndpointConfiguration
    """

    _attribute_map = {
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'endpoint_configuration': {'key': 'endpointConfiguration', 'type': 'PoolEndpointConfiguration'},
    }

    def __init__(self, subnet_id=None, endpoint_configuration=None):
        super(NetworkConfiguration, self).__init__()
        self.subnet_id = subnet_id
        self.endpoint_configuration = endpoint_configuration


class NetworkSecurityGroupRule(Model):
    """A network security group rule to apply to an inbound endpoint.

    :param priority: The priority for this rule. Priorities within a pool must
     be unique and are evaluated in order of priority. The lower the number the
     higher the priority. For example, rules could be specified with order
     numbers of 150, 250, and 350. The rule with the order number of 150 takes
     precedence over the rule that has an order of 250. Allowed priorities are
     150 to 3500. If any reserved or duplicate values are provided the request
     fails with HTTP status code 400.
    :type priority: int
    :param access: The action that should be taken for a specified IP address,
     subnet range or tag. Possible values include: 'Allow', 'Deny'
    :type access: str or
     ~azure.mgmt.batch.models.NetworkSecurityGroupRuleAccess
    :param source_address_prefix: The source address prefix or tag to match
     for the rule. Valid values are a single IP address (i.e. 10.10.10.10), IP
     subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If
     any other values are provided the request fails with HTTP status code 400.
    :type source_address_prefix: str
    """

    _validation = {
        'priority': {'required': True},
        'access': {'required': True},
        'source_address_prefix': {'required': True},
    }

    _attribute_map = {
        'priority': {'key': 'priority', 'type': 'int'},
        'access': {'key': 'access', 'type': 'NetworkSecurityGroupRuleAccess'},
        'source_address_prefix': {'key': 'sourceAddressPrefix', 'type': 'str'},
    }

    def __init__(self, priority, access, source_address_prefix):
        super(NetworkSecurityGroupRule, self).__init__()
        self.priority = priority
        self.access = access
        self.source_address_prefix = source_address_prefix


class Operation(Model):
    """A REST API operation.

    :param name: The operation name. This is of the format
     {provider}/{resource}/{operation}
    :type name: str
    :param display: The object that describes the operation.
    :type display: ~azure.mgmt.batch.models.OperationDisplay
    :param origin: The intended executor of the operation.
    :type origin: str
    :param properties: Properties of the operation.
    :type properties: object
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(self, name=None, display=None, origin=None, properties=None):
        super(Operation, self).__init__()
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationDisplay(Model):
    """The object that describes the operation.

    :param provider: Friendly name of the resource provider.
    :type provider: str
    :param operation: The operation type. For example: read, write, delete, or
     listKeys/action
    :type operation: str
    :param resource: The resource type on which the operation is performed.
    :type resource: str
    :param description: The friendly name of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, provider=None, operation=None, resource=None, description=None):
        super(OperationDisplay, self).__init__()
        self.provider = provider
        self.operation = operation
        self.resource = resource
        self.description = description


class PoolEndpointConfiguration(Model):
    """The endpoint configuration for a pool.

    :param inbound_nat_pools: A list of inbound NAT pools that can be used to
     address specific ports on an individual compute node externally. The
     maximum number of inbound NAT pools per Batch pool is 5. If the maximum
     number of inbound NAT pools is exceeded the request fails with HTTP status
     code 400.
    :type inbound_nat_pools: list[~azure.mgmt.batch.models.InboundNatPool]
    """

    _validation = {
        'inbound_nat_pools': {'required': True},
    }

    _attribute_map = {
        'inbound_nat_pools': {'key': 'inboundNatPools', 'type': '[InboundNatPool]'},
    }

    def __init__(self, inbound_nat_pools):
        super(PoolEndpointConfiguration, self).__init__()
        self.inbound_nat_pools = inbound_nat_pools


class ProxyResource(Model):
    """A definition of an Azure resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self):
        super(ProxyResource, self).__init__()
        self.id = None
        self.name = None
        self.type = None
        self.etag = None


class ResizeError(Model):
    """An error that occurred when resizing a pool.

    :param code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable
     for display in a user interface.
    :type message: str
    :param details: Additional details about the error.
    :type details: list[~azure.mgmt.batch.models.ResizeError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ResizeError]'},
    }

    def __init__(self, code, message, details=None):
        super(ResizeError, self).__init__()
        self.code = code
        self.message = message
        self.details = details


class ResizeOperationStatus(Model):
    """Details about the current or last completed resize operation.

    Describes either the current operation (if the pool AllocationState is
    Resizing) or the previously completed operation (if the AllocationState is
    Steady).

    :param target_dedicated_nodes: The desired number of dedicated compute
     nodes in the pool.
    :type target_dedicated_nodes: int
    :param target_low_priority_nodes: The desired number of low-priority
     compute nodes in the pool.
    :type target_low_priority_nodes: int
    :param resize_timeout: The timeout for allocation of compute nodes to the
     pool or removal of compute nodes from the pool. The default value is 15
     minutes. The minimum value is 5 minutes. If you specify a value less than
     5 minutes, the Batch service returns an error; if you are calling the REST
     API directly, the HTTP status code is 400 (Bad Request).
    :type resize_timeout: timedelta
    :param node_deallocation_option: Determines what to do with a node and its
     running task(s) if the pool size is decreasing. The default value is
     requeue. Possible values include: 'Requeue', 'Terminate',
     'TaskCompletion', 'RetainedData'
    :type node_deallocation_option: str or
     ~azure.mgmt.batch.models.ComputeNodeDeallocationOption
    :param start_time: The time when this resize operation was started.
    :type start_time: datetime
    :param errors: Details of any errors encountered while performing the last
     resize on the pool. This property is set only if an error occurred during
     the last pool resize, and only when the pool allocationState is Steady.
    :type errors: list[~azure.mgmt.batch.models.ResizeError]
    """

    _attribute_map = {
        'target_dedicated_nodes': {'key': 'targetDedicatedNodes', 'type': 'int'},
        'target_low_priority_nodes': {'key': 'targetLowPriorityNodes', 'type': 'int'},
        'resize_timeout': {'key': 'resizeTimeout', 'type': 'duration'},
        'node_deallocation_option': {'key': 'nodeDeallocationOption', 'type': 'ComputeNodeDeallocationOption'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'errors': {'key': 'errors', 'type': '[ResizeError]'},
    }

    def __init__(self, target_dedicated_nodes=None, target_low_priority_nodes=None, resize_timeout=None, node_deallocation_option=None, start_time=None, errors=None):
        super(ResizeOperationStatus, self).__init__()
        self.target_dedicated_nodes = target_dedicated_nodes
        self.target_low_priority_nodes = target_low_priority_nodes
        self.resize_timeout = resize_timeout
        self.node_deallocation_option = node_deallocation_option
        self.start_time = start_time
        self.errors = errors


class Resource(Model):
    """A definition of an Azure resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self):
        super(Resource, self).__init__()
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.tags = None


class ResourceFile(Model):
    """A single file or multiple files to be downloaded to a compute node.

    :param auto_storage_container_name: The storage container name in the auto
     storage account. The autoStorageContainerName, storageContainerUrl and
     httpUrl properties are mutually exclusive and one of them must be
     specified.
    :type auto_storage_container_name: str
    :param storage_container_url: The URL of the blob container within Azure
     Blob Storage. The autoStorageContainerName, storageContainerUrl and
     httpUrl properties are mutually exclusive and one of them must be
     specified. This URL must be readable and listable using anonymous access;
     that is, the Batch service does not present any credentials when
     downloading blobs from the container. There are two ways to get such a URL
     for a container in Azure storage: include a Shared Access Signature (SAS)
     granting read and list permissions on the container, or set the ACL for
     the container to allow public access.
    :type storage_container_url: str
    :param http_url: The URL of the file to download. The
     autoStorageContainerName, storageContainerUrl and httpUrl properties are
     mutually exclusive and one of them must be specified. If the URL is Azure
     Blob Storage, it must be readable using anonymous access; that is, the
     Batch service does not present any credentials when downloading the blob.
     There are two ways to get such a URL for a blob in Azure storage: include
     a Shared Access Signature (SAS) granting read permissions on the blob, or
     set the ACL for the blob or its container to allow public access.
    :type http_url: str
    :param blob_prefix: The blob prefix to use when downloading blobs from an
     Azure Storage container. Only the blobs whose names begin with the
     specified prefix will be downloaded. The property is valid only when
     autoStorageContainerName or storageContainerUrl is used. This prefix can
     be a partial filename or a subdirectory. If a prefix is not specified, all
     the files in the container will be downloaded.
    :type blob_prefix: str
    :param file_path: The location on the compute node to which to download
     the file, relative to the task's working directory. If the httpUrl
     property is specified, the filePath is required and describes the path
     which the file will be downloaded to, including the filename. Otherwise,
     if the autoStorageContainerName or storageContainerUrl property is
     specified, filePath is optional and is the directory to download the files
     to. In the case where filePath is used as a directory, any directory
     structure already associated with the input data will be retained in full
     and appended to the specified filePath directory. The specified relative
     path cannot break out of the task's working directory (for example by
     using '..').
    :type file_path: str
    :param file_mode: The file permission mode attribute in octal format. This
     property applies only to files being downloaded to Linux compute nodes. It
     will be ignored if it is specified for a resourceFile which will be
     downloaded to a Windows node. If this property is not specified for a
     Linux node, then a default value of 0770 is applied to the file.
    :type file_mode: str
    """

    _attribute_map = {
        'auto_storage_container_name': {'key': 'autoStorageContainerName', 'type': 'str'},
        'storage_container_url': {'key': 'storageContainerUrl', 'type': 'str'},
        'http_url': {'key': 'httpUrl', 'type': 'str'},
        'blob_prefix': {'key': 'blobPrefix', 'type': 'str'},
        'file_path': {'key': 'filePath', 'type': 'str'},
        'file_mode': {'key': 'fileMode', 'type': 'str'},
    }

    def __init__(self, auto_storage_container_name=None, storage_container_url=None, http_url=None, blob_prefix=None, file_path=None, file_mode=None):
        super(ResourceFile, self).__init__()
        self.auto_storage_container_name = auto_storage_container_name
        self.storage_container_url = storage_container_url
        self.http_url = http_url
        self.blob_prefix = blob_prefix
        self.file_path = file_path
        self.file_mode = file_mode


class ScaleSettings(Model):
    """Scale settings for the pool.

    Defines the desired size of the pool. This can either be 'fixedScale' where
    the requested targetDedicatedNodes is specified, or 'autoScale' which
    defines a formula which is periodically reevaluated. If this property is
    not specified, the pool will have a fixed scale with 0
    targetDedicatedNodes.

    :param fixed_scale: Fixed scale settings for the pool. This property and
     autoScale are mutually exclusive and one of the properties must be
     specified.
    :type fixed_scale: ~azure.mgmt.batch.models.FixedScaleSettings
    :param auto_scale: AutoScale settings for the pool. This property and
     fixedScale are mutually exclusive and one of the properties must be
     specified.
    :type auto_scale: ~azure.mgmt.batch.models.AutoScaleSettings
    """

    _attribute_map = {
        'fixed_scale': {'key': 'fixedScale', 'type': 'FixedScaleSettings'},
        'auto_scale': {'key': 'autoScale', 'type': 'AutoScaleSettings'},
    }

    def __init__(self, fixed_scale=None, auto_scale=None):
        super(ScaleSettings, self).__init__()
        self.fixed_scale = fixed_scale
        self.auto_scale = auto_scale


class StartTask(Model):
    """A task which is run when a compute node joins a pool in the Azure Batch
    service, or when the compute node is rebooted or reimaged.

    :param command_line: The command line of the start task. The command line
     does not run under a shell, and therefore cannot take advantage of shell
     features such as environment variable expansion. If you want to take
     advantage of such features, you should invoke the shell in the command
     line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c
     MyCommand" in Linux. Required if any other properties of the startTask are
     specified.
    :type command_line: str
    :param resource_files: A list of files that the Batch service will
     download to the compute node before running the command line.
    :type resource_files: list[~azure.mgmt.batch.models.ResourceFile]
    :param environment_settings: A list of environment variable settings for
     the start task.
    :type environment_settings:
     list[~azure.mgmt.batch.models.EnvironmentSetting]
    :param user_identity: The user identity under which the start task runs.
     If omitted, the task runs as a non-administrative user unique to the task.
    :type user_identity: ~azure.mgmt.batch.models.UserIdentity
    :param max_task_retry_count: The maximum number of times the task may be
     retried. The Batch service retries a task if its exit code is nonzero.
     Note that this value specifically controls the number of retries. The
     Batch service will try the task once, and may then retry up to this limit.
     For example, if the maximum retry count is 3, Batch tries the task up to 4
     times (one initial try and 3 retries). If the maximum retry count is 0,
     the Batch service does not retry the task. If the maximum retry count is
     -1, the Batch service retries the task without limit.
    :type max_task_retry_count: int
    :param wait_for_success: Whether the Batch service should wait for the
     start task to complete successfully (that is, to exit with exit code 0)
     before scheduling any tasks on the compute node. If true and the start
     task fails on a compute node, the Batch service retries the start task up
     to its maximum retry count (maxTaskRetryCount). If the task has still not
     completed successfully after all retries, then the Batch service marks the
     compute node unusable, and will not schedule tasks to it. This condition
     can be detected via the node state and scheduling error detail. If false,
     the Batch service will not wait for the start task to complete. In this
     case, other tasks can start executing on the compute node while the start
     task is still running; and even if the start task fails, new tasks will
     continue to be scheduled on the node. The default is false.
    :type wait_for_success: bool
    :param container_settings: The settings for the container under which the
     start task runs. When this is specified, all directories recursively below
     the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the
     node) are mapped into the container, all task environment variables are
     mapped into the container, and the task command line is executed in the
     container.
    :type container_settings: ~azure.mgmt.batch.models.TaskContainerSettings
    """

    _attribute_map = {
        'command_line': {'key': 'commandLine', 'type': 'str'},
        'resource_files': {'key': 'resourceFiles', 'type': '[ResourceFile]'},
        'environment_settings': {'key': 'environmentSettings', 'type': '[EnvironmentSetting]'},
        'user_identity': {'key': 'userIdentity', 'type': 'UserIdentity'},
        'max_task_retry_count': {'key': 'maxTaskRetryCount', 'type': 'int'},
        'wait_for_success': {'key': 'waitForSuccess', 'type': 'bool'},
        'container_settings': {'key': 'containerSettings', 'type': 'TaskContainerSettings'},
    }

    def __init__(self, command_line=None, resource_files=None, environment_settings=None, user_identity=None, max_task_retry_count=None, wait_for_success=None, container_settings=None):
        super(StartTask, self).__init__()
        self.command_line = command_line
        self.resource_files = resource_files
        self.environment_settings = environment_settings
        self.user_identity = user_identity
        self.max_task_retry_count = max_task_retry_count
        self.wait_for_success = wait_for_success
        self.container_settings = container_settings


class TaskContainerSettings(Model):
    """The container settings for a task.

    :param container_run_options: Additional options to the container create
     command. These additional options are supplied as arguments to the "docker
     create" command, in addition to those controlled by the Batch Service.
    :type container_run_options: str
    :param image_name: The image to use to create the container in which the
     task will run. This is the full image reference, as would be specified to
     "docker pull". If no tag is provided as part of the image name, the tag
     ":latest" is used as a default.
    :type image_name: str
    :param registry: The private registry which contains the container image.
     This setting can be omitted if was already provided at pool creation.
    :type registry: ~azure.mgmt.batch.models.ContainerRegistry
    """

    _validation = {
        'image_name': {'required': True},
    }

    _attribute_map = {
        'container_run_options': {'key': 'containerRunOptions', 'type': 'str'},
        'image_name': {'key': 'imageName', 'type': 'str'},
        'registry': {'key': 'registry', 'type': 'ContainerRegistry'},
    }

    def __init__(self, image_name, container_run_options=None, registry=None):
        super(TaskContainerSettings, self).__init__()
        self.container_run_options = container_run_options
        self.image_name = image_name
        self.registry = registry


class TaskSchedulingPolicy(Model):
    """Specifies how tasks should be distributed across compute nodes.

    :param node_fill_type: How tasks should be distributed across compute
     nodes. Possible values include: 'Spread', 'Pack'
    :type node_fill_type: str or ~azure.mgmt.batch.models.ComputeNodeFillType
    """

    _validation = {
        'node_fill_type': {'required': True},
    }

    _attribute_map = {
        'node_fill_type': {'key': 'nodeFillType', 'type': 'ComputeNodeFillType'},
    }

    def __init__(self, node_fill_type):
        super(TaskSchedulingPolicy, self).__init__()
        self.node_fill_type = node_fill_type


class UserAccount(Model):
    """Properties used to create a user on an Azure Batch node.

    :param name: The name of the user account.
    :type name: str
    :param password: The password for the user account.
    :type password: str
    :param elevation_level: The elevation level of the user account. nonAdmin
     - The auto user is a standard user without elevated access. admin - The
     auto user is a user with elevated access and operates with full
     Administrator permissions. The default value is nonAdmin. Possible values
     include: 'NonAdmin', 'Admin'
    :type elevation_level: str or ~azure.mgmt.batch.models.ElevationLevel
    :param linux_user_configuration: The Linux-specific user configuration for
     the user account. This property is ignored if specified on a Windows pool.
     If not specified, the user is created with the default options.
    :type linux_user_configuration:
     ~azure.mgmt.batch.models.LinuxUserConfiguration
    :param windows_user_configuration: The Windows-specific user configuration
     for the user account. This property can only be specified if the user is
     on a Windows pool. If not specified and on a Windows pool, the user is
     created with the default options.
    :type windows_user_configuration:
     ~azure.mgmt.batch.models.WindowsUserConfiguration
    """

    _validation = {
        'name': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'elevation_level': {'key': 'elevationLevel', 'type': 'ElevationLevel'},
        'linux_user_configuration': {'key': 'linuxUserConfiguration', 'type': 'LinuxUserConfiguration'},
        'windows_user_configuration': {'key': 'windowsUserConfiguration', 'type': 'WindowsUserConfiguration'},
    }

    def __init__(self, name, password, elevation_level=None, linux_user_configuration=None, windows_user_configuration=None):
        super(UserAccount, self).__init__()
        self.name = name
        self.password = password
        self.elevation_level = elevation_level
        self.linux_user_configuration = linux_user_configuration
        self.windows_user_configuration = windows_user_configuration


class UserIdentity(Model):
    """The definition of the user identity under which the task is run.

    Specify either the userName or autoUser property, but not both.

    :param user_name: The name of the user identity under which the task is
     run. The userName and autoUser properties are mutually exclusive; you must
     specify one but not both.
    :type user_name: str
    :param auto_user: The auto user under which the task is run. The userName
     and autoUser properties are mutually exclusive; you must specify one but
     not both.
    :type auto_user: ~azure.mgmt.batch.models.AutoUserSpecification
    """

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'str'},
        'auto_user': {'key': 'autoUser', 'type': 'AutoUserSpecification'},
    }

    def __init__(self, user_name=None, auto_user=None):
        super(UserIdentity, self).__init__()
        self.user_name = user_name
        self.auto_user = auto_user


class VirtualMachineConfiguration(Model):
    """The configuration for compute nodes in a pool based on the Azure Virtual
    Machines infrastructure.

    :param image_reference: A reference to the Azure Virtual Machines
     Marketplace Image or the custom Virtual Machine Image to use.
    :type image_reference: ~azure.mgmt.batch.models.ImageReference
    :param node_agent_sku_id: The SKU of the Batch node agent to be
     provisioned on compute nodes in the pool. The Batch node agent is a
     program that runs on each node in the pool, and provides the
     command-and-control interface between the node and the Batch service.
     There are different implementations of the node agent, known as SKUs, for
     different operating systems. You must specify a node agent SKU which
     matches the selected image reference. To get the list of supported node
     agent SKUs along with their list of verified image references, see the
     'List supported node agent SKUs' operation.
    :type node_agent_sku_id: str
    :param windows_configuration: Windows operating system settings on the
     virtual machine. This property must not be specified if the imageReference
     specifies a Linux OS image.
    :type windows_configuration: ~azure.mgmt.batch.models.WindowsConfiguration
    :param data_disks: The configuration for data disks attached to the
     compute nodes in the pool. This property must be specified if the compute
     nodes in the pool need to have empty data disks attached to them.
    :type data_disks: list[~azure.mgmt.batch.models.DataDisk]
    :param license_type: The type of on-premises license to be used when
     deploying the operating system. This only applies to images that contain
     the Windows operating system, and should only be used when you hold valid
     on-premises licenses for the nodes which will be deployed. If omitted, no
     on-premises licensing discount is applied. Values are:
     Windows_Server - The on-premises license is for Windows Server.
     Windows_Client - The on-premises license is for Windows Client.
    :type license_type: str
    :param container_configuration: The container configuration for the pool.
     If specified, setup is performed on each node in the pool to allow tasks
     to run in containers. All regular tasks and job manager tasks run on this
     pool must specify the containerSettings property, and all other tasks may
     specify it.
    :type container_configuration:
     ~azure.mgmt.batch.models.ContainerConfiguration
    """

    _validation = {
        'image_reference': {'required': True},
        'node_agent_sku_id': {'required': True},
    }

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'node_agent_sku_id': {'key': 'nodeAgentSkuId', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
        'data_disks': {'key': 'dataDisks', 'type': '[DataDisk]'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'container_configuration': {'key': 'containerConfiguration', 'type': 'ContainerConfiguration'},
    }

    def __init__(self, image_reference, node_agent_sku_id, windows_configuration=None, data_disks=None, license_type=None, container_configuration=None):
        super(VirtualMachineConfiguration, self).__init__()
        self.image_reference = image_reference
        self.node_agent_sku_id = node_agent_sku_id
        self.windows_configuration = windows_configuration
        self.data_disks = data_disks
        self.license_type = license_type
        self.container_configuration = container_configuration


class WindowsConfiguration(Model):
    """Windows operating system settings to apply to the virtual machine.

    :param enable_automatic_updates: Whether automatic updates are enabled on
     the virtual machine. If omitted, the default value is true.
    :type enable_automatic_updates: bool
    """

    _attribute_map = {
        'enable_automatic_updates': {'key': 'enableAutomaticUpdates', 'type': 'bool'},
    }

    def __init__(self, enable_automatic_updates=None):
        super(WindowsConfiguration, self).__init__()
        self.enable_automatic_updates = enable_automatic_updates


class WindowsUserConfiguration(Model):
    """Properties used to create a user account on a Windows node.

    :param login_mode: Login mode for user. Specifies login mode for the user.
     The default value for VirtualMachineConfiguration pools is interactive
     mode and for CloudServiceConfiguration pools is batch mode. Possible
     values include: 'Batch', 'Interactive'
    :type login_mode: str or ~azure.mgmt.batch.models.LoginMode
    """

    _attribute_map = {
        'login_mode': {'key': 'loginMode', 'type': 'LoginMode'},
    }

    def __init__(self, login_mode=None):
        super(WindowsUserConfiguration, self).__init__()
        self.login_mode = login_mode


class Application(ProxyResource):
    """Contains information about an application in a Batch account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :param display_name: The display name for the application.
    :type display_name: str
    :param allow_updates: A value indicating whether packages within the
     application may be overwritten using the same version string.
    :type allow_updates: bool
    :param default_version: The package to use if a client requests the
     application but does not specify a version. This property can only be set
     to the name of an existing package.
    :type default_version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'allow_updates': {'key': 'properties.allowUpdates', 'type': 'bool'},
        'default_version': {'key': 'properties.defaultVersion', 'type': 'str'},
    }

    def __init__(self, display_name=None, allow_updates=None, default_version=None):
        super(Application, self).__init__()
        self.display_name = display_name
        self.allow_updates = allow_updates
        self.default_version = default_version


class ApplicationPackage(ProxyResource):
    """An application package which represents a particular version of an
    application.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar state: The current state of the application package. Possible values
     include: 'Pending', 'Active'
    :vartype state: str or ~azure.mgmt.batch.models.PackageState
    :ivar format: The format of the application package, if the package is
     active.
    :vartype format: str
    :ivar storage_url: The URL for the application package in Azure Storage.
    :vartype storage_url: str
    :ivar storage_url_expiry: The UTC time at which the Azure Storage URL will
     expire.
    :vartype storage_url_expiry: datetime
    :ivar last_activation_time: The time at which the package was last
     activated, if the package is active.
    :vartype last_activation_time: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'state': {'readonly': True},
        'format': {'readonly': True},
        'storage_url': {'readonly': True},
        'storage_url_expiry': {'readonly': True},
        'last_activation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'PackageState'},
        'format': {'key': 'properties.format', 'type': 'str'},
        'storage_url': {'key': 'properties.storageUrl', 'type': 'str'},
        'storage_url_expiry': {'key': 'properties.storageUrlExpiry', 'type': 'iso-8601'},
        'last_activation_time': {'key': 'properties.lastActivationTime', 'type': 'iso-8601'},
    }

    def __init__(self):
        super(ApplicationPackage, self).__init__()
        self.state = None
        self.format = None
        self.storage_url = None
        self.storage_url_expiry = None
        self.last_activation_time = None


class AutoStorageProperties(AutoStorageBaseProperties):
    """Contains information about the auto-storage account associated with a Batch
    account.

    :param storage_account_id: The resource ID of the storage account to be
     used for auto-storage account.
    :type storage_account_id: str
    :param last_key_sync: The UTC time at which storage keys were last
     synchronized with the Batch account.
    :type last_key_sync: datetime
    """

    _validation = {
        'storage_account_id': {'required': True},
        'last_key_sync': {'required': True},
    }

    _attribute_map = {
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
        'last_key_sync': {'key': 'lastKeySync', 'type': 'iso-8601'},
    }

    def __init__(self, storage_account_id, last_key_sync):
        super(AutoStorageProperties, self).__init__(storage_account_id=storage_account_id)
        self.last_key_sync = last_key_sync


class BatchAccount(Resource):
    """Contains information about an Azure Batch account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar account_endpoint: The account endpoint used to interact with the
     Batch service.
    :vartype account_endpoint: str
    :ivar provisioning_state: The provisioned state of the resource. Possible
     values include: 'Invalid', 'Creating', 'Deleting', 'Succeeded', 'Failed',
     'Cancelled'
    :vartype provisioning_state: str or
     ~azure.mgmt.batch.models.ProvisioningState
    :ivar pool_allocation_mode: The allocation mode to use for creating pools
     in the Batch account. Possible values include: 'BatchService',
     'UserSubscription'
    :vartype pool_allocation_mode: str or
     ~azure.mgmt.batch.models.PoolAllocationMode
    :ivar key_vault_reference: A reference to the Azure key vault associated
     with the Batch account.
    :vartype key_vault_reference: ~azure.mgmt.batch.models.KeyVaultReference
    :ivar auto_storage: The properties and status of any auto-storage account
     associated with the Batch account.
    :vartype auto_storage: ~azure.mgmt.batch.models.AutoStorageProperties
    :ivar dedicated_core_quota: The dedicated core quota for this Batch
     account.
    :vartype dedicated_core_quota: int
    :ivar low_priority_core_quota: The low-priority core quota for this Batch
     account.
    :vartype low_priority_core_quota: int
    :ivar pool_quota: The pool quota for this Batch account.
    :vartype pool_quota: int
    :ivar active_job_and_job_schedule_quota: The active job and job schedule
     quota for this Batch account.
    :vartype active_job_and_job_schedule_quota: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
        'account_endpoint': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'pool_allocation_mode': {'readonly': True},
        'key_vault_reference': {'readonly': True},
        'auto_storage': {'readonly': True},
        'dedicated_core_quota': {'readonly': True},
        'low_priority_core_quota': {'readonly': True},
        'pool_quota': {'readonly': True},
        'active_job_and_job_schedule_quota': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'account_endpoint': {'key': 'properties.accountEndpoint', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'ProvisioningState'},
        'pool_allocation_mode': {'key': 'properties.poolAllocationMode', 'type': 'PoolAllocationMode'},
        'key_vault_reference': {'key': 'properties.keyVaultReference', 'type': 'KeyVaultReference'},
        'auto_storage': {'key': 'properties.autoStorage', 'type': 'AutoStorageProperties'},
        'dedicated_core_quota': {'key': 'properties.dedicatedCoreQuota', 'type': 'int'},
        'low_priority_core_quota': {'key': 'properties.lowPriorityCoreQuota', 'type': 'int'},
        'pool_quota': {'key': 'properties.poolQuota', 'type': 'int'},
        'active_job_and_job_schedule_quota': {'key': 'properties.activeJobAndJobScheduleQuota', 'type': 'int'},
    }

    def __init__(self):
        super(BatchAccount, self).__init__()
        self.account_endpoint = None
        self.provisioning_state = None
        self.pool_allocation_mode = None
        self.key_vault_reference = None
        self.auto_storage = None
        self.dedicated_core_quota = None
        self.low_priority_core_quota = None
        self.pool_quota = None
        self.active_job_and_job_schedule_quota = None


class Certificate(ProxyResource):
    """Contains information about a certificate.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :param thumbprint_algorithm: The algorithm of the certificate thumbprint.
     This must match the first portion of the certificate name. Currently
     required to be 'SHA1'.
    :type thumbprint_algorithm: str
    :param thumbprint: The thumbprint of the certificate. This must match the
     thumbprint from the name.
    :type thumbprint: str
    :param format: The format of the certificate - either Pfx or Cer. If
     omitted, the default is Pfx. Possible values include: 'Pfx', 'Cer'
    :type format: str or ~azure.mgmt.batch.models.CertificateFormat
    :ivar provisioning_state: The provisioned state of the resource. Possible
     values include: 'Succeeded', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.batch.models.CertificateProvisioningState
    :ivar provisioning_state_transition_time: The time at which the
     certificate entered its current state.
    :vartype provisioning_state_transition_time: datetime
    :ivar previous_provisioning_state: The previous provisioned state of the
     resource. Possible values include: 'Succeeded', 'Deleting', 'Failed'
    :vartype previous_provisioning_state: str or
     ~azure.mgmt.batch.models.CertificateProvisioningState
    :ivar previous_provisioning_state_transition_time: The time at which the
     certificate entered its previous state.
    :vartype previous_provisioning_state_transition_time: datetime
    :ivar public_data: The public key of the certificate.
    :vartype public_data: str
    :ivar delete_certificate_error: The error which occurred while deleting
     the certificate. This is only returned when the certificate
     provisioningState is 'Failed'.
    :vartype delete_certificate_error:
     ~azure.mgmt.batch.models.DeleteCertificateError
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'provisioning_state_transition_time': {'readonly': True},
        'previous_provisioning_state': {'readonly': True},
        'previous_provisioning_state_transition_time': {'readonly': True},
        'public_data': {'readonly': True},
        'delete_certificate_error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'thumbprint_algorithm': {'key': 'properties.thumbprintAlgorithm', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'format': {'key': 'properties.format', 'type': 'CertificateFormat'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'CertificateProvisioningState'},
        'provisioning_state_transition_time': {'key': 'properties.provisioningStateTransitionTime', 'type': 'iso-8601'},
        'previous_provisioning_state': {'key': 'properties.previousProvisioningState', 'type': 'CertificateProvisioningState'},
        'previous_provisioning_state_transition_time': {'key': 'properties.previousProvisioningStateTransitionTime', 'type': 'iso-8601'},
        'public_data': {'key': 'properties.publicData', 'type': 'str'},
        'delete_certificate_error': {'key': 'properties.deleteCertificateError', 'type': 'DeleteCertificateError'},
    }

    def __init__(self, thumbprint_algorithm=None, thumbprint=None, format=None):
        super(Certificate, self).__init__()
        self.thumbprint_algorithm = thumbprint_algorithm
        self.thumbprint = thumbprint
        self.format = format
        self.provisioning_state = None
        self.provisioning_state_transition_time = None
        self.previous_provisioning_state = None
        self.previous_provisioning_state_transition_time = None
        self.public_data = None
        self.delete_certificate_error = None


class CertificateCreateOrUpdateParameters(ProxyResource):
    """Contains information about a certificate.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :param thumbprint_algorithm: The algorithm of the certificate thumbprint.
     This must match the first portion of the certificate name. Currently
     required to be 'SHA1'.
    :type thumbprint_algorithm: str
    :param thumbprint: The thumbprint of the certificate. This must match the
     thumbprint from the name.
    :type thumbprint: str
    :param format: The format of the certificate - either Pfx or Cer. If
     omitted, the default is Pfx. Possible values include: 'Pfx', 'Cer'
    :type format: str or ~azure.mgmt.batch.models.CertificateFormat
    :param data: The base64-encoded contents of the certificate. The maximum
     size is 10KB.
    :type data: str
    :param password: The password to access the certificate's private key.
     This is required if the certificate format is pfx and must be omitted if
     the certificate format is cer.
    :type password: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'data': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'thumbprint_algorithm': {'key': 'properties.thumbprintAlgorithm', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'format': {'key': 'properties.format', 'type': 'CertificateFormat'},
        'data': {'key': 'properties.data', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
    }

    def __init__(self, data, thumbprint_algorithm=None, thumbprint=None, format=None, password=None):
        super(CertificateCreateOrUpdateParameters, self).__init__()
        self.thumbprint_algorithm = thumbprint_algorithm
        self.thumbprint = thumbprint
        self.format = format
        self.data = data
        self.password = password


class Pool(ProxyResource):
    """Contains information about a pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :param display_name: The display name for the pool. The display name need
     not be unique and can contain any Unicode characters up to a maximum
     length of 1024.
    :type display_name: str
    :ivar last_modified: The last modified time of the pool. This is the last
     time at which the pool level data, such as the targetDedicatedNodes or
     autoScaleSettings, changed. It does not factor in node-level changes such
     as a compute node changing state.
    :vartype last_modified: datetime
    :ivar creation_time: The creation time of the pool.
    :vartype creation_time: datetime
    :ivar provisioning_state: The current state of the pool. Possible values
     include: 'Succeeded', 'Deleting'
    :vartype provisioning_state: str or
     ~azure.mgmt.batch.models.PoolProvisioningState
    :ivar provisioning_state_transition_time: The time at which the pool
     entered its current state.
    :vartype provisioning_state_transition_time: datetime
    :ivar allocation_state: Whether the pool is resizing. Possible values
     include: 'Steady', 'Resizing', 'Stopping'
    :vartype allocation_state: str or ~azure.mgmt.batch.models.AllocationState
    :ivar allocation_state_transition_time: The time at which the pool entered
     its current allocation state.
    :vartype allocation_state_transition_time: datetime
    :param vm_size: The size of virtual machines in the pool. All VMs in a
     pool are the same size. For information about available sizes of virtual
     machines for Cloud Services pools (pools created with
     cloudServiceConfiguration), see Sizes for Cloud Services
     (http://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/).
     Batch supports all Cloud Services VM sizes except ExtraSmall. For
     information about available VM sizes for pools using images from the
     Virtual Machines Marketplace (pools created with
     virtualMachineConfiguration) see Sizes for Virtual Machines (Linux)
     (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/)
     or Sizes for Virtual Machines (Windows)
     (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/).
     Batch supports all Azure VM sizes except STANDARD_A0 and those with
     premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
    :type vm_size: str
    :param deployment_configuration: This property describes how the pool
     nodes will be deployed - using Cloud Services or Virtual Machines. Using
     CloudServiceConfiguration specifies that the nodes should be creating
     using Azure Cloud Services (PaaS), while VirtualMachineConfiguration uses
     Azure Virtual Machines (IaaS).
    :type deployment_configuration:
     ~azure.mgmt.batch.models.DeploymentConfiguration
    :ivar current_dedicated_nodes: The number of compute nodes currently in
     the pool.
    :vartype current_dedicated_nodes: int
    :ivar current_low_priority_nodes: The number of low priority compute nodes
     currently in the pool.
    :vartype current_low_priority_nodes: int
    :param scale_settings: Settings which configure the number of nodes in the
     pool.
    :type scale_settings: ~azure.mgmt.batch.models.ScaleSettings
    :ivar auto_scale_run: The results and errors from the last execution of
     the autoscale formula. This property is set only if the pool automatically
     scales, i.e. autoScaleSettings are used.
    :vartype auto_scale_run: ~azure.mgmt.batch.models.AutoScaleRun
    :param inter_node_communication: Whether the pool permits direct
     communication between nodes. This imposes restrictions on which nodes can
     be assigned to the pool. Enabling this value can reduce the chance of the
     requested number of nodes to be allocated in the pool. If not specified,
     this value defaults to 'Disabled'. Possible values include: 'Enabled',
     'Disabled'
    :type inter_node_communication: str or
     ~azure.mgmt.batch.models.InterNodeCommunicationState
    :param network_configuration: The network configuration for the pool.
    :type network_configuration: ~azure.mgmt.batch.models.NetworkConfiguration
    :param max_tasks_per_node: The maximum number of tasks that can run
     concurrently on a single compute node in the pool.
    :type max_tasks_per_node: int
    :param task_scheduling_policy: How tasks are distributed across compute
     nodes in a pool.
    :type task_scheduling_policy:
     ~azure.mgmt.batch.models.TaskSchedulingPolicy
    :param user_accounts: The list of user accounts to be created on each node
     in the pool.
    :type user_accounts: list[~azure.mgmt.batch.models.UserAccount]
    :param metadata: A list of name-value pairs associated with the pool as
     metadata. The Batch service does not assign any meaning to metadata; it is
     solely for the use of user code.
    :type metadata: list[~azure.mgmt.batch.models.MetadataItem]
    :param start_task: A task specified to run on each compute node as it
     joins the pool. In an PATCH (update) operation, this property can be set
     to an empty object to remove the start task from the pool.
    :type start_task: ~azure.mgmt.batch.models.StartTask
    :param certificates: The list of certificates to be installed on each
     compute node in the pool. For Windows compute nodes, the Batch service
     installs the certificates to the specified certificate store and location.
     For Linux compute nodes, the certificates are stored in a directory inside
     the task working directory and an environment variable
     AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this
     location. For certificates with visibility of 'remoteUser', a 'certs'
     directory is created in the user's home directory (e.g.,
     /home/{user-name}/certs) and certificates are placed in that directory.
    :type certificates: list[~azure.mgmt.batch.models.CertificateReference]
    :param application_packages: The list of application packages to be
     installed on each compute node in the pool. Changes to application
     packages affect all new compute nodes joining the pool, but do not affect
     compute nodes that are already in the pool until they are rebooted or
     reimaged.
    :type application_packages:
     list[~azure.mgmt.batch.models.ApplicationPackageReference]
    :param application_licenses: The list of application licenses the Batch
     service will make available on each compute node in the pool. The list of
     application licenses must be a subset of available Batch service
     application licenses. If a license is requested which is not supported,
     pool creation will fail.
    :type application_licenses: list[str]
    :ivar resize_operation_status: Contains details about the current or last
     completed resize operation.
    :vartype resize_operation_status:
     ~azure.mgmt.batch.models.ResizeOperationStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'last_modified': {'readonly': True},
        'creation_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'provisioning_state_transition_time': {'readonly': True},
        'allocation_state': {'readonly': True},
        'allocation_state_transition_time': {'readonly': True},
        'current_dedicated_nodes': {'readonly': True},
        'current_low_priority_nodes': {'readonly': True},
        'auto_scale_run': {'readonly': True},
        'resize_operation_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'last_modified': {'key': 'properties.lastModified', 'type': 'iso-8601'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'PoolProvisioningState'},
        'provisioning_state_transition_time': {'key': 'properties.provisioningStateTransitionTime', 'type': 'iso-8601'},
        'allocation_state': {'key': 'properties.allocationState', 'type': 'AllocationState'},
        'allocation_state_transition_time': {'key': 'properties.allocationStateTransitionTime', 'type': 'iso-8601'},
        'vm_size': {'key': 'properties.vmSize', 'type': 'str'},
        'deployment_configuration': {'key': 'properties.deploymentConfiguration', 'type': 'DeploymentConfiguration'},
        'current_dedicated_nodes': {'key': 'properties.currentDedicatedNodes', 'type': 'int'},
        'current_low_priority_nodes': {'key': 'properties.currentLowPriorityNodes', 'type': 'int'},
        'scale_settings': {'key': 'properties.scaleSettings', 'type': 'ScaleSettings'},
        'auto_scale_run': {'key': 'properties.autoScaleRun', 'type': 'AutoScaleRun'},
        'inter_node_communication': {'key': 'properties.interNodeCommunication', 'type': 'InterNodeCommunicationState'},
        'network_configuration': {'key': 'properties.networkConfiguration', 'type': 'NetworkConfiguration'},
        'max_tasks_per_node': {'key': 'properties.maxTasksPerNode', 'type': 'int'},
        'task_scheduling_policy': {'key': 'properties.taskSchedulingPolicy', 'type': 'TaskSchedulingPolicy'},
        'user_accounts': {'key': 'properties.userAccounts', 'type': '[UserAccount]'},
        'metadata': {'key': 'properties.metadata', 'type': '[MetadataItem]'},
        'start_task': {'key': 'properties.startTask', 'type': 'StartTask'},
        'certificates': {'key': 'properties.certificates', 'type': '[CertificateReference]'},
        'application_packages': {'key': 'properties.applicationPackages', 'type': '[ApplicationPackageReference]'},
        'application_licenses': {'key': 'properties.applicationLicenses', 'type': '[str]'},
        'resize_operation_status': {'key': 'properties.resizeOperationStatus', 'type': 'ResizeOperationStatus'},
    }

    def __init__(self, display_name=None, vm_size=None, deployment_configuration=None, scale_settings=None, inter_node_communication=None, network_configuration=None, max_tasks_per_node=None, task_scheduling_policy=None, user_accounts=None, metadata=None, start_task=None, certificates=None, application_packages=None, application_licenses=None):
        super(Pool, self).__init__()
        self.display_name = display_name
        self.last_modified = None
        self.creation_time = None
        self.provisioning_state = None
        self.provisioning_state_transition_time = None
        self.allocation_state = None
        self.allocation_state_transition_time = None
        self.vm_size = vm_size
        self.deployment_configuration = deployment_configuration
        self.current_dedicated_nodes = None
        self.current_low_priority_nodes = None
        self.scale_settings = scale_settings
        self.auto_scale_run = None
        self.inter_node_communication = inter_node_communication
        self.network_configuration = network_configuration
        self.max_tasks_per_node = max_tasks_per_node
        self.task_scheduling_policy = task_scheduling_policy
        self.user_accounts = user_accounts
        self.metadata = metadata
        self.start_task = start_task
        self.certificates = certificates
        self.application_packages = application_packages
        self.application_licenses = application_licenses
        self.resize_operation_status = None
