# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .auto_scaling_trigger_py3 import AutoScalingTrigger


class AverageLoadScalingTrigger(AutoScalingTrigger):
    """Describes the average load trigger used for auto scaling.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param metric: Required. Description of the metric that is used for
     scaling.
    :type metric: ~azure.servicefabric.models.AutoScalingMetric
    :param lower_load_threshold: Required. Lower load threshold (if average
     load is below this threshold, service will scale down).
    :type lower_load_threshold: float
    :param upper_load_threshold: Required. Upper load threshold (if average
     load is above this threshold, service will scale up).
    :type upper_load_threshold: float
    :param scale_interval_in_seconds: Required. Scale interval that indicates
     how often will this trigger be checked.
    :type scale_interval_in_seconds: int
    """

    _validation = {
        'kind': {'required': True},
        'metric': {'required': True},
        'lower_load_threshold': {'required': True},
        'upper_load_threshold': {'required': True},
        'scale_interval_in_seconds': {'required': True, 'minimum': 60},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'metric': {'key': 'metric', 'type': 'AutoScalingMetric'},
        'lower_load_threshold': {'key': 'lowerLoadThreshold', 'type': 'float'},
        'upper_load_threshold': {'key': 'upperLoadThreshold', 'type': 'float'},
        'scale_interval_in_seconds': {'key': 'scaleIntervalInSeconds', 'type': 'int'},
    }

    def __init__(self, *, metric, lower_load_threshold: float, upper_load_threshold: float, scale_interval_in_seconds: int, **kwargs) -> None:
        super(AverageLoadScalingTrigger, self).__init__(**kwargs)
        self.metric = metric
        self.lower_load_threshold = lower_load_threshold
        self.upper_load_threshold = upper_load_threshold
        self.scale_interval_in_seconds = scale_interval_in_seconds
        self.kind = 'AverageLoad'
