# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class HttpRouteConfig(Model):
    """Describes the hostname properties for http routing.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. http route name.
    :type name: str
    :param match: Required. Describes a rule for http route matching.
    :type match: ~azure.servicefabric.models.HttpRouteMatchRule
    :param destination: Required. Describes destination endpoint for routing
     traffic.
    :type destination: ~azure.servicefabric.models.GatewayDestination
    """

    _validation = {
        'name': {'required': True},
        'match': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'match': {'key': 'match', 'type': 'HttpRouteMatchRule'},
        'destination': {'key': 'destination', 'type': 'GatewayDestination'},
    }

    def __init__(self, *, name: str, match, destination, **kwargs) -> None:
        super(HttpRouteConfig, self).__init__(**kwargs)
        self.name = name
        self.match = match
        self.destination = destination
