# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class HttpRouteMatchRule(Model):
    """Describes a rule for http route matching.

    All required parameters must be populated in order to send to Azure.

    :param path: Required. Path to match for routing.
    :type path: ~azure.servicefabric.models.HttpRouteMatchPath
    :param headers: headers and their values to match in request.
    :type headers: list[~azure.servicefabric.models.HttpRouteMatchHeader]
    """

    _validation = {
        'path': {'required': True},
    }

    _attribute_map = {
        'path': {'key': 'path', 'type': 'HttpRouteMatchPath'},
        'headers': {'key': 'headers', 'type': '[HttpRouteMatchHeader]'},
    }

    def __init__(self, *, path, headers=None, **kwargs) -> None:
        super(HttpRouteMatchRule, self).__init__(**kwargs)
        self.path = path
        self.headers = headers
