# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TcpConfig(Model):
    """Describes the tcp configuration for external connectivity for this network.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. tcp gateway config name.
    :type name: str
    :param port: Required. Specifies the port at which the service endpoint
     below needs to be exposed.
    :type port: int
    :param destination: Required. Describes destination endpoint for routing
     traffic.
    :type destination: ~azure.servicefabric.models.GatewayDestination
    """

    _validation = {
        'name': {'required': True},
        'port': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'destination': {'key': 'destination', 'type': 'GatewayDestination'},
    }

    def __init__(self, **kwargs):
        super(TcpConfig, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.port = kwargs.get('port', None)
        self.destination = kwargs.get('destination', None)
