from flopy.mbase import Package


class ModflowDrn(Package):
    '''Drain package class\n'''
    ''' layer_row_column_elevation_cond is a list of 2D arrays. Each array has 5 columns containing
    the layer #, row #, column #, elevation and conductance value of a drn cell.
    Enter a separate array for each stress period. When fewer arrays are supplied than stress periods,
    the drn cells of the last array are repeated.
    No parameters implemented
    '''
    def __init__(self, model, idrncb = 0, layer_row_column_elevation_cond=None, extension ='drn', unitnumber=21,options=[],naux=0):
        Package.__init__(self, model, extension, 'DRN', unitnumber) # Call ancestor's init to set self.parent, extension, name and unit number
        self.heading = '# DRN for MODFLOW, generated by Flopy.'
        self.url = 'drn.htm'
        self.idrncb = idrncb  # 0: no cell by cell terms are written
        self.mxactd, self.layer_row_column_elevation_cond = self.assign_layer_row_column_data(layer_row_column_elevation_cond, 5+naux)
        self.np = 0
        self.options = options
        self.parent.add_package(self)
    def ncells( self):
        # Returns the  maximum number of cells that have drains (developped for MT3DMS SSM package)
        #print 'Function must be implemented properly for drn package'
        
        return self.mxactd
    def write_file(self):
        f_drn = open(self.fn_path, 'w')
        f_drn.write('%s\n' % self.heading)
        #f_drn.write('%10i%10i\n' % (self.mxactd, self.idrncb))
        line = '{0:10d}{1:10d}'.format(self.mxactd, self.idrncb)
        for opt in self.options:
            line += ' ' + str(opt)
        line += '\n'
        f_drn.write(line)
        self.write_layer_row_column_data(f_drn, self.layer_row_column_elevation_cond)
        f_drn.close()

    @staticmethod
    def load(f, model, nper=None, ext_unit_dict=None):
        '''
        f is either a filename or a file handle.  if the arrays in the file
        are specified using interal, external, or older style array control
        records, then f should be a file handle, and the ext_unit_dict
        dictionary of unitnumber:open(filename, 'r') must be included.
        '''
        if type(f) is not file:
            filename = f
            f = open(filename, 'r')
        #dataset 0 -- header
        while True:
            line = f.readline()
            if line[0] != '#':
                break
        #--check for parameters
        if "parameter" in line.lower():
            raw = line.strip().split()
            assert int(raw[1]) == 0,"Parameters are not supported"
            line = f.readline()
        #dataset 2a
        t = line.strip().split()
        mxactd = int(t[0])
        idrncb = 0
        try:
            if int(t[1]) != 0:
                idrncb = 53
        except:
            pass

        options = []
        naux = 0
        if len(t) > 2:
            for toption in t[3:-1]:
                if toption.lower() is 'noprint':
                    options.append(toption)
                elif 'aux' in toption.lower():
                    naux += 1
                    options.append(toption)
        if nper is None:
            nrow, ncol, nlay, nper = model.get_nrow_ncol_nlay_nper()
        #read data for every stress period
        layer_row_column_elevation_cond = []
        current = []
        nitems = 5 + naux
        for iper in xrange(nper):
            line = f.readline()
            t = line.strip().split()
            itmp = int(t[0])
            if itmp == 0:
                current = []
            elif itmp > 0:
                for ibnd in xrange(itmp):
                    line = f.readline()
                    t = line.strip().split()
                    current.append(t[0:nitems])
            layer_row_column_elevation_cond.append(current)
        drn = ModflowDrn(model,idrncb=idrncb,layer_row_column_elevation_cond=layer_row_column_elevation_cond,options=options,naux=naux)
        return drn
