DV.Schema.events.ViewAnnotation = {
  next: function(e){
    var viewer              = this.viewer;
    var activeAnnotationId  = viewer.activeAnnotationId;
    var annotationsModel    = this.models.annotations;
    var nextAnnotation      = (activeAnnotationId === null) ?
        annotationsModel.getFirstAnnotation() : annotationsModel.getNextAnnotation(activeAnnotationId);

    if (!nextAnnotation){
      return false;
    }

    viewer.pageSet.showAnnotation(nextAnnotation);
    this.helpers.setAnnotationPosition(nextAnnotation.position);


  },
  previous: function(e){
    var viewer              = this.viewer;
    var activeAnnotationId  = viewer.activeAnnotationId;
    var annotationsModel    = this.models.annotations;

    var previousAnnotation = (!activeAnnotationId) ?
    annotationsModel.getFirstAnnotation() : annotationsModel.getPreviousAnnotation(activeAnnotationId);
    if (!previousAnnotation){
      return false;
    }

    viewer.pageSet.showAnnotation(previousAnnotation);
    this.helpers.setAnnotationPosition(previousAnnotation.position);


  },
  search: function(e){
    e.preventDefault();
    this.viewer.open('ViewSearch');

    return false;
  }
};