# Copyright 2020 StrongDM Inc
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import approval_workflows_pb2 as approval__workflows__pb2


class ApprovalWorkflowsStub(object):
    """ApprovalWorkflows are the mechanism by which requests for access can be viewed by authorized
    approvers and be approved or denied.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Create = channel.unary_unary(
                '/v1.ApprovalWorkflows/Create',
                request_serializer=approval__workflows__pb2.ApprovalWorkflowCreateRequest.SerializeToString,
                response_deserializer=approval__workflows__pb2.ApprovalWorkflowCreateResponse.FromString,
                )
        self.Get = channel.unary_unary(
                '/v1.ApprovalWorkflows/Get',
                request_serializer=approval__workflows__pb2.ApprovalWorkflowGetRequest.SerializeToString,
                response_deserializer=approval__workflows__pb2.ApprovalWorkflowGetResponse.FromString,
                )
        self.Delete = channel.unary_unary(
                '/v1.ApprovalWorkflows/Delete',
                request_serializer=approval__workflows__pb2.ApprovalWorkflowDeleteRequest.SerializeToString,
                response_deserializer=approval__workflows__pb2.ApprovalWorkflowDeleteResponse.FromString,
                )
        self.Update = channel.unary_unary(
                '/v1.ApprovalWorkflows/Update',
                request_serializer=approval__workflows__pb2.ApprovalWorkflowUpdateRequest.SerializeToString,
                response_deserializer=approval__workflows__pb2.ApprovalWorkflowUpdateResponse.FromString,
                )
        self.List = channel.unary_unary(
                '/v1.ApprovalWorkflows/List',
                request_serializer=approval__workflows__pb2.ApprovalWorkflowListRequest.SerializeToString,
                response_deserializer=approval__workflows__pb2.ApprovalWorkflowListResponse.FromString,
                )


class ApprovalWorkflowsServicer(object):
    """ApprovalWorkflows are the mechanism by which requests for access can be viewed by authorized
    approvers and be approved or denied.
    """

    def Create(self, request, context):
        """Create creates a new approval workflow and requires a name and approval mode for the approval workflow.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Get(self, request, context):
        """Get reads one approval workflow by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Delete(self, request, context):
        """Delete deletes an existing approval workflow.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Update(self, request, context):
        """Update updates an existing approval workflow.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def List(self, request, context):
        """Lists existing approval workflows.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ApprovalWorkflowsServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Create': grpc.unary_unary_rpc_method_handler(
                    servicer.Create,
                    request_deserializer=approval__workflows__pb2.ApprovalWorkflowCreateRequest.FromString,
                    response_serializer=approval__workflows__pb2.ApprovalWorkflowCreateResponse.SerializeToString,
            ),
            'Get': grpc.unary_unary_rpc_method_handler(
                    servicer.Get,
                    request_deserializer=approval__workflows__pb2.ApprovalWorkflowGetRequest.FromString,
                    response_serializer=approval__workflows__pb2.ApprovalWorkflowGetResponse.SerializeToString,
            ),
            'Delete': grpc.unary_unary_rpc_method_handler(
                    servicer.Delete,
                    request_deserializer=approval__workflows__pb2.ApprovalWorkflowDeleteRequest.FromString,
                    response_serializer=approval__workflows__pb2.ApprovalWorkflowDeleteResponse.SerializeToString,
            ),
            'Update': grpc.unary_unary_rpc_method_handler(
                    servicer.Update,
                    request_deserializer=approval__workflows__pb2.ApprovalWorkflowUpdateRequest.FromString,
                    response_serializer=approval__workflows__pb2.ApprovalWorkflowUpdateResponse.SerializeToString,
            ),
            'List': grpc.unary_unary_rpc_method_handler(
                    servicer.List,
                    request_deserializer=approval__workflows__pb2.ApprovalWorkflowListRequest.FromString,
                    response_serializer=approval__workflows__pb2.ApprovalWorkflowListResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'v1.ApprovalWorkflows', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class ApprovalWorkflows(object):
    """ApprovalWorkflows are the mechanism by which requests for access can be viewed by authorized
    approvers and be approved or denied.
    """

    @staticmethod
    def Create(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ApprovalWorkflows/Create',
            approval__workflows__pb2.ApprovalWorkflowCreateRequest.SerializeToString,
            approval__workflows__pb2.ApprovalWorkflowCreateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Get(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ApprovalWorkflows/Get',
            approval__workflows__pb2.ApprovalWorkflowGetRequest.SerializeToString,
            approval__workflows__pb2.ApprovalWorkflowGetResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Delete(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ApprovalWorkflows/Delete',
            approval__workflows__pb2.ApprovalWorkflowDeleteRequest.SerializeToString,
            approval__workflows__pb2.ApprovalWorkflowDeleteResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Update(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ApprovalWorkflows/Update',
            approval__workflows__pb2.ApprovalWorkflowUpdateRequest.SerializeToString,
            approval__workflows__pb2.ApprovalWorkflowUpdateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def List(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ApprovalWorkflows/List',
            approval__workflows__pb2.ApprovalWorkflowListRequest.SerializeToString,
            approval__workflows__pb2.ApprovalWorkflowListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
