# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EntityPrediction(Model):
    """A suggested entity.

    All required parameters must be populated in order to send to Azure.

    :param entity_name: Required. The entity's name
    :type entity_name: str
    :param start_token_index: Required. The index within the utterance where
     the extracted entity starts.
    :type start_token_index: int
    :param end_token_index: Required. The index within the utterance where the
     extracted entity ends.
    :type end_token_index: int
    :param phrase: Required. The actual token(s) that comprise the entity.
    :type phrase: str
    """

    _validation = {
        'entity_name': {'required': True},
        'start_token_index': {'required': True},
        'end_token_index': {'required': True},
        'phrase': {'required': True},
    }

    _attribute_map = {
        'entity_name': {'key': 'entityName', 'type': 'str'},
        'start_token_index': {'key': 'startTokenIndex', 'type': 'int'},
        'end_token_index': {'key': 'endTokenIndex', 'type': 'int'},
        'phrase': {'key': 'phrase', 'type': 'str'},
    }

    def __init__(self, *, entity_name: str, start_token_index: int, end_token_index: int, phrase: str, **kwargs) -> None:
        super(EntityPrediction, self).__init__(**kwargs)
        self.entity_name = entity_name
        self.start_token_index = start_token_index
        self.end_token_index = end_token_index
        self.phrase = phrase
