# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EntityModel(Model):
    """An entity extracted from the utterance.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param entity: Required. Name of the entity, as defined in LUIS.
    :type entity: str
    :param type: Required. Type of the entity, as defined in LUIS.
    :type type: str
    :param start_index: Required. The position of the first character of the
     matched entity within the utterance.
    :type start_index: int
    :param end_index: Required. The position of the last character of the
     matched entity within the utterance.
    :type end_index: int
    """

    _validation = {
        'entity': {'required': True},
        'type': {'required': True},
        'start_index': {'required': True},
        'end_index': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'entity': {'key': 'entity', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_index': {'key': 'startIndex', 'type': 'int'},
        'end_index': {'key': 'endIndex', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(EntityModel, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.entity = kwargs.get('entity', None)
        self.type = kwargs.get('type', None)
        self.start_index = kwargs.get('start_index', None)
        self.end_index = kwargs.get('end_index', None)
