# -*- coding: utf-8 -*-
# Generated by Django 1.9.7 on 2016-10-24 23:24
from __future__ import unicode_literals

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('kolibriauth', '0001_initial_redone'),
        ('logger', '0001_initial_redone'),
    ]

    operations = [
        migrations.CreateModel(
            name='AttemptLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('item', models.CharField(max_length=200)),
                ('start_timestamp', models.DateTimeField()),
                ('end_timestamp', models.DateTimeField()),
                ('completion_timestamp', models.DateTimeField(blank=True, null=True)),
                ('time_spent', models.FloatField(default=0.0, help_text='(in seconds)', validators=[django.core.validators.MinValueValidator(0)])),
                ('complete', models.BooleanField(default=False)),
                ('correct', models.FloatField(validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1)])),
                ('hinted', models.BooleanField(default=False)),
                ('answer', models.TextField()),
                ('simple_answer', models.CharField(blank=True, max_length=200)),
                ('interaction_history', models.TextField()),
                ('dataset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kolibriauth.FacilityDataset')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MasteryLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mastery_criterion', models.TextField()),
                ('start_timestamp', models.DateTimeField()),
                ('end_timestamp', models.DateTimeField(blank=True, null=True)),
                ('completion_timestamp', models.DateTimeField(blank=True, null=True)),
                ('mastery_level', models.IntegerField(validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(10)])),
                ('complete', models.BooleanField(default=False)),
                ('dataset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kolibriauth.FacilityDataset')),
                ('summarylog', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='masterylogs', to='logger.ContentSummaryLog')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='attemptlog',
            name='masterylog',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='attemptlogs', to='logger.MasteryLog'),
        ),
        migrations.AddField(
            model_name='attemptlog',
            name='sessionlog',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attemptlogs', to='logger.ContentSessionLog'),
        ),
    ]
