/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc.xml;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.NamespaceHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HTMLTagsAnalyseHandler
extends DefaultHandler {
    private String fileName;
    private Report report;
    private final HashSet<String> html5SpecTags;
    private final HashSet<String> html4SpecTags;
    private final HashSet<String> nonTextTagsAlt;
    private final HashSet<String> nonTextTagsTitle;
    private final HashSet<String> headerTags;
    private final Stack<String> tagStack;
    private int html4SpecTagsCounter = 0;
    private int html5SpecTagsCounter = 0;
    private final ArrayList<Integer> listItemCounters;
    private HashMap<String, ControlMark> formInputMarks;
    private Locator locator;
    private boolean hasTitle;
    private boolean inTitle;
    private boolean inFigure;
    private boolean inBlockQuote;
    private NamespaceHelper namespaceHelper = new NamespaceHelper();
    private final int HAS_INPUT = 1;
    private final int HAS_LABEL = 2;
    private boolean hasViewport = false;
    private boolean isFixed = false;
    private int landmarkNavCount = 0;
    private EPUBVersion version;

    public int getLandmarkNavCount() {
        return this.landmarkNavCount;
    }

    public int getHtml5SpecTagsCounter() {
        return this.html5SpecTagsCounter;
    }

    public HTMLTagsAnalyseHandler() {
        String[] HTML5SpecTags = new String[]{"article", "aside", "audio", "bdi", "canvas", "command", "datalist", "details", "dialog", "embed", "figcaption", "figure", "footer", "header", "hgroup", "keygen", "mark", "meter", "nav", "output", "progress", "rp", "rt", "ruby", "section", "source", "summary", "time", "track", "wbr", "video"};
        String[] HTML4SpecTags = new String[]{"acronym", "applet", "basefont", "big", "center", "dir", "font", "frame", "frameset", "noframes", "strike"};
        String[] NonTextTagsAlt = new String[]{"img", "area"};
        String[] NonTextTagsTitle = new String[]{"map", "figure", "audio", "video"};
        String[] HeaderTags = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
        this.html4SpecTags = new HashSet();
        Collections.addAll(this.html4SpecTags, HTML4SpecTags);
        this.html5SpecTags = new HashSet();
        Collections.addAll(this.html5SpecTags, HTML5SpecTags);
        this.nonTextTagsAlt = new HashSet();
        Collections.addAll(this.nonTextTagsAlt, NonTextTagsAlt);
        this.nonTextTagsTitle = new HashSet();
        Collections.addAll(this.nonTextTagsTitle, NonTextTagsTitle);
        this.headerTags = new HashSet();
        Collections.addAll(this.headerTags, HeaderTags);
        this.tagStack = new Stack();
        this.listItemCounters = new ArrayList();
        this.formInputMarks = new HashMap();
    }

    String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setVersion(EPUBVersion version) {
        this.version = version;
    }

    public EPUBVersion getVersion() {
        return this.version;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public void setIsFixed(boolean isFixed) {
        this.isFixed = isFixed;
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        System.out.printf("%1$s : %2$s : %3$s ", name, publicId, systemId);
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        System.out.printf("%1$s : %2$s : %3$s : %4$s", name, publicId, systemId, notationName);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaceHelper.declareNamespace(prefix, uri, EPUBLocation.create(this.fileName, this.locator.getLineNumber(), this.locator.getColumnNumber(), prefix), this.report);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String typeAttr;
        String epubPrefix;
        String nameAttribute;
        String id;
        String mimeType;
        this.namespaceHelper.onStartElement(this.fileName, this.locator, uri, qName, attributes, this.report);
        String tagName = qName.toLowerCase();
        if (this.html5SpecTags.contains(tagName)) {
            ++this.html5SpecTagsCounter;
        }
        if (this.html4SpecTags.contains(tagName)) {
            ++this.html4SpecTagsCounter;
        }
        if ("source".compareTo(tagName) == 0 && "video".compareTo(this.tagStack.peek()) == 0) {
            mimeType = attributes.getValue("type");
            if (mimeType == null || !OPFChecker30.isBlessedVideoType(mimeType)) {
                if (mimeType == null) {
                    mimeType = "null";
                }
                this.report.message(MessageId.OPF_036, EPUBLocation.create(this.getFileName(), this.locator.getLineNumber(), this.locator.getColumnNumber()), mimeType);
            }
        } else if ("source".compareTo(tagName) == 0 && "audio".compareTo(this.tagStack.peek()) == 0) {
            mimeType = attributes.getValue("type");
            if (mimeType == null || !OPFChecker30.isBlessedAudioType(mimeType)) {
                if (mimeType == null) {
                    mimeType = "null";
                }
                this.report.message(MessageId.OPF_056, EPUBLocation.create(this.getFileName(), this.locator.getLineNumber(), this.locator.getColumnNumber()), mimeType);
            }
        } else if ("ul".compareTo(tagName) == 0 || "ol".compareTo(tagName) == 0 || "Dl".compareTo(tagName) == 0) {
            this.listItemCounters.add(0);
        } else if ("li".compareTo(tagName) == 0 && ("ul".compareTo(this.tagStack.peek()) == 0 || "ol".compareTo(this.tagStack.peek()) == 0)) {
            this.listItemCounters.set(this.listItemCounters.size() - 1, 1 + this.listItemCounters.get(this.listItemCounters.size() - 1));
        } else if ("dh".compareTo(tagName) == 0 && "dl".compareTo(this.tagStack.peek()) == 0) {
            this.listItemCounters.set(this.listItemCounters.size() - 1, 1 + this.listItemCounters.get(this.listItemCounters.size() - 1));
        } else if ("input".compareTo(tagName) == 0) {
            id = attributes.getValue("id");
            String type = attributes.getValue("type");
            if (id != null) {
                ControlMark mark = this.formInputMarks.get(id);
                if (mark == null) {
                    mark = new ControlMark();
                    mark.controlId = id;
                }
                mark.location = EPUBLocation.create(this.getFileName(), this.locator.getLineNumber(), this.locator.getColumnNumber(), id);
                mark.mark |= 1;
                this.formInputMarks.put(id, mark);
            } else if (type == null || "submit".compareToIgnoreCase(type) != 0) {
                this.report.message(MessageId.HTM_028, EPUBLocation.create(this.fileName, this.locator.getLineNumber(), this.locator.getColumnNumber()), tagName);
            }
        } else if ("label".compareTo(tagName) == 0) {
            id = attributes.getValue("for");
            if (id != null) {
                ControlMark mark = this.formInputMarks.get(id);
                if (mark == null) {
                    mark = new ControlMark();
                    mark.controlId = id;
                    mark.location = EPUBLocation.create(this.getFileName(), this.locator.getLineNumber(), this.locator.getColumnNumber(), id);
                }
                mark.mark |= 2;
                this.formInputMarks.put(id, mark);
            } else {
                this.report.message(MessageId.HTM_029, EPUBLocation.create(this.getFileName(), this.locator.getLineNumber(), this.locator.getColumnNumber(), tagName), new Object[0]);
            }
        } else if ("form".compareTo(tagName) == 0) {
            this.formInputMarks = new HashMap();
        } else if ("html".compareTo(tagName) == 0) {
            String ns = attributes.getValue("xmlns");
            if (ns == null || "http://www.w3.org/1999/xhtml".compareTo(ns) != 0) {
                this.report.message(MessageId.HTM_049, EPUBLocation.create(this.getFileName(), this.locator.getLineNumber(), this.locator.getColumnNumber(), tagName), new Object[0]);
            }
        } else if ("body".compareTo(tagName) == 0) {
            String title = attributes.getValue("title");
            if (title != null && title.length() > 0) {
                this.hasTitle = true;
            }
        } else if ("title".compareTo(tagName) == 0 && "head".compareTo(this.tagStack.peek()) == 0) {
            this.inTitle = true;
        } else if ("nav".compareTo(tagName) == 0) {
            String type = attributes.getValue("http://www.idpf.org/2007/ops", "type");
            if (type != null && "landmark".compareToIgnoreCase(type) == 0) {
                ++this.landmarkNavCount;
            }
        } else if ("blockquote".compareTo(tagName) == 0) {
            this.inBlockQuote = true;
        } else if ("figure".compareTo(tagName) == 0) {
            this.inFigure = true;
        } else if ("meta".compareTo(tagName) == 0 && (nameAttribute = attributes.getValue("name")) != null && "viewport".compareTo(nameAttribute) == 0) {
            this.hasViewport = true;
            String contentAttribute = attributes.getValue("content");
            if (!(!this.isFixed || contentAttribute != null && contentAttribute.contains("width") && contentAttribute.contains("height"))) {
                this.report.message(MessageId.HTM_047, EPUBLocation.create(this.getFileName(), this.locator.getLineNumber(), this.locator.getColumnNumber(), tagName), new Object[0]);
            }
        }
        if (this.headerTags.contains(tagName) && (this.inBlockQuote || this.inFigure)) {
            this.report.message(MessageId.ACC_010, EPUBLocation.create(this.getFileName(), this.locator.getLineNumber(), this.locator.getColumnNumber(), tagName), new Object[0]);
        }
        if (this.nonTextTagsAlt.contains(tagName) && null != this.getFileName() && null == attributes.getValue("alt")) {
            this.report.message(MessageId.ACC_001, EPUBLocation.create(this.getFileName(), this.locator.getLineNumber(), this.locator.getColumnNumber(), tagName), new Object[0]);
        }
        if (this.nonTextTagsTitle.contains(tagName) && null != this.getFileName() && null == attributes.getValue("title")) {
            this.report.message(MessageId.ACC_003, EPUBLocation.create(this.getFileName(), this.locator.getLineNumber(), this.locator.getColumnNumber(), tagName), new Object[0]);
        }
        if ((epubPrefix = this.namespaceHelper.findPrefixForUri("http://www.idpf.org/2007/ops")) != null && (typeAttr = attributes.getValue(epubPrefix + ":type")) != null && typeAttr.contains("pagebreak")) {
            this.report.message(MessageId.HTM_050, EPUBLocation.create(this.getFileName(), this.locator.getLineNumber(), this.locator.getColumnNumber(), "pagebreak"), new Object[0]);
        }
        this.tagStack.push(tagName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.namespaceHelper.onEndElement(this.report);
        String tagName = qName.toLowerCase();
        String top = this.tagStack.pop();
        if (top.compareTo(tagName) == 0) {
            Integer count;
            if (("ul".compareTo(tagName) == 0 || "ol".compareTo(tagName) == 0 || "Dl".compareTo(tagName) == 0) && (count = this.listItemCounters.remove(this.listItemCounters.size() - 1)) < 1) {
                this.report.message(MessageId.HTM_027, EPUBLocation.create(this.getFileName(), this.locator.getLineNumber(), this.locator.getColumnNumber(), qName), new Object[0]);
            }
            if ("body".compareTo(tagName) == 0) {
                for (String id : this.formInputMarks.keySet()) {
                    ControlMark mark = this.formInputMarks.get(id);
                    if ((mark.mark & 2) == 2 || (mark.mark & 1) != 1) continue;
                    this.report.message(MessageId.ACC_002, mark.location, id);
                }
            }
            if (this.inTitle && "title".compareTo(tagName) == 0) {
                this.inTitle = false;
            } else if ("head".compareTo(tagName) == 0) {
                if (!this.hasTitle) {
                    this.report.message(MessageId.HTM_033, EPUBLocation.create(this.getFileName(), this.locator.getLineNumber(), this.locator.getColumnNumber()), new Object[0]);
                }
                if (this.isFixed() && !this.hasViewport) {
                    this.report.message(MessageId.HTM_046, EPUBLocation.create(this.getFileName(), this.locator.getLineNumber(), this.locator.getColumnNumber()), new Object[0]);
                }
            } else if ("blockquote".compareTo(tagName) == 0) {
                this.inBlockQuote = false;
            } else if ("figure".compareTo(tagName) == 0) {
                this.inFigure = false;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inTitle && length > 0) {
            this.hasTitle = true;
        }
    }

    private class ControlMark {
        public String controlId;
        public int mark;
        public EPUBLocation location;

        private ControlMark() {
        }
    }
}

