/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.api.FeatureReport;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.EncryptionHandler;
import com.adobe.epubcheck.ocf.OCFData;
import com.adobe.epubcheck.ocf.OCFFilenameChecker;
import com.adobe.epubcheck.ocf.OCFHandler;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFCheckerFactory;
import com.adobe.epubcheck.opf.OPFData;
import com.adobe.epubcheck.opf.OPFHandler;
import com.adobe.epubcheck.opf.OPFHandler30;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.CheckUtil;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.ValidatorMap;
import com.adobe.epubcheck.vocab.EpubCheckVocab;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import com.adobe.epubcheck.xml.XMLValidators;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class OCFChecker {
    private static final ValidatorMap validatorMap = ValidatorMap.builder().put(Predicates.and(ValidationContext.ValidationContextPredicates.path("META-INF/container.xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_2)), XMLValidators.CONTAINER_20_RNG).put(Predicates.and(ValidationContext.ValidationContextPredicates.path("META-INF/container.xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3)), XMLValidators.CONTAINER_30_RNC).put(Predicates.and(ValidationContext.ValidationContextPredicates.path("META-INF/container.xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3)), XMLValidators.CONTAINER_30_RENDITIONS_SCH).put(Predicates.and(ValidationContext.ValidationContextPredicates.path("META-INF/encryption.xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3)), XMLValidators.ENC_30_RNC).put(Predicates.and(ValidationContext.ValidationContextPredicates.path("META-INF/encryption.xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_2)), XMLValidators.ENC_20_RNG).put(Predicates.and(ValidationContext.ValidationContextPredicates.path("META-INF/signatures.xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_2)), XMLValidators.SIG_20_RNG).put(Predicates.and(ValidationContext.ValidationContextPredicates.path("META-INF/signatures.xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3)), XMLValidators.SIG_30_RNC).put(Predicates.and(ValidationContext.ValidationContextPredicates.path("META-INF/metadata.xml"), ValidationContext.ValidationContextPredicates.hasProp(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.MULTIPLE_RENDITION))), XMLValidators.META_30_RNC).put(Predicates.and(ValidationContext.ValidationContextPredicates.path("META-INF/metadata.xml"), ValidationContext.ValidationContextPredicates.hasProp(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.MULTIPLE_RENDITION))), XMLValidators.META_30_SCH).put(Predicates.and(ValidationContext.ValidationContextPredicates.path("META-INF/metadata.xml"), ValidationContext.ValidationContextPredicates.hasProp(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.MULTIPLE_RENDITION)), ValidationContext.ValidationContextPredicates.profile(EPUBProfile.EDUPUB)), XMLValidators.META_EDUPUB_SCH).putAll(ValidationContext.ValidationContextPredicates.hasProp(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.RENDITION_MAPPING)), XMLValidators.RENDITION_MAPPING_RNC, XMLValidators.RENDITION_MAPPING_SCH).build();
    private final ValidationContext context;
    private final OCFPackage ocf;
    private final Report report;

    public OCFChecker(ValidationContext context) {
        Preconditions.checkState(context.ocf.isPresent());
        this.context = context;
        this.ocf = context.ocf.get();
        this.report = context.report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runChecks() {
        EPUBVersion validationVersion;
        OCFData containerData;
        List<String> opfPaths;
        ValidationContext.ValidationContextBuilder newContextBuilder = new ValidationContext.ValidationContextBuilder(this.context);
        this.ocf.setReport(this.report);
        if (!this.ocf.hasEntry("META-INF/container.xml")) {
            this.report.message(MessageId.RSC_002, EPUBLocation.create(this.ocf.getName()), new Object[0]);
            return;
        }
        long l = this.ocf.getTimeEntry("META-INF/container.xml");
        if (l > 0L) {
            Date d = new Date(l);
            String formattedDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(d);
            this.report.info("META-INF/container.xml", FeatureEnum.CREATION_DATE, formattedDate);
        }
        if ((opfPaths = (containerData = this.ocf.getOcfData()).getEntries("application/oebps-package+xml")) == null || opfPaths.isEmpty()) {
            this.report.message(MessageId.RSC_003, EPUBLocation.create("META-INF/container.xml"), new Object[0]);
            return;
        }
        if (opfPaths.size() > 0) {
            if (opfPaths.size() > 1) {
                this.report.info(null, FeatureEnum.EPUB_RENDITIONS_COUNT, Integer.toString(opfPaths.size()));
            }
            int rootfileErrorCounter = 0;
            for (String opfPath : opfPaths) {
                if (opfPath == null) {
                    ++rootfileErrorCounter;
                    this.report.message(MessageId.OPF_016, EPUBLocation.create("META-INF/container.xml"), new Object[0]);
                    continue;
                }
                if (opfPath.isEmpty()) {
                    ++rootfileErrorCounter;
                    this.report.message(MessageId.OPF_017, EPUBLocation.create("META-INF/container.xml"), new Object[0]);
                    continue;
                }
                if (this.ocf.hasEntry(opfPath)) continue;
                this.report.message(MessageId.OPF_002, EPUBLocation.create("META-INF/container.xml"), opfPath);
                return;
            }
            if (rootfileErrorCounter == opfPaths.size()) {
                return;
            }
        }
        EPUBVersion detectedVersion = null;
        OPFData opfData = this.ocf.getOpfData().get(opfPaths.get(0));
        if (opfData == null) {
            return;
        }
        detectedVersion = opfData.getVersion();
        this.report.info(null, FeatureEnum.FORMAT_VERSION, detectedVersion.toString());
        assert (detectedVersion != null);
        if (this.context.version != EPUBVersion.Unknown && this.context.version != detectedVersion) {
            this.report.message(MessageId.PKG_001, EPUBLocation.create(opfPaths.get(0)), new Object[]{this.context.version, detectedVersion});
            validationVersion = this.context.version;
        } else {
            validationVersion = detectedVersion;
        }
        newContextBuilder.version(validationVersion);
        EPUBProfile validationProfile = this.context.profile;
        if (validationVersion == EPUBVersion.VERSION_2 && validationProfile != EPUBProfile.DEFAULT) {
            this.report.message(MessageId.PKG_023, EPUBLocation.create(opfPaths.get(0)), new Object[0]);
        } else if (validationVersion == EPUBVersion.VERSION_3) {
            validationProfile = EPUBProfile.makeOPFCompatible(validationProfile, opfData, opfPaths.get(0), this.report);
        }
        newContextBuilder.profile(validationProfile);
        if (validationVersion == EPUBVersion.VERSION_2 && opfPaths.size() > 1) {
            this.report.message(MessageId.PKG_013, EPUBLocation.create("META-INF/container.xml"), new Object[0]);
        }
        if (validationVersion == EPUBVersion.VERSION_3 && opfPaths.size() > 1) {
            newContextBuilder.addProperty(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.MULTIPLE_RENDITION));
            if (!this.ocf.hasEntry("META-INF/metadata.xml")) {
                this.report.message(MessageId.RSC_019, EPUBLocation.create(this.ocf.getName()), new Object[0]);
            }
            if (containerData.getMapping().isPresent()) {
                this.validateRenditionMapping(new ValidationContext.ValidationContextBuilder(newContextBuilder.build()).mimetype("application/xhtml+xml").path(containerData.getMapping().get()).addProperty(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.RENDITION_MAPPING)).build());
            }
        }
        InputStream mimetype = null;
        try {
            mimetype = this.ocf.getInputStream("mimetype");
            StringBuilder sb = new StringBuilder(2048);
            if (this.ocf.hasEntry("mimetype") && !CheckUtil.checkTrailingSpaces(mimetype, validationVersion, sb)) {
                this.report.message(MessageId.PKG_007, EPUBLocation.create("mimetype"), new Object[0]);
            }
            if (sb.length() != 0) {
                this.report.info(null, FeatureEnum.FORMAT_NAME, sb.toString().trim());
            }
        }
        catch (IOException sb) {
        }
        finally {
            try {
                if (mimetype != null) {
                    mimetype.close();
                }
            }
            catch (IOException sb) {}
        }
        this.validateMetaFiles(newContextBuilder.mimetype("xml").build());
        LinkedList<OPFHandler> opfHandlers = new LinkedList<OPFHandler>();
        for (String opfPath : opfPaths) {
            OPFChecker opfChecker = OPFCheckerFactory.getInstance().newInstance(newContextBuilder.path(opfPath).mimetype("application/oebps-package+xml").featureReport(new FeatureReport()).build());
            opfChecker.runChecks();
            opfHandlers.add(opfChecker.getOPFHandler());
        }
        try {
            HashSet<String> entriesSet = new HashSet<String>();
            HashSet<String> normalizedEntriesSet = new HashSet<String>();
            for (final String entry : this.ocf.getFileEntries()) {
                if (!entriesSet.add(entry.toLowerCase(Locale.ENGLISH))) {
                    this.report.message(MessageId.OPF_060, EPUBLocation.create(this.ocf.getPackagePath()), entry);
                } else if (!normalizedEntriesSet.add(Normalizer.normalize(entry, Normalizer.Form.NFC))) {
                    this.report.message(MessageId.OPF_061, EPUBLocation.create(this.ocf.getPackagePath()), entry);
                }
                this.ocf.reportMetadata(entry, this.report);
                if (!(entry.startsWith("META-INF/") || entry.startsWith("META-INF\\") || entry.equals("mimetype") || containerData.getEntries().contains(entry) || entry.equals(containerData.getMapping().orNull()) || Iterables.tryFind(opfHandlers, new Predicate<OPFHandler>(){

                    @Override
                    public boolean apply(OPFHandler opfHandler) {
                        return opfHandler.getItemByPath(entry).isPresent() || validationVersion == EPUBVersion.VERSION_3 && ((OPFHandler30)opfHandler).getLinkedResources().hasPath(entry);
                    }
                }).isPresent())) {
                    this.report.message(MessageId.OPF_003, EPUBLocation.create(this.ocf.getName()), entry);
                }
                OCFFilenameChecker.checkCompatiblyEscaped(entry, this.report, validationVersion);
            }
            for (String directory : this.ocf.getDirectoryEntries()) {
                boolean hasContents = false;
                for (String file : this.ocf.getFileEntries()) {
                    if (!file.startsWith(directory)) continue;
                    hasContents = true;
                    break;
                }
                if (hasContents) continue;
                this.report.message(MessageId.PKG_014, EPUBLocation.create(this.ocf.getName()), directory);
            }
        }
        catch (IOException e) {
            this.report.message(MessageId.PKG_015, EPUBLocation.create(this.ocf.getName()), e.getMessage());
        }
    }

    private boolean validateMetaFiles(ValidationContext context) {
        this.validateMetaFile(new ValidationContext.ValidationContextBuilder(context).path("META-INF/container.xml").build());
        if (this.ocf.hasEntry("META-INF/encryption.xml")) {
            this.validateMetaFile(new ValidationContext.ValidationContextBuilder(context).path("META-INF/encryption.xml").build());
            this.report.info(null, FeatureEnum.HAS_ENCRYPTION, "META-INF/encryption.xml");
        }
        if (this.ocf.hasEntry("META-INF/signatures.xml")) {
            this.validateMetaFile(new ValidationContext.ValidationContextBuilder(context).path("META-INF/signatures.xml").build());
            this.report.info(null, FeatureEnum.HAS_SIGNATURES, "META-INF/signatures.xml");
        }
        if (this.ocf.hasEntry("META-INF/metadata.xml")) {
            this.validateMetaFile(new ValidationContext.ValidationContextBuilder(context).path("META-INF/metadata.xml").build());
        }
        return false;
    }

    private void validateMetaFile(ValidationContext context) {
        XMLParser parser = new XMLParser(context);
        if (context.path.equals("META-INF/encryption.xml")) {
            parser.addXMLHandler(new EncryptionHandler(this.ocf, parser));
        } else {
            parser.addXMLHandler(new OCFHandler(parser));
        }
        for (XMLValidator validator : validatorMap.getValidators(context)) {
            parser.addValidator(validator);
        }
        parser.process();
    }

    private void validateRenditionMapping(ValidationContext context) {
        XMLParser parser = new XMLParser(context);
        for (XMLValidator validator : validatorMap.getValidators(context)) {
            parser.addValidator(validator);
        }
        parser.process();
    }
}

