/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.vocab;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.QuietReport;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.vocab.EnumVocab;
import com.adobe.epubcheck.vocab.PrefixDeclarationParser;
import com.adobe.epubcheck.vocab.Property;
import com.adobe.epubcheck.vocab.UncheckedVocab;
import com.adobe.epubcheck.vocab.Vocab;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VocabUtil {
    public static Vocab EMPTY_VOCAB = new EnumVocab<EMPTY>(EMPTY.class, "");
    private static Pattern propertyPattern = Pattern.compile("(([^:]*):)?(.*)");
    private static Splitter whitespaceSplitter = Splitter.onPattern("\\s+").omitEmptyStrings();

    public static Optional<Property> parseProperty(String value, Map<String, Vocab> vocabs, Report report, EPUBLocation location) {
        return Optional.fromNullable(Iterables.get(VocabUtil.parseProperties(value, vocabs, false, report, location), 0, null));
    }

    public static Set<Property> parsePropertyList(String value, Map<String, ? extends Vocab> vocabs, Report report, EPUBLocation location) {
        return VocabUtil.parseProperties(value, vocabs, true, report, location);
    }

    public static <E extends Enum<E>> Set<E> parsePropertyListAsEnumSet(String properties, Map<String, ? extends Vocab> vocabs, Class<E> clazz) {
        return Sets.newEnumSet(Property.filter(VocabUtil.parsePropertyList(properties, vocabs, QuietReport.INSTANCE, EPUBLocation.create("")), clazz), clazz);
    }

    private static Set<Property> parseProperties(String value, Map<String, ? extends Vocab> vocabs, boolean isList, Report report, EPUBLocation location) {
        Preconditions.checkNotNull(vocabs);
        Preconditions.checkNotNull(report);
        Preconditions.checkNotNull(location);
        if (value == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Iterable<String> properties = whitespaceSplitter.split(value);
        if (!isList && !Iterables.isEmpty(Iterables.skip(properties, 1))) {
            report.message(MessageId.OPF_025, location, value);
            return ImmutableSet.of();
        }
        for (String property : properties) {
            Matcher matcher = propertyPattern.matcher(property);
            matcher.matches();
            if (matcher.group(1) != null && (matcher.group(2).isEmpty() || matcher.group(3).isEmpty())) {
                report.message(MessageId.OPF_026, location, property);
                continue;
            }
            String prefix = Strings.nullToEmpty(matcher.group(2));
            String name = matcher.group(3);
            try {
                Optional<Property> found = vocabs.get(prefix).lookup(name);
                if (found.isPresent()) {
                    builder.add(found.get());
                    continue;
                }
                report.message(MessageId.OPF_027, location, property);
            }
            catch (NullPointerException e) {
                report.message(MessageId.OPF_028, location, prefix);
            }
        }
        return builder.build();
    }

    public static Map<String, Vocab> parsePrefixDeclaration(String value, Map<String, ? extends Vocab> predefined, Map<String, ? extends Vocab> known, Set<String> forbidden, Report report, EPUBLocation location) {
        HashMap<String, ? extends Vocab> vocabs = Maps.newHashMap(predefined);
        Map<String, String> mappings = PrefixDeclarationParser.parsePrefixMappings(value, report, location);
        for (Map.Entry<String, String> mapping : mappings.entrySet()) {
            String prefix = mapping.getKey();
            String uri = mapping.getValue();
            if ("_".equals(prefix)) {
                report.message(MessageId.OPF_007a, location, new Object[0]);
                continue;
            }
            if (forbidden.contains(uri)) {
                report.message(MessageId.OPF_007b, location, prefix);
                continue;
            }
            if (predefined.containsKey(prefix) && !Strings.nullToEmpty(predefined.get(prefix).getURI()).equals(uri)) {
                report.message(MessageId.OPF_007, location, prefix);
            }
            Vocab vocab = known.get(uri);
            vocabs.put(mapping.getKey(), vocab == null ? new UncheckedVocab(uri, prefix) : vocab);
        }
        return ImmutableMap.copyOf(vocabs);
    }

    private VocabUtil() {
    }

    private static enum EMPTY {

    }
}

