/*
 * Decompiled with CFR 0.152.
 */
package org.idpf.epubcheck.util.css;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.idpf.epubcheck.util.css.CssLocation;
import org.idpf.epubcheck.util.css.CssToken;
import org.idpf.epubcheck.util.css.Messages;

public final class CssExceptions {
    private static final String SCANNER = "css.scanner";
    private static final String SCANNER_TOKEN_SYNTAX = "css.scanner.token.syntax";
    private static final String GRAMMAR = "css.grammar";
    private static final String GRAMMAR_TOKEN = "css.grammar.token";
    private static final Optional<CssToken> absent = Optional.absent();

    public static abstract class CssException
    extends Exception {
        final CssErrorCode errorCode;
        final CssLocation location;
        final Optional<CssToken> token;
        private static final long serialVersionUID = -4635263495562931206L;

        CssException(CssToken token, CssErrorCode errorCode, CssLocation location, Object ... arguments) {
            super(Messages.get(errorCode.value, arguments));
            this.errorCode = Preconditions.checkNotNull(errorCode);
            this.location = Preconditions.checkNotNull(location);
            this.token = token == null ? absent : Optional.of(token);
        }

        CssException(CssErrorCode errorCode, CssLocation location, Object ... arguments) {
            this(null, errorCode, location, arguments);
        }

        public CssErrorCode getErrorCode() {
            return this.errorCode;
        }

        public CssLocation getLocation() {
            return this.location;
        }

        @Override
        public String toString() {
            return Objects.toStringHelper(this.getClass()).add("errorCode", (Object)this.errorCode).add("location", this.location.toString()).toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CssException) {
                CssException exc = (CssException)obj;
                if (exc.errorCode.equals((Object)this.errorCode) && exc.location.equals(this.location)) {
                    return true;
                }
            }
            return false;
        }
    }

    static class CssScannerException
    extends CssException {
        private static final long serialVersionUID = 7105109387886737631L;

        CssScannerException(CssToken token, CssErrorCode errorCode, CssLocation location, Object ... arguments) {
            super(token, errorCode, location, arguments);
        }

        CssScannerException(CssErrorCode errorCode, CssLocation location, Object ... arguments) {
            super(errorCode, location, arguments);
        }
    }

    static class CssGrammarException
    extends CssException {
        private static final long serialVersionUID = -7470976690623543450L;

        CssGrammarException(CssErrorCode errorCode, CssLocation location, Object ... arguments) {
            super(errorCode, location, arguments);
        }
    }

    public static enum CssErrorCode {
        SCANNER_ILLEGAL_SYNTAX("css.scanner.token.syntax"),
        SCANNER_ILLEGAL_CHAR("css.scanner.token.syntax.char"),
        SCANNER_ILLEGAL_FIRSTCHAR("css.scanner.token.syntax.firstChar"),
        SCANNER_MALFORMED_ESCAPE("css.scanner.token.syntax.escape"),
        SCANNER_ILLEGAL_URANGE("css.scanner.token.syntax.urange"),
        SCANNER_PREMATURE_EOF("css.scanner.prematureEOF"),
        GRAMMAR_PREMATURE_EOF("css.grammar.prematureEOF"),
        GRAMMAR_UNEXPECTED_TOKEN("css.grammar.token.unexpected"),
        GRAMMAR_EXPECTING_TOKEN("css.grammar.token.expecting"),
        GRAMMAR_INVALID_SELECTOR("css.grammar.invalidSelector");

        final String value;

        private CssErrorCode(String value) {
            this.value = value;
        }

        public String toString() {
            return Objects.toStringHelper(((Object)((Object)this)).getClass()).addValue(this.value).toString();
        }
    }
}

