/*
 * Decompiled with CFR 0.152.
 */
package org.idpf.epubcheck.util.css;

import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.idpf.epubcheck.util.css.CssErrorHandler;
import org.idpf.epubcheck.util.css.CssExceptions;
import org.idpf.epubcheck.util.css.CssLocation;
import org.idpf.epubcheck.util.css.CssParser;
import org.idpf.epubcheck.util.css.CssScanner;
import org.idpf.epubcheck.util.css.CssToken;
import org.idpf.epubcheck.util.css.CssTokenList;
import org.idpf.epubcheck.util.css.Messages;

public class CssGrammar {

    static final class CssConstructFactory {
        static final CssTokenTransform BUILDER_FUNCTION = new CssTokenTransform(){

            @Override
            public CssFunction build(CssToken start, CssTokenList.CssTokenIterator iter, Predicate<CssToken> limit, Predicate<CssConstruct> permitted) {
                String name = start.getChars().substring(0, start.getChars().length() - 1);
                CssFunction function = new CssFunction(name, start.location);
                CssToken tk = iter.next();
                while (!CssToken.Matchers.MATCH_CLOSEPAREN.apply(tk)) {
                    if (limit.apply(tk)) {
                        return null;
                    }
                    CssConstruct cc = CssConstructFactory.create(tk, iter, limit, CssParser.ContextRestrictions.FUNCTION);
                    if (cc == null || !permitted.apply(cc)) {
                        return null;
                    }
                    function.components.add(cc);
                    tk = iter.next();
                }
                return function;
            }
        };
        private static final CssTokenTransform BUILDER_ATOMIC = new CssTokenTransform(){

            @Override
            public CssConstruct build(CssToken start, CssTokenList.CssTokenIterator iter, Predicate<CssToken> limit, Predicate<CssConstruct> permitted) {
                CssAtomicConstruct cc;
                CssConstruct.Type type = (CssConstruct.Type)((Object)genericTypeMappings.get((Object)start.type));
                switch (type) {
                    case KEYWORD: {
                        cc = new CssKeyword(start.getChars(), start.location);
                        break;
                    }
                    case URI: {
                        cc = new CssURI(start.getChars(), start.location);
                        break;
                    }
                    case STRING: {
                        cc = new CssString(start.getChars(), start.location);
                        break;
                    }
                    case URANGE: {
                        cc = new CssUnicodeRange(start.getChars(), start.location);
                        break;
                    }
                    case HASHNAME: {
                        cc = new CssHashName(start.getChars(), start.location);
                        break;
                    }
                    case CLASSNAME: {
                        cc = new CssClassName(start.getChars(), start.location);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("CssTokenTransform BUILDER_ATOMIC");
                    }
                }
                return permitted.apply(cc) ? cc : null;
            }
        };
        private static final CssTokenTransform BUILDER_CHAR = new CssTokenTransform(){

            @Override
            public CssConstruct build(CssToken start, CssTokenList.CssTokenIterator iter, Predicate<CssToken> limit, Predicate<CssConstruct> permitted) {
                char chr = start.getChar();
                if (chr == '{' || chr == '}' || chr == ';') {
                    return null;
                }
                CssConstruct ret = chr == '(' || chr == '[' ? BUILDER_SCOPEDGROUP.build(start, iter, limit, permitted) : new CssSymbol(start.chars, start.location);
                if (ret == null) {
                    return null;
                }
                return permitted.apply(ret) ? ret : null;
            }
        };
        static final CssTokenTransform BUILDER_SCOPEDGROUP = new CssTokenTransform(){

            @Override
            public CssConstruct build(CssToken start, CssTokenList.CssTokenIterator iter, Predicate<CssToken> limit, Predicate<CssConstruct> permitted) {
                Predicate<CssToken> end;
                CssScopedGroup.Type type;
                if (CssToken.Matchers.MATCH_OPENPAREN.apply(start)) {
                    type = CssScopedGroup.Type.PAREN;
                    end = CssToken.Matchers.MATCH_CLOSEPAREN;
                } else if (CssToken.Matchers.MATCH_OPENSQUAREBRACKET.apply(start)) {
                    type = CssScopedGroup.Type.BRACKET;
                    end = CssToken.Matchers.MATCH_CLOSESQUAREBRACKET;
                } else {
                    throw new IllegalStateException();
                }
                CssScopedGroup group = new CssScopedGroup(type, start.location);
                CssToken tk = iter.next();
                while (!end.apply(tk)) {
                    if (limit.apply(tk)) {
                        return null;
                    }
                    CssConstruct cc = CssConstructFactory.create(tk, iter, limit, CssParser.ContextRestrictions.FUNCTION);
                    if (cc == null || !permitted.apply(cc)) {
                        return null;
                    }
                    group.components.add(cc);
                    tk = iter.next();
                }
                return group;
            }
        };
        private static final CssTokenTransform BUILDER_QNTY = new CssTokenTransform(){

            @Override
            public CssConstruct build(CssToken start, CssTokenList.CssTokenIterator iter, Predicate<CssToken> limit, Predicate<CssConstruct> permitted) {
                CssQuantity cq = new CssQuantity(start.chars, (CssQuantity.Unit)((Object)quantityMappings.get((Object)start.type)), start.location);
                return permitted.apply(cq) ? cq : null;
            }
        };
        private static final Map<CssToken.Type, CssTokenTransform> transformerMappings = new ImmutableMap.Builder<CssToken.Type, CssTokenTransform>().put(CssToken.Type.FUNCTION, BUILDER_FUNCTION).put(CssToken.Type.CHAR, BUILDER_CHAR).put(CssToken.Type.IDENT, BUILDER_ATOMIC).put(CssToken.Type.URI, BUILDER_ATOMIC).put(CssToken.Type.STRING, BUILDER_ATOMIC).put(CssToken.Type.AND, BUILDER_ATOMIC).put(CssToken.Type.NOT, BUILDER_ATOMIC).put(CssToken.Type.ONLY, BUILDER_ATOMIC).put(CssToken.Type.URANGE, BUILDER_ATOMIC).put(CssToken.Type.HASHNAME, BUILDER_ATOMIC).put(CssToken.Type.CLASSNAME, BUILDER_ATOMIC).put(CssToken.Type.QNTY_ANGLE, BUILDER_QNTY).put(CssToken.Type.QNTY_DIMEN, BUILDER_QNTY).put(CssToken.Type.QNTY_REMS, BUILDER_QNTY).put(CssToken.Type.QNTY_EMS, BUILDER_QNTY).put(CssToken.Type.QNTY_EXS, BUILDER_QNTY).put(CssToken.Type.QNTY_FREQ, BUILDER_QNTY).put(CssToken.Type.QNTY_LENGTH, BUILDER_QNTY).put(CssToken.Type.QNTY_PERCENTAGE, BUILDER_QNTY).put(CssToken.Type.QNTY_RESOLUTION, BUILDER_QNTY).put(CssToken.Type.QNTY_TIME, BUILDER_QNTY).put(CssToken.Type.NUMBER, BUILDER_QNTY).put(CssToken.Type.INTEGER, BUILDER_QNTY).build();
        private static final Map<CssToken.Type, CssConstruct.Type> genericTypeMappings = new ImmutableMap.Builder<CssToken.Type, CssConstruct.Type>().put(CssToken.Type.IDENT, CssConstruct.Type.KEYWORD).put(CssToken.Type.URI, CssConstruct.Type.URI).put(CssToken.Type.STRING, CssConstruct.Type.STRING).put(CssToken.Type.AND, CssConstruct.Type.KEYWORD).put(CssToken.Type.NOT, CssConstruct.Type.KEYWORD).put(CssToken.Type.ONLY, CssConstruct.Type.KEYWORD).put(CssToken.Type.URANGE, CssConstruct.Type.URANGE).put(CssToken.Type.HASHNAME, CssConstruct.Type.HASHNAME).put(CssToken.Type.CLASSNAME, CssConstruct.Type.CLASSNAME).build();
        private static final Map<CssToken.Type, CssQuantity.Unit> quantityMappings = new ImmutableMap.Builder<CssToken.Type, CssQuantity.Unit>().put(CssToken.Type.QNTY_ANGLE, CssQuantity.Unit.ANGLE).put(CssToken.Type.QNTY_DIMEN, CssQuantity.Unit.DIMEN).put(CssToken.Type.QNTY_REMS, CssQuantity.Unit.REMS).put(CssToken.Type.QNTY_EMS, CssQuantity.Unit.EMS).put(CssToken.Type.QNTY_EXS, CssQuantity.Unit.EXS).put(CssToken.Type.QNTY_FREQ, CssQuantity.Unit.FREQ).put(CssToken.Type.QNTY_LENGTH, CssQuantity.Unit.LENGTH).put(CssToken.Type.QNTY_PERCENTAGE, CssQuantity.Unit.PERCENTAGE).put(CssToken.Type.QNTY_RESOLUTION, CssQuantity.Unit.RESOLUTION).put(CssToken.Type.QNTY_TIME, CssQuantity.Unit.TIME).put(CssToken.Type.NUMBER, CssQuantity.Unit.NUMBER).put(CssToken.Type.INTEGER, CssQuantity.Unit.INTEGER).build();

        CssConstructFactory() {
        }

        static CssConstruct create(CssToken start, CssTokenList.CssTokenIterator iter, Predicate<CssToken> limit, Predicate<CssConstruct> permitted) {
            CssTokenTransform transform = transformerMappings.get((Object)start.type);
            return transform == null ? null : transform.build(start, iter, limit, permitted);
        }

        static interface CssTokenTransform {
            public CssConstruct build(CssToken var1, CssTokenList.CssTokenIterator var2, Predicate<CssToken> var3, Predicate<CssConstruct> var4);
        }
    }

    static final class CssSelectorConstructFactory {
        CssSelectorConstructFactory() {
        }

        public static CssSimpleSelectorSequence createSimpleSelectorSequence(CssToken start, CssTokenList.CssTokenIterator iter, CssErrorHandler err) throws CssExceptions.CssException {
            CssSimpleSelectorSequence seq = new CssSimpleSelectorSequence(start.location);
            CssConstruct seqItem = CssSelectorConstructFactory.createSimpleSelector(start, iter, err);
            if (seqItem == null) {
                return null;
            }
            seq.components.add(seqItem);
            CssToken next = iter.peek(CssTokenList.Filters.FILTER_NONE);
            while (!(next.type == CssToken.Type.S || CssToken.Matchers.MATCH_COMMA.apply(next) || CssToken.Matchers.MATCH_OPENBRACE.apply(next) || CssToken.Matchers.MATCH_COMBINATOR_CHAR.apply(next))) {
                seqItem = CssSelectorConstructFactory.createSimpleSelector(iter.next(CssTokenList.Filters.FILTER_NONE), iter, err);
                if (seqItem == null) {
                    return null;
                }
                seq.components.add(seqItem);
                next = iter.peek(CssTokenList.Filters.FILTER_NONE);
            }
            return seq;
        }

        static CssConstruct createSimpleSelector(CssToken start, CssTokenList.CssTokenIterator iter, CssErrorHandler err) throws CssExceptions.CssException {
            if (start.type == CssToken.Type.IDENT || CssToken.Matchers.MATCH_STAR_PIPE.apply(start)) {
                return CssSelectorConstructFactory.createTypeSelector(start, iter, err);
            }
            if (start.type == CssToken.Type.HASHNAME) {
                return new CssHashName(start.getChars(), start.location);
            }
            if (start.type == CssToken.Type.CLASSNAME) {
                return new CssClassName(start.getChars(), start.location);
            }
            if (CssToken.Matchers.MATCH_OPENSQUAREBRACKET.apply(start)) {
                return CssSelectorConstructFactory.createAttributeSelector(iter.next(), iter, err);
            }
            if (CssToken.Matchers.MATCH_COLON.apply(start)) {
                return CssSelectorConstructFactory.createPseudoSelector(start, iter, err);
            }
            if (start.type == CssToken.Type.QNTY_PERCENTAGE) {
                CssSelector sel = new CssSelector(start.location);
                sel.components.add(new CssQuantity(start.chars, CssQuantity.Unit.PERCENTAGE, start.location));
                return sel;
            }
            err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_UNEXPECTED_TOKEN, start.location, start.chars));
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static CssSelectorCombinator createCombinator(CssToken start, CssTokenList.CssTokenIterator iter, CssErrorHandler err) {
            char symbol;
            if (start.type != CssToken.Type.CHAR) return null;
            char ch = start.getChar();
            if (ch == '>') {
                symbol = ch;
                return new CssSelectorCombinator(symbol, start.location);
            } else if (ch == '+') {
                symbol = ch;
                return new CssSelectorCombinator(symbol, start.location);
            } else {
                if (ch != '~') return null;
                symbol = ch;
            }
            return new CssSelectorCombinator(symbol, start.location);
        }

        static CssPseudoSelector createPseudoSelector(CssToken start, CssTokenList.CssTokenIterator iter, CssErrorHandler err) throws CssExceptions.CssException {
            CssPseudoSelector.Type type;
            StringBuilder sb = new StringBuilder();
            sb.append(start.getChars());
            CssToken next = iter.next(CssTokenList.Filters.FILTER_NONE);
            if (CssToken.Matchers.MATCH_COLON.apply(next)) {
                type = CssPseudoSelector.Type.PSEUDO_ELEMENT;
                sb.append(next.getChars());
                next = iter.next(CssTokenList.Filters.FILTER_NONE);
            } else {
                type = CssPseudoSelector.Type.PSEUDO_CLASS;
            }
            CssPseudoSelector cps = new CssPseudoSelector(type, start.location);
            if (next.type == CssToken.Type.IDENT) {
                sb.append(next.getChars());
                cps.name = sb.toString();
            } else if (next.type == CssToken.Type.FUNCTION) {
                CssToken tk = new CssToken(next.type, next.location, sb.toString() + next.chars, next.errors.isPresent() ? next.errors.get() : null);
                CssConstruct func = Ascii.toLowerCase(next.getChars()).startsWith("not") ? CssSelectorConstructFactory.createNegationPseudo(tk, iter, err) : CssSelectorConstructFactory.createFunctionalPseudo(tk, iter, CssToken.Matchers.MATCH_OPENBRACE, err);
                if (func == null) {
                    err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_UNEXPECTED_TOKEN, iter.last.location, iter.last.chars, next.getChars()));
                    return null;
                }
                cps.function = (CssFunction)func;
            }
            return cps;
        }

        static CssConstruct createFunctionalPseudo(CssToken start, CssTokenList.CssTokenIterator iter, Predicate<CssToken> limit, CssErrorHandler err) {
            String name = start.getChars().substring(0, start.getChars().length() - 1);
            CssFunction function = new CssFunction(name, start.location);
            CssToken tk = iter.next();
            while (!CssToken.Matchers.MATCH_CLOSEPAREN.apply(tk)) {
                if (limit.apply(tk)) {
                    return null;
                }
                CssConstruct cc = CssConstructFactory.create(tk, iter, limit, CssParser.ContextRestrictions.PSEUDO_FUNCTIONAL);
                if (cc == null) {
                    return null;
                }
                function.components.add(cc);
                tk = iter.next();
            }
            return function;
        }

        static CssConstruct createNegationPseudo(CssToken start, CssTokenList.CssTokenIterator iter, CssErrorHandler err) throws CssExceptions.CssException {
            String name = start.getChars().substring(0, start.getChars().length() - 1);
            CssFunction negation = new CssFunction(name, start.location);
            CssToken tk = iter.next();
            CssConstruct cc = CssSelectorConstructFactory.createSimpleSelector(tk, iter, err);
            if (cc == null || !CssParser.ContextRestrictions.PSEUDO_NEGATION.apply(cc)) {
                return null;
            }
            negation.components.add(cc);
            iter.next();
            return negation;
        }

        static CssAttributeSelector createAttributeSelector(CssToken start, CssTokenList.CssTokenIterator iter, CssErrorHandler err) throws CssExceptions.CssException {
            CssAttributeSelector cas = new CssAttributeSelector(start.location);
            CssTypeSelector cts = CssSelectorConstructFactory.createTypeSelector(start, iter, err);
            if (cts == null) {
                return null;
            }
            cas.components.add(cts);
            CssToken next = iter.next();
            if (!CssToken.Matchers.MATCH_CLOSESQUAREBRACKET.apply(next)) {
                if (CssToken.Matchers.MATCH_ATTRIBUTE_SELECTOR_MATCHERS.apply(next)) {
                    CssAttributeMatchSelector casm = CssSelectorConstructFactory.createAttributeMatchSelector(next, iter, err);
                    cas.components.add(casm);
                    next = iter.next();
                    CssConstruct val = CssConstructFactory.create(next, iter, CssToken.Matchers.MATCH_CLOSESQUAREBRACKET, CssParser.ContextRestrictions.ATTRIBUTE_SELECTOR_VALUE);
                    if (val == null) {
                        err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_EXPECTING_TOKEN, next.location, next.chars, Messages.get("a_string_or_dentifier")));
                        return null;
                    }
                    cas.components.add(val);
                    iter.next();
                } else {
                    err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_EXPECTING_TOKEN, next.location, next.chars, Messages.get("an_attribute_value_matcher")));
                    return null;
                }
            }
            return cas;
        }

        static CssAttributeMatchSelector createAttributeMatchSelector(CssToken tk, CssTokenList.CssTokenIterator iter, CssErrorHandler err) {
            CssAttributeMatchSelector.Type type;
            switch (tk.type) {
                case INCLUDES: {
                    type = CssAttributeMatchSelector.Type.INCLUDES;
                    break;
                }
                case DASHMATCH: {
                    type = CssAttributeMatchSelector.Type.DASHMATCH;
                    break;
                }
                case PREFIXMATCH: {
                    type = CssAttributeMatchSelector.Type.PREFIXMATCH;
                    break;
                }
                case SUFFIXMATCH: {
                    type = CssAttributeMatchSelector.Type.SUFFIXMATCH;
                    break;
                }
                case SUBSTRINGMATCH: {
                    type = CssAttributeMatchSelector.Type.SUBSTRINGMATCH;
                    break;
                }
                default: {
                    type = CssAttributeMatchSelector.Type.EQUALS;
                }
            }
            return new CssAttributeMatchSelector(tk.getChars(), type, tk.location);
        }

        private static CssTypeSelector createTypeSelector(CssToken start, CssTokenList.CssTokenIterator iter, CssErrorHandler err) throws CssExceptions.CssException {
            if (start.type != CssToken.Type.IDENT && !CssToken.Matchers.MATCH_STAR_PIPE.apply(start)) {
                err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_EXPECTING_TOKEN, start.location, start.getChars(), Messages.get("a_type_or_universal_selector")));
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(start.getChars());
            if (CssToken.Matchers.MATCH_PIPE.apply(start)) {
                CssToken next = iter.peek(CssTokenList.Filters.FILTER_NONE);
                if (next.type != CssToken.Type.IDENT) {
                    err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_EXPECTING_TOKEN, next.location, next.getChars(), Messages.get("a_type_or_universal_selector")));
                    return null;
                }
                sb.append(iter.next().getChars());
            } else if (CssToken.Matchers.MATCH_PIPE.apply(iter.peek(CssTokenList.Filters.FILTER_NONE))) {
                sb.append(iter.next().getChars());
                CssToken next = iter.next(CssTokenList.Filters.FILTER_NONE);
                if (next.type != CssToken.Type.IDENT && !CssToken.Matchers.MATCH_STAR.apply(next)) {
                    err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_EXPECTING_TOKEN, start.location, next.getChars(), Messages.get("a_type_or_universal_selector")));
                    return null;
                }
                sb.append(next.getChars());
            } else if (iter.peek(CssTokenList.Filters.FILTER_NONE).type == CssToken.Type.IDENT) {
                sb.append(iter.next().getChars());
            }
            return new CssTypeSelector(sb.toString(), start.location);
        }
    }

    public static final class CssSimpleSelectorSequence
    extends CssComposedConstruct {
        public CssSimpleSelectorSequence(CssLocation location) {
            super(CssConstruct.Type.SIMPLE_SELECTOR_SEQ, location);
        }

        @Override
        public String toCssString() {
            StringBuilder sb = new StringBuilder();
            for (CssConstruct cc : this.components) {
                sb.append(cc.toCssString());
            }
            return sb.toString();
        }
    }

    public static final class CssSelector
    extends CssComposedConstruct {
        public CssSelector(CssLocation location) {
            super(CssConstruct.Type.SELECTOR, location);
        }

        @Override
        public final List<CssConstruct> getComponents() {
            return super.getComponents();
        }

        @Override
        public String toCssString() {
            StringBuilder sb = new StringBuilder();
            for (CssConstruct cc : this.components) {
                sb.append(cc.toCssString());
            }
            return sb.toString();
        }
    }

    public static final class CssPseudoSelector
    extends CssComposedConstruct {
        final Type subType;
        CssFunction function = null;
        String name = null;

        public CssPseudoSelector(Type type, CssLocation location) {
            super(CssConstruct.Type.PSEUDO, location);
            this.subType = type;
        }

        @Override
        public final Optional<String> getName() {
            if (this.function != null) {
                return this.function.getName();
            }
            return Optional.of(this.name);
        }

        @Override
        public String toString() {
            return Objects.toStringHelper(this).addValue(this.getSubType().name()).addValue(this.getName().get()).addValue(this.function != null ? Joiner.on(" ").join(this.function.components) : "").toString();
        }

        public final CssFunction getFunction() {
            return this.function;
        }

        public final Type getSubType() {
            return this.subType;
        }

        @Override
        public String toCssString() {
            if (this.function != null) {
                return this.function.toCssString();
            }
            return this.name;
        }

        public static enum Type {
            PSEUDO_ELEMENT,
            PSEUDO_CLASS;

        }
    }

    public static final class CssScopedGroup
    extends CssComposedConstruct {
        final Type subType;

        public CssScopedGroup(Type type, CssLocation location) {
            super(CssConstruct.Type.SCOPEDGROUP, location);
            this.subType = type;
        }

        @Override
        public String toString() {
            return Objects.toStringHelper(this).addValue((Object)this.type).addValue((Object)this.subType).addValue(Joiner.on(" ").join(this.components)).toString();
        }

        public final Type getGroupType() {
            return this.subType;
        }

        @Override
        public String toCssString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.subType == Type.PAREN ? (char)'(' : '[');
            for (CssConstruct cc : this.components) {
                sb.append(cc.toCssString()).append(' ');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(this.subType == Type.PAREN ? (char)')' : ']');
            return sb.toString();
        }

        public static enum Type {
            PAREN,
            BRACKET;

        }
    }

    public static final class CssDeclaration
    extends CssComposedConstruct {
        boolean important = false;

        public CssDeclaration(String name, CssLocation location) {
            super(CssConstruct.Type.DECLARATION, Ascii.toLowerCase(name).intern(), location);
        }

        public final boolean getImportant() {
            return this.important;
        }

        @Override
        public String toCssString() {
            StringBuilder sb = new StringBuilder().append((String)this.name.get()).append(" : ");
            for (CssConstruct cc : this.components) {
                sb.append(cc.toCssString()).append(' ');
            }
            if (this.getImportant()) {
                sb.append("!important ");
            }
            return sb.deleteCharAt(sb.length() - 1).append(" ;").toString();
        }
    }

    public static final class CssAtRule
    extends CssComposedConstruct {
        boolean hasBlock;

        public CssAtRule(String name, CssLocation location) {
            super(CssConstruct.Type.ATRULE, Preconditions.checkNotNull(Ascii.toLowerCase(name).intern()), location);
        }

        public final boolean hasBlock() {
            return this.hasBlock;
        }

        @Override
        public String toCssString() {
            StringBuilder sb = new StringBuilder().append((String)this.name.get()).append(' ');
            for (CssConstruct cc : this.components) {
                sb.append(cc.toCssString()).append(' ');
            }
            return sb.deleteCharAt(sb.length() - 1).toString();
        }
    }

    public static final class CssFunction
    extends CssComposedConstruct {
        public CssFunction(String name, CssLocation location) {
            super(CssConstruct.Type.FUNCTION, Ascii.toLowerCase(Preconditions.checkNotNull(name)).intern(), location);
        }

        @Override
        public String toCssString() {
            StringBuilder sb = new StringBuilder().append((String)this.name.get()).append('(');
            for (CssConstruct cc : this.components) {
                sb.append(cc.toCssString());
            }
            return sb.append(')').toString();
        }
    }

    public static final class CssAttributeSelector
    extends CssComposedConstruct {
        public CssAttributeSelector(CssLocation location) {
            super(CssConstruct.Type.ATTRIBUTE_SELECTOR, location);
        }

        @Override
        public String toCssString() {
            StringBuilder sb = new StringBuilder().append('[');
            for (CssConstruct cc : this.components) {
                sb.append(cc.toCssString());
            }
            return sb.append(']').toString();
        }
    }

    static abstract class CssComposedConstruct
    extends CssConstruct {
        final List<CssConstruct> components;
        final Optional<String> name;
        final Optional<String> absent = Optional.absent();

        public CssComposedConstruct(CssConstruct.Type type, String name, CssLocation location) {
            super(type, location);
            this.components = Lists.newArrayList();
            this.name = name != null ? Optional.of(name) : this.absent;
        }

        public CssComposedConstruct(CssConstruct.Type type, CssLocation location) {
            this(type, null, location);
        }

        public List<CssConstruct> getComponents() {
            return this.components;
        }

        public Optional<String> getName() {
            return this.name;
        }

        public String toString() {
            return Objects.toStringHelper(this).addValue((Object)this.type).addValue(this.name.isPresent() ? this.name.get() : "").addValue(this.components.isEmpty() ? "" : Joiner.on(" ").join(this.components)).toString();
        }
    }

    public static final class CssQuantity
    extends CssAtomicConstruct {
        final Unit subType;

        public CssQuantity(String value, Unit subtype, CssLocation location) {
            super(CssConstruct.Type.QUANTITY, value, location);
            this.subType = Preconditions.checkNotNull(subtype);
        }

        public final Unit getUnit() {
            return this.subType;
        }

        @Override
        public String toString() {
            return Objects.toStringHelper(this).addValue(this.subType.name()).addValue(this.value).toString();
        }

        public static enum Unit {
            DIMEN,
            PERCENTAGE,
            LENGTH,
            EMS,
            EXS,
            ANGLE,
            TIME,
            FREQ,
            RESOLUTION,
            NUMBER,
            INTEGER,
            REMS;

        }
    }

    public static class CssTypeSelector
    extends CssAtomicConstruct {
        public CssTypeSelector(String value, CssLocation location) {
            super(CssConstruct.Type.TYPE_SELECTOR, value, location);
        }
    }

    public static final class CssAttributeMatchSelector
    extends CssAtomicConstruct {
        final Type subType;

        public CssAttributeMatchSelector(String value, Type type, CssLocation location) {
            super(CssConstruct.Type.ATTRIBUTE_MATCH, value, location);
            this.subType = type;
        }

        public final Type getAttributeMatchType() {
            return this.subType;
        }

        @Override
        public String toString() {
            return Objects.toStringHelper(this).addValue(this.subType.name()).addValue(this.value).toString();
        }

        public static enum Type {
            EQUALS,
            INCLUDES,
            DASHMATCH,
            PREFIXMATCH,
            SUFFIXMATCH,
            SUBSTRINGMATCH;

        }
    }

    public static final class CssSelectorCombinator
    extends CssAtomicConstruct {
        final Type subType;

        public CssSelectorCombinator(char value, CssLocation location) {
            super(CssConstruct.Type.COMBINATOR, String.valueOf(value).intern(), location);
            switch (value) {
                case ' ': {
                    this.subType = Type.DESCENDANT;
                    break;
                }
                case '>': {
                    this.subType = Type.CHILD;
                    break;
                }
                case '+': {
                    this.subType = Type.ADJACENT_SIBLING;
                    break;
                }
                case '~': {
                    this.subType = Type.GENERAL_SIBLING;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        public final Type getCombinatorType() {
            return this.subType;
        }

        public static enum Type {
            DESCENDANT,
            CHILD,
            ADJACENT_SIBLING,
            GENERAL_SIBLING;

        }
    }

    public static final class CssSymbol
    extends CssAtomicConstruct {
        public CssSymbol(String value, CssLocation location) {
            super(CssConstruct.Type.SYMBOL, value.intern(), location);
            Preconditions.checkArgument(value.length() == 1);
        }
    }

    public static final class CssURI
    extends CssAtomicConstruct {
        public CssURI(String value, CssLocation location) {
            super(CssConstruct.Type.URI, value, location);
        }

        public String toUriString() {
            int index;
            char ch;
            StringBuilder builder = new StringBuilder();
            boolean inStart = false;
            for (int i = 0; i < this.value.length(); ++i) {
                if (i <= 3 || i >= this.value.length() - 1) continue;
                ch = this.value.charAt(i);
                if (CssScanner.QUOTES.matches(ch) || CssScanner.WHITESPACE.matches(ch)) {
                    if (!inStart) continue;
                    builder.append(ch);
                    continue;
                }
                inStart = true;
                builder.append(ch);
            }
            while (builder.length() != 0 && (CssScanner.QUOTES.matches(ch = builder.charAt(index = builder.length() - 1)) || CssScanner.WHITESPACE.matches(ch))) {
                builder.deleteCharAt(index);
            }
            return builder.toString();
        }
    }

    public static final class CssUnicodeRange
    extends CssAtomicConstruct {
        public CssUnicodeRange(String value, CssLocation location) {
            super(CssConstruct.Type.URANGE, value, location);
        }
    }

    public static final class CssClassName
    extends CssAtomicConstruct {
        public CssClassName(String value, CssLocation location) {
            super(CssConstruct.Type.CLASSNAME, value, location);
        }
    }

    public static final class CssHashName
    extends CssAtomicConstruct {
        public CssHashName(String value, CssLocation location) {
            super(CssConstruct.Type.HASHNAME, value, location);
        }
    }

    public static final class CssKeyword
    extends CssAtomicConstruct {
        public CssKeyword(String value, CssLocation location) {
            super(CssConstruct.Type.KEYWORD, value, location);
        }
    }

    public static final class CssString
    extends CssAtomicConstruct {
        public CssString(String value, CssLocation location) {
            super(CssConstruct.Type.STRING, value, location);
        }

        @Override
        public final String toCssString() {
            return "'" + this.value + "'";
        }
    }

    static abstract class CssAtomicConstruct
    extends CssConstruct {
        final String value;

        public CssAtomicConstruct(CssConstruct.Type type, String value, CssLocation location) {
            super(type, location);
            this.value = Preconditions.checkNotNull(value);
        }

        public String toString() {
            return Objects.toStringHelper(this).addValue(this.value).toString();
        }

        @Override
        public String toCssString() {
            return this.value;
        }
    }

    public static abstract class CssConstruct {
        final CssLocation location;
        final Type type;

        public CssConstruct(Type type, CssLocation location) {
            this.location = Preconditions.checkNotNull(location);
            this.type = Preconditions.checkNotNull(type);
        }

        public final CssLocation getLocation() {
            return this.location;
        }

        public final Type getType() {
            return this.type;
        }

        public abstract String toCssString();

        public static enum Type {
            STRING,
            KEYWORD,
            COMBINATOR,
            ATTRIBUTE_MATCH,
            HASHNAME,
            CLASSNAME,
            QUANTITY,
            URANGE,
            URI,
            SYMBOL,
            TYPE_SELECTOR,
            PSEUDO,
            ATRULE,
            FUNCTION,
            DECLARATION,
            SELECTOR,
            SIMPLE_SELECTOR_SEQ,
            ATTRIBUTE_SELECTOR,
            SCOPEDGROUP;

        }
    }
}

