/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.tree.util.FastStringBuffer;

public class AlphanumericCollator
implements StringCollator,
Serializable {
    private StringCollator baseCollator;
    private static Pattern pattern = Pattern.compile("\\d+");

    public AlphanumericCollator(StringCollator base) {
        this.baseCollator = base;
    }

    public int compareStrings(String s1, String s2) {
        int pos1 = 0;
        int pos2 = 0;
        Matcher m1 = pattern.matcher(s1);
        Matcher m2 = pattern.matcher(s2);
        while (true) {
            BigInteger n2;
            boolean b1 = m1.find(pos1);
            boolean b2 = m2.find(pos2);
            int m1start = b1 ? m1.start() : s1.length();
            int m2start = b2 ? m2.start() : s2.length();
            int c = this.baseCollator.compareStrings(s1.substring(pos1, m1start), s2.substring(pos2, m2start));
            if (c != 0) {
                return c;
            }
            if (b1 && !b2) {
                return 1;
            }
            if (b2 && !b1) {
                return -1;
            }
            if (!b1 && !b2) {
                return 0;
            }
            BigInteger n1 = new BigInteger(s1.substring(m1start, m1.end()));
            c = n1.compareTo(n2 = new BigInteger(s2.substring(m2start, m2.end())));
            if (c != 0) {
                return c;
            }
            pos1 = m1.end();
            pos2 = m2.end();
        }
    }

    public boolean comparesEqual(String s1, String s2) {
        return this.compareStrings(s1, s2) == 0;
    }

    public Object getCollationKey(String s) {
        FastStringBuffer sb = new FastStringBuffer(s.length() * 2);
        int pos1 = 0;
        Matcher m1 = pattern.matcher(s);
        while (true) {
            boolean b1;
            int m1start = (b1 = m1.find(pos1)) ? m1.start() : s.length();
            sb.append(s.substring(pos1, m1start));
            if (!b1) {
                return sb.toString();
            }
            int n1 = Integer.parseInt(s.substring(m1start, m1.end()));
            sb.append(n1 + "");
            pos1 = m1.end();
        }
    }
}

